/*
 * Decompiled with CFR 0.152.
 */
package com.heirloomcomputing.ecs.jfc;

import com.heirloomcomputing.ecs.jfc.LButtonDirect;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.util.StringTokenizer;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicButtonUI;
import javax.swing.plaf.basic.BasicGraphicsUtils;

class LButtonUI
extends BasicButtonUI {
    private static final LButtonUI buttonUI = new LButtonUI();
    Color focusColor = null;
    private static Rectangle viewRect = new Rectangle();
    private static Rectangle textRect = new Rectangle();
    private static Rectangle iconRect = new Rectangle();

    LButtonUI() {
    }

    public static ComponentUI createUI(JComponent c) {
        return buttonUI;
    }

    @Override
    public void installDefaults(AbstractButton b) {
        super.installDefaults(b);
        this.focusColor = UIManager.getColor(this.getPropertyPrefix() + "focus");
    }

    public static String[] layoutCompoundLabel(LButtonDirect c, FontMetrics fm, String text, Icon icon, int verticalAlignment, int horizontalAlignment, int verticalTextPosition, int horizontalTextPosition, Rectangle viewR, Rectangle iconR, Rectangle textR, int textIconGap) {
        int hAlign = horizontalAlignment;
        int hTextPos = horizontalTextPosition;
        switch (horizontalAlignment) {
            case 10: {
                hAlign = 2;
                break;
            }
            case 11: {
                hAlign = 4;
            }
        }
        switch (horizontalTextPosition) {
            case 10: {
                hTextPos = 2;
                break;
            }
            case 11: {
                hTextPos = 4;
            }
        }
        return LButtonUI.layoutCompoundLabel(fm, text, icon, verticalAlignment, hAlign, verticalTextPosition, hTextPos, viewR, iconR, textR, textIconGap);
    }

    public static String[] layoutCompoundLabel(FontMetrics fm, String text, Icon icon, int verticalAlignment, int horizontalAlignment, int verticalTextPosition, int horizontalTextPosition, Rectangle viewR, Rectangle iconR, Rectangle textR, int textIconGap) {
        int gap;
        if (icon != null) {
            iconR.width = icon.getIconWidth();
            iconR.height = icon.getIconHeight();
        } else {
            iconR.height = 0;
            iconR.width = 0;
        }
        boolean textIsEmpty = text == null || (text = text.trim()).length() == 0;
        String[] textArray = null;
        int count = 0;
        int max = -1;
        int maxIndex = -1;
        if (textIsEmpty) {
            textR.height = 0;
            textR.width = 0;
            text = "";
        } else {
            StringTokenizer st = new StringTokenizer(text, "\n");
            int numTokens = st.countTokens();
            textArray = new String[numTokens];
            while (st.hasMoreTokens()) {
                String curText;
                textArray[count] = curText = st.nextToken();
                int len = curText.length();
                if (len > max) {
                    max = len;
                    maxIndex = count;
                }
                ++count;
            }
            textR.width = max > 0 ? SwingUtilities.computeStringWidth(fm, textArray[maxIndex]) : SwingUtilities.computeStringWidth(fm, text);
            textR.height = fm.getHeight() * count;
        }
        int n = gap = textIsEmpty || icon == null ? 0 : textIconGap;
        textR.y = verticalTextPosition == 1 ? (horizontalTextPosition != 0 ? 0 : -(textR.height + gap)) : (verticalTextPosition == 0 ? iconR.height / 2 - textR.height / 2 : (horizontalTextPosition != 0 ? iconR.height - textR.height : iconR.height + gap));
        textR.x = horizontalTextPosition == 2 ? -(textR.width + gap) : (horizontalTextPosition == 0 ? iconR.width / 2 - textR.width / 2 : iconR.width + gap);
        int labelR_x = Math.min(iconR.x, textR.x);
        int labelR_width = Math.max(iconR.x + iconR.width, textR.x + textR.width) - labelR_x;
        int labelR_y = Math.min(iconR.y, textR.y);
        int labelR_height = Math.max(iconR.y + iconR.height, textR.y + textR.height) - labelR_y;
        int dy = verticalAlignment == 1 ? viewR.y - labelR_y : (verticalAlignment == 0 ? viewR.y + viewR.height / 2 - (labelR_y + labelR_height / 2) : viewR.y + viewR.height - (labelR_y + labelR_height));
        int dx = horizontalAlignment == 2 ? viewR.x - labelR_x : (horizontalAlignment == 4 ? viewR.x + viewR.width - (labelR_x + labelR_width) : viewR.x + viewR.width / 2 - (labelR_x + labelR_width / 2));
        textR.x += dx;
        textR.y += dy;
        iconR.x += dx;
        iconR.y += dy;
        return textArray;
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        LButtonDirect b = (LButtonDirect)c;
        ButtonModel model = b.getModel();
        FontMetrics fm = g.getFontMetrics();
        Insets i = b.getInsets();
        LButtonUI.viewRect.x = i.left;
        LButtonUI.viewRect.y = i.top;
        LButtonUI.viewRect.width = b.getWidth() - (i.right + LButtonUI.viewRect.x);
        LButtonUI.viewRect.height = b.getHeight() - (i.bottom + LButtonUI.viewRect.y);
        LButtonUI.textRect.height = 0;
        LButtonUI.textRect.width = 0;
        LButtonUI.textRect.y = 0;
        LButtonUI.textRect.x = 0;
        LButtonUI.iconRect.height = 0;
        LButtonUI.iconRect.width = 0;
        LButtonUI.iconRect.y = 0;
        LButtonUI.iconRect.x = 0;
        Font f = b.getFont();
        g.setFont(f);
        String text = b.getText();
        String[] textArray = LButtonUI.layoutCompoundLabel(b, fm, text, b.getIcon(), b.getVerticalAlignment(), b.getHorizontalAlignment(), b.getVerticalTextPosition(), b.getHorizontalTextPosition(), viewRect, iconRect, textRect, text == null ? 0 : this.defaultTextIconGap);
        this.clearTextShiftOffset();
        if (model.isArmed() && model.isPressed()) {
            this.paintButtonPressed(g, b);
        }
        if (b.getIcon() != null) {
            this.paintIcon(g, b, iconRect);
        }
        if (textArray != null) {
            this.paintText(g, b, textRect, textArray);
        }
        if (b.isFocusPainted() && b.hasFocus()) {
            Rectangle r = new Rectangle(textRect);
            Rectangle bounds = b.getBounds();
            r.y = i.top;
            r.x = i.left;
            r.width = bounds.width - (i.left + i.right);
            r.height = bounds.height - (i.top + i.bottom);
            this.paintFocus(g, b, viewRect, r, iconRect);
        }
    }

    protected void paintText(Graphics g, JButton b, Rectangle textRect, String[] textArray) {
        if (textArray == null) {
            return;
        }
        ButtonModel model = b.getModel();
        FontMetrics fm = g.getFontMetrics();
        int horizontalAlignment = b.getHorizontalAlignment();
        int ascent = fm.getAscent();
        int adjustText = -1;
        if (model.isEnabled()) {
            g.setColor(b.getForeground());
            int shiftOffset = this.getTextShiftOffset();
            for (int i = 0; i < textArray.length; ++i) {
                String text = textArray[i];
                int width = SwingUtilities.computeStringWidth(fm, text);
                int offset = 0;
                if (horizontalAlignment == 0) {
                    offset = (textRect.width - width) / 2;
                } else if (horizontalAlignment == 4) {
                    offset = textRect.width - width;
                }
                BasicGraphicsUtils.drawString(g, text, model.getMnemonic(), textRect.x + offset + shiftOffset, textRect.y + ascent * (i + 1) + shiftOffset + adjustText);
            }
        } else {
            int i;
            Color bg = b.getBackground();
            int[] offset = new int[textArray.length];
            g.setColor(bg.brighter());
            for (i = 0; i < textArray.length; ++i) {
                String text = textArray[i];
                int width = SwingUtilities.computeStringWidth(fm, text);
                offset[i] = 0;
                if (horizontalAlignment == 0) {
                    offset[i] = (textRect.width - width) / 2;
                } else if (horizontalAlignment == 4) {
                    offset[i] = textRect.width - width;
                }
                BasicGraphicsUtils.drawString(g, text, model.getMnemonic(), textRect.x + offset[i], textRect.y + ascent * (i + 1) + adjustText);
            }
            g.setColor(bg.darker());
            for (i = 0; i < textArray.length; ++i) {
                BasicGraphicsUtils.drawString(g, textArray[i], model.getMnemonic(), textRect.x + offset[i] - 1, textRect.y + ascent * (i + 1) - 1 + adjustText);
            }
        }
    }

    @Override
    protected void paintFocus(Graphics g, AbstractButton b, Rectangle viewRect, Rectangle textRect, Rectangle iconRect) {
        boolean isIcon;
        Rectangle focusRect = new Rectangle();
        String text = b.getText();
        boolean bl = isIcon = b.getIcon() != null;
        if (text != null && !text.equals("")) {
            if (!isIcon) {
                focusRect.setBounds(textRect);
            } else {
                focusRect.setBounds(iconRect.union(textRect));
            }
        } else if (isIcon) {
            focusRect.setBounds(iconRect);
        }
        g.setColor(this.focusColor);
        BasicGraphicsUtils.drawDashedRect(g, focusRect.x - 1, focusRect.y - 1, focusRect.width + 1, focusRect.height + 1);
    }
}

