/*
 * Decompiled with CFR 0.152.
 */
package com.heirloomcomputing.ecs.jfc;

import com.heirloomcomputing.ecs.exec.AcceptEvent;
import com.heirloomcomputing.ecs.exec.ResourceManager;
import com.heirloomcomputing.ecs.jfc.LComponent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.CellRendererPane;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.ListSelectionModel;
import javax.swing.border.Border;
import javax.swing.border.EtchedBorder;
import javax.swing.plaf.basic.BasicArrowButton;
import javax.swing.plaf.basic.BasicGraphicsUtils;

public final class LCalendar
extends LComponent
implements ActionListener,
Serializable {
    private static final long serialVersionUID = 1L;
    public String[] dayNames = new String[]{"S", "M", "T", "W", "T", "F", "S"};
    public static final String ACTION_ENTER = "Enter";
    public static final String ACTION_CLICK = "Click";
    public static final String ACTION_NEXT = "Next";
    public static final String ACTION_PREV = "Prev";
    public static final int[] daysInMonth = new int[]{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    public String[] monthNames = new String[]{"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};
    public Color cellBackground = Color.white;
    public Color cellForeground = Color.blue;
    public Color cellUnselected = Color.lightGray;
    protected Vector<ActionListener> listeners = new Vector();
    protected ListSelectionModel selector;
    protected CalendarRenderer headRenderer;
    protected CalendarRenderer cellRenderer;
    protected CalendarGroup group = new CalendarGroup();
    protected JButton westArrow;
    protected JButton eastArrow;
    protected JButton northArrow;
    protected JButton southArrow;
    private CalendarView view = null;

    public Color getCellBackground() {
        return this.cellBackground;
    }

    public int getCellBackgroundRGB() {
        Color c = this.cellBackground;
        if (c != null) {
            return c.getRGB();
        }
        return -1;
    }

    public Color getCellForeground() {
        return this.cellForeground;
    }

    public int getCellForegroundRGB() {
        Color c = this.cellForeground;
        if (c != null) {
            return c.getRGB();
        }
        return -1;
    }

    public Color getCellUnselected() {
        return this.cellUnselected;
    }

    public void setCellBackground(Color c) {
        this.cellBackground = c;
    }

    public void setCellBackgroundRGB(int rgb) {
        this.setCellBackground(new Color(rgb));
    }

    public void setCellBackground(int color2) {
        Color c = colorArray[this.adjustForeground(color2)];
        this.setCellBackground(c);
    }

    public void setCellForeground(Color c) {
        this.cellForeground = c;
    }

    public void setCellForegroundRGB(int rgb) {
        this.setCellForeground(new Color(rgb));
    }

    public void setCellForeground(int color2) {
        Color c = colorArray[this.adjustForeground(color2)];
        this.setCellForeground(c);
    }

    public void setCellUnselected(Color c) {
        this.cellUnselected = c;
    }

    public void setCellUnselected(int color2) {
        Color c = colorArray[this.adjustForeground(color2)];
        this.setCellUnselected(c);
    }

    public void setCellUnselectedRGB(int rgb) {
        this.setCellUnselected(new Color(rgb));
    }

    public int getDayOfMonth() {
        return this.getDate().get(5);
    }

    public void setDayOfMonth(int val) {
        Calendar date = this.getDate();
        date.set(5, val);
        this.setDate(date);
    }

    public int getDayOfWeek() {
        return this.getDate().get(7);
    }

    public void setDayOfWeek(int val) {
        Calendar date = this.getDate();
        date.set(7, val);
        this.setDate(date);
    }

    public int getDayOfWeekInMonth() {
        return this.getDate().get(8);
    }

    public void setDayOfWeekInMonth(int val) {
        Calendar date = this.getDate();
        date.set(8, val);
        this.setDate(date);
    }

    public int getDayOfYear() {
        return this.getDate().get(6);
    }

    public void setDayOfYear(int val) {
        Calendar date = this.getDate();
        date.set(6, val);
        this.setDate(date);
    }

    public int getDstOffset() {
        return this.getDate().get(16);
    }

    public void setDstOffset(int val) {
        Calendar date = this.getDate();
        date.set(16, val);
        this.setDate(date);
    }

    public int getEra() {
        return this.getDate().get(0);
    }

    public void setEra(int val) {
        Calendar date = this.getDate();
        date.set(0, val);
        this.setDate(date);
    }

    public int getMonth() {
        return this.getDate().get(2) + 1;
    }

    public void setMonth(int val) {
        Calendar date = this.getDate();
        date.set(2, val - 1);
        this.setDate(date);
    }

    public int getWeekOfMonth() {
        return this.getDate().get(4);
    }

    public void setWeekOfMonth(int val) {
        Calendar date = this.getDate();
        date.set(4, val);
        this.setDate(date);
    }

    public int getWeekOfYear() {
        return this.getDate().get(3);
    }

    public void setWeekOfYear(int val) {
        Calendar date = this.getDate();
        date.set(3, val);
        this.setDate(date);
    }

    public int getYear() {
        return this.getDate().get(1);
    }

    public void setYear(int val) {
        Calendar date = this.getDate();
        date.set(1, val);
        this.setDate(date);
    }

    public int getZoneOffset() {
        return this.getDate().get(15);
    }

    public void setZoneOffset(int val) {
        Calendar date = this.getDate();
        date.set(15, val);
        this.setDate(date);
    }

    public LCalendar() {
        this.init(Calendar.getInstance(), new DefaultListSelectionModel(), new DefaultCalendarRenderer(true), new DefaultCalendarRenderer(false), null);
    }

    public LCalendar(Calendar date) {
        this.init(date, new DefaultListSelectionModel(), new DefaultCalendarRenderer(true), new DefaultCalendarRenderer(false), null);
    }

    public LCalendar(Calendar date, ListSelectionModel selector, boolean headBool, boolean cellBool) {
        this.init(date, selector, new PopupCalendarRenderer(headBool), new PopupCalendarRenderer(cellBool), null);
    }

    public LCalendar(Calendar date, ListSelectionModel selector, CalendarRenderer headRenderer, CalendarRenderer cellRenderer) {
        this.init(date, selector, headRenderer, cellRenderer, null);
    }

    private void init(Calendar date, ListSelectionModel selector, CalendarRenderer headRenderer, CalendarRenderer cellRenderer, Locale locale) {
        try {
            this.lines = 14.0;
            this.size = 24.0;
            if (locale == null) {
                locale = Locale.getDefault();
            }
            ResourceBundle resource = null;
            try {
                resource = ResourceBundle.getBundle("java.text.resources.LocaleElements", locale);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (resource != null) {
                this.monthNames = resource.getStringArray("MonthAbbreviations");
            }
            if (this.monthNames == null) {
                this.monthNames = new String[]{ResourceManager.get("component.calendar.month.1", "Jan"), ResourceManager.get("component.calendar.month.2", "Feb"), ResourceManager.get("component.calendar.month.3", "Mar"), ResourceManager.get("component.calendar.month.4", "Apr"), ResourceManager.get("component.calendar.month.5", "May"), ResourceManager.get("component.calendar.month.6", "Jun"), ResourceManager.get("component.calendar.month.7", "Jul"), ResourceManager.get("component.calendar.month.8", "Aug"), ResourceManager.get("component.calendar.month.9", "Sep"), ResourceManager.get("component.calendar.month.10", "Oct"), ResourceManager.get("component.calendar.month.11", "Nov"), ResourceManager.get("component.calendar.month.12", "Dec")};
            }
            if (resource != null) {
                this.dayNames = resource.getStringArray("DayAbbreviations");
            }
            if (this.dayNames == null) {
                this.dayNames = new String[]{ResourceManager.get("component.calendar.day.1", "Su"), ResourceManager.get("component.calendar.day.2", "Mo"), ResourceManager.get("component.calendar.day.3", "Tu"), ResourceManager.get("component.calendar.day.4", "We"), ResourceManager.get("component.calendar.day.5", "Th"), ResourceManager.get("component.calendar.day.6", "Fr"), ResourceManager.get("component.calendar.day.7", "Sa")};
            }
            for (int i = 0; i < this.dayNames.length; ++i) {
                String dayName = this.dayNames[i];
                if (dayName == null) {
                    dayName = "?";
                }
                if (dayName.length() <= 2) continue;
                this.dayNames[i] = dayName.substring(0, 2);
            }
            this.selector = selector;
            this.headRenderer = headRenderer;
            this.cellRenderer = cellRenderer;
            this.group.setParent(this);
            this.setLayout(new GridLayout(1, 1, 3, 3));
            int startMonth = date.get(2);
            Calendar clone = (Calendar)date.clone();
            clone.set(2, startMonth);
            this.view = new CalendarView(clone, selector, headRenderer, cellRenderer, this.group);
            this.view.month.addActionListener(this);
            this.view.month.setActive(false);
            this.add(this.view);
            this.westArrow = this.view.getWestArrow();
            this.westArrow.addActionListener(this);
            this.eastArrow = this.view.getEastArrow();
            this.eastArrow.addActionListener(this);
            this.northArrow = this.view.getNorthArrow();
            this.northArrow.addActionListener(this);
            this.southArrow = this.view.getSouthArrow();
            this.southArrow.addActionListener(this);
            this.group.setActiveMonth(0);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Calendar getDate() {
        return this.group.getActiveMonth().getDate();
    }

    public void setDate(Calendar date) {
        this.group.getActiveMonth().setDate(date);
        this.fireActionEvent(ACTION_CLICK);
        this.view.setTitle();
    }

    public void setSelectionModel(ListSelectionModel selector) {
        this.selector = selector;
    }

    public ListSelectionModel getSelectionModel() {
        return this.selector;
    }

    public void setHeadRenderer(CalendarRenderer renderer) {
        this.headRenderer = renderer;
    }

    public CalendarRenderer getHeadRenderer() {
        return this.headRenderer;
    }

    public void setCellRenderer(CalendarRenderer renderer) {
        this.cellRenderer = renderer;
    }

    public CalendarRenderer getCellRenderer() {
        return this.cellRenderer;
    }

    public void setGroup(CalendarGroup group) {
        this.group = group;
    }

    public CalendarGroup getGroup() {
        return this.group;
    }

    public void nextMonth(boolean repaint) {
        this.getGroup().nextMonth(repaint);
    }

    public void prevMonth(boolean repaint) {
        this.getGroup().prevMonth(repaint);
    }

    public void nextYear(boolean repaint) {
        this.getGroup().nextYear(repaint);
    }

    public void prevYear(boolean repaint) {
        this.getGroup().prevYear(repaint);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        String command;
        Object source = event.getSource();
        if (source instanceof CalendarMonth && ((command = event.getActionCommand()).equals(ACTION_ENTER) || command.equals(ACTION_CLICK))) {
            this.fireActionEvent(command);
        }
    }

    public void addActionListener(ActionListener listener) {
        this.listeners.addElement(listener);
    }

    public void removeActionListener(ActionListener listener) {
        this.listeners.removeElement(listener);
    }

    public void fireActionEvent(String command) {
        Vector list = (Vector)this.listeners.clone();
        ActionEvent event = new ActionEvent(this, 1001, command);
        for (int i = 0; i < list.size(); ++i) {
            ActionListener listener = (ActionListener)list.elementAt(i);
            listener.actionPerformed(event);
        }
    }

    public void addConstantListeners() {
    }

    public void removeConstantListeners() {
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.addConstantListeners();
    }

    @Override
    public void removeNotify() {
        this.removeConstantListeners();
        super.removeNotify();
    }

    class DefaultCalendarRenderer
    extends JLabel
    implements CalendarRenderer {
        private boolean isHeader = false;
        private final Border raised = new EtchedBorder(0);
        private final Border lowered = new EtchedBorder(1);

        public DefaultCalendarRenderer(boolean isHeader) {
            this.setOpaque(true);
            this.setBorder(this.raised);
            this.setVerticalAlignment(1);
            this.setHorizontalAlignment(isHeader ? 0 : 2);
            Dimension size = new Dimension(22, 18);
            this.setPreferredSize(size);
            this.setMinimumSize(size);
            this.isHeader = isHeader;
        }

        @Override
        public Color getBackdrop() {
            return LCalendar.this.getCellUnselected();
        }

        @Override
        public Component getCalendarRendererComponent(JComponent parent, Object value, boolean isSelected, boolean hasFocus) {
            this.setText(value.toString());
            if (isSelected) {
                this.setBorder(this.lowered);
                this.setBackground(LCalendar.this.getCellForeground());
                this.setForeground(LCalendar.this.getCellBackground());
            } else {
                this.setBorder(this.raised);
                this.setBackground(this.isHeader ? Color.gray : LCalendar.this.getCellUnselected());
                this.setForeground(Color.black);
            }
            return this;
        }
    }

    class PopupCalendarRenderer
    extends JLabel
    implements CalendarRenderer {
        private boolean hasFocus = false;
        private boolean isSelected = false;
        private boolean isHeader = false;

        public PopupCalendarRenderer(boolean isHeader) {
            this.setOpaque(true);
            this.setBorder(null);
            this.setVerticalAlignment(1);
            this.setHorizontalAlignment(0);
            Dimension size = new Dimension(22, 18);
            this.setPreferredSize(size);
            this.setMinimumSize(size);
            this.isHeader = isHeader;
        }

        @Override
        public Color getBackdrop() {
            return LCalendar.this.getCellUnselected();
        }

        @Override
        public Component getCalendarRendererComponent(JComponent parent, Object value, boolean isSelected, boolean hasFocus) {
            this.hasFocus = hasFocus;
            this.isSelected = isSelected;
            this.setText(value.toString());
            this.setBackground(isSelected ? LCalendar.this.getCellForeground() : LCalendar.this.getCellUnselected());
            this.setForeground(isSelected ? LCalendar.this.getCellBackground() : LCalendar.this.getCellForeground());
            return this;
        }

        @Override
        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            int w = this.getSize().width;
            int h = this.getSize().height;
            if (!this.isHeader && this.hasFocus & this.isSelected) {
                g.setColor(LCalendar.this.getCellBackground());
                BasicGraphicsUtils.drawDashedRect(g, 0, 0, w, h);
            }
            if (this.isHeader) {
                g.drawLine(0, h - 1, w, h - 1);
            }
        }
    }

    class CalendarView
    extends JPanel
    implements ActionListener {
        private BasicArrowButton westArrow;
        private BasicArrowButton eastArrow;
        private BasicArrowButton northArrow;
        private BasicArrowButton southArrow;
        private JLabel title;
        private CalendarMonth month;
        private CalendarGroup group;

        public CalendarView(Calendar date, ListSelectionModel selector, CalendarRenderer headRenderer, CalendarRenderer cellRenderer, CalendarGroup group) {
            this.group = group;
            this.setLayout(new BorderLayout());
            this.setBorder(new EtchedBorder(1));
            JPanel nav = new JPanel();
            nav.setLayout(new BorderLayout());
            this.title = new JLabel(this.formatLabel(date));
            nav.add("Center", this.title);
            this.title.setHorizontalAlignment(0);
            this.title.setBorder(new EtchedBorder(0));
            JPanel p = new JPanel();
            p.setLayout(new BorderLayout());
            this.westArrow = new BasicArrowButton(7);
            p.add("West", this.westArrow);
            this.eastArrow = new BasicArrowButton(3);
            p.add("East", this.eastArrow);
            this.westArrow.setToolTipText(ResourceManager.get("component.calendar.month.previous", "Previous Month "));
            this.eastArrow.setToolTipText(ResourceManager.get("component.calendar.month.next", "Next Month "));
            nav.add("West", p);
            p = new JPanel();
            p.setLayout(new BorderLayout());
            this.southArrow = new BasicArrowButton(5);
            p.add("West", this.southArrow);
            this.northArrow = new BasicArrowButton(1);
            p.add("East", this.northArrow);
            this.southArrow.setToolTipText(ResourceManager.get("component.calendar.year.previous", "Previous Year "));
            this.northArrow.setToolTipText(ResourceManager.get("component.calendar.year.next", "Next Year"));
            nav.add("East", p);
            this.northArrow.addActionListener(this);
            this.southArrow.addActionListener(this);
            this.eastArrow.addActionListener(this);
            this.westArrow.addActionListener(this);
            JPanel header = new JPanel();
            header.setLayout(new BorderLayout());
            header.add("North", nav);
            header.add("South", new CalendarHeader(headRenderer));
            this.add("North", header);
            this.month = new CalendarMonth(date, selector, cellRenderer, group);
            this.add("Center", this.month);
            this.month.addActionListener(this);
        }

        private String formatLabel(Calendar calendar) {
            String year = "" + calendar.get(1);
            int month = calendar.get(2);
            if (month >= 0 && month < LCalendar.this.monthNames.length) {
                return LCalendar.this.monthNames[month] + " " + year;
            }
            return month + 1 + "/" + year;
        }

        public BasicArrowButton getWestArrow() {
            return this.westArrow;
        }

        public BasicArrowButton getEastArrow() {
            return this.eastArrow;
        }

        public BasicArrowButton getNorthArrow() {
            return this.northArrow;
        }

        public BasicArrowButton getSouthArrow() {
            return this.southArrow;
        }

        public void nextMonth() {
            this.group.nextMonth(false);
            Calendar date = this.month.getDate();
            this.title.setText(this.formatLabel(date));
            this.repaint();
        }

        public void prevMonth() {
            this.group.prevMonth(false);
            Calendar date = this.month.getDate();
            this.title.setText(this.formatLabel(date));
            this.repaint();
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            Object source = event.getSource();
            if (source == this.month) {
                Calendar date = this.month.getDate();
                this.title.setText(this.formatLabel(date));
                this.title.repaint();
                String command = event.getActionCommand();
                if (command.equals(LCalendar.ACTION_ENTER) || command.equals(LCalendar.ACTION_CLICK)) {
                    if (LCalendar.this.exceptionValue != 0) {
                        LCalendar.this.processAcceptKey(new AcceptEvent(LCalendar.this.getHandle(), 2, LCalendar.this.exceptionValue, event, LCalendar.this.getDayOfMonth(), LCalendar.this.getMonth()));
                    } else if (LCalendar.this.terminationValue != 0) {
                        LCalendar.this.processAcceptKey(new AcceptEvent(LCalendar.this.getHandle(), 1, LCalendar.this.terminationValue, event, LCalendar.this.getDayOfMonth(), LCalendar.this.getMonth()));
                    } else {
                        LCalendar.this.processAcceptEvent(new AcceptEvent(LCalendar.this.getHandle(), 0, 4, event, LCalendar.this.getDayOfMonth(), LCalendar.this.getMonth()));
                    }
                }
            } else if (source == this.westArrow) {
                this.group.prevMonth(true);
            } else if (source == this.eastArrow) {
                this.group.nextMonth(true);
            } else if (source == this.northArrow) {
                this.group.nextYear(true);
            } else if (source == this.southArrow) {
                this.group.prevYear(true);
            }
        }

        public void setTitle() {
            this.title.setText(this.formatLabel(this.month.getDate()));
        }
    }

    class CalendarMonth
    extends JPanel
    implements MouseListener,
    MouseMotionListener,
    KeyListener,
    FocusListener {
        private Vector<ActionListener> listeners = new Vector();
        private boolean hasFocus = false;
        private CellRendererPane renderPane = new CellRendererPane();
        private CalendarRenderer renderer;
        private ListSelectionModel selector;
        private CalendarGroup group;
        private Calendar date = Calendar.getInstance();
        private double xunit = 0.0;
        private double yunit = 0.0;
        private int first;
        private int days;
        private boolean active = true;

        public CalendarMonth(Calendar date, ListSelectionModel selector, CalendarRenderer renderer, CalendarGroup group) {
            this.group = group;
            this.selector = selector;
            this.renderer = renderer;
            group.add(this);
            this.setLayout(new BorderLayout());
            this.add("Center", this.renderPane);
            this.addMouseMotionListener(this);
            this.addMouseListener(this);
            this.addFocusListener(this);
            this.addKeyListener(this);
            this.setDate(date);
        }

        public void setDay(int day) {
            this.selector.setSelectionInterval(day, day);
            this.date.set(5, day);
        }

        public void setMonth(int month) {
            this.date.set(2, month);
            this.setDate(this.date);
        }

        public void setYear(int year) {
            this.date.set(1, year);
            this.setDate(this.date);
        }

        public void setDate(Calendar date) {
            this.date = date;
            Calendar temp = (Calendar)date.clone();
            temp.set(5, 1);
            this.first = temp.get(7) - 1;
            int current = date.get(5);
            this.selector.setSelectionInterval(current, current);
            this.days = daysInMonth[date.get(2)];
            if (this.isLeapYear(date.get(1)) && date.get(2) == 1) {
                this.days = 29;
            }
        }

        public Calendar getDate() {
            return this.date;
        }

        public void nextMonth() {
            this.date.add(2, 1);
            this.setDate(this.date);
            this.fireActionEvent(LCalendar.ACTION_NEXT);
        }

        public void prevMonth() {
            this.date.add(2, -1);
            this.setDate(this.date);
            this.fireActionEvent(LCalendar.ACTION_PREV);
        }

        public void setFirstDay() {
            this.setDay(1);
        }

        public void setLastDay() {
            this.setDay(this.days);
        }

        public void setActive(boolean active) {
            this.active = active;
        }

        @Override
        public void paintComponent(Graphics g) {
            this.xunit = this.getSize().width / 7;
            this.yunit = this.getSize().height / 6;
            g.setColor(this.renderer.getBackdrop());
            g.fillRect(0, 0, this.getSize().width, this.getSize().height);
            int day = 1;
            for (int y = 0; y < 6; ++y) {
                for (int x = 0; x < 7; ++x) {
                    if (!this.isValidDay(x, y)) continue;
                    this.drawCell(g, (int)((double)x * this.xunit), (int)((double)y * this.yunit), (int)this.xunit, (int)this.yunit, "" + day, this.isSelected(day));
                    ++day;
                }
            }
        }

        private boolean isSelected(int day) {
            if (!this.active) {
                return false;
            }
            return this.selector.isSelectedIndex(day);
        }

        private boolean isValidDay(int x, int y) {
            return y == 0 && x >= this.first || y > 0 && x + y * 7 - this.first < this.days;
        }

        private void drawCell(Graphics g, int x, int y, int w, int h, String text, boolean isSelected) {
            Component render = this.renderer.getCalendarRendererComponent(this, text, isSelected, this.hasFocus);
            this.renderPane.paintComponent(g, render, this, x, y, w, h);
        }

        private boolean isLeapYear(int year) {
            return year % 4 == 0 && (year % 100 != 0 || year % 400 == 0);
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension dimension = ((Component)((Object)this.renderer)).getPreferredSize();
            return new Dimension(dimension.width * 7, dimension.height * 6);
        }

        @Override
        public Dimension getMinimumSize() {
            Dimension dimension = ((Component)((Object)this.renderer)).getMinimumSize();
            return new Dimension(dimension.width * 7, dimension.height * 6);
        }

        @Override
        public void mouseClicked(MouseEvent event) {
        }

        @Override
        public void mouseReleased(MouseEvent event) {
        }

        @Override
        public void mouseEntered(MouseEvent event) {
        }

        @Override
        public void mouseExited(MouseEvent event) {
        }

        @Override
        public void mouseMoved(MouseEvent event) {
        }

        @Override
        public void mouseDragged(MouseEvent event) {
        }

        @Override
        public void keyTyped(KeyEvent event) {
        }

        @Override
        public void keyReleased(KeyEvent event) {
        }

        @Override
        public void mousePressed(MouseEvent event) {
            int y;
            int x;
            if (!this.hasFocus()) {
                this.requestFocus();
                this.group.setActiveMonth(this);
            }
            if (!this.isValidDay(x = (int)((double)event.getX() / this.xunit), y = (int)((double)event.getY() / this.yunit))) {
                return;
            }
            int day = x + y * 7 - this.first + 1;
            if (event.isShiftDown() || event.isControlDown()) {
                this.selector.setLeadSelectionIndex(day);
                this.repaint();
            } else {
                this.setDay(day);
                this.repaint();
            }
            this.fireActionEvent(LCalendar.ACTION_CLICK);
        }

        @Override
        public void keyPressed(KeyEvent event) {
            if (!this.active) {
                return;
            }
            int key = event.getKeyCode();
            if (key == 10) {
                this.fireActionEvent(LCalendar.ACTION_ENTER);
            }
            if (key == 36) {
                this.setFirstDay();
                this.repaint();
            }
            if (key == 35) {
                this.setLastDay();
                this.repaint();
            }
            if (key == 34) {
                if (event.isShiftDown()) {
                    this.group.prevYear(true);
                } else {
                    this.group.prevMonth(true);
                }
            }
            if (key == 33) {
                if (event.isShiftDown()) {
                    this.group.nextYear(true);
                } else {
                    this.group.nextMonth(true);
                }
            }
            int anchor = this.selector.getAnchorSelectionIndex();
            int lead = this.selector.getLeadSelectionIndex();
            if (key == 39) {
                if (event.isShiftDown() || event.isControlDown()) {
                    if (lead < this.days) {
                        this.selector.setLeadSelectionIndex(lead + 1);
                        this.repaint();
                    }
                } else if (anchor < this.days) {
                    this.setDay(anchor + 1);
                    this.repaint();
                } else if (anchor == this.days) {
                    if (this.group.isLastCalendarMonth(this)) {
                        this.group.nextMonth(true);
                        this.setLastDay();
                        this.repaint();
                    } else {
                        CalendarMonth next = this.group.nextCalendarMonth();
                        next.setFirstDay();
                        next.repaint();
                        this.repaint();
                    }
                }
            }
            if (key == 37) {
                if (event.isShiftDown() || event.isControlDown()) {
                    if (lead > 1) {
                        this.selector.setLeadSelectionIndex(lead - 1);
                        this.repaint();
                    }
                } else if (anchor > 1) {
                    this.setDay(anchor - 1);
                    this.repaint();
                } else if (anchor == 1) {
                    if (this.group.isFirstCalendarMonth(this)) {
                        this.group.prevMonth(true);
                        this.setFirstDay();
                        this.repaint();
                    } else {
                        CalendarMonth prev = this.group.prevCalendarMonth();
                        prev.setLastDay();
                        prev.repaint();
                        this.repaint();
                    }
                }
            }
            if (key == 38) {
                if (event.isShiftDown() || event.isControlDown()) {
                    if (lead > 7) {
                        this.selector.setLeadSelectionIndex(lead - 7);
                        this.repaint();
                    }
                } else if (anchor > 7) {
                    this.setDay(anchor - 7);
                    this.repaint();
                }
            }
            if (key == 40) {
                if (event.isShiftDown() || event.isControlDown()) {
                    if (lead <= this.days - 7) {
                        this.selector.setLeadSelectionIndex(lead + 7);
                        this.repaint();
                    }
                } else if (anchor <= this.days - 7) {
                    this.setDay(anchor + 7);
                    this.repaint();
                }
            }
        }

        @Override
        public void focusGained(FocusEvent event) {
            this.hasFocus = true;
            this.repaint();
        }

        @Override
        public void focusLost(FocusEvent event) {
            this.hasFocus = false;
            this.repaint();
            if (event.isTemporary()) {
                return;
            }
        }

        @Override
        public boolean isFocusTraversable() {
            return this.active;
        }

        public void addActionListener(ActionListener listener) {
            this.listeners.addElement(listener);
        }

        public void removeActionListener(ActionListener listener) {
            this.listeners.removeElement(listener);
        }

        public void fireActionEvent(String command) {
            Vector list = (Vector)this.listeners.clone();
            ActionEvent event = new ActionEvent(this, 1001, command);
            for (int i = 0; i < list.size(); ++i) {
                ActionListener listener = (ActionListener)list.elementAt(i);
                listener.actionPerformed(event);
            }
        }
    }

    static interface CalendarRenderer {
        public Component getCalendarRendererComponent(JComponent var1, Object var2, boolean var3, boolean var4);

        public Color getBackdrop();
    }

    class CalendarHeader
    extends JPanel {
        private CalendarRenderer renderer;
        private CellRendererPane renderPane = new CellRendererPane();
        private double xunit = 0.0;
        private double yunit = 0.0;

        public CalendarHeader(CalendarRenderer renderer) {
            this.renderer = renderer;
            this.setLayout(new BorderLayout());
            this.add("Center", this.renderPane);
        }

        @Override
        public void paintComponent(Graphics g) {
            this.xunit = this.getSize().width / 7;
            this.yunit = this.getSize().height;
            for (int x = 0; x < 7; ++x) {
                this.drawCell(g, (int)((double)x * this.xunit), 0, (int)this.xunit, (int)this.yunit, LCalendar.this.dayNames[x], false);
            }
        }

        private void drawCell(Graphics g, int x, int y, int w, int h, String text, boolean selected) {
            Component render = this.renderer.getCalendarRendererComponent(this, text, selected, false);
            this.renderPane.paintComponent(g, render, this, x, y, w, h);
        }

        @Override
        public boolean isFocusTraversable() {
            return false;
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension dimension = ((Component)((Object)this.renderer)).getPreferredSize();
            return new Dimension(dimension.width * 7, dimension.height);
        }

        @Override
        public Dimension getMinimumSize() {
            Dimension dimension = ((Component)((Object)this.renderer)).getMinimumSize();
            return new Dimension(dimension.width * 7, dimension.height);
        }
    }

    class CalendarGroup {
        private Component parent;
        private Vector<CalendarMonth> group;
        private int active;

        public CalendarGroup() {
            this(null);
        }

        public CalendarGroup(Component parent) {
            this.parent = parent;
            this.group = new Vector();
            this.active = 0;
        }

        public void setParent(Component parent) {
            this.parent = parent;
        }

        public void setActiveMonth(int index) {
            if (index > this.group.size()) {
                throw new IndexOutOfBoundsException("Invalid");
            }
            this.active = index;
            for (int i = 0; i < this.group.size(); ++i) {
                this.getCalendarMonth(i).setActive(i == this.active);
                if (i != this.active) continue;
                this.getCalendarMonth(i).requestFocus();
            }
        }

        public void setActiveMonth(CalendarMonth month) {
            for (int i = 0; i < this.group.size(); ++i) {
                if (this.getCalendarMonth(i) != month) continue;
                this.setActiveMonth(i);
                this.parent.repaint();
                break;
            }
        }

        public void add(CalendarMonth month) {
            this.group.addElement(month);
            this.active = this.group.size() - 1;
        }

        public CalendarMonth getActiveMonth() {
            return this.getCalendarMonth(this.active);
        }

        public CalendarMonth getCalendarMonth(int index) {
            return this.group.elementAt(index);
        }

        public CalendarMonth nextCalendarMonth() {
            ++this.active;
            if (this.active >= this.group.size()) {
                this.active = 0;
            }
            this.setActiveMonth(this.active);
            return this.getCalendarMonth(this.active);
        }

        public CalendarMonth prevCalendarMonth() {
            --this.active;
            if (this.active < 0) {
                this.active = this.group.size() - 1;
            }
            this.setActiveMonth(this.active);
            return this.getCalendarMonth(this.active);
        }

        public boolean isFirstCalendarMonth(CalendarMonth month) {
            return month == this.getCalendarMonth(0);
        }

        public boolean isLastCalendarMonth(CalendarMonth month) {
            return month == this.getCalendarMonth(this.group.size() - 1);
        }

        public void nextYear(boolean repaint) {
            for (int i = 0; i < 11; ++i) {
                this.nextMonth(false);
            }
            this.nextMonth(repaint);
        }

        public void nextMonth(boolean repaint) {
            for (int i = 0; i < this.group.size(); ++i) {
                this.getCalendarMonth(i).nextMonth();
                this.getCalendarMonth(i).invalidate();
                if (!repaint || this.parent == null) continue;
                this.parent.repaint();
            }
        }

        public void prevYear(boolean repaint) {
            for (int i = 0; i < 11; ++i) {
                this.prevMonth(false);
            }
            this.prevMonth(repaint);
        }

        public void prevMonth(boolean repaint) {
            for (int i = 0; i < this.group.size(); ++i) {
                this.getCalendarMonth(i).prevMonth();
                this.getCalendarMonth(i).invalidate();
                if (!repaint || this.parent == null) continue;
                this.parent.repaint();
            }
        }
    }
}

