/*
 * Decompiled with CFR 0.152.
 */
package com.heirloomcomputing.ecs.jfc;

import com.heirloomcomputing.ecs.exec.ThreadQueue;
import com.heirloomcomputing.ecs.jfc.LBorder;
import com.heirloomcomputing.ecs.jfc.LComponent;
import com.heirloomcomputing.ecs.jfc.LTitledBorder;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JComponent;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.basic.BasicProgressBarUI;

public final class LFrame
extends LComponent
implements KeyListener {
    private int highColor;
    private int lowColor;
    private int fillColor;
    private int fillColor2;
    private int titlePosition;
    private int fillPercent;
    private Color highColorObject;
    private Color lowColorObject;
    private Color fillColorObject;
    private Color fillColor2Object;
    JProgressBar progressBar = new JProgressBar(){

        @Override
        public void updateUI() {
            this.setUI(new BasicProgressBarUI(){
                protected JProgressBar progressBar = null;

                @Override
                public void installUI(JComponent c) {
                    this.progressBar = (JProgressBar)c;
                    super.installUI(c);
                }

                @Override
                protected Point getStringPlacement(Graphics g, String progressString, int x, int y, int width, int height) {
                    FontMetrics fontSizer = this.progressBar.getFontMetrics(this.progressBar.getFont());
                    int stringWidth = fontSizer.stringWidth(progressString);
                    int stringHeight = fontSizer.getHeight();
                    height -= 4;
                    --y;
                    if (this.getOrientation() == 0) {
                        return new Point(x + Math.round(width / 2 - stringWidth / 2), y + Math.round(height / 2 + stringHeight / 2));
                    }
                    return new Point(x + Math.round(width / 2 - stringWidth / 2), y + Math.round(height / 2 + stringHeight / 2));
                }

                @Override
                protected int getCellSpacing() {
                    return 0;
                }
            });
            this.invalidate();
        }
    };

    public LFrame() {
        this.progressBar.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.setOpaque(false);
        this.lines = 5.0;
        this.size = 12.0;
        this.setLayout(new BorderLayout());
        this.progressBar.setVisible(false);
        this.progressBar.setStringPainted(false);
        this.progressBar.setOrientation(0);
        this.progressBar.setMinimum(0);
        this.progressBar.setMaximum(100);
        this.progressBar.setBorderPainted(false);
        this.add("Center", this.progressBar);
        this.adjustLine = -3;
        this.adjustLines = 4;
        this.setForeground(Color.black);
    }

    @Override
    public void keyPressed(KeyEvent event) {
    }

    @Override
    public void keyReleased(KeyEvent event) {
        this.processKey(this, event);
    }

    @Override
    public void keyTyped(KeyEvent event) {
    }

    public void addConstantListeners() {
        this.addKeyListener(this);
        this.progressBar.addKeyListener(this);
    }

    public void removeConstantListeners() {
        this.removeKeyListener(this);
        this.progressBar.removeKeyListener(this);
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.addConstantListeners();
    }

    @Override
    public void removeNotify() {
        this.removeConstantListeners();
        super.removeNotify();
    }

    @Override
    public boolean isAcceptable() {
        return false;
    }

    @Override
    public int getControlType() {
        return 9;
    }

    public JProgressBar getJProgressBar() {
        return this.progressBar;
    }

    public void setHorizontal() {
        this.progressBar.setOrientation(0);
    }

    public void setVertical() {
        this.progressBar.setOrientation(1);
    }

    public boolean isHorizontal() {
        return this.progressBar.getOrientation() == 0;
    }

    public boolean isVertical() {
        return this.progressBar.getOrientation() == 1;
    }

    public int getHorizontal() {
        return this.isHorizontal() ? 1 : 0;
    }

    public int getVertical() {
        return this.isVertical() ? 1 : 0;
    }

    @Override
    public void setCleanTitle(String value) {
        if (value != null) {
            value = value.length() > 0 && value.charAt(0) == '\u0000' ? null : value.trim();
        }
        super.setCleanTitle(value);
        this.progressBar.setString(value);
        this.redisplay();
    }

    @Override
    public void determineDefaultSize() {
        if (this.size > 0.0) {
            return;
        }
        this.lines = 5.0;
        this.size = 12.0;
    }

    public boolean isNormal() {
        return this.isStyle(48);
    }

    public void setNormal() {
        this.setStyleOn(0, 32);
    }

    public void setNormal(boolean state) {
        this.setStyle(48, state, 48);
    }

    public boolean isHeavy() {
        return this.isStyle(16);
    }

    public int getHeavy() {
        return this.isHeavy() ? 1 : 0;
    }

    public void setHeavy() {
        this.setStyleOn(16, 32);
    }

    public void setHeavy(boolean state) {
        this.setStyle(16, state, 32);
    }

    public boolean isVeryHeavy() {
        return this.isStyle(32);
    }

    public int getVeryHeavy() {
        return this.isVeryHeavy() ? 1 : 0;
    }

    public void setVeryHeavy() {
        this.setStyleOn(32, 16);
    }

    public void setVeryHeavy(boolean state) {
        this.setStyle(32, state, 16);
    }

    public boolean isAlternate() {
        return this.isStyle(64);
    }

    public int getAlternate() {
        return this.isAlternate() ? 1 : 0;
    }

    public void setAlternate() {
        this.setStyleOn(64);
    }

    public void setAlternate(boolean state) {
        this.setStyle(64, state);
    }

    public boolean isFullHeight() {
        return this.isStyle(128);
    }

    public int getFullHeight() {
        return this.isFullHeight() ? 1 : 0;
    }

    public void setFullHeight() {
        this.setStyleOn(128);
    }

    public void setFullHeight(boolean state) {
        this.setStyle(128, state);
    }

    public boolean isRaised() {
        return this.isStyle(1);
    }

    public int getRaised() {
        return this.isRaised() ? 1 : 0;
    }

    public void setRaised() {
        this.setStyleOn(1, 14);
    }

    public void setRaised(boolean state) {
        this.setStyle(1, state, 14);
    }

    public boolean isLowered() {
        return this.isStyle(2);
    }

    public int getLowered() {
        return this.isLowered() ? 1 : 0;
    }

    public void setLowered() {
        this.setStyleOn(2, 13);
    }

    public void setLowered(boolean state) {
        this.setStyle(2, state, 13);
    }

    public boolean isEngraved() {
        return this.isStyle(4);
    }

    public int getEngraved() {
        return this.isEngraved() ? 1 : 0;
    }

    public void setEngraved() {
        this.setStyleOn(4, 11);
    }

    public void setEngraved(boolean state) {
        this.setStyle(4, state, 11);
    }

    public boolean isRimmed() {
        return this.isStyle(8);
    }

    public int getRimmed() {
        return this.isRimmed() ? 1 : 0;
    }

    public void setRimmed() {
        this.setStyleOn(8, 7);
    }

    public void setRimmed(boolean state) {
        this.setStyle(8, state, 7);
    }

    @Override
    public void setStyle(int mask) {
        super.setStyle(mask);
        this.redisplay();
    }

    @Override
    public void setProperty(int number, Object property) {
        switch (number) {
            case 1: {
                this.setHighColor(this.getInt(property));
                break;
            }
            case 2: {
                this.setLowColor(this.getInt(property));
                break;
            }
            case 3: {
                this.setFillColor(this.getInt(property));
                break;
            }
            case 4: {
                this.setFillPercent(this.getInt(property));
                break;
            }
            case 5: {
                this.setFillColor2(this.getInt(property));
                break;
            }
            case 6: {
                this.setTitlePosition(this.getInt(property));
                break;
            }
            default: {
                super.setProperty(number, property);
            }
        }
    }

    @Override
    public String getProperty(int number) {
        switch (number) {
            case 1: {
                return String.valueOf(this.getHighColor());
            }
            case 2: {
                return String.valueOf(this.getLowColor());
            }
            case 3: {
                return String.valueOf(this.getFillColor());
            }
            case 4: {
                return String.valueOf(this.getFillPercent());
            }
            case 5: {
                return String.valueOf(this.getFillColor2());
            }
            case 6: {
                return String.valueOf(this.getTitlePosition());
            }
        }
        return super.getProperty(number);
    }

    public void setHighColor(int value) {
        this.highColor = value;
        if (this.highColor > 0 && this.highColor <= 16) {
            this.highColorObject = LFrame.getCobolColor(this.highColor);
        }
        this.redisplay();
    }

    public int getHighColor() {
        return this.highColor;
    }

    public void setLowColor(int value) {
        this.lowColor = value;
        if (this.lowColor > 0 && this.lowColor <= 16) {
            this.lowColorObject = LFrame.getCobolColor(this.lowColor);
        }
        this.redisplay();
    }

    public int getLowColor() {
        return this.lowColor;
    }

    public void setFillColor(int value) {
        this.fillColor = value;
        if (this.fillColor > 0 && this.fillColor <= 16) {
            this.fillColorObject = LFrame.getCobolColor(this.fillColor);
            if (this.fillColor == 16) {
                this.fillColorObject = Color.white;
            }
            this.progressBar.setForeground(this.fillColorObject);
            this.progressBar.setBackground(this.fillColor2Object);
            this.progressBar.setVisible(true);
        } else {
            this.setOpaque(false);
            this.progressBar.setVisible(false);
        }
        this.redisplay();
    }

    public int getFillColor() {
        return this.fillColor;
    }

    public void setFillColor2(int value) {
        this.fillColor2 = value;
        if (this.fillColor2 > 0 && this.fillColor2 <= 16) {
            this.fillColor2Object = LFrame.getCobolColor(this.fillColor2);
            if (this.fillColor2 == 16) {
                this.fillColor2Object = Color.white;
            }
            this.progressBar.setBackground(this.fillColor2Object);
        }
    }

    public int getFillColor2() {
        return this.fillColor2;
    }

    private void refreshProgressBar() {
        ThreadQueue appThread = new ThreadQueue(){

            @Override
            public void run() {
                try {
                    SwingUtilities.invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            LFrame.this.progressBar.paintImmediately(LFrame.this.progressBar.getBounds());
                        }
                    });
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        };
        appThread.start();
    }

    public void setFillPercent(int value) {
        this.fillPercent = value;
        if (value < 0) {
            value = 0;
        } else if (value > 100) {
            value = 100;
        }
        if (this.progressBar != null) {
            this.progressBar.setValue(value);
            this.refreshProgressBar();
        }
    }

    public int getFillPercent() {
        return this.fillPercent;
    }

    public void setTitlePosition(int value) {
        this.titlePosition = value;
        this.redisplay();
    }

    public int getTitlePosition() {
        return this.titlePosition;
    }

    @Override
    public void setFont(Font f) {
        super.setFont(f);
        this.redisplay();
    }

    private void redisplay() {
        String displayTitle = this.cleanTitle;
        if (displayTitle != null && displayTitle.length() > 0) {
            displayTitle = " " + displayTitle;
        }
        Border border = this.getBorder();
        LBorder myBorder = null;
        int type = 0;
        if ((this.style & 1) != 0) {
            type = 1;
        }
        if ((this.style & 2) != 0) {
            type = 2;
        }
        if ((this.style & 4) != 0) {
            type = 3;
        }
        if ((this.style & 8) != 0) {
            type = 4;
        }
        int thickness = 1;
        if (type > 0) {
            thickness = 2;
        }
        if ((this.style & 0x10) != 0) {
            ++thickness;
        }
        if ((this.style & 0x20) != 0) {
            thickness += 2;
        }
        boolean alternate = (this.style & 0x40) != 0;
        int verticalOffset = 0;
        myBorder = new LBorder(verticalOffset, type, Color.black, this.highColorObject, this.lowColorObject, thickness, alternate, false);
        this.setLines(this.lines);
        this.setColumns(this.size);
        int titleJust = 0;
        int titlePos = 0;
        Color titleColor = this.getForeground();
        Font titleFont = this.getFont();
        switch (this.titlePosition) {
            default: {
                this.titlePosition = 1;
            }
            case 1: 
            case 4: {
                titleJust = 1;
                break;
            }
            case 2: 
            case 5: {
                titleJust = 2;
                break;
            }
            case 3: 
            case 6: {
                titleJust = 3;
            }
            case 7: 
        }
        this.progressBar.setStringPainted(this.titlePosition == 7);
        if (this.titlePosition != 7) {
            if (this.isFullHeight()) {
                if (this.titlePosition <= 3) {
                    titlePos = 3;
                } else if (this.titlePosition <= 6) {
                    titlePos = 4;
                }
            } else if (this.titlePosition <= 3) {
                titlePos = 2;
            } else if (this.titlePosition <= 6) {
                titlePos = 5;
            }
        }
        if (border instanceof LTitledBorder) {
            LTitledBorder b = (LTitledBorder)border;
            b.setBorder(myBorder);
            b.setTitleJustification(titleJust);
            b.setTitlePosition(titlePos);
            b.setTitleFont(titleFont);
            b.setTitleColor(titleColor);
            if (displayTitle != null && this.titlePosition != 7) {
                b.setTitle(displayTitle);
            } else {
                b.setTitlePosition(2);
                b.setTitle(null);
            }
        } else if (displayTitle == null || this.titlePosition == 7) {
            titlePos = 2;
            border = new LTitledBorder(border, null, titleJust, titlePos, titleFont, titleColor);
        } else {
            border = new LTitledBorder(border, displayTitle, titleJust, titlePos, titleFont, titleColor);
        }
        if (this.titlePosition == 7) {
            this.setBorder(myBorder);
        } else {
            this.setBorder(border);
        }
        this.repaint();
    }

    @Override
    public void setBackground(Color c) {
        super.setBackground(c);
        if (this.fillColor2 == 0) {
            this.fillColor2Object = c;
        }
        this.redisplay();
    }

    @Override
    public void setForeground(Color c) {
        super.setForeground(c);
        this.redisplay();
    }
}

