/*
 * Decompiled with CFR 0.152.
 */
package com.heirloomcomputing.ecs.jfc;

import com.heirloomcomputing.ecs.exec.AcceptEvent;
import com.heirloomcomputing.ecs.exec.Handle;
import com.heirloomcomputing.ecs.exec.XOpenInternational;
import com.heirloomcomputing.ecs.jfc.LBitmap;
import com.heirloomcomputing.ecs.jfc.LBitmapIcon;
import com.heirloomcomputing.ecs.jfc.LComponent;
import com.heirloomcomputing.ecs.jfc.LPager;
import com.heirloomcomputing.ecs.jfc.PageListener;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.SystemColor;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.EventObject;
import javax.swing.AbstractListModel;
import javax.swing.DefaultCellEditor;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JViewport;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.SwingConstants;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.AbstractBorder;
import javax.swing.border.BevelBorder;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public final class LGrid
extends LComponent
implements KeyListener,
FocusListener,
ComponentListener,
PageListener,
MouseListener {
    public static final String DT_X = "X";
    public static final String DT_U = "U";
    public static final String DT_L = "L";
    public static final String DT_9 = "9";
    public static final String DT_Z = "Z";
    public static final String DT_I = "I";
    public static final String DT_P = "P";
    public static final String DT_D = "D";
    public static final int ALIGN_UNALIGNED = 0;
    public static final int ALIGN_LEFT_JUSTIFIED = 1;
    public static final int ALIGN_RIGHT_JUSTIFIED = 2;
    public static final int ALIGN_CENTERED = 3;
    public static final int ALIGN_LEADING = 4;
    public static final int ALIGN_TRAILING = 5;
    public static final int DEFAULT_COLUMN_WIDTH = 75;
    public static final boolean REORDERING_ALLOWED = true;
    public static final boolean MEANINGFUL_DEFAULT_HEADERS = false;
    public static Border noFocusBorder = new EmptyBorder(1, 2, 1, 2);
    private int x = 1;
    private int y = 1;
    private boolean massUpdate;
    private JTable jTable;
    private JScrollPane scrollpane;
    private LBitmap bitmapComponent;
    private LPager pager;
    private int bitmapHandle = 0;
    private int bitmapWidth = 16;
    private int bitmapNumber = 1;
    private int[] dataColumns;
    private int[] displayColumns;
    private int filePos;
    private int insertionIndex;
    private int searchResult;
    private int virtualWidth;
    private ListModel<Object> rowHeaderModel;
    private Border originalBorder;
    public int numberOfColumnHeadings;
    public int numberOfRowHeadings;
    private JList<Object> rowHeader;
    private RowHeaderRenderer rowHeaderRenderer;
    private ColumnHeaderRenderer columnHeaderRenderer;
    private ColumnHeaderListener columnHeaderListener;
    private RowHeaderListener rowHeaderListener;
    private int numberOfRowsPerRecord = 1;
    private int numberOfColumnsPerRecord;
    private ColumnSelectionListener columnSelectionListener;
    private RowSelectionListener rowSelectionListener;
    public boolean currentlyDragging;
    public int dragColumn;
    public int dragRow;
    public boolean internalCursorPositioning;
    public boolean internalColumnWidthPositioning;
    private int previousColumn = -1;
    private int previousRow = -1;
    public boolean pagedAtStart;
    public boolean pagedAtEnd;
    private JViewport backupColumnHeaderView;
    public RowHeaderRenderer cornerComponent;
    private boolean constantListenersAdded;
    private boolean componentListener;
    private boolean enableDragEvents = true;
    private boolean gridSearchDirection = true;
    private boolean gridSearchWrapFlag = true;
    private boolean gridSearchCaseFlag = true;
    private int gridSearchMatchFlag;
    private int gridSearchLocationFlag;
    private boolean gridSearchSkipFlag = true;
    private boolean gridSearchCursorFlag = true;
    private int gridSearchColumn;

    public static void log(String s) {
    }

    public static void log(Throwable t) {
    }

    private void initializeGrid() {
        try {
            this.setPagedEmpty();
            this.setLayout(new BorderLayout());
            this.jTable = new JTable(new TableCellModel(this));
            this.jTable.setAutoCreateColumnsFromModel(false);
            this.jTable.setAutoResizeMode(0);
            this.jTable.setVisible(false);
            this.jTable.getTableHeader().setReorderingAllowed(false);
            this.jTable.getTableHeader().setResizingAllowed(false);
            ListSelectionModel listSelectionModel = this.jTable.getSelectionModel();
            this.jTable.setRowSelectionAllowed(true);
            this.jTable.setColumnSelectionAllowed(true);
            listSelectionModel.setSelectionMode(1);
            this.rowHeaderModel = new RowHeaderModel();
            this.rowHeader = new JList<Object>(this.rowHeaderModel);
            this.rowHeader.setFixedCellWidth(0);
            this.rowHeader.setVisible(false);
            this.rowHeaderRenderer = new RowHeaderRenderer();
            this.rowHeader.setCellRenderer(this.rowHeaderRenderer);
            this.rowHeader.setBackground(this.jTable.getTableHeader().getBackground());
            this.columnHeaderRenderer = new ColumnHeaderRenderer();
            this.scrollpane = new JScrollPane(this.jTable);
            this.scrollpane.setRowHeaderView(this.rowHeader);
            this.backupColumnHeaderView = this.scrollpane.getColumnHeader();
            this.scrollpane.setColumnHeader(null);
            this.setVerticalScrollBarPolicy(VERTICAL_SCROLLBAR_NEVER);
            this.setHorizontalScrollBarPolicy(HORIZONTAL_SCROLLBAR_NEVER);
            this.add((Component)this.scrollpane, "Center");
            this.pager = new LPager();
            this.pager.setVisible(false);
            this.scrollpane.setVisible(true);
            this.jTable.setVisible(true);
            this.originalBorder = this.scrollpane.getBorder();
            this.style = 64;
            this.jTable.setDefaultRenderer(Object.class, new TableCellLabelRenderer());
            int jTableRowHeight = this.jTable.getRowHeight();
            this.rowHeader.setFixedCellHeight(jTableRowHeight);
            this.setNumRowHeadings(0);
            this.setNumColHeadings(0);
            this.cornerComponent = new RowHeaderRenderer();
            this.cornerComponent.updateCornerComponent();
            this.scrollpane.setCorner("UPPER_LEFT_CORNER", this.cornerComponent);
            this.add((Component)this.pager, "East");
        }
        catch (Throwable t) {
            LGrid.log(t);
        }
    }

    public LGrid() {
        this.lines = 5.0;
        this.size = 12.0;
        this.initializeGrid();
    }

    @Override
    public void componentResized(ComponentEvent event) {
        if (event != null) {
            Component c = event.getComponent();
            Dimension rowHeaderSize = this.rowHeader.getSize();
            Dimension tableSize = c.getSize();
            this.rowHeader.setSize(new Dimension(rowHeaderSize.width, tableSize.height));
        }
    }

    @Override
    public void componentShown(ComponentEvent event) {
    }

    @Override
    public void componentHidden(ComponentEvent event) {
    }

    @Override
    public void componentMoved(ComponentEvent event) {
    }

    @Override
    public void keyPressed(KeyEvent event) {
    }

    @Override
    public void keyReleased(KeyEvent event) {
        int keyCode = event.getKeyCode();
        switch (keyCode) {
            case 9: {
                if (!this.isUseTab()) break;
                return;
            }
            case 38: {
                return;
            }
            case 40: {
                return;
            }
            case 37: {
                return;
            }
            case 39: {
                return;
            }
        }
        this.processKey(this, event);
    }

    @Override
    public void keyTyped(KeyEvent event) {
    }

    @Override
    public void focusGained(FocusEvent event) {
        if (!this.isSelfAct() && this.processGotoEvent(new AcceptEvent(this.getHandle(), 0, 3, event))) {
            return;
        }
    }

    @Override
    public void focusLost(FocusEvent event) {
        if (event.isTemporary()) {
            return;
        }
        if (this.jTable != null && this.jTable.isEditing()) {
            return;
        }
        if (this.processAcceptEvent(new AcceptEvent(this.getHandle(), 0, 16391, event))) {
            this.requestFocus();
            return;
        }
    }

    @Override
    public void spinnerIncrease() {
        if (!this.pagedAtStart && this.processAcceptEvent(new AcceptEvent(this.getHandle(), 0, 16420, null, 0, this.getPagePos()))) {
            this.setPagedAtStart();
            return;
        }
    }

    @Override
    public void spinnerDecrease() {
        if (!this.pagedAtEnd && this.processAcceptEvent(new AcceptEvent(this.getHandle(), 0, 16419, null, 0, this.getPagePos()))) {
            this.setPagedAtEnd();
            return;
        }
    }

    @Override
    public void pageIncrease() {
        if (!this.pagedAtStart && this.processAcceptEvent(new AcceptEvent(this.getHandle(), 0, 16422, null))) {
            return;
        }
    }

    @Override
    public void pageDecrease() {
        if (!this.pagedAtEnd && this.processAcceptEvent(new AcceptEvent(this.getHandle(), 0, 16421, null))) {
            return;
        }
    }

    @Override
    public void pageFirst() {
        if (this.processAcceptEvent(new AcceptEvent(this.getHandle(), 0, 16423, null))) {
            this.setPagedEmpty();
            return;
        }
        this.setPagedAtStart();
    }

    @Override
    public void pageLast() {
        if (this.processAcceptEvent(new AcceptEvent(this.getHandle(), 0, 16424, null))) {
            this.setPagedEmpty();
            return;
        }
        this.setPagedAtEnd();
    }

    @Override
    public void mouseClicked(MouseEvent event) {
    }

    @Override
    public void mouseEntered(MouseEvent event) {
    }

    @Override
    public void mouseExited(MouseEvent event) {
    }

    @Override
    public void mousePressed(MouseEvent event) {
        if ((event.getModifiers() & 4) == 4 && this.processGridEvent(16426, event)) {
            event.consume();
            return;
        }
    }

    @Override
    public void mouseReleased(MouseEvent event) {
        if ((event.getModifiers() & 4) == 4 && this.processGridEvent(16427, event)) {
            event.consume();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConstantListeners() {
        LGrid lGrid = this;
        synchronized (lGrid) {
            if (this.constantListenersAdded) {
                return;
            }
            this.constantListenersAdded = true;
            this.jTable.addKeyListener(this);
            this.jTable.addFocusListener(this);
            this.pager.addPageListener(this);
            this.jTable.addMouseListener(this);
            JTableHeader header = this.jTable.getTableHeader();
            this.columnHeaderListener = new ColumnHeaderListener(header);
            header.addMouseListener(this.columnHeaderListener);
            this.rowHeaderListener = new RowHeaderListener(this.rowHeader);
            this.rowHeader.addMouseListener(this.rowHeaderListener);
            this.rowSelectionListener = new RowSelectionListener();
            this.columnSelectionListener = new ColumnSelectionListener();
            this.jTable.getSelectionModel().addListSelectionListener(this.rowSelectionListener);
            this.jTable.getColumnModel().getSelectionModel().addListSelectionListener(this.columnSelectionListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeConstantListeners() {
        LGrid lGrid = this;
        synchronized (lGrid) {
            if (!this.constantListenersAdded) {
                return;
            }
            this.jTable.removeKeyListener(this);
            this.jTable.removeFocusListener(this);
            this.constantListenersAdded = false;
            this.pager.removePageListener(this);
            this.jTable.removeMouseListener(this);
            JTableHeader header = this.jTable.getTableHeader();
            header.removeMouseListener(this.columnHeaderListener);
            this.columnHeaderListener = null;
            this.rowHeader.removeMouseListener(this.rowHeaderListener);
            this.rowHeaderListener = null;
            if (this.rowSelectionListener != null) {
                this.jTable.getSelectionModel().removeListSelectionListener(this.rowSelectionListener);
            }
            if (this.columnSelectionListener != null) {
                this.jTable.getColumnModel().getSelectionModel().removeListSelectionListener(this.columnSelectionListener);
            }
        }
    }

    public int getAnchorRowSelectionIndex() {
        return this.jTable.getSelectionModel().getAnchorSelectionIndex();
    }

    public int getAnchorColumnSelectionIndex() {
        return this.jTable.getColumnModel().getSelectionModel().getAnchorSelectionIndex();
    }

    public int getLeadRowSelectionIndex() {
        return this.jTable.getSelectionModel().getLeadSelectionIndex();
    }

    public int getLeadColumnSelectionIndex() {
        return this.jTable.getColumnModel().getSelectionModel().getLeadSelectionIndex();
    }

    public void updateCornerComponent() {
        this.cornerComponent.updateCornerComponent();
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
    }

    @Override
    public void addNotify() {
        try {
            super.addNotify();
            int col = this.getNumColHeadings();
            int row = this.getNumRowHeadings();
            this.numberOfColumnHeadings = -1;
            this.numberOfRowHeadings = -1;
            this.setNumColHeadings(col);
            this.setNumRowHeadings(row);
            this.addConstantListeners();
            this.jTable.addComponentListener(this);
            this.componentListener = true;
        }
        catch (Throwable catchAll) {
            LGrid.log(catchAll);
        }
    }

    @Override
    public void removeNotify() {
        try {
            this.removeConstantListeners();
            this.jTable.removeComponentListener(this);
            this.componentListener = false;
            super.removeNotify();
        }
        catch (Throwable catchAll) {
            LGrid.log(catchAll);
        }
    }

    @Override
    public boolean isManagingFocus() {
        return true;
    }

    @Override
    public void requestChildFocus() {
        this.jTable.requestFocus();
    }

    @Override
    public boolean hasFocusChild() {
        return this.hasFocus() || this.scrollpane.hasFocus() || this.jTable.hasFocus();
    }

    @Override
    public int getControlType() {
        return 12;
    }

    public TableCell getTableCell(int row, int col) {
        return this.getTableCellModel().getTableCell(row - 1, col - 1);
    }

    @Override
    public void setInquireIndex(int value) {
        this.setCellY(value);
        this.setCellX(1);
    }

    @Override
    public void setInquireIndex(int value1, int value2) {
        this.setCellY(value1);
        this.setCellX(value2);
    }

    @Override
    public void setCleanTitle(String value) {
        this.jTable.setToolTipText(value);
    }

    public TableCellModel getTableCellModel() {
        try {
            return (TableCellModel)this.jTable.getModel();
        }
        catch (ClassCastException e) {
            LGrid.log(e);
            return null;
        }
        catch (Exception catchAll) {
            LGrid.log(catchAll);
            return null;
        }
    }

    public boolean processGridEvent(int value, EventObject eventObject) {
        if (!this.isVisible()) {
            return false;
        }
        int eventData1 = 0;
        int eventData2 = 0;
        try {
            if (eventObject instanceof MouseEvent) {
                MouseEvent mouseEvent = (MouseEvent)eventObject;
                Point mousePoint = mouseEvent.getPoint();
                int col = this.jTable.columnAtPoint(mousePoint);
                col = this.jTable.convertColumnIndexToModel(col);
                ++col;
                int row = this.jTable.rowAtPoint(mousePoint);
                if (this.numberOfRowHeadings > 0) {
                    row += this.numberOfRowHeadings;
                }
                eventData1 = col;
                eventData2 = ++row;
            } else {
                int col = this.jTable.getEditingColumn();
                col = this.jTable.convertColumnIndexToModel(col);
                ++col;
                int row = this.jTable.getEditingRow();
                ++row;
                if (this.numberOfRowHeadings > 0) {
                    row += this.numberOfRowHeadings;
                }
                eventData1 = col;
                eventData2 = row;
            }
        }
        catch (Exception fillInEventData) {
            LGrid.log(fillInEventData);
        }
        return this.processGridXYEvent(value, eventObject, eventData1, eventData2);
    }

    public boolean processGridXYEvent(int value, EventObject eventObject, int eventData1, int eventData2) {
        int oldx = this.x;
        int oldy = this.y;
        this.x = eventData1;
        this.y = eventData2;
        boolean result = this.processGridEvent(value, eventObject, eventData1, eventData2);
        this.x = oldx;
        this.y = oldy;
        return result;
    }

    public boolean processGridEvent(int value, EventObject eventObject, int eventData1, int eventData2) {
        if (!this.isVisible()) {
            return false;
        }
        try {
            return this.processAcceptEvent(new AcceptEvent(this.getHandle(), 0, value, eventObject, eventData1, eventData2));
        }
        catch (Exception processingException) {
            LGrid.log(processingException);
            return false;
        }
    }

    public boolean isAdjustableColumns() {
        return this.isStyle(512);
    }

    public int getAdjustableColumns() {
        return this.isAdjustableColumns() ? 1 : 0;
    }

    public void setAdjustableColumns() {
        this.setStyleOn(512);
    }

    public void setAdjustableColumns(boolean state) {
        this.setStyle(512, state);
    }

    public boolean isBoxed() {
        return this.isStyle(1);
    }

    public int getBoxed() {
        return this.isBoxed() ? 1 : 0;
    }

    public void setBoxed() {
        this.setStyleOn(1);
    }

    public void setBoxed(boolean state) {
        this.setStyle(1, state);
    }

    public boolean isCenteredHeadings() {
        return this.isStyle(128);
    }

    public int getCenteredHeadings() {
        return this.isCenteredHeadings() ? 1 : 0;
    }

    public void setCenteredHeadings() {
        this.setStyleOn(128);
    }

    public void setCenteredHeadings(boolean state) {
        this.setStyle(128, state);
    }

    public boolean isColumnHeadings() {
        return this.isStyle(16);
    }

    public int getColumnHeadings() {
        return this.isColumnHeadings() ? 1 : 0;
    }

    public void setColumnHeadings() {
        this.setStyleOn(16);
    }

    public void setColumnHeadings(boolean state) {
        this.setStyle(16, state);
    }

    public boolean isHscroll() {
        return this.isStyle(8);
    }

    public int getHscroll() {
        return this.isHscroll() ? 1 : 0;
    }

    public void setHscroll() {
        this.setStyleOn(8);
    }

    public void setHscroll(boolean state) {
        this.setStyle(8, state);
    }

    public boolean isNoBox() {
        return this.isStyle(2);
    }

    public int getNoBox() {
        return this.isNoBox() ? 1 : 0;
    }

    public void setNoBox() {
        this.setStyleOn(2);
    }

    public void setNoBox(boolean state) {
        this.setStyle(2, state);
    }

    public boolean isPaged() {
        return this.isStyle(1024);
    }

    public int getPaged() {
        return this.isPaged() ? 1 : 0;
    }

    public void setPaged() {
        this.setStyleOn(1024);
    }

    public void setPaged(boolean state) {
        this.setStyle(1024, state);
    }

    public boolean isRowHeadings() {
        return this.isStyle(32);
    }

    public int getRowHeadings() {
        return this.isRowHeadings() ? 1 : 0;
    }

    public void setRowHeadings() {
        this.setStyleOn(32);
    }

    public void setRowHeadings(boolean state) {
        this.setStyle(32, state);
    }

    public boolean isTiledHeadings() {
        return this.isStyle(64);
    }

    public int getTiledHeadings() {
        return this.isTiledHeadings() ? 1 : 0;
    }

    public void setTiledHeadings() {
        this.setStyleOn(64);
    }

    public void setTiledHeadings(boolean state) {
        this.setStyle(64, state);
    }

    public boolean isUseTab() {
        return this.isStyle(256);
    }

    public int getUseTab() {
        return this.isUseTab() ? 1 : 0;
    }

    public void setUseTab() {
        this.setStyleOn(256);
    }

    public void setUseTab(boolean state) {
        this.setStyle(256, state);
    }

    public boolean isVscroll() {
        return this.isStyle(4);
    }

    public int getVscroll() {
        return this.isVscroll() ? 1 : 0;
    }

    public void setVscroll() {
        this.setStyleOn(4);
    }

    public void setVscroll(boolean state) {
        this.setStyle(4, state);
    }

    public void setVerticalScrollBarPolicy(int value) {
        this.scrollpane.setVerticalScrollBarPolicy(value);
    }

    public int getVerticalScrollBarPolicy() {
        return this.scrollpane.getVerticalScrollBarPolicy();
    }

    public void setHorizontalScrollBarPolicy(int value) {
        this.scrollpane.setHorizontalScrollBarPolicy(value);
    }

    public int getHorizontalScrollBarPolicy() {
        return this.scrollpane.getHorizontalScrollBarPolicy();
    }

    @Override
    public void setStyle(int mask) {
        int rowHeadings = -1;
        int colHeadings = -1;
        try {
            int change = this.style ^ mask;
            try {
                if ((change & 0x400) == 1024) {
                    boolean paged = (mask & 0x400) == 1024;
                    this.pager.setVisible(paged);
                }
            }
            catch (Exception e) {
                LGrid.log(e);
            }
            if ((change & 0x40) == 64) {
                boolean tiledHeadings = (mask & 0x40) == 64;
                this.rowHeaderRenderer.setTiledHeadings(tiledHeadings);
                this.columnHeaderRenderer.setTiledHeadings(tiledHeadings);
            }
            if ((change & 0x2000003) != 0) {
                if ((mask & 1) == 1) {
                    this.scrollpane.setBorder(this.originalBorder);
                } else if ((mask & 0x2000000) == 0x2000000) {
                    this.scrollpane.setBorder(new BevelBorder(1));
                } else if ((mask & 2) == 2) {
                    this.scrollpane.setBorder(null);
                } else {
                    this.scrollpane.setBorder(this.originalBorder);
                }
            }
            if ((change & 0x200) == 512) {
                boolean adjustableColumns;
                boolean bl = adjustableColumns = (mask & 0x200) == 512;
                if (adjustableColumns) {
                    this.jTable.getTableHeader().setReorderingAllowed(true);
                    this.jTable.getTableHeader().setResizingAllowed(true);
                    this.addMsgColWidthChangedListener();
                } else {
                    this.jTable.getTableHeader().setReorderingAllowed(false);
                    this.jTable.getTableHeader().setResizingAllowed(false);
                    this.removeMsgColWidthChangedListener();
                }
            }
            if ((change & 4) == 4) {
                boolean vscroll = (mask & 4) == 4;
                this.setVerticalScrollBarPolicy(vscroll ? VERTICAL_SCROLLBAR_ALWAYS : VERTICAL_SCROLLBAR_NEVER);
            }
            if ((change & 8) == 8) {
                boolean hscroll = (mask & 8) == 8;
                this.setHorizontalScrollBarPolicy(hscroll ? HORIZONTAL_SCROLLBAR_ALWAYS : HORIZONTAL_SCROLLBAR_NEVER);
            }
            if ((change & 0x20) == 32) {
                rowHeadings = this.getNumRowHeadings();
            }
            if ((change & 0x10) == 16) {
                colHeadings = this.getNumColHeadings();
            }
            this.revalidateAndDisplay();
            super.setStyle(mask);
            if (rowHeadings >= 0) {
                this.setNumRowHeadings(rowHeadings);
            }
            if (colHeadings >= 0) {
                this.setNumColHeadings(colHeadings);
            }
            boolean centeredHeadings = (this.style & 0x80) == 128;
            this.rowHeaderRenderer.setCenteredHeadings(centeredHeadings);
            this.columnHeaderRenderer.setCenteredHeadings(centeredHeadings);
        }
        catch (Throwable catchAll) {
            LGrid.log(catchAll);
        }
    }

    public void addMsgColWidthChangedListener() {
    }

    public void removeMsgColWidthChangedListener() {
    }

    @Override
    public void setProperty(int number, Object property) {
        switch (number) {
            case 1: {
                this.setRowDividers(this.getInt(property));
                break;
            }
            case 2: {
                this.setVpadding(this.getInt(property));
                break;
            }
            case 3: {
                this.setDividerColor(this.getInt(property));
                break;
            }
            case 4: {
                this.setInsertionIndex(this.getInt(property));
                break;
            }
            case 5: {
                this.setDataColumns(this.getInt(property));
                break;
            }
            case 6: {
                this.setDisplayColumns(this.getInt(property));
                break;
            }
            case 7: {
                this.setAlignment(this.getString(property));
                break;
            }
            case 8: {
                this.setSeparation(this.getInt(property));
                break;
            }
            case 9: {
                this.setColumnDividers(this.getInt(property));
                break;
            }
            case 10: {
                this.setRowColorPattern(this.getInt(property));
                break;
            }
            case 11: {
                this.setCellY(this.getInt(property));
                break;
            }
            case 12: {
                this.setCellX(this.getInt(property));
                break;
            }
            case 13: {
                this.setColumnColor(this.getInt(property));
                break;
            }
            case 14: {
                this.setRowColor(this.getInt(property));
                break;
            }
            case 15: {
                this.setCellColor(this.getInt(property));
                break;
            }
            case 16: {
                this.setColumnFont(this.getInt(property));
                break;
            }
            case 17: {
                this.setRowFont(this.getInt(property));
                break;
            }
            case 18: {
                this.setCellFont(this.getInt(property));
                break;
            }
            case 19: {
                this.setBitmap(this.getInt(property));
                break;
            }
            case 20: {
                this.setBitmapNumber(this.getInt(property));
                break;
            }
            case 21: {
                this.setBitmapWidth(this.getInt(property));
                break;
            }
            case 22: {
                this.setBitmapTrailing(this.getInt(property));
                break;
            }
            case 23: {
                this.setNumRows(this.getInt(property));
                break;
            }
            case 24: {
                this.setCursorY(this.getInt(property));
                break;
            }
            case 25: {
                this.setCursorX(this.getInt(property));
                break;
            }
            case 26: {
                this.setCursorFrameWidth(this.getInt(property));
                break;
            }
            case 27: {
                this.setVirtualWidth(this.getInt(property));
            }
            case 28: {
                this.setDataTypes(this.getString(property));
                break;
            }
            case 29: {
                this.setCursorColor(this.getInt(property));
                break;
            }
            case 30: {
                this.setHeadingColor(this.getInt(property));
                break;
            }
            case 31: {
                this.setHeadingFont(this.getInt(property));
                break;
            }
            case 32: {
                this.setHeadingDividerColor(this.getInt(property));
                break;
            }
            case 33: {
                this.setStartX(this.getInt(property));
                break;
            }
            case 34: {
                this.setStartY(this.getInt(property));
                break;
            }
            case 35: {
                this.setRegionColor(this.getInt(property));
                break;
            }
            case 36: {
                this.setMassUpdate(this.getInt(property));
                break;
            }
            case 37: {
                this.setHiddenData(this.getString(property));
                break;
            }
            case 38: {
                this.setEndColor(this.getInt(property));
                break;
            }
            case 39: {
                this.setFilePos(this.getInt(property));
                break;
            }
            case 40: {
                this.setNumColHeadings(this.getInt(property));
                break;
            }
            case 4097: {
                this.setRecordToAdd(this.getString(property));
                break;
            }
            case 4098: {
                this.setResetGrid(this.getInt(property));
                break;
            }
            case 4099: {
                this.setCellData(this.getString(property));
                break;
            }
            case 4100: {
                this.setRecordToDelete(this.getInt(property));
                break;
            }
            case 4101: {
                this.setRecordData(this.getString(property));
                break;
            }
            case 4105: {
                this.setAction(this.getInt(property));
                break;
            }
            case 4106: {
                this.setSearchText(this.getString(property));
                break;
            }
            case 4107: {
                this.setSearchOptions(this.getString(property));
                break;
            }
            case 4108: {
                this.setInsertRows(this.getInt(property));
                break;
            }
            default: {
                super.setProperty(number, property);
            }
        }
    }

    @Override
    public String getProperty(int number) {
        switch (number) {
            case 2: {
                return String.valueOf(this.getVpadding());
            }
            case 3: {
                return String.valueOf(this.getDividerColor());
            }
            case 4: {
                return String.valueOf(this.getInsertionIndex());
            }
            case 5: {
                return String.valueOf(this.getDataColumns());
            }
            case 6: {
                return String.valueOf(this.getDisplayColumns());
            }
            case 8: {
                return String.valueOf(this.getSeparation());
            }
            case 11: {
                return String.valueOf(this.getCellY());
            }
            case 12: {
                return String.valueOf(this.getCellX());
            }
            case 13: {
                return String.valueOf(this.getColumnColor());
            }
            case 14: {
                return String.valueOf(this.getRowColor());
            }
            case 15: {
                return String.valueOf(this.getCellColor());
            }
            case 19: {
                return String.valueOf(this.getBitmap());
            }
            case 20: {
                return String.valueOf(this.getBitmapNumber());
            }
            case 21: {
                return String.valueOf(this.getBitmapWidth());
            }
            case 22: {
                return String.valueOf(this.getBitmapTrailing());
            }
            case 23: {
                return String.valueOf(this.getNumRows());
            }
            case 24: {
                return String.valueOf(this.getCursorY());
            }
            case 25: {
                return String.valueOf(this.getCursorX());
            }
            case 26: {
                return String.valueOf(this.getCursorFrameWidth());
            }
            case 27: {
                return String.valueOf(this.getVirtualWidth());
            }
            case 29: {
                return String.valueOf(this.getCursorColor());
            }
            case 30: {
                return String.valueOf(this.getHeadingColor());
            }
            case 31: {
                return String.valueOf(this.getHeadingFont());
            }
            case 32: {
                return String.valueOf(this.getHeadingDividerColor());
            }
            case 33: {
                return String.valueOf(this.getStartX());
            }
            case 34: {
                return String.valueOf(this.getStartY());
            }
            case 35: {
                return String.valueOf(this.getRegionColor());
            }
            case 36: {
                return String.valueOf(this.getMassUpdate());
            }
            case 37: {
                return this.getHiddenData();
            }
            case 38: {
                return String.valueOf(this.getEndColor());
            }
            case 39: {
                return String.valueOf(this.getFilePos());
            }
            case 40: {
                return String.valueOf(this.getNumColHeadings());
            }
            case 4097: {
                return this.getRecordToAdd();
            }
            case 4098: {
                return String.valueOf(this.getResetGrid());
            }
            case 4099: {
                return this.getCellData();
            }
            case 4101: {
                return this.getRecordData();
            }
            case 4102: {
                return String.valueOf(this.getLastRow());
            }
            case 4103: {
                return String.valueOf(this.getVscrollPos());
            }
            case 4104: {
                return String.valueOf(this.getHscrollPos());
            }
            case 4106: {
                return this.getSearchText();
            }
        }
        return super.getProperty(number);
    }

    public void setAction(int value) {
        switch (value) {
            case 10: {
                this.doFirstPage();
                break;
            }
            case 11: {
                this.doLastPage();
                break;
            }
            case 12: {
                this.doCurrentPage();
            }
        }
    }

    public void setAction(String value) {
        try {
            this.setAction(Integer.parseInt(value.trim()));
        }
        catch (Exception e) {
            LGrid.log(e);
        }
    }

    public void doFirstPage() {
        this.pageFirst();
    }

    public void doLastPage() {
        this.pageLast();
    }

    public void doCurrentPage() {
        if (!this.pagedAtEnd) {
            this.processAcceptEvent(new AcceptEvent(this.getHandle(), 0, 16421, null));
        }
    }

    public void setAlignment(String value) {
        try {
            int align = 0;
            if (value != null && value.length() > 0) {
                switch (value.charAt(0)) {
                    case 'L': 
                    case 'l': {
                        align = 1;
                        break;
                    }
                    case 'R': 
                    case 'r': {
                        align = 2;
                        break;
                    }
                    case 'C': 
                    case 'c': {
                        align = 3;
                        break;
                    }
                    case 'U': 
                    case 'u': {
                        align = 0;
                        break;
                    }
                    case '>': {
                        align = 5;
                        break;
                    }
                    case '<': {
                        align = 4;
                    }
                }
            }
            this.setAlignment(align);
        }
        catch (Throwable catchAll) {
            LGrid.log(catchAll);
        }
    }

    public void setAlignment(int align) {
        try {
            this.getTableCellModel().setColumnAlignment(align);
            this.refresh();
        }
        catch (Throwable catchAll) {
            LGrid.log(catchAll);
        }
    }

    public void setDragEvents(boolean state) {
        this.enableDragEvents = state;
    }

    public void setDragEvents(int state) {
        this.setDragEvents(state != 0);
    }

    public boolean isDragEvents() {
        return this.enableDragEvents;
    }

    public int getDragEvents() {
        return this.enableDragEvents ? 1 : 0;
    }

    public void setBitmap(int value) {
        try {
            this.setBitmap(Handle.getHandle(value));
        }
        catch (Throwable t) {
            LGrid.log(t);
        }
    }

    public int getBitmap() {
        return this.bitmapHandle;
    }

    public void setBitmap(Handle value) {
        try {
            if (value == null) {
                this.setBitmap(0, null);
            } else {
                this.setBitmap(value.getHandleNumber(), (LBitmap)value.getComponent());
            }
        }
        catch (Throwable t) {
            LGrid.log(t);
        }
    }

    public void setBitmapValue(String resourceName) {
        this.setBitmap(0, new LBitmap(resourceName));
    }

    public void setBitmap(LBitmap component) {
        this.setBitmap(0, component);
    }

    public void setBitmap(int handle, LBitmap component) {
        try {
            this.bitmapHandle = handle;
            this.bitmapComponent = component;
            this.refreshBitmap();
        }
        catch (Throwable catchAll) {
            LGrid.log(catchAll);
        }
    }

    public void setBitmapWidth(int value) {
        this.bitmapWidth = value;
        this.refreshBitmap();
    }

    public int getBitmapWidth() {
        return this.bitmapWidth;
    }

    public void setBitmapNumber(int value) {
        this.bitmapNumber = value;
        this.refreshBitmap();
    }

    public int getBitmapNumber() {
        return this.bitmapNumber;
    }

    private void refreshBitmap() {
        try {
            LBitmapIcon icon = null;
            if (this.bitmapComponent != null) {
                if (this.bitmapNumber < 1) {
                    this.bitmapNumber = 1;
                }
                icon = this.bitmapWidth > 0 ? new LBitmapIcon(this.bitmapComponent, this.bitmapNumber, this.bitmapWidth) : new LBitmapIcon(this.bitmapComponent, this.bitmapNumber, 16);
            }
            this.getTableCellModel().getTableCell(this.y - 1, this.x - 1).setBitmap(icon);
            if (this.y == 1 && this.x == 1) {
                this.updateCornerComponent();
            }
            this.refresh();
        }
        catch (Throwable catchAll) {
            LGrid.log(catchAll);
        }
    }

    public void setBitmapTrailing(int value) {
        try {
            this.setBitmapTrailing(value != 0);
        }
        catch (Throwable catchAll) {
            LGrid.log(catchAll);
        }
    }

    public int getBitmapTrailing() {
        return this.isBitmapTrailing() ? 1 : 0;
    }

    public void setBitmapTrailing(boolean state) {
        try {
            this.getTableCellModel().getTableCell(this.y - 1, this.x - 1).setBitmapTrailing(state);
            if (this.y == 1 && this.x == 1) {
                this.updateCornerComponent();
            }
        }
        catch (Throwable catchAll) {
            LGrid.log(catchAll);
        }
    }

    public boolean isBitmapTrailing() {
        return this.getTableCellModel().getTableCell(this.y - 1, this.x - 1).isBitmapTrailing();
    }

    public void setCellColor(int value) {
        try {
            TableCellModel model = this.getTableCellModel();
            Color fore = this.getComplexForegroundColor(value);
            Color back = this.getComplexBackgroundColor(value);
            model.setForeground(fore, this.y - 1, this.x - 1);
            model.setBackground(back, this.y - 1, this.x - 1);
        }
        catch (Throwable catchAll) {
            LGrid.log(catchAll);
        }
    }

    public void setCellBackground(int value) {
        try {
            TableCellModel model = this.getTableCellModel();
            model.setBackground(LGrid.getCobolColor(value), this.y - 1, this.x - 1);
        }
        catch (Throwable catchAll) {
            LGrid.log(catchAll);
        }
    }

    public void setCellBackgroundRGB(int rgb) {
        try {
            TableCellModel model = this.getTableCellModel();
            model.setBackground(new Color(rgb), this.y - 1, this.x - 1);
        }
        catch (Throwable catchAll) {
            LGrid.log(catchAll);
        }
    }

    public void setCellForeground(int value) {
        try {
            TableCellModel model = this.getTableCellModel();
            model.setForeground(LGrid.getCobolColor(value), this.y - 1, this.x - 1);
        }
        catch (Throwable catchAll) {
            LGrid.log(catchAll);
        }
    }

    public void setCellForegroundRGB(int rgb) {
        try {
            TableCellModel model = this.getTableCellModel();
            model.setForeground(new Color(rgb), this.y - 1, this.x - 1);
        }
        catch (Throwable catchAll) {
            LGrid.log(catchAll);
        }
    }

    public int getCellColor() {
        try {
            int back = this.getCellBackground() + 1;
            int fore = this.getCellForeground() + 1;
            return fore + back * 32;
        }
        catch (Throwable catchAll) {
            LGrid.log(catchAll);
            return 0;
        }
    }

    public int getCellBackground() {
        try {
            TableCellModel model = this.getTableCellModel();
            return this.getClosestColorIndex(model.getBackground(this.y - 1, this.x - 1));
        }
        catch (Throwable catchAll) {
            LGrid.log(catchAll);
            return 0;
        }
    }

    public int getCellBackgroundRGB() {
        try {
            TableCellModel model = this.getTableCellModel();
            return model.getBackground(this.y, this.x).getRGB();
        }
        catch (Throwable catchAll) {
            LGrid.log(catchAll);
            return 0;
        }
    }

    public int getCellForeground() {
        try {
            TableCellModel model = this.getTableCellModel();
            return this.getClosestColorIndex(model.getForeground(this.y - 1, this.x - 1));
        }
        catch (Throwable catchAll) {
            LGrid.log(catchAll);
            return 0;
        }
    }

    public int getCellForegroundRGB() {
        try {
            TableCellModel model = this.getTableCellModel();
            return model.getForeground(this.y - 1, this.x - 1).getRGB();
        }
        catch (Throwable catchAll) {
            LGrid.log(catchAll);
            return 0;
        }
    }

    public void setCellData(String value) {
        this.setCellData(value, this.y, this.x);
    }

    public void setCellData(String value, int row, int col) {
        try {
            TableCellModel model = this.getTableCellModel();
            model.setDataAt(value != null ? value : "", row - 1, col - 1);
        }
        catch (Throwable catchAll) {
            LGrid.log(catchAll);
        }
    }

    public String getCellData() {
        String data = this.getCellData(this.y, this.x);
        return data != null ? data : "";
    }

    public String getCellData(int y, int x) {
        try {
            TableCellModel model = this.getTableCellModel();
            Object value = model.getDataAt(y - 1, x - 1);
            return value != null ? (String)value : "";
        }
        catch (Throwable catchAll) {
            LGrid.log(catchAll);
            return null;
        }
    }

    public void setCellFont(int value) {
        try {
            this.setCellFont(Handle.getFont(value));
        }
        catch (Throwable catchAll) {
            LGrid.log(catchAll);
        }
    }

    @Override
    public void setCellFont(Font value) {
        try {
            TableCellModel model = this.getTableCellModel();
            model.setFont(value, this.y - 1, this.x - 1);
        }
        catch (Throwable catchAll) {
            LGrid.log(catchAll);
        }
    }

    public void setCellFont(Handle h) {
        this.setCellFont(h.getFont());
    }

    public void setCellFontName(String name) {
        this.setCellFont(Handle.decodeFont(name));
    }

    public void setColumnColor(int value) {
        try {
            this.setColumnForeground(this.getComplexForegroundColor(value));
            this.setColumnBackground(this.getComplexBackgroundColor(value));
        }
        catch (Throwable catchAll) {
            LGrid.log(catchAll);
        }
    }

    public void setColumnForeground(int color2) {
        this.setColumnForeground(LGrid.getCobolColor(color2));
    }

    public void setColumnBackground(int color2) {
        this.setColumnBackground(LGrid.getCobolColor(color2));
    }

    public void setColumnForegroundRGB(int rgb) {
        this.setColumnForeground(new Color(rgb));
    }

    public void setColumnBackgroundRGB(int rgb) {
        this.setColumnBackground(new Color(rgb));
    }

    public void setColumnForeground(Color fore) {
        try {
            this.getTableCellModel().setColumnForeground(fore, this.x - 1);
        }
        catch (Throwable catchAll) {
            LGrid.log(catchAll);
        }
    }

    public void setColumnBackground(Color back) {
        try {
            this.getTableCellModel().setColumnBackground(back, this.x - 1);
        }
        catch (Throwable catchAll) {
            LGrid.log(catchAll);
        }
    }

    public int getColumnColor() {
        int back = this.getColumnBackground() + 1;
        int fore = this.getColumnForeground() + 1;
        return fore + back * 32;
    }

    public int getColumnBackground() {
        return this.getClosestColorIndex(this.getTableCellModel().getColumnBackground(this.x - 1));
    }

    public int getColumnBackgroundRGB() {
        return this.getTableCellModel().getColumnBackground(this.x - 1).getRGB();
    }

    public int getColumnForeground() {
        return this.getClosestColorIndex(this.getTableCellModel().getColumnForeground(this.x - 1));
    }

    public int getColumnForegroundRGB() {
        return this.getTableCellModel().getColumnForeground(this.x - 1).getRGB();
    }

    public void setColumnDividers(int widthInPixels) {
        try {
            TableCellModel model = this.getTableCellModel();
            model.setColumnDividers(widthInPixels);
        }
        catch (Throwable catchAll) {
            LGrid.log(catchAll);
        }
    }

    public void setColumnFont(int value) {
        this.setColumnFont(Handle.getFont(value));
    }

    public void setColumnFont(Font value) {
        try {
            TableCellModel model = this.getTableCellModel();
            model.setColumnFont(value, this.x - 1);
        }
        catch (Throwable catchAll) {
            LGrid.log(catchAll);
        }
    }

    public void setColumnFont(Handle h) {
        this.setColumnFont(h.getFont());
    }

    public void setColumnFontName(String name) {
        this.setColumnFont(Handle.decodeFont(name));
    }

    public void setCursorColor(int value) {
        try {
            Color fore = this.getComplexForegroundColor(value);
            Color back = this.getComplexBackgroundColor(value);
            this.setCursorForeground(fore);
            this.setCursorBackground(back);
        }
        catch (Throwable catchAll) {
            LGrid.log(catchAll);
        }
    }

    public void setCursorForegroundRGB(int rgb) {
        this.setCursorForeground(new Color(rgb));
    }

    public void setCursorBackgroundRGB(int rgb) {
        this.setCursorBackground(new Color(rgb));
    }

    public void setCursorForeground(int value) {
        this.setCursorForeground(LGrid.getCobolColor(value));
    }

    public void setCursorBackground(int value) {
        this.setCursorBackground(LGrid.getCobolColor(value));
    }

    public void setCursorForeground(Color color2) {
        this.getTableCellModel().setCursorForeground(color2);
    }

    public void setCursorBackground(Color color2) {
        this.getTableCellModel().setCursorBackground(color2);
    }

    public int getCursorColor() {
        int fore = this.getCursorForeground() + 1;
        int back = this.getCursorBackground() + 1;
        return fore + back * 16;
    }

    public int getCursorForegroundRGB() {
        return this.getTableCellModel().getCursorForeground().getRGB();
    }

    public int getCursorBackgroundRGB() {
        return this.getTableCellModel().getCursorBackground().getRGB();
    }

    public int getCursorForeground() {
        return this.getClosestColorIndex(this.getTableCellModel().getCursorForeground());
    }

    public int getCursorBackground() {
        return this.getClosestColorIndex(this.getTableCellModel().getCursorBackground());
    }

    public void setEditableColor(int value) {
        try {
            Color fore = this.getComplexForegroundColor(value);
            Color back = this.getComplexBackgroundColor(value);
            this.setEditableForeground(fore);
            this.setEditableBackground(back);
        }
        catch (Throwable catchAll) {
            LGrid.log(catchAll);
        }
    }

    public void setEditableForegroundRGB(int rgb) {
        this.setEditableForeground(new Color(rgb));
    }

    public void setEditableBackgroundRGB(int rgb) {
        this.setEditableBackground(new Color(rgb));
    }

    public void setEditableForeground(int value) {
        this.setEditableForeground(LGrid.getCobolColor(value));
    }

    public void setEditableBackground(int value) {
        this.setEditableBackground(LGrid.getCobolColor(value));
    }

    public void setEditableForeground(Color color2) {
        this.getTableCellModel().setEditableForeground(color2);
    }

    public void setEditableBackground(Color color2) {
        this.getTableCellModel().setEditableBackground(color2);
    }

    public void setCursorFrameWidth(int value) {
        try {
            this.getTableCellModel().setCursorFrameWidth(value);
        }
        catch (Throwable catchAll) {
            LGrid.log(catchAll);
        }
    }

    public int getCursorFrameWidth() {
        return this.getTableCellModel().getCursorFrameWidth();
    }

    public void setCursorX(int value) {
        try {
            int cursorx = value - 1;
            this.internalCursorPositioning = true;
            if (cursorx >= 0) {
                this.jTable.setColumnSelectionInterval(cursorx, cursorx);
            }
            this.internalCursorPositioning = false;
        }
        catch (Throwable t) {
            LGrid.log(t);
        }
    }

    public int getCursorX() {
        try {
            return this.jTable.getSelectedColumn() + 1;
        }
        catch (Throwable t) {
            LGrid.log(t);
            return 1;
        }
    }

    public void setCursorY(int value) {
        try {
            int cursory = value - 1 - this.numberOfColumnHeadings;
            this.internalCursorPositioning = true;
            if (cursory >= 0) {
                this.jTable.setRowSelectionInterval(cursory, cursory);
            }
            this.internalCursorPositioning = false;
        }
        catch (Throwable t) {
            LGrid.log(t);
        }
    }

    public int getCursorY() {
        try {
            return this.jTable.getSelectedRow() + this.numberOfColumnHeadings + 1;
        }
        catch (Throwable t) {
            LGrid.log(t);
            return 1;
        }
    }

    public void setDataColumns(int value) {
        try {
            if (value < 0) {
                this.dataColumns = null;
                this.refresh();
                return;
            }
            if (this.dataColumns == null) {
                this.dataColumns = value == 1 ? new int[]{1} : new int[]{1, value};
                this.refresh();
                return;
            }
            int oldDataColumnsLength = this.dataColumns.length;
            int[] newDataColumns = new int[oldDataColumnsLength + 1];
            System.arraycopy(this.dataColumns, 0, newDataColumns, 0, oldDataColumnsLength);
            int col = newDataColumns.length - 1;
            newDataColumns[col] = value;
            this.dataColumns = newDataColumns;
            this.refresh();
        }
        catch (Throwable catchAll) {
            LGrid.log(catchAll);
        }
    }

    public int getDataColumns() {
        return this.dataColumns != null ? this.dataColumns.length : 0;
    }

    public int getDataColumn(int col) {
        try {
            if (this.dataColumns == null || col < 0 || col >= this.dataColumns.length) {
                return -1;
            }
            return this.dataColumns[col];
        }
        catch (Throwable catchAll) {
            LGrid.log(catchAll);
            return 0;
        }
    }

    public int getDataColumnSize(int col) {
        if (--col < 0) {
            return -1;
        }
        if (this.dataColumns == null) {
            return -1;
        }
        if (col >= this.dataColumns.length - 1) {
            return -1;
        }
        int size = this.dataColumns[col + 1] - this.dataColumns[col];
        return size <= 0 ? -1 : size;
    }

    public void setDataSizes(int value) {
        try {
            if (value < 0) {
                this.dataColumns = null;
                this.refresh();
                return;
            }
            if (this.dataColumns == null) {
                this.dataColumns = new int[]{1, value + 1};
                this.refresh();
                return;
            }
            int[] newDataColumns = new int[this.dataColumns.length + 1];
            System.arraycopy(this.dataColumns, 0, newDataColumns, 0, this.dataColumns.length);
            newDataColumns[newDataColumns.length - 1] = value + newDataColumns[newDataColumns.length - 2];
            this.dataColumns = newDataColumns;
            this.refresh();
        }
        catch (Throwable catchAll) {
            LGrid.log(catchAll);
        }
    }

    public int getDataSizes() {
        return this.getDataColumns();
    }

    public int getDataSize(int col) {
        return this.getDataColumn(col);
    }

    public void setDataTypes(String value) {
        this.getTableCellModel().setDataType(value);
    }

    public void setDisplayColumns(int value) {
        try {
            if (value >= 0) {
                int previous;
                int width;
                if (this.displayColumns == null) {
                    this.numberOfRowsPerRecord = 1;
                    this.numberOfColumnsPerRecord = 0;
                    this.displayColumns = new int[]{1};
                    if (value == 1) {
                        return;
                    }
                }
                if ((width = value - (previous = this.displayColumns[this.displayColumns.length - 1])) < 0) {
                    return;
                }
                int[] newDisplayColumns = new int[this.displayColumns.length + 1];
                System.arraycopy(this.displayColumns, 0, newDisplayColumns, 0, this.displayColumns.length);
                int col = newDisplayColumns.length - 1;
                newDisplayColumns[col] = value;
                this.displayColumns = newDisplayColumns;
                if (value < previous) {
                    ++this.numberOfRowsPerRecord;
                    if (this.numberOfColumnsPerRecord == 0) {
                        this.numberOfColumnsPerRecord = this.displayColumns.length - 1;
                        if (this.numberOfColumnsPerRecord < 1) {
                            this.numberOfColumnsPerRecord = 0;
                        }
                    }
                }
                if (this.numberOfRowsPerRecord > 1) {
                    return;
                }
                int columnNumber = this.displayColumns.length - 2;
                int widthInPixels = width * this.getUnitWidth();
                this.getTableCellModel().setColumnWidth(columnNumber, widthInPixels);
                if (columnNumber == 0 && this.numberOfRowHeadings >= 1) {
                    this.rowHeader.setFixedCellWidth(widthInPixels);
                }
            } else {
                this.displayColumns = null;
                this.numberOfRowsPerRecord = 1;
                this.numberOfColumnsPerRecord = 0;
            }
            this.refresh();
        }
        catch (Exception e) {
            LGrid.log(e);
        }
    }

    public int getDisplayColumn(int column) {
        try {
            if (this.displayColumns == null) {
                return -1;
            }
            if (column >= 0 && column < this.displayColumns.length) {
                return this.displayColumns[column];
            }
            return -1;
        }
        catch (Throwable catchAll) {
            LGrid.log(catchAll);
            return -1;
        }
    }

    public int getDisplayColumns() {
        return this.displayColumns != null ? this.displayColumns.length : 0;
    }

    public int getCellSelected() {
        return this.jTable.isCellSelected(this.y - 1, this.x - 1) ? 1 : 0;
    }

    public int getRowSelected(int row) {
        return this.jTable.isRowSelected(row - 1) ? 1 : 0;
    }

    public int getColumnSelected(int col) {
        return this.jTable.isColumnSelected(col - 1) ? 1 : 0;
    }

    public int getSelectedRowCount() {
        return this.jTable.getSelectedRowCount();
    }

    public int getSelectedColumnCount() {
        return this.jTable.getSelectedColumnCount();
    }

    public void selectAll() {
        this.jTable.selectAll();
    }

    public void clearAll() {
        this.jTable.clearSelection();
    }

    public void setSelectionMode(int value) {
        this.jTable.setSelectionMode(value);
    }

    public void editCell() {
        try {
            this.jTable.editCellAt(this.y - 1, this.x - 1);
        }
        catch (Throwable catchAll) {
            LGrid.log(catchAll);
        }
    }

    public void setEditingColumn(int column) {
        try {
            this.jTable.setEditingColumn(column - 1);
        }
        catch (Throwable catchAll) {
            LGrid.log(catchAll);
        }
    }

    public int getEditingColumn() {
        try {
            return this.jTable.getEditingColumn() + 1;
        }
        catch (Throwable catchAll) {
            LGrid.log(catchAll);
            return 0;
        }
    }

    public void setEditingRow(int row) {
        try {
            this.jTable.setEditingRow(row - 1);
        }
        catch (Throwable catchAll) {
            LGrid.log(catchAll);
        }
    }

    public int getEditingRow() {
        try {
            return this.jTable.getEditingRow() + 1;
        }
        catch (Throwable catchAll) {
            LGrid.log(catchAll);
            return 0;
        }
    }

    public int getEditing() {
        try {
            return this.jTable.isEditing() ? 1 : 0;
        }
        catch (Throwable catchAll) {
            LGrid.log(catchAll);
            return 0;
        }
    }

    public void setDividerColor(int value) {
        try {
            this.setDividerColor(LGrid.getCobolColor(value));
        }
        catch (Throwable catchAll) {
            LGrid.log(catchAll);
        }
    }

    public void setDividerColorRGB(int value) {
        this.setDividerColor(new Color(value));
    }

    public void setDividerColor(Color value) {
        this.getTableCellModel().setDividerColor(value);
    }

    public int getDividerColor() {
        return this.getClosestColorIndex(this.getTableCellModel().getDividerColor()) + 1;
    }

    public int getDividerColorRGB() {
        return this.getTableCellModel().getDividerColor().getRGB();
    }

    public void setEndColor(int value) {
        try {
            if (value == 0) {
                this.setEndColor(SystemColor.control);
            } else {
                this.setEndColor(LGrid.getCobolColor(value));
            }
        }
        catch (Throwable catchAll) {
            LGrid.log(catchAll);
        }
    }

    public void setEndColorRGB(int value) {
        this.setEndColor(new Color(value));
    }

    public void setEndColor(Color value) {
        this.getTableCellModel().setEndColor(value);
    }

    public int getEndColor() {
        return this.getClosestColorIndex(this.getTableCellModel().getEndColor()) + 1;
    }

    public int getEndColorRGB() {
        return this.getTableCellModel().getEndColor().getRGB();
    }

    public final void setFilePos(int value) {
        this.pagedAtStart = false;
        this.pagedAtEnd = false;
        if (value == 2147418113) {
            this.setPagedAtStart();
        } else if (value == 2147418114) {
            this.setPagedAtEnd();
        } else if (value == 2147418115) {
            this.setPagedEmpty();
        }
        this.filePos = value;
    }

    public void setPagedAtStart() {
        this.filePos = 2147418113;
        this.pagedAtStart = true;
    }

    public void setPagedAtEnd() {
        this.filePos = 2147418114;
        this.pagedAtEnd = true;
    }

    public void setPagedEmpty() {
        this.setPagedAtStart();
        this.setPagedAtEnd();
        this.filePos = 2147418115;
    }

    public int getFilePos() {
        return this.filePos;
    }

    public int getPagePos() {
        return this.getFilePos();
    }

    private void checkFilePos(int recordIndex) {
        if (recordIndex == this.numberOfColumnHeadings + 1) {
            this.setFilePos(recordIndex);
        } else if (recordIndex == this.getTableCellModel().getRowSize() + 1) {
            this.setFilePos(recordIndex);
        }
    }

    public void setHeadingColor(int value) {
        try {
            this.setHeadingForeground(this.getComplexForegroundColor(value));
            this.setHeadingBackground(this.getComplexBackgroundColor(value));
        }
        catch (Throwable catchAll) {
            LGrid.log(catchAll);
        }
    }

    public void setHeadingBackground(Color c) {
        this.rowHeaderRenderer.setHeadingBackground(c);
        this.columnHeaderRenderer.setHeadingBackground(c);
    }

    public void setHeadingBackground(int value) {
        this.setHeadingBackground(LGrid.getCobolColor(value));
    }

    public void setHeadingBackgroundRGB(int rgb) {
        this.setHeadingBackground(new Color(rgb));
    }

    public void setHeadingForeground(Color c) {
        this.rowHeaderRenderer.setHeadingForeground(c);
        this.columnHeaderRenderer.setHeadingForeground(c);
    }

    public void setHeadingForeground(int value) {
        this.setHeadingForeground(LGrid.getCobolColor(value));
    }

    public void setHeadingForegroundRGB(int rgb) {
        this.setHeadingForeground(new Color(rgb));
    }

    public int getHeadingColor() {
        int back = this.getHeadingBackground() + 1;
        int fore = this.getHeadingForeground() + 1;
        return fore + back * 32;
    }

    public int getHeadingBackground() {
        return this.getClosestColorIndex(this.rowHeaderRenderer.getHeadingBackground());
    }

    public int getHeadingBackgroundRGB() {
        return this.rowHeaderRenderer.getHeadingBackground().getRGB();
    }

    public int getHeadingForeground() {
        return this.getClosestColorIndex(this.rowHeaderRenderer.getHeadingForeground());
    }

    public int getHeadingForegroundRGB() {
        return this.rowHeaderRenderer.getHeadingForeground().getRGB();
    }

    public void setHeadingDividerColor(int value) {
        try {
            if (value == 0) {
                this.setHeadingDividerColor(SystemColor.control);
            } else {
                this.setHeadingDividerColor(LGrid.getCobolColor(value));
            }
        }
        catch (Throwable catchAll) {
            LGrid.log(catchAll);
        }
    }

    public void setHeadingDividerColorRGB(int value) {
        this.setHeadingDividerColor(new Color(value));
    }

    public void setHeadingDividerColor(Color value) {
        this.rowHeaderRenderer.setHeadingDivider(value);
        this.columnHeaderRenderer.setHeadingDivider(value);
    }

    public int getHeadingDividerColor() {
        return this.getClosestColorIndex(this.rowHeaderRenderer.getHeadingDivider()) + 1;
    }

    public int getHeadingDividerColorRGB() {
        return this.rowHeaderRenderer.getHeadingDivider().getRGB();
    }

    public void setHeadingFont(int value) {
        this.setHeadingFont(Handle.getFont(value));
    }

    public void setHeadingFont(Font value) {
        this.rowHeaderRenderer.setHeadingFont(value);
        this.columnHeaderRenderer.setHeadingFont(value);
    }

    public void setHeadingFont(Handle h) {
        this.setHeadingFont(h.getFont());
    }

    public void setHeadingFontName(String name) {
        this.setHeadingFont(Handle.decodeFont(name));
    }

    public int getHeadingFont() {
        return 0;
    }

    public void setHiddenData(String value) {
        try {
            this.getTableCellModel().setHiddenData(value, this.y - 1, this.x - 1);
        }
        catch (Throwable catchAll) {
            LGrid.log(catchAll);
        }
    }

    public String getHiddenData() {
        String data = this.getHiddenData(this.y, this.x);
        return data != null ? data : "";
    }

    public String getHiddenData(int y, int x) {
        try {
            TableCellModel model = this.getTableCellModel();
            String value = model.getHiddenData(y - 1, x - 1);
            return value != null ? value : "";
        }
        catch (Throwable catchAll) {
            LGrid.log(catchAll);
            return null;
        }
    }

    public void setEditable(boolean value) {
        try {
            this.getTableCellModel().setCellEditable(value, this.y - 1 - this.numberOfColumnHeadings, this.x - 1);
        }
        catch (Throwable catchAll) {
            LGrid.log(catchAll);
        }
    }

    public boolean isEditable() {
        try {
            return this.getTableCellModel().isCellEditable(this.y - 1 - this.numberOfColumnHeadings, this.x - 1);
        }
        catch (Throwable catchAll) {
            LGrid.log(catchAll);
            return false;
        }
    }

    public int getEditable() {
        return this.isEditable() ? 1 : 0;
    }

    public int getHscrollPos() {
        try {
            Point p = SwingUtilities.convertPoint(this.scrollpane.getViewport(), new Point(0, 0), this.jTable);
            return this.jTable.columnAtPoint(p);
        }
        catch (Throwable catchAll) {
            LGrid.log(catchAll);
            return 0;
        }
    }

    public void setInsertRows(int rowsToInsert) {
        try {
            this.insertRecord(this.insertionIndex == 0 ? this.getTableCellModel().getRowSize() + 1 : this.insertionIndex, rowsToInsert);
            this.insertionIndex = 0;
        }
        catch (Throwable catchAll) {
            LGrid.log(catchAll);
        }
    }

    public void setInsertionIndex(int value) {
        if (value < 0) {
            value = 0;
        }
        this.insertionIndex = value;
    }

    public int getInsertionIndex() {
        return this.insertionIndex;
    }

    public int getLastRow() {
        try {
            return this.getTableCellModel().getLastRow() + 1;
        }
        catch (Throwable catchAll) {
            LGrid.log(catchAll);
            return 0;
        }
    }

    public void setMassUpdate(int value) {
        this.setMassUpdate(value != 0);
    }

    public void setMassUpdate(boolean value) {
        this.getTableCellModel().setMassUpdate(value);
    }

    public int getMassUpdate() {
        return this.getTableCellModel().isMassUpdate() ? 1 : 0;
    }

    public void setNumColHeadings(int value) {
        if (value < 0) {
            return;
        }
        try {
            boolean columnHeadings;
            boolean bl = columnHeadings = (this.style & 0x10) == 16;
            if (columnHeadings) {
                ++value;
            }
            if (value < 0) {
                value = 0;
            }
            if (value > 1) {
                value = 1;
            }
            if (value == this.numberOfColumnHeadings) {
                return;
            }
            if (value >= 0) {
                this.numberOfColumnHeadings = value;
                if (this.numberOfColumnHeadings >= 1) {
                    if (this.scrollpane.getColumnHeader() == null) {
                        this.scrollpane.setColumnHeader(this.backupColumnHeaderView);
                    }
                } else {
                    this.backupColumnHeaderView = this.scrollpane.getColumnHeader();
                    this.scrollpane.setColumnHeader(null);
                }
            }
            this.getTableCellModel().setNumberOfColumnHeadings(value);
            this.getTableCellModel().fireTableStructureChanged();
            this.refresh();
        }
        catch (Exception e) {
            LGrid.log(e);
        }
    }

    public int getNumColHeadings() {
        boolean columnHeadings = (this.style & 0x10) == 16;
        return columnHeadings ? this.numberOfColumnHeadings - 1 : this.numberOfColumnHeadings;
    }

    public int getInternalColumnHeadings() {
        return this.numberOfColumnHeadings;
    }

    public void setNumRowHeadings(int value) {
        if (value < 0) {
            return;
        }
        try {
            boolean rowHeadings;
            boolean bl = rowHeadings = (this.style & 0x20) == 32;
            if (rowHeadings) {
                ++value;
            }
            if (value < 0) {
                value = 0;
            }
            if (value > 1) {
                value = 1;
            }
            if (value == this.numberOfRowHeadings) {
                return;
            }
            TableCellModel model = this.getTableCellModel();
            if (value >= 0) {
                this.numberOfRowHeadings = value;
                if (this.numberOfRowHeadings >= 1) {
                    this.rowHeader.setVisible(true);
                    int width = this.getTableCellModel().getColumnWidth(0);
                    if (width < 0) {
                        width = 75;
                    }
                    this.rowHeader.setFixedCellWidth(width);
                } else {
                    this.rowHeader.setVisible(false);
                    this.rowHeader.setFixedCellWidth(0);
                }
            }
            if (model != null) {
                model.setNumberOfRowHeadings(value);
            }
            this.refresh();
        }
        catch (Exception e) {
            LGrid.log(e);
        }
    }

    public int getNumRowHeadings() {
        boolean rowHeadings = (this.style & 0x20) == 32;
        int value = rowHeadings ? this.numberOfRowHeadings - 1 : this.numberOfRowHeadings;
        return value;
    }

    public int getInternalRowHeadings() {
        return this.numberOfRowHeadings;
    }

    public void setNumRowsPerRecord(int value) {
        if (value >= 1) {
            this.numberOfRowsPerRecord = value;
            this.numberOfColumnsPerRecord = 0;
        }
    }

    public int getNumRowsPerRecord() {
        return this.numberOfRowsPerRecord;
    }

    public int getNumRowsAddition() {
        try {
            return this.getTableCellModel().getNumRowsAddition();
        }
        catch (Throwable catchAll) {
            LGrid.log(catchAll);
            return 0;
        }
    }

    public void setNumRows(int value) {
        try {
            int maximumRow = this.getTableCellModel().getRowSize();
            int numRowsAddition = 0;
            if (value < 0) {
                numRowsAddition = 1;
            } else if (value > 0) {
                maximumRow = value;
            }
            this.getTableCellModel().setMaximumRows(maximumRow, numRowsAddition);
        }
        catch (Throwable catchAll) {
            LGrid.log(catchAll);
        }
    }

    public int getNumRows() {
        try {
            return this.getTableCellModel().getRowSize();
        }
        catch (Throwable catchAll) {
            LGrid.log(catchAll);
            return 0;
        }
    }

    public void setNumColumns(int value) {
        try {
            this.getTableCellModel().setMaximumColumns(value);
        }
        catch (Throwable catchAll) {
            LGrid.log(catchAll);
        }
    }

    public int getNumColumns() {
        try {
            return this.getTableCellModel().getColumnSize();
        }
        catch (Throwable catchAll) {
            LGrid.log(catchAll);
            return 0;
        }
    }

    public void setRecordData(String value) {
        try {
            this.placeRecordAt(value, this.y);
        }
        catch (Throwable catchAll) {
            LGrid.log(catchAll);
        }
    }

    public String getRecordData() {
        return this.getRecordData(this.y);
    }

    public String getRecordData(int rowNumber) {
        try {
            if (this.dataColumns == null) {
                StringBuffer result = new StringBuffer(256);
                int maximumColumn = this.getTableCellModel().getColumnSize();
                for (int i = 1; i <= maximumColumn; ++i) {
                    result.append(this.getCellData(rowNumber, i));
                }
                return result.toString();
            }
            StringBuffer result = new StringBuffer(256);
            int size = this.getDataColumns();
            String currentCell = null;
            int currentSize = 0;
            int finish = -1;
            int start = -1;
            try {
                int progress = 0;
                finish = this.getDataColumn(progress);
                if (finish == 1) {
                    ++progress;
                }
                for (int col = 1; col <= size; ++col) {
                    start = finish;
                    if (start < 0) {
                        currentSize = -1;
                    } else if (progress < size - 2) {
                        finish = this.getDataColumn(++progress);
                        currentSize = finish - start;
                    } else {
                        finish = -1;
                        currentSize = -1;
                    }
                    currentCell = this.getCellData(rowNumber, col);
                    if (currentSize == -1) {
                        result.append(currentCell);
                        continue;
                    }
                    currentCell = currentCell.substring(0, currentSize);
                    int deficit = currentSize - currentCell.length();
                    result.append(currentCell);
                    for (int i = 0; i < deficit; ++i) {
                        result.append(' ');
                    }
                }
                return result.toString();
            }
            catch (Exception noMoreData) {
                LGrid.log(noMoreData);
            }
        }
        catch (Exception e) {
            LGrid.log(e);
        }
        return "";
    }

    public void setRecordToAdd(String record) {
        try {
            int row = 0;
            if (this.insertionIndex == 0) {
                row = this.getLastRow() + 1;
            } else {
                row = this.insertionIndex;
                this.insertRecord(row, 1);
            }
            this.placeRecordAt(record, row);
        }
        catch (Throwable catchAll) {
            LGrid.log(catchAll);
        }
    }

    public String getRecordToAdd() {
        return this.getRecordData();
    }

    public void setRecordToDelete(int value) {
        this.deleteRecord(value);
    }

    private void placeRecordAt(String record, int index) {
        block15: {
            try {
                this.checkFilePos(index);
                String value = record;
                String indi = null;
                if (this.dataColumns != null) {
                    int size = this.dataColumns.length;
                    try {
                        int dataColumn = 0;
                        int nextDataColumn = 0;
                        int width = -1;
                        for (int col = 1; col <= size; ++col) {
                            try {
                                int beginIndex;
                                dataColumn = this.dataColumns[col - 1];
                                nextDataColumn = col < this.dataColumns.length ? this.dataColumns[col] : -1;
                                indi = null;
                                if (nextDataColumn >= 0 && dataColumn >= 0) {
                                    width = nextDataColumn - dataColumn;
                                    beginIndex = dataColumn - 1;
                                    int endIndex = dataColumn - 1 + width;
                                    if (endIndex > value.length()) {
                                        endIndex = value.length();
                                    }
                                    if (beginIndex < 0) {
                                        beginIndex = 0;
                                    }
                                    if (beginIndex < endIndex) {
                                        indi = value.substring(beginIndex, endIndex);
                                    }
                                } else {
                                    width = -1;
                                    beginIndex = dataColumn - 1;
                                    if (beginIndex < 0) {
                                        beginIndex = 0;
                                    }
                                    if (beginIndex < value.length()) {
                                        indi = value.substring(beginIndex);
                                    }
                                }
                                this.setCellData(indi != null ? indi : "", index, col);
                                continue;
                            }
                            catch (Exception couldNotSetCell) {
                                LGrid.log(couldNotSetCell);
                            }
                        }
                        break block15;
                    }
                    catch (Exception noMoreData) {
                        LGrid.log(noMoreData);
                        break block15;
                    }
                }
                LGrid.log("No dataColumns!");
                this.setCellData(value, index, 1);
            }
            catch (Exception e) {
                LGrid.log(e);
            }
        }
    }

    private void insertRecord(int index, int multiple) {
        try {
            this.checkFilePos(index);
            this.getTableCellModel().insertRow(index - 1, multiple);
        }
        catch (Throwable catchAll) {
            LGrid.log(catchAll);
        }
    }

    private void deleteRecord(int index) {
        try {
            this.getTableCellModel().deleteRow(index - 1);
        }
        catch (Throwable catchAll) {
            LGrid.log(catchAll);
        }
    }

    public void setRegionColor(int value) {
        try {
            Color fore = this.getComplexForegroundColor(value);
            Color back = this.getComplexBackgroundColor(value);
            this.setRegionForeground(fore);
            this.setRegionBackground(back);
        }
        catch (Throwable catchAll) {
            LGrid.log(catchAll);
        }
    }

    public void setRegionBackground(int value) {
        this.setRegionBackground(LGrid.getCobolColor(value));
    }

    public void setRegionBackgroundRGB(int rgb) {
        this.setRegionBackground(new Color(rgb));
    }

    public void setRegionBackground(Color c) {
        if (c != null) {
            this.jTable.setSelectionBackground(c);
        }
    }

    public void setRegionForeground(int value) {
        this.setRegionForeground(LGrid.getCobolColor(value));
    }

    public void setRegionForegroundRGB(int rgb) {
        this.setRegionForeground(new Color(rgb));
    }

    public void setRegionForeground(Color c) {
        if (c != null) {
            this.jTable.setSelectionForeground(c);
        }
    }

    public int getRegionColor() {
        try {
            int back = this.getRegionBackground() + 1;
            int fore = this.getRegionForeground() + 1;
            return fore + back * 32;
        }
        catch (Throwable catchAll) {
            LGrid.log(catchAll);
            return 0;
        }
    }

    public int getRegionBackground() {
        try {
            return this.getClosestColorIndex(this.jTable.getSelectionBackground());
        }
        catch (Throwable catchAll) {
            LGrid.log(catchAll);
            return 0;
        }
    }

    public int getRegionBackgroundRGB() {
        try {
            return this.jTable.getSelectionBackground().getRGB();
        }
        catch (Throwable catchAll) {
            LGrid.log(catchAll);
            return 0;
        }
    }

    public int getRegionForeground() {
        try {
            return this.getClosestColorIndex(this.jTable.getSelectionForeground());
        }
        catch (Throwable catchAll) {
            LGrid.log(catchAll);
            return 0;
        }
    }

    public int getRegionForegroundRGB() {
        try {
            return this.jTable.getSelectionForeground().getRGB();
        }
        catch (Throwable catchAll) {
            LGrid.log(catchAll);
            return 0;
        }
    }

    public void setResetGrid(int value) {
        if (value > 0) {
            this.resetGrid();
        }
    }

    public int getResetGrid() {
        return 0;
    }

    public void resetGrid() {
        boolean listeners = this.constantListenersAdded;
        if (listeners) {
            this.removeConstantListeners();
        }
        if (this.componentListener) {
            this.jTable.removeComponentListener(this);
        }
        this.x = 1;
        this.y = 1;
        this.massUpdate = false;
        this.jTable = null;
        this.scrollpane = null;
        this.bitmapComponent = null;
        this.bitmapHandle = 0;
        this.bitmapWidth = 16;
        this.bitmapNumber = 1;
        this.dataColumns = null;
        this.displayColumns = null;
        this.filePos = 0;
        this.insertionIndex = 0;
        this.searchResult = 0;
        this.virtualWidth = 0;
        this.rowHeaderModel = null;
        this.numberOfColumnHeadings = 0;
        this.numberOfRowHeadings = 0;
        this.rowHeader = null;
        this.rowHeaderRenderer = null;
        this.columnHeaderRenderer = null;
        this.numberOfRowsPerRecord = 1;
        this.numberOfColumnsPerRecord = 0;
        this.gridSearchDirection = true;
        this.gridSearchWrapFlag = true;
        this.gridSearchCaseFlag = true;
        this.gridSearchMatchFlag = 0;
        this.gridSearchLocationFlag = 0;
        this.gridSearchSkipFlag = true;
        this.gridSearchCursorFlag = true;
        this.gridSearchColumn = 0;
        this.backupColumnHeaderView = null;
        this.cornerComponent = null;
        this.currentlyDragging = false;
        this.dragColumn = 0;
        this.dragRow = 0;
        this.internalCursorPositioning = false;
        this.internalColumnWidthPositioning = false;
        this.previousColumn = -1;
        this.previousRow = -1;
        this.removeAll();
        this.initializeGrid();
        this.refresh();
        if (listeners) {
            this.addConstantListeners();
        }
        if (this.componentListener) {
            this.jTable.addComponentListener(this);
        }
    }

    public void setRowColor(int value) {
        try {
            TableCellModel model = this.getTableCellModel();
            Color fore = this.getComplexForegroundColor(value);
            Color back = this.getComplexBackgroundColor(value);
            model.setRowForeground(this.y - 1, fore);
            model.setRowBackground(this.y - 1, back);
        }
        catch (Throwable catchAll) {
            LGrid.log(catchAll);
        }
    }

    public void setRowBackground(int value) {
        TableCellModel model = this.getTableCellModel();
        model.setRowBackground(this.y - 1, LGrid.getCobolColor(value));
    }

    public void setRowBackgroundRGB(int rgb) {
        TableCellModel model = this.getTableCellModel();
        model.setRowBackground(this.y - 1, new Color(rgb));
    }

    public void setRowForeground(int value) {
        TableCellModel model = this.getTableCellModel();
        model.setRowForeground(this.y - 1, LGrid.getCobolColor(value));
    }

    public void setRowForegroundRGB(int rgb) {
        TableCellModel model = this.getTableCellModel();
        model.setRowForeground(this.y - 1, new Color(rgb));
    }

    public int getRowColor() {
        int back = this.getRowBackground() + 1;
        int fore = this.getRowForeground() + 1;
        return fore + back * 32;
    }

    public int getRowBackground() {
        TableCellModel model = this.getTableCellModel();
        return this.getClosestColorIndex(model.getRowBackground(this.y - 1));
    }

    public int getRowBackgroundRGB() {
        TableCellModel model = this.getTableCellModel();
        return model.getRowBackground(this.y - 1).getRGB();
    }

    public int getRowForeground() {
        TableCellModel model = this.getTableCellModel();
        return this.getClosestColorIndex(model.getRowForeground(this.y - 1));
    }

    public int getRowForegroundRGB() {
        TableCellModel model = this.getTableCellModel();
        return model.getRowForeground(this.y - 1).getRGB();
    }

    public void setRowColorPattern(int value) {
        try {
            TableCellModel model = this.getTableCellModel();
            Color fore = this.getComplexForegroundColor(value);
            Color back = this.getComplexBackgroundColor(value);
            model.setRowForegroundPattern(fore);
            model.setRowBackgroundPattern(back);
        }
        catch (Throwable catchAll) {
            LGrid.log(catchAll);
        }
    }

    public void setRowBackgroundPattern(int value) {
        TableCellModel model = this.getTableCellModel();
        model.setRowBackgroundPattern(LGrid.getCobolColor(value));
    }

    public void setRowBackgroundRGBPattern(int rgb) {
        TableCellModel model = this.getTableCellModel();
        model.setRowBackgroundPattern(new Color(rgb));
    }

    public void setRowForegroundPattern(int value) {
        TableCellModel model = this.getTableCellModel();
        model.setRowForegroundPattern(LGrid.getCobolColor(value));
    }

    public void setRowForegroundRGBPattern(int rgb) {
        TableCellModel model = this.getTableCellModel();
        model.setRowForegroundPattern(new Color(rgb));
    }

    public void setColumnColorPattern(int value) {
        try {
            TableCellModel model = this.getTableCellModel();
            Color fore = this.getComplexForegroundColor(value);
            Color back = this.getComplexBackgroundColor(value);
            model.setColumnForegroundPattern(fore);
            model.setColumnBackgroundPattern(back);
        }
        catch (Throwable catchAll) {
            LGrid.log(catchAll);
        }
    }

    public void setColumnBackgroundPattern(int value) {
        TableCellModel model = this.getTableCellModel();
        model.setColumnBackgroundPattern(LGrid.getCobolColor(value));
    }

    public void setColumnBackgroundRGBPattern(int rgb) {
        TableCellModel model = this.getTableCellModel();
        model.setColumnBackgroundPattern(new Color(rgb));
    }

    public void setColumnForegroundPattern(int value) {
        TableCellModel model = this.getTableCellModel();
        model.setColumnForegroundPattern(LGrid.getCobolColor(value));
    }

    public void setColumnForegroundRGBPattern(int rgb) {
        TableCellModel model = this.getTableCellModel();
        model.setColumnForegroundPattern(new Color(rgb));
    }

    public void setRowDividers(int widthInPixels) {
        try {
            TableCellModel model = this.getTableCellModel();
            model.setRowDividers(widthInPixels);
        }
        catch (Throwable catchAll) {
            LGrid.log(catchAll);
        }
    }

    public void setRowFont(int value) {
        this.setRowFont(Handle.getFont(value));
    }

    public void setRowFont(Font value) {
        this.getTableCellModel().setRowFont(this.y - 1, value);
    }

    public void setRowFont(Handle h) {
        this.setRowFont(h.getFont());
    }

    public void setRowFontName(String name) {
        this.setRowFont(Handle.decodeFont(name));
    }

    public void setSearchOptions(String value) {
        try {
            int searchDirection = 48;
            int searchWrapFlag = 48;
            int searchCaseFlag = 48;
            int searchMatchFlag = 48;
            int searchLocationFlag = 48;
            int searchSkipFlag = 48;
            int searchCursorFlag = 48;
            String searchColumn = "0";
            if (value.length() > 0) {
                searchDirection = value.charAt(0);
            }
            if (value.length() > 1) {
                searchWrapFlag = value.charAt(1);
            }
            if (value.length() > 2) {
                searchCaseFlag = value.charAt(2);
            }
            if (value.length() > 3) {
                searchMatchFlag = value.charAt(3);
            }
            if (value.length() > 4) {
                searchLocationFlag = value.charAt(4);
            }
            if (value.length() > 5) {
                searchSkipFlag = value.charAt(5);
            }
            if (value.length() > 6) {
                searchCursorFlag = value.charAt(6);
            }
            if (value.length() > 7) {
                searchColumn = value.substring(7);
            }
            if (searchDirection >= 48) {
                searchDirection = (char)(searchDirection - 48);
            }
            if (searchWrapFlag >= 48) {
                searchWrapFlag = (char)(searchWrapFlag - 48);
            }
            if (searchCaseFlag >= 48) {
                searchCaseFlag = (char)(searchCaseFlag - 48);
            }
            if (searchMatchFlag >= 48) {
                searchMatchFlag = (char)(searchMatchFlag - 48);
            }
            if (searchLocationFlag >= 48) {
                searchLocationFlag = (char)(searchLocationFlag - 48);
            }
            if (searchSkipFlag >= 48) {
                searchSkipFlag = (char)(searchSkipFlag - 48);
            }
            if (searchCursorFlag >= 48) {
                searchCursorFlag = (char)(searchCursorFlag - 48);
            }
            int searchColumnNumber = 0;
            try {
                searchColumnNumber = Integer.parseInt(searchColumn.trim());
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.gridSearchDirection = searchDirection != 0;
            this.gridSearchWrapFlag = searchWrapFlag != 0;
            this.gridSearchCaseFlag = searchCaseFlag != 0;
            this.gridSearchMatchFlag = searchMatchFlag;
            this.gridSearchLocationFlag = searchLocationFlag;
            this.gridSearchSkipFlag = searchSkipFlag != 0;
            this.gridSearchCursorFlag = searchCursorFlag != 0;
            this.gridSearchColumn = searchColumnNumber;
        }
        catch (Throwable catchAll) {
            LGrid.log(catchAll);
        }
    }

    public void setSearchDirection(boolean state) {
        this.gridSearchDirection = state;
    }

    public void setSearchWrapFlag(boolean state) {
        this.gridSearchWrapFlag = state;
    }

    public void setSearchCaseFlag(boolean state) {
        this.gridSearchCaseFlag = state;
    }

    public void setSearchMatchFlag(int state) {
        this.gridSearchMatchFlag = state;
    }

    public void setSearchLocationFlag(int state) {
        this.gridSearchLocationFlag = state;
    }

    public void setSearchSkipFlag(boolean state) {
        this.gridSearchSkipFlag = state;
    }

    public void setSearchCursorFlag(boolean state) {
        this.gridSearchCursorFlag = state;
    }

    public void setSearchColumn(int state) {
        this.gridSearchColumn = state;
    }

    public void setSearchText(String value) {
        this.initiateSearch(value);
    }

    public String getSearchText() {
        return String.valueOf(this.searchResult);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void initiateSearch(String searchText) {
        boolean searchHidden;
        boolean searchData;
        if (searchText == null) {
            searchText = "";
        }
        int numCols = this.getNumColumns();
        int numRows = this.getNumRows();
        int examinex = this.x;
        int examiney = this.y;
        String examineData = null;
        int searchSuccess = 1;
        boolean skipCurrent = false;
        if (this.gridSearchSkipFlag) {
            skipCurrent = true;
        }
        if (this.gridSearchCaseFlag) {
            searchText = searchText.toUpperCase();
        }
        switch (this.gridSearchLocationFlag) {
            case 0: {
                searchData = true;
                searchHidden = false;
                break;
            }
            case 1: {
                searchData = false;
                searchHidden = true;
                break;
            }
            case 2: {
                searchData = true;
                searchHidden = true;
                break;
            }
            default: {
                searchData = true;
                searchHidden = false;
            }
        }
        boolean match = false;
        this.searchResult = 0;
        if (this.gridSearchColumn != 0) {
            examinex = this.gridSearchColumn;
        }
        block15: do {
            if (!skipCurrent) {
                if (searchData && (examineData = this.getCellData(examiney, examinex)) != null) {
                    if (this.gridSearchCaseFlag) {
                        examineData = examineData.toUpperCase();
                    }
                    switch (this.gridSearchMatchFlag) {
                        case 0: {
                            if (examineData.indexOf(searchText) < 0) break;
                            match = true;
                            break block15;
                        }
                        case 1: {
                            if (!examineData.startsWith(searchText)) break;
                            match = true;
                            break block15;
                        }
                        case 2: {
                            if (!examineData.equals(searchText)) break;
                            match = true;
                            break block15;
                        }
                    }
                }
                if (searchHidden && (examineData = this.getHiddenData(examiney, examinex)) != null) {
                    if (this.gridSearchCaseFlag) {
                        examineData = examineData.toUpperCase();
                    }
                    switch (this.gridSearchMatchFlag) {
                        case 0: {
                            if (examineData.indexOf(searchText) < 0) break;
                            match = true;
                            break block15;
                        }
                        case 1: {
                            if (!examineData.startsWith(searchText)) break;
                            match = true;
                            break block15;
                        }
                        case 2: {
                            if (!examineData.equals(searchText)) break;
                            match = true;
                            break block15;
                        }
                    }
                }
            }
            skipCurrent = false;
            if (this.gridSearchDirection) {
                if (this.gridSearchColumn == 0) {
                    if (++examinex > numCols) {
                        examinex = 1;
                        ++examiney;
                    }
                } else {
                    ++examiney;
                }
                if (examiney <= numRows) continue;
                if (this.gridSearchWrapFlag) {
                    searchSuccess = 2;
                    examiney = 1;
                    continue;
                }
                break;
            }
            if (this.gridSearchColumn == 0) {
                if (--examinex < 1) {
                    examinex = numCols;
                    --examiney;
                }
            } else {
                --examiney;
            }
            if (examiney >= 0) continue;
            if (!this.gridSearchWrapFlag) break;
            this.searchResult = 2;
            examiney = numRows;
        } while (examiney != this.y || examinex != this.x);
        if (match) {
            this.searchResult = searchSuccess;
            this.x = examinex;
            this.y = examiney;
            if (this.gridSearchCursorFlag) {
                this.setCursorX(examinex);
                this.setCursorY(examiney);
            }
        }
    }

    public void setSeparation(int value) {
    }

    public int getSeparation() {
        return 0;
    }

    public void setStartX(int value) {
        this.jTable.setColumnSelectionInterval(value - 1, this.x - 1);
    }

    public int getStartX() {
        return this.jTable.getSelectedColumn() + 1;
    }

    public void setStartY(int value) {
        this.jTable.setRowSelectionInterval(value - 1, this.y - 1);
    }

    public int getStartY() {
        return this.jTable.getSelectedRow() + 1;
    }

    public void setVirtualWidth(int value) {
        this.virtualWidth = value;
    }

    public int getVirtualWidth() {
        return this.virtualWidth;
    }

    public void setVpadding(int value) {
        try {
            int vpadding = (int)((double)this.getUnitHeight() * ((double)value / 100.0));
            this.jTable.setRowMargin(1);
            int rowHeight = this.getUnitHeight() + vpadding - 1;
            this.jTable.setRowHeight(rowHeight);
            this.rowHeader.setFixedCellHeight(rowHeight);
        }
        catch (Throwable catchAll) {
            LGrid.log(catchAll);
        }
    }

    public int getVpadding() {
        try {
            int rowHeight = this.jTable.getRowHeight();
            int margin = rowHeight - this.getUnitHeight();
            return (int)((double)margin / (double)this.getUnitHeight() * 100.0);
        }
        catch (Throwable catchAll) {
            LGrid.log(catchAll);
            return 50;
        }
    }

    public int getVscrollPos() {
        try {
            Point p = SwingUtilities.convertPoint(this.scrollpane.getViewport(), new Point(0, 0), this.jTable);
            return this.jTable.rowAtPoint(p);
        }
        catch (Throwable catchAll) {
            LGrid.log(catchAll);
            return 0;
        }
    }

    public void setCellX(int value) {
        this.x = value;
    }

    public int getCellX() {
        return this.x;
    }

    public void setCellY(int value) {
        this.y = value;
    }

    public int getCellY() {
        return this.y;
    }

    @Override
    public void setPreferredSize(Dimension d) {
        this.scrollpane.setPreferredSize(d);
        super.setPreferredSize(d);
    }

    @Override
    public void setMinimumSize(Dimension d) {
        this.scrollpane.setMinimumSize(d);
        super.setMinimumSize(d);
    }

    @Override
    public void setMaximumSize(Dimension d) {
        this.scrollpane.setMaximumSize(d);
        super.setMaximumSize(d);
    }

    @Override
    public void setBackground(Color c) {
        this.scrollpane.setBackground(c);
        super.setBackground(c);
    }

    @Override
    public void setForeground(Color c) {
        this.scrollpane.setForeground(c);
        super.setForeground(c);
    }

    @Override
    public void setOpaque(boolean state) {
        this.jTable.setOpaque(state);
        super.setOpaque(state);
    }

    @Override
    public void setFont(Font f) {
        super.setFont(f);
        this.jTable.setFont(f);
    }

    @Override
    public void setEnabled(boolean state) {
        this.jTable.setEnabled(state);
        super.setEnabled(state);
    }

    public void refresh() {
        if (!this.massUpdate && this.jTable != null) {
            this.repaint();
        }
    }

    public class LinesBorder
    extends AbstractBorder
    implements SwingConstants {
        protected int northThickness;
        protected int southThickness;
        protected int eastThickness;
        protected int westThickness;
        protected Color northColor;
        protected Color southColor;
        protected Color eastColor;
        protected Color westColor;

        public LinesBorder(Color color2) {
            this(color2, 1);
        }

        public LinesBorder(Color color2, int thickness) {
            this.setColor(color2);
            this.setThickness(thickness);
        }

        public LinesBorder(Color color2, Insets insets) {
            this.setColor(color2);
            this.setThickness(insets);
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            int i;
            Color oldColor = g.getColor();
            g.setColor(this.northColor);
            for (i = 0; i < this.northThickness; ++i) {
                g.drawLine(x, y + i, x + width - 1, y + i);
            }
            g.setColor(this.southColor);
            for (i = 0; i < this.southThickness; ++i) {
                g.drawLine(x, y + height - i - 1, x + width - 1, y + height - i - 1);
            }
            g.setColor(this.eastColor);
            for (i = 0; i < this.westThickness; ++i) {
                g.drawLine(x + i, y, x + i, y + height - 1);
            }
            g.setColor(this.westColor);
            for (i = 0; i < this.eastThickness; ++i) {
                g.drawLine(x + width - i - 1, y, x + width - i - 1, y + height - 1);
            }
            g.setColor(oldColor);
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return new Insets(this.northThickness, this.westThickness, this.southThickness, this.eastThickness);
        }

        @Override
        public Insets getBorderInsets(Component c, Insets insets) {
            return new Insets(this.northThickness, this.westThickness, this.southThickness, this.eastThickness);
        }

        @Override
        public boolean isBorderOpaque() {
            return true;
        }

        public void setColor(Color c) {
            this.northColor = c;
            this.southColor = c;
            this.eastColor = c;
            this.westColor = c;
        }

        public void setColor(Color c, int direction) {
            switch (direction) {
                case 1: {
                    this.northColor = c;
                    break;
                }
                case 5: {
                    this.southColor = c;
                    break;
                }
                case 3: {
                    this.eastColor = c;
                    break;
                }
                case 7: {
                    this.westColor = c;
                    break;
                }
            }
        }

        public void setThickness(int n) {
            this.northThickness = n;
            this.southThickness = n;
            this.eastThickness = n;
            this.westThickness = n;
        }

        public void setThickness(Insets insets) {
            this.northThickness = insets.top;
            this.southThickness = insets.bottom;
            this.eastThickness = insets.right;
            this.westThickness = insets.left;
        }

        public void setThickness(int n, int direction) {
            switch (direction) {
                case 1: {
                    this.northThickness = n;
                    break;
                }
                case 5: {
                    this.southThickness = n;
                    break;
                }
                case 3: {
                    this.eastThickness = n;
                    break;
                }
                case 7: {
                    this.westThickness = n;
                    break;
                }
            }
        }

        public void append(LinesBorder b, boolean isReplace) {
            if (isReplace) {
                this.northThickness = b.northThickness;
                this.southThickness = b.southThickness;
                this.eastThickness = b.eastThickness;
                this.westThickness = b.westThickness;
            } else {
                this.northThickness = Math.max(this.northThickness, b.northThickness);
                this.southThickness = Math.max(this.southThickness, b.southThickness);
                this.eastThickness = Math.max(this.eastThickness, b.eastThickness);
                this.westThickness = Math.max(this.westThickness, b.westThickness);
            }
        }

        public void append(Insets insets, boolean isReplace) {
            if (isReplace) {
                this.northThickness = insets.top;
                this.southThickness = insets.bottom;
                this.eastThickness = insets.right;
                this.westThickness = insets.left;
            } else {
                this.northThickness = Math.max(this.northThickness, insets.top);
                this.southThickness = Math.max(this.southThickness, insets.bottom);
                this.eastThickness = Math.max(this.eastThickness, insets.right);
                this.westThickness = Math.max(this.westThickness, insets.left);
            }
        }
    }

    class DatatypeEditorDocument
    extends PlainDocument {
        private int column;
        private JTextField field;
        private LGrid lTable;

        public void setField(JTextField field) {
            this.field = field;
        }

        public JTextField getField() {
            return this.field;
        }

        public DatatypeEditorDocument(int column, LGrid lTable) {
            this.column = column;
            this.lTable = lTable;
        }

        @Override
        public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
            try {
                String oldText;
                if (str == null) {
                    return;
                }
                TableCellModel tableCellModel = null;
                if (this.lTable != null) {
                    tableCellModel = this.lTable.getTableCellModel();
                }
                int length = -1;
                char[] chars = str.toCharArray();
                int charsLength = 0;
                if (chars != null) {
                    charsLength = chars.length;
                }
                StringBuffer result = new StringBuffer();
                char c = '\u0000';
                char dataType = tableCellModel.getDataType(this.column);
                switch (dataType) {
                    case 'C': 
                    case 'X': {
                        break;
                    }
                    case 'U': {
                        str = str.toUpperCase();
                        break;
                    }
                    case 'L': {
                        str = str.toLowerCase();
                        break;
                    }
                    case '9': {
                        int i;
                        for (i = 0; i < charsLength; ++i) {
                            c = chars[i];
                            switch (c) {
                                case ' ': 
                                case '+': 
                                case '-': 
                                case '.': 
                                case '0': 
                                case '1': 
                                case '2': 
                                case '3': 
                                case '4': 
                                case '5': 
                                case '6': 
                                case '7': 
                                case '8': 
                                case '9': {
                                    result.append(c);
                                }
                            }
                        }
                        str = new String(result);
                        break;
                    }
                    case 'Z': {
                        int i;
                        block33: for (i = 0; i < charsLength; ++i) {
                            c = chars[i];
                            switch (c) {
                                case ' ': 
                                case '$': 
                                case '%': 
                                case '*': 
                                case '+': 
                                case ',': 
                                case '-': 
                                case '.': 
                                case '/': 
                                case '0': 
                                case '1': 
                                case '2': 
                                case '3': 
                                case '4': 
                                case '5': 
                                case '6': 
                                case '7': 
                                case '8': 
                                case '9': {
                                    result.append(c);
                                    continue block33;
                                }
                                default: {
                                    if (c != XOpenInternational.currencySymbol) continue block33;
                                    result.append(c);
                                }
                            }
                        }
                        str = new String(result);
                        break;
                    }
                    case 'I': {
                        int i;
                        for (i = 0; i < charsLength; ++i) {
                            c = chars[i];
                            switch (c) {
                                case ' ': 
                                case '+': 
                                case '-': 
                                case '0': 
                                case '1': 
                                case '2': 
                                case '3': 
                                case '4': 
                                case '5': 
                                case '6': 
                                case '7': 
                                case '8': 
                                case '9': {
                                    result.append(c);
                                }
                            }
                        }
                        str = new String(result);
                        break;
                    }
                    case 'P': {
                        int i;
                        for (i = 0; i < charsLength; ++i) {
                            c = chars[i];
                            switch (c) {
                                case ' ': 
                                case '0': 
                                case '1': 
                                case '2': 
                                case '3': 
                                case '4': 
                                case '5': 
                                case '6': 
                                case '7': 
                                case '8': 
                                case '9': {
                                    result.append(c);
                                }
                            }
                        }
                        str = new String(result);
                        break;
                    }
                    case 'D': {
                        int i;
                        for (i = 0; i < charsLength; ++i) {
                            c = chars[i];
                            switch (c) {
                                case ' ': 
                                case '-': 
                                case '/': 
                                case '0': 
                                case '1': 
                                case '2': 
                                case '3': 
                                case '4': 
                                case '5': 
                                case '6': 
                                case '7': 
                                case '8': 
                                case '9': {
                                    result.append(c);
                                }
                            }
                        }
                        str = new String(result);
                        break;
                    }
                    case 'B': {
                        int i;
                        block37: for (i = 0; i < charsLength; ++i) {
                            c = chars[i];
                            switch (c) {
                                case '0': 
                                case 'F': 
                                case 'N': 
                                case 'f': 
                                case 'n': {
                                    str = "T";
                                    continue block37;
                                }
                                case '1': 
                                case 'T': 
                                case 'Y': 
                                case 't': 
                                case 'y': {
                                    str = "F";
                                }
                            }
                        }
                        break;
                    }
                }
                if (tableCellModel != null) {
                    length = tableCellModel.getDataTypeLength(this.column);
                }
                if (length == -1 || length < 0) {
                    super.insertString(offs, str, a);
                    return;
                }
                int oldLength = 0;
                if (this.field != null && (oldText = this.field.getText()) != null) {
                    oldLength = oldText.length();
                }
                if (length == 0 && (length = LGrid.this.getDataColumnSize(this.column + 1)) <= 0) {
                    super.insertString(offs, str, a);
                    return;
                }
                int extra = oldLength + str.length() - length;
                if (extra > 0) {
                    if (extra >= str.length()) {
                        return;
                    }
                    str = str.substring(0, str.length() - extra);
                }
                super.insertString(offs, str, a);
            }
            catch (Throwable t) {
                LGrid.log(t);
            }
        }
    }

    class DatatypeEditor
    extends JTextField {
        public DatatypeEditor(int column, LGrid lTable) {
            super(null, null, 0);
            DatatypeEditorDocument doc = new DatatypeEditorDocument(column, lTable);
            doc.setField(this);
            this.setDocument(doc);
        }
    }

    class GridCellEditor
    extends DefaultCellEditor {
        public GridCellEditor(JComboBox<Object> object) {
            super(object);
        }

        public GridCellEditor(JCheckBox object) {
            super(object);
        }

        public GridCellEditor(JTextField object) {
            super(object);
        }

        @Override
        public boolean stopCellEditing() {
            if (LGrid.this.processGridEvent(16393, null)) {
                return false;
            }
            return super.stopCellEditing();
        }

        @Override
        public void cancelCellEditing() {
            if (LGrid.this.processGridEvent(16394, null)) {
                return;
            }
            super.cancelCellEditing();
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            Component editorComponent = super.getTableCellEditorComponent(table, value, isSelected, row, column);
            if (editorComponent != null) {
                ++column;
                ++row;
                if (LGrid.this.numberOfRowHeadings > 0) {
                    row += LGrid.this.numberOfRowHeadings;
                }
                if (LGrid.this.processGridEvent(16392, null, column, row)) {
                    editorComponent = null;
                }
            }
            if (isSelected && editorComponent instanceof JTextField) {
                ((JTextField)editorComponent).selectAll();
            }
            return editorComponent;
        }
    }

    class TableCellModel
    extends AbstractTableModel {
        private static final int DEFAULT_SEPARATION = 5;
        protected int[][][] span;
        protected TableCell[][] tableCell;
        private Font[] rowFont;
        private Color[] rowBackground;
        private Color[] rowForeground;
        private Color[] rowPatternBackground;
        private Color[] rowPatternForeground;
        private int[] rowDividers;
        private Font[] colFont;
        private Color[] colBackground;
        private Color[] colForeground;
        private int[] columnAlignment;
        private int[] columnDividers;
        private char[] dataType;
        private int[] dataTypeLength;
        private Color[] columnPatternBackground;
        private Color[] columnPatternForeground;
        private int[] colWidths;
        protected int rowSize = -1;
        protected int columnSize = -1;
        protected int lastRow = -1;
        private Color cursorForeground;
        private Color cursorBackground;
        private Color editableForeground;
        private Color editableBackground;
        private Color dividerColor;
        private Color endColor;
        private Border focusBorder = null;
        private int cursorFrameWidth = 0;
        private int numRowsAddition = 0;
        private boolean massUpdate;
        private int numberOfRowHeadings;
        private int numberOfColumnHeadings;
        private LGrid lTable;
        private TableColumn rowHeaderColumn;

        public TableCellModel(LGrid lTable) {
            this(lTable, 0, 0);
        }

        public TableCellModel(LGrid lTable, int numRows, int numColumns) {
            this.lTable = lTable;
            this.setSize(numRows, numColumns);
        }

        private void setRowSize(int rowSize) {
            int oldSize = this.rowSize;
            this.rowSize = rowSize;
            if (this.lastRow > rowSize) {
                this.lastRow = rowSize;
            }
            if (oldSize != rowSize) {
                this.fireTableStructureChanged();
            }
        }

        private void setColumnSize(int columnSize) {
            int oldSize = this.columnSize;
            this.columnSize = columnSize;
            if (oldSize != columnSize) {
                if (oldSize < 0) {
                    oldSize = 0;
                }
                for (int i = oldSize; i < columnSize; ++i) {
                    int width = this.getColumnWidth(i);
                    if (width < 0) {
                        width = 75;
                    }
                    TableColumn tableColumn = new TableColumn(i, width);
                    tableColumn.setHeaderRenderer(LGrid.this.columnHeaderRenderer);
                    if (i >= this.numberOfColumnHeadings) {
                        tableColumn.addPropertyChangeListener(new ColumnPropertyListener(i));
                    }
                    if (i == 0) {
                        this.rowHeaderColumn = tableColumn;
                        tableColumn.setMinWidth(0);
                    }
                    GridCellEditor defaultCellEditor = new GridCellEditor(new DatatypeEditor(i, this.lTable));
                    tableColumn.setCellEditor(defaultCellEditor);
                    LGrid.this.jTable.addColumn(tableColumn);
                    this.updateColumnWidth(i);
                }
                this.fireTableStructureChanged();
            }
        }

        public int getRowSize() {
            return this.rowSize;
        }

        public int getColumnSize() {
            return this.columnSize;
        }

        @Override
        public int getRowCount() {
            int rowSize = this.getRowSize();
            int count = rowSize + this.numRowsAddition;
            if (this.numberOfColumnHeadings >= 0) {
                count -= this.numberOfColumnHeadings;
            }
            return count > 0 ? count : 0;
        }

        @Override
        public int getColumnCount() {
            int count = this.getColumnSize();
            return count > 0 ? count : 0;
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            if (this.tableCell != null && (row += this.numberOfColumnHeadings) >= 0 && row < this.tableCell.length) {
                TableCell[] particularRow = this.tableCell[row];
                if (col >= 0 && col < particularRow.length) {
                    return this.getTableCell(row, col).isEditable();
                }
            }
            return true;
        }

        public void setCellEditable(boolean state, int row, int col) {
            if (this.isOutOfBounds(row += this.numberOfColumnHeadings, col)) {
                return;
            }
            this.getTableCell(row, col).setEditable(state);
        }

        @Override
        public void setValueAt(Object data, int row, int col) {
            this.setDataAt(data, row + this.numberOfColumnHeadings, col);
        }

        @Override
        public Object getValueAt(int row, int col) {
            return this.getDataAt(row + this.numberOfColumnHeadings, col);
        }

        public void setColumns(int cols) {
            if (cols < 0) {
                return;
            }
            this.setColumnSize(cols);
        }

        public void setRows(int rows) {
            if (rows < 0) {
                return;
            }
            this.setRowSize(rows);
        }

        private boolean expandColumnSize(int columnSize) {
            if (++columnSize <= this.getColumnSize()) {
                return false;
            }
            this.setColumnSize(columnSize);
            return true;
        }

        private boolean expandRowSize(int rowSize) {
            if (++rowSize <= this.getRowSize()) {
                return false;
            }
            this.setRowSize(rowSize);
            return true;
        }

        public void setSize(int width, int height) {
            if (this.rowSize <= 0 || this.columnSize <= 0) {
                return;
            }
            int oldCol = this.getColumnSize();
            int oldRow = this.getRowSize();
            this.setColumnSize(width);
            this.setRowSize(height);
            if (width != oldCol || height != oldRow) {
                this.fireTableStructureChanged();
            }
        }

        public void setSize(Dimension size) {
            this.setSize(size.width, size.height);
        }

        public Dimension getSize() {
            return new Dimension(this.columnSize, this.rowSize);
        }

        public void setNumberOfRowHeadings(int value) {
            if (value == this.numberOfRowHeadings) {
                return;
            }
            if (value < 0) {
                value = -value;
            }
            this.numberOfRowHeadings = value;
            if (value == 0) {
                this.updateColumnWidth(0);
            } else if (this.rowHeaderColumn != null) {
                boolean reorder = LGrid.this.jTable.getTableHeader().getReorderingAllowed();
                boolean resize = LGrid.this.jTable.getTableHeader().getResizingAllowed();
                LGrid.this.jTable.getTableHeader().setReorderingAllowed(true);
                LGrid.this.jTable.getTableHeader().setResizingAllowed(true);
                this.rowHeaderColumn.setPreferredWidth(0);
                this.rowHeaderColumn.setMaxWidth(0);
                this.rowHeaderColumn.setMinWidth(0);
                this.rowHeaderColumn.setWidth(0);
                this.rowHeaderColumn.sizeWidthToFit();
                LGrid.this.jTable.getTableHeader().setReorderingAllowed(reorder);
                LGrid.this.jTable.getTableHeader().setResizingAllowed(resize);
            }
            this.fireTableStructureChanged();
        }

        public void setNumberOfColumnHeadings(int value) {
            if (value == this.numberOfColumnHeadings) {
                return;
            }
            if (value < 0) {
                value = -value;
            }
            this.numberOfColumnHeadings = value;
            this.fireTableStructureChanged();
        }

        public void deleteRow(int row, int count) {
            Serializable[] replace;
            int length;
            if (count <= 0) {
                return;
            }
            if (row <= this.lastRow) {
                this.lastRow -= count;
            }
            int from = row + count;
            if (this.rowFont != null && this.rowFont.length >= row) {
                length = this.rowFont.length - row - count;
                if (from > 0 && from < this.rowFont.length && length > 0) {
                    System.arraycopy(this.rowFont, from, this.rowFont, row, length);
                    replace = new Font[this.rowFont.length - length];
                    this.rowFont = replace;
                }
            }
            if (this.rowBackground != null && this.rowBackground.length >= row) {
                length = this.rowBackground.length - row - count;
                if (from > 0 && from < this.rowBackground.length && length > 0) {
                    System.arraycopy(this.rowBackground, from, this.rowBackground, row, length);
                    replace = new Color[this.rowBackground.length - length];
                    this.rowBackground = replace;
                }
            }
            if (this.rowForeground != null && this.rowForeground.length >= row) {
                length = this.rowForeground.length - row - count;
                if (from > 0 && from < this.rowForeground.length && length > 0) {
                    System.arraycopy(this.rowForeground, from, this.rowForeground, row, length);
                    replace = new Color[this.rowForeground.length - length];
                    this.rowForeground = replace;
                }
            }
            if (this.tableCell == null) {
                this.setRowSize(this.getRowSize() - count);
                return;
            }
            if (row >= this.tableCell.length) {
                this.setRowSize(this.getRowSize() - count);
                return;
            }
            int numRows = this.rowSize;
            TableCell[][] oldTableCell = this.tableCell;
            this.tableCell = new TableCell[this.tableCell.length - count][];
            if (oldTableCell != null) {
                if (row > 0) {
                    System.arraycopy(oldTableCell, 0, this.tableCell, 0, row);
                }
                System.arraycopy(oldTableCell, row + count, this.tableCell, row, numRows - row - count);
            }
            this.setRowSize(this.getRowSize() - count);
        }

        public void deleteRow(int row) {
            this.deleteRow(row, 1);
        }

        public void insertRow(int row, int count) {
            if (count <= 0) {
                return;
            }
            if (row <= this.lastRow) {
                this.lastRow += count;
            }
            if (this.tableCell == null) {
                int currentRows = this.getRowSize();
                if (currentRows < 0) {
                    currentRows = 0;
                }
                this.setRowSize(currentRows + count);
                return;
            }
            if (row >= this.tableCell.length) {
                int currentRows = this.getRowSize();
                if (currentRows < 0) {
                    currentRows = 0;
                }
                this.setRowSize(currentRows + count);
                return;
            }
            int numColumns = this.columnSize;
            numColumns = this.columnSize;
            TableCell[][] oldTableCell = this.tableCell;
            this.tableCell = new TableCell[this.rowSize + count][];
            try {
                if (oldTableCell != null) {
                    if (row > 0) {
                        System.arraycopy(oldTableCell, 0, this.tableCell, 0, row);
                    }
                    if (this.rowSize - row > 0) {
                        System.arraycopy(oldTableCell, row, this.tableCell, row + count, this.rowSize - row);
                    }
                }
            }
            catch (Exception e) {
                LGrid.log(e);
            }
            int finalRow = row + count;
            for (int i = row; i < finalRow; ++i) {
                this.tableCell[i] = new TableCell[numColumns];
            }
            int currentRows = this.getRowSize();
            if (currentRows < 0) {
                currentRows = 0;
            }
            this.setRowSize(currentRows + count);
            this.fireTableStructureChanged();
        }

        public void refresh() {
            if (this.massUpdate) {
                super.fireTableStructureChanged();
            }
        }

        @Override
        public void fireTableStructureChanged() {
            if (!this.massUpdate) {
                super.fireTableStructureChanged();
            }
        }

        public void insertRow(int row) {
            this.insertRow(row, 1);
        }

        public void setMassUpdate(boolean state) {
            boolean refresh = false;
            if (this.massUpdate && !state) {
                refresh = true;
            }
            this.massUpdate = state;
            if (refresh) {
                this.fireTableStructureChanged();
            }
        }

        public boolean isMassUpdate() {
            return this.massUpdate;
        }

        protected boolean isOutOfBounds(int row, int col) {
            try {
                if (row < 0 || col < 0) {
                    return true;
                }
                if (this.expandRowSize(row) | this.expandColumnSize(col) | this.expandTableCell(row, col)) {
                    this.fireTableStructureChanged();
                }
            }
            catch (Throwable t) {
                LGrid.log(t);
            }
            return false;
        }

        protected boolean isOutOfBoundsNoExpansion(int row, int col) {
            try {
                if (row < 0 || col < 0) {
                    return true;
                }
                if (row >= this.getRowSize()) {
                    return true;
                }
                if (col >= this.getColumnSize()) {
                    return true;
                }
                if (this.expandRowSize(row) | this.expandColumnSize(col) | this.expandTableCell(row, col)) {
                    this.fireTableStructureChanged();
                }
            }
            catch (Throwable t) {
                LGrid.log(t);
            }
            return false;
        }

        private boolean expandTableCell(int row, int col) {
            if (this.tableCell == null) {
                this.tableCell = new TableCell[row + 1][col + 1];
                return true;
            }
            boolean fire = false;
            fire = this.expandTableCellRows(row);
            if (this.tableCell[row] == null) {
                this.tableCell[row] = new TableCell[col + 1];
                return true;
            }
            return fire |= this.expandTableCellColumns(row, col);
        }

        private boolean expandTableCellRows(int row) {
            int currentRows = this.tableCell.length;
            if (currentRows <= row) {
                TableCell[][] oldTableCell = this.tableCell;
                this.tableCell = new TableCell[row + 1][];
                System.arraycopy(oldTableCell, 0, this.tableCell, 0, currentRows);
                return true;
            }
            return false;
        }

        private boolean expandTableCellColumns(int row, int col) {
            TableCell[] oldTableCell = this.tableCell[row];
            if (oldTableCell == null) {
                this.tableCell[row] = new TableCell[col + 1];
                return true;
            }
            int currentCols = oldTableCell.length;
            if (currentCols <= col) {
                this.tableCell[row] = new TableCell[col + 1];
                if (oldTableCell != null) {
                    System.arraycopy(oldTableCell, 0, this.tableCell[row], 0, oldTableCell.length);
                }
                return true;
            }
            return false;
        }

        protected boolean isOutOfBoundsRow(int row) {
            if (row < 0) {
                return true;
            }
            if (row < this.rowSize) {
                return false;
            }
            return false;
        }

        protected boolean isOutOfBoundsCol(int col) {
            if (col < 0) {
                return true;
            }
            if (col < this.columnSize) {
                return false;
            }
            return false;
        }

        protected boolean isOutOfBounds(int[] rows, int[] columns) {
            int rowsLength = rows.length;
            for (int i = 0; i < rowsLength; ++i) {
                if (!this.isOutOfBoundsRow(rows[i])) continue;
                return true;
            }
            int columnsLength = columns.length;
            for (int i = 0; i < columnsLength; ++i) {
                if (!this.isOutOfBoundsCol(columns[i])) continue;
                return true;
            }
            return false;
        }

        public int getLastRow() {
            return this.lastRow;
        }

        public void setMaximumRows(int maxRows, int numRowsAddition) {
            this.numRowsAddition = numRowsAddition;
            this.setRows(maxRows + numRowsAddition);
            this.fireTableStructureChanged();
        }

        public void setMaximumColumns(int maxCols) {
            this.setColumns(maxCols);
            this.fireTableStructureChanged();
        }

        public int getNumRowsAddition() {
            return this.numRowsAddition;
        }

        public void setColumnWidth(int col, int widthInPixels) {
            if (this.isOutOfBoundsCol(col)) {
                return;
            }
            if (this.colWidths == null) {
                this.colWidths = new int[col + 1];
            } else {
                int[] old = this.colWidths;
                this.colWidths = new int[col + 1];
                System.arraycopy(old, 0, this.colWidths, 0, old.length);
            }
            this.colWidths[col] = widthInPixels;
            this.updateColumnWidth(col);
        }

        public void updateColumnWidth(int col) {
            try {
                if (this.colWidths == null || col >= this.colWidths.length) {
                    return;
                }
                if (col < 0 || col >= this.getColumnSize()) {
                    return;
                }
                int preferredWidth = this.colWidths[col];
                preferredWidth += 5;
                if (col == 0 && this.numberOfRowHeadings > 0) {
                    preferredWidth = 0;
                }
                if (preferredWidth >= 0) {
                    TableColumnModel tableColumnModel = LGrid.this.jTable.getColumnModel();
                    int count = tableColumnModel.getColumnCount();
                    if (col >= count) {
                        return;
                    }
                    LGrid.this.internalColumnWidthPositioning = true;
                    TableColumn tableColumn = tableColumnModel.getColumn(col);
                    tableColumn.setPreferredWidth(preferredWidth);
                    int minWidth = preferredWidth * 2 / 3;
                    int maxWidth = preferredWidth * 3;
                    if (tableColumn.getMinWidth() > minWidth) {
                        tableColumn.setMinWidth(minWidth);
                    }
                    if (tableColumn.getMaxWidth() < maxWidth) {
                        tableColumn.setMaxWidth(maxWidth);
                    }
                    tableColumn.setWidth(preferredWidth);
                    tableColumn.setResizable(true);
                    LGrid.this.jTable.sizeColumnsToFit(col);
                    LGrid.this.internalColumnWidthPositioning = false;
                }
            }
            catch (Throwable catchAll) {
                LGrid.log(catchAll);
            }
        }

        public int getColumnWidth(int col) {
            if (this.isOutOfBoundsCol(col)) {
                return -1;
            }
            if (this.colWidths != null && col < this.colWidths.length) {
                return this.colWidths[col];
            }
            return -1;
        }

        public void setHiddenData(String data, int row, int col) {
            if (this.isOutOfBounds(row, col)) {
                return;
            }
            this.getTableCell(row, col).setHiddenData(data);
        }

        public String getHiddenData(int row, int col) {
            if (this.isOutOfBoundsNoExpansion(row, col)) {
                return null;
            }
            return this.getTableCell(row, col).getHiddenData();
        }

        public void setDataAt(Object data, int row, int col) {
            if (this.isOutOfBounds(row, col)) {
                return;
            }
            if (data != null) {
                if (this.lastRow < row) {
                    this.lastRow = row;
                }
                this.getTableCell(row, col).setValue(data);
                if (row == 0 && col == 0) {
                    LGrid.this.updateCornerComponent();
                }
            }
        }

        public Object getDataAt(int row, int col) {
            if (this.isOutOfBoundsNoExpansion(row, col)) {
                return null;
            }
            return this.getTableCell(row, col).getValue();
        }

        public void setDividerColor(Color c) {
            this.dividerColor = c;
        }

        public Color getDividerColor() {
            return this.dividerColor;
        }

        public void setEndColor(Color c) {
            this.endColor = c;
        }

        public Color getEndColor() {
            return this.endColor;
        }

        public Border getFocusBorder() {
            return this.focusBorder;
        }

        public void setFocusBorder(Border border) {
            this.focusBorder = border;
        }

        public void setCursorFrameWidth(int value) {
            this.cursorFrameWidth = value;
            this.focusBorder = value == 0 ? null : (value > 0 ? new LineBorder(Color.black, this.cursorFrameWidth) : new LineBorder(Color.lightGray, this.cursorFrameWidth));
        }

        public int getCursorFrameWidth() {
            return this.cursorFrameWidth;
        }

        public Color getCursorForeground() {
            return this.cursorForeground;
        }

        public Color getCursorBackground() {
            return this.cursorBackground;
        }

        public void setCursorForeground(Color c) {
            this.cursorForeground = c;
        }

        public void setCursorBackground(Color c) {
            this.cursorBackground = c;
        }

        public Color getEditableForeground() {
            return this.editableForeground;
        }

        public Color getEditableBackground() {
            return this.editableBackground;
        }

        public void setEditableForeground(Color c) {
            this.editableForeground = c;
        }

        public void setEditableBackground(Color c) {
            this.editableBackground = c;
        }

        public int getAlignment(int row, int col) {
            if (this.isOutOfBoundsNoExpansion(row, col)) {
                return 0;
            }
            int align = this.getTableCell(row, col).getAlignment();
            if (align >= 0) {
                return align;
            }
            if (this.columnAlignment != null && col < this.columnAlignment.length) {
                align = this.columnAlignment[col];
            }
            return align;
        }

        public int getColumnAlignment(int col, int defaultAlignment) {
            if (this.columnAlignment != null && col < this.columnAlignment.length) {
                return this.columnAlignment[col];
            }
            return defaultAlignment;
        }

        public int getColumnAlignment(int col) {
            return this.getColumnAlignment(col, 0);
        }

        public void setColumnAlignment(int[] columnAlignment) {
            this.columnAlignment = columnAlignment;
        }

        public void setColumnAlignment(int align) {
            if (align < 0) {
                this.columnAlignment = null;
            } else if (this.columnAlignment == null) {
                this.columnAlignment = new int[]{align};
            } else {
                int[] newColumnAlignment = new int[this.columnAlignment.length + 1];
                System.arraycopy(this.columnAlignment, 0, newColumnAlignment, 0, this.columnAlignment.length);
                newColumnAlignment[newColumnAlignment.length - 1] = align;
                this.columnAlignment = newColumnAlignment;
            }
        }

        public void setColumnDividers(int[] columnDividers) {
            this.columnDividers = columnDividers;
        }

        public void setColumnDividers(int widthInPixels) {
            if (widthInPixels < 0) {
                this.columnDividers = null;
            } else if (this.columnDividers == null) {
                this.columnDividers = new int[]{widthInPixels};
            } else {
                int[] newColumnDividers = new int[this.columnDividers.length + 1];
                System.arraycopy(this.columnDividers, 0, newColumnDividers, 0, this.columnDividers.length);
                newColumnDividers[newColumnDividers.length - 1] = widthInPixels;
                this.columnDividers = newColumnDividers;
            }
        }

        public int getColumnDividers(int col) {
            if (this.isOutOfBoundsCol(col)) {
                return -1;
            }
            int widthInPixels = -1;
            if (this.columnDividers != null && col < this.columnDividers.length) {
                widthInPixels = this.columnDividers[col];
            }
            return widthInPixels;
        }

        public void setRowDividers(int[] rowDividers) {
            this.rowDividers = rowDividers;
        }

        public void setRowDividers(int widthInPixels) {
            if (widthInPixels < 0) {
                this.rowDividers = null;
            } else if (this.rowDividers == null) {
                this.rowDividers = new int[]{widthInPixels};
            } else {
                int[] newRowDividers = new int[this.rowDividers.length + 1];
                System.arraycopy(this.rowDividers, 0, newRowDividers, 0, this.rowDividers.length);
                newRowDividers[newRowDividers.length - 1] = widthInPixels;
                this.rowDividers = newRowDividers;
            }
        }

        public int getRowDividers(int row) {
            int widthInPixels = -1;
            if (this.rowDividers != null && this.rowDividers.length > 0) {
                widthInPixels = this.rowDividers[row %= this.rowDividers.length];
            }
            return widthInPixels;
        }

        public void setDataType(String s) {
            if (s == null) {
                this.setDataType('X');
                return;
            }
            int s_length = (s = s.trim()).length();
            if (s_length == 0) {
                this.setDataType('X');
                return;
            }
            char c = s.charAt(0);
            int length = 0;
            if (s_length > 1) {
                length = 0;
                int parse = 48;
                for (int i = 1; i < s_length; ++i) {
                    parse = s.charAt(i);
                    if (parse < 48 || parse > 57) continue;
                    length *= 10;
                    length += parse - 48;
                }
            }
            this.setDataType(c, length);
        }

        public void setDataType(char c) {
            this.setDataType(c, 0);
        }

        public void setDataType(char c, int length) {
            switch (c) {
                case 'X': 
                case 'x': {
                    c = (char)88;
                    break;
                }
                case 'U': 
                case 'u': {
                    c = (char)85;
                    break;
                }
                case 'L': 
                case 'l': {
                    c = (char)76;
                    break;
                }
                case '9': 
                case 'N': 
                case 'n': {
                    c = (char)57;
                    break;
                }
                case 'E': 
                case 'Z': 
                case 'e': 
                case 'z': {
                    c = (char)90;
                    break;
                }
                case 'I': 
                case 'i': {
                    c = (char)73;
                    break;
                }
                case 'P': 
                case 'p': {
                    c = (char)80;
                    break;
                }
                case 'D': 
                case 'd': {
                    c = (char)68;
                    break;
                }
                case 'B': 
                case 'b': {
                    c = (char)66;
                    length = 1;
                    break;
                }
                default: {
                    c = (char)88;
                }
            }
            if (this.dataType == null) {
                this.dataType = new char[]{c};
                this.dataTypeLength = new int[]{length};
            } else {
                char[] newDataType = new char[this.dataType.length + 1];
                System.arraycopy(this.dataType, 0, newDataType, 0, this.dataType.length);
                newDataType[newDataType.length - 1] = c;
                this.dataType = newDataType;
                int[] newDataTypeLength = new int[this.dataTypeLength.length + 1];
                System.arraycopy(this.dataTypeLength, 0, newDataTypeLength, 0, this.dataTypeLength.length);
                newDataTypeLength[newDataTypeLength.length - 1] = length;
                this.dataTypeLength = newDataTypeLength;
            }
        }

        public char getDataType(int row, int col) {
            if (this.isOutOfBoundsNoExpansion(row, col)) {
                return 'X';
            }
            char c = this.getTableCell(row, col).getDataType();
            if (c != '\u0000') {
                return c;
            }
            c = this.dataType != null && col < this.dataType.length ? this.dataType[col] : (char)'X';
            return c;
        }

        public char getDataType(int col) {
            return this.getDataType(0, col);
        }

        public int getDataTypeLength(int row, int col) {
            if (this.isOutOfBoundsNoExpansion(row, col)) {
                return 0;
            }
            if (this.getTableCell(row, col).getDataType() != '\u0000') {
                return this.getTableCell(row, col).getDataTypeLength();
            }
            if (this.dataTypeLength != null && col < this.dataTypeLength.length) {
                return this.dataTypeLength[col];
            }
            return 0;
        }

        public int getDataTypeLength(int col) {
            return this.getDataTypeLength(0, col);
        }

        public TableCell getTableCell(int row, int col) {
            if (this.isOutOfBounds(row, col)) {
                return null;
            }
            try {
                TableCell cell = this.tableCell[row][col];
                if (cell == null) {
                    this.tableCell[row][col] = cell = new TableCell();
                }
                return cell;
            }
            catch (Exception tableCellException) {
                LGrid.log(tableCellException);
                return null;
            }
        }

        public void setRowPattern(Color[] background, Color[] foreground) {
            this.rowPatternBackground = background;
            this.rowPatternForeground = foreground;
        }

        public void setRowForegroundPattern(Color foreground) {
            if (foreground == null) {
                this.rowPatternForeground = null;
            } else if (this.rowPatternForeground == null) {
                this.rowPatternForeground = new Color[]{foreground};
            } else {
                Color[] newRowPatternForeground = new Color[this.rowPatternForeground.length + 1];
                System.arraycopy(this.rowPatternForeground, 0, newRowPatternForeground, 0, this.rowPatternForeground.length);
                newRowPatternForeground[newRowPatternForeground.length - 1] = foreground;
                this.rowPatternForeground = newRowPatternForeground;
            }
        }

        public void setRowBackgroundPattern(Color background) {
            if (background == null) {
                this.rowPatternBackground = null;
            } else if (this.rowPatternBackground == null) {
                this.rowPatternBackground = new Color[]{background};
            } else {
                Color[] newRowPatternBackground = new Color[this.rowPatternBackground.length + 1];
                System.arraycopy(this.rowPatternBackground, 0, newRowPatternBackground, 0, this.rowPatternBackground.length);
                newRowPatternBackground[newRowPatternBackground.length - 1] = background;
                this.rowPatternBackground = newRowPatternBackground;
            }
        }

        public void setColumnPattern(Color[] background, Color[] foreground) {
            this.columnPatternBackground = background;
            this.columnPatternForeground = foreground;
        }

        public void setColumnForegroundPattern(Color foreground) {
            if (foreground == null) {
                this.columnPatternForeground = null;
            } else if (this.columnPatternForeground == null) {
                this.columnPatternForeground = new Color[]{foreground};
            } else {
                Color[] newColumnPatternForeground = new Color[this.columnPatternForeground.length + 1];
                System.arraycopy(this.columnPatternForeground, 0, newColumnPatternForeground, 0, this.columnPatternForeground.length);
                newColumnPatternForeground[newColumnPatternForeground.length - 1] = foreground;
                this.columnPatternForeground = newColumnPatternForeground;
            }
        }

        public void setColumnBackgroundPattern(Color background) {
            if (background == null) {
                this.columnPatternBackground = null;
            } else if (this.columnPatternBackground == null) {
                this.columnPatternBackground = new Color[]{background};
            } else {
                Color[] newColumnPatternBackground = new Color[this.columnPatternBackground.length + 1];
                System.arraycopy(this.columnPatternBackground, 0, newColumnPatternBackground, 0, this.columnPatternBackground.length);
                newColumnPatternBackground[newColumnPatternBackground.length - 1] = background;
                this.columnPatternBackground = newColumnPatternBackground;
            }
        }

        public void setRowFont(int row, Font f) {
            if (this.isOutOfBoundsRow(row)) {
                return;
            }
            if (this.rowFont == null) {
                this.rowFont = new Font[row + 1];
            } else {
                Font[] old = this.rowFont;
                this.rowFont = new Font[row + 1];
                System.arraycopy(old, 0, this.rowFont, 0, old.length);
            }
            this.rowFont[row] = f;
        }

        public Font getRowFont(int row) {
            if (this.isOutOfBoundsRow(row)) {
                return null;
            }
            if (this.rowFont != null || row >= this.rowFont.length) {
                return null;
            }
            return this.rowFont[row];
        }

        public void setRowBackground(int row, Color c) {
            if (this.isOutOfBoundsRow(row)) {
                return;
            }
            if (this.rowBackground == null) {
                this.rowBackground = new Color[row + 1];
            } else {
                Color[] old = this.rowBackground;
                this.rowBackground = new Color[row + 1];
                System.arraycopy(old, 0, this.rowBackground, 0, old.length);
            }
            this.rowBackground[row] = c;
        }

        public Color getRowBackground(int row) {
            if (this.isOutOfBoundsRow(row)) {
                return null;
            }
            if (this.rowBackground == null || row >= this.rowBackground.length) {
                return null;
            }
            return this.rowBackground[row];
        }

        public void setRowForeground(int row, Color c) {
            if (this.isOutOfBoundsRow(row)) {
                return;
            }
            if (this.rowForeground == null) {
                this.rowForeground = new Color[row + 1];
            } else {
                Color[] old = this.rowForeground;
                this.rowForeground = new Color[row + 1];
                System.arraycopy(old, 0, this.rowForeground, 0, old.length);
            }
            this.rowForeground[row] = c;
        }

        public Color getRowForeground(int row) {
            if (this.isOutOfBoundsRow(row)) {
                return null;
            }
            if (this.rowForeground == null || row >= this.rowForeground.length) {
                return null;
            }
            return this.rowForeground[row];
        }

        public void setColumnFont(Font f, int col) {
            if (this.isOutOfBoundsCol(col)) {
                return;
            }
            if (this.colFont == null) {
                this.colFont = new Font[col + 1];
            } else {
                Font[] old = this.colFont;
                this.colFont = new Font[col + 1];
                System.arraycopy(old, 0, this.colFont, 0, old.length);
            }
            this.colFont[col] = f;
        }

        public Font getColumnFont(int col) {
            if (this.isOutOfBoundsCol(col)) {
                return null;
            }
            if (this.colFont == null || col >= this.colFont.length) {
                return null;
            }
            return this.colFont[col];
        }

        public void setColumnBackground(Color c, int col) {
            if (this.isOutOfBoundsCol(col)) {
                return;
            }
            if (this.colBackground == null) {
                this.colBackground = new Color[col + 1];
            } else {
                Color[] old = this.colBackground;
                this.colBackground = new Color[col + 1];
                System.arraycopy(old, 0, this.colBackground, 0, old.length);
            }
            this.colBackground[col] = c;
        }

        public Color getColumnBackground(int col) {
            if (this.isOutOfBoundsCol(col)) {
                return null;
            }
            if (this.colBackground == null || col >= this.colBackground.length) {
                return null;
            }
            return this.colBackground[col];
        }

        public void setColumnForeground(Color c, int col) {
            if (this.isOutOfBoundsCol(col)) {
                return;
            }
            if (this.colForeground == null) {
                this.colForeground = new Color[col + 1];
            } else {
                Color[] old = this.colForeground;
                this.colForeground = new Color[col + 1];
                System.arraycopy(old, 0, this.colForeground, 0, old.length);
            }
            this.colForeground[col] = c;
        }

        public Color getColumnForeground(int col) {
            if (this.isOutOfBoundsCol(col)) {
                return null;
            }
            if (this.colForeground == null || col >= this.colForeground.length) {
                return null;
            }
            return this.colForeground[col];
        }

        public Icon getBitmap(int row, int column) {
            if (this.isOutOfBoundsNoExpansion(row, column)) {
                return null;
            }
            return this.getTableCell(row, column).getBitmap();
        }

        public boolean isBitmapTrailing(int row, int column) {
            if (this.isOutOfBoundsNoExpansion(row, column)) {
                return false;
            }
            return this.getTableCell(row, column).isBitmapTrailing();
        }

        public Color getForeground(int row, int column) {
            if (this.isOutOfBoundsNoExpansion(row, column)) {
                return null;
            }
            Color c = this.getTableCell(row, column).getForeground();
            if (c == null && this.rowForeground != null && row < this.rowForeground.length) {
                c = this.rowForeground[row];
            }
            if (c == null && this.colForeground != null && column < this.colForeground.length) {
                c = this.colForeground[column];
            }
            if (c == null && this.rowPatternForeground != null && this.rowPatternForeground.length > 0) {
                c = this.rowPatternForeground[row % this.rowPatternForeground.length];
            }
            return c;
        }

        public void setForeground(Color color2, int row, int column) {
            if (this.isOutOfBounds(row, column)) {
                return;
            }
            this.getTableCell(row, column).setForeground(color2);
            if (row == 0 && column == 0) {
                LGrid.this.updateCornerComponent();
            }
        }

        public void setForeground(Color color2, int[] rows, int[] columns) {
            if (this.isOutOfBounds(rows, columns)) {
                return;
            }
            for (int row : rows) {
                for (int column : columns) {
                    this.getTableCell(row, column).setForeground(color2);
                }
            }
        }

        public Color getBackground(int row, int column) {
            if (this.isOutOfBoundsNoExpansion(row, column)) {
                return null;
            }
            Color c = this.getTableCell(row, column).getBackground();
            if (c == null && this.rowBackground != null && row < this.rowBackground.length) {
                c = this.rowBackground[row];
            }
            if (c == null && this.colBackground != null && column < this.colBackground.length) {
                c = this.colBackground[column];
            }
            if (c == null && this.rowPatternBackground != null && this.rowPatternBackground.length > 0) {
                c = this.rowPatternBackground[row % this.rowPatternBackground.length];
            }
            return c;
        }

        public void setBackground(Color color2, int row, int column) {
            if (this.isOutOfBounds(row, column)) {
                return;
            }
            this.getTableCell(row, column).setBackground(color2);
            if (row == 0 && column == 0) {
                LGrid.this.updateCornerComponent();
            }
        }

        public void setBackground(Color color2, int[] rows, int[] columns) {
            if (this.isOutOfBounds(rows, columns)) {
                return;
            }
            for (int row : rows) {
                for (int column : columns) {
                    this.getTableCell(row, column).setBackground(color2);
                }
            }
        }

        public Font getFont(int row, int column) {
            if (this.isOutOfBoundsNoExpansion(row, column)) {
                return null;
            }
            Font f = this.getTableCell(row, column).getFont();
            if (f == null && this.rowFont != null && row < this.rowFont.length) {
                f = this.rowFont[row];
            }
            if (f == null && this.colFont != null && column < this.colFont.length) {
                f = this.colFont[column];
            }
            return f;
        }

        public void setFont(Font font2, int row, int column) {
            if (this.isOutOfBounds(row, column)) {
                return;
            }
            this.getTableCell(row, column).setFont(font2);
            if (row == 0 && column == 0) {
                LGrid.this.updateCornerComponent();
            }
        }

        public void setFont(Font font2, int[] rows, int[] columns) {
            if (this.isOutOfBounds(rows, columns)) {
                return;
            }
            for (int row : rows) {
                for (int column : columns) {
                    this.getTableCell(row, column).setFont(font2);
                }
            }
        }
    }

    class ColumnPropertyListener
    implements PropertyChangeListener {
        private int columnNumber;

        public ColumnPropertyListener(int columnNumber) {
            this.columnNumber = columnNumber + 1;
        }

        @Override
        public void propertyChange(PropertyChangeEvent event) {
            if (LGrid.this.internalColumnWidthPositioning) {
                return;
            }
            if (event != null) {
                try {
                    String name = event.getPropertyName();
                    if ("width".equals(name)) {
                        Object newValue = event.getNewValue();
                        int newValueInt = (Integer)newValue;
                        if (LGrid.this.unitWidth > 0) {
                            newValueInt /= LGrid.this.unitWidth;
                        }
                        if (LGrid.this.processGridEvent(16410, event, this.columnNumber, newValueInt)) {
                            return;
                        }
                    }
                }
                catch (Exception e) {
                    LGrid.log(e);
                }
            }
        }
    }

    class TableCell
    implements SwingConstants {
        public static final char DATATYPE_X = 'X';
        public static final char DATATYPE_U = 'U';
        public static final char DATATYPE_L = 'L';
        public static final char DATATYPE_9 = '9';
        public static final char DATATYPE_Z = 'Z';
        public static final char DATATYPE_I = 'I';
        public static final char DATATYPE_P = 'P';
        public static final char DATATYPE_D = 'D';
        public static final char DATATYPE_B = 'B';
        public static final char DATATYPE_C = 'C';
        public static final char DATATYPE_DEFAULT = 'X';
        public static final int DATATYPE_LENGTH_COLUMN = 0;
        public static final int DATATYPE_LENGTH_UNLIMITED = -1;
        public static final int DATATYPE_LENGTH_DEFAULT = 0;
        private Color foreground;
        private Color background;
        private Font font;
        private String hiddenData;
        private int spanColumns = 1;
        private int spanRows = 1;
        private Icon bitmap;
        private int alignment = -1;
        private char datatype = '\u0000';
        private int datatypeLength;
        private boolean bitmapTrailing;
        private Object value;
        private boolean editable = true;

        TableCell() {
        }

        public boolean isEditable() {
            return this.editable;
        }

        public void setEditable(boolean state) {
            this.editable = state;
        }

        public void setValue(Object o) {
            this.value = o;
        }

        public Object getValue() {
            return this.value;
        }

        public void setBitmapTrailing(boolean state) {
            this.bitmapTrailing = state;
        }

        public boolean isBitmapTrailing() {
            return this.bitmapTrailing;
        }

        public void setForeground(Color c) {
            this.foreground = c;
        }

        public Color getForeground() {
            return this.foreground;
        }

        public void setBackground(Color c) {
            this.background = c;
        }

        public Color getBackground() {
            return this.background;
        }

        public void setFont(Font f) {
            this.font = f;
        }

        public Font getFont() {
            return this.font;
        }

        public void setHiddenData(String o) {
            this.hiddenData = o;
        }

        public String getHiddenData() {
            return this.hiddenData;
        }

        public void setSpanColumns(int value) {
            this.spanColumns = value;
        }

        public void setSpanRows(int value) {
            this.spanRows = value;
        }

        public int getSpanColumns() {
            return this.spanColumns;
        }

        public int getSpanRows() {
            return this.spanRows;
        }

        public void setBitmap(Icon icon) {
            this.bitmap = icon;
        }

        public Icon getBitmap() {
            return this.bitmap;
        }

        public void setAlignment(int value) {
            this.alignment = value;
        }

        public int getAlignment() {
            return this.alignment;
        }

        public String validatedString(String data) {
            String value = data;
            if (value == null) {
                return "";
            }
            if (this.alignment != 0) {
                value = value.trim();
            }
            String validationSet = null;
            switch (this.datatype) {
                case 'X': {
                    break;
                }
                case 'U': {
                    value = value.toUpperCase();
                    break;
                }
                case 'L': {
                    value = value.toLowerCase();
                    break;
                }
                case '9': {
                    validationSet = "0123456789.+- ";
                    break;
                }
                case 'Z': {
                    validationSet = "0123456789.,+-$*%/ ";
                    break;
                }
                case 'I': {
                    validationSet = "0123456789+- ";
                    break;
                }
                case 'P': {
                    validationSet = "0123456789 ";
                    break;
                }
                case 'D': {
                    validationSet = "0123456789/-";
                    break;
                }
                case 'B': {
                    validationSet = "01";
                    break;
                }
                case 'C': {
                    if (this.alignment != 0) {
                        value = value.trim();
                    }
                    if (value.length() == 0) {
                        value = "\u0000";
                        break;
                    }
                    try {
                        if (value.length() <= 1) break;
                        if (value.startsWith("#")) {
                            value = value.substring(1);
                            value = String.valueOf((char)Integer.parseInt(value));
                            break;
                        }
                        if (value.startsWith("$")) {
                            value = value.substring(1);
                            value = String.valueOf((char)Integer.parseInt(value, 16));
                            break;
                        }
                        if (value.endsWith("h") || value.endsWith("H")) {
                            value = value.substring(0, value.length() - 1);
                            value = String.valueOf((char)Integer.parseInt(value, 16));
                            break;
                        }
                        if (value.endsWith("o") || value.endsWith("O")) {
                            value = value.substring(0, value.length() - 1);
                            value = String.valueOf((char)Integer.parseInt(value, 8));
                            break;
                        }
                        if (value.startsWith("0x")) {
                            value = value.substring(2);
                            value = String.valueOf((char)Integer.parseInt(value, 16));
                            break;
                        }
                        if (!value.startsWith("0")) break;
                        value = value.substring(1);
                        value = String.valueOf((char)Integer.parseInt(value, 8));
                        break;
                    }
                    catch (NumberFormatException numberFormatException) {
                        LGrid.log(numberFormatException);
                        value = "?";
                    }
                }
            }
            if (validationSet != null) {
                int length = value.length();
                char c = ' ';
                for (int i = 0; i < length; ++i) {
                    c = value.charAt(i);
                    if (validationSet.indexOf(c) >= 0) continue;
                    StringBuffer result = new StringBuffer(value.substring(0, i));
                    ++i;
                    while (i < length) {
                        c = value.charAt(i);
                        if (validationSet.indexOf(c) >= 0) {
                            result.append(c);
                        }
                        ++i;
                    }
                    value = result.toString();
                    break;
                }
            }
            if (this.datatypeLength > 0 && this.datatypeLength > value.length()) {
                value = value.substring(0, this.datatypeLength);
            }
            if (this.alignment != 0) {
                value = value.trim();
            }
            return value;
        }

        public char getDataType() {
            return this.datatype;
        }

        public int getDataTypeLength() {
            return this.datatypeLength;
        }

        public void setDataType(String s) {
            if (s == null) {
                this.setDataType('X');
                return;
            }
            char c = s.charAt(0);
            int length = 0;
            int s_length = s.length();
            if (s_length > 1) {
                length = 0;
                int parse = 48;
                for (int i = 1; i < s_length; ++i) {
                    parse = s.charAt(i);
                    if (parse < 48 || parse > 57) continue;
                    length *= 10;
                    length += parse - 48;
                }
            }
            this.setDataType(c, length);
        }

        public void setDataType(char c) {
            this.setDataType(c, 0);
        }

        public void setDataType(char c, int length) {
            switch (c) {
                case 'X': 
                case 'x': {
                    c = (char)88;
                    break;
                }
                case 'U': 
                case 'u': {
                    c = (char)85;
                    break;
                }
                case 'L': 
                case 'l': {
                    c = (char)76;
                    break;
                }
                case '9': 
                case 'N': 
                case 'n': {
                    c = (char)57;
                    break;
                }
                case 'E': 
                case 'Z': 
                case 'e': 
                case 'z': {
                    c = (char)90;
                    break;
                }
                case 'I': 
                case 'i': {
                    c = (char)73;
                    break;
                }
                case 'P': 
                case 'p': {
                    c = (char)80;
                    break;
                }
                case 'D': 
                case 'd': {
                    c = (char)68;
                    break;
                }
                case 'B': 
                case 'b': {
                    c = (char)66;
                    length = 1;
                    break;
                }
                default: {
                    c = (char)88;
                }
            }
            this.datatype = c;
            this.datatypeLength = length;
        }
    }

    class TableCellLabelRenderer
    extends JLabel
    implements TableCellRenderer {
        public TableCellLabelRenderer() {
            this.setOpaque(true);
            this.setBorder(noFocusBorder);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            try {
                Color foreground = null;
                Color background = null;
                Font font2 = null;
                Border focusBorder = null;
                String valueString = "";
                if (value != null) {
                    valueString = value.toString();
                }
                TableCellModel tableCellModel = null;
                column = LGrid.this.jTable.convertColumnIndexToModel(column);
                int numRowHeadings = 0;
                int numColHeadings = LGrid.this.numberOfColumnHeadings;
                if (numColHeadings < 0) {
                    numColHeadings = 0;
                }
                row += numColHeadings;
                try {
                    tableCellModel = (TableCellModel)table.getModel();
                    if (hasFocus) {
                        focusBorder = tableCellModel.getFocusBorder();
                    }
                    foreground = tableCellModel.getForeground(row, column);
                    background = tableCellModel.getBackground(row, column);
                    font2 = tableCellModel.getFont(row, column);
                    Icon icon = tableCellModel.getBitmap(row, column);
                    this.setIcon(icon);
                    if (icon != null) {
                        boolean iconTrailing = tableCellModel.isBitmapTrailing(row, column);
                        this.setHorizontalTextPosition(iconTrailing ? 10 : 11);
                    }
                    int alignment = tableCellModel.getAlignment(row, column);
                    switch (alignment) {
                        case 1: {
                            this.setHorizontalAlignment(2);
                            valueString = valueString.trim();
                            break;
                        }
                        case 2: {
                            this.setHorizontalAlignment(4);
                            valueString = valueString.trim();
                            break;
                        }
                        case 3: {
                            this.setHorizontalAlignment(0);
                            valueString = valueString.trim();
                            break;
                        }
                        case 4: {
                            this.setHorizontalAlignment(10);
                            valueString = valueString.trim();
                            break;
                        }
                        case 5: {
                            this.setHorizontalAlignment(11);
                            valueString = valueString.trim();
                            break;
                        }
                        default: {
                            this.setHorizontalAlignment(2);
                            break;
                        }
                    }
                }
                catch (ClassCastException exception) {
                    LGrid.log(exception);
                }
                if (isSelected) {
                    this.setForeground(table.getSelectionForeground());
                    this.setBackground(table.getSelectionBackground());
                } else {
                    this.setForeground(foreground != null ? foreground : table.getForeground());
                    this.setBackground(background != null ? background : table.getBackground());
                }
                this.setFont(font2 != null ? font2 : table.getFont());
                if (hasFocus) {
                    if (focusBorder == null) {
                        focusBorder = UIManager.getBorder("Table.focusCellHighlightBorder");
                    }
                    this.setBorder(focusBorder);
                    Color fore = null;
                    Color back = null;
                    if (LGrid.this.jTable.isCellEditable(row - numColHeadings, column - numRowHeadings)) {
                        fore = tableCellModel.getEditableForeground();
                        back = tableCellModel.getEditableBackground();
                    }
                    if (fore == null) {
                        fore = tableCellModel.getCursorForeground();
                    }
                    if (fore == null) {
                        fore = UIManager.getColor("Table.focusCellForeground");
                    }
                    this.setForeground(fore);
                    if (back == null) {
                        back = tableCellModel.getCursorBackground();
                    }
                    if (back == null) {
                        back = UIManager.getColor("Table.focusCellBackground");
                    }
                    this.setBackground(back);
                } else {
                    Border defaultBorder = noFocusBorder;
                    int colDivider = tableCellModel.getColumnDividers(column);
                    int rowDivider = tableCellModel.getRowDividers(row);
                    if (colDivider >= 0 || rowDivider >= 0) {
                        if (colDivider < 0) {
                            colDivider = 1;
                        }
                        if (rowDivider < 0) {
                            rowDivider = 1;
                        }
                        defaultBorder = new LinesBorder(tableCellModel.getDividerColor(), new Insets(0, 0, rowDivider, colDivider));
                    }
                    this.setBorder(defaultBorder);
                }
                this.setValue(value);
            }
            catch (Throwable log) {
                LGrid.log(log);
                this.setText("");
            }
            return this;
        }

        protected void setValue(Object value) {
            this.setText(value == null ? "" : value.toString());
        }
    }

    class ColumnHeaderRenderer
    extends JLabel
    implements TableCellRenderer {
        private boolean centeredHeadings;
        private boolean tiledHeadings = true;
        private Font headingFont;
        private Color headingForeground;
        private Color headingBackground;
        private Color headingDivider = Color.black;

        ColumnHeaderRenderer() {
            this.setOpaque(true);
            this.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
            this.setHorizontalAlignment(0);
            JTableHeader header = LGrid.this.jTable.getTableHeader();
            if (header != null) {
                this.setFont(header.getFont());
            }
        }

        public void setTiledHeadings(boolean state) {
            this.setHeadingBorder(state, this.headingDivider);
        }

        public boolean isTiledHeadings() {
            return this.tiledHeadings;
        }

        public void setHeadingDivider(Color c) {
            this.setHeadingBorder(this.tiledHeadings, c);
        }

        public Color getHeadingDivider() {
            return this.headingDivider;
        }

        private void setHeadingBorder(boolean tiled, Color divider) {
            if (tiled == this.tiledHeadings && divider == this.headingDivider) {
                return;
            }
            if (tiled) {
                if (this.tiledHeadings == tiled) {
                    return;
                }
                this.tiledHeadings = tiled;
                this.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
            } else {
                this.headingDivider = divider;
                this.setBorder(new LinesBorder(this.headingDivider));
            }
        }

        public void setCenteredHeadings(boolean state) {
            this.centeredHeadings = state;
        }

        public void setHeadingFont(Font f) {
            this.headingFont = f;
        }

        public Font getHeadingFont() {
            return this.headingFont;
        }

        public void setHeadingForeground(Color c) {
            this.headingForeground = c;
        }

        public Color getHeadingForeground() {
            return this.headingForeground;
        }

        public void setHeadingBackground(Color c) {
            this.headingBackground = c;
        }

        public Color getHeadingBackground() {
            return this.headingBackground;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean cellHasFocus, int row, int column) {
            try {
                TableCellModel tableCellModel = LGrid.this.getTableCellModel();
                column = LGrid.this.jTable.convertColumnIndexToModel(column);
                if (row < 0) {
                    row = 0;
                }
                try {
                    if (tableCellModel != null) {
                        int columnSize = tableCellModel.getColumnSize();
                        if (column >= columnSize) {
                            this.setText("");
                            return this;
                        }
                        TableCell tableCell = tableCellModel.getTableCell(0, column);
                        if (tableCell != null) {
                            Object headerValue = tableCell.getValue();
                            value = headerValue != null ? headerValue : null;
                        }
                    }
                }
                catch (Throwable t) {
                    LGrid.log(t);
                }
                String valueString = value == null ? " " : value.toString();
                try {
                    JTableHeader header = LGrid.this.jTable.getTableHeader();
                    Color fore = this.headingForeground;
                    if (fore == null) {
                        fore = header.getForeground();
                    }
                    this.setForeground(fore);
                    Color back = this.headingBackground;
                    if (back == null) {
                        back = header.getBackground();
                    }
                    this.setBackground(back);
                    if (this.headingFont != null) {
                        this.setFont(this.headingFont);
                    } else {
                        this.setFont(header.getFont());
                    }
                    Icon icon = tableCellModel.getBitmap(row, column);
                    this.setIcon(icon);
                    if (icon != null) {
                        boolean iconTrailing = tableCellModel.isBitmapTrailing(row, column);
                        this.setHorizontalTextPosition(iconTrailing ? 10 : 11);
                    }
                    if (this.centeredHeadings) {
                        this.setHorizontalAlignment(0);
                        valueString = valueString.trim();
                    } else {
                        int align = LGrid.this.getTableCellModel().getAlignment(0, column);
                        switch (align) {
                            case 1: {
                                this.setHorizontalAlignment(2);
                                valueString = valueString.trim();
                                break;
                            }
                            case 2: {
                                this.setHorizontalAlignment(4);
                                valueString = valueString.trim();
                                break;
                            }
                            case 4: {
                                this.setHorizontalAlignment(10);
                                valueString = valueString.trim();
                                break;
                            }
                            case 5: {
                                this.setHorizontalAlignment(11);
                                valueString = valueString.trim();
                                break;
                            }
                            case 0: {
                                this.setHorizontalAlignment(2);
                                break;
                            }
                            default: {
                                this.setHorizontalAlignment(0);
                                valueString = valueString.trim();
                            }
                        }
                    }
                }
                catch (Throwable t) {
                    LGrid.log(t);
                }
                if (valueString == null || valueString.length() == 0) {
                    valueString = " ";
                }
                this.setText(valueString);
            }
            catch (Throwable log) {
                LGrid.log(log);
                this.setText("");
            }
            return this;
        }
    }

    class RowHeaderRenderer
    extends JLabel
    implements ListCellRenderer<Object> {
        private boolean centeredHeadings;
        private boolean tiledHeadings = true;
        private Font headingFont;
        private Color headingForeground;
        private Color headingBackground;
        private Color headingDivider = Color.black;

        RowHeaderRenderer() {
            this.setOpaque(true);
            this.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
            this.setHorizontalAlignment(0);
            JTableHeader header = LGrid.this.jTable.getTableHeader();
            if (header != null) {
                this.setFont(header.getFont());
            }
        }

        public void setTiledHeadings(boolean state) {
            this.setHeadingBorder(state, this.headingDivider);
        }

        public boolean isTiledHeadings() {
            return this.tiledHeadings;
        }

        public void setHeadingDivider(Color c) {
            this.setHeadingBorder(this.tiledHeadings, c);
        }

        public Color getHeadingDivider() {
            return this.headingDivider;
        }

        private void setHeadingBorder(boolean tiled, Color divider) {
            if (tiled == this.tiledHeadings && divider == this.headingDivider) {
                return;
            }
            if (tiled) {
                if (this.tiledHeadings == tiled) {
                    return;
                }
                this.tiledHeadings = tiled;
                this.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
            } else {
                this.headingDivider = divider;
                this.setBorder(new LinesBorder(this.headingDivider));
            }
        }

        public void setCenteredHeadings(boolean state) {
            this.centeredHeadings = state;
        }

        public void setHeadingFont(Font f) {
            this.headingFont = f;
        }

        public Font getHeadingFont() {
            return this.headingFont;
        }

        public void setHeadingForeground(Color c) {
            this.headingForeground = c;
        }

        public Color getHeadingForeground() {
            return this.headingForeground;
        }

        public void setHeadingBackground(Color c) {
            this.headingBackground = c;
        }

        public Color getHeadingBackground() {
            return this.headingBackground;
        }

        public void updateCornerComponent() {
            Object value = null;
            TableCellModel model = LGrid.this.getTableCellModel();
            if (model != null) {
                value = model.getDataAt(0, 0);
                if (model.getRowCount() > 0 && model.getColumnCount() > 0) {
                    this.getListCellRendererComponent((JList<?>)null, value, -LGrid.this.numberOfColumnHeadings, false, false);
                }
            }
        }

        @Override
        public Component getListCellRendererComponent(JList<?> list, Object value, int row, boolean isSelected, boolean cellHasFocus) {
            try {
                int column = 0;
                if ((row += LGrid.this.numberOfColumnHeadings) < 0) {
                    row = 0;
                }
                TableCellModel tableCellModel = LGrid.this.getTableCellModel();
                String valueString = value == null ? "" : value.toString();
                JTableHeader header = LGrid.this.jTable.getTableHeader();
                Color fore = this.headingForeground;
                Color back = this.headingBackground;
                if (fore == null && header != null) {
                    fore = header.getForeground();
                } else if (fore == null) {
                    fore = LGrid.this.getForeground();
                }
                this.setForeground(fore);
                if (back == null && header != null) {
                    back = header.getBackground();
                } else if (back == null) {
                    back = LGrid.this.getBackground();
                }
                this.setBackground(back);
                if (this.headingFont != null) {
                    this.setFont(this.headingFont);
                } else {
                    this.setFont(header.getFont());
                }
                Icon icon = tableCellModel.getBitmap(row, column);
                this.setIcon(icon);
                if (icon != null) {
                    boolean iconTrailing = tableCellModel.isBitmapTrailing(row, column);
                    this.setHorizontalTextPosition(iconTrailing ? 10 : 11);
                }
                if (this.centeredHeadings) {
                    this.setHorizontalAlignment(0);
                    valueString = valueString.trim();
                } else {
                    int align = tableCellModel.getAlignment(row, column);
                    switch (align) {
                        case 1: {
                            this.setHorizontalAlignment(2);
                            valueString = valueString.trim();
                            break;
                        }
                        case 2: {
                            this.setHorizontalAlignment(4);
                            valueString = valueString.trim();
                            break;
                        }
                        case 4: {
                            this.setHorizontalAlignment(10);
                            valueString = valueString.trim();
                            break;
                        }
                        case 5: {
                            this.setHorizontalAlignment(11);
                            valueString = valueString.trim();
                            break;
                        }
                        case 0: {
                            this.setHorizontalAlignment(2);
                            break;
                        }
                        default: {
                            this.setHorizontalAlignment(0);
                            valueString = valueString.trim();
                        }
                    }
                }
                this.setText(valueString);
            }
            catch (Throwable log) {
                LGrid.log(log);
                this.setText("");
            }
            return this;
        }
    }

    class RowHeaderModel
    extends AbstractListModel<Object> {
        RowHeaderModel() {
        }

        @Override
        public int getSize() {
            TableCellModel model = LGrid.this.getTableCellModel();
            if (model != null) {
                int rowCount = model.getRowSize();
                if (LGrid.this.numberOfColumnHeadings > 0) {
                    rowCount -= LGrid.this.numberOfColumnHeadings;
                }
                if (rowCount >= 0) {
                    return rowCount;
                }
            }
            return 0;
        }

        @Override
        public Object getElementAt(int row) {
            row += LGrid.this.numberOfColumnHeadings;
            TableCellModel model = LGrid.this.getTableCellModel();
            Object value = null;
            if (model != null) {
                value = model.getTableCell(row, 0).getValue();
            }
            if (value == null) {
                value = "";
            }
            return value;
        }
    }

    class RowHeaderListener
    implements MouseListener {
        JList<Object> header;

        public RowHeaderListener(JList<Object> header) {
            this.header = header;
        }

        @Override
        public void mouseClicked(MouseEvent event) {
        }

        @Override
        public void mouseEntered(MouseEvent event) {
        }

        @Override
        public void mouseExited(MouseEvent event) {
        }

        @Override
        public void mousePressed(MouseEvent event) {
            this.handleClicks(event);
        }

        @Override
        public void mouseReleased(MouseEvent event) {
        }

        private void handleClicks(MouseEvent event) {
            int clickCount = event.getClickCount();
            int col = 1;
            int row = 1;
            row = LGrid.this.jTable.rowAtPoint(event.getPoint());
            ++row;
            if (LGrid.this.numberOfRowHeadings > 0) {
                row += LGrid.this.numberOfRowHeadings;
            }
            if (clickCount == 1) {
                if (LGrid.this.processGridEvent(16402, event, col, row)) {
                    event.consume();
                    return;
                }
            } else if (clickCount == 2 && LGrid.this.processGridEvent(16403, event, col, row)) {
                event.consume();
                return;
            }
        }
    }

    class ColumnHeaderListener
    implements MouseListener {
        JTableHeader header;

        public ColumnHeaderListener(JTableHeader header) {
            this.header = header;
        }

        @Override
        public void mouseClicked(MouseEvent event) {
        }

        @Override
        public void mouseEntered(MouseEvent event) {
        }

        @Override
        public void mouseExited(MouseEvent event) {
        }

        @Override
        public void mousePressed(MouseEvent event) {
            this.handleClicks(event);
        }

        @Override
        public void mouseReleased(MouseEvent event) {
        }

        private void handleClicks(MouseEvent event) {
            int clickCount = event.getClickCount();
            int col = this.header.columnAtPoint(event.getPoint());
            col = LGrid.this.jTable.convertColumnIndexToModel(col);
            ++col;
            if (clickCount == 1) {
                if (LGrid.this.processGridEvent(16402, event, col, 1)) {
                    event.consume();
                    return;
                }
            } else if (clickCount == 2 && LGrid.this.processGridEvent(16403, event, col, 1)) {
                event.consume();
                return;
            }
        }
    }

    class RowSelectionListener
    implements ListSelectionListener {
        private boolean previousDrag;
        private boolean msgBeginDragSent;

        RowSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent event) {
            if (LGrid.this.internalCursorPositioning) {
                return;
            }
            if (!LGrid.this.isVisible()) {
                return;
            }
            boolean valueIsAdjusting = event.getValueIsAdjusting();
            int anchorColumn = LGrid.this.getAnchorColumnSelectionIndex();
            int leadColumn = LGrid.this.getLeadColumnSelectionIndex();
            int anchorRow = LGrid.this.getAnchorRowSelectionIndex();
            int leadRow = LGrid.this.getLeadRowSelectionIndex();
            anchorColumn = LGrid.this.jTable.convertColumnIndexToModel(anchorColumn);
            leadColumn = LGrid.this.jTable.convertColumnIndexToModel(leadColumn);
            if (LGrid.this.numberOfRowHeadings > 0) {
                anchorRow += LGrid.this.numberOfRowHeadings;
                leadRow += LGrid.this.numberOfRowHeadings;
            }
            ++anchorColumn;
            ++leadColumn;
            ++anchorRow;
            ++leadRow;
            int col = LGrid.this.jTable.getSelectedColumn();
            col = LGrid.this.jTable.convertColumnIndexToModel(col);
            ++col;
            if (LGrid.this.currentlyDragging) {
                this.msgBeginDragSent = true;
            }
            if (this.previousDrag || LGrid.this.currentlyDragging) {
                if (valueIsAdjusting) {
                    if (!this.msgBeginDragSent) {
                        this.msgBeginDragSent = true;
                        LGrid.this.currentlyDragging = true;
                        LGrid.this.previousColumn = -1;
                        LGrid.this.previousRow = -1;
                        if (LGrid.this.enableDragEvents && LGrid.this.processGridXYEvent(16406, event, LGrid.this.dragColumn, LGrid.this.dragRow)) {
                            this.previousDrag = valueIsAdjusting;
                            return;
                        }
                        if (LGrid.this.enableDragEvents && LGrid.this.processGridXYEvent(16404, event, leadColumn, leadRow)) {
                            this.previousDrag = valueIsAdjusting;
                            return;
                        }
                    } else {
                        LGrid.this.previousColumn = -1;
                        LGrid.this.previousRow = -1;
                        if (LGrid.this.enableDragEvents && LGrid.this.processGridXYEvent(16404, event, leadColumn, leadRow)) {
                            this.previousDrag = valueIsAdjusting;
                            return;
                        }
                    }
                } else if (LGrid.this.currentlyDragging) {
                    this.msgBeginDragSent = false;
                    LGrid.this.currentlyDragging = false;
                    LGrid.this.previousColumn = -1;
                    LGrid.this.previousRow = -1;
                    if (LGrid.this.enableDragEvents && LGrid.this.processGridXYEvent(16407, event, leadColumn, leadRow)) {
                        this.previousDrag = valueIsAdjusting;
                        return;
                    }
                } else if ((LGrid.this.previousColumn != leadColumn || LGrid.this.previousRow != leadRow) && LGrid.this.processGridXYEvent(16395, event, LGrid.this.previousColumn = leadColumn, LGrid.this.previousRow = leadRow)) {
                    this.previousDrag = valueIsAdjusting;
                    return;
                }
            } else {
                LGrid.this.dragColumn = anchorColumn;
                LGrid.this.dragRow = anchorRow;
                if (valueIsAdjusting) {
                    this.msgBeginDragSent = false;
                } else if ((LGrid.this.previousColumn != leadColumn || LGrid.this.previousRow != leadRow) && LGrid.this.processGridXYEvent(16395, event, LGrid.this.previousColumn = leadColumn, LGrid.this.previousRow = leadRow)) {
                    this.previousDrag = valueIsAdjusting;
                    return;
                }
            }
            this.previousDrag = valueIsAdjusting;
        }
    }

    class ColumnSelectionListener
    implements ListSelectionListener {
        private boolean previousDrag;
        private boolean msgBeginDragSent;

        ColumnSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent event) {
            if (LGrid.this.internalCursorPositioning) {
                return;
            }
            if (!LGrid.this.isVisible()) {
                return;
            }
            boolean valueIsAdjusting = event.getValueIsAdjusting();
            int anchorColumn = LGrid.this.getAnchorColumnSelectionIndex();
            int leadColumn = LGrid.this.getLeadColumnSelectionIndex();
            int anchorRow = LGrid.this.getAnchorRowSelectionIndex();
            int leadRow = LGrid.this.getLeadRowSelectionIndex();
            anchorColumn = LGrid.this.jTable.convertColumnIndexToModel(anchorColumn);
            leadColumn = LGrid.this.jTable.convertColumnIndexToModel(leadColumn);
            if (LGrid.this.numberOfRowHeadings > 0) {
                anchorRow += LGrid.this.numberOfRowHeadings;
                leadRow += LGrid.this.numberOfRowHeadings;
            }
            ++anchorColumn;
            ++leadColumn;
            ++anchorRow;
            ++leadRow;
            int col = LGrid.this.jTable.getSelectedColumn();
            col = LGrid.this.jTable.convertColumnIndexToModel(col);
            if (LGrid.this.currentlyDragging) {
                this.msgBeginDragSent = true;
            }
            if (this.previousDrag || LGrid.this.currentlyDragging) {
                if (valueIsAdjusting) {
                    if (!this.msgBeginDragSent) {
                        this.msgBeginDragSent = true;
                        LGrid.this.currentlyDragging = true;
                        LGrid.this.previousColumn = -1;
                        LGrid.this.previousRow = -1;
                        if (LGrid.this.enableDragEvents && LGrid.this.processGridXYEvent(16406, event, LGrid.this.dragColumn, LGrid.this.dragRow)) {
                            this.previousDrag = valueIsAdjusting;
                            return;
                        }
                        if (LGrid.this.enableDragEvents && LGrid.this.processGridXYEvent(16404, event, leadColumn, leadRow)) {
                            this.previousDrag = valueIsAdjusting;
                            return;
                        }
                    } else {
                        LGrid.this.previousColumn = -1;
                        LGrid.this.previousRow = -1;
                        if (LGrid.this.enableDragEvents && LGrid.this.processGridXYEvent(16404, event, leadColumn, leadRow)) {
                            this.previousDrag = valueIsAdjusting;
                            return;
                        }
                    }
                } else if (LGrid.this.currentlyDragging) {
                    this.msgBeginDragSent = false;
                    LGrid.this.currentlyDragging = false;
                    LGrid.this.previousColumn = -1;
                    LGrid.this.previousRow = -1;
                    if (LGrid.this.enableDragEvents && LGrid.this.processGridXYEvent(16407, event, leadColumn, leadRow)) {
                        this.previousDrag = valueIsAdjusting;
                        return;
                    }
                } else if ((LGrid.this.previousColumn != leadColumn || LGrid.this.previousRow != leadRow) && LGrid.this.processGridXYEvent(16395, event, LGrid.this.previousColumn = leadColumn, LGrid.this.previousRow = leadRow)) {
                    this.previousDrag = valueIsAdjusting;
                    return;
                }
            } else {
                LGrid.this.dragColumn = anchorColumn;
                LGrid.this.dragRow = anchorRow;
                if (valueIsAdjusting) {
                    this.msgBeginDragSent = false;
                } else if ((LGrid.this.previousColumn != leadColumn || LGrid.this.previousRow != leadRow) && LGrid.this.processGridXYEvent(16395, event, LGrid.this.previousColumn = leadColumn, LGrid.this.previousRow = leadRow)) {
                    this.previousDrag = valueIsAdjusting;
                    return;
                }
            }
            this.previousDrag = valueIsAdjusting;
        }
    }
}

