/*
 * Decompiled with CFR 0.152.
 */
package com.heirloomcomputing.ecs.jfc;

import com.heirloomcomputing.ecs.exec.ThreadQueue;
import com.heirloomcomputing.ecs.jfc.LComponent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.lang.reflect.Method;
import javax.swing.JComponent;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.basic.BasicProgressBarUI;

public final class LProgressBar
extends LComponent
implements KeyListener {
    private int highColor;
    private int lowColor;
    private int fillColor;
    private int fillColor2;
    private int titlePosition;
    private int fillPercent;
    private Color highColorObject;
    private Color lowColorObject;
    private Color fillColorObject;
    private Color fillColor2Object;
    private boolean indeterminate;
    JProgressBar progressBar = new JProgressBar(){

        @Override
        public void updateUI() {
            this.setUI(new BasicProgressBarUI(){
                protected JProgressBar progressBar = null;

                @Override
                public void installUI(JComponent c) {
                    this.progressBar = (JProgressBar)c;
                    super.installUI(c);
                }

                @Override
                protected Point getStringPlacement(Graphics g, String progressString, int x, int y, int width, int height) {
                    FontMetrics fontSizer = this.progressBar.getFontMetrics(this.progressBar.getFont());
                    int stringWidth = fontSizer.stringWidth(progressString);
                    int stringHeight = fontSizer.getHeight();
                    height -= 4;
                    --y;
                    if (this.getOrientation() == 0) {
                        return new Point(x + Math.round(width / 2 - stringWidth / 2), y + Math.round(height / 2 + stringHeight / 2));
                    }
                    return new Point(x + Math.round(width / 2 - stringWidth / 2), y + Math.round(height / 2 + stringHeight / 2));
                }

                @Override
                protected int getCellSpacing() {
                    return 0;
                }
            });
            this.invalidate();
        }
    };

    public LProgressBar() {
        this.progressBar.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.setOpaque(false);
        this.lines = 5.0;
        this.size = 12.0;
        this.setLayout(new BorderLayout());
        this.progressBar.setVisible(false);
        this.progressBar.setStringPainted(false);
        this.progressBar.setOrientation(0);
        this.progressBar.setMinimum(0);
        this.progressBar.setMaximum(100);
        this.progressBar.setBorderPainted(false);
        this.add("Center", this.progressBar);
        this.adjustLine = -3;
        this.adjustLines = 4;
        this.setForeground(Color.black);
    }

    @Override
    public void keyPressed(KeyEvent event) {
    }

    @Override
    public void keyReleased(KeyEvent event) {
        this.processKey(this, event);
    }

    @Override
    public void keyTyped(KeyEvent event) {
    }

    public void addConstantListeners() {
        this.addKeyListener(this);
        this.progressBar.addKeyListener(this);
    }

    public void removeConstantListeners() {
        this.removeKeyListener(this);
        this.progressBar.removeKeyListener(this);
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.addConstantListeners();
    }

    @Override
    public void removeNotify() {
        this.removeConstantListeners();
        super.removeNotify();
    }

    @Override
    public boolean isAcceptable() {
        return false;
    }

    @Override
    public int getControlType() {
        return 1010;
    }

    public JProgressBar getJProgressBar() {
        return this.progressBar;
    }

    public void setHorizontal() {
        this.progressBar.setOrientation(0);
    }

    public void setVertical() {
        this.progressBar.setOrientation(1);
    }

    public boolean isHorizontal() {
        return this.progressBar.getOrientation() == 0;
    }

    public boolean isVertical() {
        return this.progressBar.getOrientation() == 1;
    }

    public int getHorizontal() {
        return this.isHorizontal() ? 1 : 0;
    }

    public int getVertical() {
        return this.isVertical() ? 1 : 0;
    }

    public void setIndeterminate(boolean state) {
        this.indeterminate = state;
        if (this.progressBar != null) {
            try {
                Class<?> c = this.progressBar.getClass();
                Method m = c.getDeclaredMethod("setIndeterminate", Boolean.TYPE);
                m.invoke((Object)this.progressBar, new Boolean(state));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public void setIndeterminate(int state) {
        this.setIndeterminate(state != 0);
    }

    public boolean isIndeterminate() {
        return this.indeterminate;
    }

    public int getIndeterminate() {
        return this.indeterminate ? 1 : 0;
    }

    @Override
    public void setCleanTitle(String value) {
        if (value != null) {
            value = value.length() > 0 && value.charAt(0) == '\u0000' ? null : value.trim();
        }
        super.setCleanTitle(value);
        this.progressBar.setString(value);
        this.redisplay();
    }

    @Override
    public void determineDefaultSize() {
        if (this.size > 0.0) {
            return;
        }
        this.lines = 5.0;
        this.size = 12.0;
    }

    public boolean isNormal() {
        return this.isStyle(48);
    }

    public void setNormal() {
        this.setStyleOn(0, 32);
    }

    public void setNormal(boolean state) {
        this.setStyle(48, state, 48);
    }

    public boolean isHeavy() {
        return this.isStyle(16);
    }

    public int getHeavy() {
        return this.isHeavy() ? 1 : 0;
    }

    public void setHeavy() {
        this.setStyleOn(16, 32);
    }

    public void setHeavy(boolean state) {
        this.setStyle(16, state, 32);
    }

    public boolean isVeryHeavy() {
        return this.isStyle(32);
    }

    public int getVeryHeavy() {
        return this.isVeryHeavy() ? 1 : 0;
    }

    public void setVeryHeavy() {
        this.setStyleOn(32, 16);
    }

    public void setVeryHeavy(boolean state) {
        this.setStyle(32, state, 16);
    }

    public boolean isAlternate() {
        return this.isStyle(64);
    }

    public int getAlternate() {
        return this.isAlternate() ? 1 : 0;
    }

    public void setAlternate() {
        this.setStyleOn(64);
    }

    public void setAlternate(boolean state) {
        this.setStyle(64, state);
    }

    public boolean isFullHeight() {
        return this.isStyle(128);
    }

    public int getFullHeight() {
        return this.isFullHeight() ? 1 : 0;
    }

    public void setFullHeight() {
        this.setStyleOn(128);
    }

    public void setFullHeight(boolean state) {
        this.setStyle(128, state);
    }

    public boolean isRaised() {
        return this.isStyle(1);
    }

    public int getRaised() {
        return this.isRaised() ? 1 : 0;
    }

    public void setRaised() {
        this.setStyleOn(1, 14);
    }

    public void setRaised(boolean state) {
        this.setStyle(1, state, 14);
    }

    public boolean isLowered() {
        return this.isStyle(2);
    }

    public int getLowered() {
        return this.isLowered() ? 1 : 0;
    }

    public void setLowered() {
        this.setStyleOn(2, 13);
    }

    public void setLowered(boolean state) {
        this.setStyle(2, state, 13);
    }

    public boolean isEngraved() {
        return this.isStyle(4);
    }

    public int getEngraved() {
        return this.isEngraved() ? 1 : 0;
    }

    public void setEngraved() {
        this.setStyleOn(4, 11);
    }

    public void setEngraved(boolean state) {
        this.setStyle(4, state, 11);
    }

    public boolean isRimmed() {
        return this.isStyle(8);
    }

    public int getRimmed() {
        return this.isRimmed() ? 1 : 0;
    }

    public void setRimmed() {
        this.setStyleOn(8, 7);
    }

    public void setRimmed(boolean state) {
        this.setStyle(8, state, 7);
    }

    @Override
    public void setStyle(int mask) {
        super.setStyle(mask);
        this.redisplay();
    }

    @Override
    public void setProperty(int number, Object property) {
        switch (number) {
            case 1: {
                this.setHighColor(this.getInt(property));
                break;
            }
            case 2: {
                this.setLowColor(this.getInt(property));
                break;
            }
            case 3: {
                this.setFillColor(this.getInt(property));
                break;
            }
            case 4: {
                this.setFillPercent(this.getInt(property));
                break;
            }
            case 5: {
                this.setFillColor2(this.getInt(property));
                break;
            }
            case 6: {
                this.setTitlePosition(this.getInt(property));
                break;
            }
            default: {
                super.setProperty(number, property);
            }
        }
    }

    @Override
    public String getProperty(int number) {
        switch (number) {
            case 1: {
                return String.valueOf(this.getHighColor());
            }
            case 2: {
                return String.valueOf(this.getLowColor());
            }
            case 3: {
                return String.valueOf(this.getFillColor());
            }
            case 4: {
                return String.valueOf(this.getFillPercent());
            }
            case 5: {
                return String.valueOf(this.getFillColor2());
            }
            case 6: {
                return String.valueOf(this.getTitlePosition());
            }
        }
        return super.getProperty(number);
    }

    public void setHighColor(int value) {
        this.highColor = value;
        if (this.highColor > 0 && this.highColor <= 16) {
            this.highColorObject = LProgressBar.getCobolColor(this.highColor);
        }
        this.redisplay();
    }

    public int getHighColor() {
        return this.highColor;
    }

    public void setLowColor(int value) {
        this.lowColor = value;
        if (this.lowColor > 0 && this.lowColor <= 16) {
            this.lowColorObject = LProgressBar.getCobolColor(this.lowColor);
        }
        this.redisplay();
    }

    public int getLowColor() {
        return this.lowColor;
    }

    public void setFillColor(int value) {
        this.fillColor = value;
        if (this.fillColor > 0 && this.fillColor <= 16) {
            this.fillColorObject = LProgressBar.getCobolColor(this.fillColor);
            if (this.fillColor == 16) {
                this.fillColorObject = Color.white;
            }
            this.progressBar.setForeground(this.fillColorObject);
            this.progressBar.setBackground(this.fillColor2Object);
            this.progressBar.setVisible(true);
        } else {
            this.setOpaque(false);
            this.progressBar.setVisible(false);
        }
        this.redisplay();
    }

    public int getFillColor() {
        return this.fillColor;
    }

    public void setFillColor2(int value) {
        this.fillColor2 = value;
        if (this.fillColor2 > 0 && this.fillColor2 <= 16) {
            this.fillColor2Object = LProgressBar.getCobolColor(this.fillColor2);
            if (this.fillColor2 == 16) {
                this.fillColor2Object = Color.white;
            }
            this.progressBar.setBackground(this.fillColor2Object);
        }
    }

    public int getFillColor2() {
        return this.fillColor2;
    }

    private void refreshProgressBar() {
        ThreadQueue appThread = new ThreadQueue(){

            @Override
            public void run() {
                try {
                    SwingUtilities.invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            LProgressBar.this.progressBar.paintImmediately(LProgressBar.this.progressBar.getBounds());
                        }
                    });
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        };
        appThread.start();
    }

    public void setFillPercent(int value) {
        this.fillPercent = value;
        if (value < 0) {
            value = 0;
        } else if (value > 100) {
            value = 100;
        }
        if (this.progressBar != null) {
            this.progressBar.setValue(value);
            this.refreshProgressBar();
        }
    }

    public int getFillPercent() {
        return this.fillPercent;
    }

    public void setTitlePosition(int value) {
        this.titlePosition = value;
        this.redisplay();
    }

    public int getTitlePosition() {
        return this.titlePosition;
    }

    @Override
    public void setFont(Font f) {
        super.setFont(f);
        this.redisplay();
    }

    private void redisplay() {
        String displayTitle = this.cleanTitle;
        if (displayTitle != null && displayTitle.length() > 0) {
            displayTitle = " " + displayTitle;
        }
        Border border = this.getBorder();
        LBorder myBorder = null;
        int type = 0;
        if ((this.style & 1) != 0) {
            type = 1;
        }
        if ((this.style & 2) != 0) {
            type = 2;
        }
        if ((this.style & 4) != 0) {
            type = 3;
        }
        if ((this.style & 8) != 0) {
            type = 4;
        }
        int thickness = 1;
        if (type > 0) {
            thickness = 2;
        }
        if ((this.style & 0x10) != 0) {
            ++thickness;
        }
        if ((this.style & 0x20) != 0) {
            thickness += 2;
        }
        boolean alternate = (this.style & 0x40) != 0;
        int verticalOffset = 0;
        myBorder = new LBorder(verticalOffset, type, Color.black, this.highColorObject, this.lowColorObject, thickness, alternate, false);
        this.setLines(this.lines);
        this.setColumns(this.size);
        int titleJust = 0;
        int titlePos = 0;
        Color titleColor = this.getForeground();
        Font titleFont = this.getFont();
        switch (this.titlePosition) {
            default: {
                this.titlePosition = 1;
            }
            case 1: 
            case 4: {
                titleJust = 1;
                break;
            }
            case 2: 
            case 5: {
                titleJust = 2;
                break;
            }
            case 3: 
            case 6: {
                titleJust = 3;
            }
            case 7: 
        }
        this.progressBar.setStringPainted(this.titlePosition == 7);
        if (this.titlePosition != 7) {
            if (this.isFullHeight()) {
                if (this.titlePosition <= 3) {
                    titlePos = 3;
                } else if (this.titlePosition <= 6) {
                    titlePos = 4;
                }
            } else if (this.titlePosition <= 3) {
                titlePos = 2;
            } else if (this.titlePosition <= 6) {
                titlePos = 5;
            }
        }
        if (border instanceof LTitledBorder) {
            LTitledBorder b = (LTitledBorder)border;
            b.setBorder(myBorder);
            b.setTitleJustification(titleJust);
            b.setTitlePosition(titlePos);
            b.setTitleFont(titleFont);
            b.setTitleColor(titleColor);
            if (displayTitle != null && this.titlePosition != 7) {
                b.setTitle(displayTitle);
            } else {
                b.setTitlePosition(2);
                b.setTitle(null);
            }
        } else if (displayTitle == null || this.titlePosition == 7) {
            titlePos = 2;
            border = new LTitledBorder(border, null, titleJust, titlePos, titleFont, titleColor);
        } else {
            border = new LTitledBorder(border, displayTitle, titleJust, titlePos, titleFont, titleColor);
        }
        if (this.titlePosition == 7) {
            this.setBorder(myBorder);
        } else {
            this.setBorder(border);
        }
        this.repaint();
    }

    @Override
    public void setBackground(Color c) {
        super.setBackground(c);
        if (this.fillColor2 == 0) {
            this.fillColor2Object = c;
        }
        this.redisplay();
    }

    @Override
    public void setForeground(Color c) {
        super.setForeground(c);
        this.redisplay();
    }

    final class LTitledBorder
    extends AbstractBorder {
        protected String title;
        protected Border border;
        protected int titlePosition;
        protected int titleJustification;
        protected Font titleFont;
        protected Color titleColor;
        private Point textLoc = new Point();
        public static final int DEFAULT_POSITION = 0;
        public static final int ABOVE_TOP = 1;
        public static final int TOP = 2;
        public static final int BELOW_TOP = 3;
        public static final int ABOVE_BOTTOM = 4;
        public static final int BOTTOM = 5;
        public static final int BELOW_BOTTOM = 6;
        public static final int DEFAULT_JUSTIFICATION = 0;
        public static final int LEFT = 1;
        public static final int CENTER = 2;
        public static final int RIGHT = 3;
        public static final int LEADING = 4;
        public static final int TRAILING = 5;
        protected static final int EDGE_SPACING = 2;
        protected static final int TEXT_SPACING = 2;
        protected static final int TEXT_INSET_H = 5;

        public LTitledBorder(Border border, String title, int titleJustification, int titlePosition, Font titleFont, Color titleColor) {
            this.title = title;
            this.border = border;
            this.titleFont = titleFont;
            this.titleColor = titleColor;
            this.setTitleJustification(titleJustification);
            this.setTitlePosition(titlePosition);
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            Border border = this.getBorder();
            Rectangle grooveRect = new Rectangle(x + 2, y + 2, width - 4, height - 4);
            Font font2 = g.getFont();
            Color color2 = g.getColor();
            g.setFont(this.getFont(c));
            FontMetrics fm = g.getFontMetrics();
            int fontHeight = fm.getHeight();
            int descent = fm.getDescent();
            int ascent = fm.getAscent();
            int stringWidth = 0;
            String title = this.getTitle();
            if (title != null) {
                stringWidth = fm.stringWidth(title);
            }
            Insets insets = border != null ? border.getBorderInsets(c) : new Insets(0, 0, 0, 0);
            int titlePos = this.getTitlePosition();
            switch (titlePos) {
                case 1: {
                    int diff = ascent + descent + (Math.max(2, 4) - 2);
                    grooveRect.y += diff;
                    grooveRect.height -= diff;
                    this.textLoc.y = grooveRect.y - (descent + 2);
                    break;
                }
                case 0: 
                case 2: {
                    int diff = Math.max(0, ascent / 2 + 2 - 2);
                    grooveRect.y += diff;
                    grooveRect.height -= diff;
                    this.textLoc.y = grooveRect.y - descent + (insets.top + ascent + descent) / 2;
                    break;
                }
                case 3: {
                    this.textLoc.y = grooveRect.y + insets.top + ascent + 2;
                    break;
                }
                case 4: {
                    this.textLoc.y = grooveRect.y + grooveRect.height - (insets.bottom + descent + 2);
                    break;
                }
                case 5: {
                    grooveRect.height -= fontHeight / 2;
                    this.textLoc.y = grooveRect.y + grooveRect.height - descent + (ascent + descent - insets.bottom) / 2;
                    break;
                }
                case 6: {
                    grooveRect.height -= fontHeight;
                    this.textLoc.y = grooveRect.y + grooveRect.height + ascent + 2;
                }
            }
            int justification = this.getTitleJustification();
            if (width >= height) {
                if (justification == 4 || justification == 0) {
                    justification = 1;
                } else if (justification == 5) {
                    justification = 3;
                }
            } else if (justification == 4 || justification == 0) {
                justification = 3;
            } else if (justification == 5) {
                justification = 1;
            }
            switch (justification) {
                case 1: {
                    this.textLoc.x = grooveRect.x + 5 + insets.left;
                    break;
                }
                case 3: {
                    this.textLoc.x = grooveRect.x + grooveRect.width - (stringWidth + 5 + insets.right);
                    break;
                }
                case 2: {
                    this.textLoc.x = grooveRect.x + (grooveRect.width - stringWidth) / 2;
                }
            }
            if (border != null) {
                if (titlePos == 2 || titlePos == 5 || titlePos == 0) {
                    Rectangle clipRect = new Rectangle();
                    Rectangle saveClip = g.getClipBounds();
                    clipRect.setBounds(saveClip);
                    if (this.computeIntersection(clipRect, x, y, this.textLoc.x, height)) {
                        g.setClip(clipRect);
                        border.paintBorder(c, g, grooveRect.x, grooveRect.y, grooveRect.width, grooveRect.height);
                    }
                    clipRect.setBounds(saveClip);
                    if (this.computeIntersection(clipRect, this.textLoc.x + stringWidth, 0, width - stringWidth - this.textLoc.x, height)) {
                        g.setClip(clipRect);
                        border.paintBorder(c, g, grooveRect.x, grooveRect.y, grooveRect.width, grooveRect.height);
                    }
                    clipRect.setBounds(saveClip);
                    if (titlePos == 2 || titlePos == 0) {
                        if (this.computeIntersection(clipRect, this.textLoc.x, grooveRect.y + insets.top, stringWidth, height - grooveRect.y - insets.top)) {
                            g.setClip(clipRect);
                            border.paintBorder(c, g, grooveRect.x, grooveRect.y, grooveRect.width, grooveRect.height);
                        }
                    } else if (this.computeIntersection(clipRect, this.textLoc.x, y, stringWidth, height - insets.bottom - (height - grooveRect.height - grooveRect.y))) {
                        g.setClip(clipRect);
                        border.paintBorder(c, g, grooveRect.x, grooveRect.y, grooveRect.width, grooveRect.height);
                    }
                    g.setClip(saveClip);
                } else {
                    border.paintBorder(c, g, grooveRect.x, grooveRect.y, grooveRect.width, grooveRect.height);
                }
            }
            g.setColor(this.getTitleColor());
            if (title != null) {
                g.drawString(title, this.textLoc.x, this.textLoc.y);
            }
            g.setFont(font2);
            g.setColor(color2);
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return this.getBorderInsets(c, new Insets(0, 0, 0, 0));
        }

        @Override
        public Insets getBorderInsets(Component c, Insets insets) {
            int descent = 0;
            int ascent = 16;
            Border border = this.getBorder();
            if (border != null) {
                if (border instanceof AbstractBorder) {
                    ((AbstractBorder)border).getBorderInsets(c, insets);
                } else {
                    Insets i = border.getBorderInsets(c);
                    insets.top = i.top;
                    insets.right = i.right;
                    insets.bottom = i.bottom;
                    insets.left = i.left;
                }
            } else {
                insets.bottom = 0;
                insets.right = 0;
                insets.top = 0;
                insets.left = 0;
            }
            if (c == null) {
                return insets;
            }
            insets.left += 4;
            insets.right += 4;
            insets.top += 4;
            insets.bottom += 4;
            Font font2 = this.getFont(c);
            FontMetrics fm = c.getFontMetrics(font2);
            if (fm != null) {
                descent = fm.getDescent();
                ascent = fm.getAscent();
            }
            switch (this.getTitlePosition()) {
                case 1: {
                    insets.top += ascent + descent + (Math.max(2, 4) - 2);
                    break;
                }
                case 0: 
                case 2: {
                    insets.top += ascent + descent;
                    break;
                }
                case 3: {
                    insets.top += ascent + descent + 2;
                    break;
                }
                case 4: {
                    insets.bottom += ascent + descent + 2;
                    break;
                }
                case 5: {
                    insets.bottom += ascent + descent;
                    break;
                }
                case 6: {
                    insets.bottom += ascent + 2;
                }
            }
            return insets;
        }

        @Override
        public boolean isBorderOpaque() {
            return false;
        }

        public String getTitle() {
            return this.title;
        }

        public Border getBorder() {
            Border b = this.border;
            if (b == null) {
                b = UIManager.getBorder("TitledBorder.border");
            }
            return b;
        }

        public int getTitlePosition() {
            return this.titlePosition;
        }

        public int getTitleJustification() {
            return this.titleJustification;
        }

        public Font getTitleFont() {
            Font f = this.titleFont;
            if (f == null) {
                f = UIManager.getFont("TitledBorder.font");
            }
            return f;
        }

        public Color getTitleColor() {
            Color c = this.titleColor;
            if (c == null) {
                c = UIManager.getColor("TitledBorder.titleColor");
            }
            return c;
        }

        public void setTitle(String title) {
            this.title = title;
        }

        public void setBorder(Border border) {
            this.border = border;
        }

        public void setTitlePosition(int titlePosition) {
            switch (titlePosition) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    this.titlePosition = titlePosition;
                    break;
                }
                default: {
                    throw new IllegalArgumentException(titlePosition + " is not a valid title position.");
                }
            }
        }

        public void setTitleJustification(int titleJustification) {
            switch (titleJustification) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    this.titleJustification = titleJustification;
                    break;
                }
                default: {
                    throw new IllegalArgumentException(titleJustification + " is not a valid title justification.");
                }
            }
        }

        public void setTitleFont(Font titleFont) {
            this.titleFont = titleFont;
        }

        public void setTitleColor(Color titleColor) {
            this.titleColor = titleColor;
        }

        public Dimension getMinimumSize(Component c) {
            Insets insets = this.getBorderInsets(c);
            Dimension minSize = new Dimension(insets.right + insets.left, insets.top + insets.bottom);
            Font font2 = this.getFont(c);
            FontMetrics fm = c.getFontMetrics(font2);
            switch (this.titlePosition) {
                case 1: 
                case 6: {
                    minSize.width = Math.max(fm.stringWidth(this.getTitle()), minSize.width);
                    break;
                }
                default: {
                    minSize.width += fm.stringWidth(this.getTitle());
                }
            }
            return minSize;
        }

        protected Font getFont(Component c) {
            Font font2 = this.getTitleFont();
            if (font2 != null) {
                return font2;
            }
            if (c != null && (font2 = c.getFont()) != null) {
                return font2;
            }
            return new Font("Dialog", 0, 12);
        }

        private boolean computeIntersection(Rectangle dest, int rx, int ry, int rw, int rh) {
            int x1 = Math.max(rx, dest.x);
            int x2 = Math.min(rx + rw, dest.x + dest.width);
            int y1 = Math.max(ry, dest.y);
            int y2 = Math.min(ry + rh, dest.y + dest.height);
            dest.x = x1;
            dest.y = y1;
            dest.width = x2 - x1;
            dest.height = y2 - y1;
            return dest.width > 0 && dest.height > 0;
        }
    }

    class LBorder
    extends AbstractBorder {
        public static final int RAISED = 0;
        public static final int LOWERED = 1;
        protected int etchType;
        protected Color highlightOuter;
        protected Color highlightInner;
        protected Color shadowInner;
        protected Color shadowOuter;
        protected Color lineColor;
        protected int type;
        protected int thickness = 1;
        protected boolean alternate = false;
        protected boolean roundedCorners = false;
        protected int verticalOffset = 0;

        public void setHighlight(Color value) {
            this.highlightOuter = value;
            if (this.highlightOuter != null) {
                this.highlightOuter = this.highlightOuter.brighter();
            }
            this.highlightInner = value;
        }

        public void setShadow(Color value) {
            this.shadowOuter = value;
            this.shadowInner = value;
            if (this.shadowInner != null) {
                this.shadowInner = this.shadowInner.brighter();
            }
        }

        public void setNormal() {
            this.type = 0;
        }

        public void setRaised() {
            this.type = 1;
        }

        public void setLowered() {
            this.type = 2;
        }

        public void setEngraved() {
            this.type = 3;
        }

        public void setRimmed() {
            this.type = 4;
        }

        public boolean isNormal() {
            return this.type == 0;
        }

        public boolean isRaised() {
            return this.type == 1;
        }

        public boolean isLowered() {
            return this.type == 2;
        }

        public boolean isEngraved() {
            return this.type == 3;
        }

        public boolean isRimmed() {
            return this.type == 4;
        }

        public void setDefault() {
            this.thickness = 1;
        }

        public void setHeavy() {
            this.thickness = 2;
        }

        public void setVeryHeavy() {
            this.thickness = 3;
        }

        public boolean isDefault() {
            return this.thickness == 1;
        }

        public boolean isHeavy() {
            return this.thickness == 2;
        }

        public boolean isVeryHeavy() {
            return this.thickness == 3;
        }

        public void setAlternate(boolean state) {
            this.alternate = state;
        }

        public boolean isAlternate() {
            return this.alternate;
        }

        public LBorder(int verticalOffset, int type, Color lineColor, Color highlight, Color shadow, int thickness, boolean alternate, boolean roundedCorners) {
            this.verticalOffset = verticalOffset;
            this.lineColor = lineColor;
            this.type = type;
            this.setHighlight(highlight);
            this.setShadow(shadow);
            this.thickness = thickness;
            this.alternate = alternate;
            this.roundedCorners = roundedCorners;
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            if (height > this.verticalOffset) {
                y += this.verticalOffset;
                height -= this.verticalOffset;
            }
            if (this.type == 0) {
                Color oldColor = g.getColor();
                g.setColor(c.getForeground());
                if (!this.roundedCorners) {
                    if (this.alternate) {
                        g.drawRect(x, y, width - 1, height - 1);
                        int i = this.thickness - 1;
                        g.drawRect(x + i, y + i, width - i - i - 1, height - i - i - 1);
                    } else {
                        for (int i = 0; i < this.thickness; ++i) {
                            g.drawRect(x + i, y + i, width - i - i - 1, height - i - i - 1);
                        }
                    }
                } else if (this.alternate) {
                    g.drawRoundRect(x, y, width - 1, height - 1, 2, 2);
                    int i = this.thickness - 1;
                    g.drawRoundRect(x + i, y + i, width - i - i - 1, height - i - i - 1, 2, 2);
                } else {
                    for (int i = 0; i < this.thickness; ++i) {
                        g.drawRoundRect(x + i, y + i, width - i - i - 1, height - i - i - 1, 2, 2);
                    }
                }
                g.setColor(oldColor);
            } else if (this.type == 1) {
                this.paintRaisedBevel(c, g, x, y, width, height, this.thickness);
            } else if (this.type == 2) {
                this.paintLoweredBevel(c, g, x, y, width, height, this.thickness);
            } else if (this.type == 3 || this.type == 4) {
                int w = width;
                int h = height;
                g.translate(x, y);
                int half = this.thickness / 2;
                int i = 0;
                g.setColor(this.type == 4 ? this.getShadowColor(c) : this.getHighlightColor(c));
                for (i = half; i < this.thickness; ++i) {
                    g.drawRect(i, i, w - this.thickness, h - this.thickness);
                }
                g.setColor(this.type == 4 ? this.getHighlightColor(c) : this.getShadowColor(c));
                for (i = 0; i < half; ++i) {
                    g.drawRect(i, i, w - this.thickness, h - this.thickness);
                }
                g.translate(-x, -y);
            }
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return new Insets(this.thickness, this.thickness, this.thickness, this.thickness);
        }

        @Override
        public Insets getBorderInsets(Component c, Insets insets) {
            insets.right = insets.bottom = this.thickness;
            insets.top = insets.bottom;
            insets.left = insets.bottom;
            return insets;
        }

        @Override
        public boolean isBorderOpaque() {
            return true;
        }

        public Color getHighlightColor(Component c) {
            return this.highlightInner != null ? this.highlightInner : c.getBackground().brighter();
        }

        public Color getShadowColor(Component c) {
            return this.shadowOuter != null ? this.shadowOuter : c.getBackground().darker();
        }

        protected void paintRaisedBevel(Component c, Graphics g, int x, int y, int width, int height, int thickness) {
            Color oldColor = g.getColor();
            int h = height;
            int w = width;
            g.translate(x, y);
            g.setColor(this.getHighlightOuterColor(c));
            g.drawLine(0, 0, 0, h - 1);
            g.drawLine(1, 0, w - 1, 0);
            g.setColor(this.getShadowOuterColor(c));
            g.drawLine(1, h - 1, w - 1, h - 1);
            g.drawLine(w - 1, 1, w - 1, h - 2);
            for (int i = 1; i < thickness; ++i) {
                g.setColor(this.getHighlightInnerColor(c));
                g.drawLine(i, i, i, h - 1 - i);
                g.drawLine(i + 1, i, w - 1 - i, i);
                g.setColor(this.getShadowInnerColor(c));
                g.drawLine(i + 1, h - i - 1, w - i - 1, h - i - 1);
                g.drawLine(w - i - 1, i + 1, w - i - 1, h - i - 2);
            }
            g.translate(-x, -y);
            g.setColor(oldColor);
        }

        protected void paintLoweredBevel(Component c, Graphics g, int x, int y, int width, int height, int thickness) {
            Color oldColor = g.getColor();
            int h = height;
            int w = width;
            g.translate(x, y);
            g.setColor(this.getShadowInnerColor(c));
            g.drawLine(0, 0, 0, h - 1);
            g.drawLine(1, 0, w - 1, 0);
            g.setColor(this.getHighlightOuterColor(c));
            g.drawLine(1, h - 1, w - 1, h - 1);
            g.drawLine(w - 1, 1, w - 1, h - 2);
            for (int i = 1; i < thickness; ++i) {
                g.setColor(this.getShadowOuterColor(c));
                g.drawLine(i, i, i, h - i - 1);
                g.drawLine(i + 1, i, w - i - 1, i);
                g.setColor(this.getHighlightInnerColor(c));
                g.drawLine(i + 1, h - i - 1, w - i - 1, h - i - 1);
                g.drawLine(w - i - 1, i + 1, w - i - 1, h - i - 2);
            }
            g.translate(-x, -y);
            g.setColor(oldColor);
        }

        public Color getHighlightOuterColor(Component c) {
            return this.highlightOuter != null ? this.highlightOuter : c.getBackground().brighter().brighter();
        }

        public Color getHighlightInnerColor(Component c) {
            return this.highlightInner != null ? this.highlightInner : c.getBackground().brighter();
        }

        public Color getShadowInnerColor(Component c) {
            return this.shadowInner != null ? this.shadowInner : c.getBackground().darker();
        }

        public Color getShadowOuterColor(Component c) {
            return this.shadowOuter != null ? this.shadowOuter : c.getBackground().darker().darker();
        }
    }
}

