/*
 * Decompiled with CFR 0.152.
 */
package com.heirloomcomputing.ecs.jfc;

import com.heirloomcomputing.ecs.exec.AcceptEvent;
import com.heirloomcomputing.ecs.jfc.LComponent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JScrollBar;
import javax.swing.border.EtchedBorder;

public final class LScrollBar
extends LComponent
implements FocusListener,
AdjustmentListener,
KeyListener {
    private JScrollBar scrollbar;
    private int pageSize;

    public LScrollBar() {
        this.setBorder(new EtchedBorder(1));
        this.scrollbar = new JScrollBar(1);
        this.setLayout(new BorderLayout());
        this.add((Component)this.scrollbar, "Center");
        Dimension d = this.scrollbar.getPreferredSize();
        int min = Math.min(d.width, d.height);
        this.minimumWidth = min + 4;
        this.minimumHeight = min + 4;
        this.lines = 1.0;
        this.size = 1.0;
    }

    @Override
    public void keyPressed(KeyEvent event) {
    }

    @Override
    public void keyReleased(KeyEvent event) {
        if (event.getModifiers() == 0) {
            int keyCode = event.getKeyCode();
            if (keyCode == 38) {
                return;
            }
            if (keyCode == 40) {
                return;
            }
            if (keyCode == 37) {
                return;
            }
            if (keyCode == 39) {
                return;
            }
        }
        this.processKey(this, event);
    }

    @Override
    public void keyTyped(KeyEvent event) {
    }

    @Override
    public void adjustmentValueChanged(AdjustmentEvent event) {
        this.updateValue();
        if (this.exceptionValue != 0) {
            this.processAcceptKey(new AcceptEvent(this.getHandle(), 2, this.exceptionValue, event));
        } else if (this.terminationValue != 0) {
            this.processAcceptKey(new AcceptEvent(this.getHandle(), 1, this.terminationValue, event));
        } else {
            switch (event.getAdjustmentType()) {
                case 3: {
                    this.processAcceptEvent(new AcceptEvent(this.getHandle(), 0, 16388, event, 0, event.getValue() + 1));
                    break;
                }
                case 4: {
                    this.processAcceptEvent(new AcceptEvent(this.getHandle(), 0, 16387, event, 0, event.getValue() + 1));
                    break;
                }
                case 2: {
                    this.processAcceptEvent(new AcceptEvent(this.getHandle(), 0, 16386, event, 0, event.getValue() + 1));
                    break;
                }
                case 1: {
                    this.processAcceptEvent(new AcceptEvent(this.getHandle(), 0, 16385, event, 0, event.getValue() + 1));
                    break;
                }
                case 5: {
                    if (this.scrollbar.getValueIsAdjusting()) {
                        if (!this.isTrackThumb()) break;
                        this.processAcceptEvent(new AcceptEvent(this.getHandle(), 0, 16390, event, 0, event.getValue() + 1));
                        break;
                    }
                    this.processAcceptEvent(new AcceptEvent(this.getHandle(), 0, 16389, event, 0, event.getValue() + 1));
                }
            }
        }
    }

    @Override
    public void focusGained(FocusEvent event) {
        if (!this.isSelfAct() && this.processGotoEvent(new AcceptEvent(this.getHandle(), 0, 3, event))) {
            return;
        }
    }

    @Override
    public void focusLost(FocusEvent event) {
        if (event.isTemporary()) {
            return;
        }
        if (this.processAcceptEvent(new AcceptEvent(this.getHandle(), 0, 16391, event))) {
            this.requestFocus();
            return;
        }
    }

    public void addConstantListeners() {
        try {
            this.scrollbar.addFocusListener(this);
            this.scrollbar.addAdjustmentListener(this);
            this.scrollbar.addKeyListener(this);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void removeConstantListeners() {
        try {
            this.scrollbar.removeFocusListener(this);
            this.scrollbar.removeAdjustmentListener(this);
            this.scrollbar.removeKeyListener(this);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.addConstantListeners();
    }

    @Override
    public void removeNotify() {
        this.removeConstantListeners();
        super.removeNotify();
    }

    @Override
    public boolean isManagingFocus() {
        return true;
    }

    @Override
    public void requestChildFocus() {
        this.scrollbar.requestFocus();
    }

    @Override
    public boolean hasFocusChild() {
        return this.hasFocus() || this.scrollbar.hasFocus();
    }

    @Override
    public int getControlType() {
        return 6;
    }

    public JScrollBar getJScrollBar() {
        return this.scrollbar;
    }

    @Override
    public int getUnitWidth() {
        return this.getCellWidth();
    }

    @Override
    public int getUnitHeight() {
        return this.getCellHeight();
    }

    @Override
    public void setCleanTitle(String s) {
        this.scrollbar.setToolTipText(s);
    }

    @Override
    public void setValue(String s) {
        this.setValue(Integer.parseInt(s.trim()));
    }

    public void setValue(int value) {
        this.scrollbar.setValue(value);
    }

    @Override
    public String getValue() {
        return String.valueOf(this.scrollbar.getValue());
    }

    public void setMinVal(int value) {
        this.scrollbar.setMinimum(value);
    }

    public void setMaxVal(int value) {
        this.scrollbar.setMaximum(value);
    }

    public int getMinVal() {
        return this.scrollbar.getMinimum();
    }

    public int getMaxVal() {
        return this.scrollbar.getMaximum();
    }

    public void setPageSize(int value) {
        this.pageSize = value;
        this.scrollbar.setVisibleAmount(this.pageSize);
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public boolean isHorizontal() {
        return this.isStyle(1);
    }

    public int getHorizontal() {
        return this.isHorizontal() ? 1 : 0;
    }

    public void setHorizontal() {
        this.setStyleOn(1);
    }

    public void setHorizontal(boolean state) {
        this.setStyle(1, state);
    }

    public boolean isTrackThumb() {
        return this.isStyle(2);
    }

    public int getTrackThumb() {
        return this.isTrackThumb() ? 1 : 0;
    }

    public void setTrackThumb() {
        this.setStyleOn(2);
    }

    public void setTrackThumb(boolean state) {
        this.setStyle(2, state);
    }

    @Override
    public void setStyle(int mask) {
        int change = this.style ^ mask;
        if ((change & 1) == 1) {
            if ((mask & 1) == 1) {
                this.scrollbar.setOrientation(0);
            } else {
                this.scrollbar.setOrientation(1);
            }
        }
        super.setStyle(mask);
    }

    @Override
    public void setProperty(int number, Object property) {
        switch (number) {
            case 1: {
                this.setMinVal(this.getInt(property));
                break;
            }
            case 2: {
                this.setMaxVal(this.getInt(property));
                break;
            }
            case 3: {
                this.setPageSize(this.getInt(property));
                break;
            }
            default: {
                super.setProperty(number, property);
            }
        }
    }

    @Override
    public String getProperty(int number) {
        switch (number) {
            case 1: {
                return String.valueOf(this.getMinVal());
            }
            case 2: {
                return String.valueOf(this.getMaxVal());
            }
            case 3: {
                return String.valueOf(this.getPageSize());
            }
        }
        return super.getProperty(number);
    }

    @Override
    public Dimension getPreferredSize() {
        return this.scrollbar.getPreferredSize();
    }

    @Override
    public Dimension getMinimumSize() {
        return this.scrollbar.getMinimumSize();
    }

    @Override
    public Dimension getMaximumSize() {
        return this.scrollbar.getMaximumSize();
    }

    @Override
    public void setBackground(Color c) {
        if (COMPATIBILITY <= 1) {
            this.scrollbar.setBackground(c);
            super.setBackground(c);
        }
    }

    @Override
    public void setForeground(Color c) {
        if (COMPATIBILITY <= 1) {
            this.scrollbar.setForeground(c);
            super.setForeground(c);
        }
    }

    @Override
    public void setOpaque(boolean state) {
        this.scrollbar.setOpaque(state);
        super.setOpaque(state);
    }

    @Override
    public void setFont(Font f) {
        this.scrollbar.setFont(f);
        super.setFont(f);
    }

    @Override
    public void setEnabled(boolean state) {
        this.scrollbar.setEnabled(state);
        super.setEnabled(state);
    }
}

