/*
 * Decompiled with CFR 0.152.
 */
package com.heirloomcomputing.ecs.jfc;

import com.heirloomcomputing.ecs.jfc.LComponent;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Vector;

public final class LStatusBar
extends LComponent
implements KeyListener {
    public static final int FLAT = 0;
    public static final int LOWERED = 1;
    public static final int RAISED = 2;
    private int styleIndex = 1;
    private int widthIndex = 1;
    private int textIndex = 1;
    private final Vector<Integer> styles = new Vector();
    private final Vector<Integer> widths = new Vector();
    private final Vector<String> text = new Vector();
    private int currentStyle;
    private Color highlightOuter;
    private Color highlightInner;
    private Color shadowOuter;
    private Color shadowInner;

    public LStatusBar() {
        this.lines = 1.0;
    }

    @Override
    public void keyPressed(KeyEvent event) {
    }

    @Override
    public void keyReleased(KeyEvent event) {
        this.processKey(this, event);
    }

    @Override
    public void keyTyped(KeyEvent event) {
    }

    public void addConstantListeners() {
        this.addKeyListener(this);
    }

    public void removeConstantListeners() {
        this.removeKeyListener(this);
    }

    @Override
    public int getControlType() {
        return 1004;
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.addConstantListeners();
        this.setBackground(super.getBackground());
    }

    @Override
    public void removeNotify() {
        this.removeConstantListeners();
        super.removeNotify();
    }

    @Override
    public boolean isFocusTraversable() {
        return false;
    }

    @Override
    public boolean isAcceptable() {
        return false;
    }

    @Override
    public boolean isSpecialDisplay() {
        return true;
    }

    @Override
    public void setCleanTitle(String value) {
        this.setPanelText(value);
    }

    public boolean isGrip() {
        return this.isStyle(1);
    }

    public int getGrip() {
        return this.isGrip() ? 1 : 0;
    }

    public void setGrip() {
        this.setStyleOn(1);
    }

    public void setGrip(boolean state) {
        this.setStyle(1, state);
    }

    @Override
    public void setProperty(int number, Object property) {
        switch (number) {
            case 1: {
                this.setPanelWidths(this.getInt(property));
                break;
            }
            case 2: {
                this.setPanelStyle(this.getInt(property));
                break;
            }
            case 3: {
                this.setPanelText(this.getString(property));
                break;
            }
            case 4: {
                this.setPanelIndex(this.getInt(property));
                break;
            }
            default: {
                super.setProperty(number, property);
            }
        }
    }

    @Override
    public String getProperty(int number) {
        switch (number) {
            case 1: {
                return String.valueOf(this.getPanelWidths());
            }
            case 2: {
                return String.valueOf(this.getPanelStyle());
            }
            case 3: {
                return String.valueOf(this.getPanelText());
            }
            case 4: {
                return String.valueOf(this.getPanelIndex());
            }
        }
        return super.getProperty(number);
    }

    public void setPanelWidths(int value) {
        if (value >= 0) {
            if (this.widths.size() < this.widthIndex) {
                this.widths.setSize(this.widthIndex);
            }
            this.widths.ensureCapacity(this.widthIndex + 1);
            this.widths.setElementAt(new Integer(value), this.widthIndex - 1);
            ++this.widthIndex;
        } else {
            this.widthIndex = 1;
        }
    }

    public int getPanelWidths() {
        return this.widthIndex;
    }

    public void setPanelStyle(int value) {
        if (value >= 0 && value <= 2) {
            if (this.styles.size() < this.styleIndex) {
                this.styles.setSize(this.styleIndex);
            }
            this.styles.setElementAt(new Integer(value), this.styleIndex - 1);
            ++this.styleIndex;
        } else {
            this.styleIndex = 1;
        }
    }

    public int getPanelStyle() {
        return this.styleIndex;
    }

    public void setPanelText(String value) {
        if (value != null) {
            if (this.text.size() < this.textIndex) {
                this.text.setSize(this.textIndex);
            }
            this.text.setElementAt(value, this.textIndex - 1);
            ++this.textIndex;
        } else {
            this.textIndex = 1;
        }
        this.repaint();
    }

    public int getPanelText() {
        return this.textIndex;
    }

    public void setPanelIndex(int value) {
        this.widthIndex = this.textIndex = value;
        this.styleIndex = this.textIndex;
    }

    public int getPanelIndex() {
        int max = this.styleIndex;
        if (this.widthIndex > max) {
            max = this.widthIndex;
        }
        if (this.textIndex > max) {
            max = this.textIndex;
        }
        return max;
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(this.getCellWidth() * 256, this.getCellHeight() + 4);
    }

    @Override
    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    @Override
    public void setBackground(Color c) {
        this.highlightOuter = LStatusBar.doubleBrighter(c);
        this.highlightInner = c.brighter();
        this.shadowOuter = LStatusBar.doubleDarker(c);
        this.shadowInner = c.darker();
        super.setBackground(c);
    }

    @Override
    public void paint(Graphics g) {
        int h;
        super.paint(g);
        Color oldColor = g.getColor();
        Color fore = this.getForeground();
        Color back = this.getBackground();
        Font f = this.getFont();
        FontMetrics fm = g.getFontMetrics(f);
        int widthSize = this.widths.size();
        int w = 0;
        int x = 0;
        int y = fm.getHeight() - 3;
        int styleSize = this.styles.size();
        int textSize = this.text.size();
        String textValue = null;
        int fullHeight = h = this.getSize().height;
        int fullWidth = this.getSize().width;
        g.setColor(back);
        g.fillRect(0, 0, fullWidth, fullHeight);
        for (int i = 0; i < textSize; ++i) {
            Object o;
            try {
                if (i < widthSize) {
                    o = this.widths.elementAt(i);
                    if (o != null) {
                        w = (Integer)o;
                        w *= this.getCellWidth();
                    }
                } else {
                    w = this.getParent().getSize().width;
                }
            }
            catch (Exception e) {
                w = -1;
            }
            try {
                if (i < styleSize && (o = this.styles.elementAt(i)) != null) {
                    this.currentStyle = (Integer)o;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (w >= 0) {
                try {
                    switch (this.currentStyle) {
                        case 2: {
                            g.setColor(this.highlightOuter);
                            g.drawLine(x, 0, x, h - 1);
                            g.drawLine(x + 1, 0, x + w - 1, 0);
                            g.setColor(this.highlightInner);
                            g.drawLine(x + 1, 1, x + 1, h - 2);
                            g.drawLine(x + 2, 1, x + w - 2, 1);
                            g.setColor(this.shadowOuter);
                            g.drawLine(x + 1, h - 1, x + w - 1, h - 1);
                            g.drawLine(x + w - 1, 1, x + w - 1, h - 2);
                            g.setColor(this.shadowInner);
                            g.drawLine(x + 2, h - 2, x + w - 2, h - 2);
                            g.drawLine(x + w - 2, 2, x + w - 2, h - 3);
                            break;
                        }
                        case 1: {
                            g.setColor(this.shadowInner);
                            g.drawLine(x, 0, x, h - 1);
                            g.drawLine(x + 1, 0, x + w - 1, 0);
                            g.setColor(this.shadowOuter);
                            g.drawLine(x + 1, 1, x + 1, h - 2);
                            g.drawLine(x + 2, 1, x + w - 2, 1);
                            g.setColor(this.highlightOuter);
                            g.drawLine(x + 1, h - 1, x + w - 1, h - 1);
                            g.drawLine(x + w - 1, 1, x + w - 1, h - 2);
                            g.setColor(this.highlightInner);
                            g.drawLine(x + 2, h - 2, x + w - 2, h - 2);
                            g.drawLine(x + w - 2, 2, x + w - 2, h - 3);
                            break;
                        }
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            textValue = null;
            try {
                if (i < textSize && (o = this.text.elementAt(i)) != null) {
                    textValue = o.toString();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (textValue != null) {
                g.setColor(fore);
                g.drawString(textValue, x + 2, y);
            }
            x += w;
        }
        g.setColor(oldColor);
    }
}

