/*
 * Decompiled with CFR 0.152.
 */
package com.heirloomcomputing.ecs.jfc;

import com.heirloomcomputing.ecs.exec.AcceptEvent;
import com.heirloomcomputing.ecs.exec.Handle;
import com.heirloomcomputing.ecs.jfc.LBitmap;
import com.heirloomcomputing.ecs.jfc.LComponent;
import com.heirloomcomputing.ecs.jfc.LDynamicTreeNode;
import com.heirloomcomputing.ecs.jfc.LTreeUI;
import com.heirloomcomputing.ecs.jfc.SJTree;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.border.BevelBorder;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.TreePath;

public class LTreeView
extends LComponent
implements FocusListener,
TreeExpansionListener,
TreeSelectionListener,
TreeWillExpandListener,
MouseListener,
KeyListener {
    private SJTree tree;
    private JScrollPane scrollpane;
    private Border defaultTreeBorder;
    private Border defaultScrollpaneBorder;
    private LDynamicTreeNode currentNode;
    private LDynamicTreeNode parentNode;
    private TreePath currentPath;
    private LBitmap bitmapComponent;
    private int parentItem;
    private int placement;
    private int item;
    private int bitmapHandle;
    private int bitmapWidth = 16;
    private int nextItem;
    private int itemToDelete;
    private int resetList;
    private int ensureVisible;
    private int expand;
    private int itemToEmpty;
    private int itemToAdd;

    public LTreeView() {
        this.setLayout(new BorderLayout());
        this.setReverseOrder(false);
        this.tree = new SJTree();
        this.scrollpane = new JScrollPane(this.tree);
        this.add((Component)this.scrollpane, "Center");
        this.currentNode = this.tree.getRoot();
        this.defaultScrollpaneBorder = this.scrollpane.getBorder();
        this.defaultTreeBorder = this.tree.getBorder();
        this.size = 12.0;
        this.lines = 5.0;
    }

    @Override
    public void keyPressed(KeyEvent event) {
    }

    @Override
    public void keyReleased(KeyEvent event) {
        int keyCode = event.getKeyCode();
        if (keyCode == 38) {
            return;
        }
        if (keyCode == 40) {
            return;
        }
        if (keyCode == 37) {
            return;
        }
        if (keyCode == 39) {
            return;
        }
        if (keyCode == 10) {
            return;
        }
        this.processKey(this, event);
    }

    @Override
    public void keyTyped(KeyEvent event) {
    }

    public void addConstantListeners() {
        try {
            this.tree.addFocusListener(this);
            this.tree.addTreeExpansionListener(this);
            this.tree.addTreeSelectionListener(this);
            this.tree.addTreeWillExpandListener(this);
            this.tree.addMouseListener(this);
            this.tree.addKeyListener(this);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void removeConstantListeners() {
        try {
            this.tree.removeFocusListener(this);
            this.tree.removeMouseListener(this);
            this.tree.removeTreeWillExpandListener(this);
            this.tree.removeTreeSelectionListener(this);
            this.tree.removeTreeExpansionListener(this);
            this.tree.removeKeyListener(this);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public void valueChanged(TreeSelectionEvent event) {
        try {
            int id = ((LDynamicTreeNode)event.getNewLeadSelectionPath().getLastPathComponent()).getId();
            int why = 1;
            if (this.processAcceptEvent(new AcceptEvent(this.getHandle(), 0, 16411, event, why, id))) {
                return;
            }
            if (this.processAcceptEvent(new AcceptEvent(this.getHandle(), 0, 16412, event, why, id))) {
                return;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public void mouseClicked(MouseEvent event) {
        try {
            LDynamicTreeNode treeNode;
            TreePath selPath;
            int selRow;
            if (event.getClickCount() == 2 && (selRow = this.tree.getRowForLocation(event.getX(), event.getY())) != -1 && (selPath = this.tree.getPathForLocation(event.getX(), event.getY())) != null && (treeNode = (LDynamicTreeNode)selPath.getLastPathComponent()).isLeaf()) {
                int id = ((LDynamicTreeNode)selPath.getLastPathComponent()).getId();
                if (this.exceptionValue != 0) {
                    this.processAcceptKey(new AcceptEvent(this.getHandle(), 2, this.exceptionValue, event, id));
                } else if (this.terminationValue != 0) {
                    this.processAcceptKey(new AcceptEvent(this.getHandle(), 1, this.terminationValue, event, id));
                } else {
                    this.processAcceptEvent(new AcceptEvent(this.getHandle(), 0, 16428, event, 0, id));
                }
                event.consume();
                return;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        super.mouseClicked(event);
    }

    @Override
    public void mouseEntered(MouseEvent event) {
        super.mouseEntered(event);
    }

    @Override
    public void mouseExited(MouseEvent event) {
        super.mouseExited(event);
    }

    @Override
    public void mousePressed(MouseEvent event) {
        super.mousePressed(event);
    }

    @Override
    public void mouseReleased(MouseEvent event) {
        super.mouseReleased(event);
    }

    @Override
    public void treeExpanded(TreeExpansionEvent event) {
        if (this.tree.quiet) {
            return;
        }
        try {
            LDynamicTreeNode node = this.getDynamicTreeNode(event.getPath());
            int id = node.getId();
            this.setEventItem(id);
            this.processAcceptEvent(new AcceptEvent(this.getHandle(), 0, 16414, event, 2, id));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public void treeCollapsed(TreeExpansionEvent event) {
        if (this.tree.quiet) {
            return;
        }
        try {
            LDynamicTreeNode node = this.getDynamicTreeNode(event.getPath());
            int id = node.getId();
            this.setEventItem(id);
            this.processAcceptEvent(new AcceptEvent(this.getHandle(), 0, 16414, event, 1, id));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private LDynamicTreeNode getDynamicTreeNode(TreePath path) {
        return (LDynamicTreeNode)path.getLastPathComponent();
    }

    @Override
    public void treeWillExpand(TreeExpansionEvent event) {
        if (this.tree.quiet) {
            return;
        }
        try {
            LDynamicTreeNode node = this.getDynamicTreeNode(event.getPath());
            int id = node.getId();
            this.setEventItem(id);
            this.processAcceptEvent(new AcceptEvent(this.getHandle(), 0, 16413, event, 2, id));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public void treeWillCollapse(TreeExpansionEvent event) {
        if (this.tree.quiet) {
            return;
        }
        try {
            LDynamicTreeNode node = this.getDynamicTreeNode(event.getPath());
            int id = node.getId();
            this.setEventItem(id);
            this.processAcceptEvent(new AcceptEvent(this.getHandle(), 0, 16413, event, 1, id));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void setEventItem(int id) {
        this.setItem(id);
        this.setParentItem(id);
    }

    @Override
    public void focusGained(FocusEvent event) {
        if (!this.isSelfAct() && this.processGotoEvent(new AcceptEvent(this.getHandle(), 0, 3, event))) {
            return;
        }
    }

    @Override
    public void focusLost(FocusEvent event) {
        if (event.isTemporary()) {
            return;
        }
        if (this.processAcceptEvent(new AcceptEvent(this.getHandle(), 0, 16391, event))) {
            this.requestFocus();
            return;
        }
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.addConstantListeners();
    }

    @Override
    public void removeNotify() {
        this.removeConstantListeners();
        super.removeNotify();
    }

    @Override
    public boolean isManagingFocus() {
        return true;
    }

    @Override
    public void requestChildFocus() {
        this.tree.requestFocus();
    }

    @Override
    public boolean hasFocusChild() {
        return this.hasFocus() || this.tree.hasFocus();
    }

    @Override
    public int getControlType() {
        return 14;
    }

    @Override
    public void setInquireIndex(int value) {
        this.setItem(value);
    }

    @Override
    public void setInquireIndex(int value1, int value2) {
        this.setItem(value1);
    }

    public JTree getJTree() {
        return this.tree;
    }

    @Override
    public void setCleanTitle(String value) {
    }

    @Override
    public void setValue(String value) {
        try {
            this.setValue(Integer.parseInt(value.trim()));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setValue(int value) {
        this.tree.setValue(value);
    }

    @Override
    public String getValue() {
        return String.valueOf(this.tree.getValue());
    }

    public boolean isBoxed() {
        return this.isStyle(1);
    }

    public int getBoxed() {
        return this.isBoxed() ? 1 : 0;
    }

    public void setBoxed() {
        this.setStyleOn(1, 2);
    }

    public void setBoxed(boolean state) {
        this.setStyle(1, state, 2);
    }

    public boolean isNoBox() {
        return this.isStyle(2);
    }

    public int getNoBox() {
        return this.isNoBox() ? 1 : 0;
    }

    public void setNoBox() {
        this.setStyleOn(2, 1);
    }

    public void setNoBox(boolean state) {
        this.setStyle(2, state, 1);
    }

    public boolean isButtons() {
        return this.isStyle(4);
    }

    public int getButtons() {
        return this.isButtons() ? 1 : 0;
    }

    public void setButtons() {
        this.setStyleOn(4);
    }

    public void setButtons(boolean state) {
        this.setStyle(4, state);
    }

    public boolean isShowLines() {
        return this.isStyle(8);
    }

    public int getShowLines() {
        return this.isShowLines() ? 1 : 0;
    }

    public void setShowLines() {
        this.setStyleOn(8);
    }

    public void setShowLines(boolean state) {
        this.setStyle(8, state);
    }

    public boolean isLinesAtRoot() {
        return this.isStyle(16);
    }

    public int getLinesAtRoot() {
        return this.isLinesAtRoot() ? 1 : 0;
    }

    public void setLinesAtRoot() {
        this.setStyleOn(16);
    }

    public void setLinesAtRoot(boolean state) {
        this.setStyle(16, state);
    }

    public boolean isShowSelAlways() {
        return this.isStyle(32);
    }

    public int getShowSelAlways() {
        return this.isShowSelAlways() ? 1 : 0;
    }

    public void setShowSelAlways() {
        this.setStyleOn(32);
    }

    public void setShowSelAlways(boolean state) {
        this.setStyle(32, state);
    }

    @Override
    public void setStyle(int mask) {
        boolean state;
        int change = this.style ^ mask;
        if ((change & 0x2000003) != 0) {
            if ((mask & 2) == 2) {
                this.tree.setBorder(new EmptyBorder(0, 0, 0, 0));
                this.scrollpane.setBorder(new EmptyBorder(0, 0, 0, 0));
            } else if ((mask & 0x2000000) == 0x2000000) {
                this.tree.setBorder(this.defaultTreeBorder);
                this.scrollpane.setBorder(new BevelBorder(1));
            } else {
                this.tree.setBorder(this.defaultTreeBorder);
                this.scrollpane.setBorder(this.defaultScrollpaneBorder);
            }
        }
        if ((change & 4) == 4) {
            state = (mask & 4) == 4;
            this.tree.setShowsHandles(state);
        }
        if ((change & 8) == 8) {
            state = (mask & 8) == 8;
            this.tree.setShowsLines(state);
        }
        if ((change & 0x10) == 16) {
            state = (mask & 0x10) == 16;
            this.tree.setShowsRootEffects(state);
        }
        if ((change & 0x20) == 32) {
            state = (mask & 0x20) == 32;
            this.tree.setShowsSelectionAlways(state);
        }
        this.revalidateAndDisplay();
        super.setStyle(mask);
    }

    @Override
    public void setProperty(int number, Object property) {
        switch (number) {
            case 1: {
                this.setParentItem(this.getInt(property));
                break;
            }
            case 2: {
                this.setPlacement(this.getInt(property));
                break;
            }
            case 3: {
                this.setItem(this.getInt(property));
                break;
            }
            case 4: {
                this.setBitmapHandle(this.getInt(property));
                break;
            }
            case 5: {
                this.setBitmapWidth(this.getInt(property));
                break;
            }
            case 4099: {
                this.setNextItem(this.getInt(property));
                break;
            }
            case 4100: {
                this.setItemToDelete(this.getInt(property));
                break;
            }
            case 4101: {
                this.setResetList(this.getInt(property));
                break;
            }
            case 4102: {
                this.setEnsureVisible(this.getInt(property));
                break;
            }
            case 4103: {
                this.setExpand(this.getInt(property));
                break;
            }
            case 4104: {
                this.setItemToEmpty(this.getInt(property));
                break;
            }
            case 4105: {
                this.setBitmapNumber(this.getInt(property));
                break;
            }
            case 4107: {
                this.setHasChildren(this.getInt(property));
                break;
            }
            case 4098: {
                this.setItemText(this.getString(property));
                break;
            }
            case 4106: {
                this.setHiddenData(this.getString(property));
                break;
            }
            case 4097: {
                this.setItemToAdd(this.getString(property));
                break;
            }
            default: {
                super.setProperty(number, property);
            }
        }
    }

    @Override
    public String getProperty(int number) {
        switch (number) {
            case 1: {
                return String.valueOf(this.getParentItem());
            }
            case 2: {
                return String.valueOf(this.getPlacement());
            }
            case 3: {
                return String.valueOf(this.getItem());
            }
            case 4: {
                return String.valueOf(this.getBitmapHandle());
            }
            case 5: {
                return String.valueOf(this.getBitmapWidth());
            }
            case 4099: {
                return String.valueOf(this.getNextItem());
            }
            case 4100: {
                return String.valueOf(this.getItemToDelete());
            }
            case 4101: {
                return String.valueOf(this.getResetList());
            }
            case 4102: {
                return String.valueOf(this.getEnsureVisible());
            }
            case 4103: {
                return String.valueOf(this.getExpand());
            }
            case 4104: {
                return String.valueOf(this.getItemToEmpty());
            }
            case 4105: {
                return String.valueOf(this.getBitmapNumber());
            }
            case 4107: {
                return String.valueOf(this.getHasChildren());
            }
            case 4098: {
                return String.valueOf(this.getItemText());
            }
            case 4106: {
                return this.getHiddenData();
            }
            case 4097: {
                return String.valueOf(this.getItemToAdd());
            }
        }
        return super.getProperty(number);
    }

    public void setParentItem(int value) {
        this.parentItem = value;
        this.parentNode = this.tree.getNode(this.parentItem);
    }

    public int getParentItem() {
        return this.parentItem;
    }

    public void setPlacement(int value) {
        this.placement = value;
    }

    public int getPlacement() {
        return this.placement;
    }

    private TreePath getCurrentPath() {
        if (this.currentPath != null) {
            return this.currentPath;
        }
        this.currentPath = this.tree.getTreePath(this.currentNode);
        return this.currentPath;
    }

    public void setItem(int value) {
        this.item = value;
        LDynamicTreeNode provisionalNode = this.tree.getNode(value);
        if (provisionalNode != null) {
            this.currentNode = provisionalNode;
            this.currentPath = null;
        }
    }

    public int getItem() {
        return this.item;
    }

    public void setBitmapHandle(int value) {
        try {
            this.bitmapHandle = value;
            this.setBitmapHandle(Handle.getHandle(value));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void setBitmapHandle(Handle value) {
        try {
            if (value == null) {
                this.bitmapHandle = 0;
                this.bitmapComponent = null;
            } else {
                this.bitmapHandle = value.getHandleNumber();
                this.bitmapComponent = (LBitmap)value.getComponent();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public int getBitmapHandle() {
        return this.bitmapHandle;
    }

    public void setBitmapWidth(int value) {
        this.bitmapWidth = value;
    }

    public int getBitmapWidth() {
        return this.bitmapWidth;
    }

    public void setBitmapValue(String resourceName) {
        try {
            this.setBitmapValue(new LBitmap(resourceName));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void setBitmapValue(LBitmap component) {
        this.bitmapComponent = component;
    }

    public void setNextItem(int value) {
        LDynamicTreeNode nextNode = this.currentNode;
        try {
            TreePath path = null;
            int curRow = 0;
            if (nextNode == null) {
                nextNode = this.tree.getRoot();
            }
            switch (value) {
                case 1: {
                    nextNode = (LDynamicTreeNode)this.currentNode.getFirstChild();
                    break;
                }
                case 3: {
                    nextNode = (LDynamicTreeNode)this.currentNode.getNextSibling();
                    break;
                }
                case 5: {
                    nextNode = (LDynamicTreeNode)this.currentNode.getParent();
                    break;
                }
                case 6: {
                    nextNode = (LDynamicTreeNode)this.currentNode.getPreviousSibling();
                    break;
                }
                case 8: {
                    nextNode = (LDynamicTreeNode)this.tree.getRoot().getFirstChild();
                    break;
                }
                case 2: {
                    curRow = 0;
                    path = this.tree.getPathForRow(curRow);
                    nextNode = (LDynamicTreeNode)path.getLastPathComponent();
                    this.tree.scrollRowToVisible(curRow);
                    break;
                }
                case 4: {
                    curRow = this.tree.getRowForPath(this.getCurrentPath());
                    path = this.tree.getPathForRow(++curRow);
                    nextNode = (LDynamicTreeNode)path.getLastPathComponent();
                    this.tree.scrollRowToVisible(curRow);
                    break;
                }
                case 7: {
                    curRow = this.tree.getRowForPath(this.getCurrentPath());
                    path = this.tree.getPathForRow(--curRow);
                    nextNode = (LDynamicTreeNode)path.getLastPathComponent();
                    this.tree.scrollRowToVisible(curRow);
                }
            }
        }
        catch (Exception e) {
            nextNode = null;
        }
        if (nextNode == null) {
            nextNode = this.tree.getRoot();
        }
        this.nextItem = nextNode.getId();
    }

    public int getNextItem() {
        return this.nextItem;
    }

    public void setItemToDelete(int value) {
        this.itemToDelete = value;
        this.tree.reload(this.tree.removeNode(value));
    }

    public int getItemToDelete() {
        return this.itemToDelete;
    }

    public void setItemToEmpty(int value) {
        if (value == 0) {
            return;
        }
        this.itemToEmpty = value;
        this.tree.reload(this.tree.removeChildren(value));
    }

    public int getItemToEmpty() {
        return this.itemToEmpty;
    }

    public void setResetList(int value) {
        this.resetList = value;
        if (this.resetList != 0) {
            this.tree.reset();
            this.tree.reload();
        }
    }

    public int getResetList() {
        return this.resetList;
    }

    public void setEnsureVisible(int value) {
        try {
            this.ensureVisible = value;
            this.tree.makeVisible(this.getCurrentPath());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int getEnsureVisible() {
        return this.ensureVisible;
    }

    public void setExpand(int value) {
        this.expand = value;
        try {
            if (this.currentPath != null) {
                if (this.expand == 2) {
                    this.tree.expandPath(this.getCurrentPath());
                } else if (this.expand == 1) {
                    this.tree.collapsePath(this.getCurrentPath());
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int getExpand() {
        return this.expand;
    }

    public void setBitmapNumber(int value) {
        if (this.currentNode != null) {
            this.currentNode.setBitmapNumber(this.bitmapComponent, value, this.bitmapWidth);
        }
    }

    public int getBitmapNumber() {
        if (this.currentNode != null) {
            return this.currentNode.getBitmapNumber();
        }
        return 0;
    }

    public void setHasChildren(int value) {
        this.setHasChildren(value != 0);
    }

    public void setHasChildren(boolean state) {
        this.currentNode.setAlwaysParent(state);
        this.tree.reload(this.currentNode);
    }

    public int getHasChildren() {
        return !this.currentNode.isLeaf() ? 1 : 0;
    }

    public void setItemToAdd(Object[] values) {
        for (int i = 1; i < values.length; ++i) {
            this.setItemToAdd(String.valueOf(values[i]));
        }
    }

    public void setItemToAdd(String value) {
        int desiredPlacement = this.placement & 3;
        if (this.parentNode == null) {
            this.parentNode = this.tree.getRoot();
        }
        if (this.parentNode != null) {
            switch (desiredPlacement) {
                case 1: {
                    this.currentNode = this.tree.newNode(value);
                    this.tree.setQuietExpandedState(this.tree.getTreePath(this.parentNode), true);
                    this.parentNode.addFirst(this.currentNode);
                    this.currentPath = null;
                    this.itemToAdd = this.currentNode.getId();
                    break;
                }
                case 3: {
                    this.currentNode = this.tree.newNode(value);
                    this.tree.setQuietExpandedState(this.tree.getTreePath(this.parentNode), true);
                    this.parentNode.addSorted(this.currentNode);
                    this.currentPath = null;
                    this.itemToAdd = this.currentNode.getId();
                    break;
                }
                default: {
                    this.currentNode = this.tree.newNode(value);
                    this.tree.setQuietExpandedState(this.tree.getTreePath(this.parentNode), true);
                    this.parentNode.addLast(this.currentNode);
                    this.currentPath = null;
                    this.itemToAdd = this.currentNode.getId();
                }
            }
        }
        this.tree.reload((LDynamicTreeNode)this.currentNode.getParent());
    }

    public int getItemToAdd() {
        return this.itemToAdd;
    }

    public void setItemText(String value) {
        this.currentNode.setUserObject(value);
        ((LTreeUI)this.tree.getUI()).invalidateSizes();
        this.revalidateAndDisplay();
    }

    public String getItemText() {
        return String.valueOf(this.currentNode.getUserObject());
    }

    public void setHiddenData(String value) {
        this.currentNode.setHiddenData(value);
    }

    public String getHiddenData() {
        return this.currentNode.getHiddenData();
    }

    @Override
    public Dimension getPreferredSize() {
        return this.tree.getPreferredSize();
    }

    @Override
    public Dimension getMinimumSize() {
        return this.tree.getMinimumSize();
    }

    @Override
    public Dimension getMaximumSize() {
        return this.tree.getMaximumSize();
    }

    @Override
    public void setBackground(Color c) {
        this.tree.setBackground(c);
        super.setBackground(c);
    }

    @Override
    public void setForeground(Color c) {
        this.tree.setForeground(c);
        super.setForeground(c);
    }

    @Override
    public void setOpaque(boolean state) {
        this.tree.setOpaque(state);
        super.setOpaque(state);
    }

    @Override
    public void setEnabled(boolean state) {
        this.tree.setEnabled(state);
        super.setEnabled(state);
    }

    @Override
    public void setFont(Font f) {
        super.setFont(f);
        this.tree.setFont(f);
        int height = (int)((double)this.getDefaultUnitHeight(f) * 1.5) - 1;
        this.tree.setRowHeight(height);
    }
}

