/*
 * Decompiled with CFR 0.152.
 */
package com.heirloomcomputing.ecs.jfc;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.border.AbstractBorder;

class SJBevelBorder
extends AbstractBorder {
    private final int RAISED = 0;
    private final int LOWERED = 1;
    private int bevelType;
    private int hthickness = 2;
    private int vthickness = 2;

    public SJBevelBorder(int bevelType) {
        this.bevelType = bevelType;
    }

    public SJBevelBorder() {
        this(1);
    }

    public void setBorderThickness(int n) {
        this.hthickness = this.vthickness = n;
    }

    public int getBorderThickness() {
        return Math.max(this.hthickness, this.vthickness);
    }

    public void setBorderRaised(boolean state) {
        this.bevelType = state ? 0 : 1;
    }

    public boolean getBorderRaised() {
        return this.bevelType == 0;
    }

    public void setBorderHThickness(int n) {
        this.hthickness = n;
    }

    public int getBorderHThickness() {
        return this.hthickness;
    }

    public void setBorderVThickness(int n) {
        this.vthickness = n;
    }

    public int getBorderVThickness() {
        return this.vthickness;
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        if (this.bevelType == 0) {
            this.paintRaisedBevel(c, g, x, y, width, height);
        } else if (this.bevelType == 1) {
            this.paintLoweredBevel(c, g, x, y, width, height);
        }
    }

    @Override
    public Insets getBorderInsets(Component c) {
        return new Insets(this.vthickness, this.hthickness, this.vthickness, this.hthickness);
    }

    @Override
    public Insets getBorderInsets(Component c, Insets insets) {
        insets.left = insets.right = this.hthickness;
        insets.top = insets.bottom = this.vthickness;
        return insets;
    }

    public Color brighter(Color c) {
        int b;
        int g;
        double INVFACTOR = 1.414;
        int r = (int)((double)c.getRed() * INVFACTOR);
        if (r > 255) {
            r = 255;
        }
        if ((g = (int)((double)c.getGreen() * INVFACTOR)) > 255) {
            g = 255;
        }
        if ((b = (int)((double)c.getBlue() * INVFACTOR)) > 255) {
            b = 255;
        }
        return new Color(r, g, b);
    }

    public Color doublebrighter(Color c) {
        int b;
        int g;
        double INVFACTOR = 2.0;
        int r = (int)((double)c.getRed() * INVFACTOR);
        if (r > 255) {
            r = 255;
        }
        if ((g = (int)((double)c.getGreen() * INVFACTOR)) > 255) {
            g = 255;
        }
        if ((b = (int)((double)c.getBlue() * INVFACTOR)) > 255) {
            b = 255;
        }
        return new Color(r, g, b);
    }

    public Color darker(Color c) {
        int b;
        int g;
        double INVFACTOR = 0.707;
        int r = (int)((double)c.getRed() * INVFACTOR);
        if (r > 255) {
            r = 255;
        }
        if ((g = (int)((double)c.getGreen() * INVFACTOR)) > 255) {
            g = 255;
        }
        if ((b = (int)((double)c.getBlue() * INVFACTOR)) > 255) {
            b = 255;
        }
        return new Color(r, g, b);
    }

    public Color doubledarker(Color c) {
        int b;
        int g;
        double INVFACTOR = 0.5;
        int r = (int)((double)c.getRed() * INVFACTOR);
        if (r > 255) {
            r = 255;
        }
        if ((g = (int)((double)c.getGreen() * INVFACTOR)) > 255) {
            g = 255;
        }
        if ((b = (int)((double)c.getBlue() * INVFACTOR)) > 255) {
            b = 255;
        }
        return new Color(r, g, b);
    }

    public Color getHighlightOuterColor(Component c) {
        return this.doublebrighter(c.getBackground());
    }

    public Color getHighlightInnerColor(Component c) {
        return this.brighter(c.getBackground());
    }

    public Color getShadowInnerColor(Component c) {
        return this.darker(c.getBackground());
    }

    public Color getShadowOuterColor(Component c) {
        return this.doubledarker(c.getBackground());
    }

    public Color getHighlightOuterColor(Color c) {
        return this.doublebrighter(c);
    }

    public Color getHighlightInnerColor(Color c) {
        return this.brighter(c);
    }

    public Color getShadowInnerColor(Color c) {
        return this.darker(c);
    }

    public Color getShadowOuterColor(Color c) {
        return this.doubledarker(c);
    }

    public int getBevelType() {
        return this.bevelType;
    }

    @Override
    public boolean isBorderOpaque() {
        return true;
    }

    protected void paintRaisedBevel(Component c, Graphics g, int x, int y, int width, int height) {
        if (this.hthickness < 1 && this.vthickness < 1) {
            return;
        }
        Color oldColor = g.getColor();
        int h = height;
        int w = width;
        g.translate(x, y);
        Color bg = c.getBackground();
        g.setColor(this.getHighlightOuterColor(bg));
        if (this.vthickness > 0) {
            g.drawLine(0, 0, 0, h - 1);
        }
        if (this.hthickness > 0) {
            g.drawLine(1, 0, w - 1, 0);
        }
        g.setColor(this.getHighlightInnerColor(bg));
        if (this.vthickness > 2) {
            g.drawLine(1, 1, 1, h - 2);
        }
        if (this.hthickness > 2) {
            g.drawLine(2, 1, w - 2, 1);
        }
        g.setColor(this.getShadowOuterColor(bg));
        if (this.hthickness > 1) {
            g.drawLine(1, h - 1, w - 1, h - 1);
        }
        if (this.vthickness > 1) {
            g.drawLine(w - 1, 1, w - 1, h - 2);
        }
        g.setColor(this.getShadowInnerColor(bg));
        if (this.hthickness > 2) {
            g.drawLine(2, h - 2, w - 2, h - 2);
        }
        if (this.vthickness > 2) {
            g.drawLine(w - 2, 2, w - 2, h - 3);
        }
        g.translate(-x, -y);
        g.setColor(oldColor);
    }

    protected void paintLoweredBevel(Component c, Graphics g, int x, int y, int width, int height) {
        if (this.hthickness < 1 && this.vthickness < 1) {
            return;
        }
        Color oldColor = g.getColor();
        int h = height;
        int w = width;
        g.translate(x, y);
        Color bg = c.getBackground();
        g.setColor(this.getShadowInnerColor(bg));
        if (this.vthickness > 0) {
            g.drawLine(0, 0, 0, h - 1);
        }
        if (this.hthickness > 0) {
            g.drawLine(1, 0, w - 1, 0);
        }
        g.setColor(this.getShadowOuterColor(bg));
        if (this.vthickness > 1) {
            g.drawLine(1, 1, 1, h - 2);
        }
        if (this.hthickness > 1) {
            g.drawLine(2, 1, w - 2, 1);
        }
        g.setColor(this.getHighlightOuterColor(bg));
        if (this.vthickness > 0) {
            g.drawLine(1, h - 1, w - 1, h - 1);
        }
        if (this.hthickness > 0) {
            g.drawLine(w - 1, 1, w - 1, h - 2);
        }
        g.setColor(this.getHighlightInnerColor(bg));
        if (this.vthickness > 1) {
            g.drawLine(2, h - 2, w - 2, h - 2);
        }
        if (this.hthickness > 1) {
            g.drawLine(w - 2, 2, w - 2, h - 3);
        }
        g.translate(-x, -y);
        g.setColor(oldColor);
    }
}

