/*
 * Decompiled with CFR 0.152.
 */
package com.heirloomcomputing.ecs.jfc;

import com.heirloomcomputing.ecs.exec.LogSetup;
import com.heirloomcomputing.ecs.jfc.SJCustomView;
import com.heirloomcomputing.ecs.jfc.SJTextArea;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import javax.swing.JComponent;
import javax.swing.JTextArea;
import javax.swing.ToolTipManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicTextUI;
import javax.swing.text.Caret;
import javax.swing.text.DefaultCaret;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import javax.swing.text.View;

class SJTextUI
extends BasicTextUI {
    private SJCustomView customView = null;
    private boolean isField = true;

    public SJTextUI() {
    }

    public SJTextUI(boolean componentIsAField) {
        this.isField = componentIsAField;
    }

    @Override
    public void damageRange(JTextComponent t, int p0, int p1, Position.Bias p0Bias, Position.Bias p1Bias) {
        block2: {
            try {
                super.damageRange(t, p0, p1, p0Bias, p1Bias);
            }
            catch (Throwable th) {
                if (!LogSetup.IS_LOGGING_INFO) break block2;
                LogSetup.LOGGER.info("catch(Throwable th). ");
                th.printStackTrace();
            }
        }
    }

    @Override
    protected String getKeymapName() {
        String nm = "JTextField";
        if (!this.isField) {
            nm = "JTextArea";
        }
        return nm;
    }

    @Override
    protected String getPropertyPrefix() {
        if (!this.isField) {
            return "TextArea";
        }
        return "TextField";
    }

    public SJCustomView getView() {
        return this.customView;
    }

    @Override
    public View create(Element elem) {
        JTextComponent c = this.getComponent();
        boolean textArea = c instanceof JTextArea;
        this.customView = new SJCustomView(elem, !textArea);
        return this.customView;
    }

    @Override
    protected void propertyChange(PropertyChangeEvent evt) {
        if (!this.isField) {
            if (evt.getPropertyName().equalsIgnoreCase("LineWrap") || evt.getPropertyName().equalsIgnoreCase("WrapStyleWord")) {
                this.modelChanged();
            }
        } else {
            super.propertyChange(evt);
        }
    }

    public static ComponentUI createUI(JComponent ta) {
        if (ta instanceof JTextArea) {
            return new SJTextUI(false);
        }
        return new SJTextUI(true);
    }

    @Override
    protected Caret createCaret() {
        return new BasicFieldCaret();
    }

    @Override
    protected void modelChanged() {
        block2: {
            try {
                this.setView(this.create(this.getComponent().getDocument().getDefaultRootElement()));
            }
            catch (Exception e) {
                if (!LogSetup.IS_LOGGING_INFO) break block2;
                LogSetup.LOGGER.info("catch(Exception e). ");
                e.printStackTrace();
            }
        }
    }

    public String toString() {
        return "SJTextUI[" + super.toString() + "]";
    }

    static class BasicFieldCaret
    extends DefaultCaret
    implements UIResource {
        @Override
        public void mouseReleased(MouseEvent e) {
            block3: {
                JTextComponent c = this.getComponent();
                try {
                    SJTextArea f = (SJTextArea)c;
                    if (f.isStyle(65536) && f.getError()) {
                        f.setError(false);
                    }
                }
                catch (Exception ex) {
                    if (!LogSetup.IS_LOGGING_INFO) break block3;
                    LogSetup.LOGGER.info("catch(Exception ex). ");
                    ex.printStackTrace();
                }
            }
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            block5: {
                JTextComponent c = this.getComponent();
                try {
                    SJTextArea f = (SJTextArea)c;
                    if (!f.isStyle(32768)) {
                        f.setStyle(32768);
                        String override = f.getExplicitToolTipText();
                        if (override != null) {
                            f.setToolTipText(override);
                        } else {
                            f.setToolTipText(f.getDefaultToolTipText());
                        }
                        ToolTipManager.sharedInstance().mouseEntered(e);
                    }
                }
                catch (Exception ex) {
                    if (!LogSetup.IS_LOGGING_INFO) break block5;
                    LogSetup.LOGGER.info("catch(Exception ex). ");
                    ex.printStackTrace();
                }
            }
        }
    }
}

