/*
 * Decompiled with CFR 0.152.
 */
package com.heirloomcomputing.ecs.jfc;

import com.heirloomcomputing.ecs.jfc.LDynamicTreeNode;
import com.heirloomcomputing.ecs.jfc.LTreeCellRenderer;
import com.heirloomcomputing.ecs.jfc.LTreeUI;
import java.awt.Color;
import java.util.Hashtable;
import javax.swing.Icon;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.plaf.TreeUI;
import javax.swing.plaf.basic.BasicTreeUI;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreePath;

class SJTree
extends JTree {
    private static final boolean debugMode = false;
    private LDynamicTreeNode ROOT;
    public boolean quiet = true;
    private boolean showsHandles = true;
    private boolean showsLines = true;
    private boolean showsLinesAtRoot = true;
    private boolean showsSelAlways = true;
    private Hashtable<Integer, LDynamicTreeNode> idToNode = new Hashtable();

    public SJTree() {
        this(new LDynamicTreeNode("ROOT", 0));
        this.idToNode.put(this.ROOT.getID(), this.ROOT);
    }

    public SJTree(LDynamicTreeNode root) {
        super(new DefaultTreeModel(root));
        this.ROOT = root;
        this.ROOT.setParent(null);
        this.idToNode.put(this.ROOT.getID(), this.ROOT);
        this.setScrollsOnExpand(true);
        this.setRootVisible(false);
        this.setShowsRootEffects(false);
        this.setShowsLines(false);
        this.setShowsHandles(false);
        this.setShowsSelectionAlways(false);
        this.setCellRenderer(new LTreeCellRenderer());
        DefaultTreeSelectionModel model = new DefaultTreeSelectionModel();
        model.setSelectionMode(1);
        this.setSelectionModel(model);
    }

    protected void setQuietExpandedState(TreePath path, boolean state) {
        this.quiet = true;
        this.setExpandedState(path, state);
        this.quiet = false;
    }

    @Override
    protected void setExpandedState(TreePath path, boolean state) {
        super.setExpandedState(path, state);
    }

    public void reload() {
        ((DefaultTreeModel)this.getModel()).reload();
    }

    public void reload(LDynamicTreeNode node) {
        ((DefaultTreeModel)this.getModel()).reload(node);
    }

    public LDynamicTreeNode getRoot() {
        return this.ROOT;
    }

    public BasicTreeUI getBasicTreeUI() {
        return (BasicTreeUI)this.getUI();
    }

    public LTreeUI getLTreeUI() {
        return (LTreeUI)this.getUI();
    }

    @Override
    protected void clearToggledPaths() {
        super.clearToggledPaths();
    }

    public void setHashColor(boolean state) {
        if (state) {
            this.setHashColor();
        } else {
            this.setHashColor(this.getBackground());
        }
    }

    public void setHashColor() {
        this.setHashColor(UIManager.getColor("Tree.hash"));
    }

    public void setHashColor(Color c) {
        try {
            this.getLTreeUI().setHash(c);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setCollapsedIcon() {
        this.setCollapsedIcon((Icon)UIManager.get("Tree.collapsedIcon"));
    }

    public void setCollapsedIcon(boolean state) {
        if (state) {
            this.setCollapsedIcon();
        } else {
            this.setCollapsedIcon(null);
        }
    }

    public void setCollapsedIcon(Icon newIcon) {
        try {
            this.getBasicTreeUI().setCollapsedIcon(newIcon);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Icon getCollapsedIcon() {
        try {
            return this.getBasicTreeUI().getCollapsedIcon();
        }
        catch (Exception e) {
            return null;
        }
    }

    public void setExpandedIcon() {
        this.setExpandedIcon((Icon)UIManager.get("Tree.expandedIcon"));
    }

    public void setExpandedIcon(boolean state) {
        if (state) {
            this.setExpandedIcon();
        } else {
            this.setExpandedIcon(null);
        }
    }

    public void setExpandedIcon(Icon newIcon) {
        try {
            this.getBasicTreeUI().setExpandedIcon(newIcon);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Icon getExpandedIcon() {
        try {
            return this.getBasicTreeUI().getExpandedIcon();
        }
        catch (Exception e) {
            return null;
        }
    }

    public void setLeftChildIndent(int newAmount) {
        try {
            this.getBasicTreeUI().setRightChildIndent(newAmount);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setRightChildIndent(int newAmount) {
        try {
            this.getBasicTreeUI().setLeftChildIndent(newAmount);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setShowsHandles(boolean state) {
        if (this.showsHandles == state) {
            return;
        }
        this.showsHandles = state;
        this.setExpandedIcon(this.showsHandles);
        this.setCollapsedIcon(this.showsHandles);
        this.updateRootHandles();
    }

    public boolean getShowsHandles() {
        return this.showsHandles;
    }

    public void setShowsLines(boolean state) {
        if (this.showsLines == state) {
            return;
        }
        this.showsLines = state;
        this.setHashColor(this.showsLines);
        this.updateRootHandles();
    }

    public boolean getShowsRootEffects() {
        return this.showsLinesAtRoot;
    }

    public void setShowsRootEffects(boolean state) {
        if (this.showsLinesAtRoot == state) {
            return;
        }
        this.showsLinesAtRoot = state;
        this.updateRootHandles();
    }

    private void updateRootHandles() {
        if (this.showsLinesAtRoot && (this.showsLines || this.showsHandles)) {
            this.setShowsRootHandles(true);
        } else {
            this.setShowsRootHandles(false);
        }
        this.revalidate();
        this.repaint();
    }

    public boolean getShowsSelectionAlways() {
        return this.showsSelAlways;
    }

    public void setShowsSelectionAlways(boolean state) {
        if (this.showsSelAlways == state) {
            return;
        }
        this.showsSelAlways = state;
        this.revalidate();
        this.repaint();
    }

    @Override
    public void setUI(TreeUI ui) {
        super.setUI(new LTreeUI());
    }

    public void setValue(int value) {
        LDynamicTreeNode provisionalNode = null;
        provisionalNode = this.getNode(value);
        if (provisionalNode != null) {
            this.setSelectionPath(this.getTreePath(provisionalNode));
        }
    }

    public int getValue() {
        LDynamicTreeNode treeNode = (LDynamicTreeNode)this.getLastSelectedPathComponent();
        return treeNode == null ? 0 : treeNode.getId();
    }

    public LDynamicTreeNode getNode(int id) {
        Integer ID = new Integer(id);
        return this.idToNode.get(ID);
    }

    public TreePath getTreePath(LDynamicTreeNode node) {
        return new TreePath(((DefaultTreeModel)this.getModel()).getPathToRoot(node));
    }

    public TreePath getTreePath(int id) {
        return new TreePath(((DefaultTreeModel)this.getModel()).getPathToRoot(this.getNode(id)));
    }

    public LDynamicTreeNode removeNode(int id) {
        this.removeChildren(id);
        Integer ID = new Integer(id);
        LDynamicTreeNode node = this.idToNode.get(ID);
        LDynamicTreeNode parent = null;
        if (node != null) {
            this.removeHashtableEntry(id);
            parent = (LDynamicTreeNode)node.getParent();
            if (parent != null) {
                parent.remove(node);
            }
        }
        return parent;
    }

    private void removeHashtableEntry(int id) {
        try {
            this.idToNode.remove(new Integer(id));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public LDynamicTreeNode removeChildren(int id) {
        Integer ID = new Integer(id);
        LDynamicTreeNode parent = this.idToNode.get(ID);
        int childCount = parent.getChildCount();
        for (int i = childCount - 1; i >= 0; --i) {
            try {
                LDynamicTreeNode child = (LDynamicTreeNode)parent.getChildAt(i);
                int childId = child.getId();
                if (child.getChildCount() > 0) {
                    this.removeChildren(childId);
                }
                this.removeHashtableEntry(childId);
                continue;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        parent.removeAllChildren();
        return parent;
    }

    public void reset() {
        this.ROOT.removeAllChildren();
        this.idToNode = new Hashtable();
        this.idToNode.put(new Integer(0), this.ROOT);
    }

    public LDynamicTreeNode newNode() {
        LDynamicTreeNode node = new LDynamicTreeNode();
        this.idToNode.put(node.getID(), node);
        return node;
    }

    public LDynamicTreeNode newNode(String value) {
        LDynamicTreeNode node = new LDynamicTreeNode(value);
        this.idToNode.put(node.getID(), node);
        return node;
    }

    public LDynamicTreeNode newNode(String value, int idnum) {
        LDynamicTreeNode node = new LDynamicTreeNode(value, idnum);
        this.idToNode.put(node.getID(), node);
        return node;
    }
}

