/*
 * Decompiled with CFR 0.152.
 */
package com.heirloomcomputing.ecs.libcall;

import com.heirloomcomputing.ecs.libcall.BytestreamFileHandler;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

class BytestreamInputFile
extends BytestreamFileHandler {
    InputStream is = null;

    protected BytestreamInputFile(Object filename) {
        super(filename);
    }

    @Override
    public int close(boolean closeStream) {
        int result = super.close(closeStream);
        try {
            if (closeStream) {
                this.is.close();
            }
            this.is = null;
        }
        catch (IOException ioException) {
            result = 30;
        }
        catch (Throwable t) {
            result = 90;
        }
        return result;
    }

    @Override
    public int createFile(int accessMode, int denyMode) {
        int result = 0;
        if (this.filename instanceof InputStream) {
            this.is = (InputStream)this.filename;
            if (this.blockSize > 1) {
                this.is = new BufferedInputStream(this.is, this.blockSize);
            }
        } else {
            result = 90;
        }
        return result;
    }

    @Override
    public int openFile(int accessMode, int denyMode) {
        int result = 0;
        if (this.filename instanceof InputStream) {
            this.is = (InputStream)this.filename;
        } else {
            String filenameString = this.filenameString(this.filename);
            try {
                this.is = new FileInputStream(filenameString);
                if (this.blockSize > 1) {
                    this.is = new BufferedInputStream(this.is, this.blockSize);
                }
            }
            catch (IOException ioException) {
                result = 30;
            }
            catch (Throwable t) {
                result = 90;
            }
        }
        return result;
    }

    @Override
    public int readFile(long offset, int length, byte[] buffer) {
        int result = 0;
        if (length <= 0) {
            length = buffer.length;
        }
        if (length > buffer.length) {
            length = buffer.length;
            result = 91;
        }
        try {
            int count = this.is.read(buffer, 0, length);
            if (count <= 0) {
                result = 10;
                count = 0;
            }
            while (count < length) {
                buffer[count] = 32;
                ++count;
            }
        }
        catch (IOException ioException) {
            result = 10;
        }
        catch (Throwable t) {
            result = 90;
        }
        return result;
    }

    @Override
    public int writeFile(long offset, int length, byte[] buffer) {
        int result = 90;
        return result;
    }

    @Override
    public long length() {
        try {
            return this.is.available();
        }
        catch (Throwable t) {
            return 0L;
        }
    }

    @Override
    public int flushFile() {
        int result = 0;
        return result;
    }
}

