/*
 * Decompiled with CFR 0.152.
 */
package com.heirloomcomputing.ecs.libcall;

import com.heirloomcomputing.ecs.libcall.BytestreamFileHandler;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

class BytestreamOutputFile
extends BytestreamFileHandler {
    OutputStream os = null;

    protected BytestreamOutputFile(Object filename) {
        super(filename);
    }

    @Override
    public int close(boolean closeStream) {
        int result = super.close(closeStream);
        try {
            if (closeStream) {
                this.os.close();
            }
            this.os = null;
        }
        catch (IOException ioException) {
            result = 30;
        }
        catch (Throwable t) {
            result = 90;
        }
        return result;
    }

    @Override
    public int createFile(int accessMode, int denyMode) {
        int result = 0;
        if (this.filename instanceof OutputStream) {
            this.os = (OutputStream)this.filename;
            if (this.blockSize > 1) {
                this.os = new BufferedOutputStream(this.os, this.blockSize);
            }
        } else {
            String filenameString = this.filenameString(this.filename);
            try {
                this.os = new FileOutputStream(filenameString);
                if (this.blockSize > 1) {
                    this.os = new BufferedOutputStream(this.os, this.blockSize);
                }
            }
            catch (IOException ioException) {
                result = 30;
            }
            catch (Throwable ioException) {
                result = 90;
            }
        }
        return result;
    }

    @Override
    public int openFile(int accessMode, int denyMode) {
        int result = 0;
        if (this.filename instanceof OutputStream) {
            this.os = (OutputStream)this.filename;
            if (this.blockSize > 1) {
                this.os = new BufferedOutputStream(this.os, this.blockSize);
            }
        } else {
            String filenameString = this.filenameString(this.filename);
            try {
                this.os = new FileOutputStream(filenameString);
                if (this.blockSize > 1) {
                    this.os = new BufferedOutputStream(this.os, this.blockSize);
                }
            }
            catch (IOException ioException) {
                result = 30;
            }
            catch (Throwable t) {
                result = 90;
            }
        }
        return result;
    }

    @Override
    public int readFile(long offset, int length, byte[] buffer) {
        int result = 90;
        return result;
    }

    @Override
    public int writeFile(long offset, int length, byte[] buffer) {
        int result = 0;
        if (length <= 0) {
            length = buffer.length;
        }
        if (length > buffer.length) {
            length = buffer.length;
            result = 91;
        }
        try {
            this.os.write(buffer, 0, length);
        }
        catch (IOException ioException) {
            result = 30;
        }
        catch (Throwable t) {
            result = 90;
        }
        return result;
    }

    @Override
    public long length() {
        return 0L;
    }

    @Override
    public int flushFile() {
        int result = 0;
        try {
            this.os.flush();
        }
        catch (Throwable t) {
            result = -1;
        }
        return result;
    }
}

