/*
 * Decompiled with CFR 0.152.
 */
package com.heirloomcomputing.ecs.libcall;

import com.heirloomcomputing.ecs.exec.Binary;
import com.heirloomcomputing.ecs.exec.Numeric;
import com.heirloomcomputing.ecs.exec.RuntimeEnvironment;
import com.heirloomcomputing.ecs.exec.Variable;
import com.heirloomcomputing.ecs.exec.basicFile;
import com.heirloomcomputing.ecs.exec.parameterList;
import com.heirloomcomputing.ecs.libcall.DefaultCall;
import java.io.File;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CBL_LOCATE_FILE
extends DefaultCall {
    private static String ENV_VAR_PATTERN = "\\$([A-Za-z0-9]+)";
    private Variable pathFlag;
    Numeric status = new Numeric(0);

    @Override
    public Object callGiving(parameterList param) {
        String userFileSpec = param.getString(0);
        userFileSpec.replaceAll("\\\\+", "\\/");
        int userMode = param.getInt(1);
        Variable actualFileSpec = param.getVariable(2);
        Binary bufferLen = new Binary();
        bufferLen.declare(new Variable(actualFileSpec.getMemory(), actualFileSpec.getAddress(), 2));
        Variable buffer = new Variable(bufferLen.getMemory(), bufferLen.getAddress() + bufferLen.getLength(), 256);
        Variable exitFlag = param.getVariable(3);
        exitFlag.move(0);
        this.pathFlag = param.getVariable(4);
        this.pathFlag.move(0);
        String resolvedPath = this.resolveEnvVariables(ENV_VAR_PATTERN, userFileSpec);
        String foundPath = "";
        switch (userMode) {
            case 0: {
                if (resolvedPath == null || resolvedPath.equals("")) break;
                foundPath = this.findFile(resolvedPath, ENV_VAR_PATTERN, userFileSpec, false);
                if (foundPath.equals("")) {
                    foundPath = this.findFile(resolvedPath, ENV_VAR_PATTERN, userFileSpec, true);
                    break;
                }
                exitFlag.move(3);
                break;
            }
            case 1: {
                if (resolvedPath == null || resolvedPath.equals("")) break;
                foundPath = this.findFile(resolvedPath, ENV_VAR_PATTERN, userFileSpec, true);
                break;
            }
            case 2: {
                break;
            }
        }
        buffer.move(foundPath);
        ((Variable)bufferLen).move(foundPath.length());
        if (foundPath.length() > 256) {
            this.status.move(3);
        }
        return this.status;
    }

    private String resolveEnvVariables(String pattern, String text) {
        Pattern expr = Pattern.compile(pattern);
        Matcher matcher = expr.matcher(text);
        if (matcher.find()) {
            String val = matcher.group(1).toUpperCase();
            String resolvedVar = RuntimeEnvironment.getGlobalParameter(val);
            if (resolvedVar == null && (resolvedVar = basicFile.resolveExpandedAlias(val)) != null) {
                resolvedVar = resolvedVar.split("=")[1];
            }
            if (resolvedVar != null) {
                this.pathFlag.move(1);
                return resolvedVar.replaceAll("\\\\+", "\\/");
            }
            this.status.move(1);
            return null;
        }
        return text;
    }

    private String findFile(String resolvedPath, String pattern, String userFileSpec, boolean returnDefault) {
        String[] ddPath = resolvedPath.split(File.pathSeparator);
        String returnPathOfFirst = "";
        for (String dd : ddPath) {
            String fileToSearch = userFileSpec.replaceAll(pattern, dd).trim();
            File f = new File(fileToSearch);
            if (returnDefault && returnPathOfFirst.equals("")) {
                returnPathOfFirst = fileToSearch;
            }
            if (returnDefault || !f.exists()) continue;
            return fileToSearch;
        }
        return returnPathOfFirst;
    }
}

