/*
 * Decompiled with CFR 0.152.
 */
package com.heirloomcomputing.ecs.libcall;

import com.heirloomcomputing.ecs.api.IDatatype;
import com.heirloomcomputing.ecs.exec.BignumType;
import com.heirloomcomputing.ecs.exec.Comp1;
import com.heirloomcomputing.ecs.exec.Comp2;
import com.heirloomcomputing.ecs.exec.Display;
import com.heirloomcomputing.ecs.exec.DisplayA;
import com.heirloomcomputing.ecs.exec.DisplayH;
import com.heirloomcomputing.ecs.exec.DisplayMVS;
import com.heirloomcomputing.ecs.exec.DisplayP;
import com.heirloomcomputing.ecs.exec.ICallableProgramGiving;
import com.heirloomcomputing.ecs.exec.Numeric;
import com.heirloomcomputing.ecs.exec.Variable;
import com.heirloomcomputing.ecs.exec.parameterList;
import com.heirloomcomputing.ecs.isamsql.SqlColumn;
import com.heirloomcomputing.ecs.isamsql.XmlDatasetLoader;
import com.heirloomcomputing.ecs.util.BatchTree;
import com.heirloomcomputing.ecs.util.BatchTreeItem;
import com.heirloomcomputing.ecs.util.Transform;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.Vector;

public class CBL_TRANSFORM
implements ICallableProgramGiving {
    int signedTransform = 1;
    String inCharset = "IBM1047";
    String outCharset = "ISO-8859-1";
    String prevInCharset = "";
    String prevOutCharset = "";
    String xfdFileName = "";
    String prevXFDFileName = "";
    int statusCode = 0;
    byte[] inBytes;
    Variable errVar;
    Variable inputVar;
    int offsetPos = 0;
    ArrayList<String> TypeA = new ArrayList<String>(Arrays.asList("NATIONAL", "NATIONAL_EDITED", "ALPHABETIC", "ALPHANUMERIC", "ALPHANUMERIC_EDITED", "NUMERIC_EDITED"));
    boolean xfdAvail = false;
    static boolean hasMultipleLayouts = false;
    static boolean hasSingleLayout = false;
    static boolean hasNoLayouts = false;
    BatchTree XFDTree = new BatchTree(3);
    String REDEFINED = "REDEFINED";
    String XFD_WHEN = "COND";
    String REDEFINES_TXT = " redefines ";
    boolean badRecord = false;
    boolean useDefaultRedef = false;
    static ArrayList<String> CONDITIONS = new ArrayList<String>(Arrays.asList("IS < OR = TO", "IS < THAN", "IS = TO", "IS > OR = TO", "IS > THAN", "IS BETWEEN", "NOT < OR = TO", "NOT < THAN", "NOT = TO", "NOT > OR = TO", "NOT > THAN", "NOT BETWEEN"));
    static ArrayList<String> SQLCONDITIONS = new ArrayList<String>(Arrays.asList(" <= ", " < ", " = ", " >= ", " > ", " BETWEEN ", " > ", " >= ", " != ", " < ", " <= ", " NOT BETWEEN "));
    private ArrayList<BatchTreeItem> whenConds = new ArrayList();
    Vector<Object> xfdRowLayout;
    Map<Object, Integer[]> sqlTranslateMap = new HashMap<Object, Integer[]>(50);
    HashMap<Vector<Object>, HashMap<Object, Object[]>> xfdCondMap = new HashMap();
    Vector<Vector<Object>> xfdMap = new Vector();
    ArrayList<ArrayList<String>> blockMaster = new ArrayList(255);
    String ebcidicCodeSets = " 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 1140, 37-2, 38, 39, 40, 251, 252, 254, 256, 257, 258, 259, 260, 264, 273, 1141, 274, 275, 276, 277, 1142, 278, 1143, 279, 280, 1144, 281, 282, 283, 284, 1145, 285, 1146, 286, 287, 288, 289, 290, 293, 297, 1147, 298, 300, 310, 320, 321, 322, 330, 351, 352, 353, 355, 357, 358, 359, 360, 361, 363, 382, 383, 384, 385, 386, 387, 388, 389, 390, 391, 392, 393, 394, 395, 410, 420, 16804, 421, 423, 424, 8616, 12712, 425, 435, 500, 1148, 803, 829, 833, 834, 835, 836, 837, 838, 838, 839, 870, 1110, 1153, 871, 1149, 875, 4971, 9067, 880, 881, 882, 883, 884, 885, 886, 887, 888, 889, 890, 892, 893, 905, 918, 924, 930, 1390, 931, 933, 1364, 935, 1388, 937, 1371, 939, 1399, 1001, 1002, 1003, 1005, 1007, 1024, 1025, 1154, 1026, 1155, 1027, 1028, 1030, 1031, 1032, 1033, 1037, 1047, 1068, 1069, 1070, 1071, 1073, 1074, 1075, 1076, 1077, 1078, 1079, 1080, 1081, 1082, 1083, 1084, 1085, 1087, 1091, 1097, 1112, 1156, 1113, 1122, 1157, 1123, 1158, 1130, 1164, 1132, 1136, 1137, 1150, 1151, 1152, 1159, 1165, 1166, 1278, 1279, 1303, 1364, 1376, 1377, JEF, KEIS,";
    byte[][] signedAscToEbcMap = new byte[][]{{48, -64}, {49, -63}, {50, -62}, {51, -61}, {52, -60}, {53, -59}, {54, -58}, {55, -57}, {56, -56}, {57, -55}, {112, -48}, {113, -47}, {114, -46}, {115, -45}, {116, -44}, {117, -43}, {118, -42}, {119, -41}, {120, -40}, {121, -39}};
    byte[] input2outputByteMap = new byte[256];
    Map<Vector<Object>, Boolean> layoutRedefMap = new HashMap<Vector<Object>, Boolean>(5);

    @Override
    public Object callGiving() {
        return new Variable(String.valueOf(2));
    }

    @Override
    public void call() {
    }

    public void debugVarInfo(Variable var) {
        Variable child = var.getChild();
        System.err.println(var.getLength() + " :" + var.getRecordPosition());
        if (child != null) {
            this.OutputVarInfo(child);
        }
    }

    public void OutputVarInfo(Variable var) {
        System.err.print((var instanceof DisplayP) + "   ");
        System.err.print(var.getClassName() + " StorageClass:");
        System.err.print(var.getStorageClass() + " Name:");
        System.err.print(var.getName() + " SignPosition:");
        System.err.print(var.getSignPosition() + " Type:");
        System.err.print(var.getType() + " TypeName:");
        System.err.print(var.getTypeName() + " TypeNumber:");
        System.err.print(var.getTypeNumber() + " Offset:");
        System.err.print(var.getRecordPosition() + " length:");
        System.err.println(var.getLength());
        if (var.getChild() != null) {
            this.OutputVarInfo(var.getChild());
        }
        if (var.getSibling() != null) {
            this.OutputVarInfo(var.getSibling());
        }
    }

    @Override
    public Object callGiving(parameterList param) {
        this.signedTransform = 1;
        this.inCharset = "IBM1047";
        this.outCharset = "ISO-8859-1";
        this.xfdFileName = "";
        this.statusCode = 0;
        this.offsetPos = 0;
        try {
            if (param.getLength() > 1) {
                this.inputVar = param.getVariable(0);
                this.errVar = param.getVariable(1);
                this.inBytes = this.inputVar.getBytes();
                if (this.inBytes != null && this.inBytes.length != 0) {
                    for (int i = 2; i < param.getLength(); ++i) {
                        String[] paramValue = param.getString(i).split("\\(|\\)");
                        if (paramValue.length == 2) {
                            switch (paramValue[0].toUpperCase()) {
                                case "CONV": {
                                    if (paramValue[1].equalsIgnoreCase("EBC2ASC")) {
                                        this.signedTransform = 1;
                                        break;
                                    }
                                    if (paramValue[1].equalsIgnoreCase("ASC2EBC")) {
                                        this.signedTransform = 2;
                                        break;
                                    }
                                    throw new TransformException("Invalid param:" + param.getString(i));
                                }
                                case "FROMCHAR": {
                                    this.inCharset = paramValue[1];
                                    break;
                                }
                                case "TOCHAR": {
                                    this.outCharset = paramValue[1];
                                    break;
                                }
                                case "XFDXML": {
                                    this.xfdFileName = paramValue[1];
                                    break;
                                }
                                default: {
                                    throw new TransformException("Unknown param:" + param.getString(i));
                                }
                            }
                            continue;
                        }
                        throw new TransformException("Invalid param:" + param.getString(i));
                    }
                    if (!this.prevXFDFileName.equals(this.xfdFileName)) {
                        this.XFDTree.clear();
                        this.xfdRowLayout = null;
                        this.xfdMap.clear();
                        this.xfdCondMap.clear();
                        hasMultipleLayouts = false;
                        hasSingleLayout = false;
                        hasNoLayouts = true;
                        this.xfdAvail = false;
                        this.layoutRedefMap.clear();
                        this.sqlTranslateMap.clear();
                        this.prevXFDFileName = this.xfdFileName.trim();
                        if (!this.xfdFileName.trim().isEmpty()) {
                            this.populateXFDTree(this.xfdFileName);
                        }
                        if (this.XFDTree.getItemCount() > 0) {
                            hasNoLayouts = false;
                            for (BatchTreeItem item : this.XFDTree.getItems()) {
                                Vector<Object> xfdCols = new Vector<Object>();
                                boolean hasRedef = false;
                                HashMap<Object, Object[]> condMap = new HashMap<Object, Object[]>();
                                for (BatchTreeItem subItem : item.getItems()) {
                                    if (subItem.getText(0).contains(this.REDEFINES_TXT)) continue;
                                    if (subItem.getData(this.REDEFINED) != null) {
                                        hasRedef = true;
                                        xfdCols.add(subItem);
                                        continue;
                                    }
                                    if (subItem.getChecked()) {
                                        xfdCols.add(subItem.getData());
                                    }
                                    if (subItem.getData(this.XFD_WHEN) == null || subItem.getText(0).contains(this.REDEFINES_TXT)) continue;
                                    Object[] condParams = (Object[])subItem.getData(this.XFD_WHEN);
                                    condMap.put(subItem.getData(), new Object[]{this.extractDataType(condParams[1], condParams[0]), this.extractDataType(condParams[2], condParams[0]), condParams[3], condParams[4]});
                                }
                                if (condMap.size() > 0) {
                                    this.xfdCondMap.put(xfdCols, condMap);
                                }
                                this.xfdMap.add(xfdCols);
                                if (hasRedef) {
                                    this.layoutRedefMap.put(xfdCols, true);
                                    continue;
                                }
                                this.layoutRedefMap.put(xfdCols, false);
                            }
                            hasMultipleLayouts = true;
                            this.xfdAvail = true;
                        }
                    }
                    this.beginTransformation();
                    this.inputVar.setString(this.inBytes);
                }
            } else {
                this.errVar.setString("Incorrect # of  params");
                this.statusCode = 2;
            }
        }
        catch (TransformException err) {
            this.errVar.setString(err.getMessage());
            this.statusCode = 2;
        }
        catch (Exception e) {
            this.errVar.setString("Unexpected Error: " + e.getMessage());
            this.statusCode = 1;
            e.printStackTrace();
        }
        return new Variable(String.valueOf(this.statusCode));
    }

    @Override
    public void call(parameterList param) {
        this.callGiving(param);
    }

    @Override
    public void cancel() {
    }

    @Override
    public String redirectCall() {
        return null;
    }

    private void beginTransformation() throws Exception {
        if (this.blockMaster.size() <= 0 || !this.inCharset.equalsIgnoreCase(this.prevInCharset) || !this.outCharset.equalsIgnoreCase(this.prevOutCharset)) {
            this.prevInCharset = this.inCharset;
            this.prevOutCharset = this.outCharset;
            this.setupTranslateTables();
        }
        this.badRecord = false;
        if (this.xfdAvail) {
            Vector<Object> layout;
            Vector<Object> vector = layout = this.xfdMap.size() == 1 ? this.xfdMap.get(0) : this.determineRowLayout(this.inBytes);
            if (this.badRecord) {
                return;
            }
            if (layout == null) {
                throw new TransformException("Unable to map layout to input data");
            }
            this.xfdRowLayout = this.layoutRedefMap.get(layout) != false ? this.extractRedefines(layout, this.inBytes, false) : layout;
            Object convInfo = null;
            for (Object col : this.xfdRowLayout) {
                if (!this.sqlTranslateMap.containsKey(col)) {
                    if (((SqlColumn)col).getSqlType().equals("A") || ((SqlColumn)col).getSqlType().equals("B")) {
                        convInfo = new Integer[]{1, ((SqlColumn)col).getOffset(), ((SqlColumn)col).getLength()};
                    } else {
                        IDatatype datatype = ((SqlColumn)col).getIDataTypeColumn();
                        int dtype = 0;
                        if (datatype instanceof DisplayP) {
                            dtype = ((DisplayP)datatype).getArgumentType();
                        } else if (datatype instanceof Display) {
                            dtype = ((Display)datatype).getArgumentType();
                        } else if (datatype instanceof DisplayA) {
                            dtype = ((DisplayA)datatype).getArgumentType();
                        } else if (datatype instanceof DisplayH) {
                            dtype = ((DisplayH)datatype).getArgumentType();
                        } else if (datatype instanceof DisplayMVS) {
                            dtype = ((DisplayMVS)datatype).getArgumentType();
                        }
                        convInfo = dtype != 0 ? new Integer[]{dtype == 5 || dtype == 3 ? Integer.valueOf(dtype == 5 ? 2 : 3) : Integer.valueOf(4), ((SqlColumn)col).getOffset(), ((SqlColumn)col).getLength()} : null;
                    }
                    this.sqlTranslateMap.put(col, (Integer[])convInfo);
                } else {
                    convInfo = this.sqlTranslateMap.get(col);
                }
                if (convInfo == null || convInfo[1] + convInfo[2] > this.inBytes.length) continue;
                if (convInfo[0] == 1 || convInfo[0] == 4 || this.signedTransform == 0) {
                    this.translateCharset(this.inBytes, convInfo[1], convInfo[2]);
                    continue;
                }
                if (convInfo[0] != 2 && convInfo[0] != 3) continue;
                this.translateSigned(this.inBytes, convInfo[0] == 2, convInfo[1], convInfo[2], this.signedTransform != 1);
            }
            if (this.badRecord) {
                return;
            }
        } else {
            this.transformData(this.inputVar);
            if (this.offsetPos != this.inputVar.getLength()) {
                throw new TransformException("Missing field (offset:" + this.offsetPos + ":" + (this.inputVar.getLength() - this.offsetPos) + ") Use compiler option -opt:keepunusedvars ");
            }
        }
        this.inputVar.setString(this.inBytes);
    }

    public void transformData(Variable var) throws Exception {
        if (var.isFlagRedefines()) {
            if (!var.equals(this.inputVar) && var.getSibling() != null) {
                this.transformData(var.getSibling());
            }
        } else if (var.getChild() == null) {
            if (var.getRecordPosition() + var.getLength() <= this.inBytes.length) {
                if (var.getRecordPosition() != this.offsetPos) {
                    throw new TransformException("Missing field (" + this.offsetPos + ":" + (var.getRecordPosition() - this.offsetPos) + ")Use compiler option -opt:keepunusedvars");
                }
                this.offsetPos += var.getLength() * var.getMaxIndex();
                this.transformField(var);
                if (!var.equals(this.inputVar) && var.getSibling() != null) {
                    this.transformData(var.getSibling());
                }
            }
        } else {
            this.transformData(var.getChild());
            if (var.getMaxIndex() > 1) {
                this.offsetPos += var.getLength() * (var.getMaxIndex() - 1);
            }
            if (!var.equals(this.inputVar) && var.getSibling() != null) {
                this.transformData(var.getSibling());
            }
        }
    }

    public void transformField(Variable var) {
        if (this.TypeA.contains(var.getTypeName())) {
            this.translateCharset(this.inBytes, var.getRecordPosition(), var.getLength());
        } else {
            int dtype = 0;
            if (var instanceof DisplayP) {
                dtype = ((DisplayP)var).getArgumentType();
            } else if (var instanceof Display) {
                dtype = ((Display)var).getArgumentType();
            } else if (var instanceof DisplayA) {
                dtype = ((DisplayA)var).getArgumentType();
            } else if (var instanceof DisplayH) {
                dtype = ((DisplayH)var).getArgumentType();
            } else if (var instanceof DisplayMVS) {
                dtype = ((DisplayMVS)var).getArgumentType();
            }
            if (dtype != 0) {
                if (dtype == 5 || dtype == 3) {
                    this.translateSigned(this.inBytes, dtype == 5, var.getRecordPosition(), var.getLength(), this.signedTransform != 1);
                } else {
                    this.translateCharset(this.inBytes, var.getRecordPosition(), var.getLength());
                }
            }
        }
    }

    private void setupTranslateTables() throws Exception {
        String transformFileCharsetHexMap = "000102030405060708090A0B0C0D0E0F101112131415161718191A1B1C1D1E1F202122232425262728292A2B2C2D2E2F303132333435363738393A3B3C3D3E3F404142434445464748494A4B4C4D4E4F505152535455565758595A5B5C5D5E5F606162636465666768696A6B6C6D6E6F707172737475767778797A7B7C7D7E7F808182838485868788898A8B8C8D8E8F909192939495969798999A9B9C9D9E9FA0A1A2A3A4A5A6A7A8A9AAABACADAEAFB0B1B2B3B4B5B6B7B8B9BABBBCBDBEBFC0C1C2C3C4C5C6C7C8C9CACBCCCDCECFD0D1D2D3D4D5D6D7D8D9DADBDCDDDEDFE0E1E2E3E4E5E6E7E8E9EAEBECEDEEEFF0F1F2F3F4F5F6F7F8F9FAFBFCFDFEFF";
        String loadFileCharsetHexMap = "";
        boolean isInEBCIDIC = this.ebcidicCodeSets.contains(" " + this.inCharset.toUpperCase().replaceFirst("(IBM-)|(IBM)|(CP)", "") + ",");
        this.inCharset = isInEBCIDIC ? String.format("%05d", Integer.parseInt(this.inCharset.replaceAll("[^\\d.]", ""))) : this.inCharset.toUpperCase();
        boolean isOutEBCIDIC = this.ebcidicCodeSets.contains(" " + this.outCharset.toUpperCase().replaceFirst("(IBM-)|(IBM)|(CP)", "") + ",");
        this.outCharset = isOutEBCIDIC ? String.format("%05d", Integer.parseInt(this.outCharset.replaceAll("[^\\d.]", ""))) : this.outCharset.toUpperCase();
        String line = null;
        ArrayList<String> blockInfoBuild = new ArrayList<String>(10);
        StringBuilder loadFileSB = new StringBuilder(256);
        if (this.blockMaster.size() == 0) {
            InputStream in = Transform.class.getResourceAsStream("codepageconversions.txt");
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(in));
            while (true) {
                if ((line = bufferedReader.readLine()) == null || line.startsWith("UCS-4")) {
                    if (blockInfoBuild.size() > 0) {
                        this.blockMaster.add(blockInfoBuild);
                        blockInfoBuild = new ArrayList(10);
                    }
                    if (line == null) {
                        break;
                    }
                } else if (line.startsWith("#")) continue;
                blockInfoBuild.add(line.trim());
            }
            bufferedReader.close();
        }
        for (int i = 0; i < 512; i += 2) {
            if (isOutEBCIDIC != isInEBCIDIC && i == 510 && transformFileCharsetHexMap.substring(i, i + 2).equals("FF")) {
                loadFileSB.append("FF");
                continue;
            }
            String scan = (isOutEBCIDIC ? "EBCDIC " : "ASCII ") + transformFileCharsetHexMap.substring(i, i + 2) + ":";
            ArrayList<String> blockAllMatch = null;
            ArrayList<String> blockExactMatch = null;
            for (ArrayList<String> blockInfo : this.blockMaster) {
                for (String blockStr : blockInfo) {
                    if (!blockStr.startsWith(scan)) continue;
                    if (blockStr.contains(isOutEBCIDIC ? ": all EBCDIC" : ": all ASCII")) {
                        blockAllMatch = blockInfo;
                        break;
                    }
                    if (!blockStr.contains(this.outCharset + " ") && !blockStr.endsWith(this.outCharset)) continue;
                    blockExactMatch = blockInfo;
                    break;
                }
                if (blockExactMatch == null) continue;
                break;
            }
            if (blockExactMatch == null && blockAllMatch == null) {
                throw new TransformException("Codepage match not found:\nOutput Charset:" + this.outCharset + "\nchar: 0x" + transformFileCharsetHexMap.substring(i, i + 2));
            }
            if (blockExactMatch == null) {
                blockExactMatch = blockAllMatch;
            }
            scan = isInEBCIDIC ? "EBCDIC " : "ASCII ";
            boolean matchAll = false;
            boolean matchExact = false;
            String loadCharsetHex = "";
            for (String blockStr : blockExactMatch) {
                if (!blockStr.startsWith(scan) || !blockStr.contains(isInEBCIDIC ? ": all EBCDIC" : ": all ASCII") && !blockStr.contains(this.inCharset + " ") && !blockStr.endsWith(this.inCharset)) continue;
                String[] blockVals = blockStr.split(" |:");
                if (blockVals.length < 3) {
                    throw new TransformException("Output Data extraction Error\nInput Charset:" + this.inCharset + "\nchar: 0x" + transformFileCharsetHexMap.substring(i, i + 2) + "\nOutput Charset:" + this.outCharset);
                }
                if (blockStr.contains(isInEBCIDIC ? ": all EBCDIC" : ": all ASCII")) {
                    matchAll = true;
                    if (!loadCharsetHex.isEmpty()) continue;
                    loadCharsetHex = blockVals[1];
                    continue;
                }
                matchExact = true;
                loadCharsetHex = blockVals[1];
                break;
            }
            if (!matchAll && !matchExact) {
                throw new TransformException("No match for data conversion\nInput Charset:" + this.inCharset + "\nchar: 0x" + transformFileCharsetHexMap.substring(i, i + 2) + "\nOutput Charset:" + this.outCharset);
            }
            loadFileSB.append(loadCharsetHex);
        }
        loadFileCharsetHexMap = loadFileSB.toString();
        TreeMap<Integer, Integer> input2outputCharsetIntMap = new TreeMap<Integer, Integer>();
        for (int i = 0; i < transformFileCharsetHexMap.length(); i += 2) {
            int inputCharsetIntVal = Integer.decode("0x" + loadFileCharsetHexMap.substring(i, i + 2));
            int ouputCharsetIntVal = Integer.decode("0x" + transformFileCharsetHexMap.substring(i, i + 2));
            input2outputCharsetIntMap.put(inputCharsetIntVal, ouputCharsetIntVal);
        }
        int j = 0;
        for (Map.Entry i : input2outputCharsetIntMap.entrySet()) {
            if ((Integer)i.getKey() != j) {
                ++j;
            }
            this.input2outputByteMap[j] = (byte)((Integer)i.getValue()).intValue();
            ++j;
        }
    }

    private Vector<Object> determineRowLayout(byte[] buf) throws Exception {
        Iterator<Map.Entry<Vector<Object>, HashMap<Object, Object[]>>> it = this.xfdCondMap.entrySet().iterator();
        boolean found = false;
        while (it.hasNext()) {
            Map.Entry<Vector<Object>, HashMap<Object, Object[]>> keyvalue = it.next();
            HashMap<Object, Object[]> condMap = keyvalue.getValue();
            Iterator<Map.Entry<Object, Object[]>> condIt = condMap.entrySet().iterator();
            found = true;
            while (condIt.hasNext()) {
                Map.Entry<Object, Object[]> keyval = condIt.next();
                if (!this.checkXFDCondition(buf, keyval)) {
                    found = false;
                    break;
                }
                if (!this.badRecord) continue;
                return this.xfdMap.get(0);
            }
            if (this.badRecord) {
                return this.xfdMap.get(0);
            }
            if (!found) continue;
            return keyvalue.getKey();
        }
        return this.xfdMap.get(0);
    }

    private boolean checkXFDCondition(byte[] buf, Map.Entry<Object, Object[]> keyval) throws Exception {
        Object sqlObject = keyval.getKey();
        for (int i = 0; i < ((SqlColumn)sqlObject).getComponentCount(); ++i) {
            if (((SqlColumn)sqlObject).getOffset(i) + ((SqlColumn)sqlObject).getLength(i) <= buf.length) continue;
            throw new TransformException("Bad Input for Field:" + ((SqlColumn)sqlObject).getName() + " Offset:" + ((SqlColumn)sqlObject).getOffset(i) + " Length:" + ((SqlColumn)sqlObject).getLength(i));
        }
        Object[] objArray = keyval.getValue();
        Object operand1 = objArray[0];
        Object operand2 = objArray[1];
        String cond = (String)objArray[2];
        return this.checkXFDCondition(buf, sqlObject, operand1, operand2, cond);
    }

    private boolean checkXFDCondition(byte[] buf, Object sqlObject, Object operand1, Object operand2, Object cond) {
        ((SqlColumn)sqlObject).snagValue(buf, 0);
        IDatatype operand0 = ((SqlColumn)sqlObject).getIDataTypeColumn();
        int compare1 = this.compareOperands(operand0, operand1);
        if (cond.equals(CONDITIONS.get(0))) {
            return compare1 <= 0;
        }
        if (cond.equals(CONDITIONS.get(1))) {
            return compare1 < 0;
        }
        if (cond.equals(CONDITIONS.get(2))) {
            return compare1 == 0;
        }
        if (cond.equals(CONDITIONS.get(3))) {
            return compare1 >= 0;
        }
        if (cond.equals(CONDITIONS.get(4))) {
            return compare1 > 0;
        }
        if (cond.equals(CONDITIONS.get(5))) {
            int compare2 = this.compareOperands(operand0, operand2);
            return compare1 >= 0 && compare2 <= 0;
        }
        if (cond.equals(CONDITIONS.get(6))) {
            return compare1 > 0;
        }
        if (cond.equals(CONDITIONS.get(7))) {
            return compare1 >= 0;
        }
        if (cond.equals(CONDITIONS.get(8))) {
            return compare1 != 0;
        }
        if (cond.equals(CONDITIONS.get(9))) {
            return compare1 < 0;
        }
        if (cond.equals(CONDITIONS.get(10))) {
            return compare1 <= 0;
        }
        if (cond.equals(CONDITIONS.get(11))) {
            int compare2 = this.compareOperands(operand0, operand2);
            return compare1 < 0 || compare2 > 0;
        }
        return true;
    }

    private int compareOperands(Object op0, Object op1) {
        if (op0 instanceof Variable) {
            return ((Variable)op0).compare((Variable)op1);
        }
        if (op1 instanceof BignumType) {
            return ((BignumType)op0).compare((BignumType)op1);
        }
        if (op1 instanceof Comp1) {
            return ((Comp1)op0).compare((Comp1)op1);
        }
        if (op1 instanceof Comp2) {
            return ((Comp2)op0).compare((Comp2)op1);
        }
        if (op1 instanceof Numeric) {
            return ((Numeric)op0).compare((Numeric)op1);
        }
        new Exception("Unknown dataType encountered during comparison:" + op0.toString());
        return 0;
    }

    private void translateCharset(byte[] inBytes, int off, int len) {
        for (int i = off; i < inBytes.length && i < off + len; ++i) {
            inBytes[i] = inBytes[i] < 0 ? this.input2outputByteMap[256 + inBytes[i]] : this.input2outputByteMap[inBytes[i]];
        }
    }

    public void translateSigned(byte[] inBytes, boolean islead, int off, int len, boolean isAsc2Ebc) {
        byte bb = islead ? inBytes[off] : inBytes[off + len - 1];
        if (isAsc2Ebc) {
            for (int i = 0; i < 20; ++i) {
                if (bb != this.signedAscToEbcMap[i][0]) continue;
                bb = this.signedAscToEbcMap[i][1];
                break;
            }
        } else {
            for (int i = 0; i < 20; ++i) {
                if (bb != this.signedAscToEbcMap[i][1]) continue;
                bb = this.signedAscToEbcMap[i][0];
                break;
            }
        }
        if (islead) {
            inBytes[off] = bb;
            this.translateCharset(inBytes, off + 1, len - 1);
        } else {
            inBytes[off + len - 1] = bb;
            this.translateCharset(inBytes, off, len - 1);
        }
    }

    private Vector<Object> extractRedefines(Vector<Object> layout, byte[] buf, boolean prompt) {
        this.useDefaultRedef = false;
        Vector<Object> newLayout = new Vector<Object>(layout.size());
        for (Object obj : layout) {
            if (obj instanceof BatchTreeItem) {
                this.processRedefines((BatchTreeItem)obj, newLayout, buf, prompt);
                continue;
            }
            newLayout.addElement(obj);
        }
        return newLayout;
    }

    private void processRedefines(BatchTreeItem redefinedItem, Vector<Object> newlayout, byte[] buf, boolean prompt) {
        Object data = redefinedItem.getData(this.REDEFINED);
        if (data != null) {
            ArrayList redefines = (ArrayList)data;
            if (prompt) {
                this.extractRedefines(redefinedItem, newlayout, buf, prompt);
            } else {
                for (int i = 0; i < redefines.size(); ++i) {
                    Object[] condParams = (Object[])((BatchTreeItem)redefines.get(i)).getData(this.XFD_WHEN);
                    BatchTreeItem condItem = this.getItemInLayout((String)condParams[4], (BatchTreeItem)redefines.get(i));
                    if (!this.checkXFDCondition(buf, condItem.getData(), this.extractDataType(condParams[1], condParams[0]), this.extractDataType(condParams[2], condParams[0]), condParams[3])) continue;
                    this.extractRedefines((BatchTreeItem)redefines.get(i), newlayout, buf, prompt);
                    return;
                }
                this.extractRedefines(redefinedItem, newlayout, buf, prompt);
            }
        }
    }

    private void extractRedefines(BatchTreeItem Item, Vector<Object> newlayout, byte[] buf, boolean prompt) {
        if (Item.getItemCount() == 0 && Item.getChecked()) {
            newlayout.add(Item.getData());
        } else {
            for (BatchTreeItem itm : Item.getItems()) {
                if (itm.getText(0).contains(this.REDEFINES_TXT)) continue;
                if (itm.getItemCount() == 0 && itm.getChecked()) {
                    newlayout.add(itm.getData());
                }
                if (itm.getItemCount() <= 0 || itm.getData(this.REDEFINED) == null) continue;
                this.processRedefines(itm, newlayout, buf, prompt);
            }
        }
    }

    private BatchTreeItem getItemInLayout(String vname, BatchTreeItem currItem) {
        while (currItem.getParentItem() != null) {
            currItem = currItem.getParentItem();
        }
        for (BatchTreeItem itm2 : currItem.getItems()) {
            if (itm2.getItemCount() == 0 && !itm2.getText().contains(this.REDEFINES_TXT)) {
                if (!itm2.getText().startsWith(vname) || !itm2.getText().substring(0, itm2.getText().indexOf(91)).equals(vname)) continue;
                return itm2;
            }
            if (itm2.getItemCount() <= 0 || itm2.getText().contains(this.REDEFINES_TXT)) continue;
            for (BatchTreeItem itm3 : itm2.getItems()) {
                if (itm3.getItemCount() != 0 || itm3.getText().contains(this.REDEFINES_TXT) || !itm3.getText().startsWith(vname) || !itm3.getText().substring(0, itm3.getText().indexOf(91)).equals(vname)) continue;
                return itm3;
            }
        }
        return null;
    }

    private Object extractDataType(Object obj1, Object sqlObj) {
        if (obj1 == null) {
            return null;
        }
        SqlColumn sqlWork = ((SqlColumn)sqlObj).createWorkingCopy();
        sqlWork.updateColumn((byte[])obj1, 0, (byte[])obj1);
        return sqlWork.getIDataTypeColumn();
    }

    private boolean populateXFDTree(String filename) throws Exception {
        LinkedHashMap<String, LinkedHashMap<String, Object>> layoutsMap = XmlDatasetLoader.XmlToFileTableExt(filename);
        Set<Map.Entry<String, LinkedHashMap<String, Object>>> layoutsEntrySet = layoutsMap.entrySet();
        Iterator<Map.Entry<String, LinkedHashMap<String, Object>>> layoutsIter = layoutsEntrySet.iterator();
        boolean ignore = false;
        while (layoutsIter.hasNext()) {
            Map.Entry<String, LinkedHashMap<String, Object>> elementsMap = layoutsIter.next();
            ignore = false;
            for (BatchTreeItem itm : this.XFDTree.getItems()) {
                if (!itm.getText().equals(elementsMap.getKey())) continue;
                ignore = true;
            }
            if (ignore) continue;
            BatchTreeItem layoutItem = new BatchTreeItem(this.XFDTree);
            layoutItem.setText(elementsMap.getKey());
            this.whenConds.clear();
            this.recursiveLoadElements(elementsMap.getValue(), layoutItem, false);
            if (!this.validateConditions(layoutItem)) {
                return false;
            }
            layoutItem.setChecked(true);
            layoutItem.setData("FILE", filename);
        }
        return true;
    }

    private int recursiveLoadElements(LinkedHashMap<String, Object> elementsMap, BatchTreeItem currItem, boolean isredef) throws Exception {
        int maxGrpLen = 0;
        int groupLen = 0;
        int fieldLen = 0;
        Set<Map.Entry<String, Object>> elementsEntrySet = elementsMap.entrySet();
        Iterator<Map.Entry<String, Object>> elementsIter = elementsEntrySet.iterator();
        BatchTreeItem lastItem = null;
        while (elementsIter.hasNext()) {
            Map.Entry<String, Object> elementsES = elementsIter.next();
            String[] vals = elementsES.getKey().split(String.valueOf('\u001d'), 2);
            if (elementsES.getValue() instanceof SqlColumn) {
                BatchTreeItem sqlColItem = new BatchTreeItem(currItem);
                sqlColItem.setChecked(true);
                sqlColItem.setData(elementsES.getValue());
                fieldLen = ((SqlColumn)elementsES.getValue()).getLength();
                sqlColItem.setText(1, ((SqlColumn)elementsES.getValue()).getPicString());
                if (elementsES.getKey().contains(this.REDEFINES_TXT)) {
                    if (lastItem != null) {
                        ArrayList data = lastItem.getData(this.REDEFINED);
                        if (data == null) {
                            data = new ArrayList();
                        }
                        ((ArrayList)data).add(sqlColItem);
                        lastItem.setData(this.REDEFINED, data);
                    }
                    sqlColItem.setText(vals[0]);
                    if (fieldLen > maxGrpLen) {
                        groupLen += fieldLen - maxGrpLen;
                        maxGrpLen = fieldLen;
                    }
                } else {
                    sqlColItem.setText(((SqlColumn)elementsES.getValue()).getName().toUpperCase() + "[" + ((SqlColumn)elementsES.getValue()).getOffset() + ":" + ((SqlColumn)elementsES.getValue()).getLength() + "]");
                    lastItem = sqlColItem;
                    groupLen += fieldLen;
                    maxGrpLen = fieldLen;
                }
                if (vals.length != 2) continue;
                sqlColItem.setData("XMLATTR", vals[1]);
                this.whenConds.add(sqlColItem);
                continue;
            }
            BatchTreeItem newItem = new BatchTreeItem(currItem);
            if (elementsES.getKey().contains(this.REDEFINES_TXT)) {
                newItem.setText(vals[0]);
                newItem.setData("XMLATTR", vals[1]);
                this.whenConds.add(newItem);
                if (lastItem != null) {
                    ArrayList data = lastItem.getData(this.REDEFINED);
                    if (data == null) {
                        data = new ArrayList();
                    }
                    ((ArrayList)data).add(newItem);
                    lastItem.setData(this.REDEFINED, data);
                }
            } else {
                newItem.setText(elementsES.getKey());
                lastItem = newItem;
                maxGrpLen = 0;
            }
            newItem.setChecked(true);
            int currGrpLen = this.recursiveLoadElements((LinkedHashMap)elementsES.getValue(), newItem, elementsES.getKey().contains(this.REDEFINES_TXT));
            if (currGrpLen <= maxGrpLen) continue;
            groupLen += currGrpLen - maxGrpLen;
            maxGrpLen = currGrpLen;
        }
        return groupLen;
    }

    private boolean validateConditions(BatchTreeItem layoutItem) throws Exception {
        for (BatchTreeItem whenItm : this.whenConds) {
            Object sqlvar;
            String whenattr = (String)whenItm.getData("XMLATTR");
            String[] attrs = whenattr.split(String.valueOf('\u001d'));
            BatchTreeItem varItem = null;
            String desc = "";
            String varname = null;
            if (whenItm.getText().contains(this.REDEFINES_TXT)) {
                varname = attrs[3].toUpperCase();
                for (BatchTreeItem itm2 : layoutItem.getItems()) {
                    BatchTreeItem result = this.getXFdVarMatch(itm2, varname);
                    if (result == null) continue;
                    varItem = result;
                    break;
                }
                if (varItem == null) {
                    throw new TransformException("$XFD WHEN Unable to map <varname>:" + varname);
                }
                desc = desc + varname;
                sqlvar = varItem.getData();
            } else {
                sqlvar = whenItm.getData();
            }
            SqlColumn workSql = ((SqlColumn)sqlvar).createWorkingCopy();
            String oper = attrs[0];
            if (oper.equalsIgnoreCase("LTEQ")) {
                oper = "IS < OR = TO";
            } else if (oper.equalsIgnoreCase("LT")) {
                oper = "IS < THAN";
            } else if (oper.equalsIgnoreCase("EQ")) {
                oper = "IS = TO";
            } else if (oper.equalsIgnoreCase("GTEQ")) {
                oper = "IS > OR = TO";
            } else if (oper.equalsIgnoreCase("GT")) {
                oper = "IS > THAN";
            } else if (oper.equalsIgnoreCase("BET")) {
                oper = "IS BETWEEN";
            } else if (oper.equalsIgnoreCase("!LTEQ")) {
                oper = "NOT < OR = TO";
            } else if (oper.equalsIgnoreCase("!LT")) {
                oper = "NOT < THAN";
            } else if (oper.equalsIgnoreCase("!EQ")) {
                oper = "NOT = TO";
            } else if (oper.equalsIgnoreCase("!GTEQ")) {
                oper = "NOT > OR = TO";
            } else if (oper.equalsIgnoreCase("!GT")) {
                oper = "NOT > THAN";
            } else if (oper.equalsIgnoreCase("!BET")) {
                oper = "NOT BETWEEN";
            }
            int sqlLen = workSql.getLength();
            byte[] arg1Buf = new byte[sqlLen];
            workSql.updateColumn(arg1Buf, 0, attrs[1]);
            desc = desc + " " + oper + "  [" + attrs[1] + "] ";
            byte[] arg2Buf = null;
            if (oper.contains("BETWEEN")) {
                arg2Buf = new byte[sqlLen];
                workSql.updateColumn(arg2Buf, 0, attrs[2]);
                desc = desc + " AND [" + attrs[2] + "] ";
            }
            whenItm.setText(2, desc);
            whenItm.setData(this.XFD_WHEN, new Object[]{workSql, arg1Buf, arg2Buf, oper, varname});
        }
        return true;
    }

    private String getFieldName(BatchTreeItem item) {
        if (item.getText().indexOf(91) != -1) {
            return item.getText().substring(0, item.getText().indexOf(91));
        }
        if (item.getText().indexOf(32) != -1) {
            return item.getText().substring(0, item.getText().indexOf(32));
        }
        return item.getText();
    }

    private BatchTreeItem getXFdVarMatch(BatchTreeItem item, String varname) {
        if (item.getData() != null && varname.equals(this.getFieldName(item))) {
            return item;
        }
        for (BatchTreeItem subItem : item.getItems()) {
            if (subItem.getItemCount() == 0 && item.getData() != null && varname.equals(this.getFieldName(subItem))) {
                return subItem;
            }
            BatchTreeItem result = this.getXFdVarMatch(subItem, varname);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    class TransformException
    extends Exception {
        private static final long serialVersionUID = 1L;
        String errMessg;

        TransformException(String err) {
            this.errMessg = err;
        }

        @Override
        public String getMessage() {
            return this.errMessg;
        }
    }
}

