/*
 * Decompiled with CFR 0.152.
 */
package com.heirloomcomputing.ecs.libcall;

import com.heirloomcomputing.ecs.api.ICallTarget2;
import com.heirloomcomputing.ecs.api.IDatatype;
import com.heirloomcomputing.ecs.api.IProgramEnvironment;

public class EZASOKET
implements ICallTarget2 {
    @Override
    public Object call(IProgramEnvironment programenvironment, boolean[] byReference, Object[] params) {
        if (params == null || params.length < 2) {
            throw new RuntimeException("Invalid number of parameters");
        }
        String functionName = null;
        IDatatype fnName = (IDatatype)params[0];
        functionName = fnName.toText().trim();
        Function currFunction = Function.valueOf(functionName.toUpperCase());
        switch (currFunction) {
            case CLOSE: {
                this.close(programenvironment, byReference, params);
                break;
            }
            case CONNECT: {
                this.connect(programenvironment, byReference, params);
                break;
            }
            case GETHOSTBYNAME: {
                this.getHostByName(programenvironment, byReference, params);
                break;
            }
            case GETHOSTID: {
                this.getHostId(programenvironment, byReference, params);
                break;
            }
            case INITAPI: {
                System.out.println("InitAPI function");
                break;
            }
            case RECV: {
                this.recv(programenvironment, byReference, params);
                break;
            }
            case SELECT: {
                this.select(programenvironment, byReference, params);
                break;
            }
            case SOCKET: {
                this.socket(programenvironment, byReference, params);
                break;
            }
            case TERMAPI: {
                System.out.println("TermAPI function");
                break;
            }
            case WRITE: {
                this.write(programenvironment, byReference, params);
                break;
            }
            case TIMEOUTS: {
                this.setTimeouts(programenvironment, byReference, params);
                break;
            }
            default: {
                throw new RuntimeException("Invalid EZASOKET function");
            }
        }
        return "0";
    }

    private int close(IProgramEnvironment programenvironment, boolean[] byReference, Object[] params) {
        int rc = 0;
        if (params.length != 4) {
            rc = -1;
            throw new RuntimeException("EZASOKET::CLOSE::Invalid number of parameters");
        }
        IDatatype iSocketDescriptor = (IDatatype)params[1];
        IDatatype iErrNo = (IDatatype)params[2];
        IDatatype iRetCode = (IDatatype)params[3];
        int descriptor = iSocketDescriptor.toInt();
        rc = programenvironment.getEzasoketContext().closeSocket(descriptor);
        switch (rc) {
            case 0: {
                iRetCode.fromText("0");
                break;
            }
            case 1: {
                iRetCode.fromText("-1");
                iErrNo.fromText("00001");
                break;
            }
            case 42: {
                iRetCode.fromText("-1");
                iErrNo.fromText("00042");
                break;
            }
            case 10220: {
                iRetCode.fromText("-1");
                iErrNo.fromText("10220");
            }
        }
        return rc;
    }

    private int connect(IProgramEnvironment programenvironment, boolean[] byReference, Object[] params) {
        int rc = 0;
        if (params.length != 5) {
            rc = -1;
            throw new RuntimeException("EZASOKET::CONNECT::Invalid number of parameters");
        }
        IDatatype iSocketDescriptor = (IDatatype)params[1];
        IDatatype iName = (IDatatype)params[2];
        IDatatype iErrNo = (IDatatype)params[3];
        IDatatype iRetCode = (IDatatype)params[4];
        int descriptor = iSocketDescriptor.toInt();
        rc = programenvironment.getEzasoketContext().connectSocket(descriptor, iName);
        switch (rc) {
            case 0: {
                iRetCode.fromText("0");
                break;
            }
            case 1: {
                iRetCode.fromText("-1");
                iErrNo.fromText("00001");
                break;
            }
            case 5: {
                iRetCode.fromText("-1");
                iErrNo.fromText("00005");
                break;
            }
            case 6: {
                iRetCode.fromText("-1");
                iErrNo.fromText("00006");
                break;
            }
            case 10220: {
                iRetCode.fromText("-1");
                iErrNo.fromText("10220");
                break;
            }
            case 10221: {
                iRetCode.fromText("-1");
                iErrNo.fromText("10221");
            }
        }
        return rc;
    }

    private int getHostByName(IProgramEnvironment programenvironment, boolean[] byReference, Object[] params) {
        int rc = 0;
        if (params.length != 5) {
            rc = -1;
            throw new RuntimeException("EZASOKET::GETHOSTBYNAME::Invalid number of parameters");
        }
        IDatatype iNameLength = (IDatatype)params[1];
        IDatatype iName = (IDatatype)params[2];
        IDatatype iHostEnt = (IDatatype)params[3];
        IDatatype iRetCode = (IDatatype)params[4];
        int lenOfName = iNameLength.toInt();
        String host = iName.toText().substring(0, lenOfName);
        rc = programenvironment.getEzasoketContext().getHostByName(host, iHostEnt);
        iRetCode.fromInt(rc);
        return rc;
    }

    private int getHostId(IProgramEnvironment programenvironment, boolean[] byReference, Object[] params) {
        int rc = 0;
        if (params.length != 2) {
            rc = -1;
            throw new RuntimeException("EZASOKET::GETHOSTID::Invalid number of parameters");
        }
        IDatatype iRetCode = (IDatatype)params[1];
        rc = programenvironment.getEzasoketContext().getHostId(iRetCode);
        switch (rc) {
            case 0: {
                break;
            }
            case -1: {
                iRetCode.fromText("-1");
            }
        }
        return rc;
    }

    private int recv(IProgramEnvironment programenvironment, boolean[] byReference, Object[] params) {
        int rc = 0;
        if (params.length != 7) {
            rc = -1;
            throw new RuntimeException("EZASOKET::RECV::Invalid number of parameters");
        }
        IDatatype iSocketDescriptor = (IDatatype)params[1];
        IDatatype iNumBytes = (IDatatype)params[3];
        IDatatype iBuffer = (IDatatype)params[4];
        IDatatype iErrNo = (IDatatype)params[5];
        IDatatype iRetCode = (IDatatype)params[6];
        int nBytes = iNumBytes.toInt();
        if (nBytes <= 0 || nBytes > iBuffer.getLength()) {
            if (nBytes == 0) {
                iErrNo.fromText("10163");
            } else if (nBytes > 0) {
                iErrNo.fromText("10164");
            } else {
                iErrNo.fromText("10163");
            }
            iRetCode.fromText("-1");
            return rc;
        }
        int descriptor = iSocketDescriptor.toInt();
        rc = programenvironment.getEzasoketContext().recvFromSocket(descriptor, nBytes, iBuffer, iRetCode);
        switch (rc) {
            case 0: {
                break;
            }
            case 10217: {
                iRetCode.fromText("-1");
                iErrNo.fromText("10217");
                break;
            }
            case 10666: {
                iRetCode.fromText("-1");
                iErrNo.fromText("10666");
            }
        }
        return rc;
    }

    private int socket(IProgramEnvironment programenvironment, boolean[] byReference, Object[] params) {
        int rc = 0;
        if (params.length != 6) {
            rc = -1;
            throw new RuntimeException("EZASOKET::SOCKET::Invalid number of parameters");
        }
        IDatatype iErrNo = (IDatatype)params[4];
        IDatatype iRetCode = (IDatatype)params[5];
        int descriptor = 0;
        try {
            descriptor = programenvironment.getEzasoketContext().getSocket();
        }
        catch (Exception e) {
            descriptor = -1;
            iErrNo.fromText("10182");
        }
        iRetCode.fromInt(descriptor);
        return rc;
    }

    private int select(IProgramEnvironment programenvironment, boolean[] byReference, Object[] params) {
        int rc = 0;
        if (params.length != 11) {
            rc = -1;
            throw new RuntimeException("EZASOKET::SELECT::Invalid number of parameters");
        }
        rc = programenvironment.getEzasoketContext().select(params);
        return rc;
    }

    private int write(IProgramEnvironment programenvironment, boolean[] byReference, Object[] params) {
        int rc = 0;
        if (params.length != 6) {
            rc = -1;
            throw new RuntimeException("EZASOKET::WRITE::Invalid number of parameters");
        }
        IDatatype iSocketDescriptor = (IDatatype)params[1];
        IDatatype iNumBytes = (IDatatype)params[2];
        IDatatype iBuffer = (IDatatype)params[3];
        IDatatype iErrNo = (IDatatype)params[4];
        IDatatype iRetCode = (IDatatype)params[5];
        int nBytes = iNumBytes.toInt();
        if (nBytes <= 0 || nBytes > iBuffer.getLength()) {
            if (nBytes == 0) {
                iErrNo.fromText("10184");
            } else if (nBytes > 0) {
                iErrNo.fromText("10185");
            } else {
                iErrNo.fromText("10186");
            }
            iRetCode.fromText("-1");
            return rc;
        }
        int descriptor = iSocketDescriptor.toInt();
        rc = programenvironment.getEzasoketContext().writeToSocket(descriptor, nBytes, iBuffer, iRetCode);
        switch (rc) {
            case 0: {
                break;
            }
            case 5: {
                iRetCode.fromText("-1");
                iErrNo.fromText("00005");
                break;
            }
            case 10217: {
                iRetCode.fromText("-1");
                iErrNo.fromText("10217");
            }
        }
        return rc;
    }

    private int setTimeouts(IProgramEnvironment programenvironment, boolean[] byReference, Object[] params) {
        int rc = 0;
        if (params.length != 7) {
            rc = -1;
            throw new RuntimeException("EZASOKET::TIMEOUTS::Invalid number of parameters");
        }
        IDatatype iConnectTimeout = (IDatatype)params[1];
        IDatatype iReadTimeout = (IDatatype)params[2];
        IDatatype iCloseTimeout = (IDatatype)params[3];
        IDatatype iKeepAlive = (IDatatype)params[4];
        rc = programenvironment.getEzasoketContext().setTimeouts(iConnectTimeout.toInt(), iReadTimeout.toInt(), iCloseTimeout.toInt(), iKeepAlive.toBoolean());
        return rc;
    }

    private static enum Function {
        CLOSE,
        CONNECT,
        GETHOSTBYNAME,
        GETHOSTID,
        INITAPI,
        RECV,
        SELECT,
        SOCKET,
        TERMAPI,
        WRITE,
        WRITEV,
        TIMEOUTS;

    }
}

