/*
 * Decompiled with CFR 0.152.
 */
package com.heirloomcomputing.ecs.libcall;

import com.heirloomcomputing.ecs.api.ICallTarget2;
import com.heirloomcomputing.ecs.api.IDatatype;
import com.heirloomcomputing.ecs.api.IProgramEnvironment;
import com.heirloomcomputing.ecs.exec.Context;
import com.heirloomcomputing.ecs.util.JUrl;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class JOBXMIT
implements ICallTarget2 {
    private List<String> recList = new ArrayList<String>();

    @Override
    public Object call(IProgramEnvironment programenvironment, boolean[] byReference, Object[] params) {
        if (params == null || params.length < 2) {
            throw new RuntimeException("Invalid number of parameters");
        }
        int rc = 0;
        String functionName = null;
        IDatatype fnName = (IDatatype)params[0];
        functionName = fnName.toText().trim();
        Function currFunction = Function.valueOf(functionName.toUpperCase());
        switch (currFunction) {
            case ADDREC: {
                rc = this.addrec(programenvironment, byReference, params);
                break;
            }
            case ADDSUB: {
                rc = this.addsub(programenvironment, byReference, params);
                break;
            }
            case SUBMIT: {
                rc = this.submit(programenvironment, byReference, params);
                break;
            }
            default: {
                throw new RuntimeException("Invalid JOBXMIT function");
            }
        }
        if (programenvironment instanceof Context) {
            ((Context)programenvironment).setReturnCode(rc);
        }
        return rc;
    }

    private int addrec(IProgramEnvironment programenvironment, boolean[] byReference, Object[] params) {
        int rc = 0;
        if (params.length != 2) {
            rc = 12;
            if (programenvironment instanceof Context) {
                ((Context)programenvironment).setReturnCode(rc);
            }
            throw new RuntimeException("JOBXMIT::ADDREC::Invalid number of parameters");
        }
        IDatatype iRecordVar = (IDatatype)params[1];
        if (iRecordVar.toText().startsWith("/*EOF")) {
            rc = 12;
            if (programenvironment instanceof Context) {
                ((Context)programenvironment).setReturnCode(rc);
            }
            throw new RuntimeException("JOBXMIT::ADDREC::Invalid /*EOF rec. Use ADDSUB function instead");
        }
        this.recList.add(iRecordVar.toText().replaceAll("\\r\\n|\\r|\\n", ""));
        return rc;
    }

    private int addsub(IProgramEnvironment programenvironment, boolean[] byReference, Object[] params) {
        int rc = 0;
        if (params.length != 3) {
            rc = 12;
            if (programenvironment instanceof Context) {
                ((Context)programenvironment).setReturnCode(rc);
            }
            throw new RuntimeException("JOBXMIT::ADDSUB::Invalid number of parameters");
        }
        IDatatype iRecordVar = (IDatatype)params[1];
        if (iRecordVar.toText().startsWith("/*EOF")) {
            boolean[] byRef = new boolean[]{byReference[0], byReference[2]};
            Object[] pgmParms = new Object[]{params[0], params[2]};
            rc = this.submit(programenvironment, byRef, pgmParms);
            this.recList.clear();
        } else {
            boolean[] byRef = new boolean[]{byReference[0], byReference[1]};
            Object[] pgmParms = new Object[]{params[0], params[1]};
            rc = this.addrec(programenvironment, byRef, pgmParms);
        }
        return rc;
    }

    private int submit(IProgramEnvironment programenvironment, boolean[] byReference, Object[] params) {
        int rc = 0;
        if (params.length != 2) {
            rc = 12;
            if (programenvironment instanceof Context) {
                ((Context)programenvironment).setReturnCode(rc);
            }
            throw new RuntimeException("JOBXMIT::SUBMIT::Invalid number of parameters");
        }
        if (this.recList.isEmpty()) {
            rc = 4;
            if (programenvironment instanceof Context) {
                ((Context)programenvironment).setReturnCode(rc);
            }
            System.err.println("JOBXMIT::SUBMIT::No JES input to submit");
            return rc;
        }
        IDatatype iUrlVar = (IDatatype)params[1];
        String url2 = iUrlVar.toText().trim();
        if (url2.isEmpty()) {
            url2 = "http://localhost:8080/ebp/submit";
        } else if (!url2.endsWith("/submit")) {
            url2 = url2.endsWith("/") ? url2 + "submit" : url2 + "/submit";
        }
        try {
            File tmpJobFile = File.createTempFile("jobxmit", ".tmp");
            tmpJobFile.deleteOnExit();
            BufferedWriter bw = new BufferedWriter(new FileWriter(tmpJobFile));
            for (int i = 0; i < this.recList.size(); ++i) {
                bw.write(this.recList.get(i).trim());
                if (i + 1 >= this.recList.size()) continue;
                bw.write(System.lineSeparator());
            }
            bw.close();
            JUrl jurl = new JUrl();
            String[] args = new String[]{"-F", "\"deck=@" + tmpJobFile.getAbsolutePath() + ";type=text/plain\"", url2};
            System.out.println(jurl.opt(args).exec(null));
        }
        catch (IOException e) {
            e.printStackTrace();
            rc = 16;
        }
        return rc;
    }

    private static enum Function {
        ADDREC,
        ADDSUB,
        SUBMIT;

    }
}

