/*
 * Decompiled with CFR 0.152.
 */
package com.heirloomcomputing.ecs.libcall;

import com.heirloomcomputing.ecs.exec.ICallableProgramGiving;
import com.heirloomcomputing.ecs.exec.MediaAudio;
import com.heirloomcomputing.ecs.exec.Numeric;
import com.heirloomcomputing.ecs.exec.RuntimeEnvironment;
import com.heirloomcomputing.ecs.exec.Variable;
import com.heirloomcomputing.ecs.exec.parameterList;

public class WIN {

    public static class PLAYSOUND
    implements ICallableProgramGiving {
        @Override
        public Object callGiving(parameterList param) {
            if (param != null && param.size() >= 1) {
                String soundName = param.getString(0).trim();
                if (soundName.length() == 0) {
                    soundName = null;
                }
                int soundFlags = 0;
                if (param.size() >= 2) {
                    soundFlags = param.getInt(1);
                }
                if (MediaAudio.playSound(soundName, soundFlags)) {
                    return new Numeric(1);
                }
                return new Numeric();
            }
            return new Numeric();
        }

        @Override
        public Object callGiving() {
            return this.callGiving(null);
        }

        @Override
        public void call() {
            this.call(null);
        }

        @Override
        public void call(parameterList param) {
            this.callGiving(param);
        }

        @Override
        public void cancel() {
        }

        @Override
        public String redirectCall() {
            return null;
        }
    }

    public static class VERSION
    implements ICallableProgramGiving {
        private static final byte PLATFORM_WIN_95 = 2;
        private static final byte PLATFORM_WIN_98 = 2;
        private static final byte PLATFORM_WIN_NT = 3;
        private static final byte PLATFORM_WIN_2K = 3;
        private static final byte WIN_WORDSIZE_32 = 2;

        @Override
        public Object callGiving(parameterList param) {
            byte[] result = new byte[4];
            String platform = RuntimeEnvironment.getGlobalParameter("WINVERSION");
            platform = RuntimeEnvironment.getGlobalParameter("OS.NAME") + " " + RuntimeEnvironment.getGlobalParameter("OS.VERSION");
            result[3] = 2;
            if (platform != null && (platform = platform.toUpperCase()).indexOf("WIN") >= 0) {
                if (platform.indexOf("95") >= 0) {
                    result[0] = 4;
                    result[1] = 0;
                    result[2] = 2;
                } else if (platform.indexOf("98") >= 0) {
                    result[0] = 4;
                    result[1] = 1;
                    result[2] = 2;
                } else if (platform.indexOf("NT") >= 0) {
                    result[0] = 4;
                    result[1] = 0;
                    result[2] = 3;
                } else if (platform.indexOf("2000") >= 0 || platform.indexOf("2K") >= 0) {
                    result[0] = 5;
                    result[1] = 0;
                    result[2] = 3;
                }
            }
            Variable resultVariable = new Variable(result);
            if (param != null && param.size() > 0) {
                param.set(0, resultVariable);
            }
            return resultVariable;
        }

        @Override
        public Object callGiving() {
            return this.callGiving(null);
        }

        @Override
        public void call() {
            this.call(null);
        }

        @Override
        public void call(parameterList param) {
            this.callGiving(param);
        }

        @Override
        public void cancel() {
        }

        @Override
        public String redirectCall() {
            return null;
        }
    }

    public static class PRINTER
    implements ICallableProgramGiving {
        public static final int WINPRINT_SUPPORTED = 1;
        public static final int WINPRINT_SETUP = 2;
        public static final int WINPRINT_SET_STD_FONT = 3;
        public static final int WINPRINT_GET_PAGE_LAYOUT = 4;
        public static final int WINPRINT_GET_SETTINGS_SIZE = 5;
        public static final int WINPRINT_GET_SETTINGS = 6;
        public static final int WINPRINT_SET_SETTINGS = 7;
        public static final int WINPRINT_SET_FONT = 8;
        public static final int WINPRINT_SET_LINES_PER_PAGE = 9;
        public static final int WINPRINT_GET_CAPABILITIES = 10;
        public static final int WINPRINT_PRINT_BITMAP = 11;
        public static final int WINPRINT_SET_MARGINS = 12;
        public static final int WINPRINT_GET_NO_PRINTERS = 13;
        public static final int WINPRINT_GET_PRINTER_INFO = 14;
        public static final int WINPRINT_SET_PRINTER = 15;
        public static final int WINPRINT_GET_CURRENT_INFO = 16;
        public static final int WINPRINT_SETUP_OLD = 17;
        public static final int WPRTERR_UNSUPPORTED = 0;
        public static final int WPRTERR_BAD_ARG = -1;
        public static final int WPRTERR_CANCELLED = -2;
        public static final int WPRTERR_BUFFER_TOO_SMALL = -3;
        public static final int WPRTERR_NO_MEMORY = -4;
        public static final int WPRTERR_SPOOLER_OPEN = -5;
        public static final int WPRTERR_SPOOLER_CLOSED = -6;
        public static final int WPRTERR_DEVICE_INCAPABLE = -7;
        public static final int WPRTERR_ENUM_FAIL = -8;
        public static final int WPRTERR_DRV_LOADFAIL = -9;
        public static final int WPRTERR_BAD_DRIVER = -10;
        public static final int WPRTFONT_DEFAULT = 1;
        public static final int WPRTFONT_COURIER_12 = 2;
        public static final int WPRTFONT_COURIER_12_COMP = 3;
        public static final int WPRTFONT_COURIER_10 = 4;
        public static final int WPRTFONT_COURIER_10_COMP = 5;
        public static final int WPRTBITMAP_PRINTER_BITMAP = 1;
        public static final int WPRTBITMAP_SCALE_CELLS = 2;
        public static final int WPRTBITMAP_SCALE_INCHES = 4;
        public static final int WPRTBITMAP_SCALE_CENTIMETERS = 8;
        public static final int WPRTBITMAP_SCALE_PIXELS = 16;
        public static final int WPRTMARGIN_DEFAULT_MARGINS = 0;
        public static final int WPRTMARGIN_CELLS = 1;
        public static final int WPRTMARGIN_INCHES = 2;
        public static final int WPRTMARGIN_CENTIMETERS = 3;
        public static final int WPRTMARGIN_PIXELS = 4;
        public static final int WPRTSEL_ORIENT_DEFAULT = 0;
        public static final int WPRTSEL_ORIENT_PORTRAIT = 1;
        public static final int WPRTSEL_ORIENT_LANDSCAPE = 2;
        public static final int WPRTSEL_QUALITY_DEFAULT = -1;
        public static final int WPRTSEL_QUALITY_HIGH = -2;
        public static final int WPRTSEL_QUALITY_MEDIUM = -3;
        public static final int WPRTSEL_QUALITY_DRAFT = -4;

        @Override
        public Object callGiving(parameterList param) {
            if (param.size() >= 1) {
                int opcode = param.getInt(0);
                switch (opcode) {
                    case 1: {
                        return this.supported(param);
                    }
                    case 2: {
                        return this.setup(param);
                    }
                    case 3: {
                        return this.setStdFont(param);
                    }
                    case 4: {
                        return this.getPageLayout(param);
                    }
                    case 5: {
                        return this.getSettingsSize(param);
                    }
                    case 6: {
                        return this.getSettings(param);
                    }
                    case 8: {
                        return this.setFont(param);
                    }
                    case 9: {
                        return this.setLinesPerPage(param);
                    }
                    case 10: {
                        return this.getCapabilities(param);
                    }
                    case 11: {
                        return this.printBitmap(param);
                    }
                    case 12: {
                        return this.setMargins(param);
                    }
                    case 13: {
                        return this.getNoPrinters(param);
                    }
                    case 14: {
                        return this.getPrinterInfo(param);
                    }
                    case 15: {
                        return this.setPrinter(param);
                    }
                    case 16: {
                        return this.getCurrentInfo(param);
                    }
                    case 17: {
                        return this.setupOld(param);
                    }
                }
            }
            return new Numeric();
        }

        private Object supported(parameterList param) {
            return new Numeric();
        }

        private Object setup(parameterList param) {
            return new Numeric();
        }

        private Object setStdFont(parameterList param) {
            return new Numeric();
        }

        private Object getPageLayout(parameterList param) {
            return new Numeric();
        }

        private Object getSettingsSize(parameterList param) {
            return new Numeric();
        }

        private Object getSettings(parameterList param) {
            return new Numeric();
        }

        private Object setFont(parameterList param) {
            return new Numeric();
        }

        private Object setLinesPerPage(parameterList param) {
            return new Numeric();
        }

        private Object getCapabilities(parameterList param) {
            return new Numeric();
        }

        private Object printBitmap(parameterList param) {
            return new Numeric();
        }

        private Object setMargins(parameterList param) {
            return new Numeric();
        }

        private Object getNoPrinters(parameterList param) {
            return new Numeric();
        }

        private Object getPrinterInfo(parameterList param) {
            return new Numeric();
        }

        private Object setPrinter(parameterList param) {
            return new Numeric();
        }

        private Object getCurrentInfo(parameterList param) {
            return new Numeric();
        }

        private Object setupOld(parameterList param) {
            return new Numeric();
        }

        @Override
        public Object callGiving() {
            return this.callGiving(null);
        }

        @Override
        public void call() {
            this.call(null);
        }

        @Override
        public void call(parameterList param) {
            this.callGiving(param);
        }

        @Override
        public void cancel() {
        }

        @Override
        public String redirectCall() {
            return null;
        }
    }
}

