/*
 * Decompiled with CFR 0.152.
 */
package com.heirloomcomputing.ecs.mqi.jms.module;

import com.heirloomcomputing.ecs.mqi.api.MQIConnectOptions;
import com.heirloomcomputing.ecs.mqi.api.MQIGetMessageOptions;
import com.heirloomcomputing.ecs.mqi.api.MQIMessageDescriptor;
import com.heirloomcomputing.ecs.mqi.api.MQIObjectDescriptor;
import com.heirloomcomputing.ecs.mqi.api.MQIPutMessageOptions;
import com.heirloomcomputing.ecs.mqi.api.MQIResponse;
import com.heirloomcomputing.ecs.mqi.jms.module.StandardJMSModule;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Session;
import javax.naming.NamingException;

public abstract class AbstractJMSModule {
    private static Properties configProperties = null;
    private static final List<String> listOfCharsets = Arrays.asList("cp037", "cp437", "cp500", "iso-8859-1", "Unicode", "UTF8", "cp273", "cp277", "cp278", "cp280", "cp284", "cp285", "cp297", "cp420", "cp424", "cp737", "cp775", "iso-8859-7", "cp838", "cp850", "cp852", "cp855", "cp856", "cp857", "cp860", "cp861", "cp862", "cp863", "cp864", "cp865", "cp866", "cp868", "cp869", "cp870", "cp871", "cp874", "cp875", "iso-8859-2", "iso-8859-3", "iso-8859-4", "iso-8859-5", "iso-8859-8", "cp918", "iso-8859-9", "cp921", "cp922", "cp930", "ms932", "cp933", "cp935", "cp937", "cp939", "cp942", "cp948", "cp949", "Big5", "eucjis", "cp964", "cp970", "cp1006", "cp1025", "cp1026", "iso-8859-6", "cp1097", "cp1098", "cp1112", "cp1122", "cp1123", "cp1124", "cp1140", "cp1141", "cp1142", "cp1143", "cp1144", "cp1145", "cp1146", "cp1147", "cp1148", "cp1149", "cp1250", "cp1251", "cp1252", "cp1253", "cp1254", "cp1255", "cp1256", "cp1257", "cp1258", "cp1381", "cp1383", "JIS", "ksc-5601", "Unicode", "Unicode", "cp33722");
    private static final List<String> listOfCcids = Arrays.asList("37", "437", "500", "819", "1200", "1208", "273", "277", "278", "280", "284", "285", "297", "420", "424", "737", "775", "813", "838", "850", "852", "855", "856", "857", "860", "861", "862", "863", "864", "865", "866", "868", "869", "870", "871", "874", "875", "912", "913", "914", "915", "916", "918", "920", "921", "922", "930", "932", "933", "935", "937", "939", "942", "948", "949", "950", "954", "964", "970", "1006", "1025", "1026", "1089", "1097", "1098", "1112", "1122", "1123", "1124", "1140", "1141", "1142", "1143", "1144", "1145", "1146", "1147", "1148", "1149", "1250", "1251", "1252", "1253", "1254", "1255", "1256", "1257", "1258", "1381", "1383", "2022", "5601", "13488", "17584", "33722");
    private String d = null;
    private boolean loggingEnabled = false;

    private static boolean d() {
        block4: {
            configProperties = new Properties();
            try {
                ResourceBundle resourcebundle = ResourceBundle.getBundle("mqi2jms");
                if (resourcebundle != null) {
                    Enumeration<String> enumeration = resourcebundle.getKeys();
                    while (enumeration.hasMoreElements()) {
                        String s = enumeration.nextElement().toString();
                        String s1 = resourcebundle.getString(s);
                        configProperties.put(s, s1);
                    }
                    break block4;
                }
                return false;
            }
            catch (MissingResourceException missingresourceexception) {
                return false;
            }
        }
        return true;
    }

    protected static Properties getConfigProperties() {
        return configProperties;
    }

    protected static String getPropValue(String s) {
        if (configProperties == null) {
            AbstractJMSModule.d();
        }
        String s1 = (String)configProperties.get(s);
        return s1;
    }

    protected static boolean getPropValueBoolean(String s) {
        String s1 = AbstractJMSModule.getPropValue(s);
        if (s1 == null || s1.length() == 0) {
            return false;
        }
        s1 = s1.trim();
        int i = s1.length();
        switch (i) {
            case 1: {
                char c1 = Character.toUpperCase(s1.charAt(0));
                return c1 == 'Y' || c1 == 'T';
            }
            case 2: {
                return !"no".equalsIgnoreCase(s1);
            }
            case 3: {
                return "yes".equalsIgnoreCase(s1);
            }
            case 4: {
                return "true".equalsIgnoreCase(s1);
            }
            case 5: {
                return !"false".equalsIgnoreCase(s1);
            }
        }
        return false;
    }

    protected String a(String s) {
        if (s == null || s.length() != 48) {
            return null;
        }
        StringBuffer stringbuffer = new StringBuffer();
        s = s.toUpperCase();
        int i = 0;
        for (int j = 0; j < 24; ++j) {
            int k = "0123456789ABCDEF".indexOf(s.charAt(i++)) << 4;
            int l = "0123456789ABCDEF".indexOf(s.charAt(i++));
            char c1 = (char)(k | l);
            stringbuffer.append(c1);
        }
        return stringbuffer.toString();
    }

    protected String b(String s) {
        if (s == null || s.length() != 24) {
            return null;
        }
        StringBuffer stringbuffer = new StringBuffer();
        for (int i = 0; i < 24; ++i) {
            int j = s.charAt(i) & 0xFF;
            char c1 = "0123456789ABCDEF".charAt(j >> 4);
            char c2 = "0123456789ABCDEF".charAt(j & 0xF);
            stringbuffer.append(c1).append(c2);
        }
        return stringbuffer.toString();
    }

    protected String c(String s) {
        try {
            return new String(s.getBytes(), "UTF8");
        }
        catch (UnsupportedEncodingException unsupportedencodingexception) {
            return s;
        }
    }

    public String a() {
        if (this.d != null) {
            return this.d;
        }
        this.d = this.getClass().getName();
        if (this.d.endsWith(".class")) {
            this.d = this.d.substring(0, this.d.length() - 6);
        }
        this.d = this.d.substring(this.d.lastIndexOf(46) + 1);
        return this.d;
    }

    public String a(int i) {
        int j = listOfCcids.indexOf("" + i);
        if (j >= 0) {
            return listOfCharsets.get(j);
        }
        return null;
    }

    public int d(String s) {
        if (s == null) {
            return 0;
        }
        int i = listOfCharsets.indexOf(s = s.replace('_', '-').trim());
        if (i >= 0) {
            return Integer.parseInt(listOfCcids.get(i));
        }
        return 0;
    }

    public boolean isLoggingEnabled() {
        return this.loggingEnabled;
    }

    protected void setLoggingEnabled(boolean flag) {
        this.loggingEnabled = flag;
    }

    public void log(String s) {
        System.out.println(this.a() + ": " + s);
    }

    public void logException(Throwable throwable) {
        if (throwable instanceof JMSException) {
            JMSException jmsexception = (JMSException)throwable;
            System.err.println(this.a() + ": (Error code=" + jmsexception.getErrorCode() + ")");
            jmsexception.printStackTrace(System.err);
            Exception exception = jmsexception.getLinkedException();
            if (exception != null) {
                this.log("Linked Exception =");
                exception.printStackTrace(System.err);
            }
        } else {
            System.err.println(this.a() + ": ");
            throwable.printStackTrace(System.err);
        }
    }

    public static void setConfigProperties(Properties properties) {
        configProperties = properties;
    }

    public static AbstractJMSModule f() {
        return AbstractJMSModule.hInstantiate(null);
    }

    public static AbstractJMSModule hInstantiate(String s) {
        boolean traceFlag = false;
        String moduleClassName = null;
        if (s != null && (moduleClassName = AbstractJMSModule.getPropValue("com.heirloomcomputing.ecs.mqi.jms.JMSModule." + s)) != null) {
            traceFlag = AbstractJMSModule.getPropValueBoolean("com.heirloomcomputing.ecs.mqi.jms.JMSModule.trace." + s);
        }
        if (moduleClassName == null && (moduleClassName = AbstractJMSModule.getPropValue("com.heirloomcomputing.ecs.mqi.jms.JMSModule")) != null) {
            traceFlag = AbstractJMSModule.getPropValueBoolean("com.heirloomcomputing.ecs.mqi.jms.JMSModule.trace");
        }
        if (moduleClassName == null) {
            moduleClassName = "com.heirloomcomputing.ecs.mqi.jms.module.StandardJMSModule";
        }
        traceFlag = AbstractJMSModule.getPropValueBoolean("com.heirloomcomputing.ecs.mqi.jms.JMSModule.trace");
        try {
            Class<?> class1 = Class.forName(moduleClassName);
            if (class1 != null) {
                AbstractJMSModule ah1 = (AbstractJMSModule)class1.newInstance();
                ah1.setLoggingEnabled(traceFlag);
                if (ah1.isLoggingEnabled()) {
                    ah1.log("Registering JMS Implementation: " + moduleClassName);
                    ah1.log("Configuration properties:");
                    ah1.log("" + AbstractJMSModule.getConfigProperties());
                }
                return ah1;
            }
        }
        catch (Exception exception) {
            StandardJMSModule standardjmsmodule = new StandardJMSModule();
            standardjmsmodule.setLoggingEnabled(traceFlag);
            if (standardjmsmodule.isLoggingEnabled()) {
                standardjmsmodule.log("An exception occurred attempting to instantiate class '" + moduleClassName + "':");
                standardjmsmodule.log("" + exception);
                standardjmsmodule.log("");
                standardjmsmodule.log("Registering default JMS Implementation: com.heirloomcomputing.ecs.mqi.jms.module.StandardJMSModule");
                standardjmsmodule.log("Configuration properties:");
                standardjmsmodule.log("" + AbstractJMSModule.getConfigProperties());
            }
            return standardjmsmodule;
        }
        return null;
    }

    public abstract Connection obtainConnection(String var1, MQIConnectOptions var2) throws NamingException, JMSException;

    public abstract Destination obtainDestination(Session var1, MQIObjectDescriptor var2) throws NamingException, JMSException;

    public abstract void specifyMqgetCharset(Destination var1, MQIMessageDescriptor var2, MQIGetMessageOptions var3) throws JMSException;

    public abstract void specifyMqputCharset(Destination var1, MQIMessageDescriptor var2, MQIPutMessageOptions var3) throws JMSException;

    public abstract void populateMessageDescriptor(MQIGetMessageOptions var1, Message var2, MQIMessageDescriptor var3) throws JMSException;

    public abstract void populateMessageOptionsBeforePut(Session var1, MQIPutMessageOptions var2, MQIMessageDescriptor var3, Message var4) throws JMSException;

    public abstract void populateMessageOptionsAfterPut(MQIPutMessageOptions var1, Message var2, MQIMessageDescriptor var3) throws JMSException;

    public abstract void convertNamingExceptionToResponseCodes(MQIResponse var1, NamingException var2);

    public abstract void convertJMSExceptionToResponseCodes(MQIResponse var1, JMSException var2);

    public abstract void closeNamingContext();
}

