/*
 * Decompiled with CFR 0.152.
 */
package com.heirloomcomputing.ecs.mqi.jms.module;

import com.heirloomcomputing.ecs.mqi.api.MQIChannelDefinition;
import com.heirloomcomputing.ecs.mqi.api.MQIConnectOptions;
import com.heirloomcomputing.ecs.mqi.api.MQIGetMessageOptions;
import com.heirloomcomputing.ecs.mqi.api.MQIMessageDescriptor;
import com.heirloomcomputing.ecs.mqi.api.MQIObjectDescriptor;
import com.heirloomcomputing.ecs.mqi.api.MQIPutMessageOptions;
import com.heirloomcomputing.ecs.mqi.api.MQIResponse;
import com.heirloomcomputing.ecs.mqi.jms.module.StandardJMSModule;
import com.ibm.mq.MQException;
import com.ibm.mq.jms.MQConnectionFactory;
import com.ibm.mq.jms.MQDestination;
import com.ibm.mq.jms.MQQueue;
import com.ibm.mq.jms.MQQueueConnectionFactory;
import com.ibm.mq.jms.MQTopic;
import java.util.Enumeration;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.QueueSession;
import javax.jms.Session;
import javax.jms.TemporaryQueue;
import javax.jms.TemporaryTopic;
import javax.jms.TopicSession;
import javax.naming.NamingException;

public class WebSphereMQJMSModule
extends StandardJMSModule {
    @Override
    public Connection obtainConnection(String s1, MQIConnectOptions u1) throws NamingException, JMSException {
        MQIChannelDefinition v1;
        ConnectionFactory connectionfactory = this.fInitConnectionFactory(s1);
        if (connectionfactory == null) {
            return null;
        }
        if (!(connectionfactory instanceof MQConnectionFactory)) {
            if (this.isLoggingEnabled()) {
                this.log("Problem encountered:  Connection factory is not an instance of MQConnectionFactory");
            }
            return null;
        }
        MQConnectionFactory mqconnectionfactory = (MQConnectionFactory)connectionfactory;
        if (u1 != null && (v1 = u1.getChannelDefinition()) != null) {
            String s7;
            String s6;
            String s4;
            int i;
            block24: {
                String s2;
                if (this.isLoggingEnabled()) {
                    this.log("Channel data exists");
                }
                if ((s2 = v1.getChannelName()) != null && (s2 = s2.trim()).length() > 0) {
                    try {
                        if (this.isLoggingEnabled()) {
                            this.log("Channel name is '" + s2 + "', calling MQConnectionFactory.setChannel with this name...");
                        }
                        mqconnectionfactory.setChannel(s2);
                    }
                    catch (IllegalStateException illegalstateexception) {
                        if (!this.isLoggingEnabled()) break block24;
                        this.log("Exception occurred (This can happen with websphere event broker): e=" + (Object)((Object)illegalstateexception));
                    }
                }
            }
            if ((i = v1.getChannelType()) == 6) {
                if (this.isLoggingEnabled()) {
                    this.log("Channel is a client connection, setting transport type on MQConnectionFactory to MQJMS_TP_CLIENT_MQ_TCPIP");
                }
                mqconnectionfactory.setTransportType(1);
                String s3 = v1.getQueueManagerName();
                if (s3 != null && (s3 = s3.trim()).length() > 0) {
                    if (this.isLoggingEnabled()) {
                        this.log("Channel is a client connection, setting channel queue manager name on MQConnectionFactory to '" + s3 + "'");
                    }
                    mqconnectionfactory.setQueueManager(s3);
                }
            }
            if ((s4 = v1.getChannelDescription()) != null && (s4 = s4.trim()).length() > 0) {
                try {
                    if (this.isLoggingEnabled()) {
                        this.log("Setting MQConnectionFactory description to channel description: '" + s4 + "'");
                    }
                    mqconnectionfactory.setDescription(s4);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (this.isLoggingEnabled()) {
                this.log("Setting MQConnectionFactory's msg batch size to channel batch size of " + v1.getBatchSize());
            }
            mqconnectionfactory.setMsgBatchSize(v1.getBatchSize());
            String s5 = v1.getSendExit();
            if (s5 != null && (s5 = s5.trim()).length() > 0) {
                if (this.isLoggingEnabled()) {
                    this.log("Setting sendExitName to '" + s5 + "'");
                }
                mqconnectionfactory.setSendExit(s5);
            }
            if ((s6 = v1.getReceiveExit()) != null && (s6 = s6.trim()).length() > 0) {
                if (this.isLoggingEnabled()) {
                    this.log("Setting receiveExitName to '" + s6 + "'");
                }
                mqconnectionfactory.setReceiveExit(s6);
            }
            if ((s7 = v1.getSecurityExit()) != null && (s7 = s7.trim()).length() > 0) {
                if (this.isLoggingEnabled()) {
                    this.log("Setting securityExitName to '" + s7 + "'");
                }
                mqconnectionfactory.setSecurityExit(s7);
            }
        }
        return super.obtainConnection(s1, u1);
    }

    @Override
    public Destination obtainDestination(Session session, MQIObjectDescriptor MQIObjectDescriptor2) throws NamingException, JMSException {
        Destination destination = super.obtainDestination(session, MQIObjectDescriptor2);
        if (!(destination instanceof MQDestination)) {
            if (this.isLoggingEnabled()) {
                this.log("Problem encountered:  The destination is not an instance of MQDestination, destination=" + (destination == null ? "null" : destination.getClass().getName()));
            }
            return null;
        }
        return destination;
    }

    @Override
    public void specifyMqgetCharset(Destination destination, MQIMessageDescriptor w1, MQIGetMessageOptions x1) throws JMSException {
        super.specifyMqgetCharset(destination, w1, x1);
        if (destination instanceof MQDestination) {
            MQDestination mqdestination = (MQDestination)destination;
            int i = x1.getOptions();
            if ((i & 0x4000) == 16384) {
                if (this.isLoggingEnabled()) {
                    this.log("MQGMO_CONVERT option specified, attempting to set MQDestination's CCSID and Encoding to match message descriptor");
                }
                mqdestination.setCCSID(w1.getCharacterSet());
                if (this.isLoggingEnabled()) {
                    this.log("Set MQDestination's CCSID to message descriptor CCSID: " + w1.getCharacterSet());
                }
                mqdestination.setEncoding(w1.getEncoding());
                if (this.isLoggingEnabled()) {
                    this.log("Set MQDestination's encoding to message descriptor encoding: " + w1.getEncoding());
                }
            } else if (this.isLoggingEnabled()) {
                this.log("MQGMO_CONVERT option not specified, Destination's CCSID=" + mqdestination.getCCSID() + ", encoding=" + mqdestination.getEncoding());
            }
        }
    }

    @Override
    public void specifyMqputCharset(Destination destination, MQIMessageDescriptor w1, MQIPutMessageOptions ad1) throws JMSException {
        super.specifyMqputCharset(destination, w1, ad1);
        if (destination instanceof MQDestination) {
            int i;
            MQDestination mqdestination = (MQDestination)destination;
            if (this.isLoggingEnabled()) {
                this.log("Attempting to set MQDestination's CCSID and Encoding to match message descriptor");
            }
            if ((i = w1.getCharacterSet()) > 0) {
                mqdestination.setCCSID(i);
                if (this.isLoggingEnabled()) {
                    this.log("Set MQDestination's CCSID to message descriptor CCSID: " + w1.getCharacterSet());
                }
            }
            mqdestination.setEncoding(w1.getEncoding());
            if (this.isLoggingEnabled()) {
                this.log("Set MQDestination's encoding to message descriptor encoding: " + w1.getEncoding());
            }
        }
    }

    private int a(Message message, String s1) throws JMSException {
        try {
            return message.getIntProperty(s1);
        }
        catch (NumberFormatException numberformatexception) {
            return 0;
        }
    }

    @Override
    public void populateMessageDescriptor(MQIGetMessageOptions x1, Message message, MQIMessageDescriptor w1) throws JMSException {
        boolean flag;
        String s9;
        String s8;
        String s6;
        block44: {
            String s5;
            block43: {
                super.populateMessageDescriptor(x1, message, w1);
                if (this.isLoggingEnabled()) {
                    this.log("--- Setting message descriptor using message properties specific to WebSphere MQ JMS:");
                    Enumeration enumeration = message.getPropertyNames();
                    if (enumeration != null) {
                        this.log("");
                        this.log("List of available property names:");
                        while (enumeration.hasMoreElements()) {
                            this.log((String)enumeration.nextElement());
                        }
                        this.log("");
                    }
                }
                int i = 0;
                i |= this.a(message, "JMS_IBM_Report_Exception");
                i |= this.a(message, "JMS_IBM_Report_Expiration");
                i |= this.a(message, "JMS_IBM_Report_COA");
                i |= this.a(message, "JMS_IBM_Report_COD");
                i |= this.a(message, "JMS_IBM_Report_PAN");
                i |= this.a(message, "JMS_IBM_Report_NAN");
                i |= this.a(message, "JMS_IBM_Report_Pass_Msg_ID");
                i |= this.a(message, "JMS_IBM_Report_Pass_Correl_ID");
                i |= this.a(message, "JMS_IBM_Report_Discard_Msg");
                if (this.isLoggingEnabled()) {
                    this.log("Setting message descriptor's report options property to (displayed in hex): " + Integer.toHexString(i));
                }
                w1.setReport(i);
                String s1 = message.getStringProperty("JMS_IBM_MsgType");
                if (s1 != null) {
                    try {
                        if (this.isLoggingEnabled()) {
                            this.log("Setting message descriptor's message type property to '" + s1 + "'");
                        }
                        w1.setMessageType(Integer.parseInt(s1));
                    }
                    catch (NumberFormatException numberformatexception) {
                        if (this.isLoggingEnabled()) {
                            this.log("Number format exception setting message descriptor's message type property, e=");
                            this.logException(numberformatexception);
                        }
                    }
                } else if (message.getJMSReplyTo() instanceof MQQueue) {
                    if (this.isLoggingEnabled()) {
                        this.log("Setting message descriptor's message type property to MQMT_REQUEST");
                    }
                    w1.setMessageType(1);
                } else {
                    if (this.isLoggingEnabled()) {
                        this.log("Setting message descriptor's message type property to MQMT_DATAGRAM");
                    }
                    w1.setMessageType(8);
                }
                String s2 = message.getStringProperty("JMS_IBM_Feedback");
                if (s2 != null) {
                    try {
                        if (this.isLoggingEnabled()) {
                            this.log("Setting message descriptor's feedback property to '" + s2 + "'");
                        }
                        w1.setFeedback(Integer.parseInt(s2));
                    }
                    catch (NumberFormatException numberformatexception1) {
                        if (this.isLoggingEnabled()) {
                            this.log("Number format exception setting message descriptor's feedback property, e=");
                            this.logException(numberformatexception1);
                        }
                    }
                } else {
                    w1.setFeedback(0);
                }
                String s3 = message.getStringProperty("JMS_IBM_Format");
                if (s3 != null) {
                    if (this.isLoggingEnabled()) {
                        this.log("Setting message descriptor's format property to '" + s3 + "'");
                    }
                    w1.setFormat(s3);
                } else {
                    w1.setFormat("        ");
                }
                String s4 = message.getStringProperty("JMS_IBM_Encoding");
                if (s4 != null) {
                    try {
                        if (this.isLoggingEnabled()) {
                            this.log("Setting message descriptor's encoding to '" + s4 + "'");
                        }
                        w1.setEncoding(Integer.parseInt(s4));
                    }
                    catch (NumberFormatException numberformatexception2) {
                        if (!this.isLoggingEnabled()) break block43;
                        this.log("Number format exception setting message descriptor's encoding property, e=");
                        this.logException(numberformatexception2);
                    }
                }
            }
            if ((s5 = message.getStringProperty("JMS_IBM_Character_Set")) != null) {
                try {
                    if (this.isLoggingEnabled()) {
                        this.log("Setting message descriptor's CCSID to '" + s5 + "'");
                    }
                    w1.setCharacterSet(this.d(s5));
                }
                catch (NumberFormatException numberformatexception3) {
                    if (!this.isLoggingEnabled()) break block44;
                    this.log("Number format exception setting message descriptor's CCSID property, e=");
                    this.logException(numberformatexception3);
                }
            }
        }
        if ((s6 = message.getStringProperty("JMS_IBM_PutApplType")) != null) {
            try {
                if (this.isLoggingEnabled()) {
                    this.log("Setting message descriptor's 'put application type' to '" + s6 + "'");
                }
                w1.setPutApplicationType(Integer.parseInt(s6));
            }
            catch (NumberFormatException numberformatexception4) {
                if (this.isLoggingEnabled()) {
                    this.log("Number format exception setting message descriptor's 'put application type' property, e=");
                    this.logException(numberformatexception4);
                }
            }
        } else {
            w1.setPutApplicationType(0);
        }
        String s7 = message.getStringProperty("JMS_IBM_PutDate");
        if (s7 != null) {
            if (this.isLoggingEnabled()) {
                this.log("Setting message descriptor's 'put date' to: '" + s7 + "'");
            }
            w1.setPutDate(s7);
        }
        if ((s8 = message.getStringProperty("JMS_IBM_PutTime")) != null) {
            if (this.isLoggingEnabled()) {
                this.log("Setting message descriptor's 'put time' to: '" + s8 + "'");
            }
            w1.etPutTime(s8);
        }
        if ((s9 = message.getStringProperty("JMS_IBM_Last_Msg_In_Group")) != null && (flag = Boolean.valueOf(s9).booleanValue())) {
            if (this.isLoggingEnabled()) {
                this.log("Updating message flags to include MQMF_LAST_MSG_IN_GROUP");
            }
            int j = w1.getMessageFlags();
            w1.setMessageFlags(j |= 0x10);
        }
    }

    @Override
    public void populateMessageOptionsBeforePut(Session session, MQIPutMessageOptions ad1, MQIMessageDescriptor w1, Message message) throws JMSException {
        int i2;
        boolean flag1;
        boolean flag;
        String s1;
        int i;
        super.populateMessageOptionsBeforePut(session, ad1, w1, message);
        if (this.isLoggingEnabled()) {
            this.log("--- Setting message properties specific to WebSphere MQ JMS using message descriptor:");
            Enumeration enumeration = message.getPropertyNames();
            if (enumeration != null) {
                this.log("");
                this.log("List of available property names:");
                while (enumeration.hasMoreElements()) {
                    this.log((String)enumeration.nextElement());
                }
                this.log("");
            }
        }
        if ((i = w1.getReport()) != 0) {
            if (this.isLoggingEnabled()) {
                this.log("Setting message's report options property to (displayed in hex): " + Integer.toHexString(i));
            }
            int j = 0x7000000;
            message.setIntProperty("JMS_IBM_Report_Exception", i & j);
            int l = 0xE00000;
            message.setIntProperty("JMS_IBM_Report_Expiration", i & l);
            int c = 1792;
            message.setIntProperty("JMS_IBM_Report_COA", i & c);
            int c1 = 14336;
            message.setIntProperty("JMS_IBM_Report_COD", i & c1);
            message.setIntProperty("JMS_IBM_Report_PAN", i & 1);
            message.setIntProperty("JMS_IBM_Report_NAN", i & 2);
            message.setIntProperty("JMS_IBM_Report_Pass_Msg_ID", i & 0x80);
            message.setIntProperty("JMS_IBM_Report_Pass_Correl_ID", i & 0x40);
            message.setIntProperty("JMS_IBM_Report_Discard_Msg", i & 0x8000000);
        }
        int k = w1.getMessageType();
        if (this.isLoggingEnabled()) {
            this.log("Setting message's message type property to: " + k);
        }
        message.setIntProperty("JMS_IBM_MsgType", k);
        int i1 = w1.getFeedback();
        if (i1 != 0) {
            if (this.isLoggingEnabled()) {
                this.log("Setting message's feedback property to: " + i1);
            }
            message.setIntProperty("JMS_IBM_Feedback", i1);
        }
        if ((s1 = w1.getFormat()) != null && !"        ".equals(s1)) {
            if (this.isLoggingEnabled()) {
                this.log("Setting message's format property to: '" + s1 + "'");
            }
            message.setStringProperty("JMS_IBM_Format", s1);
        }
        int j1 = w1.getEncoding();
        if (this.isLoggingEnabled()) {
            this.log("Setting message's encoding property to: " + j1);
        }
        message.setIntProperty("JMS_IBM_Encoding", j1);
        int k1 = w1.getCharacterSet();
        if (k1 > 0) {
            if (this.isLoggingEnabled()) {
                this.log("Setting message's ccsid property to: " + k1);
            }
            message.setStringProperty("JMS_IBM_Character_Set", this.a(k1));
        }
        boolean bl = flag = (ad1.getOptions() & 0x800) == 2048;
        if (flag) {
            int l1 = w1.getPutApplicationType();
            if (l1 != 0) {
                if (this.isLoggingEnabled()) {
                    this.log("Setting message's 'put application type' property to: " + l1);
                }
                message.setIntProperty("JMS_IBM_PutApplType", l1);
            }
            String s2 = w1.getPutDate();
            if (this.isLoggingEnabled()) {
                this.log("Setting message's 'put date' property to: '" + s2 + "'");
            }
            message.setStringProperty("JMS_IBM_PutDate", s2);
            String s3 = w1.getPutTime();
            if (this.isLoggingEnabled()) {
                this.log("Setting message's 'put time' property to: '" + s3 + "'");
            }
            message.setStringProperty("JMS_IBM_PutTime", s3);
        }
        boolean bl2 = flag1 = ((i2 = w1.getMessageFlags()) & 0x10) == 16;
        if (flag1) {
            if (this.isLoggingEnabled()) {
                this.log("Setting message's last in group flag to true");
            }
            message.setBooleanProperty("JMS_IBM_Last_Msg_In_Group", true);
        }
    }

    @Override
    public void populateMessageOptionsAfterPut(MQIPutMessageOptions ad1, Message message, MQIMessageDescriptor w1) throws JMSException {
        String s3;
        super.populateMessageOptionsAfterPut(ad1, message, w1);
        String s1 = message.getStringProperty("JMS_IBM_PutApplType");
        if (s1 != null) {
            try {
                if (this.isLoggingEnabled()) {
                    this.log("Setting message descriptor's 'put application type' property to '" + s1 + "'");
                }
                w1.setPutApplicationType(Integer.parseInt(s1));
            }
            catch (NumberFormatException numberformatexception) {
                if (this.isLoggingEnabled()) {
                    this.log("Number format exception setting message descriptor's 'put application type' property, e=");
                    this.logException(numberformatexception);
                }
            }
        } else {
            w1.setPutApplicationType(0);
        }
        String s2 = message.getStringProperty("JMS_IBM_PutDate");
        if (s2 != null) {
            if (this.isLoggingEnabled()) {
                this.log("Setting message descriptor's 'put date' property to: '" + s2 + "'");
            }
            w1.setPutDate(s2);
        }
        if ((s3 = message.getStringProperty("JMS_IBM_PutTime")) != null) {
            if (this.isLoggingEnabled()) {
                this.log("Setting message descriptor's 'put time' property to: '" + s3 + "'");
            }
            w1.etPutTime(s3);
        }
    }

    @Override
    public void convertJMSExceptionToResponseCodes(MQIResponse s1, JMSException jmsexception) {
        super.convertJMSExceptionToResponseCodes(s1, jmsexception);
        Exception exception = jmsexception.getLinkedException();
        if (exception instanceof MQException) {
            MQException mqexception = (MQException)exception;
            s1.assign(mqexception.completionCode, mqexception.reasonCode);
        }
    }

    @Override
    protected Destination lookupDestinationVendorSpecific(Session session, String queueManagerName, String queueName) {
        block12: {
            try {
                ConnectionFactory connectionfactory = this.fInitConnectionFactory(queueManagerName);
                if (connectionfactory instanceof MQQueueConnectionFactory) {
                    TopicSession topicsession;
                    TemporaryTopic temporarytopic;
                    MQQueueConnectionFactory mqqueueconnectionfactory = (MQQueueConnectionFactory)connectionfactory;
                    mqqueueconnectionfactory.setTemporaryModel(queueName);
                    if (session instanceof QueueSession) {
                        QueueSession queuesession = (QueueSession)session;
                        TemporaryQueue temporaryqueue = queuesession.createTemporaryQueue();
                        if (temporaryqueue != null) {
                            if (this.isLoggingEnabled()) {
                                this.log("Created temporary queue for model queue '" + queueName + "', queueManagerName='" + queueManagerName + "'");
                            }
                            return temporaryqueue;
                        }
                    } else if (session instanceof TopicSession && (temporarytopic = (topicsession = (TopicSession)session).createTemporaryTopic()) != null) {
                        if (this.isLoggingEnabled()) {
                            this.log("Created temporary topic for model queue '" + queueName + "', queueManagerName='" + queueManagerName + "'");
                        }
                        return temporarytopic;
                    }
                }
            }
            catch (JMSException jmsexception) {
                if (this.isLoggingEnabled()) {
                    this.log("Exception occurred attempting to check if queue '" + queueName + "' is a model queue");
                    this.log("(this is usually okay if the queue is not a model queue), e=");
                    this.logException(jmsexception);
                }
            }
            catch (NamingException namingexception) {
                if (!this.isLoggingEnabled()) break block12;
                this.log("Exception occurred attempting to check if queue '" + queueName + "' is a model queue");
                this.log("(this is usually okay if the queue is not a model queue), e=");
                this.logException(namingexception);
            }
        }
        if (this.isLoggingEnabled()) {
            this.log("Could not create temporary destination (queue '" + queueName + "' is not a model queue?)");
        }
        return null;
    }

    @Override
    protected String a(Destination destination, String s1) throws JMSException {
        if (destination instanceof MQQueue) {
            return ((MQQueue)destination).getBaseQueueName();
        }
        if (destination instanceof MQTopic) {
            return ((MQTopic)destination).getBaseTopicName();
        }
        return s1;
    }

    @Override
    protected String b(Destination destination, String s1) throws JMSException {
        if (destination instanceof MQQueue) {
            return ((MQQueue)destination).getBaseQueueManagerName();
        }
        return s1;
    }

    @Override
    protected String a(ConnectionFactory connectionfactory) {
        if (!(connectionfactory instanceof MQConnectionFactory)) {
            return null;
        }
        return ((MQConnectionFactory)connectionfactory).getQueueManager();
    }
}

