/*
 * Decompiled with CFR 0.152.
 */
package com.heirloomcomputing.ecs.print;

import com.heirloomcomputing.ecs.api.IGenericPrinter;
import com.heirloomcomputing.ecs.exec.ColorProvider;
import com.heirloomcomputing.ecs.exec.ConvertData;
import com.heirloomcomputing.ecs.exec.MediaImage;
import com.heirloomcomputing.ecs.exec.Semaphore;
import com.heirloomcomputing.ecs.exec.Shutdown;
import com.heirloomcomputing.ecs.exec.ThreadQueue;
import com.heirloomcomputing.ecs.util.Utils;
import java.awt.BasicStroke;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public class JVM12Driver
implements IGenericPrinter,
Printable {
    private static float DASH_LENGTH = 4.0f;
    private static float DOT_LENGTH = 1.0f;
    private static float SPACE_LENGTH = 1.0f;
    public static float[] DASH_LINE = new float[]{DASH_LENGTH, SPACE_LENGTH};
    public static float[] DOT_LINE = new float[]{DOT_LENGTH, SPACE_LENGTH};
    public static float[] DASH_DOT_LINE = new float[]{DASH_LENGTH, SPACE_LENGTH, DOT_LENGTH, SPACE_LENGTH};
    public static float[] DASH_DOT_DOT_LINE = new float[]{DASH_LENGTH, SPACE_LENGTH, DOT_LENGTH, SPACE_LENGTH, DASH_LENGTH, SPACE_LENGTH};
    private static Hashtable<String, String> attributes = new Hashtable();
    public double multiplierXInches = 1.0;
    public double multiplierXMetric = 1.0;
    public double multiplierXCharacters = 1.0;
    public double multiplierXDeviceUnits = 0.12;
    public double multiplierYInches = 1.0;
    public double multiplierYMetric = 1.0;
    public double multiplierYCharacters = 1.0;
    public double multiplierYDeviceUnits = 0.12;
    public static int BASIC_LEFT_MARGIN = 12;
    public static int BASIC_TOP_MARGIN = 12;
    public static int BASIC_BOTTOM_MARGIN = 12;
    private int leftMargin = BASIC_LEFT_MARGIN;
    private int topMargin = BASIC_TOP_MARGIN;
    private int nextTopMargin = BASIC_TOP_MARGIN;
    private int bottomMargin = BASIC_BOTTOM_MARGIN;
    private double xpos = BASIC_LEFT_MARGIN;
    private double ypos = BASIC_TOP_MARGIN;
    private double lineFromX = BASIC_LEFT_MARGIN;
    private double lineFromY = BASIC_TOP_MARGIN;
    private boolean fontUnderline;
    private boolean fontStrikeOut;
    private boolean fontDoubleStrike;
    private PrinterJob job;
    private PageFormat pageFormat;
    private int printerFontHeight;
    private int printerFontWidth;
    private double printerFontMetricHeight;
    private int printerPageLength = 66;
    private int cols = 80;
    private int rows = -1;
    private int translatex;
    private int translatey;
    private int alignx;
    private int aligny;
    private String jobName = null;
    private String userName = null;
    private boolean escapeSequences;
    private int tabStop = 60;
    private Color textColor = Color.black;
    private Color penColor;
    private Color shadeColor;
    private int lineExtend = 0;
    private Font font;
    private Font defaultFont;
    private FontMetrics fontMetrics;
    private int fontAscent = 0;
    private int fontDescent = 0;
    private boolean enableGraphics;
    private String graphicsTag = "<GFX>";
    private int CONNECTION_THICKNESS = 1;
    private final Vector<ConnectorNode> connectors = new Vector();
    private int previousPageIndex = -1;
    private int pageIndex = 0;
    private int lastPageIndex = -1;
    private int pageBoundaryX;
    private int pageBoundaryY;
    private static final char[] ESCAPES_FULL = new char[]{'\t', '\n', '\r', '\u000e', '\u000f', '\u001b'};
    private static final char[] ESCAPES_SIMPLE = new char[]{'\n', '\r'};
    private int pageSplitBoundary = this.pageBoundaryY - this.bottomMargin - this.topMargin;
    public final Semaphore ejectObject = new Semaphore();
    private final Vector<Vector<PrintQueue>> printQueue = new Vector();
    private Component component;
    public static final int COLOR = 0;
    public static final int FONT = 1;
    public static final int IMAGE = 2;
    public static final int COMPONENT = 3;
    public static final int FILL3DRECT = 4;
    public static final int FILLRECT = 5;
    public static final int DRAW3DRECT = 6;
    public static final int DRAWRECT = 7;
    public static final int FILLROUNDRECT = 8;
    public static final int DRAWROUNDRECT = 9;
    public static final int FILLOVAL = 10;
    public static final int FILLARC = 12;
    public static final int DRAWARC = 13;
    public static final int DRAWLINE = 14;
    public static final int DRAWSTRING = 15;
    public static final int CLEARRECT = 16;
    public static final int CLIPRECT = 17;
    public static final int COPYAREA = 18;
    public static final int TRANSLATE = 19;
    public static final int PAINTMODE = 20;
    public static final int XORMODE = 21;
    public static final int DRAWOVAL = 22;
    public static final int SETSTROKE = 23;
    public static final int SHEAR = 24;
    public static final int SCALE = 25;
    public static final int ROTATE = 26;
    public static final int ROTATE3 = 27;
    public static final int TRANSFORM = 28;

    private static void log(String s) {
    }

    private static void log(Throwable t) {
    }

    private void resetX() {
        this.xpos = 0.0;
    }

    private void resetY() {
        this.topMargin = this.nextTopMargin;
        this.leftMargin = BASIC_LEFT_MARGIN;
        this.ypos = this.multiplierYCharacters * 2.0;
        this.pageSplitBoundary = this.pageBoundaryY - this.bottomMargin - this.topMargin;
    }

    @Override
    public Component getComponent() {
        try {
            if (this.component == null) {
                this.component = new Canvas();
            }
        }
        catch (Throwable t) {
            JVM12Driver.log(t);
        }
        return this.component;
    }

    private void clearPrintQueue(int pageIndex) {
        if (pageIndex < 0) {
            return;
        }
        int size = this.printQueue.size();
        if (pageIndex < size) {
            try {
                Vector<PrintQueue> pageQueue = this.printQueue.elementAt(pageIndex);
                if (pageQueue != null) {
                    pageQueue.setSize(0);
                }
            }
            catch (Throwable t) {
                JVM12Driver.log(t);
            }
            this.printQueue.setElementAt(null, pageIndex);
        }
    }

    private void renderPrintQueue(Graphics page, int pageIndex) {
        try {
            Vector<PrintQueue> pageQueue;
            if (pageIndex < 0) {
                return;
            }
            this.clearPrintQueue(pageIndex - 1);
            int size = this.printQueue.size();
            if (pageIndex < size && (pageQueue = this.printQueue.elementAt(pageIndex)) != null) {
                size = pageQueue.size();
                for (int i = 0; i < size; ++i) {
                    try {
                        PrintQueue element = pageQueue.elementAt(i);
                        JVM12Driver.log("render " + element);
                        element.print(page);
                        continue;
                    }
                    catch (Throwable renderingException) {
                        JVM12Driver.log(renderingException);
                    }
                }
            }
        }
        catch (Throwable t) {
            JVM12Driver.log(t);
        }
    }

    private void addPrintQueue(PrintQueue item) {
        this.waitForPage();
        Vector<PrintQueue> pageQueue = null;
        try {
            int size = this.printQueue.size();
            if (this.pageIndex < size) {
                pageQueue = this.printQueue.elementAt(this.pageIndex);
            } else {
                this.printQueue.setSize(this.pageIndex + 1);
            }
            if (pageQueue == null) {
                pageQueue = new Vector();
                this.printQueue.setElementAt(pageQueue, this.pageIndex);
            }
        }
        catch (Throwable t) {
            JVM12Driver.log(t);
        }
        if (pageQueue != null) {
            pageQueue.addElement(item);
        }
    }

    private void waitForPage() {
        if (this.job == null) {
            return;
        }
        if (this.job.isCancelled()) {
            throw new RuntimeException("Print Job Cancelled");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int pageIndex) {
        Paper paper = pageFormat.getPaper();
        paper.setImageableArea(BASIC_LEFT_MARGIN, BASIC_TOP_MARGIN, paper.getWidth() - (double)BASIC_LEFT_MARGIN, paper.getHeight() - (double)BASIC_TOP_MARGIN - (double)BASIC_BOTTOM_MARGIN);
        pageFormat.setPaper(paper);
        if (this.defaultFont != null) {
            graphics.setFont(this.defaultFont);
        }
        if (pageIndex == this.previousPageIndex) {
            this.renderPrintQueue(graphics, pageIndex);
            return 0;
        }
        this.previousPageIndex = pageIndex;
        if (pageIndex == this.lastPageIndex) {
            this.renderPrintQueue(graphics, pageIndex);
            return 1;
        }
        try {
            Semaphore semaphore = this.ejectObject;
            synchronized (semaphore) {
                this.ejectObject.acquire();
                this.renderPrintQueue(graphics, pageIndex);
            }
        }
        catch (Throwable t) {
            JVM12Driver.log(t);
            return 1;
        }
        return 0;
    }

    @Override
    public void clearDialog() {
        attributes.remove("RETURN");
        attributes.remove("EXTENDED_ERROR");
        attributes.remove("ALL_PAGES_FLAG");
        attributes.remove("SELECTION_FLAG");
        attributes.remove("PAGE_NUMBERS_FLAG");
        attributes.remove("NO_SELECTION_FLAG");
        attributes.remove("NO_PAGE_NUMBERS_FLAG");
        attributes.remove("COLLATE_FLAG");
        attributes.remove("PRINT_SETUP_FLAG");
        attributes.remove("PRINT_TO_FILE_FLAG");
        attributes.remove("NO_WARNING_FLAG");
        attributes.remove("USER_DEVICE_MODE_COPIES_FLAG");
        attributes.remove("DISABLE_PRINT_TO_FILE_FLAG");
        attributes.remove("HIDE_PRINT_TO_FILE_FLAG");
        attributes.remove("NO_NETWORK_BUTTON_FLAG");
        attributes.remove("FROM_PAGE");
        attributes.remove("TO_PAGE");
        attributes.remove("MIN_PAGE");
        attributes.remove("MAX_PAGE");
        attributes.remove("PRINT_DIALOG_COPIES");
        attributes.remove("DEVICE_NAME");
        attributes.remove("ORIENTATION");
        attributes.remove("PAPER_SIZE");
        attributes.remove("PAPER_LENGTH");
        attributes.remove("PAPER_WIDTH");
        attributes.remove("SCALE");
        attributes.remove("DEVICE_MODE_COPIES");
        attributes.remove("DEFAULT_SOURCE");
        attributes.remove("PRINT_QUALITY");
        attributes.remove("COLOR");
        attributes.remove("DUPLEX");
        attributes.remove("Y_RESOLUTION");
        attributes.remove("TRUE_TYPE_OPTION");
        attributes.remove("COLLATE");
        attributes.remove("ICM_METHOD");
        attributes.remove("MEDIA_TYPE");
        attributes.remove("DITHER_TYPE");
    }

    @Override
    public boolean displayDialog() {
        return this.job != null && this.job.printDialog();
    }

    @Override
    public String getDialog(String attribute) {
        if ((attribute = this.normalizeAttribute(attribute)) != null) {
            if (attribute.startsWith("SUPPORTED")) {
                return "3,JOB_NAME,USER_NAME,COPIES";
            }
            if (attribute.startsWith("JOB_NAME") && this.jobName != null) {
                return this.jobName;
            }
            if (attribute.startsWith("USER_NAME") && this.userName != null) {
                return this.userName;
            }
        }
        return this.getAttribute(attribute);
    }

    @Override
    public void setDialog(String attribute, String value) {
        if ((attribute = this.normalizeAttribute(attribute)) != null && attribute.startsWith("COPIES") && value != null && this.job != null) {
            this.job.setCopies(ConvertData.parseInt(value.trim()));
        }
        this.setAttribute(attribute, value);
    }

    private String normalizeAttribute(String name) {
        return name != null ? name.trim().toUpperCase().replace('-', '_').replace(' ', '_') : null;
    }

    public String getAttribute(String name) {
        if (name != null) {
            name = this.normalizeAttribute(name);
            try {
                String value = attributes.get(name);
                if (value != null) {
                    return value;
                }
            }
            catch (Exception cachedValues) {
                JVM12Driver.log(cachedValues);
            }
        }
        return null;
    }

    public void setAttribute(String name, String value) {
        if (name != null) {
            name = this.normalizeAttribute(name);
            try {
                if ("BASIC_LEFT_MARGIN".equals(name)) {
                    BASIC_LEFT_MARGIN = Integer.parseInt(value.trim());
                } else if ("BASIC_TOP_MARGIN".equals(name)) {
                    BASIC_TOP_MARGIN = Integer.parseInt(value.trim());
                } else if ("BASIC_BOTTOM_MARGIN".equals(name)) {
                    BASIC_BOTTOM_MARGIN = Integer.parseInt(value.trim());
                } else if ("DASH_LENGTH".equals(name)) {
                    DASH_LENGTH = new Float(value.trim()).floatValue();
                } else if ("DOT_LENGTH".equals(name)) {
                    DOT_LENGTH = new Float(value.trim()).floatValue();
                } else if ("SPACE_LENGTH".equals(name)) {
                    SPACE_LENGTH = new Float(value.trim()).floatValue();
                } else if ("DASH_LINE".equals(name) || "DOT_LINE".equals(name) || "DASH_DOT_LINE".equals(name) || "DASH_DOT_DOT_LINE".equals(name)) {
                    int length = value.length();
                    float[] pattern = new float[length];
                    float multiplier = 1.0f;
                    block16: for (int i = 0; i < length; ++i) {
                        switch (value.charAt(i)) {
                            case '.': {
                                pattern[i] = multiplier * DOT_LENGTH;
                                multiplier = 1.0f;
                                continue block16;
                            }
                            case '-': {
                                pattern[i] = multiplier * DASH_LENGTH;
                                multiplier = 1.0f;
                                continue block16;
                            }
                            case ' ': {
                                pattern[i] = multiplier * SPACE_LENGTH;
                                multiplier = 1.0f;
                                continue block16;
                            }
                            case '1': {
                                multiplier = 1.0f;
                                continue block16;
                            }
                            case '2': {
                                multiplier = 2.0f;
                                continue block16;
                            }
                            case '3': {
                                multiplier = 3.0f;
                                continue block16;
                            }
                            case '4': {
                                multiplier = 4.0f;
                                continue block16;
                            }
                            case '5': {
                                multiplier = 5.0f;
                                continue block16;
                            }
                            case '6': {
                                multiplier = 6.0f;
                                continue block16;
                            }
                            case '7': {
                                multiplier = 7.0f;
                                continue block16;
                            }
                            case '8': {
                                multiplier = 8.0f;
                                continue block16;
                            }
                            case '9': {
                                multiplier = 9.0f;
                            }
                        }
                    }
                    if ("DASH_LINE".equals(name)) {
                        DASH_LINE = pattern;
                    } else if ("DOT_LINE".equals(name)) {
                        DOT_LINE = pattern;
                    } else if ("DASH_DOT_DOT_LINE".equals(name)) {
                        DASH_DOT_DOT_LINE = pattern;
                    }
                }
            }
            catch (Throwable t) {
                JVM12Driver.log(t);
            }
            if (value == null) {
                attributes.remove(name);
            } else {
                attributes.put(name, value);
            }
        }
    }

    @Override
    public double getScaleX(String units) {
        if (units == null) {
            return 1.0;
        }
        if ((units = units.trim()).length() > 0) {
            switch (units.charAt(0)) {
                case 'I': 
                case 'i': {
                    return this.multiplierXInches;
                }
                case 'M': 
                case 'm': {
                    return this.multiplierXMetric;
                }
                case 'C': 
                case 'c': {
                    return this.multiplierXCharacters;
                }
                case 'D': 
                case 'T': 
                case 'd': 
                case 't': {
                    return this.multiplierXDeviceUnits;
                }
                case 'P': 
                case 'p': {
                    return 1.0;
                }
            }
        }
        return 1.0;
    }

    @Override
    public double getScaleY(String units) {
        if (units == null) {
            return 1.0;
        }
        if ((units = units.trim()).length() > 0) {
            switch (units.charAt(0)) {
                case 'I': 
                case 'i': {
                    return this.multiplierYInches;
                }
                case 'M': 
                case 'm': {
                    return this.multiplierYMetric;
                }
                case 'C': 
                case 'c': {
                    return this.multiplierYCharacters;
                }
                case 'D': 
                case 'T': 
                case 'd': 
                case 't': {
                    return this.multiplierYDeviceUnits;
                }
                case 'P': 
                case 'p': {
                    return 1.0;
                }
            }
        }
        return 1.0;
    }

    @Override
    public void draw(Image image, double xpos, double ypos, double width, double height) {
        if (this.job == null) {
            return;
        }
        if (image != null) {
            if (width <= 0.0 && height <= 0.0) {
                this.addPrintQueue(new PrintQueue(2, image, (int)(xpos + (double)this.leftMargin), (int)(ypos + (double)this.topMargin), Color.white));
            } else {
                if (width <= 0.0) {
                    width = image.getWidth(this.getComponent());
                }
                if (height <= 0.0) {
                    height = image.getHeight(this.getComponent());
                }
                this.addPrintQueue(new PrintQueue(2, image, (int)(xpos + (double)this.leftMargin), (int)(ypos + (double)this.topMargin), (int)width, (int)height, Color.white));
            }
        }
    }

    @Override
    public void draw(Component component, double xpos, double ypos, double width, double height) {
        if (this.job == null) {
            return;
        }
        this.addPrintQueue(new PrintQueue(3, component, (int)(xpos + (double)this.leftMargin), (int)(ypos + (double)this.topMargin), (int)width, (int)height));
    }

    @Override
    public void drawBox(double xpos, double ypos, double width, double height, boolean shade, boolean _3d, boolean raised) {
        if (this.job == null) {
            return;
        }
        Color c = this.getPenColor();
        int bx = (int)(xpos + (double)this.leftMargin);
        int by = (int)(ypos + (double)this.topMargin);
        int sw = (int)width;
        int sh = (int)height;
        if (shade) {
            this.addPrintQueue(new PrintQueue(this.getShadeColor()));
            if (_3d) {
                this.addPrintQueue(new PrintQueue(4, bx, by, sw, sh, raised));
            } else {
                this.addPrintQueue(new PrintQueue(5, bx, by, sw, sh));
            }
        }
        this.addPrintQueue(new PrintQueue(c));
        if (_3d) {
            this.addPrintQueue(new PrintQueue(6, bx, by, sw, sh, raised));
        } else {
            this.addPrintQueue(new PrintQueue(7, bx, by, sw, sh));
        }
    }

    @Override
    public void drawBox(double xpos, double ypos, double width, double height, boolean shade, int arcWidth, int arcHeight) {
        if (this.job == null) {
            return;
        }
        Color c = this.getPenColor();
        int bx = (int)(xpos + (double)this.leftMargin);
        int by = (int)(ypos + (double)this.topMargin);
        int sw = (int)width;
        int sh = (int)height;
        if (shade) {
            this.addPrintQueue(new PrintQueue(this.getShadeColor()));
            this.addPrintQueue(new PrintQueue(8, bx, by, sw, sh, arcWidth, arcHeight));
        }
        this.addPrintQueue(new PrintQueue(c));
        this.addPrintQueue(new PrintQueue(9, bx, by, sw, sh, arcWidth, arcHeight));
    }

    @Override
    public void drawOval(double xpos, double ypos, double width, double height, boolean shade) {
        if (this.job == null) {
            return;
        }
        Color c = this.getPenColor();
        int bx = (int)(xpos + (double)this.leftMargin);
        int by = (int)(ypos + (double)this.topMargin);
        int sw = (int)width;
        int sh = (int)height;
        if (shade) {
            this.addPrintQueue(new PrintQueue(this.getShadeColor()));
            this.addPrintQueue(new PrintQueue(10, bx, by, sw, sh));
        }
        this.addPrintQueue(new PrintQueue(c));
        this.addPrintQueue(new PrintQueue(22, bx, by, sw, sh));
    }

    @Override
    public void drawArc(double xpos, double ypos, double width, double height, boolean shade, int startAngle, int endAngle) {
        if (this.job == null) {
            return;
        }
        Color c = this.getPenColor();
        int bx = (int)(xpos + (double)this.leftMargin);
        int by = (int)(ypos + (double)this.topMargin);
        int sw = (int)width;
        int sh = (int)height;
        if (shade) {
            this.addPrintQueue(new PrintQueue(this.getShadeColor()));
            this.addPrintQueue(new PrintQueue(12, bx, by, sw, sh, startAngle, endAngle));
        }
        this.addPrintQueue(new PrintQueue(c));
        this.addPrintQueue(new PrintQueue(13, bx, by, sw, sh, startAngle, endAngle));
    }

    @Override
    public void drawLine(double x1, double y1, double x2, double y2) {
        if (this.job == null) {
            return;
        }
        Color c = this.getPenColor();
        this.addPrintQueue(new PrintQueue(c));
        this.addPrintQueue(new PrintQueue(14, (int)(x1 + (double)this.leftMargin), (int)(y1 + (double)this.topMargin), (int)(x2 + (double)this.leftMargin), (int)(y2 + (double)this.topMargin)));
        this.lineFromX = x2;
        this.lineFromY = y2;
    }

    @Override
    public void drawLineFrom(double x1, double y1) {
        this.lineFromX = x1;
        this.lineFromY = y1;
    }

    @Override
    public void drawLineTo(double x2, double y2) {
        if (this.job == null) {
            return;
        }
        this.drawLine(this.lineFromX, this.lineFromY, x2, y2);
    }

    @Override
    public void setShadeColor(Color shade) {
        if (shade == null) {
            shade = Color.lightGray;
        }
        this.shadeColor = shade;
    }

    @Override
    public Color getShadeColor() {
        if (this.shadeColor != null) {
            return this.shadeColor;
        }
        return Color.lightGray;
    }

    @Override
    public void setPen(int penStyle, double penWidth, Color penColor) {
        this.penColor = penColor;
        if (penStyle != 0 || penWidth != 1.0) {
            this.addPrintQueue(new PrintQueue(23, penWidth, (double)penStyle, 0.0));
        }
    }

    public Color getPenColor() {
        return this.penColor != null ? this.penColor : this.getTextColor();
    }

    @Override
    public double getPositionX() {
        return this.xpos;
    }

    @Override
    public double getPositionY() {
        return this.ypos;
    }

    @Override
    public void setPositionX(double xpos) {
        this.xpos = xpos;
    }

    @Override
    public void setPositionY(double ypos) {
        this.ypos = ypos;
    }

    private void init() {
        this.lastPageIndex = -1;
        this.previousPageIndex = -1;
        this.pageIndex = 0;
        this.leftMargin = BASIC_LEFT_MARGIN;
        this.topMargin = this.nextTopMargin;
        this.bottomMargin = BASIC_BOTTOM_MARGIN;
        this.fontUnderline = false;
        this.fontStrikeOut = false;
        this.fontDoubleStrike = false;
        this.resetX();
        this.resetY();
    }

    @Override
    public boolean open(boolean dialogEnabled, boolean rawMode, String filename) {
        try {
            this.init();
            if (filename == null) {
                filename = "";
            } else if (filename.indexOf(63) >= 0) {
                dialogEnabled = true;
            } else if (filename.toUpperCase().indexOf("NEW") >= 0) {
                dialogEnabled = true;
            }
            this.job = PrinterJob.getPrinterJob();
            if (this.job == null) {
                return false;
            }
            if (dialogEnabled) {
                if (!this.displayDialog()) {
                    this.job = null;
                    return false;
                }
                dialogEnabled = false;
            }
            this.jobName = this.job.getJobName();
            this.userName = this.job.getUserName();
            this.pageFormat = this.job.defaultPage();
            String value = this.getDialog("PAGE_SETUP");
            if (value == null) {
                value = this.getDialog("PAGE_DIALOG");
            }
            if (value == null) {
                value = this.getDialog("PRINT_SETUP");
            }
            if (value != null && value.length() > 0) {
                switch (value.charAt(0)) {
                    case '1': 
                    case 'Y': 
                    case 'y': {
                        this.pageFormat = this.job.pageDialog(this.pageFormat);
                    }
                }
            }
            if ((value = this.getDialog("ORIENTATION")) != null) {
                if ((value = value.trim().toUpperCase()).startsWith("1") || value.startsWith("P")) {
                    this.pageFormat.setOrientation(1);
                } else if (value.startsWith("2") || value.startsWith("L")) {
                    this.pageFormat.setOrientation(0);
                } else if (value.startsWith("3") || value.startsWith("R")) {
                    this.pageFormat.setOrientation(2);
                }
            }
            if ((value = this.getDialog("PAPER_SIZE")) == null) {
                value = this.getDialog("PAPERSIZE");
            }
            double width = -1.0;
            double height = -1.0;
            double imageWidth = -1.0;
            double imageHeight = -1.0;
            double imageX = 72.0;
            double imageY = 72.0;
            if (value != null) {
                int type;
                block138: {
                    type = 0;
                    try {
                        type = Integer.parseInt(value.trim());
                    }
                    catch (Throwable t) {
                        value = value.trim().toUpperCase();
                        if ("LETTER".equals(value)) {
                            type = 1;
                        }
                        if ("LETTERSMALL".equals(value)) {
                            type = 2;
                        }
                        if ("TABLOID".equals(value)) {
                            type = 3;
                        }
                        if ("LEDGER".equals(value)) {
                            type = 4;
                        }
                        if ("LEGAL".equals(value)) {
                            type = 5;
                        }
                        if ("STATEMENT".equals(value)) {
                            type = 6;
                        }
                        if ("EXECUTIVE".equals(value)) {
                            type = 7;
                        }
                        if ("A3".equals(value)) {
                            type = 8;
                        }
                        if ("A4".equals(value)) {
                            type = 9;
                        }
                        if ("A4SMALL".equals(value)) {
                            type = 10;
                        }
                        if ("A5".equals(value)) {
                            type = 11;
                        }
                        if ("B4".equals(value)) {
                            type = 12;
                        }
                        if ("B5".equals(value)) {
                            type = 13;
                        }
                        if ("FOLIO".equals(value)) {
                            type = 14;
                        }
                        if ("QUARTO".equals(value)) {
                            type = 15;
                        }
                        if ("10X14".equals(value)) {
                            type = 16;
                        }
                        if ("11X17".equals(value)) {
                            type = 17;
                        }
                        if ("NOTE".equals(value)) {
                            type = 18;
                        }
                        if ("ENV9".equals(value)) {
                            type = 19;
                        }
                        if ("ENV10".equals(value)) {
                            type = 20;
                        }
                        if ("ENV11".equals(value)) {
                            type = 21;
                        }
                        if ("ENV12".equals(value)) {
                            type = 22;
                        }
                        if ("ENV14".equals(value)) {
                            type = 23;
                        }
                        if ("CSHEET".equals(value)) {
                            type = 24;
                        }
                        if ("DSHEET".equals(value)) {
                            type = 25;
                        }
                        if ("ESHEET".equals(value)) {
                            type = 26;
                        }
                        if ("ENVD1".equals(value) || "ENVDL".equals(value)) {
                            type = 27;
                        }
                        if ("ENVC5".equals(value)) {
                            type = 28;
                        }
                        if ("ENVC3".equals(value)) {
                            type = 29;
                        }
                        if ("ENVC4".equals(value)) {
                            type = 30;
                        }
                        if ("ENVC6".equals(value)) {
                            type = 31;
                        }
                        if ("ENVC65".equals(value)) {
                            type = 32;
                        }
                        if ("ENVB4".equals(value)) {
                            type = 33;
                        }
                        if ("ENVB5".equals(value)) {
                            type = 34;
                        }
                        if ("ENVB6".equals(value)) {
                            type = 35;
                        }
                        if ("ENVITALY".equals(value)) {
                            type = 36;
                        }
                        if ("ENVPERSONAL".equals(value)) {
                            type = 38;
                        }
                        if ("FANFOLDUS".equals(value)) {
                            type = 39;
                        }
                        if ("FANFOLDSTDGERMAN".equals(value)) {
                            type = 40;
                        }
                        if ("FANFOLDLGLGERMAN".equals(value)) {
                            type = 41;
                        }
                        if ("ENVMONARCH".equals(value)) {
                            type = 42;
                        }
                        if ("MONARCH".equals(value)) {
                            type = 43;
                        }
                        if ("EUROPOSTCARD".equals(value)) {
                            type = 44;
                        }
                        if ("B5_JAPAN".equals(value)) {
                            type = 45;
                        }
                        if (!"HALF_LETTER".equals(value)) break block138;
                        type = 46;
                    }
                }
                switch (type) {
                    case 1: {
                        width = 612.0;
                        height = 792.0;
                        break;
                    }
                    case 2: {
                        width = 612.0;
                        height = 792.0;
                        break;
                    }
                    case 3: {
                        width = 794.0;
                        height = 1227.0;
                        break;
                    }
                    case 4: {
                        width = 794.0;
                        height = 1227.0;
                        break;
                    }
                    case 5: {
                        width = 612.0;
                        height = 1008.0;
                        break;
                    }
                    case 6: 
                    case 7: {
                        width = 522.072;
                        height = 756.0;
                        break;
                    }
                    case 8: {
                        width = 841.88976;
                        height = 1190.5512;
                        break;
                    }
                    case 9: {
                        width = 595.224;
                        height = 841.824;
                        break;
                    }
                    case 10: {
                        width = 595.224;
                        height = 841.824;
                        break;
                    }
                    case 11: {
                        width = 420.94488;
                        height = 595.27559;
                        break;
                    }
                    case 12: {
                        width = 730.0;
                        height = 1034.0;
                        break;
                    }
                    case 13: {
                        width = 500.0;
                        height = 710.0;
                        break;
                    }
                    case 14: 
                    case 15: 
                    case 16: {
                        width = 720.0;
                        height = 1008.0;
                        break;
                    }
                    case 17: {
                        width = 792.0;
                        height = 1224.0;
                        break;
                    }
                    case 18: {
                        width = 612.0;
                        height = 792.0;
                        break;
                    }
                    case 19: 
                    case 20: {
                        width = 297.0;
                        height = 684.0;
                        break;
                    }
                    case 21: 
                    case 22: 
                    case 23: 
                    case 24: {
                        width = 216.0;
                        height = 279.5;
                        break;
                    }
                    case 25: {
                        width = 279.5;
                        height = 432.0;
                        break;
                    }
                    case 26: {
                        width = 432.0;
                        height = 559.0;
                        break;
                    }
                    case 27: {
                        width = 311.76;
                        height = 649.08;
                        break;
                    }
                    case 28: {
                        width = 459.144;
                        height = 649.08;
                        break;
                    }
                    case 29: 
                    case 30: 
                    case 31: 
                    case 32: 
                    case 33: 
                    case 34: {
                        width = 498.888;
                        height = 708.624;
                        break;
                    }
                    case 35: 
                    case 36: 
                    case 38: 
                    case 39: 
                    case 40: 
                    case 41: 
                    case 42: {
                        width = 278.928;
                        height = 540.0;
                        break;
                    }
                    case 43: {
                        width = 280.0;
                        height = 542.0;
                        break;
                    }
                    case 44: {
                        width = 298.0;
                        height = 420.0;
                        break;
                    }
                    case 45: {
                        width = 517.0;
                        height = 730.0;
                        break;
                    }
                    case 46: {
                        width = 612.0;
                        height = 397.0;
                    }
                }
            }
            if ((value = this.getDialog("PAPER_LENGTH")) == null) {
                value = this.getDialog("PAPERLENGTH");
            }
            if (value != null) {
                try {
                    height = new Float(value.trim()).floatValue();
                }
                catch (Throwable type) {
                    // empty catch block
                }
            }
            if ((value = this.getDialog("PAPER_WIDTH")) == null) {
                value = this.getDialog("PAPERWIDTH");
            }
            if (value != null) {
                try {
                    width = new Float(value.trim()).floatValue();
                }
                catch (Throwable type) {
                    // empty catch block
                }
            }
            Paper modify = this.pageFormat.getPaper();
            if (imageWidth > 0.0 && imageHeight > 0.0) {
                modify.setImageableArea(imageX, imageY, imageWidth, imageHeight);
            }
            if (width > 0.0 && height > 0.0) {
                modify.setSize(width, height);
            }
            this.pageFormat.setPaper(modify);
            this.pageFormat = this.job.validatePage(this.pageFormat);
            Paper paper = this.pageFormat.getPaper();
            paper.setImageableArea(BASIC_LEFT_MARGIN, BASIC_TOP_MARGIN, paper.getWidth() - (double)BASIC_LEFT_MARGIN, paper.getHeight() - (double)BASIC_TOP_MARGIN - (double)BASIC_BOTTOM_MARGIN);
            this.pageFormat.setPaper(paper);
            String pf_font = "Monospaced";
            int pf_size = -1;
            int pf_style = 0;
            boolean pf_bold = false;
            boolean pf_italic = false;
            this.translatex = -1;
            this.translatey = -1;
            double HEIGHT_ADJUST = 0.97;
            double PAGESIZE_WIDTH_ADJUST = 0.93;
            double PAGESIZE_HEIGHT_ADJUST = 0.91;
            double DIMENSION = 0.825;
            int DPI = 600;
            try {
                StringTokenizer st = new StringTokenizer(filename, "/\\:;");
                while (st.hasMoreTokens()) {
                    String token = st.nextToken();
                    value = "";
                    if (token == null) continue;
                    int equals = token.indexOf(61);
                    if (equals >= 0) {
                        value = token.substring(equals + 1);
                        token = token.substring(0, equals);
                    }
                    if ((token = token.trim().toUpperCase()).equals("FONT")) {
                        pf_font = value;
                        continue;
                    }
                    if (token.equals("SIZE")) {
                        pf_size = ConvertData.parseInt(value.trim());
                        continue;
                    }
                    if (token.equals("COLS")) {
                        this.cols = ConvertData.parseInt(value.trim());
                        continue;
                    }
                    if (token.equals("ROWS")) {
                        this.rows = ConvertData.parseInt(value.trim());
                        continue;
                    }
                    if (token.equals("CODEPAGE") || token.equals("CP")) {
                        value = value.trim();
                        continue;
                    }
                    if (token.equals("ALIGNX")) {
                        this.alignx = ConvertData.parseInt(value.trim());
                        continue;
                    }
                    if (token.equals("ALIGNY")) {
                        this.aligny = ConvertData.parseInt(value.trim());
                        continue;
                    }
                    if (token.equals("MARGINX")) {
                        this.translatex = ConvertData.parseInt(value.trim());
                        continue;
                    }
                    if (token.equals("MARGINY")) {
                        this.translatey = ConvertData.parseInt(value.trim());
                        continue;
                    }
                    if (token.equals("DPI")) {
                        DPI = ConvertData.parseInt(value.trim());
                        continue;
                    }
                    if (token.equals("BOLD")) {
                        pf_bold = true;
                        continue;
                    }
                    if (token.equals("ITALIC")) {
                        pf_italic = true;
                        continue;
                    }
                    if (token.equals("PLAIN")) {
                        pf_bold = false;
                        pf_italic = false;
                        continue;
                    }
                    if (token.equals("GRAPHICS") || token.equals("GFX")) {
                        this.enableGraphics = true;
                        if (value == null || value.length() <= 0) continue;
                        this.graphicsTag = value;
                        continue;
                    }
                    if (token.equals("TEXT")) {
                        this.enableGraphics = false;
                        continue;
                    }
                    if (token.equals("HEIGHT-ADJUST")) {
                        HEIGHT_ADJUST = Double.valueOf(value.trim());
                        if (!(HEIGHT_ADJUST <= 0.0)) continue;
                        HEIGHT_ADJUST = 0.97;
                        continue;
                    }
                    if (token.equals("PAGE-WIDTH-ADJUST")) {
                        PAGESIZE_WIDTH_ADJUST = Double.valueOf(value.trim());
                        if (!(PAGESIZE_WIDTH_ADJUST <= 0.0)) continue;
                        PAGESIZE_WIDTH_ADJUST = 0.93;
                        continue;
                    }
                    if (token.equals("PAGE-HEIGHT-ADJUST")) {
                        PAGESIZE_HEIGHT_ADJUST = Double.valueOf(value.trim());
                        if (!(PAGESIZE_HEIGHT_ADJUST <= 0.0)) continue;
                        PAGESIZE_HEIGHT_ADJUST = 0.91;
                        continue;
                    }
                    if (!token.equals("DIMENSION") || !((DIMENSION = Double.valueOf(value.trim()).doubleValue()) <= 0.0)) continue;
                    DIMENSION = 0.825;
                }
            }
            catch (Throwable tokenizationException) {
                JVM12Driver.log(tokenizationException);
            }
            double pagesize_width = this.pageFormat.getWidth();
            double pagesize_height = this.pageFormat.getHeight();
            this.pageBoundaryX = (int)pagesize_width;
            this.pageBoundaryY = (int)pagesize_height;
            int pixelsPerInch = 72;
            this.multiplierXInches = pixelsPerInch;
            this.multiplierYInches = pixelsPerInch;
            this.multiplierXMetric = this.multiplierXInches * 0.3937;
            this.multiplierYMetric = this.multiplierYInches * 0.3937;
            this.multiplierYDeviceUnits = (double)pixelsPerInch / (double)DPI;
            this.multiplierXDeviceUnits = (double)pixelsPerInch / (double)DPI;
            int adjust_pagesize_width = (int)(pagesize_width * PAGESIZE_WIDTH_ADJUST);
            int adjust_pagesize_height = (int)(pagesize_height * PAGESIZE_HEIGHT_ADJUST);
            if (this.translatex < 0) {
                this.translatex = (int)((pagesize_width - (double)adjust_pagesize_width) / 2.0);
            }
            if (this.translatey < 0) {
                this.translatey = (int)((pagesize_height - (double)adjust_pagesize_height) / 2.0);
            }
            double desiredPointSize = 80.0 / (double)this.cols * 12.0;
            double doublePrinterPageLength = this.pageFormat.getHeight() / desiredPointSize;
            this.printerPageLength = (int)doublePrinterPageLength;
            if (this.rows == -1) {
                this.rows = this.printerPageLength;
            }
            if (this.rows < this.printerPageLength) {
                this.printerPageLength = this.rows;
            }
            this.printerFontHeight = (int)Math.ceil((double)adjust_pagesize_height / doublePrinterPageLength);
            --this.printerFontHeight;
            if (pf_size < 0) {
                pf_size = this.printerFontHeight;
            }
            if (pf_bold) {
                pf_style |= 1;
            }
            if (pf_italic) {
                pf_style |= 2;
            }
            boolean renderHeight = false;
            this.printerFontWidth = adjust_pagesize_width / this.cols;
            this.printerFontMetricHeight = (double)renderHeight * HEIGHT_ADJUST;
            this.job.setPrintable(this, this.pageFormat);
            final PrinterJob backgroundPrintJob = this.job;
            ThreadQueue backgroundJob = new ThreadQueue("CobolPrinter12 print job"){

                @Override
                public void run() {
                    try {
                        Shutdown.increaseCobolThreadDependencies();
                        backgroundPrintJob.print();
                        Shutdown.decreaseCobolThreadDependencies();
                    }
                    catch (PrinterException printerException) {
                        JVM12Driver.log(printerException);
                    }
                }
            };
            this.setDefaultFont(new Font(pf_font, pf_style, pf_size));
            this.resetX();
            this.resetY();
            backgroundJob.start();
        }
        catch (Throwable logException) {
            JVM12Driver.log(logException);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void eject() {
        if (this.job == null) {
            return;
        }
        try {
            this.realizeConnectors();
            try {
                Semaphore semaphore = this.ejectObject;
                synchronized (semaphore) {
                    ++this.pageIndex;
                    this.ejectObject.release();
                    this.resetX();
                    this.resetY();
                }
            }
            catch (Throwable t) {
                JVM12Driver.log(t);
            }
        }
        catch (Exception e) {
            JVM12Driver.log(e);
        }
    }

    @Override
    public void close() {
        this.lastPageIndex = this.pageIndex + 1;
        this.eject();
        this.job = null;
    }

    @Override
    public void clearFont() {
        this.setFont(this.defaultFont);
    }

    @Override
    public Dimension getTextExtent(String text) {
        FontMetrics fontMetrics = this.getFontMetrics();
        if (fontMetrics != null) {
            int width = fontMetrics.stringWidth(text);
            int height = fontMetrics.getHeight();
            return new Dimension(width, height);
        }
        return null;
    }

    @Override
    public double getTextPositionX(boolean bottom) {
        return this.xpos;
    }

    @Override
    public double getTextPositionY(boolean bottom) {
        if (bottom) {
            return this.ypos + (double)this.fontDescent;
        }
        return this.ypos - (double)this.fontAscent;
    }

    @Override
    public void setFont(Font f, boolean underline, boolean strikeOut, boolean doubleStrike) {
        this.fontUnderline = underline;
        this.fontStrikeOut = strikeOut;
        this.fontDoubleStrike = doubleStrike;
        this.setFont(f);
    }

    @Override
    public boolean isFontUnderline() {
        return this.fontUnderline;
    }

    @Override
    public boolean isFontStrikeOut() {
        return this.fontStrikeOut;
    }

    public boolean isFontDoubleStrike() {
        return this.fontDoubleStrike;
    }

    public void setFont(Font f) {
        if (this.defaultFont == null) {
            this.defaultFont = f;
        }
        if (f == null) {
            f = this.defaultFont;
        }
        if (this.job == null) {
            return;
        }
        this.addPrintQueue(new PrintQueue(f));
        this.font = f;
        this.fontMetrics = Utils.getFontMetrics(this.font);
        this.fontAscent = this.fontMetrics.getHeight() + this.fontMetrics.getAscent();
        this.fontDescent = this.fontMetrics.getDescent();
        this.multiplierYCharacters = (this.fontMetrics.getHeight() - this.fontMetrics.getDescent() + (this.fontMetrics.getLeading() + this.fontMetrics.getAscent())) / 2 - 1;
        if (this.multiplierYCharacters < 1.0) {
            this.multiplierYCharacters = 1.0;
        }
        int totalWidth = 0;
        int totalCount = 0;
        int indiWidth = 0;
        for (int i = 0; i < 128; ++i) {
            indiWidth = this.fontMetrics.charWidth(i);
            if (indiWidth <= 1) continue;
            ++totalCount;
            totalWidth += indiWidth;
        }
        this.multiplierXCharacters = totalCount > 0 ? (double)totalWidth / (double)totalCount : this.multiplierYCharacters;
        this.multiplierYDeviceUnits = 0.12;
        this.multiplierXDeviceUnits = 0.12;
    }

    public void setDefaultFont(Font f) {
        if (this.defaultFont == null) {
            this.defaultFont = f;
        }
        if (f == null) {
            f = this.defaultFont;
        }
        this.font = f;
        this.fontMetrics = Utils.getFontMetrics(this.font);
        this.fontAscent = this.fontMetrics.getHeight() + this.fontMetrics.getAscent();
        this.fontDescent = this.fontMetrics.getDescent();
        this.multiplierYCharacters = (this.fontMetrics.getHeight() - this.fontMetrics.getDescent() + (this.fontMetrics.getLeading() + this.fontMetrics.getAscent())) / 2 - 1;
        if (this.multiplierYCharacters < 1.0) {
            this.multiplierYCharacters = 1.0;
        }
        int totalWidth = 0;
        int totalCount = 0;
        int indiWidth = 0;
        for (int i = 0; i < 128; ++i) {
            indiWidth = this.fontMetrics.charWidth(i);
            if (indiWidth <= 1) continue;
            ++totalCount;
            totalWidth += indiWidth;
        }
        this.multiplierXCharacters = totalCount > 0 ? (double)totalWidth / (double)totalCount : this.multiplierYCharacters;
        this.multiplierYDeviceUnits = 0.12;
        this.multiplierXDeviceUnits = 0.12;
    }

    @Override
    public Font getFont() {
        if (this.font == null) {
            this.setFont(new Font("Monospaced", 0, 10));
        }
        return this.font;
    }

    @Override
    public FontMetrics getFontMetrics() {
        if (this.fontMetrics == null) {
            this.getFont();
        }
        return this.fontMetrics;
    }

    @Override
    public void setLineExtend(double extend) {
        this.lineExtend = (int)extend;
    }

    @Override
    public void setPitch(int pitchType) {
    }

    @Override
    public void setTabStop(double tabStop) {
        this.tabStop = (int)tabStop;
    }

    @Override
    public void setTextColor(Color textColor) {
        this.textColor = textColor;
    }

    @Override
    public Color getTextColor() {
        return this.textColor != null ? this.textColor : Color.black;
    }

    @Override
    public void setTextPositionX(double xpos, boolean bottom) {
        this.xpos = xpos;
    }

    @Override
    public void setTextPositionY(double ypos, boolean bottom) {
        this.ypos = bottom ? ypos - (double)this.fontDescent : ypos + (double)this.fontAscent;
    }

    @Override
    public void textOut(String text, double xpos, double ypos, boolean box, boolean shade) {
        if (this.job == null) {
            return;
        }
        this.addPrintQueue(new PrintQueue(this.getFont()));
        Color c = this.getTextColor();
        int w = this.fontMetrics.stringWidth(text);
        int h = (int)this.multiplierYCharacters;
        int lines = 1;
        int advances = 0;
        int textLength = text.length();
        for (int i = 0; i < textLength; ++i) {
            if (text.charAt(i) == '\n') {
                ++lines;
            }
            if (text.charAt(i) != '\r') continue;
            ++advances;
        }
        h *= lines;
        int x = (int)xpos;
        int y = (int)ypos;
        int boxOffsetX = x + this.leftMargin - 2;
        int boxOffsetY = y - (h += advances * this.lineExtend) + this.topMargin;
        int widestW = -1;
        if (w > 0 && shade) {
            this.addPrintQueue(new PrintQueue(this.getShadeColor()));
            this.addPrintQueue(new PrintQueue(5, boxOffsetX, boxOffsetY, w + 2, h + 2));
        }
        this.addPrintQueue(new PrintQueue(c));
        StringBuffer result = new StringBuffer();
        String resultString = null;
        char ch = '\u0000';
        int descender = this.fontMetrics.getDescent();
        block6: for (int i = 0; i < textLength; ++i) {
            ch = text.charAt(i);
            switch (ch) {
                case '\r': {
                    int stringWidth;
                    resultString = result.toString();
                    if (resultString != null && resultString.length() > 0) {
                        this.addPrintQueue(new PrintQueue(15, resultString, x + this.leftMargin, y + this.topMargin));
                        stringWidth = this.fontMetrics.stringWidth(resultString);
                        if (stringWidth > widestW) {
                            widestW = stringWidth;
                        }
                        if (this.fontUnderline) {
                            this.addPrintQueue(new PrintQueue(14, x + this.leftMargin, y + this.topMargin + descender, x + this.leftMargin + stringWidth, y + this.topMargin + descender));
                        }
                        if (this.fontStrikeOut) {
                            this.addPrintQueue(new PrintQueue(14, x + this.leftMargin, y + this.topMargin - h / 2, x + this.leftMargin + stringWidth, y + this.topMargin - h / 2));
                        }
                        if (this.fontDoubleStrike) {
                            this.addPrintQueue(new PrintQueue(15, resultString, x + this.leftMargin + 1, y + this.topMargin));
                        }
                        x += stringWidth;
                    }
                    result.setLength(0);
                    y += this.lineExtend;
                    x = 0;
                    continue block6;
                }
                case '\n': {
                    int stringWidth;
                    resultString = result.toString();
                    if (resultString != null && resultString.length() > 0) {
                        this.addPrintQueue(new PrintQueue(15, resultString, x + this.leftMargin, y + this.topMargin));
                        stringWidth = this.fontMetrics.stringWidth(resultString);
                        if (stringWidth > widestW) {
                            widestW = stringWidth;
                        }
                        if (this.fontUnderline) {
                            this.addPrintQueue(new PrintQueue(14, x + this.leftMargin, y + this.topMargin + descender, x + this.leftMargin + stringWidth, y + this.topMargin + descender));
                        }
                        if (this.fontStrikeOut) {
                            this.addPrintQueue(new PrintQueue(14, x + this.leftMargin, y + this.topMargin - h / 2, x + this.leftMargin + stringWidth, y + this.topMargin - h / 2));
                        }
                        if (this.fontDoubleStrike) {
                            this.addPrintQueue(new PrintQueue(15, resultString, x + this.leftMargin + 1, y + this.topMargin));
                        }
                        x += stringWidth;
                    }
                    result.setLength(0);
                    y += h;
                    y -= this.lineExtend;
                    continue block6;
                }
                case '\u0000': {
                    continue block6;
                }
                default: {
                    result.append(ch);
                }
            }
        }
        if (result.length() > 0 && (resultString = result.toString()) != null && resultString.length() > 0) {
            this.addPrintQueue(new PrintQueue(15, resultString, x + this.leftMargin, y + this.topMargin));
            int stringWidth = this.fontMetrics.stringWidth(resultString);
            if (stringWidth > widestW) {
                widestW = stringWidth;
            }
            if (this.fontUnderline) {
                this.addPrintQueue(new PrintQueue(14, x + this.leftMargin, y + this.topMargin + descender, x + this.leftMargin + stringWidth, y + this.topMargin + descender));
            }
            if (this.fontStrikeOut) {
                this.addPrintQueue(new PrintQueue(14, x + this.leftMargin, y + this.topMargin - h / 2, x + this.leftMargin + stringWidth, y + this.topMargin - h / 2));
            }
            if (this.fontDoubleStrike) {
                this.addPrintQueue(new PrintQueue(15, resultString, x + this.leftMargin + 1, y + this.topMargin));
            }
            x += stringWidth;
        }
        this.xpos = x;
        this.ypos = y;
        w = widestW;
        if (w > 0) {
            this.addPrintQueue(new PrintQueue(c));
            if (box) {
                this.addPrintQueue(new PrintQueue(7, boxOffsetX, boxOffsetY, w + 2, h + 2));
            }
        }
    }

    private int indexOfEscapesFull(String text) {
        return this.indexOfAny(text, ESCAPES_FULL);
    }

    private int indexOfEscapesSimple(String text) {
        return this.indexOfAny(text, ESCAPES_SIMPLE);
    }

    private int indexOfAny(String text, char[] escapes) {
        int min = Integer.MAX_VALUE;
        int index = -1;
        if (escapes != null) {
            int length = escapes.length;
            for (int i = 0; i < length; ++i) {
                index = text.indexOf(escapes[i]);
                if (index < 0 || index >= min) continue;
                min = index;
            }
        }
        return min == Integer.MAX_VALUE ? -1 : min;
    }

    @Override
    public boolean write(String text) {
        boolean ejected;
        block13: {
            if (this.job == null) {
                return false;
            }
            if (text == null) {
                return false;
            }
            String partial = null;
            ejected = false;
            text = text.replace('\u0000', ' ');
            try {
                if (this.escapeSequences) {
                    int split = -1;
                    do {
                        if ((split = this.indexOfEscapesFull(text)) >= 0) {
                            try {
                                partial = text.substring(0, split);
                                this.writeText(partial);
                            }
                            catch (Exception partialTextException) {
                                JVM12Driver.log(partialTextException);
                            }
                            text = this.writeEscape(text.substring(split));
                            ejected |= this.ejectOnPageSplit();
                            continue;
                        }
                        this.writeText(text);
                        text = null;
                    } while (split >= 0);
                    break block13;
                }
                int split = -1;
                do {
                    if ((split = this.indexOfEscapesSimple(text)) >= 0) {
                        try {
                            partial = text.substring(0, split);
                            this.writeText(partial);
                        }
                        catch (Exception partialTextException) {
                            JVM12Driver.log(partialTextException);
                        }
                        text = this.writeEscape(text.substring(split));
                        ejected |= this.ejectOnPageSplit();
                        continue;
                    }
                    this.writeText(text);
                    text = null;
                } while (split >= 0);
            }
            catch (Throwable writeException) {
                JVM12Driver.log(writeException);
            }
        }
        return ejected;
    }

    private boolean ejectOnPageSplit() {
        if (this.ypos >= (double)this.pageSplitBoundary) {
            this.eject();
            return true;
        }
        return false;
    }

    public void writeText(String text) {
        if (text == null) {
            return;
        }
        if (text.length() == 0) {
            return;
        }
        if (this.enableGraphics && text.startsWith(this.graphicsTag)) {
            this.drawTextEscapeGraphics(text);
            return;
        }
        this.addPrintQueue(new PrintQueue(this.getTextColor()));
        this.addPrintQueue(new PrintQueue(this.getFont()));
        int x = (int)(this.xpos + (double)this.leftMargin);
        int y = (int)(this.ypos + (double)this.topMargin);
        this.addPrintQueue(new PrintQueue(15, text, x, y));
        this.xpos += (double)this.fontMetrics.stringWidth(text);
    }

    public String writeEscape(String text) {
        if (text == null) {
            return null;
        }
        if (text.length() <= 0) {
            return text;
        }
        switch (text.charAt(0)) {
            case '\t': {
                int int_xpos = (int)this.xpos;
                int int_tabStop = this.tabStop;
                if (int_tabStop > 0) {
                    int_xpos = int_xpos % int_tabStop == 0 ? (int_xpos += int_tabStop) : (int_xpos += int_xpos % int_tabStop);
                    this.xpos = int_xpos;
                }
                if (this.xpos >= (double)this.pageBoundaryX) {
                    this.resetX();
                    this.ypos += this.multiplierYCharacters - (double)this.lineExtend;
                }
                return text.substring(1);
            }
            case '\n': {
                this.ypos += this.multiplierYCharacters - (double)this.lineExtend;
                return text.substring(1);
            }
            case '\r': {
                this.resetX();
                this.ypos += (double)this.lineExtend;
                return text.substring(1);
            }
            case '\u000e': {
                Font currentFont = this.getFont();
                this.addPrintQueue(new PrintQueue(new Font(currentFont.getName(), currentFont.getStyle() | 1, currentFont.getSize())));
                return text.substring(1);
            }
            case '\u000f': {
                Font currentFont = this.getFont();
                this.addPrintQueue(new PrintQueue(new Font(currentFont.getName(), currentFont.getStyle() & 0xFFFFFFFE, currentFont.getSize())));
                return text.substring(1);
            }
            case '\u001b': {
                char value = text.charAt(3);
                switch (text.charAt(1)) {
                    case '&': {
                        switch (text.charAt(2)) {
                            case 'a': {
                                switch (text.charAt(4)) {
                                    case 'L': {
                                        this.leftMargin = (int)((double)BASIC_LEFT_MARGIN + (double)value * this.multiplierXCharacters);
                                    }
                                }
                                return text.substring(4);
                            }
                            case 'k': {
                                switch (text.charAt(4)) {
                                    case 'H': {
                                        this.tabStop = (int)((double)value * this.multiplierXCharacters);
                                    }
                                }
                                return text.substring(4);
                            }
                            case 'l': {
                                switch (text.charAt(4)) {
                                    case 'D': {
                                        this.lineExtend = value;
                                        break;
                                    }
                                    case 'E': {
                                        this.topMargin = (int)((double)value * this.multiplierYCharacters + (double)BASIC_TOP_MARGIN);
                                        break;
                                    }
                                    case 'F': {
                                        break;
                                    }
                                    case 'H': {
                                        break;
                                    }
                                }
                                return text.substring(4);
                            }
                        }
                        return text.substring(3);
                    }
                    case '(': {
                        switch (text.charAt(2)) {
                            case 's': {
                                switch (text.charAt(4)) {
                                    case 'H': {
                                        break;
                                    }
                                    case 'S': {
                                        break;
                                    }
                                    case 'V': {
                                        Font currentFont = this.getFont();
                                        this.addPrintQueue(new PrintQueue(new Font(currentFont.getName(), currentFont.getStyle(), value)));
                                    }
                                }
                                return text.substring(4);
                            }
                        }
                        return text.substring(3);
                    }
                    case '9': {
                        return text.substring(2);
                    }
                    case 'E': {
                        this.clearFont();
                        this.leftMargin = BASIC_LEFT_MARGIN;
                        this.topMargin = BASIC_TOP_MARGIN;
                        return text.substring(2);
                    }
                }
                return text.substring(2);
            }
        }
        return text.substring(1);
    }

    @Override
    public void setLeftMargin(double leftMargin) {
        this.leftMargin = (int)leftMargin + BASIC_LEFT_MARGIN;
    }

    @Override
    public double getLeftMargin() {
        return this.leftMargin - BASIC_LEFT_MARGIN;
    }

    @Override
    public void setBottomMargin(double leftMargin) {
        this.bottomMargin = this.bottomMargin;
    }

    @Override
    public double getBottomMargin() {
        return this.bottomMargin;
    }

    @Override
    public void setTopMargin(double topMargin) {
        boolean reset = false;
        if (topMargin < 0.0) {
            topMargin = -topMargin;
        }
        this.nextTopMargin = (int)topMargin + BASIC_TOP_MARGIN;
        if (reset) {
            this.resetY();
        }
    }

    @Override
    public double getTopMargin() {
        return this.topMargin - BASIC_TOP_MARGIN;
    }

    @Override
    public void setDeviceMode(String attrib, String value) {
        this.setAttribute(attrib, value);
    }

    @Override
    public String getDeviceCapability(String attrib) {
        if ((attrib = this.normalizeAttribute(attrib)) != null) {
            if (attrib.startsWith("TECHNOLOGY")) {
                return "Elastic COBOL JDK 1.2 Driver";
            }
            if (attrib != null && attrib.startsWith("SUPPORTED")) {
                return "11,HORIZONTAL_AREA,VERTICAL_AREA,HORIZONTAL_RESOLUTION,VERTICAL_RESOLUTION,HORIZONTAL_INCHES,VERTICAL_INCHES,PHYSICAL_WIDTH,PHYSICAL_HEIGHT,LOGICAL_PIXELS_X,LOGICAL_PIXELS_Y,TECHNOLOGY";
            }
            if (this.job != null) {
                int pixelsPerInch = 72;
                double pagesize_width = this.pageFormat.getWidth();
                double pagesize_height = this.pageFormat.getHeight();
                if (attrib.startsWith("HORIZONTAL_AREA")) {
                    return String.valueOf(pagesize_width / (this.multiplierXMetric * 10.0));
                }
                if (attrib.startsWith("VERTICAL_AREA")) {
                    return String.valueOf(pagesize_height / (this.multiplierYMetric * 10.0));
                }
                if (attrib.startsWith("HORIZONTAL_RESOLUTION")) {
                    return String.valueOf(pagesize_width);
                }
                if (attrib.startsWith("VERTICAL_RESOLUTION")) {
                    return String.valueOf(pagesize_height);
                }
                if (attrib.startsWith("HORIZONTAL_INCHES")) {
                    return String.valueOf(pagesize_width / this.multiplierXInches);
                }
                if (attrib.startsWith("VERTICAL_INCHES")) {
                    return String.valueOf(pagesize_height / this.multiplierYInches);
                }
                if (attrib.startsWith("PHYSICAL_WIDTH")) {
                    return String.valueOf(pagesize_width / this.multiplierXDeviceUnits);
                }
                if (attrib.startsWith("PHYSICAL_HEIGHT")) {
                    return String.valueOf(pagesize_height / this.multiplierYDeviceUnits);
                }
                if (attrib.startsWith("LOGICAL_PIXELS_X")) {
                    return String.valueOf(pixelsPerInch);
                }
                if (attrib.startsWith("LOGICAL_PIXELS_Y")) {
                    return String.valueOf(pixelsPerInch);
                }
            }
        }
        return this.getAttribute(attrib);
    }

    @Override
    public void setEscapeSequences(boolean state) {
        this.escapeSequences = state;
    }

    @Override
    public String getPrinterInfo(String attrib) {
        attrib = this.normalizeAttribute(attrib);
        return this.getAttribute(attrib);
    }

    @Override
    public void setConnectorThickness(int thickness) {
        if (thickness < 0) {
            thickness = 0;
        }
        this.CONNECTION_THICKNESS = thickness;
    }

    @Override
    public void setConnector(double xpos, double ypos, int type) {
        this.connect((int)xpos, (int)ypos, type);
    }

    public void resetConnectors() {
        this.connectors.setSize(0);
    }

    public void connect(int effectiveX, int effectiveY, int connect) {
        ConnectorNode add = new ConnectorNode(effectiveX, effectiveY, connect);
        this.connectors.addElement(add);
    }

    public void connect(ConnectorNode from, ConnectorNode to) {
        boolean shade;
        int fromX = from.x;
        int fromY = from.y;
        int toX = to.x;
        int toY = to.y;
        int width = (toX += this.leftMargin) - (fromX += this.leftMargin);
        int height = (toY += this.topMargin) - (fromY += this.topMargin);
        if (width < 0) {
            width = -width;
        }
        if (height < 0) {
            height = -height;
        }
        boolean horizontal = false;
        if (fromY == toY) {
            horizontal = true;
        }
        this.addPrintQueue(new PrintQueue(this.getPenColor()));
        int thick = from.connect & 0xF0 | to.connect & 0xF0;
        boolean bl = shade = (thick & 0x10) == 16;
        if ((thick & 0x20) == 32) {
            if (shade) {
                this.addPrintQueue(new PrintQueue(this.getShadeColor()));
            }
            this.addPrintQueue(new PrintQueue(14, fromX, fromY, toX, toY));
            if (shade) {
                this.addPrintQueue(new PrintQueue(this.getPenColor()));
            }
        }
        if ((thick & 0x80) == 128) {
            int arcWidth = this.CONNECTION_THICKNESS;
            int arcHeight = this.CONNECTION_THICKNESS;
            if (shade) {
                this.addPrintQueue(new PrintQueue(this.getShadeColor()));
            }
            if (horizontal) {
                if (shade) {
                    this.addPrintQueue(new PrintQueue(8, fromX - this.CONNECTION_THICKNESS, fromY - this.CONNECTION_THICKNESS, width + this.CONNECTION_THICKNESS * 2, height + this.CONNECTION_THICKNESS * 2, arcWidth, arcHeight));
                    this.addPrintQueue(new PrintQueue(this.getPenColor()));
                }
                this.addPrintQueue(new PrintQueue(9, fromX - this.CONNECTION_THICKNESS, fromY - this.CONNECTION_THICKNESS, width + this.CONNECTION_THICKNESS * 2, height + this.CONNECTION_THICKNESS * 2, arcWidth, arcHeight));
            } else {
                if (shade) {
                    this.addPrintQueue(new PrintQueue(9, fromX - this.CONNECTION_THICKNESS, fromY - this.CONNECTION_THICKNESS, width + this.CONNECTION_THICKNESS * 2, height + this.CONNECTION_THICKNESS * 2, arcWidth, arcHeight));
                    this.addPrintQueue(new PrintQueue(this.getPenColor()));
                }
                this.addPrintQueue(new PrintQueue(9, fromX - this.CONNECTION_THICKNESS, fromY - this.CONNECTION_THICKNESS, width + this.CONNECTION_THICKNESS * 2, height + this.CONNECTION_THICKNESS * 2, arcWidth, arcHeight));
            }
        }
        if ((thick & 0x40) == 64) {
            if (shade) {
                this.addPrintQueue(new PrintQueue(this.getShadeColor()));
            }
            if (horizontal) {
                if (shade) {
                    this.addPrintQueue(new PrintQueue(5, fromX - this.CONNECTION_THICKNESS + 1, fromY - this.CONNECTION_THICKNESS + 1, width + this.CONNECTION_THICKNESS * 2 - 1, height + this.CONNECTION_THICKNESS * 2 - 1));
                    this.addPrintQueue(new PrintQueue(this.getPenColor()));
                }
                this.addPrintQueue(new PrintQueue(7, fromX - this.CONNECTION_THICKNESS, fromY - this.CONNECTION_THICKNESS, width + this.CONNECTION_THICKNESS * 2, height + this.CONNECTION_THICKNESS * 2));
            } else {
                if (shade) {
                    this.addPrintQueue(new PrintQueue(5, fromX - this.CONNECTION_THICKNESS + 1, fromY - this.CONNECTION_THICKNESS + 1, width + this.CONNECTION_THICKNESS * 2 - 1, height + this.CONNECTION_THICKNESS * 2 - 1));
                    this.addPrintQueue(new PrintQueue(this.getPenColor()));
                }
                this.addPrintQueue(new PrintQueue(7, fromX - this.CONNECTION_THICKNESS, fromY - this.CONNECTION_THICKNESS, width + this.CONNECTION_THICKNESS * 2, height + this.CONNECTION_THICKNESS * 2));
            }
        }
    }

    public void realizeConnectors() {
        ConnectorNode toDraw;
        int drawTo;
        int draw;
        int cSize;
        ConnectorNode cand;
        int k;
        int candidateSize;
        int j;
        int i;
        int size = this.connectors.size();
        ConnectorNode base = null;
        ConnectorNode check = null;
        Vector<ConnectorNode> candidate = new Vector<ConnectorNode>();
        for (i = 0; i < size - 1; ++i) {
            base = this.connector(i);
            if ((base.connect & 0xC) == 0) continue;
            candidate.setSize(0);
            candidate.addElement(base);
            for (j = i + 1; j < size; ++j) {
                check = this.connector(j);
                if (check.x != base.x || (check.connect & 0xC) == 0) continue;
                candidateSize = candidate.size();
                boolean inserted = false;
                for (k = 0; k < candidateSize; ++k) {
                    cand = (ConnectorNode)candidate.elementAt(k);
                    if (cand.y <= check.y) continue;
                    candidate.insertElementAt(check, k);
                    inserted = true;
                    break;
                }
                if (inserted) continue;
                candidate.addElement(check);
            }
            cSize = candidate.size();
            block3: for (draw = 0; draw < cSize; ++draw) {
                ConnectorNode baseDraw = (ConnectorNode)candidate.elementAt(draw);
                if ((baseDraw.connect & 8) != 8) continue;
                for (drawTo = draw + 1; drawTo < cSize; ++drawTo) {
                    toDraw = (ConnectorNode)candidate.elementAt(drawTo);
                    if ((toDraw.connect & 4) != 4) continue;
                    baseDraw.connect &= 0xFFFFFFF7;
                    toDraw.connect &= 0xFFFFFFFB;
                    this.connect(baseDraw, toDraw);
                    continue block3;
                }
            }
        }
        base = null;
        check = null;
        candidate.setSize(0);
        for (i = 0; i < size - 1; ++i) {
            base = this.connector(i);
            if ((base.connect & 3) == 0) continue;
            candidate.setSize(0);
            candidate.addElement(base);
            for (j = i + 1; j < size; ++j) {
                check = this.connector(j);
                if (check.y != base.y || (check.connect & 3) == 0) continue;
                candidateSize = candidate.size();
                boolean inserted = false;
                for (k = 0; k < candidateSize; ++k) {
                    cand = (ConnectorNode)candidate.elementAt(k);
                    if (cand.x <= check.x) continue;
                    candidate.insertElementAt(check, k);
                    inserted = true;
                    break;
                }
                if (inserted) continue;
                candidate.addElement(check);
            }
            cSize = candidate.size();
            block8: for (draw = 0; draw < cSize; ++draw) {
                ConnectorNode baseDraw = (ConnectorNode)candidate.elementAt(draw);
                if ((baseDraw.connect & 2) != 2) continue;
                for (drawTo = draw + 1; drawTo < cSize; ++drawTo) {
                    toDraw = (ConnectorNode)candidate.elementAt(drawTo);
                    if ((toDraw.connect & 1) != 1) continue;
                    baseDraw.connect &= 0xFFFFFFFD;
                    toDraw.connect &= 0xFFFFFFFE;
                    this.connect(baseDraw, toDraw);
                    continue block8;
                }
            }
        }
        this.resetConnectors();
    }

    public ConnectorNode connector(int i) {
        try {
            return this.connectors.elementAt(i);
        }
        catch (Exception e) {
            JVM12Driver.log(e);
            return null;
        }
    }

    @Override
    public void setXORMode(Color c) {
        this.addPrintQueue(new PrintQueue(21, c));
    }

    @Override
    public void setPaintMode() {
        this.addPrintQueue(new PrintQueue(20));
    }

    private final String drawTextEscapeGraphics(String drawLine) {
        int x = (int)this.xpos;
        int y = (int)this.ypos;
        if (this.enableGraphics && drawLine != null && drawLine.startsWith(this.graphicsTag)) {
            StringTokenizer st = new StringTokenizer(drawLine.substring(5), "\t\n\r(),:; ");
            String token = null;
            token = st.nextToken();
            if (token == null) {
                token = st.nextToken();
            }
            String[] param = new String[8];
            int[] intParam = new int[8];
            String paramToken = null;
            for (int paramCounter = 0; st.hasMoreTokens() && paramCounter < 8; ++paramCounter) {
                param[paramCounter] = paramToken = st.nextToken();
                if (paramToken == null || paramToken.length() <= 0) continue;
                try {
                    paramToken = paramToken.trim();
                    if (paramToken.equals("<X>")) {
                        intParam[paramCounter] = x;
                        continue;
                    }
                    if (paramToken.equals("<Y>")) {
                        intParam[paramCounter] = y;
                        continue;
                    }
                    char tokenModifier = paramToken.charAt(0);
                    switch (tokenModifier) {
                        case 'R': 
                        case 'r': {
                            intParam[paramCounter] = this.translatey + this.aligny + (int)((double)(ConvertData.parseInt(paramToken.substring(1).trim()) + 1) * this.printerFontMetricHeight);
                            break;
                        }
                        case 'C': 
                        case 'c': {
                            intParam[paramCounter] = this.translatex + this.alignx + ConvertData.parseInt(paramToken.substring(1).trim()) * this.printerFontWidth;
                            break;
                        }
                        default: {
                            intParam[paramCounter] = ConvertData.parseInt(paramToken.trim());
                        }
                    }
                    continue;
                }
                catch (Throwable individualParameter) {
                    JVM12Driver.log(individualParameter);
                }
            }
            if (token != null) {
                if ((token = token.toUpperCase()).equals("CLEARRECT") || token.equals("CLEAR")) {
                    this.addPrintQueue(new PrintQueue(16, intParam[0], intParam[1], intParam[2], intParam[3]));
                } else if (token.equals("CLIPRECT") || token.equals("CLIP")) {
                    this.addPrintQueue(new PrintQueue(17, intParam[0], intParam[1], intParam[2], intParam[3]));
                } else if (token.equals("COPYAREA") || token.equals("COPY")) {
                    this.addPrintQueue(new PrintQueue(18, intParam[0], intParam[1], intParam[2], intParam[3], intParam[4], intParam[5]));
                } else if (token.equals("DRAW3DRECT") || token.equals("3DRECT")) {
                    this.addPrintQueue(new PrintQueue(6, intParam[0], intParam[1], intParam[2], intParam[3], intParam[4] != 0));
                } else if (token.equals("DRAWARC") || token.equals("ARC")) {
                    this.addPrintQueue(new PrintQueue(13, intParam[0], intParam[1], intParam[2], intParam[3], intParam[4], intParam[5]));
                } else if (token.equals("DRAWLINE") || token.equals("LINE")) {
                    this.addPrintQueue(new PrintQueue(14, intParam[0], intParam[1], intParam[2], intParam[3]));
                } else if (token.equals("DRAWOVAL") || token.equals("OVAL")) {
                    this.addPrintQueue(new PrintQueue(22, intParam[0], intParam[1], intParam[2], intParam[3]));
                } else if (token.equals("DRAWRECT") || token.equals("RECT") || token.equals("RECTANGLE")) {
                    this.addPrintQueue(new PrintQueue(7, intParam[0], intParam[1], intParam[2], intParam[3]));
                } else if (token.equals("DRAWROUNDRECT") || token.equals("ROUNDRECT") || token.equals("ROUNDRECTANGLE")) {
                    this.addPrintQueue(new PrintQueue(9, intParam[0], intParam[1], intParam[2], intParam[3], intParam[4], intParam[5]));
                } else if (token.equals("DRAWSTRING") || token.equals("STRING") || token.equals("TEXT")) {
                    this.addPrintQueue(new PrintQueue(15, param[0], intParam[1], intParam[2]));
                } else if (token.equals("FILL3DRECT") || token.equals("FILL3DRECTANGLE")) {
                    this.addPrintQueue(new PrintQueue(4, intParam[0], intParam[1], intParam[2], intParam[3], intParam[4] != 0));
                } else if (token.equals("FILLARC")) {
                    this.addPrintQueue(new PrintQueue(12, intParam[0], intParam[1], intParam[2], intParam[3], intParam[4], intParam[5]));
                } else if (token.equals("FILLOVAL")) {
                    this.addPrintQueue(new PrintQueue(10, intParam[0], intParam[1], intParam[2], intParam[3]));
                } else if (token.equals("FILLRECT") || token.equals("FILLRECTANGLE")) {
                    this.addPrintQueue(new PrintQueue(5, intParam[0], intParam[1], intParam[2], intParam[3]));
                } else if (token.equals("FILLROUNDRECT") || token.equals("FILLROUNDRECTANGLE")) {
                    this.addPrintQueue(new PrintQueue(8, intParam[0], intParam[1], intParam[2], intParam[3], intParam[4], intParam[5]));
                } else if (token.equals("FONT")) {
                    this.addPrintQueue(new PrintQueue(Font.decode(param[0])));
                } else if (token.equals("PAINTMODE") || token.equals("PAINT")) {
                    this.addPrintQueue(new PrintQueue(20));
                } else if (token.equals("XORMODE") || token.equals("XOR")) {
                    this.addPrintQueue(new PrintQueue(21, ColorProvider.getColor(param[0])));
                } else if (token.equals("COLOR")) {
                    this.addPrintQueue(new PrintQueue(ColorProvider.getColor(param[0])));
                } else if (token.equals("TRANSLATE")) {
                    this.addPrintQueue(new PrintQueue(19, intParam[0], intParam[1]));
                } else if (!token.equals("SETLINE")) {
                    if (token.equals("DRAWIMAGE") || token.equals("IMAGE")) {
                        try {
                            this.addPrintQueue(new PrintQueue(2, MediaImage.getImage(param[0]), intParam[1], intParam[2], intParam[3], intParam[4]));
                        }
                        catch (Exception e) {
                            JVM12Driver.log(e);
                        }
                    } else {
                        return drawLine;
                    }
                }
                return null;
            }
        }
        return drawLine;
    }

    @Override
    public String command(String command) {
        try {
            StringTokenizer st = new StringTokenizer(command.trim());
            if (st.hasMoreTokens()) {
                String y;
                String x;
                String name = st.nextToken().trim().toUpperCase();
                if (name.equals("SCALE")) {
                    x = null;
                    y = null;
                    if (st.hasMoreTokens()) {
                        x = st.nextToken().trim();
                        if (st.hasMoreTokens()) {
                            y = st.nextToken().trim();
                            this.addPrintQueue(new PrintQueue(25, new Double(x), new Double(y), 0.0));
                        }
                    }
                } else if (name.equals("SHEAR")) {
                    x = null;
                    y = null;
                    if (st.hasMoreTokens()) {
                        x = st.nextToken().trim();
                        if (st.hasMoreTokens()) {
                            y = st.nextToken().trim();
                            this.addPrintQueue(new PrintQueue(24, new Double(x), new Double(y), 0.0));
                        }
                    }
                } else if (name.equals("ROTATE") || name.equals("ROTATE3")) {
                    x = null;
                    y = null;
                    String z = null;
                    if (st.hasMoreTokens()) {
                        x = st.nextToken().trim();
                        if (st.hasMoreTokens()) {
                            y = st.nextToken().trim();
                            if (st.hasMoreTokens()) {
                                z = st.nextToken().trim();
                                this.addPrintQueue(new PrintQueue(27, new Double(x), new Double(y), new Double(z)));
                            }
                        } else {
                            this.addPrintQueue(new PrintQueue(26, new Double(x), 0.0, 0.0));
                        }
                    }
                } else if (name.equals("TRANSFORM")) {
                    try {
                        String m0 = st.nextToken().trim();
                        String m1 = st.nextToken().trim();
                        String m2 = st.nextToken().trim();
                        String m3 = st.nextToken().trim();
                        String m4 = st.nextToken().trim();
                        String m5 = st.nextToken().trim();
                        this.addPrintQueue(new PrintQueue(28, new Double(m0), new Double(m1), new Double(m2), new Double(m3), new Double(m4), new Double(m5)));
                    }
                    catch (Throwable t) {
                        JVM12Driver.log(t);
                    }
                }
            }
            while (st.hasMoreTokens()) {
            }
        }
        catch (Throwable t) {
            JVM12Driver.log(t);
            return t.toString();
        }
        return " ";
    }

    private static class ConnectorNode {
        public int x;
        public int y;
        public int connect;

        public String toString() {
            return "(" + this.x + "," + this.y + ":" + this.connect + ")";
        }

        public ConnectorNode(int x, int y, int connect) {
            this.x = x;
            this.y = y;
            this.connect = connect;
        }
    }

    private static class PrintQueue {
        private int op;
        private Object object;
        private Object secondObject;
        private int x1;
        private int x2;
        private int y1;
        private int y2;
        private int start;
        private int end;
        private boolean bool;
        private double f1;
        private double f2;
        private double f3;
        private double f4;
        private double f5;
        private double f6;

        public String opcode() {
            switch (this.op) {
                case 0: {
                    return "COLOR";
                }
                case 1: {
                    return "FONT";
                }
                case 2: {
                    return "IMAGE";
                }
                case 3: {
                    return "COMPONENT";
                }
                case 4: {
                    return "FILL3DRECT";
                }
                case 5: {
                    return "FILLRECT";
                }
                case 6: {
                    return "DRAW3DRECT";
                }
                case 7: {
                    return "DRAWRECT";
                }
                case 8: {
                    return "FILLROUNDRECT";
                }
                case 9: {
                    return "DRAWROUNDRECT";
                }
                case 10: {
                    return "FILLOVAL";
                }
                case 12: {
                    return "FILLARC";
                }
                case 13: {
                    return "DRAWARC";
                }
                case 14: {
                    return "DRAWLINE";
                }
                case 15: {
                    return "DRAWSTRING";
                }
                case 16: {
                    return "CLEARRECT";
                }
                case 17: {
                    return "CLIPRECT";
                }
                case 18: {
                    return "COPYAREA";
                }
                case 19: {
                    return "TRANSLATE";
                }
                case 20: {
                    return "PAINTMODE";
                }
                case 21: {
                    return "XORMODE";
                }
                case 22: {
                    return "DRAWOVAL";
                }
                case 23: {
                    return "SETSTROKE";
                }
                case 24: {
                    return "SHEAR";
                }
                case 25: {
                    return "SCALE";
                }
                case 26: {
                    return "ROTATE";
                }
                case 27: {
                    return "ROTATE3";
                }
                case 28: {
                    return "TRANSFORM";
                }
            }
            return "";
        }

        public String toString() {
            return "{" + this.opcode() + ": object='" + this.object + "', second='" + this.secondObject + "', x1=" + this.x1 + ", y1=" + this.y1 + ", x2=" + this.x2 + ", y2=" + this.y2 + ", start=" + this.start + ", end=" + this.end + ", bool=" + this.bool + "}";
        }

        public PrintQueue(Color c) {
            this.op = 0;
            this.object = c;
        }

        public PrintQueue(Font f) {
            this.op = 1;
            this.object = f;
        }

        public PrintQueue(int op) {
            this.op = op;
        }

        public PrintQueue(int op, Object object) {
            this.op = op;
            this.object = object;
        }

        public PrintQueue(int op, Object object, int x1, int y1) {
            this.op = op;
            this.object = object;
            this.x1 = x1;
            this.y1 = y1;
        }

        public PrintQueue(int op, int x1, int y1) {
            this.op = op;
            this.x1 = x1;
            this.y1 = y1;
        }

        public PrintQueue(int op, Object object, int x1, int y1, Object secondObject) {
            this.op = op;
            this.object = object;
            this.x1 = x1;
            this.y1 = y1;
            this.secondObject = secondObject;
        }

        public PrintQueue(int op, int x1, int y1, int x2, int y2) {
            this.op = op;
            this.x1 = x1;
            this.y1 = y1;
            this.x2 = x2;
            this.y2 = y2;
        }

        public PrintQueue(int op, Object object, int x1, int y1, int x2, int y2) {
            this.op = op;
            this.x1 = x1;
            this.y1 = y1;
            this.x2 = x2;
            this.y2 = y2;
            this.object = object;
        }

        public PrintQueue(int op, Object object, int x1, int y1, int x2, int y2, Object secondObject) {
            this.op = op;
            this.x1 = x1;
            this.y1 = y1;
            this.x2 = x2;
            this.y2 = y2;
            this.object = object;
            this.secondObject = secondObject;
        }

        public PrintQueue(int op, int x1, int y1, int x2, int y2, boolean bool) {
            this.op = op;
            this.x1 = x1;
            this.y1 = y1;
            this.x2 = x2;
            this.y2 = y2;
            this.bool = bool;
        }

        public PrintQueue(int op, int x1, int y1, int x2, int y2, int start, int end) {
            this.op = op;
            this.x1 = x1;
            this.y1 = y1;
            this.x2 = x2;
            this.y2 = y2;
            this.start = start;
            this.end = end;
        }

        public PrintQueue(int op, double f1, double f2, double f3) {
            this.op = op;
            this.f1 = f1;
            this.f2 = f2;
            this.f3 = f3;
        }

        public PrintQueue(int op, double f1, double f2, double f3, double f4, double f5, double f6) {
            this.op = op;
            this.f1 = f1;
            this.f2 = f2;
            this.f3 = f3;
            this.f4 = f4;
            this.f5 = f5;
            this.f6 = f6;
        }

        public void print(Graphics g) {
            try {
                block1 : switch (this.op) {
                    case 0: {
                        g.setColor((Color)this.object);
                        break;
                    }
                    case 1: {
                        g.setFont((Font)this.object);
                        break;
                    }
                    case 2: {
                        if (this.x2 <= 0 && this.y2 <= 0) {
                            g.drawImage((Image)this.object, this.x1, this.y1, Color.white, null);
                            break;
                        }
                        g.drawImage((Image)this.object, this.x1, this.y1, this.x2, this.y2, Color.white, null);
                        break;
                    }
                    case 3: {
                        Graphics componentGraphics = g.create(this.x1, this.y1, this.x2, this.y2);
                        componentGraphics.setFont(g.getFont());
                        componentGraphics.setColor(g.getColor());
                        ((Component)this.object).printAll(componentGraphics);
                        break;
                    }
                    case 4: {
                        g.fill3DRect(this.x1, this.y1, this.x2, this.y2, this.bool);
                        break;
                    }
                    case 5: {
                        g.fillRect(this.x1, this.y1, this.x2, this.y2);
                        break;
                    }
                    case 6: {
                        g.draw3DRect(this.x1, this.y1, this.x2, this.y2, this.bool);
                        break;
                    }
                    case 7: {
                        g.drawRect(this.x1, this.y1, this.x2, this.y2);
                        break;
                    }
                    case 8: {
                        g.fillRoundRect(this.x1, this.y1, this.x2, this.y2, this.start, this.end);
                        break;
                    }
                    case 9: {
                        g.drawRoundRect(this.x1, this.y1, this.x2, this.y2, this.start, this.end);
                        break;
                    }
                    case 10: {
                        g.fillOval(this.x1, this.y1, this.x2, this.y2);
                        break;
                    }
                    case 12: {
                        g.fillArc(this.x1, this.y1, this.x2, this.y2, this.start, this.end);
                        break;
                    }
                    case 13: {
                        g.drawArc(this.x1, this.y1, this.x2, this.y2, this.start, this.end);
                        break;
                    }
                    case 14: {
                        g.drawLine(this.x1, this.y1, this.x2, this.y2);
                        break;
                    }
                    case 15: {
                        g.drawString(String.valueOf(this.object), this.x1, this.y1);
                        break;
                    }
                    case 16: {
                        g.clearRect(this.x1, this.y1, this.x2, this.y2);
                        break;
                    }
                    case 17: {
                        g.clipRect(this.x1, this.y1, this.x2, this.y2);
                        break;
                    }
                    case 18: {
                        g.copyArea(this.x1, this.y1, this.x2, this.y2, this.start, this.end);
                        break;
                    }
                    case 19: {
                        g.translate(this.x1, this.y1);
                        break;
                    }
                    case 20: {
                        g.setPaintMode();
                        break;
                    }
                    case 21: {
                        g.setXORMode((Color)this.object);
                        break;
                    }
                    case 22: {
                        g.drawOval(this.x1, this.y1, this.x2, this.y2);
                        break;
                    }
                    case 23: {
                        switch ((int)this.f2) {
                            case 0: {
                                ((Graphics2D)g).setStroke(new BasicStroke((float)this.f1));
                                break block1;
                            }
                            case 1: {
                                ((Graphics2D)g).setStroke(new BasicStroke((float)this.f1, 2, 0, 10.0f, DASH_LINE, 0.0f));
                                break block1;
                            }
                            case 2: {
                                ((Graphics2D)g).setStroke(new BasicStroke((float)this.f1, 2, 0, 10.0f, DOT_LINE, 0.0f));
                                break block1;
                            }
                            case 3: {
                                ((Graphics2D)g).setStroke(new BasicStroke((float)this.f1, 2, 0, 10.0f, DASH_DOT_LINE, 0.0f));
                                break block1;
                            }
                            case 4: {
                                ((Graphics2D)g).setStroke(new BasicStroke((float)this.f1, 2, 0, 10.0f, DASH_DOT_DOT_LINE, 0.0f));
                                break block1;
                            }
                        }
                        break;
                    }
                    case 24: {
                        ((Graphics2D)g).shear(this.f1, this.f2);
                        break;
                    }
                    case 25: {
                        ((Graphics2D)g).scale(this.f1, this.f2);
                        break;
                    }
                    case 26: {
                        ((Graphics2D)g).rotate(this.f1);
                        break;
                    }
                    case 27: {
                        ((Graphics2D)g).rotate(this.f1, this.f2, this.f3);
                        break;
                    }
                    case 28: {
                        ((Graphics2D)g).transform(new AffineTransform(this.f1, this.f2, this.f3, this.f4, this.f5, this.f6));
                    }
                }
            }
            catch (Throwable renderingException) {
                JVM12Driver.log(renderingException);
            }
        }
    }
}

