/*
 * Decompiled with CFR 0.152.
 */
package com.heirloomcomputing.ecs.print;

import com.heirloomcomputing.ecs.api.IGenericPrinter;
import com.heirloomcomputing.ecs.exec.ColorProvider;
import com.heirloomcomputing.ecs.exec.ConvertData;
import com.heirloomcomputing.ecs.exec.MediaImage;
import com.heirloomcomputing.ecs.exec.Semaphore;
import com.heirloomcomputing.ecs.exec.Shutdown;
import com.heirloomcomputing.ecs.exec.ThreadQueue;
import com.heirloomcomputing.ecs.util.Utils;
import java.awt.BasicStroke;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.print.Doc;
import javax.print.DocFlavor;
import javax.print.DocPrintJob;
import javax.print.PrintException;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.attribute.DocAttributeSet;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.print.attribute.standard.Chromaticity;
import javax.print.attribute.standard.ColorSupported;
import javax.print.attribute.standard.Copies;
import javax.print.attribute.standard.Destination;
import javax.print.attribute.standard.Fidelity;
import javax.print.attribute.standard.Finishings;
import javax.print.attribute.standard.JobImpressions;
import javax.print.attribute.standard.JobKOctets;
import javax.print.attribute.standard.JobMediaSheets;
import javax.print.attribute.standard.JobName;
import javax.print.attribute.standard.JobPriority;
import javax.print.attribute.standard.JobSheets;
import javax.print.attribute.standard.MediaPrintableArea;
import javax.print.attribute.standard.MediaSize;
import javax.print.attribute.standard.MediaSizeName;
import javax.print.attribute.standard.MediaTray;
import javax.print.attribute.standard.MultipleDocumentHandling;
import javax.print.attribute.standard.NumberUp;
import javax.print.attribute.standard.OrientationRequested;
import javax.print.attribute.standard.PDLOverrideSupported;
import javax.print.attribute.standard.PageRanges;
import javax.print.attribute.standard.PagesPerMinute;
import javax.print.attribute.standard.PagesPerMinuteColor;
import javax.print.attribute.standard.PresentationDirection;
import javax.print.attribute.standard.PrintQuality;
import javax.print.attribute.standard.PrinterInfo;
import javax.print.attribute.standard.PrinterIsAcceptingJobs;
import javax.print.attribute.standard.PrinterLocation;
import javax.print.attribute.standard.PrinterMakeAndModel;
import javax.print.attribute.standard.PrinterMessageFromOperator;
import javax.print.attribute.standard.PrinterMoreInfo;
import javax.print.attribute.standard.PrinterMoreInfoManufacturer;
import javax.print.attribute.standard.PrinterName;
import javax.print.attribute.standard.PrinterState;
import javax.print.attribute.standard.PrinterStateReasons;
import javax.print.attribute.standard.PrinterURI;
import javax.print.attribute.standard.QueuedJobCount;
import javax.print.attribute.standard.RequestingUserName;
import javax.print.attribute.standard.SheetCollate;
import javax.print.attribute.standard.Sides;
import javax.print.event.PrintJobEvent;
import javax.print.event.PrintJobListener;

public class JVM14Driver
implements IGenericPrinter,
Printable,
PrintJobListener {
    private static final double INCHES_PER_CM = 0.3937;
    private static float DASH_LENGTH = 4.0f;
    private static float DOT_LENGTH = 1.0f;
    private static float SPACE_LENGTH = 1.0f;
    public static float[] DASH_LINE = new float[]{DASH_LENGTH, SPACE_LENGTH};
    public static float[] DOT_LINE = new float[]{DOT_LENGTH, SPACE_LENGTH};
    public static float[] DASH_DOT_LINE = new float[]{DASH_LENGTH, SPACE_LENGTH, DOT_LENGTH, SPACE_LENGTH};
    public static float[] DASH_DOT_DOT_LINE = new float[]{DASH_LENGTH, SPACE_LENGTH, DOT_LENGTH, SPACE_LENGTH, DASH_LENGTH, SPACE_LENGTH};
    private static Hashtable<String, String> attributes = new Hashtable();
    public double multiplierXInches = 1.0;
    public double multiplierXMetric = 1.0;
    public double multiplierXCharacters = 1.0;
    public double multiplierXDeviceUnits = 0.12;
    public double multiplierYInches = 1.0;
    public double multiplierYMetric = 1.0;
    public double multiplierYCharacters = 1.0;
    public double multiplierYDeviceUnits = 0.12;
    public static int BASIC_LEFT_MARGIN = 12;
    public static int BASIC_TOP_MARGIN = 12;
    public static int BASIC_BOTTOM_MARGIN = 12;
    private PrintService service = null;
    private final PrintRequestAttributeSet aset = new HashPrintRequestAttributeSet();
    private int defaultTopMargin = BASIC_TOP_MARGIN;
    private int defaultLeftMargin = BASIC_LEFT_MARGIN;
    private int defaultBottomMargin = BASIC_BOTTOM_MARGIN;
    private int leftMargin = this.defaultLeftMargin;
    private int topMargin = this.defaultTopMargin;
    private int nextTopMargin = this.defaultTopMargin;
    private int bottomMargin = this.defaultBottomMargin;
    private boolean open;
    private double xpos = BASIC_LEFT_MARGIN;
    private double ypos = BASIC_TOP_MARGIN;
    private double lineFromX = BASIC_LEFT_MARGIN;
    private double lineFromY = BASIC_TOP_MARGIN;
    private boolean fontUnderline;
    private boolean fontStrikeOut;
    private boolean fontDoubleStrike;
    private DocPrintJob job;
    private PrinterJob printerJob;
    private int printerFontHeight;
    private int printerFontWidth;
    private double printerFontMetricHeight;
    private int printerPageLength = 66;
    private int cols = 80;
    private int rows = -1;
    private int alignx;
    private int aligny;
    private boolean escapeSequences;
    private int tabStop = 60;
    private Color textColor = Color.black;
    private Color penColor;
    private Color shadeColor = Color.lightGray;
    private int lineExtend = 0;
    private Font font;
    private Font defaultFont;
    private FontMetrics fontMetrics;
    private int fontAscent = 0;
    private int fontDescent = 0;
    private boolean enableGraphics;
    private String graphicsTag = "<GFX>";
    private int CONNECTION_THICKNESS = 1;
    private final Vector<ConnectorNode> connectors = new Vector();
    private int previousPageIndex = -1;
    private int pageIndex = 0;
    private int lastPageIndex = -1;
    private int pageBoundaryX;
    private int pageBoundaryY;
    private static final char[] ESCAPES_FULL = new char[]{'\t', '\n', '\r', '\u000e', '\u000f', '\u001b'};
    private static final char[] ESCAPES_SIMPLE = new char[]{'\n', '\r'};
    private int pageSplitBoundary = this.pageBoundaryY - this.bottomMargin - this.topMargin;
    private final Semaphore ejectObject = new Semaphore();
    private final Semaphore openedObject = new Semaphore();
    private final Vector<Vector<PrintQueue>> printQueue = new Vector();
    private Component component;
    private boolean canceled;
    public static final int COLOR = 0;
    public static final int FONT = 1;
    public static final int IMAGE = 2;
    public static final int COMPONENT = 3;
    public static final int FILL3DRECT = 4;
    public static final int FILLRECT = 5;
    public static final int DRAW3DRECT = 6;
    public static final int DRAWRECT = 7;
    public static final int FILLROUNDRECT = 8;
    public static final int DRAWROUNDRECT = 9;
    public static final int FILLOVAL = 10;
    public static final int FILLARC = 12;
    public static final int DRAWARC = 13;
    public static final int DRAWLINE = 14;
    public static final int DRAWSTRING = 15;
    public static final int CLEARRECT = 16;
    public static final int CLIPRECT = 17;
    public static final int COPYAREA = 18;
    public static final int TRANSLATE = 19;
    public static final int PAINTMODE = 20;
    public static final int XORMODE = 21;
    public static final int DRAWOVAL = 22;
    public static final int SETSTROKE = 23;
    public static final int SHEAR = 24;
    public static final int SCALE = 25;
    public static final int ROTATE = 26;
    public static final int ROTATE3 = 27;
    public static final int TRANSFORM = 28;
    public static final int DMBIN_ONLYONE = 1;
    public static final int DMBIN_LOWER = 2;
    public static final int DMBIN_MIDDLE = 3;
    public static final int DMBIN_MANUAL = 4;
    public static final int DMBIN_ENVELOPE = 5;
    public static final int DMBIN_ENVMANUAL = 6;
    public static final int DMBIN_AUTO = 7;
    public static final int DMBIN_TRACTOR = 8;
    public static final int DMBIN_SMALLFMT = 9;
    public static final int DMBIN_LARGEFMT = 10;
    public static final int DMBIN_LARGECAPACITY = 11;
    public static final int DMBIN_CASSETTE = 14;
    public static final int DMBIN_FORMSOURCE = 15;

    @Override
    public void printDataTransferCompleted(PrintJobEvent event) {
    }

    @Override
    public void printJobCanceled(PrintJobEvent event) {
        this.canceled = true;
    }

    @Override
    public void printJobCompleted(PrintJobEvent event) {
    }

    @Override
    public void printJobFailed(PrintJobEvent event) {
    }

    @Override
    public void printJobNoMoreEvents(PrintJobEvent event) {
    }

    @Override
    public void printJobRequiresAttention(PrintJobEvent event) {
    }

    private static void log(String s) {
    }

    private static void log(Throwable t) {
    }

    private void resetX() {
        this.xpos = 0.0;
    }

    private void resetY() {
        this.topMargin = this.nextTopMargin;
        this.leftMargin = this.defaultLeftMargin;
        this.bottomMargin = this.defaultBottomMargin;
        this.ypos = this.multiplierYCharacters * 2.0;
        this.pageSplitBoundary = this.pageBoundaryY - this.bottomMargin - this.topMargin;
    }

    @Override
    public Component getComponent() {
        try {
            if (this.component == null) {
                this.component = new Canvas();
            }
        }
        catch (Throwable t) {
            JVM14Driver.log(t);
        }
        return this.component;
    }

    private void clearPrintQueue(int pageIndex) {
        if (pageIndex < 0) {
            return;
        }
        int size = this.printQueue.size();
        if (pageIndex < size) {
            try {
                Vector<PrintQueue> pageQueue = this.printQueue.elementAt(pageIndex);
                if (pageQueue != null) {
                    pageQueue.setSize(0);
                }
            }
            catch (Throwable t) {
                JVM14Driver.log(t);
            }
            this.printQueue.setElementAt(null, pageIndex);
        }
    }

    private void renderPrintQueue(Graphics page, int pageIndex) {
        try {
            Vector<PrintQueue> pageQueue;
            if (pageIndex < 0) {
                return;
            }
            this.clearPrintQueue(pageIndex - 1);
            int size = this.printQueue.size();
            if (pageIndex < size && (pageQueue = this.printQueue.elementAt(pageIndex)) != null) {
                size = pageQueue.size();
                for (int i = 0; i < size; ++i) {
                    try {
                        PrintQueue element = pageQueue.elementAt(i);
                        element.print(page);
                        continue;
                    }
                    catch (Throwable renderingException) {
                        JVM14Driver.log(renderingException);
                    }
                }
            }
        }
        catch (Throwable t) {
            JVM14Driver.log(t);
        }
    }

    private void addPrintQueue(PrintQueue item) {
        if (!this.open) {
            return;
        }
        this.waitForPage();
        Vector<PrintQueue> pageQueue = null;
        try {
            int size = this.printQueue.size();
            if (this.pageIndex < size) {
                pageQueue = this.printQueue.elementAt(this.pageIndex);
            } else {
                this.printQueue.setSize(this.pageIndex + 1);
            }
            if (pageQueue == null) {
                pageQueue = new Vector();
                this.printQueue.setElementAt(pageQueue, this.pageIndex);
            }
        }
        catch (Throwable t) {
            JVM14Driver.log(t);
        }
        if (pageQueue != null) {
            pageQueue.addElement(item);
        }
    }

    private boolean isEmptyJob() {
        return this.job == null && this.printerJob == null;
    }

    private void waitForPage() {
        if (this.isEmptyJob()) {
            return;
        }
        if (this.canceled) {
            throw new RuntimeException("Print Job Canceled");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int pageIndex) {
        if (this.defaultFont != null) {
            graphics.setFont(this.defaultFont);
        }
        if (pageIndex == this.previousPageIndex) {
            this.renderPrintQueue(graphics, pageIndex);
            return 0;
        }
        this.previousPageIndex = pageIndex;
        if (pageIndex == this.lastPageIndex) {
            this.renderPrintQueue(graphics, pageIndex);
            return 1;
        }
        try {
            Semaphore semaphore = this.ejectObject;
            synchronized (semaphore) {
                this.ejectObject.acquire();
                this.renderPrintQueue(graphics, pageIndex);
            }
        }
        catch (Throwable t) {
            JVM14Driver.log(t);
            return 1;
        }
        return 0;
    }

    @Override
    public void clearDialog() {
        attributes.clear();
        this.aset.clear();
    }

    private PrintService getService() {
        if (this.service == null) {
            this.setPrinter(null);
        }
        return this.service;
    }

    @Override
    public boolean displayDialog() {
        if (this.job != null) {
            return false;
        }
        try {
            return this.displayDialog(this.getService());
        }
        catch (PrinterException e) {
            return false;
        }
    }

    public boolean displayDialog(PrintService service) throws PrinterException {
        if (this.printerJob == null) {
            this.printerJob = PrinterJob.getPrinterJob();
            if (this.printerJob == null) {
                return false;
            }
            if (service != null) {
                this.printerJob.setPrintService(service);
            }
        }
        return this.printerJob.printDialog(this.aset);
    }

    @Override
    public String getDialog(String attribute) {
        if ((attribute = this.normalizeAttribute(attribute)) != null && attribute.startsWith("SUPPORTED")) {
            return "3,COPIES";
        }
        return this.getAttribute(attribute);
    }

    @Override
    public void setDialog(String attribute, String value) {
        attribute = this.normalizeAttribute(attribute);
        this.setAttribute(attribute, value);
    }

    private String normalizeAttribute(String name) {
        return name != null ? name.trim().toUpperCase().replace('-', '_').replace(' ', '_') : null;
    }

    public String getAttribute(String name) {
        if (name != null) {
            name = this.normalizeAttribute(name);
            try {
                String value = attributes.get(name);
                if (value != null) {
                    return value;
                }
            }
            catch (Exception cachedValues) {
                JVM14Driver.log(cachedValues);
            }
            if (this.aset != null) {
                // empty if block
            }
        }
        return null;
    }

    public void setAttribute(String name, String value) {
        if (name == null) {
            return;
        }
        name = this.normalizeAttribute(name);
        if (value != null && (value = value.trim()).length() == 0) {
            value = null;
        }
        if (value == null) {
            attributes.remove(name);
            return;
        }
        if ("CHROMATICITY".equals(name) || "COLOR_APPEARANCE".equals(name)) {
            if ("REMOVE".equalsIgnoreCase(value)) {
                this.aset.remove(Chromaticity.class);
            } else if (!"DEFAULT".equalsIgnoreCase(value)) {
                switch (value.charAt(0)) {
                    case '0': 
                    case 'M': 
                    case 'm': {
                        this.aset.add(Chromaticity.MONOCHROME);
                        break;
                    }
                    case '1': 
                    case 'C': 
                    case 'c': {
                        this.aset.add(Chromaticity.COLOR);
                    }
                }
            }
        } else if ("COPIES".equals(name) || "PRINT_DIALOG_COPIES".equals(name) || "DEVICE_MODE_COPIES".equals(name)) {
            if ("REMOVE".equalsIgnoreCase(value)) {
                this.aset.remove(Copies.class);
            } else if (!"DEFAULT".equalsIgnoreCase(value)) {
                int copies = ConvertData.parseInt(value);
                this.aset.add(new Copies(copies));
            }
        } else if ("DESTINATION".equals(name)) {
            if ("REMOVE".equalsIgnoreCase(value)) {
                this.aset.remove(Destination.class);
            } else if (!"DEFAULT".equalsIgnoreCase(value)) {
                try {
                    this.aset.add(new Destination(new URI(value)));
                }
                catch (URISyntaxException copies) {}
            }
        } else if ("FILENAME".equals(name)) {
            if ("REMOVE".equalsIgnoreCase(value)) {
                this.aset.remove(Destination.class);
            } else if (!"DEFAULT".equalsIgnoreCase(value)) {
                this.aset.add(new Destination(new File(value).toURI()));
            }
        } else if ("FIDELITY".equals(name)) {
            if ("REMOVE".equalsIgnoreCase(value)) {
                this.aset.remove(Fidelity.class);
            } else if (!"DEFAULT".equalsIgnoreCase(value)) {
                switch (value.charAt(0)) {
                    case '0': 
                    case 'F': 
                    case 'f': {
                        this.aset.add(Fidelity.FIDELITY_FALSE);
                        break;
                    }
                    case '1': 
                    case 'T': 
                    case 't': {
                        this.aset.add(Fidelity.FIDELITY_TRUE);
                    }
                }
            }
        } else if ("FINISHINGS".equals(name)) {
            if ("REMOVE".equals(value = this.normalizeAttribute(value))) {
                this.aset.remove(Finishings.class);
            } else if (!"DEFAULT".equalsIgnoreCase(value)) {
                if ("BIND".equals(value)) {
                    this.aset.add(Finishings.BIND);
                } else if ("COVER".equals(value)) {
                    this.aset.add(Finishings.COVER);
                } else if ("EDGE_STITCH".equals(value)) {
                    this.aset.add(Finishings.EDGE_STITCH);
                } else if ("EDGE_STITCH_BOTTOM".equals(value)) {
                    this.aset.add(Finishings.EDGE_STITCH_BOTTOM);
                } else if ("EDGE_STITCH_LEFT".equals(value)) {
                    this.aset.add(Finishings.EDGE_STITCH_LEFT);
                } else if ("EDGE_STITCH_RIGHT".equals(value)) {
                    this.aset.add(Finishings.EDGE_STITCH_RIGHT);
                } else if ("EDGE_STITCH_TOP".equals(value)) {
                    this.aset.add(Finishings.EDGE_STITCH_TOP);
                } else if ("NONE".equals(value)) {
                    this.aset.add(Finishings.NONE);
                } else if ("SADDLE_STITCH".equals(value)) {
                    this.aset.add(Finishings.SADDLE_STITCH);
                } else if ("STAPLE".equals(value)) {
                    this.aset.add(Finishings.STAPLE);
                } else if ("STAPLE_BOTTOM_LEFT".equals(value)) {
                    this.aset.add(Finishings.STAPLE_BOTTOM_LEFT);
                } else if ("STAPLE_BOTTOM_RIGHT".equals(value)) {
                    this.aset.add(Finishings.STAPLE_BOTTOM_RIGHT);
                } else if ("STAPLE_DUAL_BOTTOM".equals(value)) {
                    this.aset.add(Finishings.STAPLE_DUAL_BOTTOM);
                } else if ("STAPLE_DUAL_LEFT".equals(value)) {
                    this.aset.add(Finishings.STAPLE_DUAL_LEFT);
                } else if ("STAPLE_DUAL_RIGHT".equals(value)) {
                    this.aset.add(Finishings.STAPLE_DUAL_RIGHT);
                } else if ("STAPLE_DUAL_TOP".equals(value)) {
                    this.aset.add(Finishings.STAPLE_DUAL_TOP);
                } else if ("STAPLE_TOP_LEFT".equals(value)) {
                    this.aset.add(Finishings.STAPLE_TOP_LEFT);
                } else if ("STAPLE_TOP_RIGHT".equals(value)) {
                    this.aset.add(Finishings.STAPLE_TOP_RIGHT);
                }
            }
        } else if (!"JOB_HOLD_UNTIL".equals(name)) {
            if ("JOB_IMPRESSIONS".equals(name)) {
                if ("REMOVE".equalsIgnoreCase(value)) {
                    this.aset.remove(JobImpressions.class);
                } else if (!"DEFAULT".equalsIgnoreCase(value)) {
                    int jobImpressions = ConvertData.parseInt(value);
                    this.aset.add(new JobImpressions(jobImpressions));
                }
            } else if ("JOB_KOCTETS".equals(name) || "JOB_KBYTES".equals(name) || "JOB_KB".equals(name)) {
                if ("REMOVE".equalsIgnoreCase(value)) {
                    this.aset.remove(JobKOctets.class);
                } else if (!"DEFAULT".equalsIgnoreCase(value)) {
                    int kb = ConvertData.parseInt(value);
                    this.aset.add(new JobKOctets(kb));
                }
            } else if ("JOB_MEDIA_SHEETS".equals(name)) {
                if ("REMOVE".equalsIgnoreCase(value)) {
                    this.aset.remove(JobMediaSheets.class);
                } else if (!"DEFAULT".equalsIgnoreCase(value)) {
                    int jobMediaSheets = ConvertData.parseInt(value);
                    this.aset.add(new JobMediaSheets(jobMediaSheets));
                }
            } else if ("JOB_NAME".equals(name)) {
                if ("REMOVE".equalsIgnoreCase(value)) {
                    this.aset.remove(JobName.class);
                } else if (!"DEFAULT".equalsIgnoreCase(value)) {
                    this.aset.add(new JobName(value.trim(), null));
                }
            } else if ("JOB_PRIORITY".equals(name)) {
                if ("REMOVE".equalsIgnoreCase(value)) {
                    this.aset.remove(JobPriority.class);
                } else if (!"DEFAULT".equalsIgnoreCase(value)) {
                    int priority = ConvertData.parseInt(value);
                    if (priority < 1) {
                        priority = 1;
                    } else if (priority > 100) {
                        priority = 100;
                    }
                    this.aset.add(new JobPriority(priority));
                }
            } else if ("JOB_SHEETS".equals(name)) {
                if ("REMOVE".equalsIgnoreCase(value = this.normalizeAttribute(value))) {
                    this.aset.remove(JobSheets.class);
                } else if (!"DEFAULT".equalsIgnoreCase(value)) {
                    if ("NONE".equals(value)) {
                        this.aset.add(JobSheets.NONE);
                    } else if ("STANDARD".equals(value)) {
                        this.aset.add(JobSheets.STANDARD);
                    }
                }
            } else if ("MULTIPLE_DOCUMENT_HANDLING".equals(name)) {
                if ("REMOVE".equals(value = this.normalizeAttribute(value))) {
                    this.aset.remove(MultipleDocumentHandling.class);
                } else if (!"DEFAULT".equals(value)) {
                    if ("SEPARATE_DOCUMENTS_COLLATED_COPIES".equals(value)) {
                        this.aset.add(MultipleDocumentHandling.SEPARATE_DOCUMENTS_COLLATED_COPIES);
                    } else if ("SEPARATE_DOCUMENTS_UNCOLLATED_COPIES".equals(value)) {
                        this.aset.add(MultipleDocumentHandling.SEPARATE_DOCUMENTS_UNCOLLATED_COPIES);
                    } else if ("SINGLE_DOCUMENT".equals(value)) {
                        this.aset.add(MultipleDocumentHandling.SINGLE_DOCUMENT);
                    } else if ("SINGLE_DOCUMENT_NEW_SHEET".equals(value)) {
                        this.aset.add(MultipleDocumentHandling.SINGLE_DOCUMENT_NEW_SHEET);
                    }
                }
            } else if ("NUMBER_UP".equals(name)) {
                if ("REMOVE".equalsIgnoreCase(value)) {
                    this.aset.remove(NumberUp.class);
                } else if (!"DEFAULT".equalsIgnoreCase(value)) {
                    this.aset.add(new NumberUp(ConvertData.parseInt(value)));
                }
            } else if ("ORIENTATION_REQUESTED".equals(name) || "ORIENTATION".equals(name)) {
                if ("REMOVE".equals(value = this.normalizeAttribute(value))) {
                    this.aset.remove(OrientationRequested.class);
                } else if (!"DEFAULT".equals(value)) {
                    if ("REVERSE_PORTRAIT".equals(value)) {
                        this.aset.add(OrientationRequested.REVERSE_PORTRAIT);
                    } else if ("REVERSE_LANDSCAPE".equals(value)) {
                        this.aset.add(OrientationRequested.REVERSE_LANDSCAPE);
                    } else if ("PORTRAIT".equals(value)) {
                        this.aset.add(OrientationRequested.PORTRAIT);
                    } else if ("LANDSCAPE".equals(value)) {
                        this.aset.add(OrientationRequested.LANDSCAPE);
                    } else {
                        switch (value.charAt(0)) {
                            case 'D': 
                            case 'd': {
                                break;
                            }
                            case '1': 
                            case 'P': 
                            case 'p': {
                                this.aset.add(OrientationRequested.PORTRAIT);
                                break;
                            }
                            case '2': 
                            case 'L': 
                            case 'l': {
                                this.aset.add(OrientationRequested.LANDSCAPE);
                                break;
                            }
                            case '3': 
                            case 'R': 
                            case 'r': {
                                this.aset.add(OrientationRequested.REVERSE_LANDSCAPE);
                                break;
                            }
                            case '4': 
                            case 'Q': 
                            case 'q': {
                                this.aset.add(OrientationRequested.REVERSE_PORTRAIT);
                            }
                        }
                    }
                }
            } else if ("PAGE_RANGES".equals(name)) {
                if ("REMOVE".equalsIgnoreCase(value)) {
                    this.aset.remove(PageRanges.class);
                } else if (!"DEFAULT".equalsIgnoreCase(value)) {
                    this.aset.add(new PageRanges(value));
                }
            } else if ("PRESENTATION_DIRECTION".equals(name)) {
                if ("REMOVE".equalsIgnoreCase(value = this.normalizeAttribute(value))) {
                    this.aset.remove(PresentationDirection.class);
                } else if (!"DEFAULT".equalsIgnoreCase(value)) {
                    if ("TOBOTTOM_TOLEFT".equals(value)) {
                        this.aset.add(PresentationDirection.TOBOTTOM_TOLEFT);
                    } else if ("TOBOTTOM_TORIGHT".equals(value)) {
                        this.aset.add(PresentationDirection.TOBOTTOM_TORIGHT);
                    } else if ("TOLEFT_TOBOTTOM".equals(value)) {
                        this.aset.add(PresentationDirection.TOLEFT_TOBOTTOM);
                    } else if ("TOLEFT_TOTOP".equals(value)) {
                        this.aset.add(PresentationDirection.TOLEFT_TOTOP);
                    } else if ("TORIGHT_TOBOTTOM".equals(value)) {
                        this.aset.add(PresentationDirection.TORIGHT_TOBOTTOM);
                    } else if ("TORIGHT_TOTOP".equals(value)) {
                        this.aset.add(PresentationDirection.TORIGHT_TOTOP);
                    } else if ("TOTOP_TOLEFT".equals(value)) {
                        this.aset.add(PresentationDirection.TOTOP_TOLEFT);
                    } else if ("TOTOP_TORIGHT".equals(value)) {
                        this.aset.add(PresentationDirection.TOTOP_TORIGHT);
                    }
                }
            } else if ("REQUESTING_USER_NAME".equals(name) || "USER_NAME".equals(name) || "USER".equals(name)) {
                if ("REMOVE".equalsIgnoreCase(value)) {
                    this.aset.remove(RequestingUserName.class);
                } else if (!"DEFAULT".equalsIgnoreCase(value)) {
                    this.aset.add(new RequestingUserName(value, null));
                }
            } else if (name.equals("COLLATE")) {
                if ("REMOVE".equalsIgnoreCase(value)) {
                    this.aset.remove(SheetCollate.class);
                } else if (!"DEFAULT".equalsIgnoreCase(value)) {
                    switch (value.charAt(0)) {
                        case '1': 
                        case 'C': 
                        case 'Y': 
                        case 'c': 
                        case 'y': {
                            this.aset.add(SheetCollate.COLLATED);
                            break;
                        }
                        case '0': 
                        case 'N': 
                        case 'U': 
                        case 'n': 
                        case 'u': {
                            this.aset.add(SheetCollate.UNCOLLATED);
                        }
                    }
                }
            } else if ("SIDES".equals(name) || "DUPLEX".equals(name)) {
                if ("REMOVE".equalsIgnoreCase(value)) {
                    this.aset.remove(Sides.class);
                } else if (!"DEFAULT".equalsIgnoreCase(value)) {
                    if ("DUPLEX".equals(value = this.normalizeAttribute(value))) {
                        this.aset.add(Sides.DUPLEX);
                    } else if ("ONE_SIDED".equals(value) || "ONE_SIDE".equals(value)) {
                        this.aset.add(Sides.ONE_SIDED);
                    } else if ("TUMBLE".equals(value)) {
                        this.aset.add(Sides.TUMBLE);
                    } else if ("TWO_SIDED_LONG_EDGE".equals(value)) {
                        this.aset.add(Sides.TWO_SIDED_LONG_EDGE);
                    } else if ("TWO_SIDED_SHORT_EDGE".equals(value)) {
                        this.aset.add(Sides.TWO_SIDED_SHORT_EDGE);
                    } else {
                        switch (value.charAt(0)) {
                            case '0': 
                            case 'N': 
                            case 'n': {
                                this.aset.add(Sides.ONE_SIDED);
                                break;
                            }
                            case '1': 
                            case 'D': 
                            case 'L': 
                            case 'Y': 
                            case 'd': 
                            case 'l': 
                            case 'y': {
                                this.aset.add(Sides.TWO_SIDED_LONG_EDGE);
                                break;
                            }
                            case 'S': 
                            case 'T': 
                            case 's': 
                            case 't': {
                                this.aset.add(Sides.TWO_SIDED_SHORT_EDGE);
                            }
                        }
                    }
                }
            } else if ("COLOR".equals(name)) {
                if ("REMOVE".equalsIgnoreCase(value)) {
                    this.aset.remove(ColorSupported.class);
                } else if (!"DEFAULT".equalsIgnoreCase(value)) {
                    switch (value.charAt(0)) {
                        case '1': 
                        case 'C': 
                        case 'Y': 
                        case 'c': 
                        case 'y': {
                            this.aset.add(ColorSupported.SUPPORTED);
                            break;
                        }
                        case '0': 
                        case 'M': 
                        case 'N': 
                        case 'm': 
                        case 'n': {
                            this.aset.add(ColorSupported.NOT_SUPPORTED);
                        }
                    }
                }
            } else if ("MEDIA_TRAY".equals(name) || "SOURCE".equals(name) || "TRAY".equals(name)) {
                if ("REMOVE".equalsIgnoreCase(value = this.normalizeAttribute(value))) {
                    this.aset.remove(MediaTray.class);
                } else if (!"DEFAULT".equalsIgnoreCase(value)) {
                    if ("BOTTOM".equals(value)) {
                        this.aset.add(MediaTray.BOTTOM);
                    } else if ("ENVELOPE".equals(value)) {
                        this.aset.add(MediaTray.ENVELOPE);
                    } else if ("LARGE_CAPACITY".equals(value)) {
                        this.aset.add(MediaTray.LARGE_CAPACITY);
                    } else if ("MAIN".equals(value)) {
                        this.aset.add(MediaTray.MAIN);
                    } else if ("MANUAL".equals(value)) {
                        this.aset.add(MediaTray.MANUAL);
                    } else if ("MIDDLE".equals(value)) {
                        this.aset.add(MediaTray.MIDDLE);
                    } else if ("SIDE".equals(value)) {
                        this.aset.add(MediaTray.SIDE);
                    } else if ("TOP".equals(value)) {
                        this.aset.add(MediaTray.TOP);
                    }
                }
            } else if ("MEDIA".equals(name)) {
                if ("REMOVE".equals(value = value.toUpperCase().replace(' ', '_').replace('-', '_'))) {
                    this.aset.remove(MediaSizeName.class);
                } else if (!"DEFAULT".equals(value)) {
                    if ("A".equals(value)) {
                        this.aset.add(MediaSizeName.A);
                    } else if ("A1".equals(value)) {
                        this.aset.add(MediaSizeName.ISO_A1);
                    } else if ("A2".equals(value)) {
                        this.aset.add(MediaSizeName.ISO_A2);
                    } else if ("A3".equals(value)) {
                        this.aset.add(MediaSizeName.ISO_A3);
                    } else if ("A4".equals(value)) {
                        this.aset.add(MediaSizeName.ISO_A4);
                    } else if ("A5".equals(value)) {
                        this.aset.add(MediaSizeName.ISO_A5);
                    } else if ("A6".equals(value)) {
                        this.aset.add(MediaSizeName.ISO_A6);
                    } else if ("A7".equals(value)) {
                        this.aset.add(MediaSizeName.ISO_A7);
                    } else if ("A8".equals(value)) {
                        this.aset.add(MediaSizeName.ISO_A8);
                    } else if ("A9".equals(value)) {
                        this.aset.add(MediaSizeName.ISO_A9);
                    } else if ("A10".equals(value)) {
                        this.aset.add(MediaSizeName.ISO_A10);
                    } else if ("B".equals(value)) {
                        this.aset.add(MediaSizeName.B);
                    } else if ("B1".equals(value)) {
                        this.aset.add(MediaSizeName.ISO_B1);
                    } else if ("B2".equals(value)) {
                        this.aset.add(MediaSizeName.ISO_B2);
                    } else if ("B3".equals(value)) {
                        this.aset.add(MediaSizeName.ISO_B3);
                    } else if ("B4".equals(value)) {
                        this.aset.add(MediaSizeName.ISO_B4);
                    } else if ("B5".equals(value)) {
                        this.aset.add(MediaSizeName.ISO_B5);
                    } else if ("B6".equals(value)) {
                        this.aset.add(MediaSizeName.ISO_B6);
                    } else if ("B7".equals(value)) {
                        this.aset.add(MediaSizeName.ISO_B7);
                    } else if ("B8".equals(value)) {
                        this.aset.add(MediaSizeName.ISO_B8);
                    } else if ("B9".equals(value)) {
                        this.aset.add(MediaSizeName.ISO_B9);
                    } else if ("B10".equals(value)) {
                        this.aset.add(MediaSizeName.ISO_B10);
                    } else if ("C".equals(value)) {
                        this.aset.add(MediaSizeName.C);
                    } else if ("CSHEET".equals(value)) {
                        this.aset.add(MediaSizeName.C);
                    } else if ("C1".equals(value)) {
                        this.aset.add(MediaSizeName.ISO_C1);
                    } else if ("C2".equals(value)) {
                        this.aset.add(MediaSizeName.ISO_C2);
                    } else if ("C3".equals(value)) {
                        this.aset.add(MediaSizeName.ISO_C3);
                    } else if ("C4".equals(value)) {
                        this.aset.add(MediaSizeName.ISO_C4);
                    } else if ("C5".equals(value)) {
                        this.aset.add(MediaSizeName.ISO_C5);
                    } else if ("C6".equals(value)) {
                        this.aset.add(MediaSizeName.ISO_C6);
                    } else if ("D".equals(value)) {
                        this.aset.add(MediaSizeName.D);
                    } else if ("DSHEET".equals(value)) {
                        this.aset.add(MediaSizeName.D);
                    } else if ("E".equals(value)) {
                        this.aset.add(MediaSizeName.E);
                    } else if ("ESHEET".equals(value)) {
                        this.aset.add(MediaSizeName.E);
                    } else if ("ENV_10".equals(value)) {
                        this.aset.add(MediaSizeName.NA_NUMBER_10_ENVELOPE);
                    } else if ("ENV10".equals(value)) {
                        this.aset.add(MediaSizeName.NA_NUMBER_10_ENVELOPE);
                    } else if ("ENV_10X13".equals(value)) {
                        this.aset.add(MediaSizeName.NA_10X13_ENVELOPE);
                    } else if ("ENV_10X14".equals(value)) {
                        this.aset.add(MediaSizeName.NA_10X14_ENVELOPE);
                    } else if ("10X14".equals(value)) {
                        this.aset.add(MediaSizeName.NA_10X14_ENVELOPE);
                    } else if ("ENV_10X15".equals(value)) {
                        this.aset.add(MediaSizeName.NA_10X15_ENVELOPE);
                    } else if ("ENV_11".equals(value)) {
                        this.aset.add(MediaSizeName.NA_NUMBER_11_ENVELOPE);
                    } else if ("ENV11".equals(value)) {
                        this.aset.add(MediaSizeName.NA_NUMBER_11_ENVELOPE);
                    } else if ("ENV_12".equals(value)) {
                        this.aset.add(MediaSizeName.NA_NUMBER_12_ENVELOPE);
                    } else if ("ENV12".equals(value)) {
                        this.aset.add(MediaSizeName.NA_NUMBER_12_ENVELOPE);
                    } else if ("ENV_14".equals(value)) {
                        this.aset.add(MediaSizeName.NA_NUMBER_14_ENVELOPE);
                    } else if ("ENV14".equals(value)) {
                        this.aset.add(MediaSizeName.NA_NUMBER_14_ENVELOPE);
                    } else if ("ENV_6X9".equals(value)) {
                        this.aset.add(MediaSizeName.NA_6X9_ENVELOPE);
                    } else if ("ENV_7X9".equals(value)) {
                        this.aset.add(MediaSizeName.NA_7X9_ENVELOPE);
                    } else if ("ENV_9".equals(value)) {
                        this.aset.add(MediaSizeName.NA_NUMBER_9_ENVELOPE);
                    } else if ("ENV9".equals(value)) {
                        this.aset.add(MediaSizeName.NA_NUMBER_9_ENVELOPE);
                    } else if ("ENV_9X11".equals(value)) {
                        this.aset.add(MediaSizeName.NA_9X11_ENVELOPE);
                    } else if ("ENV_9X12".equals(value)) {
                        this.aset.add(MediaSizeName.NA_9X12_ENVELOPE);
                    } else if ("ENV_ITALY".equals(value)) {
                        this.aset.add(MediaSizeName.ITALY_ENVELOPE);
                    } else if ("ENV_MONARCH".equals(value)) {
                        this.aset.add(MediaSizeName.MONARCH_ENVELOPE);
                    } else if ("ENV_PERSONAL".equals(value)) {
                        this.aset.add(MediaSizeName.PERSONAL_ENVELOPE);
                    } else if ("ENVITALY".equals(value)) {
                        this.aset.add(MediaSizeName.ITALY_ENVELOPE);
                    } else if ("ENVPERSONAL".equals(value)) {
                        this.aset.add(MediaSizeName.PERSONAL_ENVELOPE);
                    } else if ("EXECUTIVE".equals(value)) {
                        this.aset.add(MediaSizeName.EXECUTIVE);
                    } else if ("FOLIO".equals(value)) {
                        this.aset.add(MediaSizeName.FOLIO);
                    } else if ("INVOICE".equals(value)) {
                        this.aset.add(MediaSizeName.INVOICE);
                    } else if ("ISO_DESIGNATED_LONG".equals(value)) {
                        this.aset.add(MediaSizeName.ISO_DESIGNATED_LONG);
                    } else if ("ISO_DESIGNATED_LONG_ENVELOPE".equals(value)) {
                        this.aset.add(MediaSizeName.ISO_DESIGNATED_LONG);
                    } else if ("ISO_A1".equals(value)) {
                        this.aset.add(MediaSizeName.ISO_A1);
                    } else if ("ISO_A2".equals(value)) {
                        this.aset.add(MediaSizeName.ISO_A2);
                    } else if ("ISO_A3".equals(value)) {
                        this.aset.add(MediaSizeName.ISO_A3);
                    } else if ("ISO_A4".equals(value)) {
                        this.aset.add(MediaSizeName.ISO_A4);
                    } else if ("ISO_A5".equals(value)) {
                        this.aset.add(MediaSizeName.ISO_A5);
                    } else if ("ISO_A6".equals(value)) {
                        this.aset.add(MediaSizeName.ISO_A6);
                    } else if ("ISO_A7".equals(value)) {
                        this.aset.add(MediaSizeName.ISO_A7);
                    } else if ("ISO_A8".equals(value)) {
                        this.aset.add(MediaSizeName.ISO_A8);
                    } else if ("ISO_A9".equals(value)) {
                        this.aset.add(MediaSizeName.ISO_A9);
                    } else if ("ISO_A10".equals(value)) {
                        this.aset.add(MediaSizeName.ISO_A10);
                    } else if ("ISO_B1".equals(value)) {
                        this.aset.add(MediaSizeName.ISO_B1);
                    } else if ("ISO_B2".equals(value)) {
                        this.aset.add(MediaSizeName.ISO_B2);
                    } else if ("ISO_B3".equals(value)) {
                        this.aset.add(MediaSizeName.ISO_B3);
                    } else if ("ISO_B4".equals(value)) {
                        this.aset.add(MediaSizeName.ISO_B4);
                    } else if ("ISO_B5".equals(value)) {
                        this.aset.add(MediaSizeName.ISO_B5);
                    } else if ("ISO_B6".equals(value)) {
                        this.aset.add(MediaSizeName.ISO_B6);
                    } else if ("ISO_B7".equals(value)) {
                        this.aset.add(MediaSizeName.ISO_B7);
                    } else if ("ISO_B8".equals(value)) {
                        this.aset.add(MediaSizeName.ISO_B8);
                    } else if ("ISO_B9".equals(value)) {
                        this.aset.add(MediaSizeName.ISO_B9);
                    } else if ("ISO_B10".equals(value)) {
                        this.aset.add(MediaSizeName.ISO_B10);
                    } else if ("ISO_C1".equals(value)) {
                        this.aset.add(MediaSizeName.ISO_C1);
                    } else if ("ISO_C2".equals(value)) {
                        this.aset.add(MediaSizeName.ISO_C2);
                    } else if ("ISO_C3".equals(value)) {
                        this.aset.add(MediaSizeName.ISO_C3);
                    } else if ("ISO_C4".equals(value)) {
                        this.aset.add(MediaSizeName.ISO_C4);
                    } else if ("ISO_C5".equals(value)) {
                        this.aset.add(MediaSizeName.ISO_C5);
                    } else if ("ISO_C6".equals(value)) {
                        this.aset.add(MediaSizeName.ISO_C6);
                    } else if ("ITALY".equals(value)) {
                        this.aset.add(MediaSizeName.ITALY_ENVELOPE);
                    } else if ("ITALY_ENVELOPE".equals(value)) {
                        this.aset.add(MediaSizeName.ITALY_ENVELOPE);
                    } else if ("JIS_B0".equals(value)) {
                        this.aset.add(MediaSizeName.JIS_B0);
                    } else if ("JIS_B1".equals(value)) {
                        this.aset.add(MediaSizeName.JIS_B1);
                    } else if ("JIS_B2".equals(value)) {
                        this.aset.add(MediaSizeName.JIS_B2);
                    } else if ("JIS_B3".equals(value)) {
                        this.aset.add(MediaSizeName.JIS_B3);
                    } else if ("JIS_B4".equals(value)) {
                        this.aset.add(MediaSizeName.JIS_B4);
                    } else if ("JIS_B5".equals(value)) {
                        this.aset.add(MediaSizeName.JIS_B5);
                    } else if ("B5_JAPAN".equals(value)) {
                        this.aset.add(MediaSizeName.JIS_B5);
                    } else if ("JIS_B6".equals(value)) {
                        this.aset.add(MediaSizeName.JIS_B6);
                    } else if ("JIS_B7".equals(value)) {
                        this.aset.add(MediaSizeName.JIS_B7);
                    } else if ("JIS_B8".equals(value)) {
                        this.aset.add(MediaSizeName.JIS_B8);
                    } else if ("JIS_B9".equals(value)) {
                        this.aset.add(MediaSizeName.JIS_B9);
                    } else if ("LEDGER".equals(value)) {
                        this.aset.add(MediaSizeName.LEDGER);
                    } else if ("LEGAL".equals(value)) {
                        this.aset.add(MediaSizeName.NA_LEGAL);
                    } else if ("LETTER".equals(value)) {
                        this.aset.add(MediaSizeName.NA_LETTER);
                    } else if ("MONARCH".equals(value)) {
                        this.aset.add(MediaSizeName.MONARCH_ENVELOPE);
                    } else if ("MONARCH_ENVELOPE".equals(value)) {
                        this.aset.add(MediaSizeName.MONARCH_ENVELOPE);
                    } else if ("ENVMONARCH".equals(value)) {
                        this.aset.add(MediaSizeName.MONARCH_ENVELOPE);
                    } else if ("NA_10X13_ENVELOPE".equals(value)) {
                        this.aset.add(MediaSizeName.NA_10X13_ENVELOPE);
                    } else if ("NA_10X14_ENVELOPE".equals(value)) {
                        this.aset.add(MediaSizeName.NA_10X14_ENVELOPE);
                    } else if ("NA_10X15_ENVELOPE".equals(value)) {
                        this.aset.add(MediaSizeName.NA_10X15_ENVELOPE);
                    } else if ("NA_6X9_ENVELOPE".equals(value)) {
                        this.aset.add(MediaSizeName.NA_6X9_ENVELOPE);
                    } else if ("NA_7X9_ENVELOPE".equals(value)) {
                        this.aset.add(MediaSizeName.NA_7X9_ENVELOPE);
                    } else if ("NA_9X11_ENVELOPE".equals(value)) {
                        this.aset.add(MediaSizeName.NA_9X11_ENVELOPE);
                    } else if ("NA_9X12_ENVELOPE".equals(value)) {
                        this.aset.add(MediaSizeName.NA_9X12_ENVELOPE);
                    } else if ("NA_LEGAL".equals(value)) {
                        this.aset.add(MediaSizeName.NA_LEGAL);
                    } else if ("NA_LETTER".equals(value)) {
                        this.aset.add(MediaSizeName.NA_LETTER);
                    } else if ("NA_NUMBER_10_ENVELOPE".equals(value)) {
                        this.aset.add(MediaSizeName.NA_NUMBER_10_ENVELOPE);
                    } else if ("NA_NUMBER_11_ENVELOPE".equals(value)) {
                        this.aset.add(MediaSizeName.NA_NUMBER_11_ENVELOPE);
                    } else if ("NA_NUMBER_12_ENVELOPE".equals(value)) {
                        this.aset.add(MediaSizeName.NA_NUMBER_12_ENVELOPE);
                    } else if ("NA_NUMBER_14_ENVELOPE".equals(value)) {
                        this.aset.add(MediaSizeName.NA_NUMBER_14_ENVELOPE);
                    } else if ("NA_NUMBER_9_ENVELOPE".equals(value)) {
                        this.aset.add(MediaSizeName.NA_NUMBER_9_ENVELOPE);
                    } else if ("PERSONAL".equals(value)) {
                        this.aset.add(MediaSizeName.PERSONAL_ENVELOPE);
                    } else if ("PERSONAL_ENVELOPE".equals(value)) {
                        this.aset.add(MediaSizeName.PERSONAL_ENVELOPE);
                    } else if ("QUARTO".equals(value)) {
                        this.aset.add(MediaSizeName.QUARTO);
                    } else if ("TABLOID".equals(value)) {
                        this.aset.add(MediaSizeName.TABLOID);
                    }
                }
            } else if ("PAPER_SIZE".equals(name) || "PAPERSIZE".equals(name) || "SIZE".equals(name)) {
                value = value.toUpperCase();
                int type = ConvertData.parseInt(value);
                double width = 0.0;
                double height = 0.0;
                if ("REMOVE".equalsIgnoreCase(value)) {
                    this.aset.remove(MediaSize.class);
                } else if (!"DEFAULT".equalsIgnoreCase(value)) {
                    if (type == 1 || "LETTER".equals(value)) {
                        type = 1;
                        this.aset.add(MediaSize.NA.LETTER);
                        width = 612.0;
                        height = 792.0;
                    } else if (type == 2 || "LETTERSMALL".equals(value)) {
                        type = 2;
                        this.aset.add(MediaSize.NA.LETTER);
                        width = 612.0;
                        height = 792.0;
                    } else if (type == 3 || "TABLOID".equals(value)) {
                        type = 3;
                        this.aset.add(new MediaSize(11.0f, 17.0f, 25400));
                        width = 794.0;
                        height = 1227.0;
                    } else if (type == 4 || "LEDGER".equals(value)) {
                        type = 4;
                        this.aset.add(MediaSize.Other.LEDGER);
                        width = 794.0;
                        height = 1227.0;
                    } else if (type == 5 || "LEGAL".equals(value)) {
                        type = 5;
                        this.aset.add(MediaSize.NA.LEGAL);
                        width = 612.0;
                        height = 1008.0;
                    } else if (type == 6 || "STATEMENT".equals(value)) {
                        type = 6;
                        this.aset.add(new MediaSize(5.5f, 8.5f, 25400));
                    } else if (type == 7 || "EXECUTIVE".equals(value)) {
                        type = 7;
                        this.aset.add(MediaSize.Other.EXECUTIVE);
                        width = 522.072;
                        height = 756.0;
                    } else if (type == 8 || "A3".equals(value)) {
                        type = 8;
                        this.aset.add(MediaSize.ISO.A3);
                        width = 841.88976;
                        height = 1190.5512;
                    } else if (type == 9 || "A4".equals(value)) {
                        type = 9;
                        this.aset.add(MediaSize.ISO.A4);
                        width = 595.224;
                        height = 841.824;
                    } else if (type == 10 || "A4SMALL".equals(value)) {
                        type = 10;
                        this.aset.add(new MediaSize(210, 297, 1000));
                        width = 595.224;
                        height = 841.824;
                    } else if (type == 11 || "A5".equals(value)) {
                        type = 11;
                        this.aset.add(MediaSize.ISO.A5);
                        width = 420.94488;
                        height = 595.27559;
                    } else if (type == 12 || "B4".equals(value)) {
                        type = 12;
                        this.aset.add(MediaSize.ISO.B4);
                        width = 730.0;
                        height = 1034.0;
                    } else if (type == 13 || "B5".equals(value)) {
                        type = 13;
                        this.aset.add(MediaSize.ISO.B5);
                        width = 500.0;
                        height = 710.0;
                    } else if (type == 14 || "FOLIO".equals(value)) {
                        type = 14;
                        this.aset.add(MediaSize.Other.FOLIO);
                    } else if (type == 15 || "QUARTO".equals(value)) {
                        type = 15;
                        this.aset.add(MediaSize.Other.QUARTO);
                    } else if (type == 16 || "10X14".equals(value)) {
                        type = 16;
                        this.aset.add(MediaSize.NA.NA_10x14_ENVELOPE);
                        width = 720.0;
                        height = 1008.0;
                    } else if (type == 17 || "11X17".equals(value)) {
                        type = 17;
                        this.aset.add(new MediaSize(11.0f, 17.0f, 25400));
                        width = 792.0;
                        height = 1224.0;
                    } else if (type == 18 || "NOTE".equals(value)) {
                        type = 18;
                        this.aset.add(new MediaSize(8.5f, 11.0f, 25400));
                        width = 612.0;
                        height = 792.0;
                    } else if (type == 19 || "ENV9".equals(value)) {
                        type = 19;
                        this.aset.add(MediaSize.NA.NA_NUMBER_9_ENVELOPE);
                    } else if (type == 20 || "ENV10".equals(value)) {
                        type = 20;
                        this.aset.add(MediaSize.NA.NA_NUMBER_10_ENVELOPE);
                        width = 297.0;
                        height = 684.0;
                    } else if (type == 21 || "ENV11".equals(value)) {
                        type = 21;
                        this.aset.add(MediaSize.NA.NA_NUMBER_11_ENVELOPE);
                    } else if (type == 22 || "ENV12".equals(value)) {
                        type = 22;
                        this.aset.add(MediaSize.NA.NA_NUMBER_12_ENVELOPE);
                    } else if (type == 23 || "ENV14".equals(value)) {
                        type = 23;
                        this.aset.add(MediaSize.NA.NA_NUMBER_14_ENVELOPE);
                    } else if (type == 24 || "CSHEET".equals(value)) {
                        type = 24;
                        this.aset.add(MediaSize.Engineering.C);
                        width = 216.0;
                        height = 279.5;
                    } else if (type == 25 || "DSHEET".equals(value)) {
                        type = 25;
                        this.aset.add(MediaSize.Engineering.D);
                        width = 279.5;
                        height = 432.0;
                    } else if (type == 26 || "ESHEET".equals(value)) {
                        type = 26;
                        this.aset.add(MediaSize.Engineering.E);
                        width = 432.0;
                        height = 559.0;
                    } else if (type == 27 || "ENVDL".equals(value)) {
                        type = 27;
                        this.aset.add(new MediaSize(110, 220, 1000));
                        width = 311.76;
                        height = 649.08;
                    } else if (type == 28 || "ENVC5".equals(value)) {
                        type = 28;
                        this.aset.add(new MediaSize(162, 229, 1000));
                        width = 459.144;
                        height = 649.08;
                    } else if (type == 29 || "ENVC3".equals(value)) {
                        type = 29;
                        this.aset.add(new MediaSize(324, 458, 1000));
                    } else if (type == 30 || "ENVC4".equals(value)) {
                        type = 30;
                        this.aset.add(new MediaSize(229, 324, 1000));
                    } else if (type == 31 || "ENVC6".equals(value)) {
                        type = 31;
                        this.aset.add(new MediaSize(114, 162, 1000));
                    } else if (type == 32 || "ENVC65".equals(value)) {
                        type = 32;
                        this.aset.add(new MediaSize(114, 229, 1000));
                    } else if (type == 33 || "ENVB4".equals(value)) {
                        type = 33;
                        this.aset.add(new MediaSize(250, 353, 1000));
                    } else if (type == 34 || "ENVB5".equals(value)) {
                        type = 34;
                        this.aset.add(new MediaSize(176, 250, 1000));
                        width = 498.888;
                        height = 708.624;
                    } else if (type == 35 || "ENVB6".equals(value)) {
                        type = 35;
                        this.aset.add(new MediaSize(176, 125, 1000));
                    } else if (type == 36 || "ENVITALY".equals(value)) {
                        type = 36;
                        this.aset.add(MediaSize.Other.ITALY_ENVELOPE);
                    } else if (type == 37) {
                        type = 37;
                        this.aset.add(new MediaSize(3.875f, 7.5f, 25400));
                    } else if (type == 38 || "ENVPERSONAL".equals(value)) {
                        type = 38;
                        this.aset.add(new MediaSize(3.625f, 6.5f, 25400));
                    } else if (type == 39 || "FANFOLDUS".equals(value)) {
                        type = 39;
                        this.aset.add(new MediaSize(14.875f, 11.0f, 25400));
                    } else if (type == 40 || "FANFOLDSTDGERMAN".equals(value)) {
                        type = 40;
                        this.aset.add(new MediaSize(8.5f, 12.0f, 25400));
                    } else if (type == 41 || "FANFOLDLGLGERMAN".equals(value)) {
                        type = 41;
                        this.aset.add(new MediaSize(8.5f, 13.0f, 25400));
                    } else if (type == 42 || "ENVMONARCH".equals(value)) {
                        type = 42;
                        this.aset.add(MediaSize.Other.MONARCH_ENVELOPE);
                        width = 278.928;
                        height = 540.0;
                    } else if (type == 43 || "MONARCH".equals(value)) {
                        type = 43;
                        this.aset.add(MediaSize.Other.MONARCH_ENVELOPE);
                        width = 280.0;
                        height = 542.0;
                    } else if (type == 44 || "EUROPOSTCARD".equals(value)) {
                        type = 44;
                        width = 298.0;
                        height = 420.0;
                    } else if (type == 45 || "B5_JAPAN".equals(value)) {
                        type = 45;
                        width = 517.0;
                        height = 730.0;
                    } else if (type == 46 || "HALF_LETTER".equals(value)) {
                        type = 46;
                        this.aset.add(new MediaSize(8.5f, 5.5f, 25400));
                        width = 612.0;
                        height = 397.0;
                    }
                }
            } else if ("PRINT_QUALITY".equals(name) || "QUALITY".equals(name)) {
                if ("REMOVE".equalsIgnoreCase(value)) {
                    this.aset.remove(PrintQuality.DRAFT);
                } else if (!"DEFAULT".equalsIgnoreCase(value)) {
                    switch (value.charAt(0)) {
                        case '3': 
                        case 'D': 
                        case 'd': {
                            this.aset.add(PrintQuality.DRAFT);
                            break;
                        }
                        case '4': 
                        case 'N': 
                        case 'n': {
                            this.aset.add(PrintQuality.NORMAL);
                            break;
                        }
                        case '5': 
                        case 'H': 
                        case 'h': {
                            this.aset.add(PrintQuality.HIGH);
                        }
                    }
                }
            } else if ("BASIC_LEFT_MARGIN".equals(name)) {
                BASIC_LEFT_MARGIN = ConvertData.parseInt(value.trim());
            } else if ("BASIC_TOP_MARGIN".equals(name)) {
                BASIC_TOP_MARGIN = Integer.parseInt(value.trim());
            } else if ("BASIC_BOTTOM_MARGIN".equals(name)) {
                BASIC_BOTTOM_MARGIN = Integer.parseInt(value.trim());
            } else if ("DASH_LENGTH".equals(name)) {
                DASH_LENGTH = new Float(value.trim()).floatValue();
            } else if ("DOT_LENGTH".equals(name)) {
                DOT_LENGTH = new Float(value.trim()).floatValue();
            } else if ("SPACE_LENGTH".equals(name)) {
                SPACE_LENGTH = new Float(value.trim()).floatValue();
            } else if ("DASH_LINE".equals(name) || "DOT_LINE".equals(name) || "DASH_DOT_LINE".equals(name) || "DASH_DOT_DOT_LINE".equals(name)) {
                int length = value.length();
                float[] pattern = new float[length];
                float multiplier = 1.0f;
                block49: for (int i = 0; i < length; ++i) {
                    switch (value.charAt(i)) {
                        case '.': {
                            pattern[i] = multiplier * DOT_LENGTH;
                            multiplier = 1.0f;
                            continue block49;
                        }
                        case '-': {
                            pattern[i] = multiplier * DASH_LENGTH;
                            multiplier = 1.0f;
                            continue block49;
                        }
                        case ' ': {
                            pattern[i] = multiplier * SPACE_LENGTH;
                            multiplier = 1.0f;
                            continue block49;
                        }
                        case '1': {
                            multiplier = 1.0f;
                            continue block49;
                        }
                        case '2': {
                            multiplier = 2.0f;
                            continue block49;
                        }
                        case '3': {
                            multiplier = 3.0f;
                            continue block49;
                        }
                        case '4': {
                            multiplier = 4.0f;
                            continue block49;
                        }
                        case '5': {
                            multiplier = 5.0f;
                            continue block49;
                        }
                        case '6': {
                            multiplier = 6.0f;
                            continue block49;
                        }
                        case '7': {
                            multiplier = 7.0f;
                            continue block49;
                        }
                        case '8': {
                            multiplier = 8.0f;
                            continue block49;
                        }
                        case '9': {
                            multiplier = 9.0f;
                        }
                    }
                }
                if ("DASH_LINE".equals(name)) {
                    DASH_LINE = pattern;
                } else if ("DOT_LINE".equals(name)) {
                    DOT_LINE = pattern;
                } else if ("DASH_DOT_DOT_LINE".equals(name)) {
                    DASH_DOT_DOT_LINE = pattern;
                }
            }
        }
        attributes.put(name, value);
    }

    private void initAset() {
        try {
            String to;
            String from = attributes.get("FROM_PAGE");
            if (from == null) {
                from = attributes.get("MIN_PAGE");
            }
            if ((to = attributes.get("TO_PAGE")) == null) {
                to = attributes.get("MAX_PAGE");
            }
            if (from != null || to != null) {
                int fromValue = -1;
                if (from != null) {
                    fromValue = ConvertData.parseInt(String.valueOf(from).trim());
                }
                int toValue = -1;
                if (to != null) {
                    toValue = ConvertData.parseInt(String.valueOf(to).trim());
                }
                if (from != null && to != null) {
                    this.aset.add(new PageRanges(fromValue, toValue));
                } else if (from != null) {
                    this.aset.add(new PageRanges(fromValue, Integer.MAX_VALUE));
                } else if (to != null) {
                    this.aset.add(new PageRanges(1, toValue));
                }
            }
        }
        catch (Exception e) {
            JVM14Driver.log(e);
        }
    }

    @Override
    public double getScaleX(String units) {
        if (units == null) {
            return 1.0;
        }
        if ((units = units.trim()).length() > 0) {
            switch (units.charAt(0)) {
                case 'I': 
                case 'i': {
                    return this.multiplierXInches;
                }
                case 'M': 
                case 'm': {
                    return this.multiplierXMetric;
                }
                case 'C': 
                case 'c': {
                    return this.multiplierXCharacters;
                }
                case 'D': 
                case 'T': 
                case 'd': 
                case 't': {
                    return this.multiplierXDeviceUnits;
                }
                case 'P': 
                case 'p': {
                    return 1.0;
                }
            }
        }
        return 1.0;
    }

    @Override
    public double getScaleY(String units) {
        if (units == null) {
            return 1.0;
        }
        if ((units = units.trim()).length() > 0) {
            switch (units.charAt(0)) {
                case 'I': 
                case 'i': {
                    return this.multiplierYInches;
                }
                case 'M': 
                case 'm': {
                    return this.multiplierYMetric;
                }
                case 'C': 
                case 'c': {
                    return this.multiplierYCharacters;
                }
                case 'D': 
                case 'T': 
                case 'd': 
                case 't': {
                    return this.multiplierYDeviceUnits;
                }
                case 'P': 
                case 'p': {
                    return 1.0;
                }
            }
        }
        return 1.0;
    }

    @Override
    public void draw(Image image, double xpos, double ypos, double width, double height) {
        if (this.isEmptyJob()) {
            return;
        }
        if (image != null) {
            if (width <= 0.0 && height <= 0.0) {
                this.addPrintQueue(new PrintQueue(2, image, (int)(xpos + (double)this.leftMargin), (int)(ypos + (double)this.topMargin), Color.white));
            } else {
                if (width <= 0.0) {
                    width = image.getWidth(this.getComponent());
                }
                if (height <= 0.0) {
                    height = image.getHeight(this.getComponent());
                }
                this.addPrintQueue(new PrintQueue(2, image, (int)(xpos + (double)this.leftMargin), (int)(ypos + (double)this.topMargin), (int)width, (int)height, Color.white));
            }
        }
    }

    @Override
    public void draw(Component component, double xpos, double ypos, double width, double height) {
        if (this.isEmptyJob()) {
            return;
        }
        this.addPrintQueue(new PrintQueue(3, component, (int)(xpos + (double)this.leftMargin), (int)(ypos + (double)this.topMargin), (int)width, (int)height));
    }

    @Override
    public void drawBox(double xpos, double ypos, double width, double height, boolean shade, boolean _3d, boolean raised) {
        if (this.isEmptyJob()) {
            return;
        }
        Color c = this.getPenColor();
        int bx = (int)(xpos + (double)this.leftMargin);
        int by = (int)(ypos + (double)this.topMargin);
        int sw = (int)width;
        int sh = (int)height;
        if (shade) {
            this.addPrintQueue(new PrintQueue(this.getShadeColor()));
            this.addPrintQueue(new PrintQueue(_3d ? 4 : 5, bx, by, sw, sh, raised));
        }
        this.addPrintQueue(new PrintQueue(c));
        this.addPrintQueue(new PrintQueue(_3d ? 6 : 7, bx, by, sw, sh, raised));
    }

    @Override
    public void drawBox(double xpos, double ypos, double width, double height, boolean shade, int arcWidth, int arcHeight) {
        if (this.isEmptyJob()) {
            return;
        }
        Color c = this.getPenColor();
        int bx = (int)(xpos + (double)this.leftMargin);
        int by = (int)(ypos + (double)this.topMargin);
        int sw = (int)width;
        int sh = (int)height;
        if (shade) {
            this.addPrintQueue(new PrintQueue(this.getShadeColor()));
            this.addPrintQueue(new PrintQueue(8, bx, by, sw, sh, arcWidth, arcHeight));
        }
        this.addPrintQueue(new PrintQueue(c));
        this.addPrintQueue(new PrintQueue(9, bx, by, sw, sh, arcWidth, arcHeight));
    }

    @Override
    public void drawOval(double xpos, double ypos, double width, double height, boolean shade) {
        if (this.isEmptyJob()) {
            return;
        }
        Color c = this.getPenColor();
        int bx = (int)(xpos + (double)this.leftMargin);
        int by = (int)(ypos + (double)this.topMargin);
        int sw = (int)width;
        int sh = (int)height;
        if (shade) {
            this.addPrintQueue(new PrintQueue(this.getShadeColor()));
            this.addPrintQueue(new PrintQueue(10, bx, by, sw, sh));
        }
        this.addPrintQueue(new PrintQueue(c));
        this.addPrintQueue(new PrintQueue(22, bx, by, sw, sh));
    }

    @Override
    public void drawArc(double xpos, double ypos, double width, double height, boolean shade, int startAngle, int endAngle) {
        if (this.isEmptyJob()) {
            return;
        }
        Color c = this.getPenColor();
        int bx = (int)(xpos + (double)this.leftMargin);
        int by = (int)(ypos + (double)this.topMargin);
        int sw = (int)width;
        int sh = (int)height;
        if (shade) {
            this.addPrintQueue(new PrintQueue(this.getShadeColor()));
            this.addPrintQueue(new PrintQueue(12, bx, by, sw, sh, startAngle, endAngle));
        }
        this.addPrintQueue(new PrintQueue(c));
        this.addPrintQueue(new PrintQueue(13, bx, by, sw, sh, startAngle, endAngle));
    }

    @Override
    public void drawLine(double x1, double y1, double x2, double y2) {
        if (this.isEmptyJob()) {
            return;
        }
        Color c = this.getPenColor();
        this.addPrintQueue(new PrintQueue(c));
        this.addPrintQueue(new PrintQueue(14, (int)(x1 + (double)this.leftMargin), (int)(y1 + (double)this.topMargin), (int)(x2 + (double)this.leftMargin), (int)(y2 + (double)this.topMargin)));
        this.lineFromX = x2;
        this.lineFromY = y2;
    }

    @Override
    public void drawLineFrom(double x1, double y1) {
        this.lineFromX = x1;
        this.lineFromY = y1;
    }

    @Override
    public void drawLineTo(double x2, double y2) {
        if (this.isEmptyJob()) {
            return;
        }
        this.drawLine(this.lineFromX, this.lineFromY, x2, y2);
    }

    @Override
    public void setShadeColor(Color shade) {
        this.shadeColor = shade != null ? shade : Color.lightGray;
    }

    @Override
    public Color getShadeColor() {
        return this.shadeColor != null ? this.shadeColor : Color.lightGray;
    }

    @Override
    public void setPen(int penStyle, double penWidth, Color penColor) {
        this.penColor = penColor;
        if (penStyle != 0 || penWidth != 1.0) {
            this.addPrintQueue(new PrintQueue(23, penWidth, (double)penStyle, 0.0));
        }
    }

    public Color getPenColor() {
        return this.penColor != null ? this.penColor : this.getTextColor();
    }

    @Override
    public double getPositionX() {
        return this.xpos;
    }

    @Override
    public double getPositionY() {
        return this.ypos;
    }

    @Override
    public void setPositionX(double xpos) {
        this.xpos = xpos;
    }

    @Override
    public void setPositionY(double ypos) {
        this.ypos = ypos;
    }

    private void init() {
        this.lastPageIndex = -1;
        this.previousPageIndex = -1;
        this.pageIndex = 0;
        this.fontUnderline = false;
        this.fontStrikeOut = false;
        this.fontDoubleStrike = false;
        this.resetX();
        this.resetY();
        this.canceled = false;
        this.initAset();
    }

    private PrintService lookup(String assignedPrinter, PrintService[] services) {
        String other2;
        int i;
        if (assignedPrinter == null) {
            return null;
        }
        if (services == null || services.length == 0) {
            return null;
        }
        int services_length = services.length;
        for (i = 0; i < services_length; ++i) {
            try {
                other2 = services[i].getName();
                if (services[i] == null || !other2.equals(assignedPrinter)) continue;
                return services[i];
            }
            catch (RuntimeException other2) {
                // empty catch block
            }
        }
        assignedPrinter = assignedPrinter.trim();
        for (i = 0; i < services_length; ++i) {
            try {
                other2 = services[i].getName().trim();
                if (services[i] == null || !other2.equals(assignedPrinter)) continue;
                return services[i];
            }
            catch (RuntimeException other3) {
                // empty catch block
            }
        }
        boolean startsWith = false;
        boolean endsWith = false;
        if (assignedPrinter.endsWith("*")) {
            startsWith = true;
            if (assignedPrinter.length() > 1) {
                assignedPrinter = assignedPrinter.substring(0, assignedPrinter.length() - 1);
            } else {
                assignedPrinter = "";
                endsWith = true;
            }
        }
        if (assignedPrinter.startsWith("*")) {
            endsWith = true;
            if (assignedPrinter.length() > 1) {
                assignedPrinter = assignedPrinter.substring(1);
            } else {
                assignedPrinter = "";
                startsWith = true;
            }
        }
        if (startsWith && endsWith) {
            String other42;
            int i2;
            for (i2 = 0; i2 < services_length; ++i2) {
                try {
                    other42 = services[i2].getName().trim();
                    if (other42.indexOf(assignedPrinter) < 0) continue;
                    return services[i2];
                }
                catch (RuntimeException other42) {
                    // empty catch block
                }
            }
            assignedPrinter = assignedPrinter.toUpperCase();
            for (i2 = 0; i2 < services_length; ++i2) {
                try {
                    other42 = services[i2].getName().trim().toUpperCase();
                    if (other42.indexOf(assignedPrinter) < 0) continue;
                    return services[i2];
                }
                catch (RuntimeException other5) {
                    // empty catch block
                }
            }
        } else if (startsWith) {
            String other62;
            int i3;
            for (i3 = 0; i3 < services_length; ++i3) {
                try {
                    other62 = services[i3].getName().trim();
                    if (!other62.startsWith(assignedPrinter)) continue;
                    return services[i3];
                }
                catch (RuntimeException other62) {
                    // empty catch block
                }
            }
            assignedPrinter = assignedPrinter.toUpperCase();
            for (i3 = 0; i3 < services_length; ++i3) {
                try {
                    other62 = services[i3].getName().trim().toUpperCase();
                    if (!other62.startsWith(assignedPrinter)) continue;
                    return services[i3];
                }
                catch (RuntimeException other7) {
                    // empty catch block
                }
            }
        } else if (endsWith) {
            String other82;
            int i4;
            for (i4 = 0; i4 < services_length; ++i4) {
                try {
                    other82 = services[i4].getName().trim();
                    if (!other82.endsWith(assignedPrinter)) continue;
                    return services[i4];
                }
                catch (RuntimeException other82) {
                    // empty catch block
                }
            }
            assignedPrinter = assignedPrinter.toUpperCase();
            for (i4 = 0; i4 < services_length; ++i4) {
                try {
                    other82 = services[i4].getName().trim().toUpperCase();
                    if (!other82.endsWith(assignedPrinter)) continue;
                    return services[i4];
                }
                catch (RuntimeException other9) {
                    // empty catch block
                }
            }
        } else {
            String other102;
            int i5;
            for (i5 = 0; i5 < services_length; ++i5) {
                try {
                    other102 = services[i5].getName().trim();
                    if (!other102.equals(assignedPrinter)) continue;
                    return services[i5];
                }
                catch (RuntimeException other102) {
                    // empty catch block
                }
            }
            assignedPrinter = assignedPrinter.toUpperCase();
            for (i5 = 0; i5 < services_length; ++i5) {
                try {
                    other102 = services[i5].getName().trim().toUpperCase();
                    if (!other102.equals(assignedPrinter)) continue;
                    return services[i5];
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    public boolean setPrinter(String name) {
        PrintService[] services;
        if (name != null) {
            name = name.trim();
        }
        if (name.length() == 0) {
            name = null;
        }
        if (name == null) {
            this.service = PrintServiceLookup.lookupDefaultPrintService();
            if (this.service != null) {
                return true;
            }
        }
        if ((services = PrintServiceLookup.lookupPrintServices(DocFlavor.SERVICE_FORMATTED.PRINTABLE, this.aset)) != null && services.length > 0) {
            this.service = this.lookup(name, services);
            if (this.service == null) {
                String check = attributes.get("PRINTER");
                if (check == null) {
                    check = attributes.get("DEVICE_NAME");
                }
                if (check == null) {
                    check = attributes.get("PRINTER");
                }
                if (check != null) {
                    name = String.valueOf(check).trim();
                    this.service = this.lookup(name, services);
                }
                if (this.service == null) {
                    this.service = PrintServiceLookup.lookupDefaultPrintService();
                }
            }
        } else {
            this.service = PrintServiceLookup.lookupDefaultPrintService();
        }
        return this.service != null;
    }

    private void verify(MediaPrintableArea mediaPrintableArea) {
        float x = mediaPrintableArea.getX(25400);
        float y = mediaPrintableArea.getY(25400);
        int basicx = (int)Math.rint((double)x * 72.0);
        int basicy = (int)Math.rint((double)y * 72.0);
        if (this.defaultTopMargin < BASIC_TOP_MARGIN) {
            this.defaultTopMargin = BASIC_TOP_MARGIN;
        }
        if (this.defaultTopMargin < basicy) {
            this.defaultTopMargin = basicy;
        }
        if (this.topMargin < this.defaultTopMargin) {
            this.topMargin = this.defaultTopMargin;
        }
        if (this.defaultLeftMargin < BASIC_LEFT_MARGIN) {
            this.defaultLeftMargin = BASIC_LEFT_MARGIN;
        }
        if (this.defaultLeftMargin < basicx) {
            this.defaultLeftMargin = basicx;
        }
        if (this.leftMargin < this.defaultLeftMargin) {
            this.leftMargin = this.defaultLeftMargin;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean open(boolean dialogEnabled, boolean rawMode, String filename) {
        try {
            this.init();
            String pf_font = "Monospaced";
            int pf_size = -1;
            int pf_style = 0;
            double HEIGHT_ADJUST = 0.97;
            double PAGESIZE_WIDTH_ADJUST = 0.93;
            double PAGESIZE_HEIGHT_ADJUST = 0.91;
            double DIMENSION = 0.825;
            int DPI = 600;
            if (filename == null) {
                filename = "";
            } else if ((filename = filename.trim()).endsWith("-?")) {
                filename = filename.substring(0, filename.length() - 2);
                dialogEnabled = false;
            } else if (filename.endsWith("?")) {
                filename = filename.substring(0, filename.length() - 1);
                dialogEnabled = true;
            }
            String check = null;
            String str = null;
            String assignedPrinter = null;
            try {
                String value = null;
                StringTokenizer st = new StringTokenizer(filename, "/:;");
                while (st.hasMoreTokens()) {
                    String fullToken;
                    String token = fullToken = st.nextToken();
                    value = "";
                    if (token == null) continue;
                    int equals = token.indexOf(61);
                    if (equals >= 0) {
                        value = token.substring(equals + 1);
                        token = token.substring(0, equals);
                    }
                    if ((token = token.trim().toUpperCase()).equals("PRINTER") || token.equals("DRIVER") || token.equals("NAME")) {
                        assignedPrinter = value;
                        continue;
                    }
                    if (token.equals("FONT")) {
                        pf_font = value;
                        continue;
                    }
                    if (token.equals("SIZE")) {
                        pf_size = ConvertData.parseInt(value.trim());
                        continue;
                    }
                    if (token.equals("COLS")) {
                        this.cols = ConvertData.parseInt(value.trim());
                        continue;
                    }
                    if (token.equals("ROWS")) {
                        this.rows = ConvertData.parseInt(value.trim());
                        continue;
                    }
                    if (token.equals("CODEPAGE") || token.equals("CP")) {
                        value = value.trim();
                        continue;
                    }
                    if (token.equals("ALIGNX")) {
                        this.alignx = ConvertData.parseInt(value.trim());
                        continue;
                    }
                    if (token.equals("ALIGNY")) {
                        this.aligny = ConvertData.parseInt(value.trim());
                        continue;
                    }
                    if (token.equals("MARGINX")) {
                        this.defaultLeftMargin = ConvertData.parseInt(value.trim());
                        continue;
                    }
                    if (token.equals("MARGINY")) {
                        this.defaultTopMargin = ConvertData.parseInt(value.trim());
                        continue;
                    }
                    if (token.equals("DPI")) {
                        DPI = ConvertData.parseInt(value.trim());
                        continue;
                    }
                    if (token.equals("BOLD")) {
                        pf_style |= 1;
                        continue;
                    }
                    if (token.equals("ITALIC")) {
                        pf_style |= 2;
                        continue;
                    }
                    if (token.equals("PLAIN")) {
                        pf_style = 0;
                        continue;
                    }
                    if (token.equals("GRAPHICS") || token.equals("GFX")) {
                        this.enableGraphics = true;
                        if (value == null || value.length() <= 0) continue;
                        this.graphicsTag = value;
                        continue;
                    }
                    if (token.equals("TEXT")) {
                        this.enableGraphics = false;
                        continue;
                    }
                    if (token.equals("HEIGHT-ADJUST")) {
                        HEIGHT_ADJUST = Double.valueOf(value.trim());
                        if (!(HEIGHT_ADJUST <= 0.0)) continue;
                        HEIGHT_ADJUST = 0.97;
                        continue;
                    }
                    if (token.equals("PAGE-WIDTH-ADJUST")) {
                        PAGESIZE_WIDTH_ADJUST = Double.valueOf(value.trim());
                        if (!(PAGESIZE_WIDTH_ADJUST <= 0.0)) continue;
                        PAGESIZE_WIDTH_ADJUST = 0.93;
                        continue;
                    }
                    if (token.equals("PAGE-HEIGHT-ADJUST")) {
                        PAGESIZE_HEIGHT_ADJUST = Double.valueOf(value.trim());
                        if (!(PAGESIZE_HEIGHT_ADJUST <= 0.0)) continue;
                        PAGESIZE_HEIGHT_ADJUST = 0.91;
                        continue;
                    }
                    if (token.equals("DIMENSION")) {
                        DIMENSION = Double.valueOf(value.trim());
                        if (!(DIMENSION <= 0.0)) continue;
                        DIMENSION = 0.825;
                        continue;
                    }
                    if (assignedPrinter != null) continue;
                    assignedPrinter = fullToken;
                }
            }
            catch (Throwable tokenizationException) {
                JVM14Driver.log(tokenizationException);
            }
            if (assignedPrinter == null) {
                assignedPrinter = filename;
            }
            if (this.service == null && !this.setPrinter(assignedPrinter)) {
                Semaphore tokenizationException = this.openedObject;
                synchronized (tokenizationException) {
                    this.openedObject.release();
                }
                return false;
            }
            MediaPrintableArea mediaPrintableArea = null;
            if (this.service != null && (mediaPrintableArea = (MediaPrintableArea)this.service.getDefaultAttributeValue(MediaPrintableArea.class)) != null) {
                this.aset.add(mediaPrintableArea);
                this.verify(mediaPrintableArea);
            }
            int pixelsPerInch = 72;
            this.multiplierXInches = pixelsPerInch;
            this.multiplierYInches = pixelsPerInch;
            this.multiplierXMetric = this.multiplierXInches * 0.3937;
            this.multiplierYMetric = this.multiplierYInches * 0.3937;
            this.multiplierYDeviceUnits = (double)pixelsPerInch / (double)DPI;
            this.multiplierXDeviceUnits = (double)pixelsPerInch / (double)DPI;
            ThreadQueue backgroundJob = null;
            check = attributes.get("DIALOG");
            if (check != null && (str = String.valueOf(check)).length() > 0) {
                switch (str.charAt(0)) {
                    case '0': 
                    case 'N': 
                    case 'n': {
                        dialogEnabled = false;
                    }
                }
            }
            if (dialogEnabled) {
                boolean okay = false;
                if (this.printerJob == null) {
                    this.printerJob = PrinterJob.getPrinterJob();
                    if (this.printerJob != null && this.service != null) {
                        this.printerJob.setPrintService(this.service);
                    }
                }
                if (this.printerJob != null) {
                    okay = this.printerJob.printDialog(this.aset);
                }
                if (!okay) {
                    Semaphore equals = this.openedObject;
                    synchronized (equals) {
                        this.openedObject.release();
                    }
                    return false;
                }
                this.service = this.printerJob.getPrintService();
                this.aset.remove(MediaPrintableArea.class);
                mediaPrintableArea = (MediaPrintableArea)this.service.getDefaultAttributeValue(MediaPrintableArea.class);
                if (mediaPrintableArea != null) {
                    this.aset.add(mediaPrintableArea);
                    this.verify(mediaPrintableArea);
                }
                dialogEnabled = false;
            }
            mediaPrintableArea = (MediaPrintableArea)this.aset.get(MediaPrintableArea.class);
            OrientationRequested orientationRequested = (OrientationRequested)this.aset.get(OrientationRequested.class);
            double page_x = mediaPrintableArea.getX(25400);
            double page_y = mediaPrintableArea.getY(25400);
            double page_w = mediaPrintableArea.getWidth(25400);
            double page_h = mediaPrintableArea.getHeight(25400);
            if (orientationRequested == OrientationRequested.LANDSCAPE || orientationRequested == OrientationRequested.REVERSE_LANDSCAPE) {
                double temp = 0.0;
                temp = page_x;
                page_x = page_y;
                page_y = temp;
                temp = page_w;
                page_w = page_h;
                page_h = temp;
            }
            double pagesize_width = (page_w + page_x + page_x) * (double)pixelsPerInch;
            double pagesize_height = (page_h + page_y + page_y) * (double)pixelsPerInch;
            this.pageBoundaryX = (int)Math.ceil(pagesize_width);
            this.pageBoundaryY = (int)Math.ceil(pagesize_height);
            int adjust_pagesize_width = (int)(pagesize_width * PAGESIZE_WIDTH_ADJUST);
            int adjust_pagesize_height = (int)(pagesize_height * PAGESIZE_HEIGHT_ADJUST);
            double desiredPointSize = 80.0 / (double)this.cols * 12.0;
            double doublePrinterPageLength = pagesize_height / desiredPointSize;
            this.printerPageLength = (int)doublePrinterPageLength;
            if (this.rows == -1) {
                this.rows = this.printerPageLength;
            }
            if (this.rows < this.printerPageLength) {
                this.printerPageLength = this.rows;
            }
            this.printerFontHeight = (int)Math.ceil((double)adjust_pagesize_height / doublePrinterPageLength) - 1;
            if (pf_size < 0) {
                pf_size = this.printerFontHeight;
            }
            this.printerFontWidth = adjust_pagesize_width / this.cols;
            this.printerFontMetricHeight = (double)this.printerFontHeight * HEIGHT_ADJUST;
            this.setDefaultFont(new Font(pf_font, pf_style, pf_size));
            this.resetX();
            this.resetY();
            final PrintRequestAttributeSet asetFinal = this.aset;
            if (dialogEnabled) {
                this.printerJob.setPrintable(this);
                final PrinterJob backgroundPrintJob = this.printerJob;
                backgroundJob = new ThreadQueue("CobolPrinter14 print job interactive"){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        try {
                            Shutdown.increaseCobolThreadDependencies();
                            backgroundPrintJob.print(asetFinal);
                            Shutdown.decreaseCobolThreadDependencies();
                        }
                        catch (PrinterException printerException) {
                            JVM14Driver.log(printerException);
                        }
                        Semaphore semaphore = JVM14Driver.this.openedObject;
                        synchronized (semaphore) {
                            JVM14Driver.this.openedObject.release();
                        }
                    }
                };
                dialogEnabled = false;
            } else {
                this.job = this.service.createPrintJob();
                if (this.job == null) {
                    Semaphore backgroundPrintJob = this.openedObject;
                    synchronized (backgroundPrintJob) {
                        this.openedObject.release();
                    }
                    return false;
                }
                this.job.addPrintJobListener(this);
                final PrintableDoc doc = new PrintableDoc(this);
                final DocPrintJob backgroundPrintJob = this.job;
                backgroundJob = new ThreadQueue("CobolPrinter14 print job batch"){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        try {
                            Shutdown.increaseCobolThreadDependencies();
                            backgroundPrintJob.print(doc, asetFinal);
                            Shutdown.decreaseCobolThreadDependencies();
                        }
                        catch (PrintException e) {
                            JVM14Driver.log(e);
                        }
                        Semaphore semaphore = JVM14Driver.this.openedObject;
                        synchronized (semaphore) {
                            JVM14Driver.this.openedObject.release();
                        }
                    }
                };
            }
            this.open = true;
            backgroundJob.start();
        }
        catch (Throwable logException) {
            JVM14Driver.log(logException);
            Semaphore semaphore = this.openedObject;
            synchronized (semaphore) {
                this.openedObject.release();
            }
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void eject() {
        if (this.isEmptyJob()) {
            return;
        }
        try {
            this.realizeConnectors();
            try {
                Semaphore semaphore = this.ejectObject;
                synchronized (semaphore) {
                    ++this.pageIndex;
                    this.ejectObject.release();
                    this.resetX();
                    this.resetY();
                }
            }
            catch (Throwable t) {
                JVM14Driver.log(t);
            }
        }
        catch (Exception e) {
            JVM14Driver.log(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        this.lastPageIndex = this.pageIndex + 1;
        this.eject();
        if (this.job != null) {
            this.job.removePrintJobListener(this);
            this.job = null;
        }
        this.printerJob = null;
        this.reset();
        Semaphore semaphore = this.openedObject;
        synchronized (semaphore) {
            try {
                this.openedObject.acquire();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.open = false;
    }

    private void reset() {
        this.defaultTopMargin = BASIC_TOP_MARGIN;
        this.defaultLeftMargin = BASIC_LEFT_MARGIN;
        this.defaultBottomMargin = BASIC_BOTTOM_MARGIN;
        this.leftMargin = this.defaultLeftMargin;
        this.topMargin = this.defaultTopMargin;
        this.nextTopMargin = this.defaultTopMargin;
        this.bottomMargin = this.defaultBottomMargin;
        this.xpos = this.leftMargin;
        this.ypos = this.topMargin;
        this.lineFromX = BASIC_LEFT_MARGIN;
        this.lineFromY = BASIC_TOP_MARGIN;
        this.fontUnderline = false;
        this.fontStrikeOut = false;
        this.fontDoubleStrike = false;
    }

    @Override
    public void clearFont() {
        this.setFont(this.defaultFont);
    }

    @Override
    public Dimension getTextExtent(String text) {
        FontMetrics fontMetrics = this.getFontMetrics();
        if (fontMetrics == null) {
            return null;
        }
        int width = fontMetrics.stringWidth(text);
        int height = fontMetrics.getHeight();
        return new Dimension(width, height);
    }

    @Override
    public double getTextPositionX(boolean bottom) {
        return this.xpos;
    }

    @Override
    public double getTextPositionY(boolean bottom) {
        if (bottom) {
            return this.ypos + (double)this.fontDescent;
        }
        return this.ypos - (double)this.fontAscent;
    }

    @Override
    public void setFont(Font f, boolean underline, boolean strikeOut, boolean doubleStrike) {
        this.fontUnderline = underline;
        this.fontStrikeOut = strikeOut;
        this.fontDoubleStrike = doubleStrike;
        this.setFont(f);
    }

    @Override
    public boolean isFontUnderline() {
        return this.fontUnderline;
    }

    @Override
    public boolean isFontStrikeOut() {
        return this.fontStrikeOut;
    }

    public boolean isFontDoubleStrike() {
        return this.fontDoubleStrike;
    }

    public void setFont(Font f) {
        if (this.defaultFont == null) {
            this.defaultFont = f;
        }
        if (f == null) {
            f = this.defaultFont;
        }
        if (this.isEmptyJob()) {
            return;
        }
        this.addPrintQueue(new PrintQueue(f));
        this.font = f;
        this.fontMetrics = Utils.getFontMetrics(this.font);
        this.fontAscent = this.fontMetrics.getHeight() + this.fontMetrics.getAscent();
        this.fontDescent = this.fontMetrics.getDescent();
        this.multiplierYCharacters = (this.fontMetrics.getHeight() - this.fontMetrics.getDescent() + (this.fontMetrics.getLeading() + this.fontMetrics.getAscent())) / 2 - 1;
        if (this.multiplierYCharacters < 1.0) {
            this.multiplierYCharacters = 1.0;
        }
        int totalWidth = 0;
        int totalCount = 0;
        int indiWidth = 0;
        for (int i = 0; i < 128; ++i) {
            indiWidth = this.fontMetrics.charWidth(i);
            if (indiWidth <= 1) continue;
            ++totalCount;
            totalWidth += indiWidth;
        }
        this.multiplierXCharacters = totalCount > 0 ? (double)totalWidth / (double)totalCount : this.multiplierYCharacters;
        this.multiplierYDeviceUnits = 0.12;
        this.multiplierXDeviceUnits = 0.12;
    }

    public void setDefaultFont(Font f) {
        if (this.defaultFont == null) {
            this.defaultFont = f;
        }
        if (f == null) {
            f = this.defaultFont;
        }
        this.font = f;
        this.fontMetrics = Utils.getFontMetrics(this.font);
        this.fontAscent = this.fontMetrics.getHeight() + this.fontMetrics.getAscent();
        this.fontDescent = this.fontMetrics.getDescent();
        this.multiplierYCharacters = (this.fontMetrics.getHeight() - this.fontMetrics.getDescent() + (this.fontMetrics.getLeading() + this.fontMetrics.getAscent())) / 2 - 1;
        if (this.multiplierYCharacters < 1.0) {
            this.multiplierYCharacters = 1.0;
        }
        int totalWidth = 0;
        int totalCount = 0;
        int indiWidth = 0;
        for (int i = 0; i < 128; ++i) {
            indiWidth = this.fontMetrics.charWidth(i);
            if (indiWidth <= 1) continue;
            ++totalCount;
            totalWidth += indiWidth;
        }
        this.multiplierXCharacters = totalCount > 0 ? (double)totalWidth / (double)totalCount : this.multiplierYCharacters;
        this.multiplierYDeviceUnits = 0.12;
        this.multiplierXDeviceUnits = 0.12;
    }

    @Override
    public Font getFont() {
        if (this.font == null) {
            this.setFont(new Font("Monospaced", 0, 10));
        }
        return this.font;
    }

    @Override
    public FontMetrics getFontMetrics() {
        if (this.fontMetrics == null) {
            this.getFont();
        }
        return this.fontMetrics;
    }

    @Override
    public void setLineExtend(double extend) {
        this.lineExtend = (int)extend;
    }

    @Override
    public void setPitch(int pitchType) {
    }

    @Override
    public void setTabStop(double tabStop) {
        this.tabStop = (int)tabStop;
    }

    @Override
    public void setTextColor(Color textColor) {
        this.textColor = textColor;
    }

    @Override
    public Color getTextColor() {
        return this.textColor != null ? this.textColor : Color.black;
    }

    @Override
    public void setTextPositionX(double xpos, boolean bottom) {
        this.xpos = xpos;
    }

    @Override
    public void setTextPositionY(double ypos, boolean bottom) {
        this.ypos = bottom ? ypos - (double)this.fontDescent : ypos + (double)this.fontAscent;
    }

    @Override
    public void textOut(String text, double xpos, double ypos, boolean box, boolean shade) {
        if (this.isEmptyJob()) {
            return;
        }
        this.addPrintQueue(new PrintQueue(this.getFont()));
        Color c = this.getTextColor();
        int w = this.fontMetrics.stringWidth(text);
        int h = (int)this.multiplierYCharacters;
        int lines = 1;
        int advances = 0;
        int textLength = text.length();
        for (int i = 0; i < textLength; ++i) {
            if (text.charAt(i) == '\n') {
                ++lines;
            }
            if (text.charAt(i) != '\r') continue;
            ++advances;
        }
        h *= lines;
        int x = (int)xpos;
        int y = (int)ypos;
        int boxOffsetX = x + this.leftMargin - 2;
        int boxOffsetY = y - (h += advances * this.lineExtend) + this.topMargin;
        int widestW = -1;
        if (w > 0 && shade) {
            this.addPrintQueue(new PrintQueue(this.getShadeColor()));
            this.addPrintQueue(new PrintQueue(5, boxOffsetX, boxOffsetY, w + 2, h + 2));
        }
        this.addPrintQueue(new PrintQueue(c));
        StringBuffer result = new StringBuffer();
        String resultString = null;
        char ch = '\u0000';
        int descender = this.fontMetrics.getDescent();
        block6: for (int i = 0; i < textLength; ++i) {
            ch = text.charAt(i);
            switch (ch) {
                case '\r': {
                    int stringWidth;
                    int at_y;
                    int at_x;
                    resultString = result.toString();
                    if (resultString != null && resultString.length() > 0) {
                        at_x = x + this.leftMargin;
                        at_y = y + this.topMargin;
                        this.addPrintQueue(new PrintQueue(15, resultString, at_x, at_y));
                        stringWidth = this.fontMetrics.stringWidth(resultString);
                        if (stringWidth > widestW) {
                            widestW = stringWidth;
                        }
                        if (this.fontUnderline) {
                            this.addPrintQueue(new PrintQueue(14, at_x, at_y + descender, at_x + stringWidth, at_y + descender));
                        }
                        if (this.fontStrikeOut) {
                            this.addPrintQueue(new PrintQueue(14, at_x, at_y - h / 2, at_x + stringWidth, at_y - h / 2));
                        }
                        if (this.fontDoubleStrike) {
                            this.addPrintQueue(new PrintQueue(15, resultString, at_x + 1, at_y));
                        }
                        x += stringWidth;
                    }
                    result.setLength(0);
                    y += this.lineExtend;
                    x = 0;
                    continue block6;
                }
                case '\n': {
                    int stringWidth;
                    int at_y;
                    int at_x;
                    resultString = result.toString();
                    if (resultString != null && resultString.length() > 0) {
                        at_x = x + this.leftMargin;
                        at_y = y + this.topMargin;
                        this.addPrintQueue(new PrintQueue(15, resultString, at_x, at_y));
                        stringWidth = this.fontMetrics.stringWidth(resultString);
                        if (stringWidth > widestW) {
                            widestW = stringWidth;
                        }
                        if (this.fontUnderline) {
                            this.addPrintQueue(new PrintQueue(14, at_x, at_y + descender, at_x + stringWidth, at_y + descender));
                        }
                        if (this.fontStrikeOut) {
                            this.addPrintQueue(new PrintQueue(14, at_x, at_y - h / 2, at_x + stringWidth, at_y - h / 2));
                        }
                        if (this.fontDoubleStrike) {
                            this.addPrintQueue(new PrintQueue(15, resultString, at_x + 1, at_y));
                        }
                        x += stringWidth;
                    }
                    result.setLength(0);
                    y += h;
                    y -= this.lineExtend;
                    continue block6;
                }
                case '\u0000': {
                    continue block6;
                }
                default: {
                    result.append(ch);
                }
            }
        }
        if (result.length() > 0 && (resultString = result.toString()) != null && resultString.length() > 0) {
            int at_x = x + this.leftMargin;
            int at_y = y + this.topMargin;
            this.addPrintQueue(new PrintQueue(15, resultString, at_x, at_y));
            int stringWidth = this.fontMetrics.stringWidth(resultString);
            if (stringWidth > widestW) {
                widestW = stringWidth;
            }
            if (this.fontUnderline) {
                this.addPrintQueue(new PrintQueue(14, at_x, at_y + descender, at_x + stringWidth, at_y + descender));
            }
            if (this.fontStrikeOut) {
                this.addPrintQueue(new PrintQueue(14, at_x, at_y - h / 2, at_x + stringWidth, at_y - h / 2));
            }
            if (this.fontDoubleStrike) {
                this.addPrintQueue(new PrintQueue(15, resultString, at_x + 1, at_y));
            }
            x += stringWidth;
        }
        this.xpos = x;
        this.ypos = y;
        w = widestW;
        if (w > 0) {
            this.addPrintQueue(new PrintQueue(c));
            if (box) {
                this.addPrintQueue(new PrintQueue(7, boxOffsetX, boxOffsetY, w + 2, h + 2));
            }
        }
    }

    private int indexOfEscapesFull(String text) {
        return this.indexOfAny(text, ESCAPES_FULL);
    }

    private int indexOfEscapesSimple(String text) {
        return this.indexOfAny(text, ESCAPES_SIMPLE);
    }

    private int indexOfAny(String text, char[] escapes) {
        int min = Integer.MAX_VALUE;
        int index = -1;
        if (escapes != null) {
            int length = escapes.length;
            for (int i = 0; i < length; ++i) {
                index = text.indexOf(escapes[i]);
                if (index < 0 || index >= min) continue;
                min = index;
            }
        }
        return min == Integer.MAX_VALUE ? -1 : min;
    }

    @Override
    public boolean write(String text) {
        boolean ejected;
        block13: {
            if (this.isEmptyJob()) {
                return false;
            }
            if (text == null) {
                return false;
            }
            String partial = null;
            ejected = false;
            text = text.replace('\u0000', ' ');
            try {
                if (this.escapeSequences) {
                    int split = -1;
                    do {
                        if ((split = this.indexOfEscapesFull(text)) >= 0) {
                            try {
                                partial = text.substring(0, split);
                                this.writeText(partial);
                            }
                            catch (Exception partialTextException) {
                                JVM14Driver.log(partialTextException);
                            }
                            text = this.writeEscape(text.substring(split));
                            ejected |= this.ejectOnPageSplit();
                            continue;
                        }
                        this.writeText(text);
                        text = null;
                    } while (split >= 0);
                    break block13;
                }
                int split = -1;
                do {
                    if ((split = this.indexOfEscapesSimple(text)) >= 0) {
                        try {
                            partial = text.substring(0, split);
                            this.writeText(partial);
                        }
                        catch (Exception partialTextException) {
                            JVM14Driver.log(partialTextException);
                        }
                        text = this.writeEscape(text.substring(split));
                        ejected |= this.ejectOnPageSplit();
                        continue;
                    }
                    this.writeText(text);
                    text = null;
                } while (split >= 0);
            }
            catch (Throwable writeException) {
                JVM14Driver.log(writeException);
            }
        }
        return ejected;
    }

    private boolean ejectOnPageSplit() {
        if (this.ypos >= (double)this.pageSplitBoundary) {
            this.eject();
            return true;
        }
        return false;
    }

    public void writeText(String text) {
        if (text == null) {
            return;
        }
        if (text.length() == 0) {
            return;
        }
        if (this.enableGraphics && text.startsWith(this.graphicsTag)) {
            this.drawTextEscapeGraphics(text);
            return;
        }
        int x = (int)(this.xpos + (double)this.leftMargin);
        int y = (int)(this.ypos + (double)this.topMargin);
        this.addPrintQueue(new PrintQueue(this.getTextColor()));
        this.addPrintQueue(new PrintQueue(this.getFont()));
        this.addPrintQueue(new PrintQueue(15, text, x, y));
        this.xpos += (double)this.fontMetrics.stringWidth(text);
    }

    private void setPaperTray(int value) {
        switch (value) {
            case 1: {
                this.aset.add(MediaTray.MAIN);
                break;
            }
            case 2: {
                this.aset.add(MediaTray.BOTTOM);
                break;
            }
            case 3: {
                this.aset.add(MediaTray.MIDDLE);
                break;
            }
            case 5: {
                this.aset.add(MediaTray.ENVELOPE);
                break;
            }
            case 11: {
                this.aset.add(MediaTray.LARGE_CAPACITY);
            }
        }
    }

    public String writeEscape(String text) {
        if (text == null) {
            return null;
        }
        if (text.length() <= 0) {
            return text;
        }
        switch (text.charAt(0)) {
            case '\t': {
                int int_xpos = (int)this.xpos;
                int int_tabStop = this.tabStop;
                if (int_tabStop > 0) {
                    int_xpos = int_xpos % int_tabStop == 0 ? (int_xpos += int_tabStop) : (int_xpos += int_xpos % int_tabStop);
                    this.xpos = int_xpos;
                }
                if (this.xpos >= (double)this.pageBoundaryX) {
                    this.resetX();
                    this.ypos += this.multiplierYCharacters - (double)this.lineExtend;
                }
                return text.substring(1);
            }
            case '\n': {
                this.ypos += this.multiplierYCharacters - (double)this.lineExtend;
                return text.substring(1);
            }
            case '\r': {
                this.resetX();
                this.ypos += (double)this.lineExtend;
                return text.substring(1);
            }
            case '\u000e': {
                Font currentFont = this.getFont();
                this.addPrintQueue(new PrintQueue(new Font(currentFont.getName(), currentFont.getStyle() | 1, currentFont.getSize())));
                return text.substring(1);
            }
            case '\u000f': {
                Font currentFont = this.getFont();
                this.addPrintQueue(new PrintQueue(new Font(currentFont.getName(), currentFont.getStyle() & 0xFFFFFFFE, currentFont.getSize())));
                return text.substring(1);
            }
            case '\u001b': {
                char value = text.charAt(3);
                switch (text.charAt(1)) {
                    case '&': {
                        switch (text.charAt(2)) {
                            case 'a': {
                                switch (text.charAt(4)) {
                                    case 'L': {
                                        this.leftMargin = (int)((double)BASIC_LEFT_MARGIN + (double)value * this.multiplierXCharacters);
                                    }
                                }
                                return text.substring(4);
                            }
                            case 'k': {
                                switch (text.charAt(4)) {
                                    case 'H': {
                                        this.tabStop = (int)((double)value * this.multiplierXCharacters);
                                    }
                                }
                                return text.substring(4);
                            }
                            case 'l': {
                                block25 : switch (text.charAt(4)) {
                                    case 'D': {
                                        this.lineExtend = value;
                                        break;
                                    }
                                    case 'E': {
                                        this.topMargin = (int)((double)value * this.multiplierYCharacters + (double)BASIC_TOP_MARGIN);
                                        break;
                                    }
                                    case 'F': {
                                        this.rows = this.printerPageLength = (int)value;
                                        break;
                                    }
                                    case 'H': {
                                        this.setPaperTray(value);
                                        break;
                                    }
                                    case 'O': {
                                        switch (value) {
                                            case '\u0000': {
                                                this.aset.add(OrientationRequested.PORTRAIT);
                                                break block25;
                                            }
                                            case '\u0001': {
                                                this.aset.add(OrientationRequested.LANDSCAPE);
                                                break block25;
                                            }
                                            case '\u0002': {
                                                this.aset.add(OrientationRequested.REVERSE_LANDSCAPE);
                                                break block25;
                                            }
                                            case '\u0003': {
                                                this.aset.add(OrientationRequested.REVERSE_PORTRAIT);
                                            }
                                        }
                                    }
                                }
                                return text.substring(4);
                            }
                        }
                        return text.substring(3);
                    }
                    case '(': {
                        switch (text.charAt(2)) {
                            case 's': {
                                switch (text.charAt(4)) {
                                    case 'H': {
                                        break;
                                    }
                                    case 'S': {
                                        break;
                                    }
                                    case 'V': {
                                        Font currentFont = this.getFont();
                                        this.addPrintQueue(new PrintQueue(new Font(currentFont.getName(), currentFont.getStyle(), value)));
                                    }
                                }
                                return text.substring(4);
                            }
                        }
                        return text.substring(3);
                    }
                    case '9': {
                        this.leftMargin = this.defaultLeftMargin;
                        this.topMargin = this.defaultTopMargin;
                        return text.substring(2);
                    }
                    case 'E': {
                        this.clearFont();
                        this.leftMargin = this.defaultLeftMargin;
                        this.topMargin = this.defaultTopMargin;
                        return text.substring(2);
                    }
                }
                return text.substring(2);
            }
        }
        return text.substring(1);
    }

    @Override
    public void setLeftMargin(double leftMargin) {
        this.leftMargin = (int)leftMargin + BASIC_LEFT_MARGIN;
    }

    @Override
    public double getLeftMargin() {
        return this.leftMargin - BASIC_LEFT_MARGIN;
    }

    @Override
    public void setBottomMargin(double leftMargin) {
        this.bottomMargin = this.bottomMargin;
    }

    @Override
    public double getBottomMargin() {
        return this.bottomMargin;
    }

    @Override
    public void setTopMargin(double topMargin) {
        this.nextTopMargin = (int)topMargin + BASIC_TOP_MARGIN;
    }

    @Override
    public double getTopMargin() {
        return this.topMargin - BASIC_TOP_MARGIN;
    }

    @Override
    public void setDeviceMode(String attrib, String value) {
        this.setAttribute(attrib, value);
    }

    @Override
    public String getDeviceCapability(String attrib) {
        try {
            attrib = this.normalizeAttribute(attrib);
            if (attrib != null) {
                QueuedJobCount queuedJobCount;
                PrinterURI printerURI;
                PrinterStateReasons printerStateReasons;
                PrinterState printerState;
                PrinterName printerName;
                PrinterMoreInfoManufacturer printerMoreInfoManufacturer;
                PrinterMoreInfo printerMoreInfo;
                PrinterMessageFromOperator printerMessageFromOperator;
                PrinterMakeAndModel printerMakeAndModel;
                PrinterLocation printerLocation;
                PrinterIsAcceptingJobs printerIsAcceptingJobs;
                PrinterInfo printerInfo;
                PDLOverrideSupported pdlOverrideSupported;
                PagesPerMinuteColor pagesPerMinuteColor;
                PagesPerMinute pagesPerMinute;
                ColorSupported colorSupported;
                if ("PRINTERS".equals(attrib)) {
                    PrintService[] services = PrintServiceLookup.lookupPrintServices(DocFlavor.SERVICE_FORMATTED.PRINTABLE, this.aset);
                    if (services == null) {
                        return "0";
                    }
                    return String.valueOf(services.length);
                }
                if (attrib.startsWith("PRINTER#")) {
                    String num = attrib.substring(8);
                    PrintService[] services = PrintServiceLookup.lookupPrintServices(DocFlavor.SERVICE_FORMATTED.PRINTABLE, this.aset);
                    int number = ConvertData.parseInt(num) - 1;
                    if (number >= 0 && number < services.length && services[number] != null) {
                        return services[number].getName();
                    }
                    return null;
                }
                if ("DEFAULT".equals(attrib)) {
                    PrintService defaultService = PrintServiceLookup.lookupDefaultPrintService();
                    if (defaultService != null) {
                        return defaultService.getName();
                    }
                    return null;
                }
                if ("DRIVER_VERSION".equals(attrib)) {
                    return "4.03";
                }
                if ("TECHNOLOGY".equals(attrib)) {
                    return "Elastic COBOL JDK 1.4 Driver";
                }
                if ("SUPPORTED".equals(attrib)) {
                    return "28,HORIZONTAL_SIZE,VERTICAL_SIZE,HORIZONTAL_RESOLUTION,VERTICAL_RESOLUTION,HORIZONTAL_INCHES,VERTICAL_INCHES,PHYSICAL_WIDTH,PHYSICAL_HEIGHT,LOGICAL_PIXELS_X,LOGICAL_PIXELS_Y,TECHNOLOGY,COLOR_SUPPORTED,PAGES_PER_MINUTE,PAGES_PER_MINUTE_COLOR,PDL_OVERRIDE_SUPPORTED,PRINTER_INFO,PRINTER_IS_ACCEPTING_JOBS,PRINTER_LOCATION,PRINTER_MAKE_AND_MODEL,PRINTER_MESSAGE_FROM_OPERATOR,PRINTER_MORE_INFO,PRINTER_MORE_INFO_MANUFACTURER,PRINTER_NAME,PRINTER_STATE,PRINTER_STATE_REASONS,PRINTER_URI,QUEUED_JOB_COUNT,PRINTERS,PRINTER#,DEFAULT";
                }
                PrintService service = this.getService();
                if ("COLOR_SUPPORTED".equals(attrib) && (colorSupported = service.getAttribute(ColorSupported.class)) != null) {
                    return colorSupported.toString();
                }
                if ("PAGES_PER_MINUTE".equals(attrib) && (pagesPerMinute = service.getAttribute(PagesPerMinute.class)) != null) {
                    return pagesPerMinute.toString();
                }
                if ("PAGES_PER_MINUTE_COLOR".equals(attrib) && (pagesPerMinuteColor = service.getAttribute(PagesPerMinuteColor.class)) != null) {
                    return pagesPerMinuteColor.toString();
                }
                if ("PDL_OVERRIDE_SUPPORTED".equals(attrib) && (pdlOverrideSupported = service.getAttribute(PDLOverrideSupported.class)) != null) {
                    return pdlOverrideSupported.toString();
                }
                if ("PRINTER_INFO".equals(attrib) && (printerInfo = service.getAttribute(PrinterInfo.class)) != null) {
                    return printerInfo.toString();
                }
                if ("PRINTER_IS_ACCEPTING_JOBS".equals(attrib) && (printerIsAcceptingJobs = service.getAttribute(PrinterIsAcceptingJobs.class)) != null) {
                    return printerIsAcceptingJobs.toString();
                }
                if ("PRINTER_LOCATION".equals(attrib) && (printerLocation = service.getAttribute(PrinterLocation.class)) != null) {
                    return printerLocation.toString();
                }
                if ("PRINTER_MAKE_AND_MODEL".equals(attrib) && (printerMakeAndModel = service.getAttribute(PrinterMakeAndModel.class)) != null) {
                    return printerMakeAndModel.toString();
                }
                if ("PRINTER_MESSAGE_FROM_OPERATOR".equals(attrib) && (printerMessageFromOperator = service.getAttribute(PrinterMessageFromOperator.class)) != null) {
                    return printerMessageFromOperator.toString();
                }
                if ("PRINTER_MORE_INFO".equals(attrib) && (printerMoreInfo = service.getAttribute(PrinterMoreInfo.class)) != null) {
                    return printerMoreInfo.toString();
                }
                if ("PRINTER_MORE_INFO_MANUFACTURER".equals(attrib) && (printerMoreInfoManufacturer = service.getAttribute(PrinterMoreInfoManufacturer.class)) != null) {
                    return printerMoreInfoManufacturer.toString();
                }
                if ("PRINTER_NAME".equals(attrib) && (printerName = service.getAttribute(PrinterName.class)) != null) {
                    return printerName.toString();
                }
                if ("PRINTER_STATE".equals(attrib) && (printerState = service.getAttribute(PrinterState.class)) != null) {
                    return printerState.toString();
                }
                if ("PRINTER_STATE_REASONS".equals(attrib) && (printerStateReasons = service.getAttribute(PrinterStateReasons.class)) != null) {
                    return printerStateReasons.toString();
                }
                if ("PRINTER_URI".equals(attrib) && (printerURI = service.getAttribute(PrinterURI.class)) != null) {
                    return printerURI.toString();
                }
                if ("QUEUED_JOB_COUNT".equals(attrib) && (queuedJobCount = service.getAttribute(QueuedJobCount.class)) != null) {
                    return queuedJobCount.toString();
                }
                int pixelsPerInch = 72;
                MediaPrintableArea mediaPrintableArea = (MediaPrintableArea)service.getDefaultAttributeValue(MediaPrintableArea.class);
                if ("HORIZONTAL_SIZE".equals(attrib) || "HORIZONTAL_AREA".equals(attrib)) {
                    if (mediaPrintableArea == null) {
                        return "0";
                    }
                    return String.valueOf(mediaPrintableArea.getWidth(1000));
                }
                if ("VERTICAL_SIZE".equals(attrib) || "VERTICAL_AREA".equals(attrib)) {
                    if (mediaPrintableArea == null) {
                        return "0";
                    }
                    return String.valueOf(mediaPrintableArea.getHeight(1000));
                }
                if ("HORIZONTAL_RESOLUTION".equals(attrib)) {
                    if (mediaPrintableArea == null) {
                        return "0";
                    }
                    return String.valueOf(mediaPrintableArea.getWidth(25400) * 72.0f);
                }
                if ("VERTICAL_RESOLUTION".equals(attrib)) {
                    if (mediaPrintableArea == null) {
                        return "0";
                    }
                    return String.valueOf(mediaPrintableArea.getHeight(25400) * 72.0f);
                }
                if ("HORIZONTAL_INCHES".equals(attrib)) {
                    if (mediaPrintableArea == null) {
                        return "0";
                    }
                    return String.valueOf(mediaPrintableArea.getWidth(25400));
                }
                if ("VERTICAL_INCHES".equals(attrib)) {
                    if (mediaPrintableArea == null) {
                        return "0";
                    }
                    return String.valueOf(mediaPrintableArea.getHeight(25400));
                }
                if ("PHYSICAL_WIDTH".equals(attrib)) {
                    return String.valueOf((double)mediaPrintableArea.getWidth(25400) * (72.0 / this.multiplierXDeviceUnits));
                }
                if ("PHYSICAL_HEIGHT".equals(attrib)) {
                    return String.valueOf((double)mediaPrintableArea.getHeight(25400) * (72.0 / this.multiplierYDeviceUnits));
                }
                if ("LOGICAL_PIXELS_X".equals(attrib)) {
                    return String.valueOf(72);
                }
                if ("LOGICAL_PIXELS_Y".equals(attrib)) {
                    return String.valueOf(72);
                }
            }
        }
        catch (Exception e) {
            JVM14Driver.log(e);
        }
        return this.getAttribute(attrib);
    }

    @Override
    public void setEscapeSequences(boolean state) {
        this.escapeSequences = state;
    }

    @Override
    public String getPrinterInfo(String attrib) {
        attrib = this.normalizeAttribute(attrib);
        return this.getAttribute(attrib);
    }

    @Override
    public void setConnectorThickness(int thickness) {
        if (thickness < 0) {
            thickness = 0;
        }
        this.CONNECTION_THICKNESS = thickness;
    }

    @Override
    public void setConnector(double xpos, double ypos, int type) {
        this.connect((int)xpos, (int)ypos, type);
    }

    public void resetConnectors() {
        this.connectors.setSize(0);
    }

    public void connect(int effectiveX, int effectiveY, int connect) {
        ConnectorNode add = new ConnectorNode(effectiveX, effectiveY, connect);
        this.connectors.addElement(add);
    }

    public void connect(ConnectorNode from, ConnectorNode to) {
        boolean shade;
        int fromX = from.x;
        int fromY = from.y;
        int toX = to.x;
        int toY = to.y;
        int width = (toX += this.leftMargin) - (fromX += this.leftMargin);
        int height = (toY += this.topMargin) - (fromY += this.topMargin);
        if (width < 0) {
            width = -width;
        }
        if (height < 0) {
            height = -height;
        }
        boolean horizontal = false;
        if (fromY == toY) {
            horizontal = true;
        }
        this.addPrintQueue(new PrintQueue(this.getPenColor()));
        int thick = from.connect & 0xF0 | to.connect & 0xF0;
        boolean bl = shade = (thick & 0x10) == 16;
        if ((thick & 0x20) == 32) {
            if (shade) {
                this.addPrintQueue(new PrintQueue(this.getShadeColor()));
            }
            this.addPrintQueue(new PrintQueue(14, fromX, fromY, toX, toY));
            if (shade) {
                this.addPrintQueue(new PrintQueue(this.getPenColor()));
            }
        }
        if ((thick & 0x80) == 128) {
            int arcWidth = this.CONNECTION_THICKNESS;
            int arcHeight = this.CONNECTION_THICKNESS;
            if (shade) {
                this.addPrintQueue(new PrintQueue(this.getShadeColor()));
            }
            if (horizontal) {
                if (shade) {
                    this.addPrintQueue(new PrintQueue(8, fromX - this.CONNECTION_THICKNESS, fromY - this.CONNECTION_THICKNESS, width + this.CONNECTION_THICKNESS * 2, height + this.CONNECTION_THICKNESS * 2, arcWidth, arcHeight));
                    this.addPrintQueue(new PrintQueue(this.getPenColor()));
                }
                this.addPrintQueue(new PrintQueue(9, fromX - this.CONNECTION_THICKNESS, fromY - this.CONNECTION_THICKNESS, width + this.CONNECTION_THICKNESS * 2, height + this.CONNECTION_THICKNESS * 2, arcWidth, arcHeight));
            } else {
                if (shade) {
                    this.addPrintQueue(new PrintQueue(9, fromX - this.CONNECTION_THICKNESS, fromY - this.CONNECTION_THICKNESS, width + this.CONNECTION_THICKNESS * 2, height + this.CONNECTION_THICKNESS * 2, arcWidth, arcHeight));
                    this.addPrintQueue(new PrintQueue(this.getPenColor()));
                }
                this.addPrintQueue(new PrintQueue(9, fromX - this.CONNECTION_THICKNESS, fromY - this.CONNECTION_THICKNESS, width + this.CONNECTION_THICKNESS * 2, height + this.CONNECTION_THICKNESS * 2, arcWidth, arcHeight));
            }
        }
        if ((thick & 0x40) == 64) {
            if (shade) {
                this.addPrintQueue(new PrintQueue(this.getShadeColor()));
            }
            if (horizontal) {
                if (shade) {
                    this.addPrintQueue(new PrintQueue(5, fromX - this.CONNECTION_THICKNESS + 1, fromY - this.CONNECTION_THICKNESS + 1, width + this.CONNECTION_THICKNESS * 2 - 1, height + this.CONNECTION_THICKNESS * 2 - 1));
                    this.addPrintQueue(new PrintQueue(this.getPenColor()));
                }
                this.addPrintQueue(new PrintQueue(7, fromX - this.CONNECTION_THICKNESS, fromY - this.CONNECTION_THICKNESS, width + this.CONNECTION_THICKNESS * 2, height + this.CONNECTION_THICKNESS * 2));
            } else {
                if (shade) {
                    this.addPrintQueue(new PrintQueue(5, fromX - this.CONNECTION_THICKNESS + 1, fromY - this.CONNECTION_THICKNESS + 1, width + this.CONNECTION_THICKNESS * 2 - 1, height + this.CONNECTION_THICKNESS * 2 - 1));
                    this.addPrintQueue(new PrintQueue(this.getPenColor()));
                }
                this.addPrintQueue(new PrintQueue(7, fromX - this.CONNECTION_THICKNESS, fromY - this.CONNECTION_THICKNESS, width + this.CONNECTION_THICKNESS * 2, height + this.CONNECTION_THICKNESS * 2));
            }
        }
    }

    public void realizeConnectors() {
        ConnectorNode toDraw;
        int drawTo;
        int draw;
        int cSize;
        ConnectorNode cand;
        int k;
        int candidateSize;
        int j;
        int i;
        int size = this.connectors.size();
        ConnectorNode base = null;
        ConnectorNode check = null;
        Vector<ConnectorNode> candidate = new Vector<ConnectorNode>();
        for (i = 0; i < size - 1; ++i) {
            base = this.connector(i);
            if ((base.connect & 0xC) == 0) continue;
            candidate.setSize(0);
            candidate.addElement(base);
            for (j = i + 1; j < size; ++j) {
                check = this.connector(j);
                if (check.x != base.x || (check.connect & 0xC) == 0) continue;
                candidateSize = candidate.size();
                boolean inserted = false;
                for (k = 0; k < candidateSize; ++k) {
                    cand = (ConnectorNode)candidate.elementAt(k);
                    if (cand.y <= check.y) continue;
                    candidate.insertElementAt(check, k);
                    inserted = true;
                    break;
                }
                if (inserted) continue;
                candidate.addElement(check);
            }
            cSize = candidate.size();
            block3: for (draw = 0; draw < cSize; ++draw) {
                ConnectorNode baseDraw = (ConnectorNode)candidate.elementAt(draw);
                if ((baseDraw.connect & 8) != 8) continue;
                for (drawTo = draw + 1; drawTo < cSize; ++drawTo) {
                    toDraw = (ConnectorNode)candidate.elementAt(drawTo);
                    if ((toDraw.connect & 4) != 4) continue;
                    baseDraw.connect &= 0xFFFFFFF7;
                    toDraw.connect &= 0xFFFFFFFB;
                    this.connect(baseDraw, toDraw);
                    continue block3;
                }
            }
        }
        base = null;
        check = null;
        candidate.setSize(0);
        for (i = 0; i < size - 1; ++i) {
            base = this.connector(i);
            if ((base.connect & 3) == 0) continue;
            candidate.setSize(0);
            candidate.addElement(base);
            for (j = i + 1; j < size; ++j) {
                check = this.connector(j);
                if (check.y != base.y || (check.connect & 3) == 0) continue;
                candidateSize = candidate.size();
                boolean inserted = false;
                for (k = 0; k < candidateSize; ++k) {
                    cand = (ConnectorNode)candidate.elementAt(k);
                    if (cand.x <= check.x) continue;
                    candidate.insertElementAt(check, k);
                    inserted = true;
                    break;
                }
                if (inserted) continue;
                candidate.addElement(check);
            }
            cSize = candidate.size();
            block8: for (draw = 0; draw < cSize; ++draw) {
                ConnectorNode baseDraw = (ConnectorNode)candidate.elementAt(draw);
                if ((baseDraw.connect & 2) != 2) continue;
                for (drawTo = draw + 1; drawTo < cSize; ++drawTo) {
                    toDraw = (ConnectorNode)candidate.elementAt(drawTo);
                    if ((toDraw.connect & 1) != 1) continue;
                    baseDraw.connect &= 0xFFFFFFFD;
                    toDraw.connect &= 0xFFFFFFFE;
                    this.connect(baseDraw, toDraw);
                    continue block8;
                }
            }
        }
        this.resetConnectors();
    }

    public ConnectorNode connector(int i) {
        try {
            return this.connectors.elementAt(i);
        }
        catch (Exception e) {
            JVM14Driver.log(e);
            return null;
        }
    }

    @Override
    public void setXORMode(Color c) {
        this.addPrintQueue(new PrintQueue(21, c));
    }

    @Override
    public void setPaintMode() {
        this.addPrintQueue(new PrintQueue(20));
    }

    private final String drawTextEscapeGraphics(String drawLine) {
        int x = (int)this.xpos;
        int y = (int)this.ypos;
        if (this.enableGraphics && drawLine != null && drawLine.startsWith(this.graphicsTag)) {
            StringTokenizer st = new StringTokenizer(drawLine.substring(5), "\t\n\r(),:; ");
            String token = null;
            token = st.nextToken();
            if (token == null) {
                token = st.nextToken();
            }
            String[] param = new String[8];
            int[] intParam = new int[8];
            String paramToken = null;
            for (int paramCounter = 0; st.hasMoreTokens() && paramCounter < 8; ++paramCounter) {
                param[paramCounter] = paramToken = st.nextToken();
                if (paramToken == null || paramToken.length() <= 0) continue;
                try {
                    paramToken = paramToken.trim();
                    if (paramToken.equals("<X>")) {
                        intParam[paramCounter] = x;
                        continue;
                    }
                    if (paramToken.equals("<Y>")) {
                        intParam[paramCounter] = y;
                        continue;
                    }
                    char tokenModifier = paramToken.charAt(0);
                    switch (tokenModifier) {
                        case 'R': 
                        case 'r': {
                            intParam[paramCounter] = this.defaultTopMargin + this.aligny + (int)((double)(ConvertData.parseInt(paramToken.substring(1).trim()) + 1) * this.printerFontMetricHeight);
                            break;
                        }
                        case 'C': 
                        case 'c': {
                            intParam[paramCounter] = this.defaultLeftMargin + this.alignx + ConvertData.parseInt(paramToken.substring(1).trim()) * this.printerFontWidth;
                            break;
                        }
                        default: {
                            intParam[paramCounter] = ConvertData.parseInt(paramToken.trim());
                        }
                    }
                    continue;
                }
                catch (Throwable individualParameter) {
                    JVM14Driver.log(individualParameter);
                }
            }
            if (token != null) {
                if ((token = token.toUpperCase()).equals("CLEARRECT") || token.equals("CLEAR")) {
                    this.addPrintQueue(new PrintQueue(16, intParam[0], intParam[1], intParam[2], intParam[3]));
                } else if (token.equals("CLIPRECT") || token.equals("CLIP")) {
                    this.addPrintQueue(new PrintQueue(17, intParam[0], intParam[1], intParam[2], intParam[3]));
                } else if (token.equals("COPYAREA") || token.equals("COPY")) {
                    this.addPrintQueue(new PrintQueue(18, intParam[0], intParam[1], intParam[2], intParam[3], intParam[4], intParam[5]));
                } else if (token.equals("DRAW3DRECT") || token.equals("3DRECT")) {
                    this.addPrintQueue(new PrintQueue(6, intParam[0], intParam[1], intParam[2], intParam[3], intParam[4] != 0));
                } else if (token.equals("DRAWARC") || token.equals("ARC")) {
                    this.addPrintQueue(new PrintQueue(13, intParam[0], intParam[1], intParam[2], intParam[3], intParam[4], intParam[5]));
                } else if (token.equals("DRAWLINE") || token.equals("LINE")) {
                    this.addPrintQueue(new PrintQueue(14, intParam[0], intParam[1], intParam[2], intParam[3]));
                } else if (token.equals("DRAWOVAL") || token.equals("OVAL")) {
                    this.addPrintQueue(new PrintQueue(22, intParam[0], intParam[1], intParam[2], intParam[3]));
                } else if (token.equals("DRAWRECT") || token.equals("RECT") || token.equals("RECTANGLE")) {
                    this.addPrintQueue(new PrintQueue(7, intParam[0], intParam[1], intParam[2], intParam[3]));
                } else if (token.equals("DRAWROUNDRECT") || token.equals("ROUNDRECT") || token.equals("ROUNDRECTANGLE")) {
                    this.addPrintQueue(new PrintQueue(9, intParam[0], intParam[1], intParam[2], intParam[3], intParam[4], intParam[5]));
                } else if (token.equals("DRAWSTRING") || token.equals("STRING") || token.equals("TEXT")) {
                    this.addPrintQueue(new PrintQueue(15, param[0], intParam[1], intParam[2]));
                } else if (token.equals("FILL3DRECT") || token.equals("FILL3DRECTANGLE")) {
                    this.addPrintQueue(new PrintQueue(4, intParam[0], intParam[1], intParam[2], intParam[3], intParam[4] != 0));
                } else if (token.equals("FILLARC")) {
                    this.addPrintQueue(new PrintQueue(12, intParam[0], intParam[1], intParam[2], intParam[3], intParam[4], intParam[5]));
                } else if (token.equals("FILLOVAL")) {
                    this.addPrintQueue(new PrintQueue(10, intParam[0], intParam[1], intParam[2], intParam[3]));
                } else if (token.equals("FILLRECT") || token.equals("FILLRECTANGLE")) {
                    this.addPrintQueue(new PrintQueue(5, intParam[0], intParam[1], intParam[2], intParam[3]));
                } else if (token.equals("FILLROUNDRECT") || token.equals("FILLROUNDRECTANGLE")) {
                    this.addPrintQueue(new PrintQueue(8, intParam[0], intParam[1], intParam[2], intParam[3], intParam[4], intParam[5]));
                } else if (token.equals("FONT")) {
                    this.addPrintQueue(new PrintQueue(Font.decode(param[0])));
                } else if (token.equals("PAINTMODE") || token.equals("PAINT")) {
                    this.addPrintQueue(new PrintQueue(20));
                } else if (token.equals("XORMODE") || token.equals("XOR")) {
                    this.addPrintQueue(new PrintQueue(21, ColorProvider.getColor(param[0])));
                } else if (token.equals("COLOR")) {
                    this.addPrintQueue(new PrintQueue(ColorProvider.getColor(param[0])));
                } else if (token.equals("TRANSLATE")) {
                    this.addPrintQueue(new PrintQueue(19, intParam[0], intParam[1]));
                } else if (!token.equals("SETLINE")) {
                    if (token.equals("DRAWIMAGE") || token.equals("IMAGE")) {
                        try {
                            this.addPrintQueue(new PrintQueue(2, MediaImage.getImage(param[0]), intParam[1], intParam[2], intParam[3], intParam[4]));
                        }
                        catch (Exception e) {
                            JVM14Driver.log(e);
                        }
                    } else {
                        return drawLine;
                    }
                }
                return null;
            }
        }
        return drawLine;
    }

    @Override
    public String command(String command) {
        try {
            StringTokenizer st = new StringTokenizer(command.trim());
            if (st.hasMoreTokens()) {
                String y;
                String x;
                String name = st.nextToken().trim().toUpperCase();
                if (name.equals("SCALE")) {
                    x = null;
                    y = null;
                    if (st.hasMoreTokens()) {
                        x = st.nextToken().trim();
                        if (st.hasMoreTokens()) {
                            y = st.nextToken().trim();
                            this.addPrintQueue(new PrintQueue(25, new Double(x), new Double(y), 0.0));
                        }
                    }
                } else if (name.equals("SHEAR")) {
                    x = null;
                    y = null;
                    if (st.hasMoreTokens()) {
                        x = st.nextToken().trim();
                        if (st.hasMoreTokens()) {
                            y = st.nextToken().trim();
                            this.addPrintQueue(new PrintQueue(24, new Double(x), new Double(y), 0.0));
                        }
                    }
                } else if (name.equals("ROTATE") || name.equals("ROTATE3")) {
                    x = null;
                    y = null;
                    String z = null;
                    if (st.hasMoreTokens()) {
                        x = st.nextToken().trim();
                        if (st.hasMoreTokens()) {
                            y = st.nextToken().trim();
                            if (st.hasMoreTokens()) {
                                z = st.nextToken().trim();
                                this.addPrintQueue(new PrintQueue(27, new Double(x), new Double(y), new Double(z)));
                            }
                        } else {
                            this.addPrintQueue(new PrintQueue(26, new Double(x), 0.0, 0.0));
                        }
                    }
                } else if (name.equals("TRANSFORM")) {
                    try {
                        String m0 = st.nextToken().trim();
                        String m1 = st.nextToken().trim();
                        String m2 = st.nextToken().trim();
                        String m3 = st.nextToken().trim();
                        String m4 = st.nextToken().trim();
                        String m5 = st.nextToken().trim();
                        this.addPrintQueue(new PrintQueue(28, new Double(m0), new Double(m1), new Double(m2), new Double(m3), new Double(m4), new Double(m5)));
                    }
                    catch (Throwable t) {
                        JVM14Driver.log(t);
                    }
                }
            }
            while (st.hasMoreTokens()) {
            }
        }
        catch (Throwable t) {
            JVM14Driver.log(t);
            return t.toString();
        }
        return " ";
    }

    public class PrintableDoc
    implements Doc {
        private Printable printable;

        public PrintableDoc(Printable printable) {
            this.printable = printable;
        }

        @Override
        public DocFlavor getDocFlavor() {
            return DocFlavor.SERVICE_FORMATTED.PRINTABLE;
        }

        @Override
        public DocAttributeSet getAttributes() {
            return null;
        }

        @Override
        public Object getPrintData() throws IOException {
            return this.printable;
        }

        @Override
        public Reader getReaderForText() throws IOException {
            return null;
        }

        @Override
        public InputStream getStreamForBytes() throws IOException {
            return null;
        }
    }

    private static class ConnectorNode {
        public int x;
        public int y;
        public int connect;

        public String toString() {
            return "(" + this.x + "," + this.y + ":" + this.connect + ")";
        }

        public ConnectorNode(int x, int y, int connect) {
            this.x = x;
            this.y = y;
            this.connect = connect;
        }
    }

    private static class PrintQueue {
        private int op;
        private Object object;
        private Object secondObject;
        private int x1;
        private int x2;
        private int y1;
        private int y2;
        private int start;
        private int end;
        private boolean bool;
        private double f1;
        private double f2;
        private double f3;
        private double f4;
        private double f5;
        private double f6;

        public String opcode() {
            switch (this.op) {
                case 0: {
                    return "COLOR";
                }
                case 1: {
                    return "FONT";
                }
                case 2: {
                    return "IMAGE";
                }
                case 3: {
                    return "COMPONENT";
                }
                case 4: {
                    return "FILL3DRECT";
                }
                case 5: {
                    return "FILLRECT";
                }
                case 6: {
                    return "DRAW3DRECT";
                }
                case 7: {
                    return "DRAWRECT";
                }
                case 8: {
                    return "FILLROUNDRECT";
                }
                case 9: {
                    return "DRAWROUNDRECT";
                }
                case 10: {
                    return "FILLOVAL";
                }
                case 12: {
                    return "FILLARC";
                }
                case 13: {
                    return "DRAWARC";
                }
                case 14: {
                    return "DRAWLINE";
                }
                case 15: {
                    return "DRAWSTRING";
                }
                case 16: {
                    return "CLEARRECT";
                }
                case 17: {
                    return "CLIPRECT";
                }
                case 18: {
                    return "COPYAREA";
                }
                case 19: {
                    return "TRANSLATE";
                }
                case 20: {
                    return "PAINTMODE";
                }
                case 21: {
                    return "XORMODE";
                }
                case 22: {
                    return "DRAWOVAL";
                }
                case 23: {
                    return "SETSTROKE";
                }
                case 24: {
                    return "SHEAR";
                }
                case 25: {
                    return "SCALE";
                }
                case 26: {
                    return "ROTATE";
                }
                case 27: {
                    return "ROTATE3";
                }
                case 28: {
                    return "TRANSFORM";
                }
            }
            return "";
        }

        public String toString() {
            return "{" + this.opcode() + ": object='" + this.object + "', second='" + this.secondObject + "', x1=" + this.x1 + ", y1=" + this.y1 + ", x2=" + this.x2 + ", y2=" + this.y2 + ", start=" + this.start + ", end=" + this.end + ", bool=" + this.bool + "}";
        }

        public PrintQueue(Color c) {
            this.op = 0;
            this.object = c;
        }

        public PrintQueue(Font f) {
            this.op = 1;
            this.object = f;
        }

        public PrintQueue(int op) {
            this.op = op;
        }

        public PrintQueue(int op, Object object) {
            this.op = op;
            this.object = object;
        }

        public PrintQueue(int op, Object object, int x1, int y1) {
            this.op = op;
            this.object = object;
            this.x1 = x1;
            this.y1 = y1;
        }

        public PrintQueue(int op, int x1, int y1) {
            this.op = op;
            this.x1 = x1;
            this.y1 = y1;
        }

        public PrintQueue(int op, Object object, int x1, int y1, Object secondObject) {
            this.op = op;
            this.object = object;
            this.x1 = x1;
            this.y1 = y1;
            this.secondObject = secondObject;
        }

        public PrintQueue(int op, int x1, int y1, int x2, int y2) {
            this.op = op;
            this.x1 = x1;
            this.y1 = y1;
            this.x2 = x2;
            this.y2 = y2;
        }

        public PrintQueue(int op, Object object, int x1, int y1, int x2, int y2) {
            this.op = op;
            this.x1 = x1;
            this.y1 = y1;
            this.x2 = x2;
            this.y2 = y2;
            this.object = object;
        }

        public PrintQueue(int op, Object object, int x1, int y1, int x2, int y2, Object secondObject) {
            this.op = op;
            this.x1 = x1;
            this.y1 = y1;
            this.x2 = x2;
            this.y2 = y2;
            this.object = object;
            this.secondObject = secondObject;
        }

        public PrintQueue(int op, int x1, int y1, int x2, int y2, boolean bool) {
            this.op = op;
            this.x1 = x1;
            this.y1 = y1;
            this.x2 = x2;
            this.y2 = y2;
            this.bool = bool;
        }

        public PrintQueue(int op, int x1, int y1, int x2, int y2, int start, int end) {
            this.op = op;
            this.x1 = x1;
            this.y1 = y1;
            this.x2 = x2;
            this.y2 = y2;
            this.start = start;
            this.end = end;
        }

        public PrintQueue(int op, double f1, double f2, double f3) {
            this.op = op;
            this.f1 = f1;
            this.f2 = f2;
            this.f3 = f3;
        }

        public PrintQueue(int op, double f1, double f2, double f3, double f4, double f5, double f6) {
            this.op = op;
            this.f1 = f1;
            this.f2 = f2;
            this.f3 = f3;
            this.f4 = f4;
            this.f5 = f5;
            this.f6 = f6;
        }

        public void print(Graphics g) {
            try {
                switch (this.op) {
                    case 0: {
                        g.setColor((Color)this.object);
                        break;
                    }
                    case 1: {
                        g.setFont((Font)this.object);
                        break;
                    }
                    case 2: {
                        if (this.x2 <= 0 && this.y2 <= 0) {
                            g.drawImage((Image)this.object, this.x1, this.y1, Color.white, null);
                            break;
                        }
                        g.drawImage((Image)this.object, this.x1, this.y1, this.x2, this.y2, Color.white, null);
                        break;
                    }
                    case 3: {
                        Graphics componentGraphics = g.create(this.x1, this.y1, this.x2, this.y2);
                        componentGraphics.setFont(g.getFont());
                        componentGraphics.setColor(g.getColor());
                        ((Component)this.object).printAll(componentGraphics);
                        componentGraphics.dispose();
                        break;
                    }
                    case 4: {
                        g.fill3DRect(this.x1, this.y1, this.x2, this.y2, this.bool);
                        break;
                    }
                    case 5: {
                        g.fillRect(this.x1, this.y1, this.x2, this.y2);
                        break;
                    }
                    case 6: {
                        g.draw3DRect(this.x1, this.y1, this.x2, this.y2, this.bool);
                        break;
                    }
                    case 7: {
                        g.drawRect(this.x1, this.y1, this.x2, this.y2);
                        break;
                    }
                    case 8: {
                        g.fillRoundRect(this.x1, this.y1, this.x2, this.y2, this.start, this.end);
                        break;
                    }
                    case 9: {
                        g.drawRoundRect(this.x1, this.y1, this.x2, this.y2, this.start, this.end);
                        break;
                    }
                    case 10: {
                        g.fillOval(this.x1, this.y1, this.x2, this.y2);
                        break;
                    }
                    case 12: {
                        g.fillArc(this.x1, this.y1, this.x2, this.y2, this.start, this.end);
                        break;
                    }
                    case 13: {
                        g.drawArc(this.x1, this.y1, this.x2, this.y2, this.start, this.end);
                        break;
                    }
                    case 14: {
                        g.drawLine(this.x1, this.y1, this.x2, this.y2);
                        break;
                    }
                    case 15: {
                        g.drawString(String.valueOf(this.object), this.x1, this.y1);
                        break;
                    }
                    case 16: {
                        g.clearRect(this.x1, this.y1, this.x2, this.y2);
                        break;
                    }
                    case 17: {
                        g.clipRect(this.x1, this.y1, this.x2, this.y2);
                        break;
                    }
                    case 18: {
                        g.copyArea(this.x1, this.y1, this.x2, this.y2, this.start, this.end);
                        break;
                    }
                    case 19: {
                        g.translate(this.x1, this.y1);
                        break;
                    }
                    case 20: {
                        g.setPaintMode();
                        break;
                    }
                    case 21: {
                        g.setXORMode((Color)this.object);
                        break;
                    }
                    case 22: {
                        g.drawOval(this.x1, this.y1, this.x2, this.y2);
                        break;
                    }
                    case 23: {
                        BasicStroke stroke = null;
                        switch ((int)this.f2) {
                            case 0: {
                                stroke = new BasicStroke((float)this.f1);
                                break;
                            }
                            case 1: {
                                stroke = new BasicStroke((float)this.f1, 2, 0, 10.0f, DASH_LINE, 0.0f);
                                break;
                            }
                            case 2: {
                                stroke = new BasicStroke((float)this.f1, 2, 0, 10.0f, DOT_LINE, 0.0f);
                                break;
                            }
                            case 3: {
                                stroke = new BasicStroke((float)this.f1, 2, 0, 10.0f, DASH_DOT_LINE, 0.0f);
                                break;
                            }
                            case 4: {
                                stroke = new BasicStroke((float)this.f1, 2, 0, 10.0f, DASH_DOT_DOT_LINE, 0.0f);
                                break;
                            }
                        }
                        if (stroke != null) {
                            ((Graphics2D)g).setStroke(stroke);
                        }
                        break;
                    }
                    case 24: {
                        ((Graphics2D)g).shear(this.f1, this.f2);
                        break;
                    }
                    case 25: {
                        ((Graphics2D)g).scale(this.f1, this.f2);
                        break;
                    }
                    case 26: {
                        ((Graphics2D)g).rotate(this.f1);
                        break;
                    }
                    case 27: {
                        ((Graphics2D)g).rotate(this.f1, this.f2, this.f3);
                        break;
                    }
                    case 28: {
                        ((Graphics2D)g).transform(new AffineTransform(this.f1, this.f2, this.f3, this.f4, this.f5, this.f6));
                    }
                }
            }
            catch (Throwable renderingException) {
                JVM14Driver.log(renderingException);
            }
        }
    }
}

