/*
 * Decompiled with CFR 0.152.
 */
package com.heirloomcomputing.ecs.print;

import com.heirloomcomputing.ecs.api.IGenericPrinter;
import java.util.Vector;

public class PrinterControl {
    private static IGenericPrinter defaultPrinter;
    private static int currentPrinterHandle;
    private static final Vector<IGenericPrinter> printers;
    private static boolean openRawMode;
    private static String defaultDriverName;
    private static boolean printerDialogEnabled;

    private static String normalizeDriverName(String driverName) {
        if (driverName == null) {
            return null;
        }
        driverName = driverName.trim();
        try {
            if (driverName.endsWith(".class")) {
                driverName = driverName.substring(0, driverName.length() - 6);
            } else if (driverName.endsWith(".java")) {
                driverName = driverName.substring(0, driverName.length() - 5);
            }
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        if (driverName.equalsIgnoreCase("JDK11")) {
            driverName = "com.heirloomcomputing.ecs.print.JVM11Driver";
        } else if (driverName.equalsIgnoreCase("JDK12")) {
            driverName = "com.heirloomcomputing.ecs.print.JVM12Driver";
        } else if (driverName.equalsIgnoreCase("JDK13")) {
            driverName = "com.heirloomcomputing.ecs.print.JVM13Driver";
        } else if (driverName.equalsIgnoreCase("JDK14")) {
            driverName = "com.heirloomcomputing.ecs.print.JVM14Driver";
        } else if (driverName.equalsIgnoreCase("JVM11")) {
            driverName = "com.heirloomcomputing.ecs.print.JVM11Driver";
        } else if (driverName.equalsIgnoreCase("JVM12")) {
            driverName = "com.heirloomcomputing.ecs.print.JVM12Driver";
        } else if (driverName.equalsIgnoreCase("JVM13")) {
            driverName = "com.heirloomcomputing.ecs.print.JVM13Driver";
        } else if (driverName.equalsIgnoreCase("JVM14")) {
            driverName = "com.heirloomcomputing.ecs.print.JVM14Driver";
        }
        return driverName;
    }

    public static void setDefaultDriverName(String name) {
        defaultDriverName = PrinterControl.normalizeDriverName(name);
    }

    public static void setPrinterDialogEnabled(boolean state) {
        printerDialogEnabled = state;
    }

    public static boolean isPrinterDialogEnabled() {
        return printerDialogEnabled;
    }

    public static void setPrinterOpenRawMode(boolean state) {
        openRawMode = state;
    }

    public static boolean isPrinterOpenRawMode() {
        return openRawMode;
    }

    public static void setPrinterHandle(int value) {
        currentPrinterHandle = value;
        defaultPrinter = PrinterControl.getPrinter(value);
    }

    public static int getPrinterHandle() {
        return currentPrinterHandle;
    }

    public static boolean openPrinter() {
        return PrinterControl.openPrinter(openRawMode, null, null);
    }

    public static boolean openPrinter(String driver, String filename) {
        return PrinterControl.openPrinter(printerDialogEnabled, openRawMode, driver, filename);
    }

    public static boolean openPrinter(boolean rawMode, String driver, String filename) {
        return PrinterControl.openPrinter(printerDialogEnabled, rawMode, driver, filename);
    }

    public static boolean openPrinter(boolean dialogEnabled, boolean rawMode, String driver, String filename) {
        return PrinterControl.getPrinter(driver).open(dialogEnabled, rawMode, filename);
    }

    public static void closePrinter() {
        PrinterControl.getPrinter().close();
    }

    public static void closePrinter(IGenericPrinter printer2) {
        if (printer2 != null) {
            printer2.close();
            int index = printers.indexOf(printer2);
            if (index >= 0) {
                printers.setElementAt(null, index);
            }
        }
    }

    public static IGenericPrinter getPrinter() {
        if (defaultPrinter == null) {
            defaultPrinter = PrinterControl.getPrinter(null);
        }
        return defaultPrinter;
    }

    public static IGenericPrinter getPrinter(String driverName) {
        Class<?> classObject2;
        IGenericPrinter printer2 = null;
        boolean useNew = false;
        if (driverName != null) {
            if ((driverName = driverName.trim()).startsWith("new.")) {
                useNew = true;
                driverName = driverName.substring(4);
            }
            if ((driverName = PrinterControl.normalizeDriverName(driverName)).equalsIgnoreCase("NEW")) {
                useNew = true;
                driverName = null;
            }
        }
        if (driverName == null && defaultPrinter != null && !useNew) {
            return defaultPrinter;
        }
        if (driverName != null) {
            try {
                classObject2 = Class.forName(driverName);
                printer2 = (IGenericPrinter)classObject2.newInstance();
            }
            catch (Throwable classObject2) {}
        } else if (defaultDriverName != null) {
            try {
                classObject2 = Class.forName(defaultDriverName);
                printer2 = (IGenericPrinter)classObject2.newInstance();
            }
            catch (Throwable classObject3) {
                // empty catch block
            }
        }
        if (printer2 == null) {
            Class<?> classObject42;
            boolean enableCobolPrinter14 = false;
            boolean enableCobolPrinter13 = true;
            boolean enableCobolPrinter12 = true;
            boolean enableCobolPrinter11 = true;
            if (printer2 == null && enableCobolPrinter14) {
                driverName = "com.heirloomcomputing.ecs.print.JVM14Driver";
                try {
                    classObject42 = Class.forName(driverName);
                    printer2 = (IGenericPrinter)classObject42.newInstance();
                }
                catch (Throwable classObject42) {
                    // empty catch block
                }
            }
            if (printer2 == null && enableCobolPrinter13) {
                driverName = "com.heirloomcomputing.ecs.print.JVM13Driver";
                try {
                    classObject42 = Class.forName(driverName);
                    printer2 = (IGenericPrinter)classObject42.newInstance();
                }
                catch (Throwable classObject5) {
                    // empty catch block
                }
            }
            if (printer2 == null && enableCobolPrinter12) {
                driverName = "com.heirloomcomputing.ecs.print.JVM12Driver";
                try {
                    classObject42 = Class.forName(driverName);
                    printer2 = (IGenericPrinter)classObject42.newInstance();
                }
                catch (Throwable classObject6) {
                    // empty catch block
                }
            }
            if (printer2 == null && enableCobolPrinter11) {
                driverName = "com.heirloomcomputing.ecs.print.JVM11Driver";
                try {
                    classObject42 = Class.forName(driverName);
                    printer2 = (IGenericPrinter)classObject42.newInstance();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
        if (printer2 == null) {
            throw new RuntimeException("Cannot obtain any printer driver");
        }
        defaultPrinter = printer2;
        currentPrinterHandle = printers.size();
        for (int i = 0; i < currentPrinterHandle; ++i) {
            if (printers.elementAt(i) != null) continue;
            printers.setElementAt(printer2, i);
            return printer2;
        }
        printers.addElement(printer2);
        return printer2;
    }

    public static IGenericPrinter getPrinter(int n) {
        try {
            if (n < 0 || n >= printers.size()) {
                return null;
            }
            return printers.elementAt(n);
        }
        catch (Throwable t) {
            return null;
        }
    }

    static {
        printers = new Vector();
        printerDialogEnabled = true;
    }
}

