/*
 * Decompiled with CFR 0.152.
 */
package com.heirloomcomputing.ecs.util;

import com.heirloomcomputing.ecc.HCILicensing;
import com.heirloomcomputing.ecs.api.IDatatype;
import com.heirloomcomputing.ecs.exec.BignumType;
import com.heirloomcomputing.ecs.exec.Comp1;
import com.heirloomcomputing.ecs.exec.Comp2;
import com.heirloomcomputing.ecs.exec.Numeric;
import com.heirloomcomputing.ecs.exec.RuntimeEnvironment;
import com.heirloomcomputing.ecs.exec.Variable;
import com.heirloomcomputing.ecs.isamsql.COBOLFile;
import com.heirloomcomputing.ecs.isamsql.DCB;
import com.heirloomcomputing.ecs.isamsql.DCBFactory;
import com.heirloomcomputing.ecs.isamsql.SqlColumn;
import com.heirloomcomputing.ecs.isamsql.XmlDatasetLoader;
import com.heirloomcomputing.ecs.util.BatchTree;
import com.heirloomcomputing.ecs.util.BatchTreeItem;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class HCdiff {
    static Map<Vector<Object>, Boolean> layoutRedefMap = new HashMap<Vector<Object>, Boolean>(5);
    static byte[] _baseFileRecord;
    static byte[] _diffFileRecord;
    static COBOLFile _baseCOBOLObject;
    static COBOLFile _diffCOBOLObject;
    static int mismatchOff;
    static PrintWriter logfile;
    static String profDirLoc;
    static String sqluser;
    static String sqlpasswd;
    static String sqlurl;
    static String sqldriver;
    static String sqlautocommit;
    static String sqlisolation;
    static String sqlcatalog;
    static String sqlreadonly;
    static String baseDsnName;
    static String baseDsnPath;
    static String dcbDBMode;
    static boolean isDCBDB;
    static String dcbDBDriver;
    static String dcbDBDriverJar;
    static String dcbDBUrl;
    static String dcbDBUser;
    static String dcbDBPass;
    static String dcbDBTblExt;
    static String diffDsnPath;
    static int recMin;
    static int recMax;
    static int recAvg;
    static String rfsLoc;
    int LE = -1;
    int EQ = 0;
    static int GE;
    static String XFD_WHEN;
    static String REDEFINES_TXT;
    static String REDEFINED;
    static String profFileLoc;
    static String READ;
    static ArrayList<String> CONDITIONS;
    static ArrayList<String> SQLCONDITIONS;
    static int layoutLength;
    static int readCnt;
    static int dupCnt;
    static int writeCnt;
    static int dupFailCnt;
    static int diffRecLimit;
    static int diffInfoLevel;
    static boolean useDefaultRedef;
    static boolean hasMultipleLayouts;
    static boolean hasSingleLayout;
    static boolean hasNoLayouts;
    static boolean xfdAvail;
    static boolean quietMode;
    static String baseFileCharset;
    static boolean warnxfdcharset;
    static String xfdXmlCharset;
    static boolean isLoadFileEBCIDIC;
    static String ebcidicCodeSets;
    static BatchTree XFDTree;
    static DCB baseDcb;
    static DCB diffDcb;
    private static ArrayList<BatchTreeItem> whenConds;
    static Vector<Object> xfdRowLayout;
    static HashMap<Vector<Object>, HashMap<Object, Object[]>> xfdCondMap;
    static Vector<Vector<Object>> xfdMap;
    static SortedMap<String, String> xfdKeyValArgs;
    static long recCntr;
    static boolean badRecord;
    static StringBuilder sqlgen;
    static String primaryInputXfdFileName;
    static boolean isXfdXmlEbcidic;

    private static void help() {
        System.out.println("");
        System.out.println("");
        System.out.println("java -cp [/path/to/ecoboljar;/path/to/sqldrivers] com.heirloomcomputing.ecs.util.HCdiff ");
        System.out.println("     [help] [warnxfdcharset] [key:value] myfile.prof");
        System.out.println("");
        System.out.println("     help        - Display help Information");
        System.out.println("");
        System.out.println("     warnxfdcharset - If the XFD Charset does not match the load file charset, issue a warning but do not exit");
        System.out.println("                      Default behavior is to exit");
        System.out.println("");
        System.out.println("     key:value   - Override key:value specified in .prof file");
        System.out.println("                   Note: Value for Key:Value pairs that contains spaces should be enclosed within quotes");
        System.out.println("                   The following are the Key:Value pairs that may be specified");
        System.out.println("");
        System.out.println("                   sql.<conn-name>.user=<active sql connection user name>");
        System.out.println("                   sql.<conn-name>.password=<active sql connection password>");
        System.out.println("                   sql.<conn-name>.url=<active sql connection url>");
        System.out.println("                   sql.<conn-name>.driver=<active sql connection driver location>");
        System.out.println("                   sql.<conn-name>.autocommit=<active sql connection auto commit (true|false)>");
        System.out.println("                   sql.<conn-name>.isolation=<active sql connection isolation (repeatable|uncommitted|committed|serializable)>");
        System.out.println("                   sql.<conn-name>.catalog=<active sql connection catalog>");
        System.out.println("                   sql.<conn-name>.readonly=<active sql connection readonly (true|false)>");
        System.out.println("");
        System.out.println("                   DIFF-INFO-LEVEL=0  No diff output. 0 RC indicates files are identical. 1 indicates mismatch");
        System.out.println("                                   1  Basic diff output. Char output");
        System.out.println("                                   2  Adv diff output. Char and Hex output");
        System.out.println("                   DIFF-LIMIT=n [Max number of differences output. Default is 5 Records]");
        System.out.println("                   LOGFILE=path/to/logfile  [On Windows use \\\\ as file path separator]");
        System.out.println("                   BASEFILE-DSNPATH=\"path/to/input/dataset\" [On Windows use \\\\ as file path separator]");
        System.out.println("                   DIFF-DSNPATH=\"path/to/output/dataset\" [On Windows use \\\\ as file path separator]");
        System.out.println("                   XFD[n]-NAME=value                 -name of xfd xml file created during compilation");
        System.out.println("                     XFD[n]-WHEN[n]-IDXDESC=value  --");
        System.out.println("                                                     |-WHEN conditional information. These may be repeated multiple times for each xfd xml file");
        System.out.println("                     XFD[n]-WHEN[n]-INFO=value     --");
        System.out.println("                   XFDVISIBILITY=value             -XFD field visibility info. Occurs once");
        System.out.println("");
        System.out.println("     myfile.prof - Profile file for Diff");
        System.out.println("");
    }

    static void setKeyValues(String key, String val) {
        String caseKey = key;
        if ((key = key.toUpperCase()).endsWith(".USER")) {
            if (sqluser.isEmpty()) {
                sqluser = val;
                System.setProperty(caseKey, val);
            }
        } else if (key.endsWith(".PASSWORD")) {
            if (sqlpasswd.isEmpty()) {
                sqlpasswd = val;
                System.setProperty(caseKey, val);
            }
        } else if (key.endsWith(".URL")) {
            if (sqlurl.isEmpty()) {
                sqlurl = val;
                System.setProperty(caseKey, val);
            }
        } else if (key.endsWith(".DRIVER")) {
            if (sqldriver.isEmpty()) {
                sqldriver = val;
                System.setProperty(caseKey, val);
            }
        } else if (key.endsWith(".AUTOCOMMIT")) {
            if (sqlautocommit.isEmpty()) {
                if (val.isEmpty()) {
                    val = "FALSE";
                }
                sqlautocommit = val;
                System.setProperty(caseKey, val);
            }
        } else if (key.endsWith(".ISOLATION")) {
            if (sqlisolation.isEmpty()) {
                if (val.isEmpty()) {
                    val = "repeatable";
                }
                sqlisolation = val;
                System.setProperty(caseKey, val);
            }
        } else if (key.endsWith(".CATALOG")) {
            if (sqlcatalog.isEmpty()) {
                sqlcatalog = val;
                System.setProperty(caseKey, val);
            }
        } else if (key.endsWith(".READONLY")) {
            if (sqlreadonly.isEmpty()) {
                if (val.isEmpty()) {
                    val = "FALSE";
                }
                sqlreadonly = val;
                System.setProperty(caseKey, val);
            }
        } else if (key.endsWith("USEEBCDICBINARYCOLUMN")) {
            System.setProperty(caseKey, val);
        } else if (key.equals("DCBDB-MODE")) {
            if (dcbDBMode.isEmpty()) {
                dcbDBMode = val;
                isDCBDB = dcbDBMode.equalsIgnoreCase("true");
            }
        } else if (key.equals("DCBDB-DRIVER")) {
            if (dcbDBDriver.isEmpty()) {
                dcbDBDriver = val;
            }
        } else if (key.equals("DCBDB-DRIVER-JAR")) {
            if (dcbDBDriverJar.isEmpty()) {
                dcbDBDriverJar = val;
            }
        } else if (key.equals("DCBDB-URL")) {
            if (dcbDBUrl.isEmpty()) {
                dcbDBUrl = val;
            }
        } else if (key.equals("DCBDB-USER")) {
            if (dcbDBUser.isEmpty()) {
                dcbDBUser = val;
            }
        } else if (key.equals("DCBDB-PASS")) {
            if (dcbDBPass.isEmpty()) {
                dcbDBPass = val;
            }
        } else if (key.equals("DCBDB-TBLEXT")) {
            if (dcbDBTblExt.isEmpty()) {
                dcbDBTblExt = val;
            }
        } else if (key.equals("DIFF-LIMIT")) {
            if (diffRecLimit == -1) {
                try {
                    diffRecLimit = Integer.parseInt(val);
                }
                catch (NumberFormatException err) {
                    HCdiff.writeOut("[ERROR] Error parsing DIFF-LIMIT :" + val);
                    HCdiff.writeOut("[ERROR] Defaulting to 10");
                    diffRecLimit = 10;
                }
            }
        } else if (key.equals("DIFF-INFO-LEVEL")) {
            if (diffInfoLevel == -1) {
                try {
                    diffInfoLevel = Integer.parseInt(val.trim());
                }
                catch (NumberFormatException err) {
                    HCdiff.writeOut("[ERROR] Incorrect param specified for DIFF-INFO-LEVEL :" + val);
                    diffInfoLevel = 0;
                }
            }
        } else if (key.equals("BASEFILE-DSNPATH")) {
            if (baseDsnPath.isEmpty()) {
                if (val.startsWith("VDB:")) {
                    baseDsnPath = val;
                    baseDsnName = val.substring(4);
                } else {
                    File ifile = new File(val);
                    if (ifile.isAbsolute()) {
                        baseDsnPath = val;
                    } else {
                        File resFile = new File(profDirLoc, val);
                        try {
                            baseDsnPath = resFile.getCanonicalPath();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                            HCdiff.exitOut(-1);
                        }
                    }
                    baseDsnName = baseDsnPath.substring(baseDsnPath.lastIndexOf(File.separatorChar) + 1).toUpperCase();
                }
            }
        } else if (key.equals("DIFF-DSNPATH")) {
            if (diffDsnPath.isEmpty()) {
                if (val.startsWith("VDB:")) {
                    diffDsnPath = val;
                } else {
                    File ifile = new File(val);
                    if (ifile.isAbsolute()) {
                        diffDsnPath = val;
                    } else {
                        File resFile = new File(profDirLoc, val);
                        try {
                            diffDsnPath = resFile.getCanonicalPath();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                            HCdiff.exitOut(-1);
                        }
                    }
                }
            }
        } else if (key.startsWith("XFD")) {
            if (!xfdKeyValArgs.containsKey(key)) {
                xfdKeyValArgs.put(key, val);
            }
        } else if (key.equals("LOGFILE")) {
            if (!val.trim().isEmpty()) {
                try {
                    logfile = new PrintWriter(val.trim(), "ISO-8859-1");
                }
                catch (Exception e) {
                    HCdiff.writeOut("[ERROR] LogFile creation error");
                    HCdiff.writeOut(e.getMessage());
                    HCdiff.exitOut(-1);
                }
            }
        } else {
            HCdiff.writeOut("[ERROR] Unknown param :" + key + "=" + val);
        }
    }

    public static void main(String[] args) {
        String licenseCheckResult;
        boolean isCalledFromEclipse = Arrays.stream(args).anyMatch("eclipsefore"::equals);
        if (!HCILicensing.isJDKSupported() && isCalledFromEclipse) {
            System.out.println("Java version " + System.getProperty("java.specification.version") + " is not supported. This plugin currently supports Java version " + HCILicensing.LAST_SUPPORTED_JDK_VERSION + " only!");
            HCdiff.exitOut(-1);
        }
        if ((licenseCheckResult = HCILicensing.LicenseCheck("hpaas-dmt-sdk", 1, false)).compareTo("") != 0) {
            System.err.println("[ERROR] Elastic COBOL Runtime Error: " + licenseCheckResult);
            HCdiff.exitOut(-1);
        }
        if (args == null || args.length == 0) {
            args = new String[]{"help"};
        }
        String arg = null;
        for (int i = 0; i < args.length; ++i) {
            arg = args[i];
            if (arg.trim().isEmpty()) continue;
            if (arg.equalsIgnoreCase("help") || arg.equalsIgnoreCase("?")) {
                HCdiff.help();
                HCdiff.exitOut(-1);
                continue;
            }
            if (arg.equalsIgnoreCase("quietmode")) {
                quietMode = true;
                continue;
            }
            if (arg.equalsIgnoreCase("warnxfdcharset")) {
                warnxfdcharset = true;
                continue;
            }
            if (arg.endsWith(".prof")) {
                profFileLoc = arg;
                continue;
            }
            String[] keyval = arg.split("=", 2);
            if (keyval.length != 2) {
                HCdiff.writeOut("[ERROR] Parameter Error:" + arg);
                HCdiff.exitOut(-1);
            }
            HCdiff.setKeyValues(keyval[0], keyval[1].trim());
        }
        if (!profFileLoc.isEmpty()) {
            try {
                Properties profProp = new Properties();
                FileInputStream inStream = null;
                File profFile = new File(profFileLoc);
                inStream = new FileInputStream(profFile);
                if (inStream != null) {
                    String abspath = profFile.getAbsolutePath();
                    profDirLoc = abspath.substring(0, abspath.lastIndexOf(File.separatorChar));
                    profProp.load(inStream);
                    for (Map.Entry<Object, Object> keyval : profProp.entrySet()) {
                        HCdiff.setKeyValues((String)keyval.getKey(), (String)keyval.getValue());
                    }
                    ((InputStream)inStream).close();
                    if (isDCBDB) {
                        if (dcbDBDriver.isEmpty() || dcbDBUrl.isEmpty() || dcbDBUser.isEmpty()) {
                            HCdiff.writeOut("[ERROR] Transform's using Table DCB has the following parameters:");
                            HCdiff.writeOut("Required Parameters:\nDCBDB-DRIVER\nDCBDB-URL\nDCBDB-USER\nOptional Parameters:\n   DCBDB-PASS\nDCBDB-TBLEXT");
                            HCdiff.exitOut(-1);
                        } else {
                            System.setProperty("dcb.mode.db", "true");
                            System.setProperty("dcb.db.driver", dcbDBDriver);
                            System.setProperty("dcb.db.url", dcbDBUrl);
                            System.setProperty("dcb.db.user", dcbDBUser);
                            System.setProperty("dcb.db.pass", dcbDBPass);
                            System.setProperty("dcb.db.table", dcbDBTblExt);
                        }
                    }
                    baseFileCharset = "";
                    String[] segs = baseDsnPath.split("\\" + File.separatorChar);
                    String dName = "";
                    boolean dcbFound = false;
                    for (int idx = segs.length - 1; idx >= 0; --idx) {
                        if (!DCB.exists((dName = dName.isEmpty() ? segs[idx] : segs[idx] + "." + dName).toUpperCase(), baseDsnPath)) continue;
                        baseDsnName = dName.toUpperCase();
                        dcbFound = true;
                        break;
                    }
                    if (!dcbFound) {
                        HCdiff.writeOut("[ERROR] Base file DCB entry not found for dsnPath: " + baseDsnPath);
                        HCdiff.exitOut(-1);
                    }
                    if ((baseDcb = DCBFactory.getInstance(baseDsnName, baseDsnPath, true)) == null) {
                        HCdiff.writeOut("[ERROR] DCB not found for " + baseDsnName.toUpperCase() + " in " + baseDsnPath);
                        HCdiff.exitOut(-1);
                    }
                    baseDcb.unlockDCB();
                    baseFileCharset = baseDcb.getCharset();
                    if (baseFileCharset == null || baseFileCharset.trim().isEmpty()) {
                        HCdiff.writeOut("[ERROR] Load file DCB missing charset information");
                        HCdiff.exitOut(-1);
                    }
                    if (isLoadFileEBCIDIC = ebcidicCodeSets.contains(" " + baseFileCharset.toUpperCase().replaceFirst("(IBM-)|(IBM)|(CP)", "") + ",")) {
                        RuntimeEnvironment.setGlobalParameter("DT", "3");
                        RuntimeEnvironment.setGlobalParameter("ibm.encoding", baseFileCharset);
                    } else {
                        RuntimeEnvironment.setGlobalParameter("DT", "1");
                        RuntimeEnvironment.setGlobalParameter("ibm.encoding", null);
                    }
                    RuntimeEnvironment.setGlobalParameter("be", baseFileCharset);
                    Variable.redoInitialization();
                    BatchTreeItem currItem = null;
                    for (Map.Entry<String, String> kv : xfdKeyValArgs.entrySet()) {
                        if (kv.getKey().endsWith("-NAME")) {
                            HCdiff.populateXFDTree(kv.getValue(), false);
                            primaryInputXfdFileName = kv.getValue().trim();
                            continue;
                        }
                        if (kv.getKey().endsWith("-IDXDESC")) {
                            String[] splitvals = kv.getValue().split("#");
                            currItem = HCdiff.getTreeItemforIndex(splitvals[0]);
                            if (splitvals.length >= 2) {
                                currItem.setText(1, splitvals[1]);
                            }
                            if (splitvals.length != 3) continue;
                            currItem.setText(2, splitvals[2]);
                            continue;
                        }
                        if (kv.getKey().endsWith("-INFO")) {
                            String[] splitvals;
                            Object[] cond = null;
                            if (currItem.getText().contains(REDEFINES_TXT)) {
                                splitvals = kv.getValue().split("#");
                                BatchTreeItem varItem = HCdiff.getItemInLayout(splitvals[3], currItem);
                                cond = new Object[]{((SqlColumn)varItem.getData()).createWorkingCopy(), HCdiff.getByteVal(splitvals[1]), splitvals[2].isEmpty() ? null : HCdiff.getByteVal(splitvals[2]), splitvals[0], splitvals[3]};
                            } else {
                                splitvals = kv.getValue().split("#");
                                cond = new Object[]{((SqlColumn)currItem.getData()).createWorkingCopy(), HCdiff.getByteVal(splitvals[1]), splitvals.length >= 3 && !splitvals[2].isEmpty() ? HCdiff.getByteVal(splitvals[2]) : null, splitvals[0], null};
                            }
                            currItem.setData(XFD_WHEN, cond);
                            continue;
                        }
                        if (!kv.getKey().equals("XFDVISIBILITY") || kv.getValue().isEmpty()) continue;
                        for (String str : kv.getValue().split("\\]")) {
                            int i;
                            int[] idx;
                            String[] str2 = str.split("\\[");
                            String parentIdx = str2[0];
                            String childIdxs = str2[1];
                            BatchTreeItem parentItem = null;
                            if (!parentIdx.isEmpty()) {
                                String[] idxs = parentIdx.split("_");
                                idx = new int[idxs.length];
                                for (i = 0; i < idxs.length; ++i) {
                                    idx[i] = Integer.parseInt(idxs[i]);
                                }
                                BatchTreeItem idxItem = XFDTree.getItem(idx[0]);
                                for (int i2 = 1; i2 < idx.length; ++i2) {
                                    idxItem = idxItem.getItem(idx[i2]);
                                }
                                parentItem = idxItem;
                            }
                            String[] cidxs = childIdxs.split(",");
                            idx = new int[cidxs.length];
                            for (i = 0; i < cidxs.length; ++i) {
                                idx[i] = Integer.parseInt(cidxs[i]);
                                try {
                                    if (parentItem == null) {
                                        XFDTree.getItem(idx[i]).setChecked(false);
                                        continue;
                                    }
                                    parentItem.getItem(idx[i]).setChecked(false);
                                    continue;
                                }
                                catch (IllegalArgumentException illErr) {
                                    HCdiff.writeOut("[ERROR] Error extracting rfs checked values. Possible corruption:" + kv.getKey() + "=" + kv.getValue() + "\n");
                                    illErr.printStackTrace();
                                    HCdiff.exitOut(-1);
                                }
                            }
                        }
                    }
                }
            }
            catch (Exception err) {
                if (err.getMessage() == null) {
                    HCdiff.writeOut("[ERROR] Error in transform:" + err.toString());
                } else {
                    HCdiff.writeOut("[ERROR] Transform Error:" + err.getMessage());
                }
                err.printStackTrace();
                HCdiff.exitOut(-1);
            }
        }
        HCdiff.validateDcbToXfdCharset();
        try {
            xfdRowLayout = null;
            xfdMap.clear();
            xfdCondMap.clear();
            hasMultipleLayouts = false;
            hasSingleLayout = false;
            hasNoLayouts = true;
            xfdAvail = false;
            if (XFDTree.getItemCount() > 0) {
                hasNoLayouts = false;
                for (BatchTreeItem item : XFDTree.getItems()) {
                    Vector<Object> xfdCols = new Vector<Object>();
                    boolean hasRedef = false;
                    HashMap<Object, Object[]> condMap = new HashMap<Object, Object[]>();
                    for (BatchTreeItem subItem : item.getItems()) {
                        if (subItem.getText(0).contains(REDEFINES_TXT)) continue;
                        if (subItem.getData(REDEFINED) != null) {
                            hasRedef = true;
                            xfdCols.add(subItem);
                            continue;
                        }
                        if (subItem.getChecked()) {
                            xfdCols.add(subItem.getData());
                        }
                        if (subItem.getData(XFD_WHEN) == null || subItem.getText(0).contains(REDEFINES_TXT)) continue;
                        Object[] condParams = (Object[])subItem.getData(XFD_WHEN);
                        condMap.put(subItem.getData(), new Object[]{HCdiff.extractDataType(condParams[1], condParams[0]), HCdiff.extractDataType(condParams[2], condParams[0]), condParams[3], condParams[4]});
                    }
                    if (condMap.size() > 0) {
                        xfdCondMap.put(xfdCols, condMap);
                    }
                    xfdMap.add(xfdCols);
                    if (hasRedef) {
                        layoutRedefMap.put(xfdCols, true);
                        continue;
                    }
                    layoutRedefMap.put(xfdCols, false);
                }
                hasMultipleLayouts = true;
                xfdAvail = true;
            }
            HCdiff.loadAndDiffFiles();
        }
        catch (Exception err) {
            HCdiff.writeOut("[ERROR] :");
            err.printStackTrace();
        }
        HCdiff.exitOut(0);
    }

    private static void loadAndDiffFiles() {
        int diffRecCntr = 0;
        try {
            recCntr = 0L;
            _baseCOBOLObject = new COBOLFile(baseDcb);
            diffDcb = new DCB(baseDsnName, diffDsnPath);
            diffDcb.unlockDCB();
            diffDcb.merge(baseDcb);
            diffDcb.setDatasetNamePath(diffDsnPath);
            diffDcb.setProtocol(baseDcb.getProtocol());
            _diffCOBOLObject = new COBOLFile(diffDcb);
            _baseCOBOLObject.open(READ, null);
            _diffCOBOLObject.open(READ, null);
            if (_diffCOBOLObject.getStatus().equals("35")) {
                HCdiff.writeOut("[ERROR] Data file not Found!:-" + diffDsnPath);
                HCdiff.exitOut(-1);
                return;
            }
            if (_baseCOBOLObject.getStatus().equals("35")) {
                HCdiff.writeOut("[ERROR] Data file not Found!:-" + baseDsnPath);
                HCdiff.exitOut(-1);
                return;
            }
            if (baseDcb.isNumbered()) {
                if (!_baseCOBOLObject.start(GE, "9(1)", "1")) {
                    HCdiff.writeOut("[ERROR] Start Operation Failed.\n" + baseDsnPath + "\nFile Status:" + _baseCOBOLObject.getStatus());
                    HCdiff.exitOut(-1);
                    return;
                }
                if (!_diffCOBOLObject.start(GE, "9(1)", "1")) {
                    HCdiff.writeOut("[ERROR] Start Operation Failed.\n" + diffDsnPath + "\nFile Status:" + _diffCOBOLObject.getStatus());
                    HCdiff.exitOut(-1);
                    return;
                }
            } else if (baseDcb.isIndexed()) {
                int totLen = 0;
                for (int i = 0; i < baseDcb.getKeyLength().length; ++i) {
                    totLen += baseDcb.getKeyLength()[i].intValue();
                }
                if (!_baseCOBOLObject.start(GE, new byte[totLen])) {
                    HCdiff.writeOut("[ERROR] Start Operation Failed.\n" + baseDsnPath + "\nFile Status:" + _baseCOBOLObject.getStatus());
                    HCdiff.exitOut(-1);
                    return;
                }
                if (!_diffCOBOLObject.start(GE, new byte[totLen])) {
                    HCdiff.writeOut("[ERROR] Start Operation Failed.\n" + diffDsnPath + "\nFile Status:" + _diffCOBOLObject.getStatus());
                    HCdiff.exitOut(-1);
                    return;
                }
            }
            boolean diffFound = false;
            boolean mismatch = false;
            boolean useSameRec = false;
            boolean diffNextRec = false;
            StringBuilder headerRow = new StringBuilder();
            StringBuilder file1charRow = new StringBuilder();
            StringBuilder file1hexRow1 = new StringBuilder();
            StringBuilder file1hexRow2 = new StringBuilder();
            StringBuilder file2charRow = new StringBuilder();
            StringBuilder file2hexRow1 = new StringBuilder();
            StringBuilder file2hexRow2 = new StringBuilder();
            StringBuilder diffOffsetRow = new StringBuilder();
            while (diffRecCntr <= diffRecLimit) {
                Object workStr;
                mismatch = false;
                useSameRec = false;
                if (!diffNextRec && _baseFileRecord != null && mismatchOff > -1 && mismatchOff < _baseFileRecord.length - 1) {
                    useSameRec = true;
                } else {
                    diffNextRec = false;
                }
                if (!useSameRec) {
                    if (file1charRow.length() > 0) {
                        if (diffInfoLevel > 0) {
                            System.out.println(headerRow.toString());
                            System.out.println(file1charRow.toString());
                            if (diffInfoLevel > 1) {
                                System.out.println(file1hexRow1.toString());
                                System.out.println(file1hexRow2.toString());
                            }
                            System.out.println(file2charRow.toString());
                            if (diffInfoLevel > 1) {
                                System.out.println(file2hexRow1.toString());
                                System.out.println(file2hexRow2.toString());
                            }
                            System.out.println(diffOffsetRow.toString());
                        }
                        headerRow.delete(0, headerRow.length());
                        file1charRow.delete(0, file1charRow.length());
                        file1hexRow1.delete(0, file1hexRow1.length());
                        file1hexRow2.delete(0, file1hexRow2.length());
                        file2charRow.delete(0, file2charRow.length());
                        file2hexRow1.delete(0, file2hexRow1.length());
                        file2hexRow2.delete(0, file2hexRow2.length());
                        diffOffsetRow.delete(0, diffOffsetRow.length());
                    }
                    _baseFileRecord = _baseCOBOLObject.read();
                    _diffFileRecord = _diffCOBOLObject.read();
                    ++recCntr;
                }
                if (_baseFileRecord == null && _diffFileRecord == null) {
                    if (!diffFound) {
                        HCdiff.writeOut("Files are identical");
                        HCdiff.exitOut(0);
                        return;
                    }
                    HCdiff.exitOut(1);
                    return;
                }
                if (_baseFileRecord == null) {
                    HCdiff.writeOut(baseDsnPath + "\n File has additional records.");
                    HCdiff.exitOut(1);
                    return;
                }
                if (_diffFileRecord == null) {
                    HCdiff.writeOut(diffDsnPath + "\n File has additional records.");
                    HCdiff.exitOut(1);
                    return;
                }
                int idx = 0;
                if (useSameRec) {
                    idx = mismatchOff + 1;
                }
                mismatchOff = -1;
                while (idx < _baseFileRecord.length) {
                    if (idx >= _diffFileRecord.length) {
                        mismatch = true;
                        diffNextRec = true;
                        diffFound = true;
                        break;
                    }
                    if (_baseFileRecord[idx] != _diffFileRecord[idx]) {
                        mismatch = true;
                        diffFound = true;
                        mismatchOff = idx;
                        break;
                    }
                    ++idx;
                }
                if (!mismatch && idx < _diffFileRecord.length) {
                    mismatch = true;
                    diffNextRec = true;
                    diffFound = true;
                }
                if (!mismatch) continue;
                if (diffInfoLevel == 0) {
                    HCdiff.writeOut("File has differences");
                    HCdiff.exitOut(1);
                }
                xfdRowLayout = null;
                if (baseDcb.isNumbered()) {
                    recCntr = _baseCOBOLObject.getKeyByteVar().toInt();
                }
                if (xfdAvail && mismatchOff > -1) {
                    Vector<Object> layout;
                    Vector<Object> vector = layout = xfdMap.size() == 1 ? xfdMap.get(0) : HCdiff.determineRowLayout(_baseFileRecord);
                    if (badRecord) {
                        layout = null;
                    }
                    if (layout == null) {
                        HCdiff.writeOut("Unable to map layout to record #" + recCntr);
                    } else {
                        xfdRowLayout = layoutRedefMap.get(layout) != false ? HCdiff.extractRedefines(layout, _baseFileRecord, false) : layout;
                    }
                }
                if (xfdRowLayout != null && mismatchOff > -1) {
                    boolean found = false;
                    for (Object col : xfdRowLayout) {
                        String hxString;
                        SqlColumn sqlCol = (SqlColumn)col;
                        if (mismatchOff < sqlCol.getOffset() || mismatchOff >= sqlCol.getOffset() + sqlCol.getLength()) continue;
                        if (!useSameRec) {
                            if (diffInfoLevel > 0) {
                                headerRow.append("REC #                    ");
                                file1charRow.append(String.format("%-20s", recCntr)).append(isLoadFileEBCIDIC ? "[EBC]" : "[ASC]");
                                file2charRow.append(String.format("%-20s", recCntr)).append(isLoadFileEBCIDIC ? "[EBC]" : "[ASC]");
                                if (diffInfoLevel > 1) {
                                    file1hexRow1.append(String.format("%-20s", " ")).append("[HEX]");
                                    file1hexRow2.append(String.format("%-25s", " "));
                                    file2hexRow1.append(String.format("%-20s", " ")).append("[HEX]");
                                    file2hexRow2.append(String.format("%-25s", " "));
                                }
                                diffOffsetRow.append(String.format("%-25s", " "));
                            }
                            ++diffRecCntr;
                        }
                        int colSize = ((String)(workStr = String.format("%s(%d-%d)", sqlCol.getName(), sqlCol.getOffset(), sqlCol.getLength()))).length() > sqlCol.getLength() ? ((String)workStr).length() : sqlCol.getLength();
                        String sizeFormat = "%-" + colSize + "." + colSize + "s";
                        byte[] theBytes = Arrays.copyOfRange(_baseFileRecord, ((SqlColumn)col).getOffset(), ((SqlColumn)col).getOffset() + ((SqlColumn)col).getLength());
                        if (diffInfoLevel > 0) {
                            headerRow.append("     ").append(String.format(sizeFormat, workStr));
                            file1charRow.append("     ").append(String.format(sizeFormat, new String(theBytes, baseDcb.getCharset())));
                            if (diffInfoLevel > 1) {
                                file1hexRow1.append("     ");
                                file1hexRow2.append("     ");
                                for (byte b : theBytes) {
                                    hxString = String.format("%02x", b);
                                    file1hexRow1.append(hxString.charAt(0));
                                    file1hexRow2.append(hxString.charAt(1));
                                }
                                if (((String)workStr).length() > sqlCol.getLength()) {
                                    file1hexRow1.append(String.format("%-" + (((String)workStr).length() - sqlCol.getLength()) + "s", " "));
                                    file1hexRow2.append(String.format("%-" + (((String)workStr).length() - sqlCol.getLength()) + "s", " "));
                                }
                            }
                        }
                        theBytes = Arrays.copyOfRange(_diffFileRecord, ((SqlColumn)col).getOffset(), ((SqlColumn)col).getOffset() + ((SqlColumn)col).getLength());
                        if (diffInfoLevel > 0) {
                            file2charRow.append("     ").append(String.format(sizeFormat, new String(theBytes, baseDcb.getCharset())));
                            if (diffInfoLevel > 1) {
                                file2hexRow1.append("     ");
                                file2hexRow2.append("     ");
                                for (byte b : theBytes) {
                                    hxString = String.format("%02x", b);
                                    file2hexRow1.append(hxString.charAt(0));
                                    file2hexRow2.append(hxString.charAt(1));
                                }
                                if (((String)workStr).length() > sqlCol.getLength()) {
                                    file2hexRow1.append(String.format("%-" + (((String)workStr).length() - sqlCol.getLength()) + "s", " "));
                                    file2hexRow2.append(String.format("%-" + (((String)workStr).length() - sqlCol.getLength()) + "s", " "));
                                }
                            }
                        }
                        if (diffInfoLevel > 0) {
                            int pos = mismatchOff - sqlCol.getOffset();
                            diffOffsetRow.append("     ");
                            int diffLoc = diffOffsetRow.length() + pos;
                            diffOffsetRow.append(String.format(sizeFormat, " "));
                            diffOffsetRow.replace(diffLoc, diffLoc + 1, "^");
                        }
                        mismatchOff = sqlCol.getOffset() + sqlCol.getLength() - 1;
                        found = true;
                        break;
                    }
                    if (found) continue;
                    HCdiff.writeOut("[ERROR] For record " + recCntr + " col info not available for mismatch position:" + mismatchOff);
                    continue;
                }
                if (diffInfoLevel <= 0) continue;
                ++diffRecCntr;
                headerRow.append("REC #                    ");
                file1charRow.append(String.format("%-20s", recCntr)).append(isLoadFileEBCIDIC ? "[EBC]" : "[ASC]");
                file2charRow.append(String.format("%-20s", recCntr)).append(isLoadFileEBCIDIC ? "[EBC]" : "[ASC]");
                if (diffInfoLevel > 1) {
                    file1hexRow1.append(String.format("%-20s", " ")).append("[HEX]");
                    file1hexRow2.append(String.format("%-25s", " "));
                    file2hexRow1.append(String.format("%-20s", " ")).append("[HEX]");
                    file2hexRow2.append(String.format("%-25s", " "));
                }
                diffOffsetRow.append(String.format("%-25s", " "));
                file1charRow.append("     ").append(new String(_baseFileRecord, baseDcb.getCharset()));
                file2charRow.append("     ").append(new String(_diffFileRecord, baseDcb.getCharset()));
                if (diffInfoLevel > 1) {
                    String hxString;
                    file1hexRow1.append("     ");
                    file1hexRow2.append("     ");
                    for (Object b : (Object)_baseFileRecord) {
                        hxString = String.format("%02x", (byte)b);
                        file1hexRow1.append(hxString.charAt(0));
                        file1hexRow2.append(hxString.charAt(1));
                    }
                    file2hexRow1.append("     ");
                    file2hexRow2.append("     ");
                    workStr = _diffFileRecord;
                    int n = ((Object)workStr).length;
                    for (int i = 0; i < n; ++i) {
                        Object b = workStr[i];
                        hxString = String.format("%02x", (byte)b);
                        file2hexRow1.append(hxString.charAt(0));
                        file2hexRow2.append(hxString.charAt(1));
                    }
                }
                if (mismatchOff == -1) {
                    mismatchOff = _baseFileRecord.length >= _diffFileRecord.length ? _diffFileRecord.length : _baseFileRecord.length;
                }
                String sizeFormat = "%-" + (mismatchOff + 1) + "s";
                int offLoc = mismatchOff + 30;
                diffOffsetRow.append("     ").append(String.format(sizeFormat, " ")).replace(offLoc, offLoc + 1, "^");
                diffNextRec = true;
            }
        }
        catch (Exception err) {
            HCdiff.writeOut("[ERROR] " + err.getMessage());
            HCdiff.exitOut(-1);
        }
    }

    private static Vector<Object> determineRowLayout(byte[] buf) {
        Iterator<Map.Entry<Vector<Object>, HashMap<Object, Object[]>>> it = xfdCondMap.entrySet().iterator();
        boolean found = false;
        while (it.hasNext()) {
            Map.Entry<Vector<Object>, HashMap<Object, Object[]>> keyvalue = it.next();
            HashMap<Object, Object[]> condMap = keyvalue.getValue();
            Iterator<Map.Entry<Object, Object[]>> condIt = condMap.entrySet().iterator();
            found = true;
            while (condIt.hasNext()) {
                Map.Entry<Object, Object[]> keyval = condIt.next();
                if (!HCdiff.checkXFDCondition(buf, keyval)) {
                    found = false;
                    break;
                }
                if (!badRecord) continue;
                return xfdMap.get(0);
            }
            if (badRecord) {
                return xfdMap.get(0);
            }
            if (!found) continue;
            return keyvalue.getKey();
        }
        return xfdMap.get(0);
    }

    private static boolean checkXFDCondition(byte[] buf, Map.Entry<Object, Object[]> keyval) {
        Object sqlObject = keyval.getKey();
        for (int i = 0; i < ((SqlColumn)sqlObject).getComponentCount(); ++i) {
            if (((SqlColumn)sqlObject).getOffset(i) + ((SqlColumn)sqlObject).getLength(i) <= buf.length) continue;
            HCdiff.writeOut("Record layout XFD Condition byte error: Record #" + recCntr + " length=" + _baseFileRecord.length + " bytes Field:" + ((SqlColumn)sqlObject).getName() + " Offset:" + ((SqlColumn)sqlObject).getOffset(i) + " Length:" + ((SqlColumn)sqlObject).getLength(i));
            badRecord = true;
            return false;
        }
        Object[] objArray = keyval.getValue();
        Object operand1 = objArray[0];
        Object operand2 = objArray[1];
        String cond = (String)objArray[2];
        return HCdiff.checkXFDCondition(buf, sqlObject, operand1, operand2, cond);
    }

    private static Vector<Object> extractRedefines(Vector<Object> layout, byte[] buf, boolean prompt) {
        useDefaultRedef = false;
        Vector<Object> newLayout = new Vector<Object>(layout.size());
        for (Object obj : layout) {
            if (obj instanceof BatchTreeItem) {
                HCdiff.processRedefines((BatchTreeItem)obj, newLayout, buf, prompt);
                continue;
            }
            newLayout.addElement(obj);
        }
        return newLayout;
    }

    private static BatchTreeItem getItemInLayout(String vname, BatchTreeItem currItem) {
        while (currItem.getParentItem() != null) {
            currItem = currItem.getParentItem();
        }
        for (BatchTreeItem itm2 : currItem.getItems()) {
            if (itm2.getItemCount() == 0 && !itm2.getText().contains(REDEFINES_TXT)) {
                if (!itm2.getText().startsWith(vname) || !itm2.getText().substring(0, itm2.getText().indexOf(91)).equals(vname)) continue;
                return itm2;
            }
            if (itm2.getItemCount() <= 0 || itm2.getText().contains(REDEFINES_TXT)) continue;
            for (BatchTreeItem itm3 : itm2.getItems()) {
                if (itm3.getItemCount() != 0 || itm3.getText().contains(REDEFINES_TXT) || !itm3.getText().startsWith(vname) || !itm3.getText().substring(0, itm3.getText().indexOf(91)).equals(vname)) continue;
                return itm3;
            }
        }
        return null;
    }

    private static BatchTreeItem getTreeItemforIndex(String idxStr) {
        String[] idxs = idxStr.split("_");
        int[] idx = new int[idxs.length];
        for (int i = 0; i < idxs.length; ++i) {
            idx[i] = Integer.parseInt(idxs[i]);
        }
        BatchTreeItem currItem = XFDTree.getItem(idx[0]);
        for (int i = 1; i < idx.length; ++i) {
            currItem = currItem.getItem(idx[i]);
        }
        return currItem;
    }

    private static byte[] getByteVal(String hexValues) {
        byte[] b = new byte[hexValues.length() / 2];
        for (int i = 0; i < b.length; ++i) {
            int index = i * 2;
            int v = Integer.decode("0x" + hexValues.substring(index, index + 2));
            b[i] = (byte)v;
        }
        return b;
    }

    private static void validateDcbToXfdCharset() {
        if (xfdXmlCharset != null && isLoadFileEBCIDIC != isXfdXmlEbcidic) {
            HCdiff.writeOut("Data file has a " + (isLoadFileEBCIDIC ? "" : "non-") + "EBCIDIC charset which does not match the charset for the XFD.\nThis may result in incorrect comparison.");
            if (!warnxfdcharset) {
                HCdiff.exitOut(-1);
            }
        }
    }

    private static void populateXFDTree(String filename, boolean validateXFDWhen) {
        File fXmlFile = new File(filename);
        if (!fXmlFile.isAbsolute()) {
            fXmlFile = new File(profDirLoc, filename);
        }
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            Document doc = dBuilder.parse(fXmlFile);
            doc.getDocumentElement().normalize();
            String charset = doc.getDocumentElement().getAttribute("charset");
            if (charset.isEmpty()) {
                charset = "";
            }
            if (xfdXmlCharset == null) {
                isXfdXmlEbcidic = false;
                xfdXmlCharset = charset;
                if (xfdXmlCharset.equalsIgnoreCase("Cp1047") || xfdXmlCharset.equalsIgnoreCase("EBCIDIC")) {
                    isXfdXmlEbcidic = true;
                }
                HCdiff.validateDcbToXfdCharset();
            } else if (!xfdXmlCharset.equalsIgnoreCase(charset)) {
                HCdiff.writeOut("[ERROR] Input XFDXml files has mixed charset");
                if (!warnxfdcharset) {
                    HCdiff.exitOut(-1);
                }
            } else {
                HCdiff.validateDcbToXfdCharset();
            }
        }
        catch (IOException | IllegalArgumentException | ParserConfigurationException | SAXException e) {
            e.printStackTrace();
            return;
        }
        try {
            LinkedHashMap<String, LinkedHashMap<String, Object>> layoutsMap = XmlDatasetLoader.XmlToFileTableExt(filename);
            Set<Map.Entry<String, LinkedHashMap<String, Object>>> layoutsEntrySet = layoutsMap.entrySet();
            Iterator<Map.Entry<String, LinkedHashMap<String, Object>>> layoutsIter = layoutsEntrySet.iterator();
            boolean ignore = false;
            while (layoutsIter.hasNext()) {
                Map.Entry<String, LinkedHashMap<String, Object>> elementsMap = layoutsIter.next();
                ignore = false;
                for (BatchTreeItem itm : XFDTree.getItems()) {
                    if (!itm.getText().equals(elementsMap.getKey())) continue;
                    ignore = true;
                }
                if (ignore) continue;
                BatchTreeItem layoutItem = new BatchTreeItem(XFDTree);
                layoutItem.setText(elementsMap.getKey());
                layoutLength = 0;
                whenConds.clear();
                layoutLength = HCdiff.recursiveLoadElements(elementsMap.getValue(), layoutItem, false);
                if (validateXFDWhen) {
                    HCdiff.validateConditions(layoutItem);
                }
                layoutItem.setChecked(true);
                layoutItem.setData("LEN", layoutLength);
                layoutItem.setData("FILE", filename);
            }
        }
        catch (Exception err) {
            HCdiff.writeOut("[ERROR] populateXFDTree:-");
            err.printStackTrace();
            HCdiff.exitOut(-1);
            return;
        }
    }

    private static int recursiveLoadElements(LinkedHashMap<String, Object> elementsMap, BatchTreeItem currItem, boolean isredef) {
        int maxGrpLen = 0;
        int groupLen = 0;
        int fieldLen = 0;
        Set<Map.Entry<String, Object>> elementsEntrySet = elementsMap.entrySet();
        Iterator<Map.Entry<String, Object>> elementsIter = elementsEntrySet.iterator();
        BatchTreeItem lastItem = null;
        while (elementsIter.hasNext()) {
            Map.Entry<String, Object> elementsES = elementsIter.next();
            String[] vals = elementsES.getKey().split(String.valueOf('\u001d'), 2);
            if (elementsES.getValue() instanceof SqlColumn) {
                BatchTreeItem sqlColItem = new BatchTreeItem(currItem);
                sqlColItem.setChecked(true);
                sqlColItem.setData(elementsES.getValue());
                try {
                    fieldLen = ((SqlColumn)elementsES.getValue()).getLength();
                    sqlColItem.setText(1, ((SqlColumn)elementsES.getValue()).getPicString());
                    if (elementsES.getKey().contains(REDEFINES_TXT)) {
                        if (lastItem != null) {
                            ArrayList data = lastItem.getData(REDEFINED);
                            if (data == null) {
                                data = new ArrayList();
                            }
                            ((ArrayList)data).add(sqlColItem);
                            lastItem.setData(REDEFINED, data);
                        }
                        sqlColItem.setText(vals[0]);
                        if (fieldLen > maxGrpLen) {
                            groupLen += fieldLen - maxGrpLen;
                            maxGrpLen = fieldLen;
                        }
                    } else {
                        sqlColItem.setText(((SqlColumn)elementsES.getValue()).getName().toUpperCase() + "[" + ((SqlColumn)elementsES.getValue()).getOffset() + ":" + ((SqlColumn)elementsES.getValue()).getLength() + "]");
                        lastItem = sqlColItem;
                        groupLen += fieldLen;
                        maxGrpLen = fieldLen;
                    }
                    if (vals.length != 2) continue;
                    sqlColItem.setData("XMLATTR", vals[1]);
                    whenConds.add(sqlColItem);
                    continue;
                }
                catch (Exception err) {
                    HCdiff.writeOut("[ERROR] recursiveLoadElements:-");
                    err.printStackTrace();
                    HCdiff.exitOut(-1);
                    return 0;
                }
            }
            BatchTreeItem newItem = new BatchTreeItem(currItem);
            if (elementsES.getKey().contains(REDEFINES_TXT)) {
                newItem.setText(vals[0]);
                newItem.setData("XMLATTR", vals[1]);
                whenConds.add(newItem);
                if (lastItem != null) {
                    ArrayList data = lastItem.getData(REDEFINED);
                    if (data == null) {
                        data = new ArrayList();
                    }
                    ((ArrayList)data).add(newItem);
                    lastItem.setData(REDEFINED, data);
                }
            } else {
                newItem.setText(elementsES.getKey());
                lastItem = newItem;
                maxGrpLen = 0;
            }
            newItem.setChecked(true);
            int currGrpLen = HCdiff.recursiveLoadElements((LinkedHashMap)elementsES.getValue(), newItem, elementsES.getKey().contains(REDEFINES_TXT));
            if (currGrpLen <= maxGrpLen) continue;
            groupLen += currGrpLen - maxGrpLen;
            maxGrpLen = currGrpLen;
        }
        return groupLen;
    }

    private static String getFieldName(BatchTreeItem item) {
        if (item.getText().indexOf(91) != -1) {
            return item.getText().substring(0, item.getText().indexOf(91));
        }
        if (item.getText().indexOf(32) != -1) {
            return item.getText().substring(0, item.getText().indexOf(32));
        }
        return item.getText();
    }

    private static BatchTreeItem getXFdVarMatch(BatchTreeItem item, String varname) {
        if (item.getData() != null && varname.equals(HCdiff.getFieldName(item))) {
            return item;
        }
        for (BatchTreeItem subItem : item.getItems()) {
            if (subItem.getItemCount() == 0 && item.getData() != null && varname.equals(HCdiff.getFieldName(subItem))) {
                return subItem;
            }
            BatchTreeItem result = HCdiff.getXFdVarMatch(subItem, varname);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    private static void validateConditions(BatchTreeItem layoutItem) {
        for (BatchTreeItem whenItm : whenConds) {
            Object sqlvar;
            String whenattr = (String)whenItm.getData("XMLATTR");
            String[] attrs = whenattr.split(String.valueOf('\u001d'));
            BatchTreeItem varItem = null;
            String desc = "";
            String varname = null;
            if (whenItm.getText().contains(REDEFINES_TXT)) {
                varname = attrs[3].toUpperCase();
                for (BatchTreeItem itm2 : layoutItem.getItems()) {
                    BatchTreeItem result = HCdiff.getXFdVarMatch(itm2, varname);
                    if (result == null) continue;
                    varItem = result;
                    break;
                }
                if (varItem == null) {
                    HCdiff.writeOut("$XFD WHEN [varname]  operator arg1 [arg2]");
                    HCdiff.writeOut("Unable to map <varname>:" + varname);
                    continue;
                }
                desc = desc + varname;
                sqlvar = varItem.getData();
            } else {
                sqlvar = whenItm.getData();
            }
            try {
                SqlColumn workSql = ((SqlColumn)sqlvar).createWorkingCopy();
                String oper = attrs[0];
                if (oper.equalsIgnoreCase("LTEQ")) {
                    oper = "IS < OR = TO";
                } else if (oper.equalsIgnoreCase("LT")) {
                    oper = "IS < THAN";
                } else if (oper.equalsIgnoreCase("EQ")) {
                    oper = "IS = TO";
                } else if (oper.equalsIgnoreCase("GTEQ")) {
                    oper = "IS > OR = TO";
                } else if (oper.equalsIgnoreCase("GT")) {
                    oper = "IS > THAN";
                } else if (oper.equalsIgnoreCase("BET")) {
                    oper = "IS BETWEEN";
                } else if (oper.equalsIgnoreCase("!LTEQ")) {
                    oper = "NOT < OR = TO";
                } else if (oper.equalsIgnoreCase("!LT")) {
                    oper = "NOT < THAN";
                } else if (oper.equalsIgnoreCase("!EQ")) {
                    oper = "NOT = TO";
                } else if (oper.equalsIgnoreCase("!GTEQ")) {
                    oper = "NOT > OR = TO";
                } else if (oper.equalsIgnoreCase("!GT")) {
                    oper = "NOT > THAN";
                } else if (oper.equalsIgnoreCase("!BET")) {
                    oper = "NOT BETWEEN";
                }
                int sqlLen = workSql.getLength();
                byte[] arg1Buf = new byte[sqlLen];
                workSql.updateColumn(arg1Buf, 0, attrs[1]);
                desc = desc + " " + oper + "  [" + attrs[1] + "] ";
                byte[] arg2Buf = null;
                if (oper.contains("BETWEEN")) {
                    arg2Buf = new byte[sqlLen];
                    workSql.updateColumn(arg2Buf, 0, attrs[2]);
                    desc = desc + " AND [" + attrs[2] + "] ";
                }
                whenItm.setText(2, desc);
                whenItm.setData(XFD_WHEN, new Object[]{workSql, arg1Buf, arg2Buf, oper, varname});
            }
            catch (Exception err) {
                HCdiff.writeOut("[ERROR] validateConditions:-");
                err.printStackTrace();
                HCdiff.exitOut(-1);
                return;
            }
        }
    }

    private static Object extractDataType(Object obj1, Object sqlObj) {
        if (obj1 == null) {
            return null;
        }
        try {
            SqlColumn sqlWork = ((SqlColumn)sqlObj).createWorkingCopy();
            sqlWork.updateColumn((byte[])obj1, 0, (byte[])obj1);
            return sqlWork.getIDataTypeColumn();
        }
        catch (Exception err) {
            HCdiff.writeOut("[ERROR] extractDataType:-");
            err.printStackTrace();
            HCdiff.exitOut(-1);
            return null;
        }
    }

    private static void extractRedefines(BatchTreeItem Item, Vector<Object> newlayout, byte[] buf, boolean prompt) {
        if (Item.getItemCount() == 0 && Item.getChecked()) {
            newlayout.add(Item.getData());
        } else {
            for (BatchTreeItem itm : Item.getItems()) {
                if (itm.getText(0).contains(REDEFINES_TXT)) continue;
                if (itm.getItemCount() == 0 && itm.getChecked()) {
                    newlayout.add(itm.getData());
                }
                if (itm.getItemCount() <= 0 || itm.getData(REDEFINED) == null) continue;
                HCdiff.processRedefines(itm, newlayout, buf, prompt);
            }
        }
    }

    private static void processRedefines(BatchTreeItem redefinedItem, Vector<Object> newlayout, byte[] buf, boolean prompt) {
        Object data = redefinedItem.getData(REDEFINED);
        if (data != null) {
            ArrayList redefines = (ArrayList)data;
            if (prompt) {
                HCdiff.extractRedefines(redefinedItem, newlayout, buf, prompt);
            } else {
                for (int i = 0; i < redefines.size(); ++i) {
                    Object[] condParams = (Object[])((BatchTreeItem)redefines.get(i)).getData(XFD_WHEN);
                    BatchTreeItem condItem = HCdiff.getItemInLayout((String)condParams[4], (BatchTreeItem)redefines.get(i));
                    if (!HCdiff.checkXFDCondition(buf, condItem.getData(), HCdiff.extractDataType(condParams[1], condParams[0]), HCdiff.extractDataType(condParams[2], condParams[0]), condParams[3])) continue;
                    HCdiff.extractRedefines((BatchTreeItem)redefines.get(i), newlayout, buf, prompt);
                    return;
                }
                HCdiff.extractRedefines(redefinedItem, newlayout, buf, prompt);
            }
        }
    }

    private static boolean checkXFDCondition(byte[] buf, Object sqlObject, Object operand1, Object operand2, Object cond) {
        try {
            ((SqlColumn)sqlObject).snagValue(buf, 0);
            IDatatype operand0 = ((SqlColumn)sqlObject).getIDataTypeColumn();
            int compare1 = HCdiff.compareOperands(operand0, operand1);
            if (cond.equals(CONDITIONS.get(0))) {
                return compare1 <= 0;
            }
            if (cond.equals(CONDITIONS.get(1))) {
                return compare1 < 0;
            }
            if (cond.equals(CONDITIONS.get(2))) {
                return compare1 == 0;
            }
            if (cond.equals(CONDITIONS.get(3))) {
                return compare1 >= 0;
            }
            if (cond.equals(CONDITIONS.get(4))) {
                return compare1 > 0;
            }
            if (cond.equals(CONDITIONS.get(5))) {
                int compare2 = HCdiff.compareOperands(operand0, operand2);
                return compare1 >= 0 && compare2 <= 0;
            }
            if (cond.equals(CONDITIONS.get(6))) {
                return compare1 > 0;
            }
            if (cond.equals(CONDITIONS.get(7))) {
                return compare1 >= 0;
            }
            if (cond.equals(CONDITIONS.get(8))) {
                return compare1 != 0;
            }
            if (cond.equals(CONDITIONS.get(9))) {
                return compare1 < 0;
            }
            if (cond.equals(CONDITIONS.get(10))) {
                return compare1 <= 0;
            }
            if (cond.equals(CONDITIONS.get(11))) {
                int compare2 = HCdiff.compareOperands(operand0, operand2);
                return compare1 < 0 || compare2 > 0;
            }
            return true;
        }
        catch (Exception err) {
            HCdiff.writeOut("[ERROR] checkXFDCondition:");
            err.printStackTrace();
            HCdiff.exitOut(-1);
            return false;
        }
    }

    private static int compareOperands(Object op0, Object op1) {
        try {
            if (op0 instanceof Variable) {
                return ((Variable)op0).compare((Variable)op1);
            }
            if (op1 instanceof BignumType) {
                return ((BignumType)op0).compare((BignumType)op1);
            }
            if (op1 instanceof Comp1) {
                return ((Comp1)op0).compare((Comp1)op1);
            }
            if (op1 instanceof Comp2) {
                return ((Comp2)op0).compare((Comp2)op1);
            }
            if (op1 instanceof Numeric) {
                return ((Numeric)op0).compare((Numeric)op1);
            }
            new Exception("Unknown dataType encountered during comparison:" + op0.toString());
            return 0;
        }
        catch (Exception err) {
            HCdiff.writeOut("[ERROR] compareOperands:");
            err.printStackTrace();
            HCdiff.exitOut(-1);
            return 0;
        }
    }

    static void writeOut(String messg) {
        System.out.println(messg);
        if (logfile != null) {
            logfile.println(messg);
        }
    }

    static void exitOut(int exitCode) {
        if (_baseCOBOLObject != null && _baseCOBOLObject.isOpen()) {
            _baseCOBOLObject.close();
        }
        if (_diffCOBOLObject != null && _diffCOBOLObject.isOpen()) {
            _diffCOBOLObject.close();
        }
        if (logfile != null) {
            logfile.close();
        }
        System.exit(exitCode);
    }

    static {
        logfile = null;
        sqluser = "";
        sqlpasswd = "";
        sqlurl = "";
        sqldriver = "";
        sqlautocommit = "";
        sqlisolation = "";
        sqlcatalog = "";
        sqlreadonly = "";
        baseDsnName = "";
        baseDsnPath = "";
        dcbDBMode = "";
        dcbDBDriver = "";
        dcbDBDriverJar = "";
        dcbDBUrl = "";
        dcbDBUser = "";
        dcbDBPass = "";
        dcbDBTblExt = "";
        diffDsnPath = "";
        recMin = -1;
        recMax = -1;
        recAvg = -1;
        rfsLoc = "";
        GE = 1;
        XFD_WHEN = "COND";
        REDEFINES_TXT = " redefines ";
        REDEFINED = "REDEFINED";
        profFileLoc = "";
        READ = "READ";
        CONDITIONS = new ArrayList<String>(Arrays.asList("IS < OR = TO", "IS < THAN", "IS = TO", "IS > OR = TO", "IS > THAN", "IS BETWEEN", "NOT < OR = TO", "NOT < THAN", "NOT = TO", "NOT > OR = TO", "NOT > THAN", "NOT BETWEEN"));
        SQLCONDITIONS = new ArrayList<String>(Arrays.asList(" <= ", " < ", " = ", " >= ", " > ", " BETWEEN ", " > ", " >= ", " != ", " < ", " <= ", " NOT BETWEEN "));
        readCnt = 0;
        dupCnt = 0;
        writeCnt = 0;
        dupFailCnt = 0;
        diffRecLimit = -1;
        diffInfoLevel = -1;
        useDefaultRedef = false;
        hasMultipleLayouts = false;
        hasSingleLayout = false;
        hasNoLayouts = false;
        xfdAvail = false;
        quietMode = false;
        baseFileCharset = "";
        warnxfdcharset = false;
        xfdXmlCharset = null;
        isLoadFileEBCIDIC = false;
        ebcidicCodeSets = " 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 1140, 37-2, 38, 39, 40, 251, 252, 254, 256, 257, 258, 259, 260, 264, 273, 1141, 274, 275, 276, 277, 1142, 278, 1143, 279, 280, 1144, 281, 282, 283, 284, 1145, 285, 1146, 286, 287, 288, 289, 290, 293, 297, 1147, 298, 300, 310, 320, 321, 322, 330, 351, 352, 353, 355, 357, 358, 359, 360, 361, 363, 382, 383, 384, 385, 386, 387, 388, 389, 390, 391, 392, 393, 394, 395, 410, 420, 16804, 421, 423, 424, 8616, 12712, 425, 435, 500, 1148, 803, 829, 833, 834, 835, 836, 837, 838, 838, 839, 870, 1110, 1153, 871, 1149, 875, 4971, 9067, 880, 881, 882, 883, 884, 885, 886, 887, 888, 889, 890, 892, 893, 905, 918, 924, 930, 1390, 931, 933, 1364, 935, 1388, 937, 1371, 939, 1399, 1001, 1002, 1003, 1005, 1007, 1024, 1025, 1154, 1026, 1155, 1027, 1028, 1030, 1031, 1032, 1033, 1037, 1047, 1068, 1069, 1070, 1071, 1073, 1074, 1075, 1076, 1077, 1078, 1079, 1080, 1081, 1082, 1083, 1084, 1085, 1087, 1091, 1097, 1112, 1156, 1113, 1122, 1157, 1123, 1158, 1130, 1164, 1132, 1136, 1137, 1150, 1151, 1152, 1159, 1165, 1166, 1278, 1279, 1303, 1364, 1376, 1377, JEF, KEIS,";
        XFDTree = new BatchTree(3);
        whenConds = new ArrayList();
        xfdCondMap = new HashMap();
        xfdMap = new Vector();
        xfdKeyValArgs = new TreeMap<String, String>();
        recCntr = 0L;
        badRecord = false;
        sqlgen = new StringBuilder();
        primaryInputXfdFileName = "";
        isXfdXmlEbcidic = false;
    }
}

