/*
 * Decompiled with CFR 0.152.
 */
package com.heirloomcomputing.ecs.util;

import com.heirloomcomputing.ecc.HCILicensing;
import com.heirloomcomputing.ecs.api.IDatatype;
import com.heirloomcomputing.ecs.exec.BignumType;
import com.heirloomcomputing.ecs.exec.Comp1;
import com.heirloomcomputing.ecs.exec.Comp2;
import com.heirloomcomputing.ecs.exec.Display;
import com.heirloomcomputing.ecs.exec.DisplayA;
import com.heirloomcomputing.ecs.exec.DisplayH;
import com.heirloomcomputing.ecs.exec.DisplayMVS;
import com.heirloomcomputing.ecs.exec.DisplayP;
import com.heirloomcomputing.ecs.exec.Numeric;
import com.heirloomcomputing.ecs.exec.RuntimeEnvironment;
import com.heirloomcomputing.ecs.exec.Variable;
import com.heirloomcomputing.ecs.isamsql.COBOLFile;
import com.heirloomcomputing.ecs.isamsql.DCB;
import com.heirloomcomputing.ecs.isamsql.DCBFactory;
import com.heirloomcomputing.ecs.isamsql.SqlColumn;
import com.heirloomcomputing.ecs.isamsql.XmlDatasetLoader;
import com.heirloomcomputing.ecs.util.BatchTree;
import com.heirloomcomputing.ecs.util.BatchTreeItem;
import com.heirloomcomputing.ecs.util.XfdUtils;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.SortedMap;
import java.util.Timer;
import java.util.TimerTask;
import java.util.TreeMap;
import java.util.UUID;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLInputFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class Transform {
    static PrintWriter logfile = null;
    static String profDirLoc;
    static String CURR_PROF_VERSION;
    static String CURR_RFS_VERSION;
    static String sqluser;
    static String sqlpasswd;
    static String sqlurl;
    static String sqldriver;
    static String sqlautocommit;
    static String sqlisolation;
    static String sqlcatalog;
    static String sqlreadonly;
    static String inDsnName;
    static String inDsnPath;
    static String dcbDBMode;
    static boolean isDCBDB;
    static String dcbDBDriver;
    static String dcbDBDriverJar;
    static String dcbDBUrl;
    static String dcbDBUser;
    static String dcbDBPass;
    static String dcbDBTblExt;
    static String convert;
    static String convertRange;
    static String in_dsorg;
    static String in_orient;
    static String in_recfm;
    static String in_proto;
    static Integer in_recmin;
    static Integer in_recavg;
    static Integer in_lrecl;
    static Integer in_blksize;
    static Integer in_limit;
    static Integer[] in_keylen;
    static Integer[] in_keyoff;
    static Integer[] in_altkeyoffs;
    static Integer[] in_altkeylens;
    static Boolean[] in_altkeydups;
    static Integer[] in_altkeygroups;
    static Integer in_label;
    static String in_expdt;
    static String in_reuse;
    static String in_relate;
    static String[] in_associates;
    static String in_charset;
    static String in_path;
    static String outDsnName;
    static String outDsnPath;
    static String outOrient;
    static String outFormat;
    static String outPrimaryOffsets;
    static Integer[] _outPrimaryOffsets;
    static String outPrimaryLengths;
    static Integer[] _outPrimaryLengths;
    static String outPrimaryTypes;
    static String[] _outPrimaryTypes;
    static String outRelKeyLength;
    static Integer[] _outRelKeyLength;
    static String outAltOffsets;
    static Integer[] _outAltOffsets;
    static String outAltLengths;
    static Integer[] _outAltLengths;
    static String outAltTypes;
    static String[] _outAltTypes;
    static String outAltDups;
    static Boolean[] _outAltDups;
    static String outAltGroups;
    static Integer[] _outAltGroups;
    static String outRecMin;
    static int recMin;
    static String outRecMax;
    static int recMax;
    static String outRecAvg;
    static int recAvg;
    static String outProtocol;
    static String outCharset;
    static Map<String, Object> outVDBIdxInfo;
    static ArrayList<String> outVDBViews;
    static String rfsLoc;
    static String outAppend;
    static String IS_BATCH_INSERT_MODE;
    static String BATCH_INSERT_SIZE;
    static String XFD_WHEN;
    static String REDEFINES_TXT;
    static String REDEFINED;
    static String profFileLoc;
    static String READ;
    static String WRITE;
    static String READWRITE;
    static String EXTEND;
    static ArrayList<String> CONDITIONS;
    static ArrayList<String> SQLCONDITIONS;
    static int recFrom;
    static int recTo;
    static int layoutLength;
    static int inDcbLrecl;
    static int readCnt;
    static int dupCnt;
    static int writeCnt;
    static int dupFailCnt;
    static byte[] inbytes;
    static boolean useDefaultRedef;
    static boolean outDCBIsNumbered;
    static boolean outDCBIsIndexed;
    static boolean hasMultipleLayouts;
    static boolean hasSingleLayout;
    static boolean hasNoLayouts;
    static boolean xfdAvail;
    static boolean noConv;
    static boolean asc2ebc;
    static boolean quietMode;
    static boolean eclipseForeMode;
    static String loadFileCharset;
    static String transformFileCharset;
    static boolean warnxfdcharset;
    static boolean badrecordexit;
    static boolean norecvalidate;
    static String xfdXmlCharset;
    static boolean isLoadFileEBCIDIC;
    static boolean isTransformFileEBCIDIC;
    static ArrayList<ArrayList<String>> blockMaster;
    static String ebcidicCodeSets;
    static byte[][] signedAscToEbcMap;
    static byte[] input2outputByteMap;
    static BatchTree XFDTree;
    static COBOLFile inCobolFile;
    static COBOLFile outCobolFile;
    static DCB inDcb;
    static DCB outDcb;
    private static ArrayList<BatchTreeItem> whenConds;
    static Vector<Object> xfdRowLayout;
    static HashMap<Vector<Object>, HashMap<Object, Object[]>> xfdCondMap;
    static Vector<Vector<Object>> xfdMap;
    static SortedMap<String, String> xfdKeyValArgs;
    static int recCntr;
    static boolean badRecord;
    static ArrayList<String> includedLayouts;
    static ArrayList<String> excludedLayouts;
    static HashMap<String, String> renamedLayouts;
    static HashMap<String, String> redefUseMap;
    static HashMap<String, String> redefIterFileMap;
    static HashMap<String, String> layoutRedefIterMap;
    static HashMap<String, Object[]> whenCondMap;
    static HashMap<String, String> viewWhereConditions;
    static String useVarchar;
    static boolean varChar;
    static String genMatView;
    static boolean matView;
    static String dbms;
    static String xfdFileName;
    static String sqlFileName;
    static BufferedWriter bw;
    static BufferedWriter bwRedef;
    static StringBuilder sqlgen;
    static String currLayout;
    static String defLayout;
    static boolean iterateRedef;
    static String datasetGroupID;
    static String redefinesID;
    static ArrayList<String> redefProcess;
    static ArrayList<String> redefinedList;
    static HashMap<String, String> redefiningMap;
    static String primaryInputXfdFileName;
    static boolean generateViews;
    static Map<Object, Integer[]> sqlTranslateMap;
    static int signedTransform;
    static boolean killCounter;
    static boolean isXfdXmlEbcidic;
    static Timer timer;

    private static void help() {
        System.out.println("");
        System.out.println("");
        System.out.println("java -cp [/path/to/ecoboljar;/path/to/sqldrivers] com.heirloomcomputing.ecs.util.Transform ");
        System.out.println("     [help] [quietmode] [warnxfdcharset] [norecvalidate] [badrecordexit] [key:value] myfile.prof");
        System.out.println("");
        System.out.println("     help        - Display help Information");
        System.out.println("");
        System.out.println("     quietmode   - Display only final count of records converted");
        System.out.println("");
        System.out.println("     warnxfdcharset - If the XFD Charset does not match the load file charset, issue a warning but do not exit");
        System.out.println("                      Default behavior is to exit");
        System.out.println("");
        System.out.println("     badrecordexit - If record length is shorter than the layout issue a warning and exit");
        System.out.println("                     Default behavior is to issue a warning and continue");
        System.out.println("");
        System.out.println("     norecvalidate - Specifying this option prevents validation of the record length to the various fields in the record layout");
        System.out.println("                     Default behavior is to perform validation");
        System.out.println("");
        System.out.println("     key:value   - Override key:value specified in .prof file");
        System.out.println("                   For e.g. OUTFILE-ALTKEY-OFFSETS:\"[3, 2]\" ");
        System.out.println("                   Note: Value for Key:Value pairs that contains spaces should be enclosed within quotes");
        System.out.println("                   The following are the Key:Value pairs that may be specified");
        System.out.println("");
        System.out.println("                   sql.<conn-name>.user=<active sql connection user name>");
        System.out.println("                   sql.<conn-name>.password=<active sql connection password>");
        System.out.println("                   sql.<conn-name>.url=<active sql connection url>");
        System.out.println("                   sql.<conn-name>.driver=<active sql connection driver location>");
        System.out.println("                   sql.<conn-name>.autocommit=<active sql connection auto commit (true|false)>");
        System.out.println("                   sql.<conn-name>.isolation=<active sql connection isolation (repeatable|uncommitted|committed|serializable)>");
        System.out.println("                   sql.<conn-name>.catalog=<active sql connection catalog>");
        System.out.println("                   sql.<conn-name>.readonly=<active sql connection readonly (true|false)>");
        System.out.println("");
        System.out.println("                   LOGFILE=path/to/logfile  [On Windows use \\\\ as file path separator]");
        System.out.println("                   INFILE-DSNPATH=\"path/to/input/dataset\" [On Windows use \\\\ as file path separator]");
        System.out.println("                   CONVERTCOUNT=n   (n is the number of records to be converted)");
        System.out.println("                   CONVERTRANGE=n-m (n-m is the range of records to be converted)");
        System.out.println("                   OUTFILE-APPEND=TRUE|FALSE   Default behavior is to create new files. Set to TRUE to append.");
        System.out.println("                   OUTFILE-DSNPATH=\"path/to/output/dataset\" [On Windows use \\\\ as file path separator]");
        System.out.println("                   OUTFILE-ORIENT=INDEXED|NONINDEXED|LINEAR|NUMBERED|LINESEQUENTIAL   (file orientation)");
        System.out.println("                   OUTFILE-FORMAT=F|V|U|FB|VB|FBS|VBS|FBA|VBA      (file format) ");
        System.out.println("                   OUTFILE-PRIMARY-OFFSETS=\"[n, m, ....]\" (primary key offsets)");
        System.out.println("                   OUTFILE-PRIMARY-LENGTHS=\"[n, m, ....]\" (primary key lengths)");
        System.out.println("                   OUTFILE-PRIMARY-TYPES=\"[n, m, ....]\" (primary key composite types, can be 't' for text and 'n' for non text sub field)");
        System.out.println("                   OUTFILE-RELKEY-LENGTH=n              (relative key length)");
        System.out.println("                   OUTFILE-ALTKEY-OFFSETS=\"[n, m, ....]\" (alternate key offsets)");
        System.out.println("                   OUTFILE-ALTKEY-LENGTHS=\"[n, m, ....]\" (alternate key lengths)");
        System.out.println("                   OUTFILE-ALTKEY-TYPES=\"[n, m, ....]\" (alternate key composite types, can be 't' for text and 'n' for non text sub field)");
        System.out.println("                   OUTFILE-ALTKEY-DUPS=\"[true, false, ....]\" (alternate key duplicates allowed)");
        System.out.println("");
        System.out.println("                   OUTFILE-ALTKEY-GROUPS=\"[n, m, ....]\" (alternate key groups)");
        System.out.println("                          OUTFILE-ALTKEY-GROUPS are used to identify split key groups. Non Split keys will have a");
        System.out.println("                          indicator value of -1. For e.g.:- [0,0,-1,2,2,2,-1,3,3] represents the following keys:");
        System.out.println("                          two field split key(0,0) , non split key(-1), 3 field split key(2,2,2) ,a non split key(-1)");
        System.out.println("                          and a two field split key(3,3)");
        System.out.println("");
        System.out.println("                   OUTFILE-REC-MINIMUM=n    (record minimum length)");
        System.out.println("                   OUTFILE-REC-MAXIMUM=n    (record maximum length)");
        System.out.println("                   OUTFILE-REC-AVG=n        (record average length)");
        System.out.println("                   OUTFILE-PROTOCOL=EC|MF|MF3|MF8|CISAM|DISAM|EISAM|AS400|ACU|IBM|IBMV|IBMVB|SYNC|VSQL|VDB  (file protocol)");
        System.out.println("                   OUTFILE-CHARSET= (Charset/Codepage)");
        System.out.println("                   RFS-VERSION=1                     XFD Record Format Structure");
        System.out.println("                   XFD[n]-NAME=value                 -name of xfd xml file created during compilation");
        System.out.println("                     XFD[n]-WHEN[n]-IDXDESC=value  --");
        System.out.println("                                                     |-WHEN conditional information. These may be repeated multiple times for each xfd xml file");
        System.out.println("                     XFD[n]-WHEN[n]-INFO=value     --");
        System.out.println("                   XFDVISIBILITY=value             -XFD field visibility info. Occurs once");
        System.out.println("");
        System.out.println("");
        System.out.println("                   *****The following key=value options applies to VDB Views generation for multi record layouts/redefines");
        System.out.println("                   USE-VARCHAR=TRUE|FALSE  Use VARCHAR declaration whereever CHAR PIC(X) is in use");
        System.out.println("                   MATERIALIZED-VIEW=TRUE|FALSE  Create SQL for materialized View");
        System.out.println("                   INCLUDE-LAYOUTS=Layout1,Layout2,Layout3,.....  Include layouts from a multi-layout XFD");
        System.out.println("                   EXCLUDE-LAYOUTS=Layout1,Layout2,Layout3,.....  Exclude layouts from a multi-layout XFD");
        System.out.println("                   RENAME-LAYOUTS=Layout1:MyLayout,Layout2:UrLayout,Layout3:HisLayout,.....  Override the layout field name during SQL generation");
        System.out.println("                   REDEFINES_USE= <Layout>.<RedefinedField1>:<RedefiningField1>,.......");
        System.out.println("                        where <layout> is the name of the top 01 level record field");
        System.out.println("                        <RedefinedField1> is the name of the base field that is being redefined");
        System.out.println("                        <RedefiningField1> is the name of the redefining field to be used when creating the view");
        System.out.println("                        The <layout> qualifier is required when multiple layouts (01 levels) are present");
        System.out.println("                        If the <layout> qualifier is not present, the field is processed for every layout encountered");
        System.out.println("                        For e.g.");
        System.out.println("                        REDEFINES_USE=Layout1.RedefinedA:RedefinesA2,Layout2.RedefinedB:RedefinesB1");
        System.out.println("                   ");
        System.out.println("                        Specifying * as the redefining field will create a view consisting of the base redefined field and also views for each of ");
        System.out.println("                        redefining fields of that base redefined field");
        System.out.println("                        For e.g.");
        System.out.println("                        REDEFINES_USE=field1:*");
        System.out.println("                        Note the * can be specified for only one redefining field. If multiple redefines are present, the others will all default to ");
        System.out.println("                        base redefined field unless specified otherwise");
        System.out.println("                        01 L1.");
        System.out.println("                            05 A.");
        System.out.println("                            05 B.");
        System.out.println("                            05 B1 redefines B.");
        System.out.println("                            05 B2 redefines B.");
        System.out.println("                            05 B3 redefines B.");
        System.out.println("                            05 C.");
        System.out.println("                            05 D.");
        System.out.println("                            05 D1 redefines D.");
        System.out.println("                            05 D2 redefines D.");
        System.out.println("                            05 D3 redefines D.");
        System.out.println("                            05 E.");
        System.out.println("                            05 F.");
        System.out.println("                            05 F1 redefines F.");
        System.out.println("                            05 F2 redefines F.");
        System.out.println("                            05 F3 redefines F.");
        System.out.println("                            05 G.");
        System.out.println("     ");
        System.out.println("                        For the above layout consider the following scenarios");
        System.out.println("                            1)REDEFINES_USE=B:B2,F:F3");
        System.out.println("                                View created = V(A,B2,C,D,E,F3,G");
        System.out.println("                            2)REDEFINES_USE=D:*,F:F2");
        System.out.println("                                View/s created = V(A,B2,C,D, E,F2,G");
        System.out.println("                                                 V(A,B2,C,D1,E,F2,G");
        System.out.println("                                                 V(A,B2,C,D2,E,F2,G");
        System.out.println("                                                 V(A,B2,C,D3,E,F2,G");
        System.out.println("                            4)REDEFINES_USE=*   Same as (2) but applies the * to the first redefines within the layout");
        System.out.println("                                View/s created = V(A,B, C,D,E,F,G");
        System.out.println("                                                 V(A,B1,C,D,E,F,G");
        System.out.println("                                                 V(A,B2,C,D,E,F,G");
        System.out.println("                                                 V(A,B3,C,D,E,F,G");
        System.out.println("                              The default behavior when REDEFINES_USE is not specified is REDEFINES_USE=*");
        System.out.println("");
        System.out.println("                   VDB-IDXINFO-idxname=[n, m, ....][n1, m1, ....][Path]");
        System.out.println("                           For each alternate key in a VDB output, an attrib 'VDB-IDXINFO-idxname' is created,");
        System.out.println("                           where idxname is replaced by the idx name that is specified");
        System.out.println("                           The value contains a combination of offset values[n, m, ....], lengths[n1, m1, ....] and");
        System.out.println("                            AIX Path Name [Path]");
        System.out.println("");
        System.out.println("     myfile.prof - Profile file for transformation");
        System.out.println("");
    }

    private static void setupTranslateTables() {
        String transformFileCharsetHexMap = "000102030405060708090A0B0C0D0E0F101112131415161718191A1B1C1D1E1F202122232425262728292A2B2C2D2E2F303132333435363738393A3B3C3D3E3F404142434445464748494A4B4C4D4E4F505152535455565758595A5B5C5D5E5F606162636465666768696A6B6C6D6E6F707172737475767778797A7B7C7D7E7F808182838485868788898A8B8C8D8E8F909192939495969798999A9B9C9D9E9FA0A1A2A3A4A5A6A7A8A9AAABACADAEAFB0B1B2B3B4B5B6B7B8B9BABBBCBDBEBFC0C1C2C3C4C5C6C7C8C9CACBCCCDCECFD0D1D2D3D4D5D6D7D8D9DADBDCDDDEDFE0E1E2E3E4E5E6E7E8E9EAEBECEDEEEFF0F1F2F3F4F5F6F7F8F9FAFBFCFDFEFF";
        String loadFileCharsetHexMap = "";
        String inCharset = loadFileCharset;
        boolean isInEBCIDIC = ebcidicCodeSets.contains(" " + inCharset.toUpperCase().replaceFirst("(IBM-)|(IBM)|(CP)", "") + ",");
        inCharset = isInEBCIDIC ? String.format("%05d", Integer.parseInt(inCharset.replaceAll("[^\\d.]", ""))) : inCharset.toUpperCase();
        String outCharset = transformFileCharset;
        boolean isOutEBCIDIC = ebcidicCodeSets.contains(" " + outCharset.toUpperCase().replaceFirst("(IBM-)|(IBM)|(CP)", "") + ",");
        outCharset = isOutEBCIDIC ? String.format("%05d", Integer.parseInt(outCharset.replaceAll("[^\\d.]", ""))) : outCharset.toUpperCase();
        try {
            String line = null;
            ArrayList<String> blockInfoBuild = new ArrayList<String>(10);
            StringBuilder loadFileSB = new StringBuilder(256);
            if (blockMaster.size() == 0) {
                InputStream in = Transform.class.getResourceAsStream("codepageconversions.txt");
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(in));
                while (true) {
                    if ((line = bufferedReader.readLine()) == null || line.startsWith("UCS-4")) {
                        if (blockInfoBuild.size() > 0) {
                            blockMaster.add(blockInfoBuild);
                            blockInfoBuild = new ArrayList(10);
                        }
                        if (line == null) {
                            break;
                        }
                    } else if (line.startsWith("#")) continue;
                    blockInfoBuild.add(line.trim());
                }
                bufferedReader.close();
            }
            for (int i = 0; i < 512; i += 2) {
                if (isOutEBCIDIC != isInEBCIDIC && i == 510 && transformFileCharsetHexMap.substring(i, i + 2).equals("FF")) {
                    loadFileSB.append("FF");
                    continue;
                }
                String scan = (isOutEBCIDIC ? "EBCDIC " : "ASCII ") + transformFileCharsetHexMap.substring(i, i + 2) + ":";
                ArrayList<String> blockAllMatch = null;
                ArrayList<String> blockExactMatch = null;
                for (ArrayList<String> blockInfo : blockMaster) {
                    for (String blockStr : blockInfo) {
                        if (!blockStr.startsWith(scan)) continue;
                        if (blockStr.contains(isOutEBCIDIC ? ": all EBCDIC" : ": all ASCII")) {
                            blockAllMatch = blockInfo;
                            break;
                        }
                        if (!blockStr.contains(outCharset + " ") && !blockStr.endsWith(outCharset)) continue;
                        blockExactMatch = blockInfo;
                        break;
                    }
                    if (blockExactMatch == null) continue;
                    break;
                }
                if (blockExactMatch == null && blockAllMatch == null) {
                    Transform.writeOut("[ERROR] Codepage match not found:\nOutput Charset:" + outCharset + "\nchar: 0x" + transformFileCharsetHexMap.substring(i, i + 2));
                    Transform.exitOut(0);
                }
                if (blockExactMatch == null) {
                    blockExactMatch = blockAllMatch;
                }
                scan = isInEBCIDIC ? "EBCDIC " : "ASCII ";
                boolean matchAll = false;
                boolean matchExact = false;
                String loadCharsetHex = "";
                for (String blockStr : blockExactMatch) {
                    if (!blockStr.startsWith(scan) || !blockStr.contains(isInEBCIDIC ? ": all EBCDIC" : ": all ASCII") && !blockStr.contains(inCharset + " ") && !blockStr.endsWith(inCharset)) continue;
                    String[] blockVals = blockStr.split(" |:");
                    if (blockVals.length < 3) {
                        Transform.writeOut("[ERROR] Output Data extraction Error\nInput Charset:" + inCharset + "\nchar: 0x" + transformFileCharsetHexMap.substring(i, i + 2) + "\nOutput Charset:" + outCharset);
                        Transform.exitOut(0);
                        continue;
                    }
                    if (blockStr.contains(isInEBCIDIC ? ": all EBCDIC" : ": all ASCII")) {
                        matchAll = true;
                        if (!loadCharsetHex.isEmpty()) continue;
                        loadCharsetHex = blockVals[1];
                        continue;
                    }
                    matchExact = true;
                    loadCharsetHex = blockVals[1];
                    break;
                }
                if (!matchAll && !matchExact) {
                    Transform.writeOut("[ERROR] No match for data conversion\nInput Charset:" + inCharset + "\nchar: 0x" + transformFileCharsetHexMap.substring(i, i + 2) + "\nOutput Charset:" + outCharset);
                    Transform.exitOut(0);
                }
                loadFileSB.append(loadCharsetHex);
            }
            loadFileCharsetHexMap = loadFileSB.toString();
        }
        catch (IOException e) {
            e.printStackTrace();
            Transform.exitOut(0);
        }
        TreeMap<Integer, Integer> input2outputCharsetIntMap = new TreeMap<Integer, Integer>();
        for (int i = 0; i < transformFileCharsetHexMap.length(); i += 2) {
            int inputCharsetIntVal = Integer.decode("0x" + loadFileCharsetHexMap.substring(i, i + 2));
            int ouputCharsetIntVal = Integer.decode("0x" + transformFileCharsetHexMap.substring(i, i + 2));
            input2outputCharsetIntMap.put(inputCharsetIntVal, ouputCharsetIntVal);
        }
        int j = 0;
        for (Map.Entry i : input2outputCharsetIntMap.entrySet()) {
            if ((Integer)i.getKey() != j) {
                ++j;
            }
            Transform.input2outputByteMap[j] = (byte)((Integer)i.getValue()).intValue();
            ++j;
        }
    }

    static void validatePrimaryOffsets() {
        if (outPrimaryOffsets.charAt(0) != '[' || outPrimaryOffsets.charAt(outPrimaryOffsets.length() - 1) != ']') {
            Transform.writeOut("[ERROR] Param OUTFILE-PRIMARY-OFFSETS format Error:" + outPrimaryOffsets);
            Transform.writeOut("OUTFILE-PRIMARY-OFFSETS:[n, m, ....] (primary key offsets)");
            Transform.exitOut(0);
        }
        outPrimaryOffsets = outPrimaryOffsets.substring(1, outPrimaryOffsets.length() - 1);
        String[] vals = outPrimaryOffsets.split(",\\s*");
        _outPrimaryOffsets = new Integer[vals.length];
        try {
            for (int i = 0; i < _outPrimaryOffsets.length; ++i) {
                Transform._outPrimaryOffsets[i] = Integer.parseInt(vals[i]);
            }
        }
        catch (NumberFormatException err) {
            Transform.writeOut("[ERROR] Param OUTFILE-PRIMARY-OFFSETS format Error:" + outPrimaryOffsets);
            Transform.writeOut("OUTFILE-PRIMARY-OFFSETS:[n, m, ....] (primary key offsets)");
            err.printStackTrace();
            Transform.exitOut(0);
        }
    }

    static void validatePrimaryTypes() {
        if (outPrimaryTypes.charAt(0) != '[' || outPrimaryTypes.charAt(outPrimaryTypes.length() - 1) != ']') {
            Transform.writeOut("[ERROR] Param OUTFILE-PRIMARY-TYPES format Error:" + outPrimaryTypes);
            Transform.writeOut("OUTFILE-PRIMARY-TYPES:[n, m, ....] (primary key offsets)");
            Transform.exitOut(0);
        }
        outPrimaryTypes = outPrimaryTypes.substring(1, outPrimaryTypes.length() - 1);
        _outPrimaryTypes = outPrimaryTypes.split(",\\s*");
    }

    static void validateAltTypes() {
        if (outAltTypes.charAt(0) != '[' || outAltTypes.charAt(outAltTypes.length() - 1) != ']') {
            Transform.writeOut("[ERROR] Param OUTFILE-ALT-TYPES format Error:" + outPrimaryTypes);
            Transform.writeOut("OUTFILE-ALT-TYPES:[n, m, ....] (primary key offsets)");
            Transform.exitOut(0);
        }
        outAltTypes = outAltTypes.substring(1, outAltTypes.length() - 1);
        _outAltTypes = outAltTypes.split(",\\s*");
    }

    static void validateConvertCount() {
        try {
            recFrom = Integer.parseInt(convert);
        }
        catch (NumberFormatException err) {
            Transform.writeOut("[ERROR] Param CONVERTCOUNT Error:" + convert);
            Transform.writeOut("CONVERTCOUNT:n   (n is the number of records to be converted)");
            err.printStackTrace();
            Transform.exitOut(0);
        }
    }

    static void validateConvertRange() {
        String[] nums = convertRange.split("-");
        if (nums.length != 2) {
            Transform.writeOut("[ERROR] Param CONVERTRANGE Error:" + convertRange);
            Transform.writeOut("CONVERTRANGE:n-m (n-m is the range of records to be converted)");
            Transform.exitOut(0);
        }
        try {
            recFrom = Integer.parseInt(nums[0].trim());
            recTo = Integer.parseInt(nums[1].trim());
        }
        catch (NumberFormatException err) {
            Transform.writeOut("[ERROR] Param CONVERTRANGE Error:" + convertRange);
            err.printStackTrace();
            Transform.writeOut("CONVERTRANGE:n-m (n-m is the range of records to be converted)");
            Transform.exitOut(0);
        }
    }

    static void validateOrient() {
        if (!((outOrient = outOrient.trim().toUpperCase()).equals("INDEXED") || outOrient.equals("NONINDEXED") || outOrient.equals("LINEAR") || outOrient.equals("NUMBERED") || outOrient.equals("LINESEQUENTIAL"))) {
            Transform.writeOut("[ERROR] Param OUTFILE-ORIENT Error:" + outOrient);
            Transform.writeOut("OUTFILE-ORIENT:INDEXED|NONINDEXED|LINEAR|NUMBERED|LINESEQUENTIAL   (file orientation)");
            Transform.exitOut(0);
        }
    }

    static void validateFormat() {
        if (!((outFormat = outFormat.trim().toUpperCase()).equals("F") || outFormat.equals("V") || outFormat.equals("U") || outFormat.equals("FB") || outFormat.equals("VB") || outFormat.equals("FBS") || outFormat.equals("VBS") || outFormat.equals("FBA") || outFormat.equals("VBA"))) {
            Transform.writeOut("[ERROR] Param OUTFILE-FORMAT Error:" + outFormat);
            Transform.writeOut("OUTFILE-FORMAT:F|V|U|FB|VB|FBS|VBS|FBA|VBA      (file format) ");
            Transform.exitOut(0);
        }
    }

    static void validatePrimaryLengths() {
        if (outPrimaryLengths.charAt(0) != '[' || outPrimaryLengths.charAt(outPrimaryLengths.length() - 1) != ']') {
            Transform.writeOut("[ERROR] Param OUTFILE-PRIMARY-LENGTHS format Error:" + outPrimaryLengths);
            Transform.writeOut("OUTFILE-PRIMARY-LENGTHS:[n, m, ....] (primary key lengths)");
            Transform.exitOut(0);
        }
        outPrimaryLengths = outPrimaryLengths.substring(1, outPrimaryLengths.length() - 1);
        String[] vals = outPrimaryLengths.split(",\\s*");
        _outPrimaryLengths = new Integer[vals.length];
        try {
            for (int i = 0; i < _outPrimaryLengths.length; ++i) {
                Transform._outPrimaryLengths[i] = Integer.parseInt(vals[i]);
            }
        }
        catch (NumberFormatException err) {
            Transform.writeOut("[ERROR] Param OUTFILE-PRIMARY-LENGTHS format Error:" + outPrimaryLengths);
            Transform.writeOut("OUTFILE-PRIMARY-LENGTHS:[n, m, ....] (primary key lengths)");
            err.printStackTrace();
            Transform.exitOut(0);
        }
    }

    static void validateRelKeyLength() {
        _outRelKeyLength = new Integer[1];
        try {
            Transform._outRelKeyLength[0] = Integer.parseInt(outRelKeyLength);
        }
        catch (NumberFormatException err) {
            Transform.writeOut("[ERROR] Param OUTFILE-RELKEY-LENGTH format Error:" + outRelKeyLength);
            Transform.writeOut("OUTFILE-RELKEY-LENGTH:n              (relative key length)");
            err.printStackTrace();
            Transform.exitOut(0);
        }
    }

    static void validateAltKeyOffsets() {
        if (outAltOffsets.charAt(0) != '[' || outAltOffsets.charAt(outAltOffsets.length() - 1) != ']') {
            Transform.writeOut("[ERROR] Param OUTFILE-ALTKEY-OFFSETS format Error:" + outAltOffsets);
            Transform.writeOut("OUTFILE-ALTKEY-OFFSETS:[n, m, ....] (alternate key offsets)");
            Transform.exitOut(0);
        }
        outAltOffsets = outAltOffsets.substring(1, outAltOffsets.length() - 1);
        String[] vals = outAltOffsets.split(",\\s*");
        _outAltOffsets = new Integer[vals.length];
        try {
            for (int i = 0; i < _outAltOffsets.length; ++i) {
                Transform._outAltOffsets[i] = Integer.parseInt(vals[i]);
            }
        }
        catch (NumberFormatException err) {
            Transform.writeOut("[ERROR] Param OUTFILE-ALTKEY-OFFSETS format Error:" + outAltOffsets);
            Transform.writeOut("OUTFILE-ALTKEY-OFFSETS:[n, m, ....] (alternate key offsets)");
            err.printStackTrace();
            Transform.exitOut(0);
        }
    }

    static void validateAltKeyLengths() {
        if (outAltLengths.charAt(0) != '[' || outAltLengths.charAt(outAltLengths.length() - 1) != ']') {
            Transform.writeOut("[ERROR] Param OUTFILE-ALTKEY-LENGTHS format Error:" + outAltLengths);
            Transform.writeOut("OUTFILE-ALTKEY-LENGTHS:[n, m, ....] (alternate key lengths)");
            Transform.exitOut(0);
        }
        outAltLengths = outAltLengths.substring(1, outAltLengths.length() - 1);
        String[] vals = outAltLengths.split(",\\s*");
        _outAltLengths = new Integer[vals.length];
        try {
            for (int i = 0; i < _outAltLengths.length; ++i) {
                Transform._outAltLengths[i] = Integer.parseInt(vals[i]);
            }
        }
        catch (NumberFormatException err) {
            Transform.writeOut("[ERROR] Param OUTFILE-ALTKEY-LENGTHS format Error:" + outAltLengths);
            Transform.writeOut("OUTFILE-ALTKEY-LENGTHS:[n, m, ....] (alternate key lengths)");
            err.printStackTrace();
            Transform.exitOut(0);
        }
    }

    static void validateAltKeyDups() {
        if (outAltDups.charAt(0) != '[' || outAltDups.charAt(outAltDups.length() - 1) != ']') {
            Transform.writeOut("[ERROR] Param OUTFILE-ALTKEY-DUPS format Error:" + outAltDups);
            Transform.writeOut("OUTFILE-ALTKEY-DUPS:[true, false, ....] (alternate key duplicates allowed)");
            Transform.exitOut(0);
        }
        outAltDups = outAltDups.substring(1, outAltDups.length() - 1);
        String[] vals = outAltDups.split(",\\s*");
        _outAltDups = new Boolean[vals.length];
        for (int i = 0; i < _outAltDups.length; ++i) {
            Transform._outAltDups[i] = Boolean.valueOf(vals[i]);
        }
    }

    static void validateAltKeyGroups() {
        if (outAltGroups.charAt(0) != '[' || outAltGroups.charAt(outAltGroups.length() - 1) != ']') {
            Transform.writeOut("[ERROR] Param OUTFILE-ALTKEY-GROUPS format Error:" + outAltGroups);
            Transform.writeOut("OUTFILE-ALTKEY-GROUPS:[n, m, ....] (alternate key groups)");
            Transform.exitOut(0);
        }
        outAltGroups = outAltGroups.substring(1, outAltGroups.length() - 1);
        String[] vals = outAltGroups.split(",\\s*");
        _outAltGroups = new Integer[vals.length];
        try {
            for (int i = 0; i < _outAltGroups.length; ++i) {
                Transform._outAltGroups[i] = Integer.parseInt(vals[i]);
            }
        }
        catch (NumberFormatException err) {
            Transform.writeOut("[ERROR] Param OUTFILE-ALTKEY-GROUPS format Error:" + outAltGroups);
            Transform.writeOut("OUTFILE-ALTKEY-GROUPS:[n, m, ....] (alternate key groups)");
            err.printStackTrace();
            Transform.exitOut(0);
        }
    }

    static void validateRecMin() {
        try {
            recMin = Integer.parseInt(outRecMin);
        }
        catch (NumberFormatException err) {
            Transform.writeOut("[ERROR] Param OUTFILE-REC-MINIMUM Error:" + outRecMin);
            Transform.writeOut("OUTFILE-REC-MINIMUM:n    (record minimum length)");
            err.printStackTrace();
            Transform.exitOut(0);
        }
    }

    static void validateRecMax() {
        try {
            recMax = Integer.parseInt(outRecMax);
        }
        catch (NumberFormatException err) {
            Transform.writeOut("[ERROR] Param OUTFILE-REC-MAXIMUM Error:" + outRecMax);
            Transform.writeOut("OUTFILE-REC-MAXIMUM:n    (record maximum length)");
            err.printStackTrace();
            Transform.exitOut(0);
        }
    }

    static void validateRecAvg() {
        try {
            recAvg = Integer.parseInt(outRecAvg);
        }
        catch (NumberFormatException err) {
            Transform.writeOut("[ERROR] Param OUTFILE-REC-AVG Error:" + outRecAvg);
            Transform.writeOut("OUTFILE-REC-AVG:n    (record average length)");
            err.printStackTrace();
            Transform.exitOut(0);
        }
    }

    static void validateProtocol() {
        if (!((outProtocol = outProtocol.trim().toUpperCase()).isEmpty() || outProtocol.equals("EC") || outProtocol.equals("MF") || outProtocol.equals("MF3") || outProtocol.equals("MF8") || outProtocol.equals("CISAM") || outProtocol.equals("DISAM") || outProtocol.equals("EISAM") || outProtocol.equals("AS400") || outProtocol.equals("ACU") || outProtocol.equals("IBM") || outProtocol.equals("IBMV") || outProtocol.equals("IBMVB") || outProtocol.equals("SYNC") || outProtocol.equals("VSQL") || outProtocol.equals("VDB"))) {
            Transform.writeOut("[ERROR] Param OUTFILE-PROTOCOL Error:" + outProtocol);
            Transform.writeOut("OUTFILE-PROTOCOL:EC|MF|MF3|MF8|CISAM|DISAM|EISAM|AS400|ACU|IBM|IBMV|IBMVB|SYNC|VSQL|VDB  (file protocol)");
            Transform.exitOut(0);
        }
    }

    static void validateCharset() {
        outCharset = outCharset.trim().toUpperCase();
        try {
            new String(new byte[]{66, 67, 68, 69, 70, 49, 50, 51, 52}, outCharset);
        }
        catch (UnsupportedEncodingException e1) {
            Transform.writeOut("[ERROR] UnsupportedEncodingException Exception: " + e1.getMessage() + "\n Java does not support the charset/codepage.");
            Transform.exitOut(0);
        }
    }

    static void setKeyValues(String key, String val) {
        String caseKey = key;
        if ((key = key.toUpperCase()).equals("PROF-VERSION")) {
            return;
        }
        if (key.endsWith(".USER")) {
            if (sqluser.isEmpty()) {
                sqluser = val;
                System.setProperty(caseKey, val);
            }
        } else if (key.endsWith(".PASSWORD")) {
            if (sqlpasswd.isEmpty()) {
                sqlpasswd = val;
                System.setProperty(caseKey, val);
            }
        } else if (key.endsWith(".URL")) {
            if (sqlurl.isEmpty()) {
                sqlurl = val;
                System.setProperty(caseKey, val);
            }
        } else if (key.endsWith(".DRIVER")) {
            if (sqldriver.isEmpty()) {
                sqldriver = val;
                System.setProperty(caseKey, val);
            }
        } else if (key.endsWith(".AUTOCOMMIT")) {
            if (sqlautocommit.isEmpty()) {
                if (val.isEmpty()) {
                    val = "FALSE";
                }
                sqlautocommit = val;
                System.setProperty(caseKey, val);
            }
        } else if (key.endsWith(".ISOLATION")) {
            if (sqlisolation.isEmpty()) {
                if (val.isEmpty()) {
                    val = "repeatable";
                }
                sqlisolation = val;
                System.setProperty(caseKey, val);
            }
        } else if (key.endsWith(".CATALOG")) {
            if (sqlcatalog.isEmpty()) {
                sqlcatalog = val;
                System.setProperty(caseKey, val);
            }
        } else if (key.endsWith(".READONLY")) {
            if (sqlreadonly.isEmpty()) {
                if (val.isEmpty()) {
                    val = "FALSE";
                }
                sqlreadonly = val;
                System.setProperty(caseKey, val);
            }
        } else if (key.endsWith(".USEBATCHINSERT")) {
            if (IS_BATCH_INSERT_MODE.isEmpty()) {
                if (val.isEmpty()) {
                    val = "FALSE";
                }
                IS_BATCH_INSERT_MODE = val;
                System.setProperty("sql.file.useBatchInsert", val);
            }
        } else if (key.endsWith(".USEBATCHINSERT.BATCHSIZE")) {
            if (BATCH_INSERT_SIZE.isEmpty()) {
                if (val.isEmpty()) {
                    val = "100000";
                }
                BATCH_INSERT_SIZE = val;
                System.setProperty("sql.file.useBatchInsert.batchSize", val);
            }
        } else if (key.endsWith("USEEBCDICBINARYCOLUMN")) {
            System.setProperty(caseKey, val);
        } else if (key.equals("OUTFILE-PRIMARY-TYPES")) {
            if (outPrimaryTypes.isEmpty()) {
                outPrimaryTypes = val;
                Transform.validatePrimaryTypes();
                System.setProperty(caseKey, val);
            }
        } else if (key.equals("OUTFILE-ALTKEY-TYPES")) {
            if (outAltTypes.isEmpty()) {
                outAltTypes = val;
                Transform.validateAltTypes();
                System.setProperty(caseKey, val);
            }
        } else if (key.equals("DCBDB-MODE")) {
            if (dcbDBMode.isEmpty()) {
                dcbDBMode = val;
                isDCBDB = dcbDBMode.equalsIgnoreCase("true");
            }
        } else if (key.equals("DCBDB-DRIVER")) {
            if (dcbDBDriver.isEmpty()) {
                dcbDBDriver = val;
            }
        } else if (key.equals("DCBDB-DRIVER-JAR")) {
            if (dcbDBDriverJar.isEmpty()) {
                dcbDBDriverJar = val;
            }
        } else if (key.equals("DCBDB-URL")) {
            if (dcbDBUrl.isEmpty()) {
                dcbDBUrl = val;
            }
        } else if (key.equals("DCBDB-USER")) {
            if (dcbDBUser.isEmpty()) {
                dcbDBUser = val;
            }
        } else if (key.equals("DCBDB-PASS")) {
            if (dcbDBPass.isEmpty()) {
                dcbDBPass = val;
            }
        } else if (key.equals("DCBDB-TBLEXT")) {
            if (dcbDBTblExt.isEmpty()) {
                dcbDBTblExt = val;
            }
        } else if (key.equals("INFILE-DSNPATH")) {
            if (inDsnPath.isEmpty()) {
                if (val.startsWith("VDB:")) {
                    inDsnPath = val;
                    inDsnName = val.substring(4);
                } else {
                    File ifile = new File(val);
                    if (ifile.isAbsolute()) {
                        inDsnPath = val;
                    } else {
                        File resFile = new File(profDirLoc, val);
                        try {
                            inDsnPath = resFile.getCanonicalPath();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                            Transform.exitOut(0);
                        }
                    }
                    inDsnName = inDsnPath.substring(inDsnPath.lastIndexOf(File.separatorChar) + 1).toUpperCase();
                }
            }
        } else if (key.equals("CONVERTCOUNT")) {
            if (convert.isEmpty()) {
                convert = val;
                Transform.validateConvertCount();
            }
        } else if (key.equals("CONVERTRANGE")) {
            if (convertRange.isEmpty()) {
                convertRange = val;
                Transform.validateConvertRange();
            }
        } else if (key.equals("OUTFILE-DSNPATH")) {
            if (outDsnPath.isEmpty()) {
                if (val.startsWith("VDB:")) {
                    outDsnPath = val;
                    outDsnName = val.substring(4);
                } else {
                    File ifile = new File(val);
                    if (ifile.isAbsolute()) {
                        outDsnPath = val;
                    } else {
                        File resFile = new File(profDirLoc, val);
                        try {
                            outDsnPath = resFile.getCanonicalPath();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                            Transform.exitOut(0);
                        }
                    }
                    outDsnName = outDsnPath.substring(outDsnPath.lastIndexOf(File.separatorChar) + 1).toUpperCase();
                }
            }
        } else if (key.equals("OUTFILE-ORIENT")) {
            if (outOrient.isEmpty()) {
                outOrient = val;
                Transform.validateOrient();
            }
        } else if (key.equals("OUTFILE-FORMAT")) {
            if (outFormat.isEmpty()) {
                outFormat = val;
                Transform.validateFormat();
            }
        } else if (key.equals("OUTFILE-PRIMARY-OFFSETS")) {
            if (outPrimaryOffsets.isEmpty()) {
                outPrimaryOffsets = val;
                Transform.validatePrimaryOffsets();
            }
        } else if (key.equals("OUTFILE-PRIMARY-LENGTHS")) {
            if (outPrimaryLengths.isEmpty()) {
                outPrimaryLengths = val;
                Transform.validatePrimaryLengths();
            }
        } else if (key.equals("OUTFILE-RELKEY-LENGTH")) {
            if (outRelKeyLength.isEmpty()) {
                outRelKeyLength = val;
                Transform.validateRelKeyLength();
            }
        } else if (key.equals("OUTFILE-ALTKEY-OFFSETS")) {
            if (outAltOffsets.isEmpty()) {
                outAltOffsets = val;
                Transform.validateAltKeyOffsets();
            }
        } else if (key.equals("OUTFILE-ALTKEY-LENGTHS")) {
            if (outAltLengths.isEmpty()) {
                outAltLengths = val;
                Transform.validateAltKeyLengths();
            }
        } else if (key.equals("OUTFILE-ALTKEY-DUPS")) {
            if (outAltDups.isEmpty()) {
                outAltDups = val;
                Transform.validateAltKeyDups();
            }
        } else if (key.equals("OUTFILE-ALTKEY-GROUPS")) {
            if (outAltGroups.isEmpty()) {
                outAltGroups = val;
                Transform.validateAltKeyGroups();
            }
        } else if (key.equals("OUTFILE-REC-MINIMUM")) {
            if (outRecMin.isEmpty()) {
                outRecMin = val;
                Transform.validateRecMin();
            }
        } else if (key.equals("OUTFILE-REC-MAXIMUM")) {
            if (outRecMax.isEmpty()) {
                outRecMax = val;
                Transform.validateRecMax();
            }
        } else if (key.equals("OUTFILE-REC-AVG")) {
            if (outRecAvg.isEmpty()) {
                outRecAvg = val;
                Transform.validateRecAvg();
            }
        } else if (key.equals("OUTFILE-PROTOCOL")) {
            if (outProtocol.isEmpty()) {
                outProtocol = val;
                Transform.validateProtocol();
            }
        } else if (key.equals("OUTFILE-CHARSET")) {
            if (outCharset.isEmpty()) {
                outCharset = val;
                Transform.validateCharset();
            }
        } else if (key.equals("OUTFILE-APPEND")) {
            if (outAppend.isEmpty()) {
                outAppend = val;
            }
        } else if (key.startsWith("VDB-IDXINFO-")) {
            String idxName = key.substring(12);
            if (!outVDBIdxInfo.containsKey(idxName)) {
                String[] numGroups = val.split("\\]\\s*\\[");
                if (numGroups.length < 2 || numGroups.length > 3) {
                    Transform.writeOut("[ERROR] Params Error:" + val);
                    Transform.writeOut("   VDB-IDXINFO-idxname:[n, m, ....][n1, m1, ....][Path]");
                    Transform.exitOut(0);
                }
                numGroups[0] = numGroups[0].substring(1);
                String[] offVals = numGroups[0].split(",\\s*");
                Integer[] offs = new Integer[offVals.length];
                String path = "";
                if (numGroups.length == 2) {
                    numGroups[1] = numGroups[1].substring(0, numGroups[1].length() - 1);
                } else if (!numGroups[2].isEmpty()) {
                    path = numGroups[2].substring(0, numGroups[2].length() - 1);
                }
                String[] lenVals = numGroups[1].split(",\\s*");
                Integer[] lens = new Integer[lenVals.length];
                try {
                    for (int j = 0; j < offVals.length; ++j) {
                        offs[j] = Integer.parseInt(offVals[j]);
                        lens[j] = Integer.parseInt(lenVals[j]);
                    }
                }
                catch (NumberFormatException err) {
                    Transform.writeOut("[ERROR] Params Error:" + val);
                    Transform.writeOut("   VDB-IDXINFO-idxname:[n, m, ....][n1, m1, ....][Path]");
                    Transform.exitOut(0);
                }
                outVDBIdxInfo.put(idxName, new Object[]{offs, lens, path});
            }
        } else if (key.startsWith("XFD")) {
            if (!xfdKeyValArgs.containsKey(key)) {
                xfdKeyValArgs.put(key, val);
            }
        } else if (key.equals("REDEFINES_USE")) {
            if (redefUseMap.isEmpty() && !iterateRedef) {
                String[] vals;
                if (val.equals("*")) {
                    iterateRedef = true;
                    return;
                }
                for (String redefValue : vals = val.toUpperCase().split(",")) {
                    String[] redef = redefValue.split(":");
                    if (redef.length != 2) continue;
                    if (redef[1].equals("*")) {
                        int idx = redef[0].indexOf(46);
                        if (idx == -1) {
                            if (layoutRedefIterMap.containsKey("")) {
                                Transform.writeOut("Warning. Multiple '*' found in REDEFINES_USE. " + redef[0] + ":* will be ignored.");
                                continue;
                            }
                            layoutRedefIterMap.put("", redef[0]);
                            continue;
                        }
                        String skey = redef[0].substring(0, idx);
                        if (layoutRedefIterMap.containsKey(skey)) {
                            Transform.writeOut("Warning. Multiple '*' found in REDEFINES_USE. " + redef[0] + ":* will be ignored.");
                            continue;
                        }
                        layoutRedefIterMap.put(skey, redef[0].substring(idx + 1));
                        continue;
                    }
                    redefUseMap.put(redef[0], redef[1]);
                }
            }
        } else if (key.equals("INCLUDE-LAYOUTS")) {
            if (includedLayouts.isEmpty() && !val.trim().isEmpty()) {
                String[] vals;
                for (String layout : vals = val.toUpperCase().split(",")) {
                    includedLayouts.add(layout);
                }
            }
        } else if (key.equals("EXCLUDE-LAYOUTS")) {
            if (excludedLayouts.isEmpty() && !val.trim().isEmpty()) {
                String[] vals;
                for (String layout : vals = val.toUpperCase().split(",")) {
                    excludedLayouts.add(layout);
                }
            }
        } else if (key.equals("RENAME-LAYOUTS")) {
            if (renamedLayouts.isEmpty() && !val.trim().isEmpty()) {
                String[] vals;
                for (String renames : vals = val.toUpperCase().split(",")) {
                    String[] names = renames.split(":");
                    renamedLayouts.put(names[0], names[1]);
                }
            }
        } else if (key.equals("USE-VARCHAR")) {
            if (useVarchar.isEmpty()) {
                if (val.equalsIgnoreCase("TRUE")) {
                    useVarchar = "TRUE";
                    varChar = true;
                } else {
                    useVarchar = "FALSE";
                    varChar = false;
                }
            }
        } else if (key.equals("MATERIALIZED-VIEW")) {
            if (genMatView.isEmpty()) {
                if (val.equalsIgnoreCase("TRUE")) {
                    genMatView = "TRUE";
                    matView = true;
                } else {
                    genMatView = "FALSE";
                    matView = false;
                }
            }
        } else if (key.equals("LOGFILE")) {
            if (!val.trim().isEmpty()) {
                try {
                    logfile = new PrintWriter(val.trim(), "ISO-8859-1");
                }
                catch (Exception e) {
                    Transform.writeOut("[ERROR] LogFile creation error");
                    Transform.writeOut(e.getMessage());
                    Transform.exitOut(0);
                }
            }
        } else if (key.equals("RFS-VERSION")) {
            if (!val.equals(CURR_RFS_VERSION)) {
                Transform.writeOut("[ERROR] Older version of XFDXml information found in transformation profile");
                Transform.exitOut(0);
            }
        } else if (key.endsWith("-DSORG")) {
            if (in_dsorg == null) {
                in_dsorg = val.trim();
                inDsnName = key.substring(0, key.lastIndexOf(45));
            }
        } else if (key.endsWith("-ORIENT")) {
            if (in_orient == null) {
                in_orient = val.trim();
            }
        } else if (key.endsWith("-RECFM")) {
            if (in_recfm == null) {
                in_recfm = val.trim();
            }
        } else if (key.endsWith("-PROTO")) {
            if (in_proto == null) {
                in_proto = val.trim();
            }
        } else if (key.endsWith("-RECMIN")) {
            if (in_recmin == -1) {
                try {
                    in_recmin = Integer.parseInt(val.trim());
                }
                catch (NumberFormatException err) {
                    Transform.writeOut("[ERROR] Input file DCB parm [recmin] is incorrect:" + val);
                    Transform.exitOut(0);
                }
            }
        } else if (key.endsWith("-RECAVG")) {
            if (in_recavg == -1) {
                try {
                    in_recavg = Integer.parseInt(val.trim());
                }
                catch (NumberFormatException err) {
                    Transform.writeOut("[ERROR] Input file DCB parm [recavg] is incorrect:" + val);
                    Transform.exitOut(0);
                }
            }
        } else if (key.endsWith("-LRECL")) {
            if (in_lrecl == -1) {
                try {
                    in_lrecl = Integer.parseInt(val.trim());
                }
                catch (NumberFormatException err) {
                    Transform.writeOut("[ERROR] Input file DCB parm [lrecl] is incorrect:" + val);
                    Transform.exitOut(0);
                }
            }
        } else if (key.endsWith("-BLKSIZE")) {
            if (in_blksize == -1) {
                try {
                    in_blksize = Integer.parseInt(val.trim());
                }
                catch (NumberFormatException err) {
                    Transform.writeOut("[ERROR] Input file DCB parm [blksize] is incorrect:" + val);
                    Transform.exitOut(0);
                }
            }
        } else if (key.endsWith("-LIMIT")) {
            if (in_limit == -1) {
                try {
                    in_limit = Integer.parseInt(val.trim());
                }
                catch (NumberFormatException err) {
                    Transform.writeOut("[ERROR] Input file DCB parm [limit] is incorrect:" + val);
                    Transform.exitOut(0);
                }
            }
        } else if (key.endsWith("-KEYLEN")) {
            if (in_keylen == null) {
                try {
                    val = val.substring(1, val.length() - 1);
                    String[] valArray = val.split(",\\s*");
                    in_keylen = new Integer[valArray.length];
                    for (int i = 0; i < in_keylen.length; ++i) {
                        Transform.in_keylen[i] = Integer.parseInt(valArray[i]);
                    }
                }
                catch (NumberFormatException err) {
                    Transform.writeOut("[ERROR] Input file DCB parm [keylen] is incorrect:" + val);
                    Transform.exitOut(0);
                }
            }
        } else if (key.endsWith("-KEYOFF")) {
            if (in_keyoff == null) {
                try {
                    val = val.substring(1, val.length() - 1);
                    String[] valArray = val.split(",\\s*");
                    in_keyoff = new Integer[valArray.length];
                    for (int i = 0; i < in_keyoff.length; ++i) {
                        Transform.in_keyoff[i] = Integer.parseInt(valArray[i]);
                    }
                }
                catch (NumberFormatException err) {
                    Transform.writeOut("[ERROR] Input file DCB parm [keyoff] is incorrect:" + val);
                    Transform.exitOut(0);
                }
            }
        } else if (key.endsWith("-ALTKEYOFFS")) {
            if (in_altkeyoffs == null) {
                try {
                    val = val.substring(1, val.length() - 1);
                    String[] valArray = val.split(",\\s*");
                    in_altkeyoffs = new Integer[valArray.length];
                    for (int i = 0; i < in_altkeyoffs.length; ++i) {
                        Transform.in_altkeyoffs[i] = Integer.parseInt(valArray[i]);
                    }
                }
                catch (NumberFormatException err) {
                    Transform.writeOut("[ERROR] Input file DCB parm [altkeyoffs] is incorrect:" + val);
                    Transform.exitOut(0);
                }
            }
        } else if (key.endsWith("-ALTKEYLENS")) {
            if (in_altkeylens == null) {
                try {
                    val = val.substring(1, val.length() - 1);
                    String[] valArray = val.split(",\\s*");
                    in_altkeylens = new Integer[valArray.length];
                    for (int i = 0; i < in_altkeylens.length; ++i) {
                        Transform.in_altkeylens[i] = Integer.parseInt(valArray[i]);
                    }
                }
                catch (NumberFormatException err) {
                    Transform.writeOut("[ERROR] Input file DCB parm [altkeylens] is incorrect:" + val);
                    Transform.exitOut(0);
                }
            }
        } else if (key.endsWith("-ALTKEYDUPS")) {
            if (in_altkeydups == null) {
                try {
                    val = val.substring(1, val.length() - 1);
                    String[] valArray = val.split(",\\s*");
                    in_altkeydups = new Boolean[valArray.length];
                    for (int i = 0; i < in_altkeydups.length; ++i) {
                        Transform.in_altkeydups[i] = valArray[i].trim().toLowerCase().matches("(true|on|1|yes)");
                    }
                }
                catch (NumberFormatException err) {
                    Transform.writeOut("[ERROR] Input file DCB parm [altkeydups] is incorrect:" + val);
                    Transform.exitOut(0);
                }
            }
        } else if (key.endsWith("-ALTKEYGROUPS")) {
            if (in_altkeygroups == null) {
                try {
                    val = val.substring(1, val.length() - 1);
                    String[] valArray = val.split(",\\s*");
                    in_altkeygroups = new Integer[valArray.length];
                    for (int i = 0; i < in_altkeygroups.length; ++i) {
                        Transform.in_altkeygroups[i] = Integer.parseInt(valArray[i]);
                    }
                }
                catch (NumberFormatException err) {
                    Transform.writeOut("[ERROR] Input file DCB parm [altkeygroups] is incorrect:" + val);
                    Transform.exitOut(0);
                }
            }
        } else if (key.endsWith("-LABEL")) {
            if (in_label == -1) {
                try {
                    in_label = Integer.parseInt(val.trim());
                }
                catch (NumberFormatException err) {
                    Transform.writeOut("[ERROR] Input file DCB parm [label] is incorrect:" + val);
                    Transform.exitOut(0);
                }
            }
        } else if (key.endsWith("-EXPDT")) {
            if (in_expdt == null) {
                in_expdt = val.trim();
            }
        } else if (key.endsWith("-REUSE")) {
            if (in_reuse == null) {
                in_reuse = val.trim().toLowerCase().matches("(true|on|1|yes)") ? "TRUE" : "FALSE";
            }
        } else if (key.endsWith("-RELATE")) {
            if (in_relate == null) {
                in_relate = val.trim();
            }
        } else if (key.endsWith("-ASSOCIATES")) {
            if (in_associates == null) {
                try {
                    val = val.substring(1, val.length() - 1);
                    String[] valArray = val.split(",\\s*");
                    in_associates = new String[valArray.length];
                    for (int i = 0; i < in_associates.length; ++i) {
                        Transform.in_associates[i] = valArray[i];
                    }
                }
                catch (NumberFormatException err) {
                    Transform.writeOut("[ERROR] Input file DCB parm [associates] is incorrect:" + val);
                    Transform.exitOut(0);
                }
            }
        } else if (key.endsWith("-CHARSET")) {
            if (in_charset == null) {
                in_charset = val.trim();
            }
        } else if (key.endsWith("-PATH")) {
            if (in_path == null) {
                in_path = val.trim();
            }
        } else {
            Transform.writeOut("[ERROR] Unknown param :" + key + "=" + val);
        }
    }

    public static void main(String[] args) {
        block77: {
            String licenseCheckResult;
            boolean isCalledFromEclipse = Arrays.stream(args).anyMatch("eclipsefore"::equals);
            if (!HCILicensing.isJDKSupported() && isCalledFromEclipse) {
                System.out.println("Java version " + System.getProperty("java.specification.version") + " is not supported. This plugin currently supports Java version " + HCILicensing.LAST_SUPPORTED_JDK_VERSION + " only!");
                Transform.exitOut(0);
            }
            if ((licenseCheckResult = HCILicensing.LicenseCheck("hpaas-dmt-sdk", 1, false)).compareTo("") != 0) {
                System.err.println("[ERROR] Elastic COBOL Runtime Error: " + licenseCheckResult);
                Transform.exitOut(0);
            }
            if (args == null || args.length == 0) {
                args = new String[]{"help"};
            }
            String arg = null;
            for (int i = 0; i < args.length; ++i) {
                arg = args[i];
                if (arg.trim().isEmpty()) continue;
                if (arg.equalsIgnoreCase("help") || arg.equalsIgnoreCase("?")) {
                    Transform.help();
                    Transform.exitOut(0);
                    continue;
                }
                if (arg.equalsIgnoreCase("eclipsefore")) {
                    eclipseForeMode = true;
                    continue;
                }
                if (arg.equalsIgnoreCase("quietmode")) {
                    quietMode = true;
                    continue;
                }
                if (arg.equalsIgnoreCase("warnxfdcharset")) {
                    warnxfdcharset = true;
                    continue;
                }
                if (arg.equalsIgnoreCase("badrecordexit")) {
                    badrecordexit = true;
                    continue;
                }
                if (arg.equalsIgnoreCase("norecvalidate")) {
                    norecvalidate = true;
                    continue;
                }
                if (arg.endsWith(".prof")) {
                    profFileLoc = arg;
                    continue;
                }
                String[] keyval = arg.split("=", 2);
                if (keyval.length != 2) {
                    Transform.writeOut("[ERROR] Parameter Error:" + arg);
                    Transform.exitOut(0);
                }
                Transform.setKeyValues(keyval[0], keyval[1].trim());
            }
            if (!profFileLoc.isEmpty()) {
                try {
                    Properties profProp = new Properties();
                    FileInputStream inStream = null;
                    File profFile = new File(profFileLoc);
                    inStream = new FileInputStream(profFile);
                    if (inStream == null) break block77;
                    String abspath = profFile.getAbsolutePath();
                    profDirLoc = abspath.substring(0, abspath.lastIndexOf(File.separatorChar));
                    profProp.load(inStream);
                    String version = profProp.getProperty("PROF-VERSION");
                    if (version == null || !version.equals(CURR_PROF_VERSION)) {
                        Transform.writeOut("[ERROR] Invalid version profile file:" + version);
                        ((InputStream)inStream).close();
                        Transform.exitOut(0);
                        return;
                    }
                    for (Map.Entry<Object, Object> keyval : profProp.entrySet()) {
                        Transform.setKeyValues((String)keyval.getKey(), (String)keyval.getValue());
                    }
                    ((InputStream)inStream).close();
                    if (isDCBDB) {
                        if (dcbDBDriver.isEmpty() || dcbDBUrl.isEmpty() || dcbDBUser.isEmpty()) {
                            Transform.writeOut("[ERROR] Transform's using Table DCB has the following parameters:");
                            Transform.writeOut("Required Parameters:\nDCBDB-DRIVER\nDCBDB-URL\nDCBDB-USER\nOptional Parameters:\n   DCBDB-PASS\nDCBDB-TBLEXT");
                            Transform.exitOut(0);
                        } else {
                            System.setProperty("dcb.mode.db", "true");
                            System.setProperty("dcb.db.driver", dcbDBDriver);
                            System.setProperty("dcb.db.url", dcbDBUrl);
                            System.setProperty("dcb.db.user", dcbDBUser);
                            System.setProperty("dcb.db.pass", dcbDBPass);
                            System.setProperty("dcb.db.table", dcbDBTblExt);
                        }
                    }
                    loadFileCharset = "";
                    if (in_dsorg == null) {
                        String[] segs = inDsnPath.split("\\" + File.separatorChar);
                        String dName = "";
                        boolean dcbFound = false;
                        for (int idx = segs.length - 1; idx >= 0; --idx) {
                            if (!DCB.exists((dName = dName.isEmpty() ? segs[idx] : segs[idx] + "." + dName).toUpperCase(), inDsnPath)) continue;
                            inDsnName = dName.toUpperCase();
                            dcbFound = true;
                            break;
                        }
                        if (!dcbFound) {
                            Transform.writeOut("[ERROR] Input file DCB entry not found for dsnPath: " + inDsnPath);
                            Transform.exitOut(0);
                        }
                        if ((inDcb = DCBFactory.getInstance(inDsnName, inDsnPath, true)) == null) {
                            Transform.writeOut("[ERROR] DCB not found for " + inDsnName.toUpperCase() + " in " + inDsnPath);
                            Transform.exitOut(0);
                        }
                    } else {
                        DCBFactory.setModeDcbDB(false);
                        inDcb = new DCB(inDsnName, inDsnPath);
                        try {
                            inDcb.setOrganization(in_dsorg);
                            if (in_orient != null) {
                                inDcb.setOrientation(in_orient);
                            }
                            if (in_recfm != null) {
                                inDcb.setRecordFormat(in_recfm);
                            }
                            if (in_proto != null) {
                                inDcb.setProtocol(in_proto);
                            }
                            if (in_recmin != -1) {
                                inDcb.setRecordMinimum(in_recmin);
                            }
                            if (in_recavg != -1) {
                                inDcb.setRecordAverage(in_recavg);
                            }
                            if (in_lrecl != -1) {
                                inDcb.setLrecl(in_lrecl);
                            }
                            if (in_blksize != -1) {
                                inDcb.setBlksize(in_blksize);
                            }
                            if (in_limit != -1) {
                                inDcb.setLimit(in_limit);
                            }
                            if (in_keyoff != null) {
                                inDcb.setKeyOffset(in_keyoff);
                            }
                            if (in_keylen != null) {
                                inDcb.setKeyLength(in_keylen);
                            }
                            if (in_altkeyoffs != null) {
                                inDcb.setAltKeyOffsets(in_altkeyoffs);
                            }
                            if (in_altkeylens != null) {
                                inDcb.setAltKeyLengths(in_altkeylens);
                            }
                            if (in_altkeydups != null) {
                                inDcb.setAltKeyDuplicates(in_altkeydups);
                            }
                            if (in_altkeygroups != null) {
                                inDcb.setAltKeyGroups(in_altkeygroups);
                            }
                            if (in_label != -1) {
                                inDcb.setLabel(in_label);
                            }
                            if (in_expdt != null) {
                                inDcb.setExpdt(in_expdt);
                            }
                            if (in_reuse != null) {
                                inDcb.setReuse(in_reuse.toLowerCase().matches("(true|on|1|yes)"));
                            }
                            if (in_relate != null) {
                                inDcb.setRelate(in_relate);
                            }
                            if (in_associates != null) {
                                inDcb.setAssociates(in_associates);
                            }
                            if (in_charset != null) {
                                inDcb.setCharset(in_charset);
                            }
                            if (in_path != null) {
                                inDcb.setPath(in_path);
                            }
                        }
                        catch (DCB.InvalidDCBException e) {
                            Transform.writeOut("[ERROR] Error setting input DCB");
                            e.printStackTrace();
                            Transform.exitOut(0);
                        }
                    }
                    inDcb.unlockDCB();
                    inDcbLrecl = inDcb.getLrecl();
                    loadFileCharset = inDcb.getCharset();
                    if (loadFileCharset == null || loadFileCharset.trim().isEmpty()) {
                        Transform.writeOut("[ERROR] Load file DCB missing charset information");
                        Transform.exitOut(0);
                    }
                    if (isLoadFileEBCIDIC = ebcidicCodeSets.contains(" " + loadFileCharset.toUpperCase().replaceFirst("(IBM-)|(IBM)|(CP)", "") + ",")) {
                        RuntimeEnvironment.setGlobalParameter("DT", "3");
                        RuntimeEnvironment.setGlobalParameter("ibm.encoding", loadFileCharset);
                    } else {
                        RuntimeEnvironment.setGlobalParameter("DT", "1");
                        RuntimeEnvironment.setGlobalParameter("ibm.encoding", null);
                    }
                    RuntimeEnvironment.setGlobalParameter("be", loadFileCharset);
                    Variable.redoInitialization();
                    BatchTreeItem currItem = null;
                    for (Map.Entry<String, String> kv : xfdKeyValArgs.entrySet()) {
                        if (kv.getKey().endsWith("-NAME")) {
                            Transform.populateXFDTree(kv.getValue(), false);
                            primaryInputXfdFileName = kv.getValue().trim();
                            continue;
                        }
                        if (kv.getKey().endsWith("-IDXDESC")) {
                            String[] splitvals = kv.getValue().split("#");
                            currItem = Transform.getTreeItemforIndex(splitvals[0]);
                            if (splitvals.length >= 2) {
                                currItem.setText(1, splitvals[1]);
                            }
                            if (splitvals.length != 3) continue;
                            currItem.setText(2, splitvals[2]);
                            continue;
                        }
                        if (kv.getKey().endsWith("-INFO")) {
                            String[] splitvals;
                            Object[] cond = null;
                            if (currItem.getText().contains(REDEFINES_TXT)) {
                                splitvals = kv.getValue().split("#");
                                String[] var = currItem.getText().split(REDEFINES_TXT);
                                BatchTreeItem varItem = Transform.getItemInLayout(splitvals[3], currItem);
                                if (varItem == null) {
                                    Transform.writeOut("[ERROR] When condition is not valid! Item could not be initialised with " + splitvals[3] + " and " + currItem.getText());
                                    Transform.exitOut(0);
                                }
                                if (!splitvals[2].isEmpty()) {
                                    whenCondMap.put(Transform.getCurrLayout(currItem) + "." + var[0], new Object[]{((SqlColumn)varItem.getData()).getName(), splitvals[0], splitvals[1], splitvals[2]});
                                } else {
                                    whenCondMap.put(Transform.getCurrLayout(currItem) + "." + var[0], new Object[]{((SqlColumn)varItem.getData()).getName(), splitvals[0], splitvals[1]});
                                }
                                cond = new Object[]{((SqlColumn)varItem.getData()).createWorkingCopy(), Transform.getByteVal(splitvals[1]), splitvals[2].isEmpty() ? null : Transform.getByteVal(splitvals[2]), splitvals[0], splitvals[3]};
                            } else {
                                splitvals = kv.getValue().split("#");
                                if (splitvals.length >= 3 && !splitvals[2].isEmpty()) {
                                    whenCondMap.put(Transform.getCurrLayout(currItem) + "." + ((SqlColumn)currItem.getData()).getName(), new Object[]{splitvals[0], splitvals[1], splitvals[2]});
                                } else {
                                    whenCondMap.put(Transform.getCurrLayout(currItem) + "." + ((SqlColumn)currItem.getData()).getName(), new Object[]{splitvals[0], splitvals[1]});
                                }
                                cond = new Object[]{((SqlColumn)currItem.getData()).createWorkingCopy(), Transform.getByteVal(splitvals[1]), splitvals.length >= 3 && !splitvals[2].isEmpty() ? Transform.getByteVal(splitvals[2]) : null, splitvals[0], null};
                            }
                            currItem.setData(XFD_WHEN, cond);
                            continue;
                        }
                        if (!kv.getKey().equals("XFDVISIBILITY") || kv.getValue().isEmpty()) continue;
                        for (String str : kv.getValue().split("\\]")) {
                            int i;
                            int[] idx;
                            String[] str2 = str.split("\\[");
                            String parentIdx = str2[0];
                            String childIdxs = str2[1];
                            BatchTreeItem parentItem = null;
                            if (!parentIdx.isEmpty()) {
                                String[] idxs = parentIdx.split("_");
                                idx = new int[idxs.length];
                                for (i = 0; i < idxs.length; ++i) {
                                    idx[i] = Integer.parseInt(idxs[i]);
                                }
                                BatchTreeItem idxItem = XFDTree.getItem(idx[0]);
                                for (int i2 = 1; i2 < idx.length; ++i2) {
                                    idxItem = idxItem.getItem(idx[i2]);
                                }
                                parentItem = idxItem;
                            }
                            String[] cidxs = childIdxs.split(",");
                            idx = new int[cidxs.length];
                            for (i = 0; i < cidxs.length; ++i) {
                                idx[i] = Integer.parseInt(cidxs[i]);
                                try {
                                    if (parentItem == null) {
                                        XFDTree.getItem(idx[i]).setChecked(false);
                                        continue;
                                    }
                                    parentItem.getItem(idx[i]).setChecked(false);
                                    continue;
                                }
                                catch (IllegalArgumentException illErr) {
                                    Transform.writeOut("[ERROR] Error extracting rfs checked values. Possible corruption:" + kv.getKey() + "=" + kv.getValue() + "\n");
                                    illErr.printStackTrace();
                                    Transform.exitOut(0);
                                }
                            }
                        }
                    }
                }
                catch (Exception err) {
                    if (err.getMessage() == null) {
                        Transform.writeOut("[ERROR] Error in transform:" + err.toString());
                    } else {
                        Transform.writeOut("[ERROR] Transform Error:" + err.getMessage());
                    }
                    err.printStackTrace();
                    Transform.exitOut(0);
                }
            }
        }
        if (redefUseMap.isEmpty() && !iterateRedef) {
            iterateRedef = true;
        }
        Transform.validateDcbToXfdCharset();
        Transform.createOutDCB();
        try {
            if (!eclipseForeMode) {
                System.out.println("Input " + inDcb.toString().replace('\n', '\t'));
                System.out.println("Output " + outDcb.toString().replace('\n', '\t'));
            }
            Transform.beginTransformation();
        }
        catch (Exception err) {
            Transform.writeOut("[ERROR] :");
            err.printStackTrace();
        }
        Transform.exitOut(0);
    }

    private static void createOutDCB() {
        DCBFactory.setModeDcbDB(isDCBDB);
        outDcb = DCBFactory.getInstance(outDsnName, outDsnPath, true);
        try {
            outDcb.setOrientation(outOrient);
            outDcb.setRecordFormat(outFormat);
            if (_outPrimaryOffsets != null) {
                outDcb.setKeyOffset(_outPrimaryOffsets);
            }
            if (_outPrimaryLengths != null) {
                outDcb.setKeyLength(_outPrimaryLengths);
            }
            if (_outRelKeyLength != null) {
                outDcb.setKeyLength(_outRelKeyLength);
            }
            if (_outAltOffsets != null) {
                outDcb.setAltKeyOffsets(_outAltOffsets);
            }
            if (_outAltLengths != null) {
                outDcb.setAltKeyLengths(_outAltLengths);
            }
            if (_outAltDups != null) {
                outDcb.setAltKeyDuplicates(_outAltDups);
            }
            if (_outAltGroups != null) {
                outDcb.setAltKeyGroups(_outAltGroups);
            }
            if (recMin != -1) {
                outDcb.setRecordMinimum(recMin);
            } else if (outFormat.startsWith("F")) {
                outDcb.setRecordMinimum(recMax);
            }
            if (recMax != -1) {
                outDcb.setRecordMaximum(recMax);
            }
            if (recAvg != -1) {
                outDcb.setRecordAverage(recAvg);
            } else {
                outDcb.setRecordAverage(recMax);
            }
            outDcb.setProtocol(outProtocol);
            outDcb.setCharset(outCharset);
            if (outProtocol.equals("VDB")) {
                outDcb.addAssociate(null);
                outDcb.setReuse(false);
                for (Map.Entry<String, Object> es : outVDBIdxInfo.entrySet()) {
                    outDcb.addAssociate(es.getKey());
                    Object[] objArray = (Object[])es.getValue();
                    String path = "";
                    if (objArray.length != 3 || (path = (String)objArray[2]).isEmpty()) continue;
                    outDcb.addAssociate(path);
                }
            }
            outDcb.saveDCB();
            outDcb.unlockDCB();
            if (outProtocol.equals("VDB")) {
                int idx = outDsnPath.lastIndexOf(File.separatorChar);
                for (Map.Entry<String, Object> es : outVDBIdxInfo.entrySet()) {
                    if (es.getKey().isEmpty()) continue;
                    Object[] objArray = (Object[])es.getValue();
                    String path = "";
                    if (objArray.length == 3) {
                        path = (String)objArray[2];
                    }
                    Transform.createIndexDCB(true, es.getKey(), outDsnPath.substring(0, idx + 1) + es.getKey(), objArray, path);
                    outVDBViews.add(es.getKey());
                    if (objArray.length != 3 || path.isEmpty()) continue;
                    Transform.createIndexDCB(false, path, outDsnPath.substring(0, idx + 1) + path, objArray, es.getKey());
                    outVDBViews.add(path);
                }
            }
        }
        catch (DCB.InvalidDCBException e) {
            Transform.writeOut("[ERROR] Error creating output DCB");
            e.printStackTrace();
            Transform.exitOut(0);
        }
        outDcb.unlockDCB();
    }

    private static void createIndexDCB(boolean isAIX, String indexDSN, String indexDSNPath, Object[] objArray, String rel_assocDCB) {
        try {
            outDcb = DCBFactory.getInstance(indexDSN, indexDSNPath, true);
            outDcb.setOrientation(outOrient);
            outDcb.setRecordFormat(outFormat);
            outDcb.setKeyOffset((Integer[])objArray[0]);
            outDcb.setKeyLength((Integer[])objArray[1]);
            if (recMin != -1) {
                outDcb.setRecordMinimum(recMin);
            } else if (outFormat.startsWith("F")) {
                outDcb.setRecordMinimum(recMax);
            }
            if (recMax != -1) {
                outDcb.setRecordMaximum(recMax);
            }
            if (recAvg != -1) {
                outDcb.setRecordAverage(recAvg);
            } else {
                outDcb.setRecordAverage(recMax);
            }
            outDcb.setProtocol(outProtocol);
            outDcb.setCharset(outCharset);
            outDcb.setReuse(false);
            if (isAIX) {
                outDcb.setRelate(outDsnName);
                if (!rel_assocDCB.isEmpty()) {
                    outDcb.addAssociate(null);
                    outDcb.addAssociate(rel_assocDCB);
                }
            }
            if (!isAIX && !rel_assocDCB.isEmpty()) {
                outDcb.setRelate(outDsnName);
            }
            outDcb.saveDCB();
            outDcb.unlockDCB();
        }
        catch (DCB.InvalidDCBException e) {
            Transform.writeOut("[ERROR] Error creating Index DCB");
            e.printStackTrace();
            Transform.exitOut(0);
        }
    }

    private static String getCurrLayout(BatchTreeItem currItem) {
        while (currItem.getParentItem() != null) {
            currItem = currItem.getParentItem();
        }
        return currItem.getText(0);
    }

    private static BatchTreeItem getItemInLayout(String vname, String currLayout) {
        BatchTreeItem currLayoutItem = null;
        for (BatchTreeItem item : XFDTree.getItems()) {
            if (!item.getText(0).equalsIgnoreCase(currLayout)) continue;
            currLayoutItem = item;
            break;
        }
        if (currLayoutItem == null) {
            return null;
        }
        BatchTreeItem resultItem = null;
        for (BatchTreeItem item2 : currLayoutItem.getItems()) {
            resultItem = Transform.searchItemRecursive(vname, item2);
            if (resultItem == null) continue;
            return resultItem;
        }
        return resultItem;
    }

    private static BatchTreeItem searchItemRecursive(String vname, BatchTreeItem currItem) {
        String fname = null;
        if (currItem.getData() != null) {
            if (currItem.getData() instanceof SqlColumn) {
                fname = ((SqlColumn)currItem.getData()).getName();
            } else {
                fname = currItem.getText(0);
                if (currItem.getText(0).indexOf(32) != -1) {
                    fname = currItem.getText(0).substring(0, currItem.getText(0).indexOf(32));
                }
            }
        }
        if (vname.equalsIgnoreCase(fname)) {
            return currItem;
        }
        if (currItem.getItemCount() > 0) {
            BatchTreeItem resultItem = null;
            for (BatchTreeItem item2 : currItem.getItems()) {
                resultItem = Transform.searchItemRecursive(vname, item2);
                if (resultItem == null) continue;
                return resultItem;
            }
        }
        return null;
    }

    private static BatchTreeItem getItemInLayout(String vname, BatchTreeItem currItem) {
        while (currItem.getParentItem() != null) {
            currItem = currItem.getParentItem();
        }
        for (BatchTreeItem itm2 : currItem.getItems()) {
            if (itm2.getItemCount() == 0 && !itm2.getText().contains(REDEFINES_TXT)) {
                if (!itm2.getText().startsWith(vname) || !itm2.getText().substring(0, itm2.getText().indexOf(91)).equals(vname)) continue;
                return itm2;
            }
            if (itm2.getItemCount() <= 0 || itm2.getText().contains(REDEFINES_TXT)) continue;
            for (BatchTreeItem itm3 : itm2.getItems()) {
                if (itm3.getItemCount() != 0 || itm3.getText().contains(REDEFINES_TXT) || !itm3.getText().startsWith(vname) || !itm3.getText().substring(0, itm3.getText().indexOf(91)).equals(vname)) continue;
                return itm3;
            }
        }
        return null;
    }

    private static BatchTreeItem getTreeItemforIndex(String idxStr) {
        String[] idxs = idxStr.split("_");
        int[] idx = new int[idxs.length];
        for (int i = 0; i < idxs.length; ++i) {
            idx[i] = Integer.parseInt(idxs[i]);
        }
        BatchTreeItem currItem = XFDTree.getItem(idx[0]);
        for (int i = 1; i < idx.length; ++i) {
            currItem = currItem.getItem(idx[i]);
        }
        return currItem;
    }

    private static byte[] getByteVal(String hexValues) {
        byte[] b = new byte[hexValues.length() / 2];
        for (int i = 0; i < b.length; ++i) {
            int index = i * 2;
            int v = Integer.decode("0x" + hexValues.substring(index, index + 2));
            b[i] = (byte)v;
        }
        return b;
    }

    private static void validateDcbToXfdCharset() {
        if (xfdXmlCharset != null && isLoadFileEBCIDIC != isXfdXmlEbcidic) {
            Transform.writeOut("Data file has a " + (isLoadFileEBCIDIC ? "" : "non-") + "EBCIDIC charset which does not match the charset for the XFD.\nThis may result in incorrect data conversion.");
            if (!warnxfdcharset) {
                Transform.exitOut(0);
            }
        }
    }

    private static void populateXFDTree(String filename, boolean validateXFDWhen) {
        File fXmlFile = new File(filename);
        if (!fXmlFile.isAbsolute()) {
            fXmlFile = new File(profDirLoc, filename);
        }
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            Document doc = dBuilder.parse(fXmlFile);
            doc.getDocumentElement().normalize();
            String charset = doc.getDocumentElement().getAttribute("charset");
            if (charset.isEmpty()) {
                charset = "";
            }
            if (xfdXmlCharset == null) {
                isXfdXmlEbcidic = false;
                xfdXmlCharset = charset;
                if (xfdXmlCharset.equalsIgnoreCase("Cp1047") || xfdXmlCharset.equalsIgnoreCase("EBCIDIC")) {
                    isXfdXmlEbcidic = true;
                }
                Transform.validateDcbToXfdCharset();
            } else if (!xfdXmlCharset.equalsIgnoreCase(charset)) {
                Transform.writeOut("[ERROR] Input XFDXml files has mixed charset");
                if (!warnxfdcharset) {
                    Transform.exitOut(0);
                }
            } else {
                Transform.validateDcbToXfdCharset();
            }
        }
        catch (IOException | IllegalArgumentException | ParserConfigurationException | SAXException e) {
            e.printStackTrace();
            return;
        }
        try {
            LinkedHashMap<String, LinkedHashMap<String, Object>> layoutsMap = XmlDatasetLoader.XmlToFileTableExt(filename);
            Set<Map.Entry<String, LinkedHashMap<String, Object>>> layoutsEntrySet = layoutsMap.entrySet();
            Iterator<Map.Entry<String, LinkedHashMap<String, Object>>> layoutsIter = layoutsEntrySet.iterator();
            boolean ignore = false;
            while (layoutsIter.hasNext()) {
                Map.Entry<String, LinkedHashMap<String, Object>> elementsMap = layoutsIter.next();
                ignore = false;
                for (BatchTreeItem itm : XFDTree.getItems()) {
                    if (!itm.getText().equals(elementsMap.getKey())) continue;
                    ignore = true;
                }
                if (ignore) continue;
                BatchTreeItem layoutItem = new BatchTreeItem(XFDTree);
                layoutItem.setText(elementsMap.getKey());
                layoutLength = 0;
                whenConds.clear();
                layoutLength = Transform.recursiveLoadElements(elementsMap.getValue(), layoutItem, false);
                if (validateXFDWhen) {
                    Transform.validateConditions(layoutItem);
                }
                layoutItem.setChecked(true);
                layoutItem.setData("LEN", layoutLength);
                layoutItem.setData("FILE", filename);
            }
        }
        catch (Exception err) {
            Transform.writeOut("[ERROR] populateXFDTree:-");
            err.printStackTrace();
            Transform.exitOut(0);
            return;
        }
    }

    private static int recursiveLoadElements(LinkedHashMap<String, Object> elementsMap, BatchTreeItem currItem, boolean isredef) {
        int maxGrpLen = 0;
        int groupLen = 0;
        int fieldLen = 0;
        Set<Map.Entry<String, Object>> elementsEntrySet = elementsMap.entrySet();
        Iterator<Map.Entry<String, Object>> elementsIter = elementsEntrySet.iterator();
        BatchTreeItem lastItem = null;
        while (elementsIter.hasNext()) {
            Map.Entry<String, Object> elementsES = elementsIter.next();
            String[] vals = elementsES.getKey().split(String.valueOf('\u001d'), 2);
            if (elementsES.getValue() instanceof SqlColumn) {
                BatchTreeItem sqlColItem = new BatchTreeItem(currItem);
                sqlColItem.setChecked(true);
                sqlColItem.setData(elementsES.getValue());
                try {
                    fieldLen = ((SqlColumn)elementsES.getValue()).getLength();
                    sqlColItem.setText(1, ((SqlColumn)elementsES.getValue()).getPicString());
                    if (elementsES.getKey().contains(REDEFINES_TXT)) {
                        if (lastItem != null) {
                            ArrayList data = lastItem.getData(REDEFINED);
                            if (data == null) {
                                data = new ArrayList();
                            }
                            ((ArrayList)data).add(sqlColItem);
                            lastItem.setData(REDEFINED, data);
                        }
                        sqlColItem.setText(vals[0]);
                        if (fieldLen > maxGrpLen) {
                            groupLen += fieldLen - maxGrpLen;
                            maxGrpLen = fieldLen;
                        }
                    } else {
                        sqlColItem.setText(((SqlColumn)elementsES.getValue()).getName().toUpperCase() + "[" + ((SqlColumn)elementsES.getValue()).getOffset() + ":" + ((SqlColumn)elementsES.getValue()).getLength() + "]");
                        lastItem = sqlColItem;
                        groupLen += fieldLen;
                        maxGrpLen = fieldLen;
                    }
                    if (vals.length != 2) continue;
                    sqlColItem.setData("XMLATTR", vals[1]);
                    whenConds.add(sqlColItem);
                    continue;
                }
                catch (Exception err) {
                    Transform.writeOut("[ERROR] recursiveLoadElements:-");
                    err.printStackTrace();
                    Transform.exitOut(0);
                    return 0;
                }
            }
            BatchTreeItem newItem = new BatchTreeItem(currItem);
            if (elementsES.getKey().contains(REDEFINES_TXT)) {
                newItem.setText(vals[0]);
                newItem.setData("XMLATTR", vals[1]);
                whenConds.add(newItem);
                if (lastItem != null) {
                    ArrayList data = lastItem.getData(REDEFINED);
                    if (data == null) {
                        data = new ArrayList();
                    }
                    ((ArrayList)data).add(newItem);
                    lastItem.setData(REDEFINED, data);
                }
            } else {
                newItem.setText(elementsES.getKey());
                lastItem = newItem;
                maxGrpLen = 0;
            }
            newItem.setChecked(true);
            int currGrpLen = Transform.recursiveLoadElements((LinkedHashMap)elementsES.getValue(), newItem, elementsES.getKey().contains(REDEFINES_TXT));
            if (currGrpLen <= maxGrpLen) continue;
            groupLen += currGrpLen - maxGrpLen;
            maxGrpLen = currGrpLen;
        }
        return groupLen;
    }

    private static String getFieldName(BatchTreeItem item) {
        if (item.getText().indexOf(91) != -1) {
            return item.getText().substring(0, item.getText().indexOf(91));
        }
        if (item.getText().indexOf(32) != -1) {
            return item.getText().substring(0, item.getText().indexOf(32));
        }
        return item.getText();
    }

    private static BatchTreeItem getXFdVarMatch(BatchTreeItem item, String varname) {
        if (item.getData() != null && varname.equals(Transform.getFieldName(item))) {
            return item;
        }
        for (BatchTreeItem subItem : item.getItems()) {
            if (subItem.getItemCount() == 0 && item.getData() != null && varname.equals(Transform.getFieldName(subItem))) {
                return subItem;
            }
            BatchTreeItem result = Transform.getXFdVarMatch(subItem, varname);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    private static void validateConditions(BatchTreeItem layoutItem) {
        for (BatchTreeItem whenItm : whenConds) {
            Object sqlvar;
            String whenattr = (String)whenItm.getData("XMLATTR");
            String[] attrs = whenattr.split(String.valueOf('\u001d'));
            BatchTreeItem varItem = null;
            String desc = "";
            String varname = null;
            if (whenItm.getText().contains(REDEFINES_TXT)) {
                varname = attrs[3].toUpperCase();
                for (BatchTreeItem itm2 : layoutItem.getItems()) {
                    BatchTreeItem result = Transform.getXFdVarMatch(itm2, varname);
                    if (result == null) continue;
                    varItem = result;
                    break;
                }
                if (varItem == null) {
                    Transform.writeOut("$XFD WHEN [varname]  operator arg1 [arg2]");
                    Transform.writeOut("Unable to map <varname>:" + varname);
                    continue;
                }
                desc = desc + varname;
                sqlvar = varItem.getData();
            } else {
                sqlvar = whenItm.getData();
            }
            try {
                SqlColumn workSql = ((SqlColumn)sqlvar).createWorkingCopy();
                String oper = attrs[0];
                if (oper.equalsIgnoreCase("LTEQ")) {
                    oper = "IS < OR = TO";
                } else if (oper.equalsIgnoreCase("LT")) {
                    oper = "IS < THAN";
                } else if (oper.equalsIgnoreCase("EQ")) {
                    oper = "IS = TO";
                } else if (oper.equalsIgnoreCase("GTEQ")) {
                    oper = "IS > OR = TO";
                } else if (oper.equalsIgnoreCase("GT")) {
                    oper = "IS > THAN";
                } else if (oper.equalsIgnoreCase("BET")) {
                    oper = "IS BETWEEN";
                } else if (oper.equalsIgnoreCase("!LTEQ")) {
                    oper = "NOT < OR = TO";
                } else if (oper.equalsIgnoreCase("!LT")) {
                    oper = "NOT < THAN";
                } else if (oper.equalsIgnoreCase("!EQ")) {
                    oper = "NOT = TO";
                } else if (oper.equalsIgnoreCase("!GTEQ")) {
                    oper = "NOT > OR = TO";
                } else if (oper.equalsIgnoreCase("!GT")) {
                    oper = "NOT > THAN";
                } else if (oper.equalsIgnoreCase("!BET")) {
                    oper = "NOT BETWEEN";
                }
                int sqlLen = workSql.getLength();
                byte[] arg1Buf = new byte[sqlLen];
                workSql.updateColumn(arg1Buf, 0, attrs[1]);
                desc = desc + " " + oper + "  [" + attrs[1] + "] ";
                byte[] arg2Buf = null;
                if (oper.contains("BETWEEN")) {
                    arg2Buf = new byte[sqlLen];
                    workSql.updateColumn(arg2Buf, 0, attrs[2]);
                    desc = desc + " AND [" + attrs[2] + "] ";
                }
                whenItm.setText(2, desc);
                whenItm.setData(XFD_WHEN, new Object[]{workSql, arg1Buf, arg2Buf, oper, varname});
            }
            catch (Exception err) {
                Transform.writeOut("[ERROR] validateConditions:-");
                err.printStackTrace();
                Transform.exitOut(0);
                return;
            }
        }
    }

    private static void beginTransformation() {
        signedTransform = 0;
        outDcb = DCBFactory.getInstance(outDsnName, outDsnPath, true);
        outDcb.unlockDCB();
        outDCBIsNumbered = outDcb.isNumbered();
        outDCBIsIndexed = outDcb.isIndexed();
        transformFileCharset = outDcb.getCharset();
        if (transformFileCharset == null || transformFileCharset.trim().isEmpty()) {
            Transform.writeOut("[ERROR] Load file DCB missing charset information");
            Transform.exitOut(0);
        }
        isTransformFileEBCIDIC = ebcidicCodeSets.contains(" " + transformFileCharset.toUpperCase().replaceFirst("(IBM-)|(IBM)|(CP)", "") + ",");
        if (isLoadFileEBCIDIC && !isTransformFileEBCIDIC) {
            signedTransform = 1;
        }
        if (!isLoadFileEBCIDIC && isTransformFileEBCIDIC) {
            signedTransform = 2;
        }
        Transform.setupTranslateTables();
        noConv = true;
        if (!loadFileCharset.equalsIgnoreCase(transformFileCharset)) {
            noConv = false;
        }
        xfdRowLayout = null;
        xfdMap.clear();
        xfdCondMap.clear();
        hasMultipleLayouts = false;
        hasSingleLayout = false;
        hasNoLayouts = true;
        xfdAvail = false;
        HashMap layoutRedefMap = new HashMap(5);
        if (XFDTree.getItemCount() > 0) {
            hasNoLayouts = false;
            for (BatchTreeItem item : XFDTree.getItems()) {
                Vector<Object> xfdCols = new Vector<Object>();
                boolean hasRedef = false;
                HashMap<Object, Object[]> condMap = new HashMap<Object, Object[]>();
                for (BatchTreeItem subItem : item.getItems()) {
                    if (subItem.getText(0).contains(REDEFINES_TXT)) continue;
                    if (subItem.getData(REDEFINED) != null) {
                        hasRedef = true;
                        xfdCols.add(subItem);
                        continue;
                    }
                    xfdCols.add(subItem.getData());
                    if (subItem.getData(XFD_WHEN) == null || subItem.getText(0).contains(REDEFINES_TXT)) continue;
                    Object[] condParams = (Object[])subItem.getData(XFD_WHEN);
                    condMap.put(subItem.getData(), new Object[]{Transform.extractDataType(condParams[1], condParams[0]), Transform.extractDataType(condParams[2], condParams[0]), condParams[3], condParams[4]});
                }
                if (condMap.size() > 0) {
                    xfdCondMap.put(xfdCols, condMap);
                }
                xfdMap.add(xfdCols);
                if (hasRedef) {
                    layoutRedefMap.put(xfdCols, true);
                    continue;
                }
                layoutRedefMap.put(xfdCols, false);
            }
            hasMultipleLayouts = true;
            xfdAvail = true;
        }
        if (!(inCobolFile = new COBOLFile(inDcb)).open(READ, (Boolean)false)) {
            Transform.writeOut("[ERROR] Input file Open failed: File Status:" + inCobolFile.getStatus());
            Transform.writeOut("Dataset name that was tried: " + inDcb.getDatasetName());
            Transform.exitOut(0);
        }
        outCobolFile = new COBOLFile(outDcb);
        String mode = WRITE;
        boolean createAIX = true;
        if (outAppend.equalsIgnoreCase("TRUE")) {
            if (outCobolFile.open(READ, null)) {
                createAIX = false;
                outCobolFile.close();
            }
            String string2 = mode = outDCBIsIndexed || outDCBIsNumbered ? READWRITE : EXTEND;
        }
        if (!outCobolFile.open(mode, null)) {
            Transform.writeOut("[ERROR] Output file Open failed: File Status:" + outCobolFile.getStatus());
            Transform.exitOut(0);
        }
        if (createAIX) {
            String outBasePath = outDcb.getDatasetNamePath();
            outBasePath = outBasePath.substring(0, outBasePath.lastIndexOf(File.separatorChar) + 1);
            for (String indexDsn : outVDBViews) {
                DCB aixDCB = DCBFactory.getInstance(indexDsn, outBasePath + indexDsn, true);
                aixDCB.unlockDCB();
                COBOLFile aixFile = new COBOLFile(aixDCB);
                if (aixFile.open(WRITE, null)) {
                    aixFile.close();
                    continue;
                }
                Transform.writeOut("[ERROR] Failure to create AIX views:" + indexDsn);
                Transform.exitOut(0);
            }
        }
        try {
            String infileStatus = inCobolFile.getStatus();
            int recordId = 0;
            boolean doAll = false;
            if (recFrom == recTo && recTo == 0) {
                doAll = true;
            }
            if (recTo != 0) {
                --recFrom;
                for (int i = 0; i < recFrom && !infileStatus.equals("10"); ++i) {
                    inCobolFile.read();
                    ++recordId;
                    infileStatus = inCobolFile.getStatus();
                }
                recFrom = recTo - recFrom;
                recTo = 0;
            }
            String outfileStatus = "00";
            sqlTranslateMap.clear();
            if (!eclipseForeMode) {
                Transform.writeOut("Transform Started:");
                if ("TRUE".equalsIgnoreCase(IS_BATCH_INSERT_MODE)) {
                    Transform.writeOut(" - Using Batch Insert Mode with Batch Size = " + BATCH_INSERT_SIZE);
                } else {
                    Transform.writeOut(" - Batch mode off. This can significantly reduce the performance. You can use 'sql.file.useBatchInsert=true' and 'sql.file.useBatchInsert.batchSize=<batchSize>' in your PROF file. ");
                }
            }
            long inFileSize = new File(inDsnPath).length();
            long recordSize = inCobolFile.getDCB().getRecordAverage() == null ? (long)inCobolFile.getDCB().getRecordMaximum().intValue() : (long)inCobolFile.getDCB().getRecordAverage().intValue();
            long start = System.currentTimeMillis();
            int lastPercentageDone = 0;
            boolean isBatchMode = Transform.isBatchInsertMode();
            int batchSize = Transform.getBatchInsertSize();
            String batchInfo = "";
            System.setProperty("TRANSFORM_MODE", "1");
            if (eclipseForeMode) {
                Transform.launchCounter();
            }
            while (!(infileStatus.equals("10") || infileStatus.equals("23") || !doAll && recCntr == recFrom)) {
                int percentageDone;
                inbytes = inCobolFile.read();
                badRecord = false;
                ++recordId;
                infileStatus = inCobolFile.getStatus();
                ++recCntr;
                if (infileStatus.equals("10") || infileStatus.equals("23")) continue;
                if (quietMode && ++readCnt % 10 == 0) {
                    System.out.print("\r" + readCnt);
                }
                if (!noConv) {
                    if (xfdAvail) {
                        Vector<Object> layout;
                        Vector<Object> vector = layout = xfdMap.size() == 1 ? xfdMap.get(0) : Transform.determineRowLayout(inbytes);
                        if (badRecord) {
                            if (!badrecordexit) continue;
                            killCounter = true;
                            Transform.exitOut(0);
                        }
                        if (layout == null) {
                            Transform.writeOut("Unable to map layout to record #" + recordId);
                            continue;
                        }
                        xfdRowLayout = (Boolean)layoutRedefMap.get(layout) != false ? Transform.extractRedefines(layout, inbytes, false) : layout;
                        Object convInfo = null;
                        for (Object col : xfdRowLayout) {
                            if (!sqlTranslateMap.containsKey(col)) {
                                if (((SqlColumn)col).getSqlType().equals("A") || ((SqlColumn)col).getSqlType().equals("B")) {
                                    convInfo = new Integer[]{1, ((SqlColumn)col).getOffset(), ((SqlColumn)col).getLength()};
                                } else {
                                    IDatatype datatype = ((SqlColumn)col).getIDataTypeColumn();
                                    int dtype = 0;
                                    if (datatype instanceof DisplayP) {
                                        dtype = ((DisplayP)datatype).getArgumentType();
                                    } else if (datatype instanceof Display) {
                                        dtype = ((Display)datatype).getArgumentType();
                                    } else if (datatype instanceof DisplayA) {
                                        dtype = ((DisplayA)datatype).getArgumentType();
                                    } else if (datatype instanceof DisplayH) {
                                        dtype = ((DisplayH)datatype).getArgumentType();
                                    } else if (datatype instanceof DisplayMVS) {
                                        dtype = ((DisplayMVS)datatype).getArgumentType();
                                    }
                                    convInfo = dtype != 0 ? new Integer[]{dtype == 5 || dtype == 3 ? Integer.valueOf(dtype == 5 ? 2 : 3) : Integer.valueOf(4), ((SqlColumn)col).getOffset(), ((SqlColumn)col).getLength()} : null;
                                }
                                sqlTranslateMap.put(col, (Integer[])convInfo);
                            } else {
                                convInfo = sqlTranslateMap.get(col);
                            }
                            if (convInfo == null) continue;
                            if (!norecvalidate && convInfo[1] + convInfo[2] > inbytes.length) {
                                Transform.writeOut("Record layout mismatch: Record #" + recCntr + " length=" + inbytes.length + " bytes Field:" + ((SqlColumn)col).getName() + " Offset:" + convInfo[1] + " Length:" + convInfo[2]);
                                badRecord = true;
                                break;
                            }
                            if (convInfo[1] + convInfo[2] > inbytes.length) continue;
                            if (convInfo[0] == 1 || convInfo[0] == 4 || signedTransform == 0) {
                                Transform.translateCharset(inbytes, convInfo[1], convInfo[2]);
                                continue;
                            }
                            if (convInfo[0] != 2 && convInfo[0] != 3) continue;
                            Transform.translateSigned(inbytes, convInfo[0] == 2, convInfo[1], convInfo[2], signedTransform != 1);
                        }
                        if (badRecord) {
                            if (!badrecordexit) continue;
                            killCounter = true;
                            Transform.exitOut(0);
                        }
                    } else {
                        Transform.translateCharset(inbytes, 0, inbytes.length);
                    }
                }
                if (outDCBIsNumbered) {
                    outCobolFile.write(inbytes, writeCnt);
                } else {
                    outCobolFile.write(inbytes);
                }
                outfileStatus = outCobolFile.getStatus();
                if (outfileStatus.equals("02")) {
                    ++dupCnt;
                    ++writeCnt;
                } else if (outfileStatus.equals("00")) {
                    ++writeCnt;
                } else if (outfileStatus.equals("22")) {
                    ++dupFailCnt;
                    Transform.writeOut("Duplicate fail error record #" + recordId + "  \\n File Status:" + outfileStatus);
                } else {
                    String errMsg = System.getProperty("TRANSFORM_MODE_ERR", "");
                    if (errMsg.isEmpty()) {
                        errMsg = "[ERROR] Write error record #" + recordId + "  \n File Status:" + outfileStatus;
                    }
                    if (!eclipseForeMode) {
                        Transform.writeOut(errMsg);
                        break;
                    }
                    System.out.println(errMsg);
                    break;
                }
                if (isBatchMode && writeCnt % batchSize == 0) {
                    batchInfo = String.format("(Batch committed at %d record)", writeCnt);
                }
                if ((percentageDone = (int)((double)(recordSize * (long)writeCnt) * 1.0 / (double)inFileSize * 100.0)) <= 100 && percentageDone != lastPercentageDone) {
                    String progress = String.join((CharSequence)"", Collections.nCopies(percentageDone, "#"));
                    String remaining = String.join((CharSequence)"", Collections.nCopies(100 - percentageDone, " "));
                    if (!eclipseForeMode) {
                        System.out.print(String.format("[%s%s] %d %% (%d / %d) %s\r", progress, remaining, percentageDone, writeCnt, inFileSize / recordSize, batchInfo));
                    }
                }
                lastPercentageDone = percentageDone;
            }
            Transform.writeOut("");
            killCounter = true;
            long durationInSec = (System.currentTimeMillis() - start) / 1000L;
            if (!eclipseForeMode) {
                Transform.writeOut("\rTransform Completed:");
                Transform.writeOut(String.format("Time to complete: %d sec. ", durationInSec));
            }
            Transform.writeOut("Records read:" + readCnt);
            Transform.writeOut("Records written:" + writeCnt);
            Transform.writeOut("Duplicates written:" + dupCnt);
            Transform.writeOut("Duplicate writes failed:" + dupFailCnt);
            if (inCobolFile != null && inCobolFile.isOpen()) {
                inCobolFile.close();
            }
            if (outCobolFile != null && outCobolFile.isOpen()) {
                outCobolFile.close();
            }
            layoutRedefMap.clear();
        }
        catch (Exception e) {
            e.printStackTrace();
            killCounter = true;
            Transform.writeOut("Records read:" + readCnt);
            Transform.writeOut("Records written:" + writeCnt);
            Transform.writeOut("Duplicates written:" + dupCnt);
            Transform.writeOut("Duplicate writes failed:" + dupFailCnt);
            Transform.exitOut(0);
        }
        if (eclipseForeMode) {
            System.out.println("counter:" + readCnt + ":" + writeCnt + ":" + dupCnt + ":" + dupFailCnt);
        }
        if (outProtocol.equalsIgnoreCase("VDB") && !primaryInputXfdFileName.isEmpty()) {
            Transform.processXfdXml();
        }
    }

    static void launchCounter() {
        TimerTask task = new TimerTask(){

            @Override
            public void run() {
                if (killCounter) {
                    timer.cancel();
                    return;
                }
                System.out.println("counter:" + readCnt + ":" + writeCnt + ":" + dupCnt + ":" + dupFailCnt);
            }
        };
        timer.schedule(task, 1000L, 1000L);
    }

    static int getBatchInsertSize() {
        String property = System.getProperty("sql.file.useBatchInsert.batchSize");
        if (property != null && !property.isEmpty()) {
            return Integer.valueOf(property);
        }
        return 0;
    }

    static boolean isBatchInsertMode() {
        String property = System.getProperty("sql.file.useBatchInsert");
        return Boolean.valueOf(property);
    }

    static void processXfdXml() {
        XMLInputFactory inputFactory = XMLInputFactory.newInstance();
        inputFactory.setProperty("javax.xml.stream.isSupportingExternalEntities", Boolean.FALSE);
        try {
            File file2 = new File(primaryInputXfdFileName);
            DocumentBuilder dBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document xfdxml = dBuilder.parse(file2);
            if (xfdxml.hasChildNodes()) {
                NodeList nodeList = xfdxml.getChildNodes();
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    Node tempNode = nodeList.item(i);
                    if (tempNode.getNodeType() != 1 || !tempNode.getNodeName().equalsIgnoreCase("dataset")) continue;
                    if (tempNode.hasChildNodes()) {
                        NodeList recLayouts = tempNode.getChildNodes();
                        for (int j = 0; j < recLayouts.getLength(); ++j) {
                            Node fieldNode = recLayouts.item(j);
                            if (fieldNode.getNodeType() != 1 || !fieldNode.getNodeName().equalsIgnoreCase("group") && !fieldNode.getNodeName().equalsIgnoreCase("column")) continue;
                            NamedNodeMap nodeMap = fieldNode.getAttributes();
                            currLayout = nodeMap.getNamedItem("name").getNodeValue().toUpperCase();
                            if (defLayout.isEmpty()) {
                                defLayout = currLayout;
                                String defIter = layoutRedefIterMap.get("");
                                if (defIter != null) {
                                    layoutRedefIterMap.replace(defLayout, defIter);
                                }
                            }
                            if (fieldNode.getNodeName().equalsIgnoreCase("column")) continue;
                            Transform.parseRedefines(fieldNode.getChildNodes());
                        }
                    }
                    if (tempNode.getChildNodes().getLength() <= 1 && redefinedList.size() <= 0) continue;
                    generateViews = true;
                }
                Iterator<Map.Entry<String, String>> iter = layoutRedefIterMap.entrySet().iterator();
                while (iter.hasNext()) {
                    Map.Entry<String, String> set = iter.next();
                    if (redefinedList.contains(set.getKey() + "." + set.getValue())) continue;
                    iter.remove();
                }
            }
            if (!generateViews) {
                return;
            }
            Transform.writeOut("Detected multi record layout and/or redefines. Generating VDB views:");
            String[] urlVals = sqlurl.split(":", 3);
            if (urlVals.length == 3) {
                if (urlVals[1].equalsIgnoreCase("POSTGRESQL")) {
                    dbms = "POSTGRES";
                } else if (urlVals[1].equalsIgnoreCase("MYSQL") || urlVals[1].equalsIgnoreCase("MARIADB")) {
                    dbms = "MYSQL";
                } else if (urlVals[1].equalsIgnoreCase("DB2")) {
                    dbms = "DB2";
                } else if (urlVals[1].equalsIgnoreCase("ORACLE")) {
                    dbms = "ORACLE";
                } else if (urlVals[1].equalsIgnoreCase("SQLSERVER")) {
                    dbms = "MSSQL_SERVER";
                } else {
                    Transform.writeOut("DBMS not supported:" + urlVals[1]);
                    return;
                }
            }
            if (dbms.isEmpty()) {
                Transform.writeOut("DBMS not specified");
                return;
            }
            if (dbms.equalsIgnoreCase("MSSQL_SERVER")) {
                String mssqlhelp = XfdUtils.returnDatabaseHelperFunctions(XfdUtils.Database.valueOf(dbms));
                String[] helpers = mssqlhelp.split("GO");
                for (int i = 0; i < helpers.length; ++i) {
                    String help = helpers[i].trim();
                    if (help.isEmpty()) continue;
                    outCobolFile.executeSQL(help);
                }
            } else {
                outCobolFile.executeSQL(XfdUtils.returnDatabaseHelperFunctions(XfdUtils.Database.valueOf(dbms)));
            }
            xfdxml = dBuilder.parse(file2);
            if (xfdxml.hasChildNodes()) {
                Transform.processRecordLayouts(xfdxml.getChildNodes());
            }
        }
        catch (FactoryConfigurationError e) {
            System.err.println("[ERROR] FactoryConfigurationError" + e.getMessage());
            Transform.exitOut(1);
        }
        catch (IOException e) {
            e.printStackTrace();
            System.err.println("[ERROR] IOException" + e.getMessage());
            Transform.exitOut(1);
        }
        catch (Exception e) {
            e.printStackTrace();
            Transform.exitOut(1);
        }
    }

    private static void parseRedefines(NodeList fieldNodeList) {
        for (int count = 0; count < fieldNodeList.getLength(); ++count) {
            Node fieldNode = fieldNodeList.item(count);
            if (fieldNode.getNodeType() != 1) continue;
            NamedNodeMap nodeAttrMap = fieldNode.getAttributes();
            Node redefAttr = nodeAttrMap.getNamedItem("redefines");
            if (redefAttr != null) {
                String redefines = nodeAttrMap.getNamedItem("redefines").getNodeValue().toUpperCase();
                String fldname = nodeAttrMap.getNamedItem("name").getNodeValue().toUpperCase();
                if (redefiningMap.containsKey(currLayout + "." + redefines)) {
                    redefines = redefiningMap.get(currLayout + "." + redefines);
                }
                redefiningMap.put(currLayout + "." + fldname, redefines);
                if (!redefinedList.contains(currLayout + "." + redefines)) {
                    redefinedList.add(currLayout + "." + redefines);
                }
                if (iterateRedef && layoutRedefIterMap.get(currLayout) == null) {
                    layoutRedefIterMap.put(currLayout, redefines);
                }
            }
            if (!fieldNode.hasChildNodes()) continue;
            Transform.parseRedefines(fieldNode.getChildNodes());
        }
    }

    private static void processRecordLayouts(NodeList nodeList) {
        XfdUtils.generateField2ColumnMapping(primaryInputXfdFileName, varChar, outProtocol.equalsIgnoreCase("VDB") ? outDsnName.replace('.', '_') : outDsnName, XfdUtils.Database.valueOf(dbms));
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node tempNode = nodeList.item(i);
            if (tempNode.getNodeType() != 1 || !tempNode.getNodeName().equalsIgnoreCase("dataset") || !tempNode.hasChildNodes()) continue;
            NodeList recLayouts = tempNode.getChildNodes();
            for (int j = 0; j < recLayouts.getLength(); ++j) {
                Node fieldNode = recLayouts.item(j);
                if (fieldNode.getNodeType() != 1 || !fieldNode.getNodeName().equalsIgnoreCase("group") && !fieldNode.getNodeName().equalsIgnoreCase("column")) continue;
                NamedNodeMap nodeMap = fieldNode.getAttributes();
                currLayout = nodeMap.getNamedItem("name").getNodeValue().toUpperCase();
                if (includedLayouts.size() != 0 && (includedLayouts.size() <= 0 || !includedLayouts.contains(currLayout)) || excludedLayouts.size() != 0 && (excludedLayouts.size() <= 0 || excludedLayouts.contains(currLayout))) continue;
                redefProcess.clear();
                redefIterFileMap.clear();
                viewWhereConditions.clear();
                String currLayoutName = currLayout;
                if (renamedLayouts.containsKey(currLayout)) {
                    currLayoutName = renamedLayouts.get(currLayout);
                }
                String tempInputXFD = System.getProperty("java.io.tmpdir") + File.separator + "tempInputXfd" + UUID.randomUUID() + ".xml";
                String tempOutputView = System.getProperty("java.io.tmpdir") + File.separator + "tempInputXfd" + UUID.randomUUID() + ".sql";
                File tempInputFile = new File(tempInputXFD);
                try {
                    FileOutputStream fos = new FileOutputStream(tempInputFile);
                    bw = new BufferedWriter(new OutputStreamWriter(fos));
                    bw.write("<?xml version=\"1.0\" standalone=\"yes\"?>\n");
                    if (layoutRedefIterMap.get(currLayout) != null) {
                        bw.write(datasetGroupID + "\n");
                    } else {
                        bw.write("<dataset name=\"" + currLayoutName + "\" charset=\"\">\n");
                        bw.write("<group name=\"" + currLayoutName + "\" >\n");
                    }
                    if (fieldNode.getNodeName().equalsIgnoreCase("column")) {
                        bw.write("<column name=\"" + currLayoutName + "\" offset=\"" + nodeMap.getNamedItem("offset").getNodeValue() + "\" length=\"" + nodeMap.getNamedItem("length").getNodeValue() + "\" piclen=\"" + nodeMap.getNamedItem("piclen").getNodeValue() + "\" sqltype=\"" + nodeMap.getNamedItem("sqltype").getNodeValue());
                        if (nodeMap.getNamedItem("place") != null) {
                            bw.write("\" place=\"" + nodeMap.getNamedItem("place").getNodeValue() + "\"/>\n");
                        } else {
                            bw.write("\"/>\n");
                        }
                    } else {
                        Transform.processFields(fieldNode.getChildNodes());
                    }
                    bw.write("</group>\n");
                    bw.write("</dataset>\n");
                    bw.close();
                    fos.close();
                    if (layoutRedefIterMap.get(currLayout) != null) {
                        for (Map.Entry<String, String> entryset : redefIterFileMap.entrySet()) {
                            String vName = (outProtocol.equalsIgnoreCase("VDB") ? outDsnName.replaceAll("\\.", "_") : outDsnName) + "_" + currLayoutName.replaceAll("\\.", "_") + "_" + entryset.getKey() + "_view";
                            outCobolFile.executeSQL("DROP VIEW IF EXISTS " + vName);
                            Transform.writeOut("Generating View/s [Redefines]:" + vName);
                            String tmpViewXFDinput = System.getProperty("java.io.tmpdir") + File.separator + "IterXfdFile" + UUID.randomUUID() + ".xml";
                            File tmpViewXfdFile = new File(tmpViewXFDinput);
                            FileOutputStream outputStream2 = new FileOutputStream(tmpViewXfdFile);
                            BufferedWriter bufferedWriter2 = new BufferedWriter(new OutputStreamWriter(outputStream2));
                            String iterFileName = entryset.getValue();
                            File iterFile = new File(iterFileName);
                            FileInputStream inputStream1 = new FileInputStream(iterFile);
                            BufferedReader redefFileReader = new BufferedReader(new InputStreamReader(inputStream1));
                            FileInputStream mainInputStream = new FileInputStream(tempInputFile);
                            BufferedReader brMainFile = new BufferedReader(new InputStreamReader(mainInputStream));
                            String mainFileLine = brMainFile.readLine();
                            while (mainFileLine != null) {
                                if (mainFileLine.equals(datasetGroupID)) {
                                    bufferedWriter2.write("<dataset name=\"" + currLayoutName + "_" + entryset.getKey() + "\" charset=\"\">\n");
                                    bufferedWriter2.write("<group name=\"" + currLayoutName + "_" + entryset.getKey() + "\" >\n");
                                } else if (mainFileLine.equals(redefinesID)) {
                                    String redefLine = redefFileReader.readLine();
                                    while (redefLine != null) {
                                        bufferedWriter2.write(redefLine);
                                        redefLine = redefFileReader.readLine();
                                    }
                                } else {
                                    bufferedWriter2.write(mainFileLine);
                                }
                                mainFileLine = brMainFile.readLine();
                            }
                            bufferedWriter2.close();
                            redefFileReader.close();
                            mainInputStream.close();
                            brMainFile.close();
                            XfdUtils.generateView(tmpViewXFDinput, tempOutputView, XfdUtils.Database.valueOf(dbms), varChar, matView, outProtocol.equalsIgnoreCase("VDB") ? outDsnName.replaceAll("\\.", "_") : outDsnName, currLayoutName.replaceAll("\\.", "_").toLowerCase(), entryset.getKey().toLowerCase(), viewWhereConditions);
                            outCobolFile.executeSQL(new String(Files.readAllBytes(Paths.get(tempOutputView, new String[0]))));
                            iterFile.delete();
                            tmpViewXfdFile.delete();
                            File tempOutputFile = new File(tempOutputView);
                            tempOutputFile.delete();
                        }
                        tempInputFile.delete();
                    } else {
                        String vName = (outProtocol.equalsIgnoreCase("VDB") ? outDsnName.replaceAll("\\.", "_") : outDsnName) + "_" + currLayoutName.replaceAll("\\.", "_") + "_view";
                        Transform.writeOut("Generating View :" + vName);
                        outCobolFile.executeSQL("DROP VIEW IF EXISTS " + vName);
                        XfdUtils.generateView(tempInputXFD, tempOutputView, XfdUtils.Database.valueOf(dbms), varChar, matView, outProtocol.equalsIgnoreCase("VDB") ? outDsnName.replaceAll("\\.", "_") : outDsnName, currLayoutName.replaceAll("\\.", "_").toLowerCase(), null, viewWhereConditions);
                        outCobolFile.executeSQL(new String(Files.readAllBytes(Paths.get(tempOutputView, new String[0]))));
                        tempInputFile.delete();
                        File tempOutputFile = new File(tempOutputView);
                        tempOutputFile.delete();
                    }
                }
                catch (IOException ioerr) {
                    Transform.writeOut("[ERROR] Generate View SQL:-" + ioerr.getMessage());
                    Transform.exitOut(1);
                }
                for (String str : redefProcess) {
                    Transform.writeOut("Unable to process redefines field :-" + str);
                }
                if (redefProcess.size() <= 0) continue;
                Transform.writeOut("Syntax  REDEFINES_USE= <Layout>.<RedefinedField1>:<RedefiningField1>,.......");
            }
        }
    }

    private static boolean processIterRedefines(String redefField, String redefines, Node fieldNode) throws IOException {
        String redefFld = layoutRedefIterMap.get(currLayout);
        if (redefFld != null && redefFld.equalsIgnoreCase(redefines)) {
            if (bwRedef == null) {
                String redefFileName = System.getProperty("java.io.tmpdir") + File.separator + "redefField" + UUID.randomUUID() + ".xml";
                File redefFile = new File(redefFileName);
                FileOutputStream redefFos = new FileOutputStream(redefFile);
                bwRedef = new BufferedWriter(new OutputStreamWriter(redefFos));
                if (fieldNode.hasChildNodes()) {
                    Transform.processFields(fieldNode.getChildNodes());
                } else {
                    NamedNodeMap nodeAttrMap = fieldNode.getAttributes();
                    bwRedef.write("<column name=\"" + redefField + "\" offset=\"" + nodeAttrMap.getNamedItem("offset").getNodeValue() + "\" length=\"" + nodeAttrMap.getNamedItem("length").getNodeValue() + "\" piclen=\"" + nodeAttrMap.getNamedItem("piclen").getNodeValue() + "\" sqltype=\"" + nodeAttrMap.getNamedItem("sqltype").getNodeValue());
                    if (nodeAttrMap.getNamedItem("place") != null) {
                        bwRedef.write("\" place=\"" + nodeAttrMap.getNamedItem("place").getNodeValue() + "\"/>\n");
                    } else {
                        bwRedef.write("\"/>\n");
                    }
                }
                bwRedef.close();
                redefFos.close();
                bwRedef = null;
                redefIterFileMap.put(redefField, redefFileName);
                bw.write(redefinesID + "\n");
                return true;
            }
            Transform.writeOut("Duplicate nested redefines:[" + currLayout + "." + redefField + "] Iterative processings will not be performed.");
            Transform.writeOut("Use the $XFD Name directive to rename duplicate fields.");
        }
        return false;
    }

    private static String transformHex(String inputHex, SqlColumn sqlColData) {
        byte[] inputBytes = Transform.getByteVal(inputHex);
        if (xfdAvail) {
            Object convInfo;
            if (!sqlTranslateMap.containsKey(sqlColData)) {
                if (sqlColData.getSqlType().equals("A") || sqlColData.getSqlType().equals("B")) {
                    convInfo = new Integer[]{1, sqlColData.getOffset(), sqlColData.getLength()};
                } else {
                    IDatatype datatype = sqlColData.getIDataTypeColumn();
                    int dtype = 0;
                    if (datatype instanceof DisplayP) {
                        dtype = ((DisplayP)datatype).getArgumentType();
                    } else if (datatype instanceof Display) {
                        dtype = ((Display)datatype).getArgumentType();
                    } else if (datatype instanceof DisplayA) {
                        dtype = ((DisplayA)datatype).getArgumentType();
                    } else if (datatype instanceof DisplayH) {
                        dtype = ((DisplayH)datatype).getArgumentType();
                    } else if (datatype instanceof DisplayMVS) {
                        dtype = ((DisplayMVS)datatype).getArgumentType();
                    }
                    convInfo = dtype != 0 ? new Integer[]{dtype == 5 || dtype == 3 ? Integer.valueOf(dtype == 5 ? 2 : 3) : Integer.valueOf(4), sqlColData.getOffset(), sqlColData.getLength()} : null;
                }
                sqlTranslateMap.put(sqlColData, (Integer[])convInfo);
            } else {
                convInfo = sqlTranslateMap.get(sqlColData);
            }
            if (convInfo != null) {
                if (convInfo[0] == 1 || convInfo[0] == 4 || signedTransform == 0) {
                    Transform.translateCharset(inputBytes, 0, inputBytes.length);
                } else if (convInfo[0] == 2 || convInfo[0] == 3) {
                    Transform.translateSigned(inputBytes, convInfo[0] == 2, 0, inputBytes.length, signedTransform != 1);
                }
            }
        } else {
            Transform.translateCharset(inputBytes, 0, inputBytes.length);
        }
        return Transform.bytesToHex(inputBytes);
    }

    private static String bytesToHex(byte[] in) {
        StringBuilder builder = new StringBuilder();
        for (byte b : in) {
            builder.append(String.format("%02x", b));
        }
        return builder.toString();
    }

    private static void processFields(NodeList fieldNodeList) throws IOException {
        for (int count = 0; count < fieldNodeList.getLength(); ++count) {
            Node fieldNode = fieldNodeList.item(count);
            if (fieldNode.getNodeType() != 1) continue;
            NamedNodeMap nodeAttrMap = fieldNode.getAttributes();
            if (nodeAttrMap.getNamedItem("xfdop") != null) {
                String fname = nodeAttrMap.getNamedItem("name").getNodeValue();
                if (whenCondMap.containsKey(currLayout.toLowerCase() + "." + fname)) {
                    int idx;
                    BatchTreeItem argItem;
                    Object[] params = whenCondMap.get(currLayout.toLowerCase() + "." + fname);
                    String whereCond = fname;
                    if (nodeAttrMap.getNamedItem("xfdvar") != null) {
                        whereCond = (String)params[0];
                        argItem = Transform.getItemInLayout((String)params[0], currLayout);
                        idx = CONDITIONS.indexOf((String)params[1]);
                        whereCond = ((String)params[1]).contains("BETWEEN") ? (dbms.equalsIgnoreCase("POSTGRES") ? whereCond + SQLCONDITIONS.get(idx) + " bytea '\\x" + Transform.transformHex((String)params[2], (SqlColumn)argItem.getData()) + "' AND  bytea '\\x" + Transform.transformHex((String)params[3], (SqlColumn)argItem.getData()) + "'" : whereCond + SQLCONDITIONS.get(idx) + "0x" + Transform.transformHex((String)params[2], (SqlColumn)argItem.getData()) + " AND 0x" + Transform.transformHex((String)params[3], (SqlColumn)argItem.getData())) : (dbms.equalsIgnoreCase("POSTGRES") ? whereCond + SQLCONDITIONS.get(idx) + " bytea '\\x" + Transform.transformHex((String)params[2], (SqlColumn)argItem.getData()) + "'" : whereCond + SQLCONDITIONS.get(idx) + "0x" + Transform.transformHex((String)params[2], (SqlColumn)argItem.getData()));
                        viewWhereConditions.put(currLayout.toLowerCase() + "." + fname, whereCond);
                    } else {
                        argItem = Transform.getItemInLayout(fname, currLayout);
                        idx = CONDITIONS.indexOf((String)params[0]);
                        whereCond = ((String)params[0]).contains("BETWEEN") ? (dbms.equalsIgnoreCase("POSTGRES") ? whereCond + SQLCONDITIONS.get(idx) + " bytea '\\x" + Transform.transformHex((String)params[1], (SqlColumn)argItem.getData()) + "' AND  bytea '\\x" + Transform.transformHex((String)params[2], (SqlColumn)argItem.getData()) + "'" : whereCond + SQLCONDITIONS.get(idx) + "0x" + Transform.transformHex((String)params[1], (SqlColumn)argItem.getData()) + " AND 0x" + Transform.transformHex((String)params[2], (SqlColumn)argItem.getData())) : (dbms.equalsIgnoreCase("POSTGRES") ? whereCond + SQLCONDITIONS.get(idx) + " bytea '\\x" + Transform.transformHex((String)params[1], (SqlColumn)argItem.getData()) + "'" : whereCond + SQLCONDITIONS.get(idx) + "0x" + Transform.transformHex((String)params[1], (SqlColumn)argItem.getData()));
                        viewWhereConditions.put(currLayout.toLowerCase() + "_" + fname, whereCond);
                    }
                } else {
                    System.out.println("Unable to extract WHEN conitional info for:" + currLayout + "." + nodeAttrMap.getNamedItem("name").getNodeValue());
                }
            }
            Node redefAttr = nodeAttrMap.getNamedItem("redefines");
            String fieldName = nodeAttrMap.getNamedItem("name").getNodeValue().toUpperCase();
            if (redefAttr != null) {
                String redefMap;
                String redefines = nodeAttrMap.getNamedItem("redefines").getNodeValue().toUpperCase();
                if (redefiningMap.containsKey(currLayout + "." + redefines)) {
                    redefines = redefiningMap.get(currLayout + "." + redefines);
                }
                if (Transform.processIterRedefines(fieldName, redefines, fieldNode) || (redefMap = Transform.locatefield(redefines)) == null || !redefMap.equalsIgnoreCase(fieldName)) continue;
                redefProcess.remove(currLayout + "." + redefines);
            } else if (redefinedList.contains(currLayout + "." + fieldName)) {
                if (Transform.processIterRedefines(fieldName, fieldName, fieldNode)) continue;
                redefProcess.add(currLayout + "." + fieldName);
                String redefMap = Transform.locatefield(fieldName);
                if (redefMap != null && !redefMap.equalsIgnoreCase(fieldName)) continue;
                redefProcess.remove(currLayout + "." + fieldName);
            }
            if (fieldNode.hasChildNodes()) {
                Transform.processFields(fieldNode.getChildNodes());
                continue;
            }
            BufferedWriter currBw = bwRedef != null ? bwRedef : bw;
            currBw.write("<column name=\"" + fieldName + "\" offset=\"" + nodeAttrMap.getNamedItem("offset").getNodeValue() + "\" length=\"" + nodeAttrMap.getNamedItem("length").getNodeValue() + "\" piclen=\"" + nodeAttrMap.getNamedItem("piclen").getNodeValue() + "\" sqltype=\"" + nodeAttrMap.getNamedItem("sqltype").getNodeValue());
            if (nodeAttrMap.getNamedItem("place") != null) {
                currBw.write("\" place=\"" + nodeAttrMap.getNamedItem("place").getNodeValue() + "\"/>\n");
                continue;
            }
            currBw.write("\"/>\n");
        }
    }

    private static String locatefield(String fieldName) {
        if (redefUseMap.containsKey(fieldName)) {
            return redefUseMap.get(fieldName);
        }
        if (redefUseMap.containsKey(currLayout + "." + fieldName)) {
            return redefUseMap.get(currLayout + "." + fieldName);
        }
        return null;
    }

    private static void translateCharset(byte[] inBytes, int off, int len) {
        for (int i = off; i < inBytes.length && i < off + len; ++i) {
            inBytes[i] = inBytes[i] < 0 ? input2outputByteMap[256 + inBytes[i]] : input2outputByteMap[inBytes[i]];
        }
    }

    public static void translateSigned(byte[] inBytes, boolean islead, int off, int len, boolean isAsc2Ebc) {
        byte bb = islead ? inBytes[off] : inBytes[off + len - 1];
        if (isAsc2Ebc) {
            for (int i = 0; i < 20; ++i) {
                if (bb != signedAscToEbcMap[i][0]) continue;
                bb = signedAscToEbcMap[i][1];
                break;
            }
        } else {
            for (int i = 0; i < 20; ++i) {
                if (bb != signedAscToEbcMap[i][1]) continue;
                bb = signedAscToEbcMap[i][0];
                break;
            }
        }
        if (islead) {
            inBytes[off] = bb;
            Transform.translateCharset(inBytes, off + 1, len - 1);
        } else {
            inBytes[off + len - 1] = bb;
            Transform.translateCharset(inBytes, off, len - 1);
        }
    }

    private static Object extractDataType(Object obj1, Object sqlObj) {
        if (obj1 == null) {
            return null;
        }
        try {
            SqlColumn sqlWork = ((SqlColumn)sqlObj).createWorkingCopy();
            sqlWork.updateColumn((byte[])obj1, 0, (byte[])obj1);
            return sqlWork.getIDataTypeColumn();
        }
        catch (Exception err) {
            Transform.writeOut("[ERROR] extractDataType:-");
            err.printStackTrace();
            Transform.exitOut(0);
            return null;
        }
    }

    private static void extractRedefines(BatchTreeItem Item, Vector<Object> newlayout, byte[] buf, boolean prompt) {
        if (Item.getItemCount() == 0) {
            newlayout.add(Item.getData());
        } else {
            for (BatchTreeItem itm : Item.getItems()) {
                if (itm.getText(0).contains(REDEFINES_TXT)) continue;
                if (itm.getItemCount() == 0) {
                    newlayout.add(itm.getData());
                }
                if (itm.getItemCount() <= 0 || itm.getData(REDEFINED) == null) continue;
                Transform.processRedefines(itm, newlayout, buf, prompt);
            }
        }
    }

    private static void processRedefines(BatchTreeItem redefinedItem, Vector<Object> newlayout, byte[] buf, boolean prompt) {
        Object data = redefinedItem.getData(REDEFINED);
        if (data != null) {
            ArrayList redefines = (ArrayList)data;
            if (prompt) {
                Transform.extractRedefines(redefinedItem, newlayout, buf, prompt);
            } else {
                for (int i = 0; i < redefines.size(); ++i) {
                    Object[] condParams = (Object[])((BatchTreeItem)redefines.get(i)).getData(XFD_WHEN);
                    BatchTreeItem condItem = Transform.getItemInLayout((String)condParams[4], (BatchTreeItem)redefines.get(i));
                    if (!Transform.checkXFDCondition(buf, condItem.getData(), Transform.extractDataType(condParams[1], condParams[0]), Transform.extractDataType(condParams[2], condParams[0]), condParams[3])) continue;
                    Transform.extractRedefines((BatchTreeItem)redefines.get(i), newlayout, buf, prompt);
                    return;
                }
                Transform.extractRedefines(redefinedItem, newlayout, buf, prompt);
            }
        }
    }

    private static Vector<Object> extractRedefines(Vector<Object> layout, byte[] buf, boolean prompt) {
        useDefaultRedef = false;
        Vector<Object> newLayout = new Vector<Object>(layout.size());
        for (Object obj : layout) {
            if (obj instanceof BatchTreeItem) {
                Transform.processRedefines((BatchTreeItem)obj, newLayout, buf, prompt);
                continue;
            }
            newLayout.addElement(obj);
        }
        return newLayout;
    }

    private static boolean checkXFDCondition(byte[] buf, Map.Entry<Object, Object[]> keyval) {
        Object sqlObject = keyval.getKey();
        for (int i = 0; i < ((SqlColumn)sqlObject).getComponentCount(); ++i) {
            if (((SqlColumn)sqlObject).getOffset(i) + ((SqlColumn)sqlObject).getLength(i) <= buf.length) continue;
            Transform.writeOut("Record layout XFD Condition byte error: Record #" + recCntr + " length=" + inbytes.length + " bytes Field:" + ((SqlColumn)sqlObject).getName() + " Offset:" + ((SqlColumn)sqlObject).getOffset(i) + " Length:" + ((SqlColumn)sqlObject).getLength(i));
            badRecord = true;
            return false;
        }
        Object[] objArray = keyval.getValue();
        Object operand1 = objArray[0];
        Object operand2 = objArray[1];
        String cond = (String)objArray[2];
        return Transform.checkXFDCondition(buf, sqlObject, operand1, operand2, cond);
    }

    private static boolean checkXFDCondition(byte[] buf, Object sqlObject, Object operand1, Object operand2, Object cond) {
        try {
            ((SqlColumn)sqlObject).snagValue(buf, 0);
            IDatatype operand0 = ((SqlColumn)sqlObject).getIDataTypeColumn();
            int compare1 = Transform.compareOperands(operand0, operand1);
            if (cond.equals(CONDITIONS.get(0))) {
                return compare1 <= 0;
            }
            if (cond.equals(CONDITIONS.get(1))) {
                return compare1 < 0;
            }
            if (cond.equals(CONDITIONS.get(2))) {
                return compare1 == 0;
            }
            if (cond.equals(CONDITIONS.get(3))) {
                return compare1 >= 0;
            }
            if (cond.equals(CONDITIONS.get(4))) {
                return compare1 > 0;
            }
            if (cond.equals(CONDITIONS.get(5))) {
                int compare2 = Transform.compareOperands(operand0, operand2);
                return compare1 >= 0 && compare2 <= 0;
            }
            if (cond.equals(CONDITIONS.get(6))) {
                return compare1 > 0;
            }
            if (cond.equals(CONDITIONS.get(7))) {
                return compare1 >= 0;
            }
            if (cond.equals(CONDITIONS.get(8))) {
                return compare1 != 0;
            }
            if (cond.equals(CONDITIONS.get(9))) {
                return compare1 < 0;
            }
            if (cond.equals(CONDITIONS.get(10))) {
                return compare1 <= 0;
            }
            if (cond.equals(CONDITIONS.get(11))) {
                int compare2 = Transform.compareOperands(operand0, operand2);
                return compare1 < 0 || compare2 > 0;
            }
            return true;
        }
        catch (Exception err) {
            Transform.writeOut("[ERROR] checkXFDCondition:");
            err.printStackTrace();
            Transform.exitOut(0);
            return false;
        }
    }

    private static int compareOperands(Object op0, Object op1) {
        try {
            if (op0 instanceof Variable) {
                return ((Variable)op0).compare((Variable)op1);
            }
            if (op1 instanceof BignumType) {
                return ((BignumType)op0).compare((BignumType)op1);
            }
            if (op1 instanceof Comp1) {
                return ((Comp1)op0).compare((Comp1)op1);
            }
            if (op1 instanceof Comp2) {
                return ((Comp2)op0).compare((Comp2)op1);
            }
            if (op1 instanceof Numeric) {
                return ((Numeric)op0).compare((Numeric)op1);
            }
            new Exception("Unknown dataType encountered during comparison:" + op0.toString());
            return 0;
        }
        catch (Exception err) {
            Transform.writeOut("[ERROR] compareOperands:");
            err.printStackTrace();
            Transform.exitOut(0);
            return 0;
        }
    }

    private static Vector<Object> determineRowLayout(byte[] buf) {
        Iterator<Map.Entry<Vector<Object>, HashMap<Object, Object[]>>> it = xfdCondMap.entrySet().iterator();
        boolean found = false;
        while (it.hasNext()) {
            Map.Entry<Vector<Object>, HashMap<Object, Object[]>> keyvalue = it.next();
            HashMap<Object, Object[]> condMap = keyvalue.getValue();
            Iterator<Map.Entry<Object, Object[]>> condIt = condMap.entrySet().iterator();
            found = true;
            while (condIt.hasNext()) {
                Map.Entry<Object, Object[]> keyval = condIt.next();
                if (!Transform.checkXFDCondition(buf, keyval)) {
                    found = false;
                    break;
                }
                if (!badRecord) continue;
                return xfdMap.get(0);
            }
            if (badRecord) {
                return xfdMap.get(0);
            }
            if (!found) continue;
            return keyvalue.getKey();
        }
        return xfdMap.get(0);
    }

    static void writeOut(String messg) {
        System.out.println(messg);
        if (logfile != null) {
            logfile.println(messg);
        }
    }

    static void exitOut(int exitCode) {
        if (logfile != null) {
            logfile.close();
        }
        System.exit(exitCode);
    }

    static {
        CURR_PROF_VERSION = "1";
        CURR_RFS_VERSION = "1";
        sqluser = "";
        sqlpasswd = "";
        sqlurl = "";
        sqldriver = "";
        sqlautocommit = "";
        sqlisolation = "";
        sqlcatalog = "";
        sqlreadonly = "";
        inDsnName = "";
        inDsnPath = "";
        dcbDBMode = "";
        dcbDBDriver = "";
        dcbDBDriverJar = "";
        dcbDBUrl = "";
        dcbDBUser = "";
        dcbDBPass = "";
        dcbDBTblExt = "";
        convert = "";
        convertRange = "";
        in_dsorg = null;
        in_orient = null;
        in_recfm = null;
        in_proto = null;
        in_recmin = -1;
        in_recavg = -1;
        in_lrecl = -1;
        in_blksize = -1;
        in_limit = -1;
        in_keylen = null;
        in_keyoff = null;
        in_altkeyoffs = null;
        in_altkeylens = null;
        in_altkeydups = null;
        in_altkeygroups = null;
        in_label = -1;
        in_expdt = null;
        in_reuse = null;
        in_relate = null;
        in_associates = null;
        in_charset = null;
        in_path = null;
        outDsnName = "";
        outDsnPath = "";
        outOrient = "";
        outFormat = "";
        outPrimaryOffsets = "";
        outPrimaryLengths = "";
        outPrimaryTypes = "";
        outRelKeyLength = "";
        outAltOffsets = "";
        outAltLengths = "";
        outAltTypes = "";
        outAltDups = "";
        outAltGroups = "";
        outRecMin = "";
        recMin = -1;
        outRecMax = "";
        recMax = -1;
        outRecAvg = "";
        recAvg = -1;
        outProtocol = "";
        outCharset = "";
        outVDBIdxInfo = new HashMap<String, Object>(0);
        outVDBViews = new ArrayList(0);
        rfsLoc = "";
        outAppend = "";
        IS_BATCH_INSERT_MODE = "";
        BATCH_INSERT_SIZE = "";
        XFD_WHEN = "COND";
        REDEFINES_TXT = " redefines ";
        REDEFINED = "REDEFINED";
        profFileLoc = "";
        READ = "READ";
        WRITE = "WRITE";
        READWRITE = "READWRITE";
        EXTEND = "EXTEND";
        CONDITIONS = new ArrayList<String>(Arrays.asList("IS < OR = TO", "IS < THAN", "IS = TO", "IS > OR = TO", "IS > THAN", "IS BETWEEN", "NOT < OR = TO", "NOT < THAN", "NOT = TO", "NOT > OR = TO", "NOT > THAN", "NOT BETWEEN"));
        SQLCONDITIONS = new ArrayList<String>(Arrays.asList(" <= ", " < ", " = ", " >= ", " > ", " BETWEEN ", " > ", " >= ", " != ", " < ", " <= ", " NOT BETWEEN "));
        recFrom = 0;
        recTo = 0;
        readCnt = 0;
        dupCnt = 0;
        writeCnt = 0;
        dupFailCnt = 0;
        inbytes = null;
        useDefaultRedef = false;
        outDCBIsNumbered = false;
        outDCBIsIndexed = false;
        hasMultipleLayouts = false;
        hasSingleLayout = false;
        hasNoLayouts = false;
        xfdAvail = false;
        noConv = true;
        asc2ebc = false;
        quietMode = false;
        eclipseForeMode = false;
        loadFileCharset = "";
        transformFileCharset = "";
        warnxfdcharset = false;
        badrecordexit = false;
        norecvalidate = false;
        xfdXmlCharset = null;
        isLoadFileEBCIDIC = false;
        isTransformFileEBCIDIC = false;
        blockMaster = new ArrayList(255);
        ebcidicCodeSets = " 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 1140, 37-2, 38, 39, 40, 251, 252, 254, 256, 257, 258, 259, 260, 264, 273, 1141, 274, 275, 276, 277, 1142, 278, 1143, 279, 280, 1144, 281, 282, 283, 284, 1145, 285, 1146, 286, 287, 288, 289, 290, 293, 297, 1147, 298, 300, 310, 320, 321, 322, 330, 351, 352, 353, 355, 357, 358, 359, 360, 361, 363, 382, 383, 384, 385, 386, 387, 388, 389, 390, 391, 392, 393, 394, 395, 410, 420, 16804, 421, 423, 424, 8616, 12712, 425, 435, 500, 1148, 803, 829, 833, 834, 835, 836, 837, 838, 838, 839, 870, 1110, 1153, 871, 1149, 875, 4971, 9067, 880, 881, 882, 883, 884, 885, 886, 887, 888, 889, 890, 892, 893, 905, 918, 924, 930, 1390, 931, 933, 1364, 935, 1388, 937, 1371, 939, 1399, 1001, 1002, 1003, 1005, 1007, 1024, 1025, 1154, 1026, 1155, 1027, 1028, 1030, 1031, 1032, 1033, 1037, 1047, 1068, 1069, 1070, 1071, 1073, 1074, 1075, 1076, 1077, 1078, 1079, 1080, 1081, 1082, 1083, 1084, 1085, 1087, 1091, 1097, 1112, 1156, 1113, 1122, 1157, 1123, 1158, 1130, 1164, 1132, 1136, 1137, 1150, 1151, 1152, 1159, 1165, 1166, 1278, 1279, 1303, 1364, 1376, 1377, JEF, KEIS,";
        signedAscToEbcMap = new byte[][]{{48, -64}, {49, -63}, {50, -62}, {51, -61}, {52, -60}, {53, -59}, {54, -58}, {55, -57}, {56, -56}, {57, -55}, {112, -48}, {113, -47}, {114, -46}, {115, -45}, {116, -44}, {117, -43}, {118, -42}, {119, -41}, {120, -40}, {121, -39}};
        input2outputByteMap = new byte[256];
        XFDTree = new BatchTree(3);
        whenConds = new ArrayList();
        xfdCondMap = new HashMap();
        xfdMap = new Vector();
        xfdKeyValArgs = new TreeMap<String, String>();
        recCntr = 0;
        badRecord = false;
        includedLayouts = new ArrayList();
        excludedLayouts = new ArrayList();
        renamedLayouts = new HashMap();
        redefUseMap = new HashMap();
        redefIterFileMap = new HashMap();
        layoutRedefIterMap = new HashMap();
        whenCondMap = new HashMap();
        viewWhereConditions = new HashMap();
        useVarchar = "";
        varChar = false;
        genMatView = "";
        matView = false;
        dbms = "";
        xfdFileName = "";
        sqlFileName = "";
        bwRedef = null;
        sqlgen = new StringBuilder();
        defLayout = "";
        iterateRedef = false;
        datasetGroupID = "@@@@@";
        redefinesID = "~~~~~";
        redefProcess = new ArrayList();
        redefinedList = new ArrayList();
        redefiningMap = new HashMap();
        primaryInputXfdFileName = "";
        generateViews = false;
        sqlTranslateMap = new HashMap<Object, Integer[]>(50);
        signedTransform = 0;
        isXfdXmlEbcidic = false;
        timer = new Timer();
    }
}

