/*
 * Decompiled with CFR 0.152.
 */
package com.heirloomcomputing.ecs.xio;

import com.heirloomcomputing.ecs.isamsql.DCB;
import com.heirloomcomputing.ecs.isamsql.DCBFactory;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.time.LocalTime;
import java.util.Arrays;
import org.rocksdb.Options;
import org.rocksdb.RocksDB;
import org.rocksdb.RocksDBException;

public class ROXIndexUtils {
    public static void main(String[] args) {
        if (args.length < 3) {
            System.err.println("Invalid arguments received");
            ROXIndexUtils.printUsage();
            return;
        }
        System.out.println("Index creation initiated: " + LocalTime.now());
        String infile = args[0];
        int keyOffset = Integer.parseInt(args[1]);
        int keyLength = Integer.parseInt(args[2]);
        int recLength = 0;
        if (args.length > 3) {
            recLength = Integer.parseInt(args[3]);
        }
        try {
            if (recLength > 0) {
                ROXIndexUtils.createIndexObjects(infile, keyOffset, keyLength, recLength);
            } else {
                ROXIndexUtils.createIndexObjects(infile, keyOffset, keyLength);
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return;
        }
        System.out.println("Index creation complete : " + LocalTime.now());
    }

    public static void createIndexObjects(String inputFile, int keyOffset, int keyLength) throws FileNotFoundException {
        RocksDB rocksDBStore;
        RocksDB.loadLibrary();
        File f = new File(inputFile);
        if (!f.exists() || f.isDirectory()) {
            throw new FileNotFoundException(inputFile + "not found or is a directory");
        }
        String baseFileName = f.getName();
        String basePathName = f.getParent();
        DCB dcb = DCBFactory.getInstance(baseFileName, basePathName, true);
        String proto = "ROX";
        dcb.setRecordFormat(DCB.RecordFormat.VB);
        dcb.setOrganization(DCB.Organization.PS);
        try {
            dcb.setProtocol(proto);
        }
        catch (DCB.InvalidDCBException e1) {
            e1.printStackTrace();
        }
        dcb.setKeyOffset(new Integer[]{keyOffset});
        dcb.setKeyLength(new Integer[]{keyLength});
        dcb.saveDCB();
        String indexFileName = basePathName + File.separatorChar + baseFileName + "_rocksDBStore";
        Options options = new Options();
        options.setCreateIfMissing(true);
        if (new File(indexFileName).exists()) {
            try {
                RocksDB rocksDBStore2 = RocksDB.open((Options)options, (String)indexFileName);
            }
            catch (RocksDBException e) {
                e.printStackTrace();
            }
            return;
        }
        try {
            rocksDBStore = RocksDB.open((Options)options, (String)indexFileName);
        }
        catch (RocksDBException e) {
            e.printStackTrace();
            return;
        }
        long fpos = 0L;
        try (BufferedInputStream inputStream = new BufferedInputStream(new FileInputStream(inputFile));){
            int bytesRead = 0;
            boolean hasBytesToRead = true;
            while (hasBytesToRead) {
                byte[] recBytes;
                byte[] rdwBytes = new byte[4];
                bytesRead = inputStream.read(rdwBytes);
                if (bytesRead <= 0) {
                    break;
                }
                short rdw = ROXIndexUtils.getShort(rdwBytes, 0);
                if (rdw - 4 <= 0) {
                    System.err.println("rdw minus 4 <= 0. rdw: " + rdw);
                }
                if ((bytesRead = inputStream.read(recBytes = new byte[rdw - 4])) <= 0) {
                    break;
                }
                byte[] keyBytes = Arrays.copyOfRange(recBytes, keyOffset, keyLength);
                byte[] fposBytes = new byte[10];
                fposBytes[0] = rdwBytes[0];
                fposBytes[1] = rdwBytes[1];
                ROXIndexUtils.longToBytes(fpos, fposBytes, 2);
                rocksDBStore.put(keyBytes, fposBytes);
                fpos += (long)rdw;
            }
        }
        catch (IOException | RocksDBException ex) {
            ex.printStackTrace();
        }
        rocksDBStore.close();
    }

    public static void createIndexObjects(String inputFile, int keyOffset, int keyLength, int recLength) throws FileNotFoundException {
        RocksDB rocksDBStore;
        RocksDB.loadLibrary();
        File f = new File(inputFile);
        if (!f.exists() || f.isDirectory()) {
            throw new FileNotFoundException(inputFile + "not found or is a directory");
        }
        String baseFileName = f.getName();
        String basePathName = f.getParent();
        DCB dcb = DCBFactory.getInstance(baseFileName, basePathName, true);
        String proto = "ROX";
        dcb.setRecordFormat(DCB.RecordFormat.FB);
        dcb.setOrganization(DCB.Organization.PS);
        try {
            dcb.setProtocol(proto);
        }
        catch (DCB.InvalidDCBException e1) {
            e1.printStackTrace();
        }
        dcb.setKeyOffset(new Integer[]{keyOffset});
        dcb.setKeyLength(new Integer[]{keyLength});
        dcb.setLrecl(recLength);
        dcb.saveDCB();
        String indexFileName = basePathName + File.separatorChar + baseFileName + "_rocksDBStoreFixed";
        Options options = new Options();
        options.setCreateIfMissing(true);
        if (new File(indexFileName).exists()) {
            try {
                RocksDB rocksDBStore2 = RocksDB.open((Options)options, (String)indexFileName);
            }
            catch (RocksDBException e) {
                e.printStackTrace();
            }
            return;
        }
        try {
            rocksDBStore = RocksDB.open((Options)options, (String)indexFileName);
        }
        catch (RocksDBException e) {
            e.printStackTrace();
            return;
        }
        long fpos = 0L;
        try (BufferedInputStream inputStream = new BufferedInputStream(new FileInputStream(inputFile));){
            int bytesRead = 0;
            short rdw = (short)recLength;
            byte[] recBytes = new byte[rdw];
            byte[] rdwBytes = new byte[2];
            ROXIndexUtils.shortToByteArray(rdw, rdwBytes, 0);
            boolean hasBytesToRead = true;
            while (hasBytesToRead) {
                bytesRead = inputStream.read(recBytes);
                if (bytesRead <= 0) {
                    break;
                }
                byte[] keyBytes = Arrays.copyOfRange(recBytes, keyOffset, keyLength);
                byte[] fposBytes = new byte[10];
                fposBytes[0] = rdwBytes[0];
                fposBytes[1] = rdwBytes[1];
                ROXIndexUtils.longToBytes(fpos, fposBytes, 2);
                rocksDBStore.put(keyBytes, fposBytes);
                fpos += (long)rdw;
            }
        }
        catch (IOException | RocksDBException ex) {
            ex.printStackTrace();
        }
        rocksDBStore.close();
    }

    public static void createIndexData(String inputFile, int keyOffset, int keyLength) throws FileNotFoundException {
        RocksDB rocksDBStore;
        RocksDB.loadLibrary();
        File f = new File(inputFile);
        if (!f.exists() || f.isDirectory()) {
            throw new FileNotFoundException(inputFile + "not found or is a directory");
        }
        String baseFileName = f.getName();
        String basePathName = f.getParent();
        String indexFileName = basePathName + File.separatorChar + baseFileName + "_levelDBDataStore";
        Options options = new Options();
        options.setCreateIfMissing(true);
        if (new File(indexFileName).exists()) {
            try {
                RocksDB rocksDBStore2 = RocksDB.open((Options)options, (String)indexFileName);
            }
            catch (RocksDBException e) {
                e.printStackTrace();
            }
            return;
        }
        try {
            rocksDBStore = RocksDB.open((Options)options, (String)indexFileName);
        }
        catch (RocksDBException e) {
            e.printStackTrace();
            return;
        }
        try (BufferedInputStream inputStream = new BufferedInputStream(new FileInputStream(inputFile));){
            int bytesRead = 0;
            boolean hasBytesToRead = true;
            while (hasBytesToRead) {
                byte[] recBytes;
                byte[] rdwBytes = new byte[4];
                bytesRead = inputStream.read(rdwBytes);
                if (bytesRead <= 0) {
                    break;
                }
                short rdw = ROXIndexUtils.getShort(rdwBytes, 0);
                if (rdw - 4 <= 0) {
                    System.err.println("rdw minus 4 <= 0. rdw: " + rdw);
                }
                if ((bytesRead = inputStream.read(recBytes = new byte[rdw - 4])) <= 0) {
                    break;
                }
                rocksDBStore.put(Arrays.copyOfRange(recBytes, keyOffset, keyLength), recBytes);
            }
        }
        catch (IOException | RocksDBException ex) {
            ex.printStackTrace();
        }
        rocksDBStore.close();
    }

    private static void printUsage() {
        System.err.println();
        System.err.println("******************************************************************************************************************");
        System.err.println("*****************************                 ROXIndexUtils usage                 ********************************");
        System.err.println("******************************************************************************************************************");
        System.err.println();
        System.err.println("******************************************************************************************************************");
        System.err.println("*****************************                 Variable length files               ********************************");
        System.err.println("******************************************************************************************************************");
        System.err.println();
        System.err.println("java -cp ecobol.jar[;|:]rocksdbjni.jar com.heirloomcomputing.ecs.xio.ROXIndexUtils inputfile, keyOffset, keyLength");
        System.err.println();
        System.err.println("inputfile is String representation of full path and file name");
        System.err.println("keyOffset is int");
        System.err.println("keyLength is int");
        System.err.println();
        System.err.println("******************************************************************************************************************");
        System.err.println("*****************************                 Fixed length files                  ********************************");
        System.err.println("******************************************************************************************************************");
        System.err.println();
        System.err.println("java -cp ecobol.jar[;|:]rocksdbjni.jar com.heirloomcomputing.ecs.xio.ROXIndexUtils inputfile, keyOffset, keyLength, recLength");
        System.err.println();
        System.err.println("inputfile is String representation of full path and file name");
        System.err.println("keyOffset is int");
        System.err.println("keyLength is int");
        System.err.println("recLength is int");
    }

    private static short getShort(byte[] arr, int off) {
        return (short)(arr[off] << 8 & 0xFF00 | arr[off + 1] & 0xFF);
    }

    private static int getInt(byte[] arr, int off) {
        return arr[off] << 8 & 0xFF00 | arr[off + 1] & 0xFF;
    }

    private static byte[] shortToBytes(short s) {
        return new byte[]{(byte)((s & 0xFF00) >> 8), (byte)(s & 0xFF)};
    }

    private static void longToByteArray(long value, byte[] array, int startFrom) {
        for (int i = 7; i >= 0; --i) {
            array[startFrom + 7 - i] = (byte)(value >> i * 8);
        }
    }

    public static byte[] longToByteArray(long value) {
        byte[] array = new byte[8];
        ROXIndexUtils.longToByteArray(value, array, 0);
        return array;
    }

    public static void longToBytes(long l, byte[] array, int offset) {
        for (int i = 7; i >= 0; --i) {
            array[offset + i] = (byte)(l & 0xFFL);
            l >>= 8;
        }
    }

    private static long bytesToLong(byte[] bytes, int offset) {
        long result = 0L;
        for (int i = offset; i < 8 + offset; ++i) {
            result <<= 8;
            result |= (long)(bytes[i] & 0xFF);
        }
        return result;
    }

    private static void shortToByteArray(short value, byte[] array, int startFrom) {
        for (int i = 1; i >= 0; --i) {
            array[startFrom + 1 - i] = (byte)(value >> i * 8);
        }
    }

    private static byte[] shortToByteArray(short value) {
        byte[] array = new byte[2];
        ROXIndexUtils.shortToByteArray(value, array, 0);
        return array;
    }
}

