/*
 * Decompiled with CFR 0.152.
 */
package com.heirloomcomputing.ecs.xio;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;
import redis.clients.jedis.Transaction;
import redis.clients.jedis.params.ScanParams;
import redis.clients.jedis.resps.ScanResult;

public class RedisUtil {
    static JedisPool REDIS_POOL;
    boolean isLogEnabled;

    public RedisUtil(String host, int port, boolean logEnabled) {
        host = Objects.isNull(host) ? "redis://localhost" : host;
        port = port == 0 ? 6379 : port;
        this.isLogEnabled = logEnabled;
        this.log("Connecting to Redis(" + host + "," + port + ")");
        URI uri = URI.create(host + ":" + port);
        if (REDIS_POOL == null) {
            JedisPoolConfig jedisPoolConfig = new JedisPoolConfig();
            jedisPoolConfig.setTestWhileIdle(true);
            jedisPoolConfig.setMinIdle(1);
            REDIS_POOL = new JedisPool((GenericObjectPoolConfig)jedisPoolConfig, uri);
        }
    }

    public RedisUtil(String host, int port) {
        host = Objects.isNull(host) ? "redis://localhost" : host;
        port = port == 0 ? 6379 : port;
        URI uri = URI.create(host + ":" + port);
        uri.getUserInfo();
        if (REDIS_POOL == null) {
            JedisPoolConfig jedisPoolConfig = new JedisPoolConfig();
            jedisPoolConfig.setTestWhileIdle(true);
            jedisPoolConfig.setMinIdle(1);
            jedisPoolConfig.setMaxTotal(10);
            REDIS_POOL = new JedisPool((GenericObjectPoolConfig)jedisPoolConfig, uri);
        }
    }

    private Jedis getConnection() {
        return REDIS_POOL.getResource();
    }

    public Map<String, String> fetchSetByKey(String key) {
        try (Jedis redis = this.getConnection();){
            Map hgetAll;
            Map map = hgetAll = redis.hgetAll(key);
            return map;
        }
    }

    public String fetchSetByKey(String key, String field) {
        try (Jedis redis = this.getConnection();){
            String string2 = redis.hget(key, field);
            return string2;
        }
    }

    public long insertSetByKey(String key, String field, String value) {
        try (Jedis redis = this.getConnection();){
            long l = redis.hset(key, field, value);
            return l;
        }
    }

    public List<String> getFetchByGeneric(String tableName, String key) {
        return this.getFetchByGeneric(tableName.getBytes(), key.getBytes());
    }

    public List<String> getFetchByGeneric(byte[] table, byte[] key) {
        ArrayList<String> keys = new ArrayList<String>();
        int cursor = 0;
        ScanParams sp = new ScanParams();
        sp.count(Integer.valueOf(1000));
        sp.match(key);
        byte[] tableNameWithSortedPrefix = this.appendPrefixToTableName(table);
        try (Jedis redis = this.getConnection();){
            do {
                ScanResult zscan = redis.zscan(tableNameWithSortedPrefix, String.valueOf(cursor).getBytes(), sp);
                String tableName = table != null ? new String(table) : "";
                List collect = zscan.getResult().stream().map(element -> tableName.concat(element.getElement())).collect(Collectors.toList());
                cursor = Integer.parseInt(zscan.getCursor());
                keys.addAll(collect);
            } while (cursor > 0);
        }
        this.log("Fetch By Generic(table:" + new String(table) + " key:" + new String(key) + ") Size:" + keys.size());
        return keys;
    }

    public String insertByKey(String key, String value) {
        return this.insertByKey(null, key, value);
    }

    public String insertByKey(String tableName, String key, String value) {
        byte[] tableNameByteArray = tableName != null ? tableName.getBytes() : null;
        byte[] insertByKey = this.insertByKey(tableNameByteArray, key.getBytes(), value.getBytes());
        return new String(insertByKey);
    }

    public void insertByKey(byte[] key, byte[] value) {
        this.insertByKey(null, key, value);
    }

    public byte[] insertByKey(byte[] tableName, byte[] key, byte[] value) {
        if (tableName == null) {
            tableName = new String("").getBytes();
        }
        byte[] keyCompound = this.appendBytes(tableName, key);
        this.log("Insert By (tableName:" + new String(tableName) + ",key:" + new String(key) + ") value:" + new String(keyCompound) + ")");
        try (Jedis redis = this.getConnection();){
            Transaction multi = redis.multi();
            multi.set(keyCompound, value);
            byte[] tableWithPrefix = this.appendPrefixToTableName(tableName);
            multi.zadd(tableWithPrefix, (double)System.nanoTime(), key);
            multi.exec();
            byte[] byArray = keyCompound;
            return byArray;
        }
    }

    public String fetchByKey(String key) {
        return this.fetchByKey(null, key);
    }

    public String fetchByKey(String tableName, String key) {
        byte[] tableNameByteArray = tableName != null ? tableName.getBytes() : null;
        byte[] insertedKey = this.fetchByKey(tableNameByteArray, key.getBytes());
        return insertedKey != null ? new String(insertedKey) : null;
    }

    public byte[] fetchByKey(byte[] key) {
        return this.fetchByKey(null, key);
    }

    public byte[] fetchByKey(byte[] tableName, byte[] key) {
        if (tableName == null) {
            tableName = new String("").getBytes();
        }
        this.log("Fetch By Key (tableName:" + new String(tableName) + ",key:" + new String(key) + ")");
        byte[] keyCompound = this.appendBytes(tableName, key);
        try (Jedis redis = this.getConnection();){
            byte[] byArray = redis.get(keyCompound);
            return byArray;
        }
    }

    private byte[] getMatchKey(byte[] key) {
        String STAR = "*";
        if (key == null || key.length == 0) {
            return STAR.getBytes();
        }
        String keyAsString = new String(key);
        if (keyAsString.endsWith(STAR)) {
            return key;
        }
        byte[] matchingKey = new byte[key.length + STAR.getBytes().length];
        System.arraycopy(key, 0, matchingKey, 0, key.length);
        System.arraycopy(STAR.getBytes(), 0, matchingKey, key.length, STAR.getBytes().length);
        return matchingKey;
    }

    private byte[] appendBytes(byte[] tableName, byte[] key) {
        byte[] keyCompound = new byte[tableName.length + key.length];
        System.arraycopy(tableName, 0, keyCompound, 0, tableName.length);
        System.arraycopy(key, 0, keyCompound, tableName.length, key.length);
        return keyCompound;
    }

    private void log(String message) {
        if (this.isLogEnabled) {
            System.out.println(message);
        }
    }

    private byte[] appendPrefixToTableName(byte[] tableName) {
        return this.appendBytes("SORTED_".getBytes(), tableName);
    }
}

