/*
 * Decompiled with CFR 0.152.
 */
package com.heirloomcomputing.ecs.zos;

import com.heirloomcomputing.ecs.exec.Context;
import com.heirloomcomputing.ecs.exec.LockFile;
import com.heirloomcomputing.ecs.exec.LogSetup;
import com.heirloomcomputing.ecs.exec.Numeric;
import com.heirloomcomputing.ecs.exec.RuntimeEnvironment;
import com.heirloomcomputing.ecs.exec.Utilities;
import com.heirloomcomputing.ecs.exec.Variable;
import com.heirloomcomputing.ecs.exec.seqFile;
import com.heirloomcomputing.ecs.zos.YFile;
import com.heirloomcomputing.ecs.zos.YFileException;

public class zOSSequentialFile
extends seqFile {
    private static final boolean on = true;
    private int openIOMode;
    private boolean isOpenIO;
    private boolean isOpenInput;
    private boolean isOpenOutput;
    private boolean isOpenOExtend;
    private boolean isOpenIExtend;
    private Command priorCommand;
    private zOSSequentialFile externalFile;
    private String protocol = null;
    private boolean remote = false;
    private int port;
    private String site;
    private boolean optional;
    private String assignTo;
    private int reserve;
    private boolean isRecords;
    private byte[] into;
    private int newModes = 0;
    private String filteredFilename;
    private int fileMarkerKeyOffset = 0;
    Class<?> zFileClass = null;
    YFile zFile = null;

    public zOSSequentialFile() {
    }

    public zOSSequentialFile(zOSSequentialFile copy) {
        this.isOpen = copy.isOpen;
        this.openIOMode = copy.openIOMode;
        this.isOpenIO = copy.isOpenIO;
        this.isOpenInput = copy.isOpenInput;
        this.isOpenOutput = copy.isOpenOutput;
        this.isOpenOExtend = copy.isOpenOExtend;
        this.isOpenIExtend = copy.isOpenIExtend;
        this.readable = copy.readable;
        this.writable = copy.writable;
        this.extend = copy.extend;
        this.priorErrorCode = copy.priorErrorCode;
        this.priorCommand = copy.priorCommand;
        this.externalFile = copy.externalFile;
        this.protocol = copy.protocol;
        this.remote = copy.remote;
        this.port = copy.port;
        this.site = copy.site;
        this.file = copy.file;
        this.filenameVariable = copy.filenameVariable;
        this.optional = copy.optional;
        this.assignTo = copy.assignTo;
        this.reserve = copy.reserve;
        this.fileStatus = copy.fileStatus;
        this.blockFrom = copy.blockFrom;
        this.blockTo = copy.blockTo;
        this.isRecords = copy.isRecords;
        this.minimum = copy.minimum;
        this.maximum = copy.maximum;
        this.into = copy.into;
        this.dependingOn = copy.dependingOn;
        this.newModes = copy.newModes;
        this.filteredFilename = copy.filteredFilename;
        this.fileMarkerKeyOffset = copy.fileMarkerKeyOffset;
        this.zFileClass = copy.zFileClass;
        this.zFile = copy.zFile;
    }

    @Override
    public zOSSequentialFile clone() {
        return new zOSSequentialFile(this);
    }

    @Override
    public void setFilename(String fn) {
        this.assignTo = fn;
    }

    @Override
    public String getFilename() {
        String filename = "";
        filename = this.filenameVariable != null ? this.filenameVariable.toString() : this.assignTo;
        if (filename != null) {
            filename = filename.trim();
        }
        return filename;
    }

    private String getFilteredFilename() {
        String filename = "";
        filename = this.filenameVariable != null ? this.filenameVariable.toString() : this.assignTo;
        return this.filterFilename(filename);
    }

    private String getAConnectFilename(String filename) {
        if (filename == null || filename.trim().length() == 0) {
            return null;
        }
        if (filename.trim().charAt(0) == '@') {
            return filename;
        }
        String name = RuntimeEnvironment.getGlobalParameter(filename);
        if (name == null || name.trim().length() == 0) {
            return null;
        }
        if (name.trim().charAt(0) == '@') {
            return name;
        }
        return null;
    }

    private String filterFilename(String filename) {
        String temp;
        if (filename != null) {
            filename = filename.trim();
        }
        if ((temp = this.getAConnectFilename(filename)) != null) {
            filename = temp;
            this.protocol = "ACON";
        } else {
            String envname;
            if (filename.startsWith("env:") && (filename = RuntimeEnvironment.getGlobalParameter(envname = filename.substring(4))) == null) {
                filename = envname;
            }
            filename = this.filterRemote(filename);
            filename = this.filterProtocol(filename);
        }
        return filename;
    }

    private String filterProtocol(String filename) {
        if (filename == null) {
            return null;
        }
        this.protocol = null;
        int index = filename.indexOf(58);
        if (index >= 2) {
            this.protocol = filename.substring(0, index);
            filename = index < filename.length() - 1 ? filename.substring(index + 1) : "";
        }
        return filename;
    }

    private String filterRemote(String filename) {
        if (filename == null) {
            return null;
        }
        if ((filename = filename.trim()).toLowerCase().startsWith("remote:")) {
            int index = 7;
            if (index >= filename.length()) {
                return "";
            }
            filename = filename.substring(index);
            filename = this.setRemote(filename);
        }
        return filename;
    }

    private String setRemote(String filename) {
        if (filename == null) {
            return null;
        }
        this.remote = true;
        this.filenameVariable = null;
        this.site = null;
        int index = filename.indexOf(58);
        if (index >= 0) {
            this.site = filename.substring(0, index);
            filename = index < filename.length() - 1 ? filename.substring(index + 1) : "";
        }
        if (this.site == null) {
            try {
                this.site = Utilities.getCodeBase().toString();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.site == null) {
            this.site = RuntimeEnvironment.getGlobalParameter("REMOTEHOST");
        }
        if (this.site == null) {
            this.site = "127.0.0.1";
        }
        index = filename.indexOf(58);
        this.port = 6584;
        if (index >= 0) {
            if (index < filename.length() - 1) {
                try {
                    this.port = Integer.decode(filename.substring(index + 1));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            filename = filename.substring(0, index);
        }
        if (Context.getGlobalFileCharacter() != '/') {
            int i = 0;
            do {
                if ((i = filename.indexOf(47, i)) < 0) continue;
                filename = filename.substring(0, i - 1) + '/' + filename.substring(i);
                i += 2;
            } while (i >= 0);
            i = 0;
            do {
                if ((i = filename.indexOf(Context.getGlobalFileCharacter(), i)) < 0) continue;
                filename = filename.substring(0, i - 1) + Context.getGlobalFileCharacter() + filename.substring(i + 1);
                ++i;
            } while (i >= 0);
        }
        return filename;
    }

    @Override
    public String toString() {
        try {
            String linesep = System.getProperty("line.separator");
            if (linesep == null) {
                linesep = "\n";
            }
            StringBuffer result = new StringBuffer();
            result.append("ORGANIZATION IS SEQUENTIAL").append(linesep);
            result.append("ACCESS MODE IS SEQUENTIAL").append(linesep);
            result.append((this.optional ? "" : "NOT-") + "OPTIONAL").append(linesep);
            if (this.filenameVariable != null) {
                result.append("ASSIGN TO ").append(this.filenameVariable.getName()).append("=\"").append(this.filenameVariable.toString()).append("\"").append(linesep);
            } else if (this.file != null) {
                result.append("ASSIGN TO \"").append(this.getFilename()).append("\"").append(linesep);
            }
            result.append("SYSTEM FILENAME W/O PROTOCOL IS " + this.filteredFilename).append(linesep);
            result.append("FILE IS " + (this.isOpen ? "OPENED" : "CLOSED")).append(linesep);
            if (this.fileStatus != null) {
                result.append("FILE STATUS IS ").append(this.fileStatus.getName()).append("=").append(this.fileStatus.toDisplayString()).append(linesep);
            }
            if (this.minimum == this.maximum) {
                result.append("RECORDING MODE IS FIXED").append(linesep);
            } else {
                result.append("RECORDING MODE IS VARIABLE").append(linesep);
            }
            if (this.minimum != -1 || this.maximum != -1) {
                if (this.minimum >= this.maximum) {
                    result.append("RECORD CONTAINS ").append(this.minimum).append(" CHARACTERS").append(linesep);
                } else {
                    result.append("RECORD CONTAINS ").append(this.minimum).append(" TO ").append(this.maximum).append(" CHARACTERS").append(linesep);
                }
            }
            if (this.dependingOn != null) {
                result.append("DEPENDING ON ").append(this.dependingOn.getName()).append('=').append(this.dependingOn.toInt()).append(linesep);
            }
            if (this.blockFrom != 0 || this.blockTo != 0) {
                String type = null;
                type = this.isRecords ? " RECORDS" : " CHARACTERS";
                if (this.blockFrom >= this.blockTo) {
                    result.append("BLOCK CONTAINS ").append(this.blockFrom).append(type).append(linesep);
                } else {
                    result.append("BLOCK CONTAINS ").append(this.blockFrom).append(" TO ").append(this.blockTo).append(type).append(linesep);
                }
            }
            result.append("PROTOCOL IS: " + this.protocol).append(linesep);
            if (this.remote) {
                result.append("IS REMOTE (HOST='" + this.site + "', PORT='" + this.port + "')").append(linesep);
            }
            result.append("OPEN INPUT/OUTPUT MODE IS: " + this.openIOMode).append(linesep);
            result.append((this.isOpenInput ? "" : "NOT ") + "OPEN INPUT").append(linesep);
            result.append((this.isOpenOutput ? "" : "NOT ") + "OPEN OUTPUT").append(linesep);
            result.append((this.isOpenIO ? "" : "NOT ") + "OPEN IO").append(linesep);
            result.append((this.readable ? "" : "NOT ") + "READABLE").append(linesep);
            result.append((this.writable ? "" : "NOT ") + "writable").append(linesep);
            result.append((this.extend ? "" : "NOT ") + "EXTEND").append(linesep);
            return result.toString();
        }
        catch (RuntimeException t) {
            return "INDEXED FILE";
        }
    }

    @Override
    public seqFile declare(boolean optional, Variable filenameVariable, int reserve, Variable paddingId, char paddingChar, Variable fileStatus, int blockFrom, int blockTo, boolean isRecords, int recordFrom, int recordTo, Variable dependingOn, boolean isLabelRecordsOmitted, Variable linageId, int linage, Variable footingId, int footing, Variable topId, int top, Variable bottomId, int bottom, String codeSet, int newModes) {
        this.newModes = newModes;
        return this.declare(optional, filenameVariable, reserve, paddingId, paddingChar, fileStatus, blockFrom, blockTo, isRecords, recordFrom, recordTo, dependingOn, isLabelRecordsOmitted, linageId, linage, footingId, footing, topId, top, bottomId, bottom, codeSet);
    }

    @Override
    public seqFile declare(boolean optional, Variable filenameVariable, int reserve, Variable paddingId, char paddingChar, Variable fileStatus, int blockFrom, int blockTo, boolean isRecords, int recordFrom, int recordTo, Variable dependingOn, boolean isLabelRecordsOmitted, Variable linageId, int linage, Variable footingId, int footing, Variable topId, int top, Variable bottomId, int bottom, String codeSet) {
        this.filenameVariable = filenameVariable;
        if (filenameVariable != null) {
            this.assignTo = filenameVariable.toString();
        }
        return this.declare(optional, this.assignTo, reserve, paddingId, paddingChar, fileStatus, blockFrom, blockTo, isRecords, recordFrom, recordTo, dependingOn, isLabelRecordsOmitted, linageId, linage, footingId, footing, topId, top, bottomId, bottom, codeSet);
    }

    @Override
    public seqFile declare(boolean optional, String assignTo, int reserve, Variable paddingId, char paddingChar, Variable fileStatus, int blockFrom, int blockTo, boolean isRecords, int recordFrom, int recordTo, Variable dependingOn, boolean isLabelRecordsOmitted, Variable linageId, int linage, Variable footingId, int footing, Variable topId, int top, Variable bottomId, int bottom, String codeSet, int newModes) {
        this.newModes = newModes;
        return this.declare(optional, assignTo, reserve, paddingId, paddingChar, fileStatus, blockFrom, blockTo, isRecords, recordFrom, recordTo, dependingOn, isLabelRecordsOmitted, linageId, linage, footingId, footing, topId, top, bottomId, bottom, codeSet);
    }

    @Override
    public seqFile declare(boolean optional, String assignTo, int reserve, Variable paddingId, char paddingChar, Variable fileStatus, int blockFrom, int blockTo, boolean isRecords, int recordFrom, int recordTo, Variable dependingOn, boolean isLabelRecordsOmitted, Variable linageId, int linage, Variable footingId, int footing, Variable topId, int top, Variable bottomId, int bottom, String codeSet) {
        this.optional = optional;
        if (assignTo != null && this.assignTo == null) {
            this.assignTo = assignTo;
        }
        this.reserve = reserve;
        this.fileStatus = fileStatus;
        this.blockFrom = blockFrom;
        this.blockTo = blockTo;
        this.isRecords = isRecords;
        this.minimum = recordFrom;
        this.maximum = recordTo;
        this.dependingOn = dependingOn;
        if (recordFrom != -1 || recordTo != -1) {
            this.into = recordFrom >= recordTo ? new byte[recordFrom] : new byte[recordTo];
        }
        this.endDeclare();
        this.priorCommand = Command.DECLARE;
        return this;
    }

    @Override
    public seqFile endDeclare() {
        this.filteredFilename = this.getFilteredFilename();
        return this;
    }

    @Override
    public boolean open(int mode) {
        this.openIOMode = mode;
        this.readable = (mode & 1) == 1;
        this.writable = (mode & 2) == 2;
        this.extend = (mode & 4) == 4;
        this.isOpenIO = this.readable && this.writable;
        this.isOpenInput = this.readable && !this.writable;
        this.isOpenOutput = !this.readable && this.writable;
        this.isOpenOExtend = !this.readable && this.extend;
        this.isOpenIExtend = this.readable && this.extend;
        String zFileName = "";
        String zFileOptions = "";
        zFileName = this.filteredFilename.contains(".") || this.filteredFilename.contains("(") ? "//'" + this.filteredFilename.toUpperCase() + "'" : "//DD:" + this.filteredFilename.toUpperCase();
        if (this.isOpenIExtend) {
            zFileOptions = "ab+";
        } else if (this.isOpenOExtend) {
            zFileOptions = "ab";
        } else if (this.isOpenIO) {
            zFileOptions = "rb+";
        } else if (this.isOpenInput) {
            zFileOptions = "rb";
        } else if (this.isOpenOutput) {
            zFileOptions = "wb";
        }
        if (this.isRecords) {
            zFileOptions = zFileOptions + ",type=record";
        }
        try {
            if (LogSetup.IS_LOGGING) {
                LogSetup.LOGGER.finer("new ZFile(\"" + zFileName + "\",\"" + zFileOptions + "\")");
            }
            this.zFile = new YFile(zFileName, zFileOptions);
            this.iostatus(0);
            this.isOpen = true;
        }
        catch (NoClassDefFoundError e) {
            this.iostatus(-30);
            if (LogSetup.IS_LOGGING) {
                LogSetup.LOGGER.severe("ZFile NoClassDefFoundError:  include ibmjzos.jar in CLASSPATH, its associated native library in LIBPATH, and only run on z/OS");
            }
            this.isOpenIExtend = false;
            this.isOpenOExtend = false;
            this.isOpenIO = false;
            this.isOpenOutput = false;
            this.isOpenInput = false;
            this.isOpen = false;
        }
        catch (UnsatisfiedLinkError e) {
            this.iostatus(-30);
            if (LogSetup.IS_LOGGING) {
                LogSetup.LOGGER.severe("ZFile UnsatisfiedLinkError:  include ibmjzos.jar in CLASSPATH, its associated native library in LIBPATH, and only run on z/OS");
            }
            this.isOpenIExtend = false;
            this.isOpenOExtend = false;
            this.isOpenIO = false;
            this.isOpenOutput = false;
            this.isOpenInput = false;
            this.isOpen = false;
        }
        catch (YFileException e) {
            this.iostatus(-30);
            if (LogSetup.IS_LOGGING) {
                LogSetup.LOGGER.severe("YFile exception: " + e.toString());
            }
            this.isOpenIExtend = false;
            this.isOpenOExtend = false;
            this.isOpenIO = false;
            this.isOpenOutput = false;
            this.isOpenInput = false;
            this.isOpen = false;
        }
        this.priorCommand = Command.OPEN;
        return this.isOpen;
    }

    @Override
    public boolean openTimeoutSeconds(int mode, Numeric timeout) {
        mode = LockFile.transformOpenMode(mode);
        int timeout_mask = 0x2100000;
        mode &= ~timeout_mask;
        double seconds = timeout.toDouble();
        boolean success = false;
        long currentTime = System.currentTimeMillis();
        long finalTime = currentTime + (long)(seconds * 1000.0);
        do {
            this.iostatus(0);
            success = this.open(mode);
            if (success || System.currentTimeMillis() >= finalTime) continue;
            try {
                Thread.sleep(500L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        } while (!success && System.currentTimeMillis() < finalTime);
        return success;
    }

    @Override
    public boolean openTimeoutRetries(int mode, Numeric timeout) {
        mode = LockFile.transformOpenMode(mode);
        int timeout_mask = 0x2100000;
        mode &= ~timeout_mask;
        int attempts = timeout.toInt();
        if (attempts < 0) {
            attempts = 0;
        }
        ++attempts;
        boolean success = false;
        do {
            this.iostatus(0);
            success = this.open(mode);
            if (success || --attempts <= 0) continue;
            try {
                Thread.sleep(500L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        } while (!success && attempts > 0);
        return success;
    }

    @Override
    public boolean openTimeoutRetries(int mode) {
        mode = LockFile.transformOpenMode(mode);
        mode &= 0xFDEFFFFF;
        boolean success = false;
        do {
            this.iostatus(0);
            success = this.open(mode);
            if (success) continue;
            try {
                Thread.sleep(500L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        } while (!success);
        return success;
    }

    @Override
    public boolean close() {
        return this.close(0);
    }

    @Override
    public boolean close(int mode) {
        if (!this.isOpen) {
            this.iostatus(-42);
            return true;
        }
        try {
            if (LogSetup.IS_LOGGING) {
                LogSetup.LOGGER.finer("ZFile.close()");
            }
            if (this.zFile == null) {
                if (LogSetup.IS_LOGGING) {
                    LogSetup.LOGGER.severe("ZFile class instance not found");
                }
                this.iostatus(-30);
                return true;
            }
            this.zFile.close();
        }
        catch (YFileException e) {
            if (LogSetup.IS_LOGGING) {
                LogSetup.LOGGER.severe("" + e);
            }
            this.iostatus(-90);
            return true;
        }
        this.iostatus(0);
        this.priorCommand = Command.CLOSE;
        return false;
    }

    @Override
    public boolean read(Variable intoVar, int mode, Numeric timeout) {
        return this.readNext(intoVar, mode, timeout);
    }

    @Override
    public boolean read(Variable data) {
        return this.readNext(data, 0, null);
    }

    @Override
    public boolean read(Variable data, int determineSize) {
        return this.readNext(data, 0, null);
    }

    @Override
    public boolean readNext(Variable intoVar, int mode, Numeric timeout) {
        double tod = timeout != null ? timeout.toDouble() : 0.0;
        byte[] rec = this.readNext(mode, tod);
        if (rec.length == 0) {
            return false;
        }
        intoVar.setArgument(this.into);
        return true;
    }

    private byte[] readNext(int mode, double timeout) {
        int lenread = 0;
        if (!this.isOpenInput && !this.isOpenIO) {
            this.iostatus(-47);
            if (LogSetup.IS_LOGGING) {
                LogSetup.LOGGER.warning("File Status=-47: READ NEXT requires file be OPENed as INPUT or IO.");
            }
            return new byte[0];
        }
        try {
            if (this.zFile == null) {
                if (LogSetup.IS_LOGGING) {
                    LogSetup.LOGGER.severe("ZFile class instance not found");
                }
                this.iostatus(-30);
                return new byte[0];
            }
            lenread = this.zFile.read(this.into);
            if (LogSetup.IS_LOGGING) {
                LogSetup.LOGGER.finer("ZFile.read(into)=" + lenread + ",\"" + zOSSequentialFile.encode(this.into, lenread));
            }
        }
        catch (YFileException e) {
            if (LogSetup.IS_LOGGING) {
                LogSetup.LOGGER.severe("" + e);
            }
            this.iostatus(-10);
            return new byte[0];
        }
        if (lenread <= 0) {
            this.iostatus(-10);
            return new byte[0];
        }
        this.iostatus(0);
        this.priorCommand = Command.READ_NEXT;
        return this.into;
    }

    @Override
    public boolean readNext(Variable intoVar) {
        return this.readNext(intoVar, 0, null);
    }

    @Override
    public boolean readPrevious(Variable intoVar, int mode, Numeric timeout) {
        double tod = timeout != null ? timeout.toDouble() : 0.0;
        byte[] rec = this.readPrevious(mode, tod);
        if (rec.length == 0) {
            return false;
        }
        intoVar.setArgument(this.into);
        return true;
    }

    private byte[] readPrevious(int mode, double timeout) {
        int lenread = 0;
        if (!this.isOpenInput && !this.isOpenIO) {
            this.iostatus(-47);
            if (LogSetup.IS_LOGGING) {
                LogSetup.LOGGER.warning("File Status=-47: READ NEXT requires file be OPENed as INPUT or IO.");
            }
            return new byte[0];
        }
        try {
            if (this.zFile == null) {
                if (LogSetup.IS_LOGGING) {
                    LogSetup.LOGGER.severe("ZFile class instance not found");
                }
                this.iostatus(-30);
                return new byte[0];
            }
            lenread = this.zFile.read(this.into);
            if (LogSetup.IS_LOGGING) {
                LogSetup.LOGGER.finer("ZFile.read(into <length=" + this.into.length + ">)=" + lenread);
            }
        }
        catch (YFileException e) {
            if (LogSetup.IS_LOGGING) {
                LogSetup.LOGGER.severe("" + e);
            }
            this.iostatus(-10);
            return new byte[0];
        }
        if (lenread <= 0) {
            this.iostatus(-10);
            return new byte[0];
        }
        this.iostatus(0);
        this.priorCommand = Command.READ_PREVIOUS;
        return this.into;
    }

    @Override
    public boolean write(Variable fromVar) {
        byte[] rec = fromVar.toByteArray();
        return this.write(rec, 0, rec.length);
    }

    @Override
    public boolean write(Variable fromVar, int mode, Numeric timeout) {
        byte[] rec = fromVar.toByteArray();
        return this.write(rec, 0, rec.length);
    }

    @Override
    public boolean write(Variable fromVar, int mode, Numeric timeout, boolean printSequential) {
        byte[] rec = fromVar.toByteArray();
        return this.write(rec, 0, rec.length);
    }

    @Override
    public boolean write(byte[] record, int off, int len) {
        if (!this.isOpenOutput && !this.isOpenIO) {
            this.iostatus(-48);
            return false;
        }
        try {
            if (LogSetup.IS_LOGGING) {
                LogSetup.LOGGER.finer("ZFile.write(\"" + zOSSequentialFile.encode(record, record.length) + "\"," + off + "," + len + ")");
            }
            if (this.zFile == null) {
                if (LogSetup.IS_LOGGING) {
                    LogSetup.LOGGER.severe("ZFile class instance not found");
                }
                this.iostatus(-30);
                return true;
            }
            this.zFile.write(record, off, len);
        }
        catch (YFileException e) {
            if (LogSetup.IS_LOGGING) {
                LogSetup.LOGGER.severe("" + e);
            }
            this.iostatus(-90);
            return true;
        }
        this.iostatus(0);
        this.priorCommand = Command.WRITE;
        return false;
    }

    @Override
    public boolean rewrite(Variable fromVar) {
        byte[] record = fromVar.toByteArray();
        return this.rewrite(record.length, record);
    }

    private boolean rewrite(int len, byte[] record) {
        if (!this.isOpenIO) {
            this.iostatus(-49);
            return false;
        }
        try {
            if (LogSetup.IS_LOGGING) {
                LogSetup.LOGGER.finer("ZFile.update(\"" + zOSSequentialFile.encode(record, len) + "\",0," + len + ")");
            }
            if (this.zFile == null) {
                if (LogSetup.IS_LOGGING) {
                    LogSetup.LOGGER.severe("ZFile class instance not found");
                }
                this.iostatus(-30);
                return true;
            }
            this.zFile.update(record, 0, len);
        }
        catch (YFileException e) {
            if (LogSetup.IS_LOGGING) {
                LogSetup.LOGGER.severe("" + e);
            }
            this.iostatus(-23);
            return true;
        }
        this.iostatus(0);
        this.priorCommand = Command.REWRITE;
        return false;
    }

    public static String encode(byte[] b, int upto) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < upto; ++i) {
            if (b[i] < 32 || b[i] > 126) {
                sb.append(".");
                continue;
            }
            sb.append((char)b[i]);
        }
        return sb.toString();
    }

    private static enum Command {
        DECLARE,
        OPEN,
        CLOSE,
        START,
        START_NEXT,
        READ,
        READ_NEXT,
        READ_PREVIOUS,
        WRITE,
        REWRITE,
        DELETE;

    }
}

