/*
 * Decompiled with CFR 0.152.
 */
package com.heirloomcomputing.term;

import com.heirloomcomputing.term.GUITerm;
import com.heirloomcomputing.term.KeyValue;
import com.heirloomcomputing.term.ScreenHandler;
import com.heirloomcomputing.term.ScreenProperty;
import com.heirloomcomputing.term.Utilities;
import java.awt.CheckboxMenuItem;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Menu;
import java.awt.PopupMenu;
import java.awt.PrintJob;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;

public class GUIHandler
implements ScreenHandler,
FocusListener,
MouseListener {
    public static boolean debugMode;
    public static final int DEFAULT_LINES = 25;
    public static final int DEFAULT_COLUMNS = 80;
    private static boolean isPrintAvailable;
    private char[][] buffer = null;
    private int[][] attrBuffer = null;
    private boolean[] lineChanged = null;
    private int[] clearBuffer = null;
    public char[] blankColumn = null;
    private boolean scroll = true;
    private boolean clip = false;
    private int lines = 25;
    private int columns = 80;
    private int cursorx = 0;
    private int cursory = 0;
    private int curAttributes = 0;
    private int realAttr = 0;
    private int realFG = -1;
    private int realBG = -1;
    public GUITerm gfx = null;
    public static final int fgShift = 14;
    public static final int bgShift = 18;
    public static final int fgColorMask = 245760;
    public static final int bgColorMask = 0x3C0000;
    public static final int bgColorSetMask = 0x400000;
    public static final int fgColorSetMask = 0x800000;
    public static final int colorMask = 0xFFC000;
    private static final int mask = 1375730876;
    public CheckboxMenuItem[] bgMenuItem;
    public CheckboxMenuItem[] fgMenuItem;
    public CheckboxMenuItem[] fontMenuItem;
    public CheckboxMenuItem[] screenMenuItem;
    public CheckboxMenuItem[] cursorMenuItem;
    public int curBGState = -1;
    public int curFGState = -1;
    public int curFontState = -1;
    public int curScreenState = -1;
    public int curCursorState = -1;
    public int curBG = -1;
    public int curFG = -1;
    public int curFontSize = 12;
    public Properties printProps;
    public PopupMenu menu = null;
    public Hashtable<String, Integer> colorHash = null;
    public keyboard Keyboard = null;
    public boolean userClosed = true;
    private int defaultFG = -1;
    private int defaultBG = -1;
    private long timeout = -1L;
    private boolean forcedTimeout = false;
    private long timeoutTimer = 0L;
    private char secureChar = (char)32;
    private boolean secureCharSet = false;
    private boolean dataModified = false;
    private Vector<ActionListener> actionListeners = null;
    private boolean force;
    private KeyValue terminator = null;
    private KeyValue exitKey = null;
    private boolean insertMode = false;
    private int cx = 0;
    private int cy = 0;
    private StringBuffer text = null;
    private int startpos = 0;
    private int startx = 0;
    private int starty = 0;
    private int curpos = 0;
    private int endpos = -1;
    private int sx = 0;
    private int sy = 0;
    private Object o = new Object();
    private int count = 0;
    private volatile boolean paused = false;

    public static void debug(String string2) {
        System.out.println("GUIHandler: " + string2);
    }

    public GUIHandler() throws Throwable {
        this("Console", Color.green, Color.black, 25, 80);
    }

    public GUIHandler(String string2) throws Throwable {
        this(string2, Color.green, Color.black, 25, 80);
    }

    public GUIHandler(String string2, Color color2, Color color3) throws Throwable {
        this(string2, color2, color3, 25, 80);
    }

    public GUIHandler(String string2, Color color2, Color color3, int n, int n2) throws Throwable {
        String string3;
        if (debugMode) {
            GUIHandler.debug("Called GUIHandler(), lines=" + n);
        }
        this.lines = n;
        this.columns = n2;
        this.buffer = new char[n][n2];
        this.attrBuffer = new int[n][n2];
        this.lineChanged = new boolean[n];
        this.clearBuffer = new int[n2];
        this.blankColumn = new char[n2];
        for (int i = 0; i < n2; ++i) {
            this.blankColumn[i] = 32;
        }
        if (debugMode) {
            GUIHandler.debug("lines=" + n);
        }
        this.clearScreen(this.buffer);
        String string4 = null;
        String string5 = null;
        try {
            string4 = Utilities.getParameter("user.region");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (string4 == null) {
            string4 = "US";
        }
        try {
            string5 = Utilities.getParameter("user.language");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (string5 == null) {
            string5 = "en";
        }
        if ((string3 = Utilities.getParameter("console_font_size_" + string5 + "_" + string4)) == null) {
            string3 = Utilities.getParameter("console_font_size_" + string5);
        }
        if (string3 == null) {
            string3 = Utilities.getParameter("console_font_size");
        }
        if (string3 == null) {
            this.curFontSize = 12;
        } else {
            try {
                this.curFontSize = Utilities.parseInt(string3);
            }
            catch (Exception exception) {
                this.curFontSize = 12;
            }
        }
        this.gfx = new GUITerm(this.curFontSize, n, n2, color2, color3);
        if (debugMode) {
            GUIHandler.debug("gfx=" + this.gfx);
        }
        this.Keyboard = new keyboard(128);
        keyListener keyListener2 = new keyListener(this.Keyboard);
        this.getPanelForWindow().addKeyListener(keyListener2);
        this.getPanelForWindow().addFocusListener(this);
    }

    @Override
    public boolean isDataModified() {
        return this.dataModified;
    }

    @Override
    public int getCellWidth() {
        return this.gfx.getCellWidth();
    }

    @Override
    public void setCellWidth(int n) {
        this.gfx.setCellWidth(n);
    }

    @Override
    public int getCellHeight() {
        return this.gfx.getCellHeight();
    }

    @Override
    public void setCellHeight(int n) {
        this.gfx.setCellHeight(n);
    }

    @Override
    public Container getPanelForWindow() {
        return this.gfx.getPanelForWindow();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireActionEvent(ActionEvent actionEvent) {
        if (debugMode) {
            GUIHandler.debug("Called fireActionEvent(" + actionEvent + ")");
        }
        if (this.actionListeners != null) {
            if (debugMode) {
                GUIHandler.debug("synchronized on actionListeners");
            }
            Vector<ActionListener> vector = this.actionListeners;
            synchronized (vector) {
                for (int i = 0; i < this.actionListeners.size(); ++i) {
                    ActionListener actionListener2 = this.actionListeners.elementAt(i);
                    if (debugMode) {
                        GUIHandler.debug("l=" + actionListener2);
                    }
                    actionListener2.actionPerformed(actionEvent);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addActionListener(ActionListener actionListener2) {
        if (actionListener2 == null) {
            return;
        }
        if (this.actionListeners == null) {
            this.actionListeners = new Vector();
        }
        Vector<ActionListener> vector = this.actionListeners;
        synchronized (vector) {
            if (!this.actionListeners.contains(actionListener2)) {
                this.actionListeners.addElement(actionListener2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeActionListener(ActionListener actionListener2) {
        if (actionListener2 == null || this.actionListeners == null) {
            return;
        }
        Vector<ActionListener> vector = this.actionListeners;
        synchronized (vector) {
            if (!this.actionListeners.contains(actionListener2)) {
                return;
            }
            this.actionListeners.removeElement(actionListener2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeAllActionListeners() {
        if (this.actionListeners == null) {
            return;
        }
        Vector<ActionListener> vector = this.actionListeners;
        synchronized (vector) {
            this.actionListeners.removeAllElements();
            this.actionListeners = null;
        }
    }

    private void clearScreen(char[][] cArray) {
        for (int i = 0; i < this.lines; ++i) {
            System.arraycopy(this.blankColumn, 0, cArray[i], 0, this.columns);
        }
    }

    @Override
    public void end() {
        this.userClosed = false;
        this.gfx.end();
        this.removeAllActionListeners();
    }

    @Override
    public void forceRefresh() {
        this.force = true;
    }

    @Override
    public boolean refresh() {
        boolean bl = this.innerRefresh();
        this.gfx.refresh();
        return bl;
    }

    private boolean innerRefresh() {
        for (int i = 0; i < this.lines; ++i) {
            if (this.force) {
                this.lineChanged[i] = false;
                this.gfx.printGUI(0, i, this.buffer[i], this.attrBuffer[i]);
                continue;
            }
            if (!this.lineChanged[i]) continue;
            this.lineChanged[i] = false;
            this.gfx.printGUI(0, i, this.buffer[i], this.attrBuffer[i]);
        }
        this.gfx.setCursor(this.cursorx, this.cursory);
        this.force = false;
        this.gfx.setAttributes(this.curAttributes & 0x51FFFCBC);
        return true;
    }

    @Override
    public boolean move(int n, int n2) {
        if (debugMode) {
            GUIHandler.debug("Called move(" + n + ", " + n2 + ")");
            GUIHandler.debug("lines=" + this.lines + ", columns=" + this.columns);
        }
        if (n >= this.lines || n2 >= this.columns || n < 0 || n2 < 0) {
            return false;
        }
        this.cursorx = n2;
        this.cursory = n;
        return true;
    }

    public void scroll() {
        int n;
        int n2;
        while (this.paused) {
            Thread.yield();
        }
        char[] cArray = this.buffer[0];
        int[] nArray = this.attrBuffer[0];
        for (n2 = 1; n2 < this.lines; ++n2) {
            n = n2 - 1;
            this.buffer[n] = this.buffer[n2];
            this.attrBuffer[n] = this.attrBuffer[n2];
            this.lineChanged[n] = true;
        }
        n = n2 - 1;
        this.buffer[n] = cArray;
        this.attrBuffer[n] = nArray;
        this.lineChanged[n] = true;
        System.arraycopy(this.blankColumn, 0, this.buffer[n], 0, this.columns);
        System.arraycopy(this.clearBuffer, 0, this.attrBuffer[n], 0, this.columns);
        if (this.gfx != null) {
            int n3 = this.getCellHeight();
            this.fireActionEvent(new ActionEvent(this, 0, "SCROLL +" + n3));
        }
    }

    public static final boolean isPrintable(char c) {
        return c >= ' ' && c != '\u007f' && c != '\uffff';
    }

    private boolean putChar(char c) {
        if (this.cursorx >= this.columns || this.cursory >= this.lines) {
            return false;
        }
        if (debugMode) {
            GUIHandler.debug("Called putChar(" + c + "), cursorx=" + this.cursorx + ", current char at position=" + this.buffer[this.cursory][this.cursorx]);
        }
        if (!GUIHandler.isPrintable(c)) {
            c = (char)32;
        }
        this.buffer[this.cursory][this.cursorx] = c;
        this.attrBuffer[this.cursory][this.cursorx] = this.curAttributes & 0x51FFFCBC;
        int n = this.cursorx + 1;
        if (n < this.columns) {
            int n2 = this.gfx.getCharCellsOccupied(c);
            if (debugMode) {
                GUIHandler.debug("numCells=" + n2);
            }
            if (n2 > 1) {
                this.buffer[this.cursory][n] = 65535;
                this.attrBuffer[this.cursory][n] = this.curAttributes & 0x51FFFCBC;
            } else if (this.buffer[this.cursory][n] == '\uffff') {
                this.buffer[this.cursory][n] = 32;
                this.attrBuffer[this.cursory][n] = this.curAttributes & 0x51FFFCBC;
            }
        }
        this.lineChanged[this.cursory] = true;
        return true;
    }

    @Override
    public boolean print(String string2) {
        if (debugMode) {
            GUIHandler.debug("Called print(" + string2 + "), curAttributes=" + this.curAttributes);
        }
        if (string2 == null) {
            return false;
        }
        int n = string2.length();
        char[] cArray = null;
        int[] nArray = null;
        boolean bl = false;
        int n2 = this.curAttributes & 0x51FFFCBC;
        block0: for (int i = 0; i < n; ++i) {
            int n3;
            char c = string2.charAt(i);
            if (c < ' ' || c == '\u007f' || c == '\uffff') {
                if (c == '\u0007') {
                    this.beep();
                    continue;
                }
                if (c == '\t') {
                    for (n3 = 0; n3 < 8; ++n3) {
                        if (this.cursorx >= this.columns) {
                            if (this.clip) {
                                this.cursorx = this.columns - 1;
                                return true;
                            }
                            this.cursorx = 0;
                            ++this.cursory;
                            bl = false;
                            continue block0;
                        }
                        if (this.cursory >= this.lines) {
                            if (!this.scroll) {
                                this.cursory = this.lines - 1;
                                return true;
                            }
                            this.cursory = this.lines - 1;
                            this.scroll();
                        }
                        bl = true;
                        this.lineChanged[this.cursory] = true;
                        cArray = this.buffer[this.cursory];
                        nArray = this.attrBuffer[this.cursory];
                        cArray[this.cursorx] = 32;
                        nArray[this.cursorx++] = n2;
                    }
                    continue;
                }
                if (c == '\n') {
                    ++this.cursory;
                    bl = false;
                    if (this.cursory < this.lines) continue;
                    if (!this.scroll) {
                        this.cursory = this.lines - 1;
                        return true;
                    }
                    this.cursory = this.lines - 1;
                    this.scroll();
                    continue;
                }
                if (c == '\f') {
                    bl = false;
                    for (n3 = 0; n3 < this.lines; ++n3) {
                        ++this.cursory;
                        if (this.cursory < this.lines) continue;
                        if (!this.scroll) {
                            this.cursory = this.lines - 1;
                            return true;
                        }
                        this.cursory = this.lines - 1;
                        this.scroll();
                    }
                    this.cursorx = 0;
                    continue;
                }
                if (c == '\r') {
                    this.cursorx = 0;
                    continue;
                }
                c = ' ';
            }
            if (this.cursorx >= this.columns) {
                if (this.clip) {
                    this.cursorx = this.columns - 1;
                    return true;
                }
                this.cursorx = 0;
                ++this.cursory;
                bl = false;
            }
            if (this.cursory >= this.lines) {
                if (!this.scroll) {
                    this.cursory = this.lines - 1;
                    return true;
                }
                this.cursory = this.lines - 1;
                bl = false;
                this.scroll();
            }
            if (!bl) {
                bl = true;
                this.lineChanged[this.cursory] = true;
                cArray = this.buffer[this.cursory];
                nArray = this.attrBuffer[this.cursory];
            }
            cArray[this.cursorx] = c;
            nArray[this.cursorx] = n2;
            ++this.cursorx;
            n3 = this.gfx.getCharCellsOccupied(c);
            if (n3 <= 1 || this.cursorx >= this.columns) continue;
            cArray[this.cursorx] = 65535;
            nArray[this.cursorx] = n2;
            ++this.cursorx;
        }
        if (debugMode) {
            GUIHandler.debug("buffer[" + this.cursory + "]=" + new String(this.buffer[this.cursory]));
        }
        return true;
    }

    @Override
    public boolean println(String string2) {
        this.print(string2);
        if (this.cursory + 1 >= this.lines) {
            this.scroll();
            this.move(this.lines - 1, 0);
            return true;
        }
        this.move(this.cursory + 1, 0);
        return true;
    }

    @Override
    public void clrtoeol() {
        this.fireActionEvent(new ActionEvent(this, 0, "CLRTOEOL " + this.cx + "," + this.cy));
        this.inner_clrtoeol();
    }

    private void inner_clrtoeol() {
        String string2 = new String(this.blankColumn, this.cursorx, this.columns - this.cursorx);
        int n = this.cursorx;
        int n2 = this.cursory;
        boolean bl = this.clip;
        boolean bl2 = this.scroll;
        this.clip = true;
        this.scroll = false;
        int n3 = this.curAttributes;
        this.curAttributes &= 0xAE000343;
        this.print(string2);
        this.curAttributes = n3;
        this.clip = bl;
        this.scroll = bl2;
        this.move(n2, n);
    }

    @Override
    public void clrtobot() {
        this.fireActionEvent(new ActionEvent(this, 0, "CLRTOBOT " + this.cursory));
        int n = this.cursory;
        int n2 = this.cursorx;
        for (int i = this.cursory; i < this.lines; ++i) {
            this.move(i, 0);
            this.inner_clrtoeol();
        }
        this.move(n, n2);
        this.forceRefresh();
    }

    @Override
    public void beep() {
        Utilities.beep();
    }

    @Override
    public void setScrollable(boolean bl) {
        this.scroll = bl;
    }

    @Override
    public int getLines() {
        return this.lines;
    }

    @Override
    public int getColumns() {
        return this.columns;
    }

    @Override
    public void clearAttributes() {
        if (debugMode) {
            GUIHandler.debug("Called clearAttributes()");
        }
        this.realAttr = 0;
        this.realFG = this.defaultFG;
        this.realBG = this.defaultBG;
        this.curAttributes = 0;
    }

    @Override
    public void setFG(Color color2) {
        int n = -1;
        if (color2 != null) {
            n = ScreenProperty.getClosestColorIndex(color2);
        }
        this.setFG(n);
    }

    @Override
    public void setFG(int n) {
        this.setAttributes(this.getAttributes(), n, -1);
    }

    @Override
    public void setBG(Color color2) {
        int n = -1;
        if (color2 != null) {
            n = ScreenProperty.getClosestColorIndex(color2);
        }
        this.setBG(n);
    }

    @Override
    public void setBG(int n) {
        this.setAttributes(this.getAttributes(), -1, n);
    }

    @Override
    public void setAttributes(int n, int n2, int n3) {
        if (debugMode) {
            GUIHandler.debug("Called setAttributes(" + n + ", " + n2 + ", " + n3 + ")");
        }
        this.realAttr = n;
        int n4 = n & 0x51FFFCBC & 0xFF003FFF;
        if (n2 >= 0 && n2 < 16) {
            this.realFG = n2;
            n4 |= (n2 <<= 14) | 0x800000;
        } else {
            n4 |= this.realFG << 14 | 0x800000;
        }
        if (n3 >= 0 && n3 < 16) {
            this.realBG = n3;
            n4 |= (n3 <<= 18) | 0x400000;
        } else {
            n4 |= this.realBG << 18 | 0x400000;
        }
        this.curAttributes = n4;
        this.gfx.setAttributes(this.curAttributes);
    }

    @Override
    public int getAttributes() {
        return this.realAttr;
    }

    @Override
    public int getFG() {
        return this.realFG;
    }

    @Override
    public int getBG() {
        return this.realBG;
    }

    @Override
    public boolean setDefaultColors(Color color2, Color color3) {
        int n = -1;
        if (color2 != null) {
            n = ScreenProperty.getClosestColorIndex(color2);
        }
        int n2 = -1;
        if (color3 != null) {
            n2 = ScreenProperty.getClosestColorIndex(color3);
        }
        return this.setDefaultColors(n, n2);
    }

    @Override
    public int getDefaultFG() {
        return this.defaultFG;
    }

    @Override
    public int getDefaultBG() {
        return this.defaultBG;
    }

    @Override
    public boolean setDefaultColors(int n, int n2) {
        if (debugMode) {
            GUIHandler.debug("Called setDefaultColors(" + n + ", " + n2 + ")");
        }
        if (n >= 0) {
            this.curFG = n;
            this.defaultFG = n;
        }
        if (n2 >= 0) {
            this.curBG = n2;
            this.defaultBG = n2;
        }
        this.gfx.setDefaultColors(n, n2);
        this.forceRefresh();
        return true;
    }

    @Override
    public int getCursorX() {
        return this.cursorx;
    }

    @Override
    public int getCursorY() {
        return this.cursory;
    }

    @Override
    public Font getFont() {
        if (this.gfx == null) {
            return this.getPanelForWindow().getFont();
        }
        return this.gfx.getFont();
    }

    @Override
    public void setFont(Font font2) {
        Container container;
        int n;
        if (font2 == null) {
            return;
        }
        if (debugMode) {
            GUIHandler.debug("Called setFont(" + font2 + ")");
        }
        this.curFontSize = n = font2.getSize();
        this.gfx.setCellWidth(-1);
        this.gfx.setCellHeight(-1);
        this.gfx.setFont(font2);
        for (container = this.getPanelForWindow(); container != null && !(container instanceof Frame); container = container.getParent()) {
        }
        if (container != null) {
            Frame frame = (Frame)container;
            frame.setVisible(true);
            frame.pack();
        }
        this.forceRefresh();
        this.innerRefresh();
    }

    @Override
    public boolean setFontSize(int n) {
        Container container;
        if (debugMode) {
            GUIHandler.debug("Called setFontSize(" + n + ")");
        }
        this.curFontSize = n;
        this.gfx.setCellWidth(-1);
        this.gfx.setCellHeight(-1);
        this.gfx.setFontSize(n);
        for (container = this.getPanelForWindow(); container != null && !(container instanceof Frame); container = container.getParent()) {
        }
        if (container != null) {
            Frame frame = (Frame)container;
            frame.setVisible(true);
            frame.pack();
        }
        this.forceRefresh();
        this.innerRefresh();
        return true;
    }

    @Override
    public boolean setScreenResolution(int n, int n2) {
        Container container;
        Object object;
        int n3;
        if (debugMode) {
            GUIHandler.debug("Called setScreenResolution(" + n + ", " + n2 + ")");
        }
        char[][] cArray = new char[n][n2];
        int[][] nArray = new int[n][n2];
        this.lineChanged = new boolean[n];
        this.blankColumn = new char[n2];
        for (n3 = 0; n3 < n2; ++n3) {
            this.blankColumn[n3] = 32;
        }
        this.clearBuffer = new int[n2];
        for (n3 = 0; n3 < n; ++n3) {
            this.lineChanged[n3] = true;
            object = cArray[n3];
            int[] nArray2 = nArray[n3];
            System.arraycopy(this.blankColumn, 0, object, 0, n2);
            System.arraycopy(this.clearBuffer, 0, nArray2, 0, n2);
            if (n3 >= Math.min(n, this.lines)) continue;
            int n4 = Math.min(n2, this.columns);
            char[] cArray2 = this.buffer[n3];
            int[] nArray3 = this.attrBuffer[n3];
            for (int i = 0; i < n4; ++i) {
                object[i] = cArray2[i];
                nArray2[i] = nArray3[i];
            }
        }
        this.buffer = cArray;
        this.attrBuffer = nArray;
        this.lines = n;
        this.columns = n2;
        this.gfx.setDimension(n, n2);
        for (container = this.getPanelForWindow(); container != null && !(container instanceof Frame); container = container.getParent()) {
        }
        if (container != null) {
            object = (Frame)container;
            ((Window)object).setVisible(true);
            ((Window)object).pack();
        }
        this.forceRefresh();
        this.innerRefresh();
        return true;
    }

    public int getCursorMode() {
        try {
            String string2 = Utilities.getParameter("CURSOR-MODE");
            if (string2 == null) {
                return 3;
            }
            return Integer.valueOf(string2);
        }
        catch (Throwable throwable) {
            return 3;
        }
    }

    @Override
    public void showCursor() {
        if (this.getCursorMode() == 2) {
            return;
        }
        this.gfx.showCursor();
    }

    @Override
    public void hideCursor() {
        if (this.getCursorMode() == 1) {
            return;
        }
        this.gfx.hideCursor();
    }

    public void setClip(boolean bl) {
        this.clip = bl;
    }

    private static final String makePrintable(String string2) {
        String string3 = "";
        for (int i = 0; i < string2.length(); ++i) {
            char c = string2.charAt(i);
            string3 = !GUIHandler.isPrintable(c) ? string3 + ' ' : string3 + c;
        }
        return string3;
    }

    @Override
    public KeyValue getChar() {
        this.Keyboard.clearBuffer();
        return this.Keyboard.getChar();
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void waitForTerminatorKey(KeyValue[] var1_1) {
        this.requestFocus();
        this.terminator = null;
        this.exitKey = null;
        this.Keyboard.clearBuffer();
        var2_2 = null;
        this.forcedTimeout = false;
        block0: while (true) {
            var2_2 = this.Keyboard.getChar();
            if (this.forcedTimeout || var2_2 == null) break;
            if (var1_1 == null) continue;
            var3_3 = 0;
            while (true) {
                if (var3_3 < var1_1.length) ** break;
                continue block0;
                if (var2_2.equals(var1_1[var3_3])) {
                    this.terminator = var2_2;
                    return;
                }
                ++var3_3;
            }
            break;
        }
    }

    private void cursorback() {
        --this.cx;
        if (this.cx < 0) {
            this.cx = this.columns - 1;
            --this.cy;
            if (this.cy < 0) {
                this.cx = 0;
                this.cy = 0;
            }
        }
        if (this.buffer[this.cy][this.cx] == '\uffff') {
            --this.cx;
        }
        this.move(this.cy, this.cx);
    }

    private void cursorforward() {
        if (debugMode) {
            GUIHandler.debug("Called cursorforward(), cx=" + this.cx + ", cy=" + this.cy);
        }
        ++this.cx;
        if (this.cx >= this.columns) {
            this.cx = 0;
            ++this.cy;
            if (this.cy >= this.lines) {
                this.cy = this.lines - 1;
                this.scroll();
                --this.starty;
                if (this.starty < 0) {
                    this.startpos += this.columns - this.startx;
                    this.startx = 0;
                    this.starty = 0;
                }
            }
        }
        if (this.buffer[this.cy][this.cx] == '\uffff') {
            ++this.cx;
        }
        this.move(this.cy, this.cx);
    }

    private void cursorsave() {
        this.sx = this.cx;
        this.sy = this.cy;
    }

    private void cursorrestore() {
        this.cx = this.sx;
        this.cy = this.sy;
        this.move(this.cy, this.cx);
    }

    private void cursorupdate() {
        this.gfx.setCursor(this.cx, this.cy);
        this.refresh();
    }

    private void updateChar(int n, char c) {
        this.putChar(c);
        if (n == this.text.length()) {
            this.text.append(c);
            ++this.endpos;
        } else {
            this.text.setCharAt(n, c);
        }
    }

    public void printScreen() {
        Container container;
        for (container = this.getPanelForWindow(); container != null && !(container instanceof Frame); container = container.getParent()) {
        }
        if (container == null) {
            return;
        }
        Frame frame = (Frame)container;
        if (!isPrintAvailable) {
            return;
        }
        try {
            Graphics graphics;
            PrintJob printJob;
            if (this.printProps == null) {
                this.printProps = new Properties();
            }
            if ((printJob = frame.getToolkit().getPrintJob(frame, "Print Screen", this.printProps)) != null && (graphics = printJob.getGraphics()) != null) {
                Dimension dimension = frame.getSize();
                Dimension dimension2 = printJob.getPageDimension();
                graphics.translate((dimension2.width - dimension.width) / 2, (dimension2.height - dimension.height) / 2);
                graphics.setClip(0, 0, dimension.width, dimension.height);
                frame.printAll(graphics);
                graphics.dispose();
            }
            printJob.end();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void setTimeoutTimer(long l) {
        this.forcedTimeout = false;
        this.timeoutTimer = l;
    }

    @Override
    public void setSecureChar(char c) {
        this.secureChar = c;
        this.secureCharSet = true;
    }

    @Override
    public char getSecureChar() {
        if (this.secureCharSet) {
            return this.secureChar;
        }
        String string2 = Utilities.getParameter("SECURE-CHAR");
        if (string2 == null || string2.length() != 1) {
            return '*';
        }
        return string2.charAt(0);
    }

    private void requestFocus() {
        this.gfx.requestFocus();
    }

    private String rightTrimString(String string2) {
        int n;
        int n2 = n = string2.length() - 1;
        while (n >= 0 && string2.charAt(n) == ' ') {
            --n;
        }
        if (n < 0) {
            return "";
        }
        if (n == n2) {
            return string2;
        }
        return string2.substring(0, n + 1);
    }

    @Override
    public String getString(String string2, boolean bl, boolean bl2, KeyValue[] keyValueArray, int n, boolean bl3, char c, String string3, boolean bl4, String string4) {
        Container container = this.getPanelForWindow();
        container.addMouseListener(this);
        String string5 = this.inner_getString(string2, bl, bl2, keyValueArray, n, bl3, c, string3, bl4, string4);
        container.removeMouseListener(this);
        return string5;
    }

    private String inner_getString(String string2, boolean bl, boolean bl2, KeyValue[] keyValueArray, int n, boolean bl3, char c, String string3, boolean bl4, String string4) {
        if (string2 == null || string2.length() == 0) {
            return null;
        }
        this.dataModified = false;
        this.requestFocus();
        this.showCursor();
        this.terminator = null;
        this.exitKey = null;
        this.Keyboard.clearBuffer();
        string2 = GUIHandler.makePrintable(string2);
        this.cy = this.getCursorY();
        this.cx = this.getCursorX();
        if (debugMode) {
            GUIHandler.debug("Called getString(), cx=" + this.cx + ", cy=" + this.cy);
        }
        this.gfx.setCursor(this.cx, this.cy);
        this.move(this.cy, this.cx);
        int n2 = this.gfx.getCharCellsOccupied(string2.substring(0, n));
        int n3 = this.gfx.getCharCellsOccupied(string2);
        int n4 = this.cx - n2;
        int n5 = n4 + (n3 - 1);
        int n6 = n;
        if (n6 < 0) {
            n6 = 0;
        }
        if (n5 >= this.columns) {
            n5 = this.columns - 1;
            string2 = string2.substring(0, n5 - n4 + 1);
        }
        if (debugMode) {
            GUIHandler.debug("endx=" + n5 + ", cx=" + this.cx + ", cy=" + this.cy);
        }
        StringBuffer stringBuffer = new StringBuffer(string2);
        KeyValue keyValue = null;
        int n7 = 0;
        int n8 = stringBuffer.length() - 1;
        this.forcedTimeout = false;
        if (this.timeout > 0L) {
            this.setTimeoutTimer(this.timeout);
        }
        char c2 = this.getSecureChar();
        block19: while (true) {
            char c3;
            int n9;
            int n10;
            int n11;
            int n12;
            String string5;
            int n13;
            int n14;
            if (bl2) {
                while (n8 >= 0 && stringBuffer.charAt(n8) == ' ') {
                    --n8;
                }
            }
            keyValue = this.Keyboard.getChar();
            if (this.forcedTimeout) {
                this.hideCursor();
                if (bl3) {
                    this.println("");
                }
                return stringBuffer.toString();
            }
            if (debugMode) {
                GUIHandler.debug("key: " + keyValue);
            }
            char c4 = keyValue.getKeyChar();
            n7 = keyValue.getKeyModifier();
            if (n7 != 0) {
                n14 = keyValue.getKeyCode();
                if (n7 == 1) {
                    if (n14 == 9) {
                        this.exitKey = keyValue;
                        this.hideCursor();
                        if (bl3) {
                            this.println("");
                        }
                        return stringBuffer.toString();
                    }
                } else if (n7 == 2) {
                    if (n14 == 36) {
                        this.exitKey = keyValue;
                        this.hideCursor();
                        if (bl3) {
                            this.println("");
                        }
                        return stringBuffer.toString();
                    }
                    if (n14 == 35) {
                        this.exitKey = keyValue;
                        this.hideCursor();
                        if (bl3) {
                            this.println("");
                        }
                        return stringBuffer.toString();
                    }
                }
            } else {
                char c5 = c4;
                switch (c5) {
                    case '\r': {
                        keyValue.setKeyCode(10);
                        break;
                    }
                    case '\b': {
                        keyValue.setKeyCode(8);
                        break;
                    }
                    case '\t': {
                        keyValue.setKeyCode(9);
                        break;
                    }
                    case '\u007f': {
                        keyValue.setKeyCode(127);
                        break;
                    }
                    case '\u001b': {
                        keyValue.setKeyCode(27);
                    }
                }
                n14 = keyValue.getKeyCode();
                switch (n14) {
                    case 155: {
                        this.insertMode = !this.insertMode;
                        this.gfx.setCursorType(this.insertMode ? 1 : 0);
                        continue block19;
                    }
                    case 9: {
                        this.exitKey = keyValue;
                        this.hideCursor();
                        if (bl3) {
                            this.println("");
                        }
                        return stringBuffer.toString();
                    }
                    case 38: {
                        this.exitKey = keyValue;
                        this.hideCursor();
                        if (bl3) {
                            this.println("");
                        }
                        return stringBuffer.toString();
                    }
                    case 40: {
                        this.exitKey = keyValue;
                        this.hideCursor();
                        if (bl3) {
                            this.println("");
                        }
                        return stringBuffer.toString();
                    }
                    case 36: {
                        this.cx = n4;
                        n6 = 0;
                        this.gfx.setCursor(this.cx, this.cy);
                        this.move(this.cy, this.cx);
                        continue block19;
                    }
                    case 35: {
                        for (n13 = stringBuffer.length() - 1; n13 > 0 && stringBuffer.charAt(n13) == ' '; --n13) {
                        }
                        if (n13 != 0) {
                            this.cx = n4 + n13 + 1;
                            n6 = n13 + 1;
                            if (this.cx > n5) {
                                --n6;
                                this.cx = n5;
                            }
                        } else {
                            n6 = 0;
                            this.cx = n4;
                        }
                        if (this.buffer[this.cy][this.cx] == '\uffff') {
                            --this.cx;
                        }
                        this.gfx.setCursor(this.cx, this.cy);
                        this.move(this.cy, this.cx);
                        continue block19;
                    }
                    case 39: {
                        if (this.cx < n5) {
                            ++n6;
                            this.cursorforward();
                            this.gfx.setCursor(this.cx, this.cy);
                            continue block19;
                        }
                        if (!bl) continue block19;
                        this.hideCursor();
                        if (bl3) {
                            this.println("");
                        }
                        return stringBuffer.toString();
                    }
                    case 37: {
                        if (this.cx <= n4) continue block19;
                        --n6;
                        this.cursorback();
                        this.gfx.setCursor(this.cx, this.cy);
                        continue block19;
                    }
                    case 8: {
                        if (debugMode) {
                            GUIHandler.debug("hit backspace, curPos=" + n6 + ", cx=" + this.cx + ", beginx=" + n4 + ", lastChar=" + n8);
                        }
                        if (this.cx <= n4) continue block19;
                        --n6;
                        this.cursorback();
                        this.cursorsave();
                        if (debugMode) {
                            GUIHandler.debug("curPos=" + n6 + ", cx=" + this.cx);
                        }
                        string5 = this.rightTrimString(stringBuffer.toString());
                        n12 = this.gfx.getCharCellsOccupied(string5);
                        n11 = string5.length();
                        n10 = n8 - (n12 - n11);
                        for (n9 = n6; n9 < n10; ++n9) {
                            char c6 = c3 = (char)stringBuffer.charAt(n9 + 1);
                            if (bl2) {
                                c3 = n9 + 1 <= n10 ? c2 : c;
                            } else if (c3 == ' ') {
                                c3 = c;
                            }
                            this.putChar(c3);
                            stringBuffer.setCharAt(n9, c6);
                            this.cursorforward();
                        }
                        this.putChar(c);
                        if (n10 >= 0) {
                            stringBuffer.setCharAt(n10, ' ');
                        }
                        this.cursorrestore();
                        this.gfx.setCursor(this.cx, this.cy);
                        this.dataModified = true;
                        this.refresh();
                        continue block19;
                    }
                    case 127: {
                        if (debugMode) {
                            GUIHandler.debug("hit del, curPos=" + n6 + ", text='" + stringBuffer + "'");
                        }
                        this.cursorsave();
                        string5 = this.rightTrimString(stringBuffer.toString());
                        n12 = this.gfx.getCharCellsOccupied(string5);
                        n11 = string5.length();
                        n10 = n8 - (n12 - n11);
                        for (n9 = n6; n9 < n10; ++n9) {
                            c3 = ' ';
                            if (!bl2) {
                                c3 = stringBuffer.charAt(n9 + 1);
                            } else {
                                char c7 = c3 = n9 + 1 <= n10 ? c2 : (char)' ';
                            }
                            if (c3 == ' ') {
                                c3 = c;
                            }
                            if (debugMode) {
                                GUIHandler.debug("ch=" + c3);
                            }
                            this.putChar(c3);
                            stringBuffer.setCharAt(n9, stringBuffer.charAt(n9 + 1));
                            this.cursorforward();
                        }
                        this.putChar(c);
                        this.cursorrestore();
                        this.gfx.setCursor(this.cx, this.cy);
                        if (n10 >= 0) {
                            stringBuffer.setCharAt(n10, ' ');
                        }
                        this.dataModified = true;
                        this.refresh();
                        continue block19;
                    }
                }
            }
            if (debugMode) {
                GUIHandler.debug("char hit..");
            }
            if (keyValueArray != null) {
                if (debugMode) {
                    GUIHandler.debug("term length: " + keyValueArray.length);
                }
                for (n13 = 0; n13 < keyValueArray.length; ++n13) {
                    if (debugMode) {
                        GUIHandler.debug("terminators[" + n13 + "]=" + keyValueArray[n13]);
                    }
                    if (debugMode && keyValueArray[n13] == null) {
                        GUIHandler.debug("PROBLEM!");
                    }
                    if (!keyValue.equals(keyValueArray[n13])) continue;
                    this.terminator = keyValue;
                    this.hideCursor();
                    if (bl3) {
                        this.println("");
                    }
                    return stringBuffer.toString();
                }
            }
            if (c4 == '\uffff' || c4 == '\uffff' || !GUIHandler.isPrintable(c4)) continue;
            if (bl4) {
                c4 = Character.toUpperCase(c4);
            }
            if (string3 != null && string3.indexOf(c4) < 0) {
                this.beep();
                continue;
            }
            if (debugMode) {
                GUIHandler.debug("Calling putChar(c), isSecure=" + bl2);
            }
            n13 = this.gfx.getCharCellsOccupied(c4);
            if (this.insertMode) {
                if (debugMode) {
                    GUIHandler.debug("insert mode is on");
                }
                if ((n10 = n8 - ((n12 = this.gfx.getCharCellsOccupied(string5 = this.rightTrimString(stringBuffer.toString()))) - (n11 = string5.length()))) >= 0 && stringBuffer.charAt(n10) != ' ') continue;
                for (n9 = n10; n9 > n6; --n9) {
                    stringBuffer.setCharAt(n9, stringBuffer.charAt(n9 - 1));
                }
                stringBuffer.setCharAt(n6, c4);
                this.cursorsave();
                for (n9 = n6; n9 <= n10; ++n9) {
                    c3 = stringBuffer.charAt(n9);
                    if (!bl2) {
                        this.putChar(c3);
                    } else if (n9 - 1 <= n10) {
                        this.putChar(c2);
                    } else {
                        this.putChar(' ');
                    }
                    this.cursorforward();
                }
                this.cursorrestore();
            } else if (n13 > 1 && this.cx == n5) continue;
            if (bl2) {
                this.putChar(c2);
            } else {
                this.putChar(c4);
            }
            if (debugMode) {
                GUIHandler.debug("curPos=" + n6 + ", c=" + c4 + ", cx=" + this.cx + ", cy=" + this.cy);
            }
            stringBuffer.setCharAt(n6, c4);
            this.dataModified = true;
            this.refresh();
            if (debugMode) {
                GUIHandler.debug("text after putChar='" + stringBuffer + "', cx=" + this.cx + ", cy=" + this.cy);
            }
            if (n13 <= 1 && this.cx < n5 || n13 > 1 && this.cx < n5 - 1) {
                ++n6;
                this.cursorforward();
                this.gfx.setCursor(this.cx, this.cy);
                continue;
            }
            if (bl) break;
        }
        if (debugMode) {
            GUIHandler.debug("auto ending");
        }
        this.hideCursor();
        if (bl3) {
            this.println("");
        }
        return stringBuffer.toString();
    }

    @Override
    public String getString() {
        Container container = this.getPanelForWindow();
        container.addMouseListener(this);
        String string2 = this.inner_getString();
        container.removeMouseListener(this);
        return string2;
    }

    private String inner_getString() {
        this.dataModified = false;
        this.requestFocus();
        this.showCursor();
        this.terminator = null;
        this.exitKey = null;
        this.Keyboard.clearBuffer();
        this.cy = this.getCursorY();
        this.cx = this.getCursorX();
        if (debugMode) {
            GUIHandler.debug("cx=" + this.cx + ", cy=" + this.cy);
        }
        this.gfx.setCursor(this.cx, this.cy);
        this.move(this.cy, this.cx);
        this.startpos = 0;
        this.startx = this.cx;
        this.starty = this.cy;
        this.curpos = 0;
        this.endpos = -1;
        this.text = new StringBuffer();
        KeyValue keyValue = null;
        int n = 0;
        this.forcedTimeout = false;
        if (this.timeout > 0L) {
            this.setTimeoutTimer(this.timeout);
        }
        block8: while (true) {
            int n2;
            keyValue = this.Keyboard.getChar();
            if (debugMode) {
                GUIHandler.debug("key: " + keyValue);
            }
            char c = keyValue.getKeyChar();
            if (this.forcedTimeout) {
                this.hideCursor();
                this.println("");
                return this.text.toString();
            }
            if (c == '\r') {
                keyValue.setKeyCode(10);
            } else if (c == '\b') {
                keyValue.setKeyCode(8);
            } else if (c == '\t') {
                keyValue.setKeyCode(9);
            } else if (c == '\u007f') {
                keyValue.setKeyCode(127);
            } else if (c == '\u001b') {
                keyValue.setKeyCode(27);
            }
            n = keyValue.getKeyCode();
            switch (n) {
                case 155: {
                    boolean bl = this.insertMode = !this.insertMode;
                    if (this.insertMode) {
                        this.gfx.setCursorType(1);
                        continue block8;
                    }
                    this.gfx.setCursorType(0);
                    continue block8;
                }
                case 39: {
                    if (this.curpos > this.endpos) continue block8;
                    ++this.curpos;
                    this.cursorforward();
                    this.cursorupdate();
                    continue block8;
                }
                case 37: {
                    if (this.curpos <= this.startpos) continue block8;
                    --this.curpos;
                    this.cursorback();
                    this.cursorupdate();
                    continue block8;
                }
                case 8: {
                    if (this.curpos <= this.startpos) continue block8;
                    this.cursorback();
                    this.cursorsave();
                    for (n2 = --this.curpos; n2 < this.endpos; ++n2) {
                        this.updateChar(n2, this.text.charAt(n2 + 1));
                        this.cursorforward();
                    }
                    this.updateChar(this.endpos, ' ');
                    --this.endpos;
                    this.text.setLength(this.endpos + 1);
                    this.cursorrestore();
                    this.dataModified = true;
                    this.cursorupdate();
                    continue block8;
                }
                case 127: {
                    if (debugMode) {
                        GUIHandler.debug("hit del");
                    }
                    if (this.curpos > this.endpos) continue block8;
                    this.cursorsave();
                    for (n2 = this.curpos; n2 < this.endpos; ++n2) {
                        this.updateChar(n2, this.text.charAt(n2 + 1));
                        this.cursorforward();
                    }
                    this.updateChar(this.endpos, ' ');
                    --this.endpos;
                    this.text.setLength(this.endpos + 1);
                    this.cursorrestore();
                    this.dataModified = true;
                    this.cursorupdate();
                    continue block8;
                }
                case 33: 
                case 34: 
                case 35: 
                case 36: {
                    continue block8;
                }
            }
            if (debugMode) {
                GUIHandler.debug("char hit..");
            }
            if (n == 10) {
                this.terminator = keyValue;
                this.hideCursor();
                this.println("");
                return this.text.toString();
            }
            if (c == '\uffff' || c == '\uffff' || !GUIHandler.isPrintable(c)) continue;
            if (this.insertMode) {
                this.updateChar(this.endpos + 1, ' ');
                for (n2 = this.endpos; n2 > this.curpos; --n2) {
                    this.text.setCharAt(n2, this.text.charAt(n2 - 1));
                }
                this.text.setCharAt(this.curpos, c);
                this.cursorsave();
                for (n2 = this.curpos; n2 <= this.endpos; ++n2) {
                    char c2 = this.text.charAt(n2);
                    this.putChar(c2);
                    this.cursorforward();
                }
                this.cursorrestore();
            }
            this.updateChar(this.curpos, c);
            ++this.curpos;
            this.cursorforward();
            this.dataModified = true;
            this.cursorupdate();
        }
    }

    @Override
    public KeyValue getTerminator() {
        return this.terminator;
    }

    @Override
    public KeyValue getExitKey() {
        return this.exitKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitFor() {
        Object object = this.o;
        synchronized (object) {
            ++this.count;
            if (this.count == 1) {
                return;
            }
            if (this.timeoutTimer > 0L) {
                long l = System.currentTimeMillis();
                try {
                    this.o.wait(this.timeoutTimer);
                }
                catch (Exception exception) {
                    --this.count;
                }
                this.timeoutTimer -= System.currentTimeMillis() - l;
                if (this.timeoutTimer <= 0L) {
                    this.timeoutTimer = 0L;
                    this.forcedTimeout = true;
                }
            } else {
                try {
                    this.o.wait();
                }
                catch (Exception exception) {
                    --this.count;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyOf() {
        Object object = this.o;
        synchronized (object) {
            if (this.count > 0) {
                --this.count;
            }
            try {
                this.o.notify();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public void setGetStringTimeout(long l) {
        this.timeout = l;
    }

    @Override
    public void forceGetStringTimeout() {
        if (!this.forcedTimeout) {
            this.forcedTimeout = true;
            this.notifyOf();
        }
    }

    @Override
    public boolean isGetStringTimeout() {
        return this.forcedTimeout;
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (debugMode) {
            GUIHandler.debug("Called mouseReleased(" + mouseEvent + ")");
        }
        if (mouseEvent == null) {
            return;
        }
        int n = this.getCellWidth();
        if (n <= 0) {
            return;
        }
        int n2 = this.getCellHeight();
        if (n2 <= 0) {
            return;
        }
        int n3 = mouseEvent.getX() / n;
        int n4 = mouseEvent.getY() / n2;
        if (debugMode) {
            GUIHandler.debug("Calling fireActionEvent...");
        }
        this.fireActionEvent(new ActionEvent(this, 0, "MOUSE_RELEASED " + n3 + ", " + n4));
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        if (focusEvent == null) {
            return;
        }
        if (!focusEvent.isTemporary() && !this.forcedTimeout) {
            this.forceGetStringTimeout();
        }
    }

    public void setPaused(boolean bl) {
        this.paused = bl;
    }

    public boolean isPaused() {
        return this.paused;
    }

    @Override
    public void clearScreen() {
        this.fireActionEvent(new ActionEvent(this, 0, "CLEAR_SCREEN"));
        for (int i = 0; i < this.getLines(); ++i) {
            this.move(i, 0);
            this.inner_clrtoeol();
        }
        this.move(0, 0);
        this.forceRefresh();
    }

    static {
        block7: {
            debugMode = false;
            isPrintAvailable = false;
            try {
                isPrintAvailable = true;
                String string2 = Utilities.getParameter("java.version");
                int n = 0;
                if (string2 == null) break block7;
                for (int i = 0; i < string2.length(); ++i) {
                    char c = string2.charAt(i);
                    if (c < '0' || c > '9') continue;
                    if (++n == 1) {
                        if (c == '1') {
                            ++n;
                            continue;
                        }
                    } else if (c <= '1') {
                        isPrintAvailable = false;
                    }
                    break;
                }
            }
            catch (Throwable throwable) {
                isPrintAvailable = false;
            }
        }
    }

    class actionListener
    implements ActionListener {
        actionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getActionCommand().equals("Print Screen")) {
                GUIHandler.this.printScreen();
            }
        }
    }

    class mouseListener
    extends MouseAdapter {
        mouseListener() {
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (GUIHandler.this.menu != null && mouseEvent.isPopupTrigger()) {
                GUIHandler.this.menu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            }
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (GUIHandler.this.menu != null && mouseEvent.isPopupTrigger()) {
                GUIHandler.this.menu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            }
        }
    }

    class itemListener
    implements ItemListener {
        itemListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            String string2 = (String)itemEvent.getItem();
            CheckboxMenuItem checkboxMenuItem = (CheckboxMenuItem)itemEvent.getSource();
            int n = -1;
            n = string2.indexOf("x");
            if (n >= 0) {
                int n2 = 0;
                int n3 = 0;
                try {
                    n3 = Integer.valueOf(string2.substring(0, n).trim());
                }
                catch (Exception exception) {
                    return;
                }
                try {
                    n2 = Integer.valueOf(string2.substring(n + 1).trim());
                }
                catch (Exception exception) {
                    return;
                }
                if (GUIHandler.this.curScreenState >= 0) {
                    GUIHandler.this.screenMenuItem[GUIHandler.this.curScreenState].setState(false);
                }
                for (int i = 0; i < GUIHandler.this.screenMenuItem.length; ++i) {
                    if (!string2.equals(GUIHandler.this.screenMenuItem[i].getLabel())) continue;
                    GUIHandler.this.curScreenState = i;
                    break;
                }
                checkboxMenuItem.setState(true);
                GUIHandler.this.setScreenResolution(n2, n3);
            } else {
                n = string2.indexOf("pt");
                if (n >= 0) {
                    int n4 = 0;
                    try {
                        n4 = Integer.valueOf(string2.substring(0, n).trim());
                    }
                    catch (Exception exception) {
                        return;
                    }
                    if (GUIHandler.this.curFontState >= 0) {
                        GUIHandler.this.fontMenuItem[GUIHandler.this.curFontState].setState(false);
                    }
                    for (int i = 0; i < GUIHandler.this.fontMenuItem.length; ++i) {
                        if (!string2.equals(GUIHandler.this.fontMenuItem[i].getLabel())) continue;
                        GUIHandler.this.curFontState = i;
                        break;
                    }
                    checkboxMenuItem.setState(true);
                    GUIHandler.this.setFontSize(n4);
                } else if (((Menu)checkboxMenuItem.getParent()).getLabel().equals("Foreground Color")) {
                    Integer n5 = GUIHandler.this.colorHash.get(string2);
                    if (n5 == null) {
                        return;
                    }
                    if (GUIHandler.this.curFGState >= 0) {
                        GUIHandler.this.fgMenuItem[GUIHandler.this.curFGState].setState(false);
                    }
                    for (int i = 0; i < GUIHandler.this.fgMenuItem.length; ++i) {
                        if (!string2.equals(GUIHandler.this.fgMenuItem[i].getLabel())) continue;
                        GUIHandler.this.curFGState = i;
                        break;
                    }
                    checkboxMenuItem.setState(true);
                    GUIHandler.this.setDefaultColors(n5, GUIHandler.this.curBG);
                } else if (((Menu)checkboxMenuItem.getParent()).getLabel().equals("Background Color")) {
                    Integer n6 = GUIHandler.this.colorHash.get(string2);
                    if (n6 == null) {
                        return;
                    }
                    if (GUIHandler.this.curBGState >= 0) {
                        GUIHandler.this.bgMenuItem[GUIHandler.this.curBGState].setState(false);
                    }
                    for (int i = 0; i < GUIHandler.this.bgMenuItem.length; ++i) {
                        if (!string2.equals(GUIHandler.this.bgMenuItem[i].getLabel())) continue;
                        GUIHandler.this.curBGState = i;
                        break;
                    }
                    checkboxMenuItem.setState(true);
                    GUIHandler.this.setDefaultColors(GUIHandler.this.curFG, n6);
                } else if (((Menu)checkboxMenuItem.getParent()).getLabel().equals("Cursor type")) {
                    if (GUIHandler.this.curCursorState >= 0) {
                        GUIHandler.this.cursorMenuItem[GUIHandler.this.curCursorState].setState(false);
                    }
                    for (int i = 0; i < GUIHandler.this.cursorMenuItem.length; ++i) {
                        if (!string2.equals(GUIHandler.this.cursorMenuItem[i].getLabel())) continue;
                        GUIHandler.this.curCursorState = i;
                        break;
                    }
                    checkboxMenuItem.setState(true);
                    if (string2.equals("Block")) {
                        GUIHandler.this.gfx.setCursorType(0);
                    }
                    if (string2.equals("Underline")) {
                        GUIHandler.this.gfx.setCursorType(1);
                    }
                }
            }
        }
    }

    class keyListener
    extends KeyAdapter {
        private keyboard myKeyboard;
        private KeyValue key = new KeyValue();
        private char bufferedKeyCode = '\u0000';

        public keyListener(keyboard keyboard2) {
            this.myKeyboard = keyboard2;
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            if (!GUIHandler.this.getPanelForWindow().isVisible()) {
                return;
            }
            int n = keyEvent.getKeyCode();
            if (this.bufferedKeyCode == '\uffff') {
                this.bufferedKeyCode = '\u0000';
            }
            if (n == 20) {
                return;
            }
            if (n == 19) {
                if (!GUIHandler.this.isPaused()) {
                    GUIHandler.this.setPaused(true);
                }
                this.key.setKeyChar('\uffff');
                this.key.setKeyCode(0);
                return;
            }
            if (n == 154) {
                this.key.setKeyChar('\uffff');
                this.key.setKeyCode(0);
                return;
            }
            if (n == 16) {
                this.key.setKeyModifier(this.key.getKeyModifier() | 1);
            } else if (n == 18) {
                this.key.setKeyModifier(this.key.getKeyModifier() | 8);
            } else if (n == 17) {
                this.key.setKeyModifier(this.key.getKeyModifier() | 2);
            } else {
                char c;
                if (keyEvent.isAltDown()) {
                    c = keyEvent.getKeyChar();
                    if (c >= '0' && c <= '9') {
                        int n2 = c - 48;
                        if (this.bufferedKeyCode >= '\u270f') {
                            GUIHandler.this.beep();
                            this.bufferedKeyCode = (char)65535;
                            this.key.setKeyChar('\uffff');
                            this.key.setKeyCode(0);
                            return;
                        }
                        this.bufferedKeyCode = (char)(this.bufferedKeyCode * 10 + n2);
                        return;
                    }
                    this.bufferedKeyCode = '\u0000';
                } else {
                    this.bufferedKeyCode = '\u0000';
                }
                GUIHandler.this.setPaused(false);
                c = keyEvent.getKeyChar();
                if (n == 10) {
                    c = '\r';
                }
                this.key.setKeyCode(n);
                this.key.setKeyChar(c);
                if (this.isActionKey(keyEvent)) {
                    this.myKeyboard.putKey(new KeyValue(this.key));
                }
            }
            this.key.setKeyChar('\uffff');
            this.key.setKeyCode(0);
        }

        @Override
        public void keyReleased(KeyEvent keyEvent) {
            if (!GUIHandler.this.getPanelForWindow().isVisible()) {
                return;
            }
            int n = keyEvent.getKeyCode();
            int n2 = this.key.getKeyModifier();
            if (keyEvent.getKeyCode() == 38 || keyEvent.getKeyCode() == 40) {
                if (!(keyEvent.isControlDown() || keyEvent.isAltDown() || keyEvent.isShiftDown())) {
                    this.myKeyboard.putKey(new KeyValue(keyEvent));
                }
            } else if (keyEvent.getKeyChar() == '\t' && !keyEvent.isControlDown() && !keyEvent.isAltDown()) {
                this.myKeyboard.putKey(new KeyValue(keyEvent));
            }
            if (n == 18) {
                if (this.bufferedKeyCode != '\u0000' && this.bufferedKeyCode != '\uffff') {
                    GUIHandler.this.setPaused(false);
                    this.key.setKeyCode(this.bufferedKeyCode);
                    this.key.setKeyChar(this.bufferedKeyCode);
                    this.myKeyboard.putKey(new KeyValue(this.key));
                    this.bufferedKeyCode = '\u0000';
                }
            } else if (n == 154) {
                GUIHandler.this.printScreen();
                this.key.setKeyChar('\uffff');
                this.key.setKeyCode(0);
                return;
            }
            if (n == 16 && (n2 & 1) != 0) {
                this.key.setKeyModifier(n2 & 0xFFFFFFFE);
            } else if (n == 18 && (n2 & 8) != 0) {
                this.key.setKeyModifier(n2 & 0xFFFFFFF7);
            } else if (n == 17 && (n2 & 2) != 0) {
                this.key.setKeyModifier(n2 & 0xFFFFFFFD);
            }
        }

        @Override
        public void keyTyped(KeyEvent keyEvent) {
            if (!GUIHandler.this.getPanelForWindow().isVisible() || this.isActionKey(keyEvent)) {
                return;
            }
            char c = keyEvent.getKeyChar();
            if (c == '\uffff' || c == '\uffff') {
                return;
            }
            if (this.bufferedKeyCode != '\u0000') {
                return;
            }
            int n = keyEvent.getKeyCode();
            if (n == 10) {
                c = '\r';
            }
            this.key.setKeyChar(c);
            this.key.setKeyCode(n);
            if (keyEvent.getKeyChar() != '\t') {
                this.myKeyboard.putKey(new KeyValue(this.key));
            } else {
                this.key.setKeyModifier(0);
            }
            this.key.setKeyChar('\uffff');
            this.key.setKeyCode(0);
        }

        private boolean isActionKey(KeyEvent keyEvent) {
            if (keyEvent.getKeyCode() == 38 || keyEvent.getKeyCode() == 40) {
                return false;
            }
            if (keyEvent.isActionKey()) {
                return true;
            }
            int n = keyEvent.getKeyCode();
            return n == 127 || n == 10 || n == 154;
        }
    }

    class keyboard {
        private KeyValue[] buffer = null;
        private final Object startEndLock = new Object();
        private int start = 0;
        private int end = 0;

        public keyboard(int n) {
            this.buffer = new KeyValue[n];
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void clearBuffer() {
            Object object = this.startEndLock;
            synchronized (object) {
                this.start = 0;
                this.end = 0;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized boolean putKey(KeyValue keyValue) {
            if (debugMode) {
                GUIHandler.debug("Called putKey(" + keyValue + ")");
            }
            Object object = this.startEndLock;
            synchronized (object) {
                KeyValue keyValue2;
                if (this.end == this.start - 1 || this.end == this.buffer.length - 1 && this.start == 0) {
                    return false;
                }
                this.buffer[this.end] = keyValue2 = new KeyValue(keyValue);
                ++this.end;
                if (this.end == this.buffer.length) {
                    this.end = 0;
                }
            }
            GUIHandler.this.notifyOf();
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized KeyValue getKey() {
            Object object = this.startEndLock;
            synchronized (object) {
                if (this.start == this.end) {
                    if (debugMode) {
                        GUIHandler.debug("getKey() returning null");
                    }
                    return null;
                }
                KeyValue keyValue = this.buffer[this.start];
                ++this.start;
                if (this.start == this.buffer.length) {
                    this.start = 0;
                }
                return keyValue;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public KeyValue getChar() {
            KeyValue keyValue = null;
            while (keyValue == null) {
                boolean bl = false;
                Object object = this.startEndLock;
                synchronized (object) {
                    if (this.start == this.end) {
                        bl = true;
                    }
                }
                if (bl) {
                    GUIHandler.this.waitFor();
                    if (GUIHandler.this.forcedTimeout) {
                        return null;
                    }
                }
                keyValue = this.getKey();
            }
            return keyValue;
        }
    }
}

