/*
 * Decompiled with CFR 0.152.
 */
package com.heirloomcomputing.term;

import com.heirloomcomputing.term.Field;
import com.heirloomcomputing.term.FieldException;
import com.heirloomcomputing.term.Form;
import com.heirloomcomputing.term.KeyValue;
import com.heirloomcomputing.term.ScreenHandler;
import com.heirloomcomputing.term.Text;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class TextForm
extends Form
implements ActionListener {
    private static final int BLACK = 0;
    private static final int GREEN = 2;
    private static final int CYAN = 3;
    private static final int RED = 4;
    private static final int YELLOW = 6;
    private static final int WHITE = 7;
    private static final int BRIGHT_BLUE = 9;
    private static final int BRIGHT_MAGENTA = 13;
    private static final int DEFAULT_FG = 2;
    private static final int DEFAULT_BG = 0;
    private ScreenHandler term;
    private int defaultFG = 2;
    private int defaultBG = 0;
    private String filler;
    private Text status;
    private Text errorEnhancement;
    private boolean mouseClickTimeout;
    private int mouseCursorOffset;
    private int mouseFieldIndex;

    public TextForm(ScreenHandler screenHandler) {
        this(screenHandler, 2, 0);
    }

    public TextForm(ScreenHandler screenHandler, int n, int n2) {
        this.term = screenHandler;
        this.defaultFG = n;
        this.defaultBG = n2;
        this.setDisplaySize(new Dimension(screenHandler.getColumns(), screenHandler.getLines()));
    }

    private void setCurrentAttributes(Text text) {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        boolean bl7 = false;
        int n = this.defaultBG;
        int n2 = this.defaultFG;
        if (text.isNonDisplay()) {
            bl = true;
            n2 = 9;
        } else {
            if (text.isReversedImage()) {
                bl2 = true;
            }
            if (text.isHighIntensity()) {
                bl3 = true;
            }
            if (text.isLowIntensity()) {
                bl4 = true;
            }
            if (text.isUnderlined()) {
                bl5 = true;
            }
            if (text.isBlink()) {
                bl6 = true;
            }
            if (text.isBlueColor()) {
                n2 = 9;
            } else if (text.isPinkColor()) {
                n2 = 13;
            } else if (text.isYellowColor()) {
                n2 = 6;
            } else if (text.isTurquoiseColor()) {
                n2 = 3;
            } else if (text.isRedColor()) {
                n2 = 4;
            } else if (text.isWhiteColor()) {
                n2 = 7;
            } else if (text.isGreenColor()) {
                n2 = 2;
            }
            if (text instanceof Field && ((Field)text).isError()) {
                if (this.errorEnhancement != null) {
                    bl2 = this.errorEnhancement.isReversedImage();
                    bl4 = this.errorEnhancement.isLowIntensity();
                    bl3 = this.errorEnhancement.isHighIntensity();
                    bl5 = this.errorEnhancement.isUnderlined();
                    bl6 = this.errorEnhancement.isBlink();
                    if (this.errorEnhancement.isBlueColor()) {
                        n2 = 9;
                    } else if (this.errorEnhancement.isPinkColor()) {
                        n2 = 13;
                    } else if (this.errorEnhancement.isYellowColor()) {
                        n2 = 6;
                    } else if (this.errorEnhancement.isTurquoiseColor()) {
                        n2 = 3;
                    } else if (this.errorEnhancement.isRedColor()) {
                        n2 = 4;
                    } else if (this.errorEnhancement.isWhiteColor()) {
                        n2 = 7;
                    } else if (this.errorEnhancement.isGreenColor()) {
                        n2 = 2;
                    }
                } else {
                    bl2 = true;
                    bl4 = false;
                    bl3 = true;
                    bl5 = true;
                    bl6 = false;
                }
            }
        }
        if (text.isColumnSeparator()) {
            if (text.isNonDisplay() || n2 != 9 && n2 != 13) {
                bl7 = true;
            }
        } else if (text.isNonDisplay()) {
            n2 = 7;
        }
        this.setCurrentAttributes(true, bl, bl2, bl3, bl4, bl5, bl6, bl7, n2, n);
    }

    private void setCurrentAttributes(boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7, boolean bl8, int n, int n2) {
        int n3 = 0;
        if (bl2) {
            n3 |= 8;
        } else {
            if (bl3) {
                n3 |= 0x1000;
            }
            if (bl4) {
                n3 |= 0x400;
            }
            if (bl5) {
                n3 |= 0x800;
            }
            if (bl6) {
                n3 |= 0x2000;
            }
            if (bl7) {
                n3 |= 0x80;
            }
        }
        if (bl8) {
            n3 |= 0x10000000;
        }
        if (bl) {
            n3 |= 0x20000000;
        }
        this.term.setAttributes(n3, n, n2);
    }

    private void drawText(Text[] textArray) {
        if (textArray == null) {
            return;
        }
        for (Text text : textArray) {
            int n = text.getDisplayLength();
            String string2 = text.getDisplayValue();
            if (text.isNonDisplay()) {
                string2 = "";
            }
            while (string2.length() < n) {
                string2 = string2 + "                              ";
            }
            if (n > 0 && string2.length() > n) {
                string2 = string2.substring(0, n);
            }
            this.setCurrentAttributes(text);
            Point point = text.getLocation();
            try {
                this.term.move(point.y, point.x);
                this.term.print(string2);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void putErrorMessage(Text text) {
        this.clearErrorMessage();
        this.status = text;
        this.drawText(new Text[]{text});
        Point point = this.getCursorLocation();
        this.term.move(point.y, point.x);
        this.term.refresh();
    }

    private void clearErrorMessage() {
        if (this.status == null) {
            return;
        }
        Point point = this.status.getLocation();
        this.term.setAttributes(0, this.defaultFG, this.defaultBG);
        if (this.filler == null) {
            int n = this.status.getDisplayLength();
            this.filler = "                                                                               ";
            while (this.filler.length() < n) {
                this.filler = this.filler + this.filler;
            }
            if (this.filler.length() > n) {
                this.filler = this.filler.substring(0, n);
            }
        }
        try {
            this.term.move(point.y, point.x);
            this.term.print(this.filler);
        }
        catch (Exception exception) {
            // empty catch block
        }
        Point point2 = this.getCursorLocation();
        this.term.move(point2.y, point2.x);
        this.term.refresh();
    }

    @Override
    public void showForm(boolean bl, boolean bl2, Text[] textArray, Text[] textArray2, Text text) {
        this.errorEnhancement = text;
        this.term.setDefaultColors(this.defaultFG, this.defaultBG);
        this.term.setFG(this.defaultFG);
        this.term.setBG(this.defaultBG);
        this.term.clearScreen();
        this.drawText(this.getText());
        this.drawText(this.getFields());
        this.drawText(textArray);
        this.drawText(textArray2);
        Text text2 = this.getStatus();
        if (text2 == null) {
            this.clearErrorMessage();
        } else {
            this.putErrorMessage(text2);
        }
        this.term.refresh();
        if (bl2) {
            this.term.beep();
        }
    }

    @Override
    protected Object waitForTerminator(Object[] objectArray) {
        KeyValue keyValue;
        do {
            this.term.waitForTerminatorKey((KeyValue[])objectArray);
        } while ((keyValue = this.term.getTerminator()) == null);
        return keyValue;
    }

    @Override
    protected int readField(int n, Object[] objectArray) throws FieldException {
        Object object;
        int n2 = this.getNumberOfFields();
        Field field = null;
        if (n2 > 0) {
            field = this.getField(n);
        }
        if (field == null) {
            this.term.waitForTerminatorKey((KeyValue[])objectArray);
        } else {
            int n3 = field.getDisplayLength();
            if (!field.isEditable() || n3 == 0) {
                n = n == -n2 ? -1 : --n;
                return n;
            }
            object = field.getLocation();
            int n4 = 0;
            if (this.mouseFieldIndex < 0) {
                if (this.mouseCursorOffset > 0) {
                    n4 = this.mouseCursorOffset;
                }
                this.mouseCursorOffset = 0;
                this.mouseFieldIndex = 0;
            }
            this.setCursorLocation(new Point(((Point)object).x + n4, ((Point)object).y));
            int n5 = this.term.getAttributes();
            this.setCurrentAttributes(field);
            boolean bl = field.isSecure();
            boolean bl2 = field.isAuto();
            boolean bl3 = field.isForceUpperCase();
            String string2 = field.getAllowChars();
            String string3 = field.getEditMask();
            String string4 = field.getDisplayValue();
            if (string4 == null) {
                string4 = "";
            }
            if (n3 > 0) {
                while (string4.length() < n3) {
                    string4 = string4 + "                    ";
                }
                string4 = string4.substring(0, n3);
            }
            String string5 = null;
            this.addMouseListener();
            try {
                this.term.move(((Point)object).y, ((Point)object).x + n4);
                string5 = this.term.getString(string4, bl2, bl, (KeyValue[])objectArray, n4, false, ' ', string2, bl3, string3);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.term.setAttributes(n5, -1, -1);
            this.setCursorLocation(new Point(this.term.getCursorX(), this.term.getCursorY()));
            if (string5 != null) {
                field.setValue(string5);
                field.setDirty(true);
            }
            if (this.term.isGetStringTimeout() && this.isMouseClickCausedTimeout()) {
                this.setMouseClickCausedTimeout(false);
                if (this.mouseFieldIndex < 0) {
                    this.removeMouseListener();
                    return this.mouseFieldIndex;
                }
            }
            this.removeMouseListener();
        }
        final KeyValue keyValue = this.term.getTerminator();
        if (keyValue != null) {
            throw new FieldException(){

                @Override
                public boolean getTerminatorPressed() {
                    return true;
                }

                @Override
                public Object getTerminator() {
                    return keyValue;
                }
            };
        }
        object = this.term.getExitKey();
        if (object == null) {
            n = n == -n2 ? -1 : --n;
            return n;
        }
        if (TextForm.isEditMoveToNextField((KeyValue)object)) {
            n = n == -n2 ? -1 : --n;
        } else if (TextForm.isEditDown((KeyValue)object)) {
            n = n == -n2 ? -1 : --n;
        } else if (TextForm.isEditRight((KeyValue)object)) {
            n = n == -n2 ? -1 : --n;
        } else if (TextForm.isEditUp((KeyValue)object)) {
            if (++n == 0) {
                n = -n2;
            }
        } else if (TextForm.isEditMoveToPreviousField((KeyValue)object) || TextForm.isEditLeft((KeyValue)object)) {
            if (++n == 0) {
                n = -n2;
            }
        } else {
            n = TextForm.isEditMoveToFirstField((KeyValue)object) ? -1 : (TextForm.isEditMoveToLastField((KeyValue)object) ? -n2 : (n == -n2 ? -1 : --n));
        }
        return n;
    }

    private boolean isMouseClickCausedTimeout() {
        return this.mouseClickTimeout;
    }

    private void setMouseClickCausedTimeout(boolean bl) {
        this.mouseClickTimeout = false;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        int n;
        int n2;
        if (actionEvent == null) {
            return;
        }
        if (this.term == null) {
            return;
        }
        int n3 = this.term.getCellWidth();
        if (n3 <= 0) {
            return;
        }
        int n4 = this.term.getCellHeight();
        if (n4 <= 0) {
            return;
        }
        String string2 = actionEvent.getActionCommand();
        if (string2 == null || !string2.startsWith("MOUSE_RELEASED")) {
            return;
        }
        if (string2.length() <= 15) {
            return;
        }
        int n5 = (string2 = string2.substring(15)).indexOf(44);
        if (n5 < 0) {
            return;
        }
        if (n5 + 1 >= string2.length()) {
            return;
        }
        String string3 = string2.substring(0, n5).trim();
        String string4 = string2.substring(n5 + 1).trim();
        try {
            n2 = Integer.valueOf(string3);
        }
        catch (Exception exception) {
            return;
        }
        try {
            n = Integer.valueOf(string4);
        }
        catch (Exception exception) {
            return;
        }
        this.mouseClickTimeout = false;
        int n6 = this.getFieldIndex(new Point(n2, n));
        if (n6 == 0) {
            return;
        }
        this.mouseClickTimeout = true;
        this.mouseFieldIndex = n6;
        Field field = this.getField(n6);
        this.mouseCursorOffset = n2 - field.getLocation().x;
        this.term.forceGetStringTimeout();
    }

    private void addMouseListener() {
        this.mouseClickTimeout = false;
        if (this.term != null) {
            this.term.addActionListener(this);
        }
    }

    private void removeMouseListener() {
        this.mouseClickTimeout = false;
        if (this.term != null) {
            this.term.removeActionListener(this);
        }
    }

    private static boolean isEditMoveToFirstField(KeyValue keyValue) {
        return keyValue.getKeyCode() == 36 && keyValue.getModifiers() == 2;
    }

    private static boolean isEditMoveToLastField(KeyValue keyValue) {
        return keyValue.getKeyCode() == 35 && keyValue.getModifiers() == 2;
    }

    private static boolean isEditMoveToNextField(KeyValue keyValue) {
        return keyValue.getKeyCode() == 9 && keyValue.getModifiers() == 0;
    }

    private static boolean isEditMoveToPreviousField(KeyValue keyValue) {
        return keyValue.getKeyCode() == 9 && keyValue.getModifiers() == 1;
    }

    private static boolean isEditUp(KeyValue keyValue) {
        return keyValue.getKeyCode() == 38 && keyValue.getModifiers() == 0;
    }

    private static boolean isEditDown(KeyValue keyValue) {
        return keyValue.getKeyCode() == 40 && keyValue.getModifiers() == 0;
    }

    private static boolean isEditLeft(KeyValue keyValue) {
        return keyValue.getKeyCode() == 37 && keyValue.getModifiers() == 0;
    }

    private static boolean isEditRight(KeyValue keyValue) {
        return keyValue.getKeyCode() == 39 && keyValue.getModifiers() == 0;
    }
}

