/*
 * Decompiled with CFR 0.152.
 */
package com.heirloomcomputing.term.jcurses;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;

public class filePtr {
    private boolean isOutput = false;
    private boolean isInput = false;
    private OutputStream os = null;
    private InputStream is = null;
    private DataInput datain = null;
    private DataOutput dataout = null;

    public filePtr() {
        this.isOutput = true;
        this.isInput = true;
        this.os = System.out;
        this.is = System.in;
    }

    public filePtr(OutputStream outputStream) {
        this.isOutput = true;
        this.os = outputStream;
    }

    public filePtr(InputStream inputStream) {
        this.isInput = true;
        this.is = inputStream;
    }

    public filePtr(InputStream inputStream, OutputStream outputStream) {
        this.isOutput = true;
        this.os = outputStream;
        this.isInput = true;
        this.is = inputStream;
    }

    public filePtr(Object object) throws IOException {
        if (object instanceof DataInput) {
            this.datain = (DataInput)object;
            this.isInput = true;
            return;
        }
        if (object instanceof DataOutput) {
            this.dataout = (DataOutput)object;
            this.isOutput = true;
            return;
        }
        throw new IOException("Object: '" + object + "' not supported by filePtr");
    }

    public void setIO(InputStream inputStream) {
        this.isInput = true;
        this.is = inputStream;
    }

    public void setIO(OutputStream outputStream) {
        this.isOutput = true;
        this.os = outputStream;
    }

    public void setIO(InputStream inputStream, OutputStream outputStream) {
        this.isInput = true;
        this.is = inputStream;
        this.isOutput = true;
        this.os = outputStream;
    }

    public void setIO(Object object) throws IOException {
        if (object instanceof DataInput) {
            this.datain = (DataInput)object;
            this.isInput = true;
            return;
        }
        if (object instanceof DataOutput) {
            this.dataout = (DataOutput)object;
            this.isOutput = true;
            return;
        }
        throw new IOException("Object: '" + object + "' not supported by filePtr");
    }

    public void write(byte[] byArray) throws IOException {
        if (!this.isOutput) {
            return;
        }
        if (this.os == null) {
            if (this.dataout != null) {
                this.dataout.write(byArray);
            }
        } else {
            this.os.write(byArray);
        }
    }

    public void write(int n) throws IOException {
        if (!this.isOutput) {
            return;
        }
        if (this.os == null) {
            if (this.dataout != null) {
                this.dataout.write(n);
            }
        } else {
            this.os.write(n);
        }
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        if (!this.isOutput) {
            return;
        }
        if (this.os == null) {
            if (this.dataout != null) {
                this.dataout.write(byArray, n, n2);
            }
        } else {
            this.os.write(byArray, n, n2);
        }
    }

    public void flush() throws IOException {
        if (!this.isOutput) {
            return;
        }
        if (this.os == null) {
            return;
        }
        this.os.flush();
    }

    public int read() throws IOException {
        if (!this.isInput) {
            throw new IOException("trying to read from a non-input device");
        }
        if (this.is == null) {
            if (this.datain != null) {
                return this.datain.readByte() & 0xFF;
            }
        } else {
            return this.is.read();
        }
        return -1;
    }

    public int read(byte[] byArray) throws IOException {
        if (!this.isInput) {
            throw new IOException("trying to read from a non-input device");
        }
        if (this.is == null) {
            if (this.datain != null) {
                this.datain.readFully(byArray);
                return byArray.length;
            }
        } else {
            return this.is.read(byArray);
        }
        return -1;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (!this.isInput) {
            throw new IOException("trying to read from a non-input device");
        }
        if (this.is == null) {
            if (this.datain != null) {
                this.datain.readFully(byArray, n, n2);
                return n2;
            }
        } else {
            return this.is.read(byArray, n, n2);
        }
        return -1;
    }

    public byte readByte() throws IOException {
        int n = this.read();
        return new Integer(n).byteValue();
    }

    public void readFully(byte[] byArray) throws IOException {
        this.read(byArray);
    }

    public void readFully(byte[] byArray, int n, int n2) throws IOException {
        this.read(byArray, n, n2);
    }

    public void close() throws IOException {
        if (this.os != null) {
            this.os.close();
        }
        if (this.is != null) {
            this.is.close();
        }
        if (this.os == null && this.is == null) {
            if (this.datain != null && this.datain instanceof RandomAccessFile) {
                ((RandomAccessFile)this.datain).close();
            }
            if (this.dataout != null && this.dataout instanceof RandomAccessFile) {
                ((RandomAccessFile)this.dataout).close();
            }
        }
    }

    public int available() throws IOException {
        if (this.is != null) {
            int n = this.is.available();
            if (n == 0) {
                return 1;
            }
            return n;
        }
        return 0;
    }
}

