/*
 * Decompiled with CFR 0.152.
 */
package com.heirloomcomputing.term.jcurses;

public class string {
    public static final boolean debugMode = false;
    private intBuffer myString = null;
    private int offset = 0;
    private int size = 0;

    public string(int n) throws IllegalArgumentException {
        if (n < 0) {
            throw new IllegalArgumentException("Passed a size < 0 to constructor");
        }
        this.myString = new intBuffer(n);
        this.size = n;
        this.offset = 0;
    }

    public string(String string2) throws IllegalArgumentException {
        if (string2 == null || string2.length() == 0) {
            throw new IllegalArgumentException("A null or zero length string was passed to constructor.");
        }
        string2 = string2 + '\u0000';
        this.myString = new intBuffer(string2);
        this.size = string2.length();
        this.offset = 0;
    }

    public string(intBuffer intBuffer2) throws IllegalArgumentException {
        if (intBuffer2 == null || intBuffer2.length() == 0) {
            throw new IllegalArgumentException("A null or zero length string was passed to constructor.");
        }
        this.myString = intBuffer2;
        this.size = intBuffer2.length();
        this.offset = 0;
    }

    public string(string string2) throws IllegalArgumentException {
        if (string2 == null) {
            throw new IllegalArgumentException("A null or zero length string was passed to constructor.");
        }
        this.myString = new intBuffer(string2.myString);
        this.offset = string2.offset;
        this.size = string2.size;
    }

    public void setCharAt(int n, int n2) throws StringIndexOutOfBoundsException {
        this.myString.setCharAt(this.offset + n, n2);
    }

    public int charAt(int n) throws StringIndexOutOfBoundsException {
        return this.myString.charAt(this.offset + n);
    }

    public void inc() throws StringIndexOutOfBoundsException {
        ++this.offset;
    }

    public void inc(int n) throws StringIndexOutOfBoundsException {
        this.offset += n;
    }

    public String toString() {
        String string2 = this.myString.toString().substring(this.offset);
        int n = string2.indexOf(0);
        if (n < 0) {
            n = string2.length();
        }
        string2 = n == 0 ? "" : string2.substring(0, n);
        return string2;
    }

    public int length() {
        return this.toString().length();
    }

    public string copy() {
        string string2 = new string(this);
        return string2;
    }

    public string assignTo() {
        string string2 = this.copy();
        string2.myString = this.myString;
        return string2;
    }

    public string assignTo(int n) {
        string string2 = this.copy();
        string2.myString = this.myString;
        string2.offset = n;
        return string2;
    }

    public string substring(int n, int n2) throws StringIndexOutOfBoundsException {
        if (this.offset + n >= this.size) {
            throw new StringIndexOutOfBoundsException("offset is beyond boundaries of string");
        }
        int n3 = this.offset + n2;
        if (n3 > this.size) {
            n3 = this.size;
        }
        return new string(this.myString.substring(this.offset + n, n3));
    }

    public string substring(int n) throws StringIndexOutOfBoundsException {
        if (this.offset + n >= this.size) {
            throw new StringIndexOutOfBoundsException("offset is beyond boundaries of string");
        }
        return new string(this.myString.substring(this.offset + n));
    }

    public void replace(int n, String string2) {
        this.replace(n, new string(string2));
    }

    public void replace(int n, string string2) {
        this.myString.replace(this.offset + n, string2.myString);
        int n2 = this.offset + n + string2.myString.length();
        if (n2 > this.size) {
            this.size = n2;
        }
    }

    public void resize(int n) {
        if (n < 0) {
            throw new StringIndexOutOfBoundsException("passed a negative size to resize(..)");
        }
        this.myString.resize(n);
        this.size = n;
    }

    public void append(String string2) {
        string2 = string2 + '\u0000';
        this.replace(this.offset + this.length(), string2);
    }

    public void append(string string2) {
        this.replace(this.offset + this.length(), string2);
    }

    public int getOffset() {
        return this.offset;
    }

    public void set(char c) {
        intBuffer intBuffer2 = this.myString;
        for (int i = this.offset; i < intBuffer2.length() && intBuffer2.charAt(i) != 0; ++i) {
            intBuffer2.setCharAt(i, c);
        }
    }

    public boolean memcmp(string string2, int n) {
        for (int i = 0; i < n; ++i) {
            if (string2.charAt(i) == this.charAt(i)) continue;
            return false;
        }
        return true;
    }

    public boolean equals(string string2) {
        if (string2.length() != this.length()) {
            return false;
        }
        return this.memcmp(string2, this.length());
    }

    class intBuffer {
        private int[] buffer;

        public intBuffer(int n) {
            this.buffer = new int[n];
        }

        public intBuffer(String string3) {
            this.buffer = this.fromString(string3);
        }

        public intBuffer(intBuffer intBuffer2) {
            this.buffer = new int[intBuffer2.buffer.length];
            System.arraycopy(intBuffer2.buffer, 0, this.buffer, 0, intBuffer2.buffer.length);
        }

        private int[] fromString(String string2) {
            char[] cArray = new char[string2.length()];
            int[] nArray = new int[string2.length()];
            string2.getChars(0, string2.length(), cArray, 0);
            for (int i = 0; i < cArray.length; ++i) {
                nArray[i] = cArray[i];
            }
            return nArray;
        }

        public String toString() {
            if (this.buffer == null) {
                return "";
            }
            char[] cArray = new char[this.buffer.length];
            for (int i = 0; i < this.buffer.length; ++i) {
                cArray[i] = (char)this.buffer[i];
            }
            return new String(cArray);
        }

        public void append(String string2) {
            int[] nArray = this.buffer != null ? new int[this.buffer.length + string2.length()] : new int[string2.length()];
            System.arraycopy(this.buffer, 0, nArray, 0, this.buffer.length);
            int[] nArray2 = this.fromString(string2);
            System.arraycopy(nArray2, 0, nArray, this.buffer.length, nArray2.length);
            this.buffer = nArray;
        }

        public int charAt(int n) {
            return this.buffer[n];
        }

        public void setCharAt(int n, int n2) {
            this.buffer[n] = n2;
        }

        public int length() {
            if (this.buffer == null) {
                return 0;
            }
            return this.buffer.length;
        }

        public intBuffer substring(int n, int n2) {
            if (n2 > this.buffer.length) {
                n2 = this.buffer.length;
            }
            intBuffer intBuffer2 = new intBuffer(n2 - n);
            System.arraycopy(this.buffer, n, intBuffer2.buffer, 0, n2 - n);
            return intBuffer2;
        }

        public intBuffer substring(int n) {
            return this.substring(n, this.buffer.length);
        }

        public void setLength(int n) {
            this.buffer = (int[])(n > 0 ? new int[n] : null);
        }

        public void resize(int n) {
            int[] nArray = new int[n];
            if (this.buffer != null) {
                System.arraycopy(this.buffer, 0, nArray, 0, Math.min(n, this.buffer.length));
            }
            this.buffer = nArray;
        }

        public void replace(int n, intBuffer intBuffer2) {
            if (intBuffer2.length() + n > this.length()) {
                this.resize(intBuffer2.length() + n);
            }
            System.arraycopy(intBuffer2.buffer, 0, this.buffer, n, intBuffer2.length());
        }
    }
}

