       IDENTIFICATION DIVISION.
       PROGRAM-ID. ACCTDIS.
      *REMARKS. THIS PROGRAM IS USED TO DISPLAY INDIVIDUAL ACCOUNT 
      *         DETAILS
       
       ENVIRONMENT DIVISION.
       DATA DIVISION.
       WORKING-STORAGE SECTION.
       77  PGM-NAME                     PIC X(11) VALUE 'ACCTDIS'.   
       77  TRANS-NAME                   PIC X(11) VALUE 'ACDI'.   
       77  WHEN-UPDATE                  PIC X(40) VALUE 
           'UPDATED 2018-11-30 10:00 AM. '. 
       77  CICS-RESP                    PIC S9(8) BINARY. 
       77  START-CODE                   PIC X(02) VALUE SPACES.          
       01  COUNTERS.
           05  WS-ABSTIME               PIC S9(15).    
      * COMMUNICATIONS AREA PASSED BETWEEN PROGRAMS.      
       01  WS-COMMAREA.  
       COPY COMAREA.         
      * CICS BUILTIN ATTRIBUTE VALUES           
       COPY DFHBMSCA. 
      * CICS BUILTIN COPYBOOK FOR EIBAID VALUES           
       COPY DFHAID.   
      * VSAM FILE LAYOUT             
       01  ACCTREC.
           COPY ACCTREC.                       
      * BMS MAP LAYOUT                  
       COPY ACCTDTL.                    
       LINKAGE SECTION.
       01  DFHCOMMAREA                  PIC X(200). 
       
       PROCEDURE DIVISION.
       MAINLINE.
      $if displaymode = 1
           DISPLAY PGM-NAME WHEN-UPDATE UPON SYSERR
      $end-if 
      * CHECK IF PROGRAM WAS STARTED FROM MENU OR FROM TRANSID       
           EXEC CICS ASSIGN
                     STARTCODE (START-CODE)
           END-EXEC 
           
      * INITIALIZE MAP AREA     
           MOVE LOW-VALUES                TO ACCTDTMI           
   
           EVALUATE TRUE       
             WHEN EIBCALEN = 0 AND
                  START-CODE = 'SD'                                    
                EXEC CICS RETRIEVE 
                          SET (ADDRESS OF DFHCOMMAREA)           
                          LENGTH (LENGTH OF DFHCOMMAREA)         
                          RESP (EIBRESP)                         
                END-EXEC                                                  
                EVALUATE EIBRESP                                          
                   WHEN DFHRESP (NORMAL)
                     MOVE DFHCOMMAREA  TO WS-COMMAREA                   
                     IF WS-CA-ACCTNO-TOP = SPACES
                        PERFORM CICS-SEND-MAP  
                        PERFORM CICS-RETURN
                     ELSE         
                        PERFORM READ-ACCTFIL
                        PERFORM CICS-SEND-MAP  
                        PERFORM CICS-RETURN
                     END-IF             
                   WHEN DFHRESP (ENDDATA)
                       SET DATAONLY-OFF   TO TRUE               
                       PERFORM CICS-SEND-MAP 
                       PERFORM CICS-RETURN                                                    
                END-EVALUATE
             WHEN EIBCALEN = 0
                PERFORM CICS-SEND-MAP 
                PERFORM CICS-RETURN                         
           END-EVALUATE
            
           MOVE DFHCOMMAREA               TO WS-COMMAREA
           
           EVALUATE EIBAID
             WHEN DFHCLEAR
               MOVE SPACES                TO WS-CA-IN-ACCTNO       
                                             WS-CA-IN-NAME              
               SET DATAONLY-OFF           TO TRUE               
               PERFORM CICS-SEND-MAP 
               PERFORM CICS-RETURN                      
             WHEN DFHPF2
               INITIALIZE WS-CA-REINIT-AREA
               MOVE 561                   TO WS-CA-NEXT-CPOSN              
               MOVE WS-CA-PREV-TRANSID    TO WS-CA-TRANSID
               PERFORM START-NEW-TRANSID              
             WHEN DFHPF3
               INITIALIZE WS-COMMAREA
               MOVE 'ACMN'                TO WS-CA-TRANSID
               PERFORM START-NEW-TRANSID
             WHEN OTHER
                CONTINUE  
           END-EVALUATE
              
           PERFORM RECEIVE-MAP    
           PERFORM CICS-SEND-MAP                                                                                                                                                     
                                                                        
           PERFORM CICS-RETURN              
                                                                                                  
           GOBACK                                                                    
           .            
       CICS-SEND-MAP.
       
      * SET THE PROGRAM FUNCTION
           MOVE '** DISPLAY **'           TO FUNCO 
      * UNLOCK ACCOUNT NUMBER FIELD         
           MOVE DFHBMFSE                   TO ACCTDA
      * UPDATE COLOR FOR INPUT
           MOVE DFHGREEN                  TO ACCTDC            
      * ALWAYS SET CURSOR AT FIRST FIELD FOR DISPLAY PROGRAM 
           MOVE -1                        TO ACCTDL   
                      
           MOVE TRANS-NAME                TO TRANSO           
           MOVE PGM-NAME                  TO PGMNMO                      
       
           EXEC CICS ASKTIME
                ABSTIME (WS-ABSTIME)
           END-EXEC

           EXEC CICS FORMATTIME
                ABSTIME(WS-ABSTIME)
                MMDDYYYY(DATEO)
                DATESEP('/')
                TIME  (TIMEO)
                TIMESEP (':')
           END-EXEC
           
           IF DATAONLY-ON	
               EXEC CICS SEND 
                         MAP('ACCTDTM') 
                         MAPSET('ACCTDTL') 
                         FROM (ACCTDTMO)
                         FREEKB
                         CURSOR
                         DATAONLY 
               END-EXEC
           ELSE        		       
               EXEC CICS SEND 
                         MAP('ACCTDTM') 
                         MAPSET('ACCTDTL') 
                         FROM (ACCTDTMO)
                         FREEKB
                         CURSOR
                         ERASE 
               END-EXEC
               SET DATAONLY-ON            TO TRUE
           END-IF    
           .
       CICS-RETURN.
       
           EXEC CICS RETURN 
                     TRANSID(TRANS-NAME) 
                     COMMAREA (WS-COMMAREA)
                     LENGTH (LENGTH OF WS-COMMAREA)
           END-EXEC
           GOBACK
           .
       RECEIVE-MAP.

           EXEC CICS RECEIVE 
                     MAP('ACCTDTM') 
                     MAPSET('ACCTDTL') 
                     RESP(CICS-RESP) 
           END-EXEC
           EVALUATE CICS-RESP   
             WHEN DFHRESP(MAPFAIL)
               MOVE -1                    TO ACCTDL
               MOVE 'YOU MUST ENTER AN ACCOUNT NUMBER' TO MSGO   
             WHEN DFHRESP(NORMAL)
               IF ACCTDL > ZEROS
                   MOVE ACCTDI            TO WS-CA-ACCTNO-TOP
                   PERFORM READ-ACCTFIL                   
               END-IF                                  
           END-EVALUATE        
           .
       READ-ACCTFIL.
         
           EXEC CICS READ 
                     DATASET('ACCTFIL') 
                     RIDFLD(WS-CA-ACCTNO-TOP) 
                     INTO(ACCTREC)
                     RESP(CICS-RESP)
           END-EXEC
      $if displaymode = 1         
           DISPLAY PGM-NAME 
           "CHECK-DETAIL-FIELDS: READ ACCTFIL RESPONSE=" CICS-RESP 
           22
           ". EIBRESP="  EIBRESP 
           ". EIBRCODE=" EIBRCODE 
           ". ACCTNO="   WS-CA-ACCTNO-TOP "."  
             UPON SYSERR  
      $end-if          
           IF CICS-RESP = DFHRESP(NORMAL)
               MOVE SPACES            TO MSGO               
               PERFORM BUILD-MAP
           ELSE
      $if displaymode = 1         
               DISPLAY PGM-NAME 
               'CHECK-DETAIL-FIELDS: READ DATASET ACCTFIL UNEXPECTED EIB
      -        'RESP=' EIBRESP 'EIBERRMSG=' EIBERRMSG UPON SYSERR
      $end-if
               INITIALIZE ACCTDTMO
               SET DATAONLY-OFF           TO TRUE
               MOVE 'ACCOUNT NUMBER NOT FOUND, TRY ANOTHER NUMBER' 
                                          TO MSGO
           END-IF    
           .   
       BUILD-MAP. 
       
           MOVE CORRESPONDING ACCTREC     TO ACCTDTMO
           MOVE SNAMEDO OF ACCTREC        TO SNAMEDO OF ACCTDTMO
           MOVE FNAMEDO OF ACCTREC        TO FNAMEDO OF ACCTDTMO
           
           MOVE PAY1-YYYYMMDD             TO DATE1DO
           MOVE PAY1-PAYMENT              TO PAY1DO
           MOVE PAY1-BALANCE              TO BAL1DO
           MOVE PAY2-YYYYMMDD             TO DATE2DO
           MOVE PAY2-PAYMENT              TO PAY2DO
           MOVE PAY2-BALANCE              TO BAL2DO
      
      $if displaymode = 1     
           DISPLAY PGM-NAME 
          "BUILD-MAP: PAY1-PAYMENT=" PAY1-PAYMENT ". PAY1DO=" PAY1DO "." 
              UPON SYSERR
      $end-if        
          .                                                          
       START-NEW-TRANSID.
       
           EXEC CICS START TRANSID  (WS-CA-TRANSID)                    
                           FROM     (WS-COMMAREA)                  
                           LENGTH   (LENGTH OF WS-COMMAREA)                     
                           TERMID   (EIBTRMID)                       
                           RTERMID  (EIBTRMID)                       
                           RESP     (CICS-RESP)                      
           END-EXEC
           EXEC CICS RETURN
           END-EXEC
           GOBACK
           .       