       IDENTIFICATION DIVISION.
       PROGRAM-ID. ACCTMNU.
      *REMARKS. THIS IS THE MENU PROGRAM FOR FIRST TIME THROUGH
      *         WITHOUT USING FASTPATH. 5 OPTIONS ARE AVAILABLE
      *         1.  SEARCH ACCOUNTS BY NAME
      *         2.  SEARCH ACCOUNTS BY ACCOUNT NUMBER 
      *         3.  BROWSE ACCOUNT DETAILS
      *         4.  INSERT INDIVIDUAL ACCOUNT
      *         5.  MODIFY INDIVIDUAL ACCOUNT
      *         6.  DELETE INDIVIDUAL ACCOUNT
       
       ENVIRONMENT DIVISION.
       DATA DIVISION.
       WORKING-STORAGE SECTION.
       77  PGM-NAME                     PIC X(11) VALUE 'ACCTMNU'.     
       77  TRANS-NAME                   pic x(04) value 'ACMN'.         
       77  WHEN-UPDATE                  PIC X(40) VALUE 
           'UPDATED 2018-11-30 10:00 AM. '. 
       77  CICS-RESP                    PIC S9(8) BINARY. 
       77  GOODBYE-MSG                  PIC X(70) VALUE                           
            'Thank you for using Heirloom''s version of Account Demo'.
       77  NOTAUTH-MSG                  PIC X(70) VALUE                           
            'Not Authorized for this page'.
       77  START-CODE                   PIC X(02) VALUE SPACES.   
       01  COUNTERS. 
           05  WS-ABSTIME               PIC S9(15).      
      * COMMUNICATIONS AREA PASSED BETWEEN PROGRAMS.       
       01  WS-COMMAREA.
       COPY COMAREA.       
      * CICS BUILTIN ATTRIBUTE VALUES 
       COPY DFHBMSCA.
      * CICS BUILTIN COPYBOOK FOR EIBAID VALUES          
       COPY DFHAID.
      * BMS MAP LAYOUT                 
       COPY ACCTMNU.
       COPY ACCTNOT.
       LINKAGE SECTION.
       01  DFHCOMMAREA                  PIC X(200). 
       
       PROCEDURE DIVISION.
       MAINLINE.
      $if displaymode = 1
           DISPLAY PGM-NAME WHEN-UPDATE UPON SYSERR  
      $end-if 
      * CHECK IF PROGRAM WAS STARTED FROM MENU OR FROM TRANSID 
           EXEC CICS ASSIGN
                     STARTCODE (START-CODE)
           END-EXEC     
           
      * INITIALIZE MAP AREA     
           MOVE LOW-VALUES                TO ACCTMNMI  
                                       
           EVALUATE TRUE       
             WHEN EIBCALEN = 0 AND
                  START-CODE = 'SD'                                    
                EXEC CICS RETRIEVE 
                          SET (ADDRESS OF DFHCOMMAREA)           
                          LENGTH (LENGTH OF DFHCOMMAREA)         
                          RESP (EIBRESP)                         
                END-EXEC                                                  
                EVALUATE EIBRESP                                          
                   WHEN DFHRESP (NORMAL)
                     MOVE DFHCOMMAREA  TO WS-COMMAREA
                     PERFORM CICS-SEND-MAP  
                     PERFORM CICS-RETURN                                                                        
                END-EVALUATE
             WHEN EIBCALEN = 0
               MOVE 'ENTER VALUE 1 THOUGH 6' TO MSGO
               PERFORM CICS-SEND-MAP
               PERFORM CICS-RETURN                     
           END-EVALUATE 
                                       
           MOVE DFHCOMMAREA      TO WS-COMMAREA
           
           IF EIBAID = DFHCLEAR OR
              EIBAID = DFHPF3
             EXEC CICS SEND TEXT 
                       FROM (GOODBYE-MSG) 
                       ERASE
                       FREEKB
             END-EXEC
             EXEC CICS 
                  RETURN
             END-EXEC
           END-IF           
           
           EXEC CICS RECEIVE 
                     MAP('ACCTMNM') 
                     MAPSET('ACCTMNU') 
                     RESP(CICS-RESP) 
           END-EXEC
           EVALUATE CICS-RESP   
             WHEN DFHRESP(MAPFAIL)
               MOVE 'YOU MUST ENTER A VALUE OF 1 THOUGH 6' TO MSGO   
             WHEN DFHRESP(NORMAL)
               PERFORM VALIDATE-ENTERED-VALUE                              
           END-EVALUATE                                                                     
           .            
       CICS-SEND-MAP.
       
           EXEC CICS ASKTIME
                ABSTIME (WS-ABSTIME)
           END-EXEC

           EXEC CICS FORMATTIME
                ABSTIME(WS-ABSTIME)
                MMDDYYYY(DATEO)
                DATESEP('/')
                TIME  (TIMEO)
                TIMESEP (':')
           END-EXEC	

           IF DATAONLY-ON
               EXEC CICS SEND 
                         MAP('ACCTMNM') 
                         MAPSET('ACCTMNU') 
                         FROM (ACCTMNMO)
                         FREEKB
                         DATAONLY 
           END-EXEC  
           ELSE                    		       
               EXEC CICS SEND 
                         MAP('ACCTMNM') 
                         MAPSET('ACCTMNU') 
                         FROM (ACCTMNMO)
                         FREEKB
                         ERASE 
               END-EXEC
               SET DATAONLY-ON            TO TRUE
           END-IF
           .
       CICS-RETURN.
       
           EXEC CICS RETURN 
                     TRANSID(TRANS-NAME) 
                     COMMAREA (WS-COMMAREA)
                     LENGTH (LENGTH OF WS-COMMAREA)
           END-EXEC
           GOBACK
           .
       VALIDATE-ENTERED-VALUE.
       
           EVALUATE TRUE
             WHEN SELNUMI = ZEROS
               MOVE 'VALUE MUST BE GREATER THAN ZERO' TO MSGO
             WHEN SELNUMI = 1
      * SEARCH BY NAME       
               MOVE EIBTRNID              TO WS-CA-PREV-TRANSID               
               MOVE 'ACSN'                TO WS-CA-TRANSID
               SET DATAONLY-OFF           TO TRUE
               PERFORM START-NEW-TRANSID
      * SEARCH BY ACCOUNT NUMBER         
             WHEN SELNUMI = 2
               MOVE EIBTRNID              TO WS-CA-PREV-TRANSID               
               MOVE 'ACSA'                TO WS-CA-TRANSID
               SET DATAONLY-OFF           TO TRUE
               PERFORM START-NEW-TRANSID               
             WHEN SELNUMI = 3
      * DISPLAY ACCOUNT RECORDS
               MOVE EIBTRNID              TO WS-CA-PREV-TRANSID        
               MOVE 'ACDI'                TO WS-CA-TRANSID
               SET DATAONLY-OFF           TO TRUE
               PERFORM START-NEW-TRANSID
             WHEN SELNUMI = 4
      * UPDATE ACCOUNT RECORDS      
               MOVE EIBTRNID              TO WS-CA-PREV-TRANSID  
               MOVE 'ACUP'                TO WS-CA-TRANSID
               SET DATAONLY-OFF           TO TRUE               
               PERFORM START-NEW-TRANSID               
             WHEN SELNUMI = 5
      * INSERT ACCOUNT RECORDS  
               MOVE EIBTRNID              TO WS-CA-PREV-TRANSID                   
               MOVE 'ACIN'                TO WS-CA-TRANSID
               MOVE SPACES                TO WS-CA-IN-ACCTNO
               SET DATAONLY-OFF           TO TRUE               
               PERFORM START-NEW-TRANSID 
             WHEN SELNUMI = 6
      * DELETE ACCOUNT RECORDS 
               MOVE EIBTRNID              TO WS-CA-PREV-TRANSID  
               MOVE 'ACDE'                TO WS-CA-TRANSID
               SET DATAONLY-OFF           TO TRUE               
               PERFORM START-NEW-TRANSID                                                         
              WHEN OTHER
               MOVE 'INVALID SELECTION NUMBER' TO MSGO
           END-EVALUATE
           .                                
       START-NEW-TRANSID.
       
           EXEC CICS START TRANSID  (WS-CA-TRANSID)                    
                           FROM     (WS-COMMAREA)                  
                           LENGTH   (LENGTH OF WS-COMMAREA)                     
                           TERMID   (EIBTRMID)                       
                           RTERMID  (EIBTRMID)                       
                           RESP     (CICS-RESP)                      
           END-EXEC
           
            EVALUATE CICS-RESP   
             WHEN DFHRESP(NOTAUTH)
               EXEC CICS SEND 
                         MAP('ACCTNOT') 
                         MAPSET('ACCTNOT') 
                         FROM (ACCTNOTO)
                         FREEKB
                         ERASE 
               END-EXEC                          
           END-EVALUATE                   
               
           EXEC CICS RETURN
           END-EXEC
           GOBACK
           .        
           