       IDENTIFICATION DIVISION.
       PROGRAM-ID. ACCTSRA.
      *REMARKS. THIS PROGRAM IS USED TO SEARCH FOR ACCOUNTS 
      *         BY ACCOUNT NUMBER. 
       
       ENVIRONMENT DIVISION.
       DATA DIVISION.
       WORKING-STORAGE SECTION.
       77  PGM-NAME                     PIC X(11) VALUE 'ACCTSRA'.  
       77  TRANS-NAME                   pic x(04) value 'ACSA'.        
       77  WHEN-UPDATE                  PIC X(40) VALUE 
           'UPDATED 2018-11-30 10:00 AM. '. 
       77  CICS-RESP                    PIC S9(8) BINARY. 
       77  START-CODE                   PIC X(02) VALUE SPACES.   
       01  COUNTERS.
           05  I                        PIC S9(04) COMP VALUE ZEROS.          
           05  WS-ABSTIME               PIC S9(15).      
      * COMMUNICATIONS AREA PASSED BETWEEN PROGRAMS.
       01  WS-COMMAREA.
       COPY COMAREA. 
                  
       01  WS-SCREEN-LINE.
            05  SL-ACCT                 PIC X(05).
            05  FILLER                  PIC X(03). 
            05  SL-SNAME                PIC X(13).
            05  FILLER                  PIC X(01). 
            05  SL-FNAME                PIC X(08).
            05  FILLER                  PIC X(01). 
            05  SL-MID                  PIC X(01).
            05  FILLER                  PIC X(02). 
            05  SL-TTL                  PIC X(03).
            05  FILLER                  PIC X(03). 
            05  SL-ADDR1                PIC X(24).
            05  FILLER                  PIC X(01). 
            05  SL-STATE                PIC X(02).
            05  FILLER                  PIC X(01). 
            05  SL-LIMIT                PIC ZZ,ZZ9.9(2).
      * CICS BUILTIN ATTRIBUTE VALUES                             
       COPY DFHBMSCA.  
      * CICS BUILTIN COPYBOOK FOR EIBAID VALUES          
       COPY DFHAID.   
      * VSAM FILE LAYOUT            
       01  ACCTREC.
           COPY ACCTREC.                         
      * BMS MAP LAYOUT          
       COPY ACCTSRA. 
      * CREATE TABLE TO PROCESS RECURRING LINES                               
       01  FILLER REDEFINES ACCTSRMO.
           05  FILLER                   PIC X(58). 
           05  ACCTSRH-TABLE OCCURS 15 TIMES.          
               10  FILLER               PIC X(02). 
               10  ACCTSRH-ATTR         PIC X(01). 
               10  FILLER               PIC X(04). 
               10  ACCTSRH-POS          PIC X(01).                
               10  FILLER               PIC X(07). 
               10  ACCTSRH-ENTRY        PIC X(77). 
                
       LINKAGE SECTION.
       01  DFHCOMMAREA                  PIC X(200). 
       
       PROCEDURE DIVISION.
       MAINLINE.
      $if displaymode = 1
           DISPLAY PGM-NAME WHEN-UPDATE UPON SYSERR
      $end-if 

      * iNITIALIZE MAP AREA
           MOVE LOW-VALUES                TO ACCTSRMI  
                
      * CHECK IF PROGRAM WAS STARTED FROM MENU OR FROM TRANSID 
           EXEC CICS ASSIGN
                     STARTCODE (START-CODE)
           END-EXEC                        
                                       
           EVALUATE TRUE       
             WHEN EIBCALEN = 0 AND
                  START-CODE = 'SD'                                    
                EXEC CICS RETRIEVE 
                          SET (ADDRESS OF DFHCOMMAREA)           
                          LENGTH (LENGTH OF DFHCOMMAREA)         
                          RESP (EIBRESP)                         
                END-EXEC                                                  
                EVALUATE EIBRESP                                          
                   WHEN DFHRESP (NORMAL)
                     MOVE DFHCOMMAREA     TO WS-COMMAREA                    
                     IF WS-CA-ACCTNO-TOP NOT = SPACES
                       MOVE WS-CA-ACCTNO-TOP  
                                          TO ACCTDO
                       PERFORM START-BROWSE-ACCTFIL
                       PERFORM BROWSE-FORWARD-ACCTFIL
                         VARYING I FROM 1 BY 1 
                         UNTIL I > 16
                       PERFORM CICS-SEND-MAP  
                       PERFORM CICS-RETURN                             
                     ELSE    
                       MOVE 'PRESS ENTER TO START AT THE TOP OF FILE'
                                          TO MSGO
                       PERFORM CICS-SEND-MAP  
                       PERFORM CICS-RETURN  
                     END-IF                                              
                   WHEN DFHRESP (ENDDATA)                    
                     MOVE 'PRESS ENTER TO START AT THE TOP OF FILE'
                                          TO MSGO
                     PERFORM CICS-SEND-MAP  
                     PERFORM CICS-RETURN                                                                                                             
                   WHEN OTHER                                             
                      CONTINUE                               
                END-EVALUATE
             WHEN EIBCALEN = 0
                MOVE 'PRESS ENTER TO START AT THE TOP OF FILE BY NAME' 
                                          TO MSGO
                PERFORM CICS-SEND-MAP 
                PERFORM CICS-RETURN                          
           END-EVALUATE           
            
           MOVE DFHCOMMAREA               TO WS-COMMAREA
           
           EVALUATE TRUE
             WHEN EIBAID = DFHCLEAR
               MOVE SPACES                TO WS-CA-IN-ACCTNO       
                                             WS-CA-IN-NAME 
               MOVE 'PRESS ENTER TO START AT THE TOP OF FILE'
                                          TO MSGO
               SET DATAONLY-OFF           TO TRUE                            
               PERFORM CICS-SEND-MAP  
               PERFORM CICS-RETURN                    
             WHEN EIBAID = DFHPF1
             WHEN EIBAID = DFHPF2
               MOVE 'INVALID FUNCTION KEY PRESSED' 
                                          TO MSGO 
             WHEN EIBAID = DFHPF3
               INITIALIZE WS-COMMAREA             
               MOVE 'ACMN'                TO WS-CA-TRANSID
               PERFORM START-NEW-TRANSID
      ****** SEARCH BY ACCOUNT NUMBER   
             WHEN EIBAID = DFHPF7         AND 
                  WS-CA-ACCTNO-TOP <= WS-CA-IN-ACCTNO
               MOVE 'TOP OF SEARCH REACHED FOR SPECIFIED ACCOUNT' 
                                          TO MSGO                                  
      * IF YOU ARE AT TOP OF THE FILE SEND MESSAGE AND CONTINUE         
             WHEN EIBAID = DFHPF7         AND 
                           TOP-FILE-ON
               MOVE WS-CA-IN-ACCTNO       TO ACCTSMO            
               MOVE 'TOP OF FILE REACHED' TO MSGO
             WHEN EIBAID = DFHPF7 
               MOVE SPACES                TO MSGO                                                       
               PERFORM PAGE-BACK-ACCTFIL             
      * IF YOU ARE AT BOTTOM OF THE FILE SEND MESSAGE AND CONTINUE 
             WHEN EIBAID = DFHPF8         AND
                           BOTTOM-FILE-ON
               MOVE WS-CA-IN-ACCTNO       TO ACCTSMO   
               MOVE 'BOTTOM OF FILE REACHED' 
                                          TO MSGO                           
             WHEN EIBAID = DFHPF8         
               MOVE SPACES                TO MSGO                            
               PERFORM PAGE-NEXT-ACCTFIL
             WHEN EIBAID = DFHPF9
               PERFORM DETERMINE-CURSOR-POSN
               MOVE WS-CA-ACCTNO-TOP      TO WS-CA-IN-ACCTNO                  
               MOVE EIBTRNID              TO WS-CA-PREV-TRANSID               
               MOVE 'ACDI'                TO WS-CA-TRANSID
               INITIALIZE WS-CA-REINIT-AREA               
               PERFORM START-NEW-TRANSID
             WHEN EIBAID = DFHPF10
               PERFORM DETERMINE-CURSOR-POSN
               MOVE WS-CA-ACCTNO-TOP      TO WS-CA-IN-ACCTNO   
               MOVE EIBTRNID              TO WS-CA-PREV-TRANSID                            
               MOVE 'ACUP'                TO WS-CA-TRANSID
               INITIALIZE WS-CA-REINIT-AREA                 
               PERFORM START-NEW-TRANSID                       
             WHEN EIBAID = DFHPF11
               PERFORM DETERMINE-CURSOR-POSN
               MOVE SPACES                TO WS-CA-IN-ACCTNO   
               MOVE EIBTRNID              TO WS-CA-PREV-TRANSID               
               MOVE 'ACIN'                TO WS-CA-TRANSID
               INITIALIZE WS-CA-REINIT-AREA               
               PERFORM START-NEW-TRANSID      
             WHEN EIBAID = DFHPF12
               PERFORM DETERMINE-CURSOR-POSN
               MOVE WS-CA-ACCTNO-TOP      TO WS-CA-IN-ACCTNO   
               MOVE EIBTRNID              TO WS-CA-PREV-TRANSID               
               MOVE 'ACDE'                TO WS-CA-TRANSID
               INITIALIZE WS-CA-REINIT-AREA               
               PERFORM START-NEW-TRANSID                                             
             WHEN OTHER
               PERFORM RECEIVE-MAP  
           END-EVALUATE
                 
           PERFORM CICS-SEND-MAP                                                                                                                                                                                                
           PERFORM CICS-RETURN              
                                                                                                  
           GOBACK                                                                    
           .            
       CICS-SEND-MAP.
              
           MOVE WS-CA-IN-ACCTNO           TO ACCTSMO
              
           EXEC CICS ASKTIME
                ABSTIME (WS-ABSTIME)
           END-EXEC

           EXEC CICS FORMATTIME
                ABSTIME(WS-ABSTIME)
                MMDDYYYY(DATEO)
                DATESEP('/')
                TIME  (TIMEO)
                TIMESEP (':')
           END-EXEC
           
           IF DATAONLY-ON
               MOVE -1                   TO ACCTSML
               EXEC CICS SEND 
                         MAP('ACCTSRM') 
                         MAPSET('ACCTSRA') 
                         FROM (ACCTSRMO)
                         CURSOR
                         FREEKB
                         DATAONLY 
               END-EXEC
           ELSE    
               IF WS-CA-NEXT-CPOSN > ZEROS
                 MOVE -1                  TO POS01L
               ELSE
                 MOVE -1                  TO ACCTSML
               END-IF
               EXEC CICS SEND 
                         MAP('ACCTSRM') 
                         MAPSET('ACCTSRA') 
                         FROM (ACCTSRMO)
                         CURSOR
                         FREEKB
                         ERASE 
               END-EXEC 
               SET DATAONLY-ON            TO TRUE
           END-IF    
           .
       CICS-RETURN.
       
           EXEC CICS RETURN 
                     TRANSID(TRANS-NAME) 
                     COMMAREA (WS-COMMAREA)
                     LENGTH (LENGTH OF WS-COMMAREA)
           END-EXEC
           GOBACK
           .
       RECEIVE-MAP.

           EXEC CICS RECEIVE 
                     MAP('ACCTSRM') 
                     MAPSET('ACCTSRA') 
                     RESP(CICS-RESP) 
           END-EXEC
           EVALUATE CICS-RESP   
             WHEN DFHRESP(MAPFAIL)
               IF WS-CA-IN-ACCTNO = SPACES 
                 SET DATAONLY-OFF         TO TRUE
                 MOVE ZEROS               TO WS-CA-IN-ACCTNO
                 PERFORM START-BROWSE-ACCTFIL
                 PERFORM BROWSE-FORWARD-ACCTFIL
                    VARYING I FROM 1 BY 1 
                    UNTIL I > 16  
               END-IF         
             WHEN DFHRESP(NORMAL)
               MOVE SPACES                TO MSGO
               PERFORM VALIDATE-ENTERED-VALUE                              
           END-EVALUATE        
           .
       VALIDATE-ENTERED-VALUE.
      
         
           MOVE ACCTSMI                   TO WS-CA-IN-ACCTNO
                                             WS-CA-ACCTNO-TOP
                                             ACCTDO 
                                                 
           IF ACCTSMF NOT = LOW-VALUE
                MOVE SPACES               TO WS-CA-ACCTNO-TOP
           END-IF 

           IF WS-CA-ACCTNO-TOP NOT NUMERIC
               MOVE ZEROS                 TO WS-CA-ACCTNO-TOP
           END-IF
                           
           PERFORM START-BROWSE-ACCTFIL
           PERFORM BROWSE-FORWARD-ACCTFIL
             VARYING I FROM 1 BY 1 
             UNTIL I > 16                  
                     
           .                                   
       START-BROWSE-ACCTFIL. 
                     
           EXEC CICS STARTBR 
                     DATASET('ACCTFIL') 
                     RIDFLD(ACCTDO) 
                     GTEQ
                     RESP(CICS-RESP)
           END-EXEC
      $if displaymode = 1     
           DISPLAY PGM-NAME 
           "BACKWARD-SRCH-RESUME: STARTBR RESPONSE=" CICS-RESP 
           ". EIBRESP=" EIBRESP 
           ". NAMEDO OF ACCTREC=" NAMEDO OF ACCTREC "." 
               UPON SYSERR
      $end-if     
           IF CICS-RESP = DFHRESP(NOTFND)
      $if displaymode = 1     
               DISPLAY PGM-NAME 
            "BACKWARD-SRCH-RESUME: STARTBR CICS REPONSE CODE IS NOTFND" 
                   UPON SYSERR
      $end-if    
             MOVE 'RECORD NOT FOUND'      TO MSGO                   
           ELSE
               IF CICS-RESP NOT = ZERO 
      $if displaymode = 1         
                   DISPLAY PGM-NAME 
                 "BACKWARD-SRCH-RESUME: STARTBR BAD CICS REPONSE CODE " 
                   CICS-RESP 
                    UPON SYSERR
      $end-if 
                   MOVE "ERROR OCCURED"   TO MSGO             
               END-IF    
           END-IF
           .     
       PAGE-BACK-ACCTFIL.     
           MOVE WS-CA-ACCTNO-TOP          TO ACCTDO 
           PERFORM START-BROWSE-ACCTFIL
           PERFORM BROWSE-BACKWARD-ACCTFIL
              VARYING I FROM 16 BY -1 
              UNTIL I < 1 
           .      
       PAGE-NEXT-ACCTFIL.
           MOVE WS-CA-ACCTNO-BOT          TO ACCTDO 
           PERFORM START-BROWSE-ACCTFIL
           PERFORM BROWSE-FORWARD-ACCTFIL
              VARYING I FROM 1 BY 1 
              UNTIL I > 16 
           .         
       BROWSE-FORWARD-ACCTFIL. 

      $if displaymode = 1   
           DISPLAY PGM-NAME 
           "SRCH-LOOP: BEFORE READNEXT. NAMEDO=" NAMEDO "."   
             UPON SYSERR.
      $end-if             
           EXEC CICS READNEXT 
                     DATASET('ACCTFIL') 
                     INTO(ACCTREC)
                     LENGTH(LENGTH OF ACCTREC) 
                     RIDFLD(ACCTDO) 
                     RESP(CICS-RESP)
           END-EXEC
      $if displaymode = 1       
           DISPLAY ACCTREC UPON SYSERR
      $end-if      
           EVALUATE CICS-RESP 
             WHEN DFHRESP(NORMAL)
               IF I > 15
      * GET THE NEXT RECORD FOR THE TOP OF NEXT PAGE                 
                  MOVE ACCTDO             TO WS-CA-ACCTNO-BOT
               ELSE                
                  SET RESET-FILE-FLAG     TO TRUE
                  PERFORM BUILD-MAP
               END-IF   
             WHEN DFHRESP(ENDFILE)
                MOVE 17                   TO I
                SET BOTTOM-FILE-ON        TO TRUE             
                SET DATAONLY-OFF          TO TRUE
                MOVE WS-CA-IN-ACCTNO      TO ACCTSMO
                MOVE 'BOTTOM OF FILE REACHED' 
                                          TO MSGO
             WHEN OTHER
               DISPLAY "CICS-RESP: " CICS-RESP UPON SYSERR                                            
           END-EVALUATE            
           .
       BROWSE-BACKWARD-ACCTFIL. 

      $if displaymode = 1   
           DISPLAY PGM-NAME 
           "SRCH-LOOP: BEFORE READPREV. NAMEDO=" NAMEDO "."  
             UPON SYSERR.
      $end-if             
           EXEC CICS READPREV
                     DATASET('ACCTFIL') 
                     INTO(ACCTREC)
                     LENGTH(LENGTH OF ACCTREC) 
                     RIDFLD(ACCTDO) 
                     RESP(CICS-RESP)
           END-EXEC
      $if displaymode = 1       
           DISPLAY ACCTREC UPON SYSERR
      $end-if      
           EVALUATE CICS-RESP
             WHEN DFHRESP(NORMAL)
               IF ACCTDO = WS-CA-ACCTNO-TOP
                           AND I = 16
                 MOVE ACCTDO              TO WS-CA-ACCTNO-BOT
               ELSE                                           
                  IF I < 1 
      * GET THE PREVIOUS RECORD FOR THE BOTTOM OF NEXT PAGE                 
                      MOVE ACCTDO         TO WS-CA-ACCTNO-TOP
                  ELSE                
                     SET RESET-FILE-FLAG  TO TRUE
                     PERFORM BUILD-MAP
                  END-IF
                END-IF                   
             WHEN DFHRESP(ENDFILE)                                  
               MOVE ZEROS                 TO I
               SET TOP-FILE-ON            TO TRUE                      
               SET DATAONLY-OFF           TO TRUE
               MOVE WS-CA-IN-ACCTNO       TO ACCTSMO
               MOVE 'TOP OF FILE REACHED' TO MSGO 
             WHEN OTHER
               DISPLAY "CICS-RESP: " CICS-RESP UPON SYSERR   
           END-EVALUATE           
           .                           
       BUILD-MAP. 
                        
           MOVE ACCTDO                    TO SL-ACCT     
                                             WS-CA-ACCTNO-ENTRY (I) 
           EVALUATE TRUE
             WHEN I = 1             AND
                 (WS-CA-IN-ACCTNO = ZEROS OR 
                                    SPACES OR 
                                    LOW-VALUES)
      * IF NO ACCOUNT NUMBER IS ENTERED, 
      * MAKE THE VERY FIRST ENTRY THE TOP OF FILE            
               MOVE ACCTDO                TO WS-CA-IN-ACCTNO                    
             WHEN I = 1
      * TOP OF PAGE MARKER       
               MOVE ACCTDO                TO WS-CA-ACCTNO-TOP
             WHEN OTHER                   
              CONTINUE
           END-EVALUATE                    
                                     
           MOVE SNAMEDO                   TO SL-SNAME     
           MOVE FNAMEDO                   TO SL-FNAME 
           MOVE MIDO                      TO SL-MID
           MOVE TTLDO                     TO SL-TTL   
           MOVE ADDR1DO                   TO SL-ADDR1                    
           MOVE ADDR3DO                   TO SL-STATE                       
           MOVE LIMITDO                   TO SL-LIMIT
           MOVE '_'                       TO ACCTSRH-POS (I)
           MOVE DFHBMBRY                  TO ACCTSRH-ATTR (I)                          
      * POPULATE SCREEN BUFFER                                               
           MOVE WS-SCREEN-LINE            TO ACCTSRH-ENTRY (I)                               
                                               
      $if displaymode = 1     
           DISPLAY PGM-NAME 
          "BUILD-MAP: ACCTNO=" SL-ACCT 
          ". LAST NAME=" SL-SNAME "."
          ". FIRST NAME=" SL-FNAME "." 
              UPON SYSERR
      $end-if        
           .  
       DETERMINE-CURSOR-POSN.
       
           EVALUATE TRUE 
            WHEN EIBCPOSN = 561 
               MOVE WS-CA-ACCTNO-ENTRY(1) TO WS-CA-ACCTNO-TOP
            WHEN EIBCPOSN = 641 
               MOVE WS-CA-ACCTNO-ENTRY(2) TO WS-CA-ACCTNO-TOP        
            WHEN EIBCPOSN = 721 
               MOVE WS-CA-ACCTNO-ENTRY(3) TO WS-CA-ACCTNO-TOP
            WHEN EIBCPOSN = 801 
               MOVE WS-CA-ACCTNO-ENTRY(4) TO WS-CA-ACCTNO-TOP            
            WHEN EIBCPOSN = 881 
               MOVE WS-CA-ACCTNO-ENTRY(5) TO WS-CA-ACCTNO-TOP         
            WHEN EIBCPOSN = 961 
               MOVE WS-CA-ACCTNO-ENTRY(6) TO WS-CA-ACCTNO-TOP      
            WHEN EIBCPOSN = 1041 
               MOVE WS-CA-ACCTNO-ENTRY(7) TO WS-CA-ACCTNO-TOP    
            WHEN EIBCPOSN = 1121 
               MOVE WS-CA-ACCTNO-ENTRY(8) TO WS-CA-ACCTNO-TOP
            WHEN EIBCPOSN = 1201 
               MOVE WS-CA-ACCTNO-ENTRY(9) TO WS-CA-ACCTNO-TOP 
            WHEN EIBCPOSN = 1281 
               MOVE WS-CA-ACCTNO-ENTRY(10) TO WS-CA-ACCTNO-TOP  
            WHEN EIBCPOSN = 1361 
               MOVE WS-CA-ACCTNO-ENTRY(11) TO WS-CA-ACCTNO-TOP
            WHEN EIBCPOSN = 1461 
               MOVE WS-CA-ACCTNO-ENTRY(12) TO WS-CA-ACCTNO-TOP
            WHEN EIBCPOSN = 1521          
               MOVE WS-CA-ACCTNO-ENTRY(13) TO WS-CA-ACCTNO-TOP
            WHEN EIBCPOSN = 1601 
               MOVE WS-CA-ACCTNO-ENTRY(14) TO WS-CA-ACCTNO-TOP
            WHEN EIBCPOSN = 1681 
               MOVE WS-CA-ACCTNO-ENTRY(15) TO WS-CA-ACCTNO-TOP                                                                                                                              
            WHEN OTHER
               CONTINUE
           END-EVALUATE
           .          
                         
       START-NEW-TRANSID.
       
           EXEC CICS START TRANSID  (WS-CA-TRANSID)                    
                           FROM     (WS-COMMAREA)                  
                           LENGTH   (LENGTH OF WS-COMMAREA)                     
                           TERMID   (EIBTRMID)                       
                           RTERMID  (EIBTRMID)                       
                           RESP     (CICS-RESP)                      
           END-EXEC
           EXEC CICS RETURN
           END-EXEC
           GOBACK
           .                       