package com.heirloom.demo.facade;

import java.util.HashMap;
import java.util.Map;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Properties;
import com.heirloom.demo.account.acctdis;
import javax.naming.NamingException;
import com.heirloomcomputing.etp.transaction.api.TransactionEnvironment;
import com.heirloomcomputing.etp.transaction.services.SimpleTransactionEnvironment;

public class getAccount {
	private acctdis pgmInstance;

	/*
	 * The facade to the original (compiled from COBOL to java) code
	 * creates a transaction environment since we won't be running under 
	 * Heirloom's transaction environment under a JEE server
	 * 
	 * Loads the database settings for the application since they're
	 * not supplied by the deploy project (we're not running under it)
	 * 
	 * Finally call the original procedure (now a Java method)
	 * and return the data.
	 * 
	 *
	 */
	public getAccount() {
		// load system properties to pick up db connection credential
		// shown here as an example, there are various ways to configure
		// db connections 
		loadProperties();
		
		// create instance of old cobol program
		this.pgmInstance = new acctdis();
		// create a lightweight transaction environment
		TransactionEnvironment env = null;
		try {
			env = new SimpleTransactionEnvironment().buildTransactionEnvironment();
		} catch (NamingException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		
		// set pgmInstance context to initialize for execution
		if (env!=null) {
			this.pgmInstance.setup(this.pgmInstance._context);
			this.pgmInstance._setTransactionEnvironment(env);			
		}
		else {
			System.err.println("Unable to establish transaction environment");
		}
		
	}
	
	
	public void setInputParams(String parm1) {

		pgmInstance.wrk.ws_ca_acctno_top_OF_ws_commarea.fromText(parm1);
	}
	
	
	public Map<String,Object> getOutputs() {
		Map<String,Object> rc = new HashMap<String,Object>();
		
		rc.put("wrk.teldo_OF_acctrec", pgmInstance.wrk.teldo_OF_acctrec.toString());
		rc.put("wrk.limitdo_OF_acctrec", pgmInstance.wrk.limitdo_OF_acctrec.toString());
		rc.put("wrk.bal1do_OF_acctdtmo", pgmInstance.wrk.bal1do_OF_acctdtmo.toString());
		return rc;
	}

	public void invokeService() {
       try {
		    pgmInstance.read_acctfil_OF_defaultsection_0();
       }
       catch (com.heirloomcomputing.ecs.exec.ExitProgramException epe) {
       // be silent on this one
       }
	}

   private void loadProperties() {
       Properties p = new Properties();
       // retrieve the location of the properties file from environment or property settings
       String propertyFile =System.getenv("heirloom_facade_properties");
       if (propertyFile == null || propertyFile == "") {
    	   propertyFile =System.getProperty("heirloom_facade_properties","");
       }
       if (propertyFile == "") {
    	   // if not passed expect to find properties file in facade/<facadeName>
           // TODO - You’ll need to change the location of this file depending on how and where you deploy to
    	   System.out.println("No property passed");
    	   propertyFile= "facade/getAccount.properties";
       }
       FileInputStream input;
       try {
           input = new FileInputStream(propertyFile);
           p.load(input);
           for (String name : p.stringPropertyNames()) {
                 String value = p.getProperty(name);
                 System.setProperty(name, value);
           }
       } catch (FileNotFoundException e) {
           e.printStackTrace();
       } catch (IOException e) {
           e.printStackTrace();
       }
       finally {
           if (input != null)
               input.close();
       }

   }



}


