-- The ACCT sample application demo database.  ACCT is a CICS/VSAM example from IBM,
-- running under Elastic Transaction Processor in VSAM database transparancy mode.
-- Use these SQL statements to create the sample table and populate it.

-- Assumed this is created according to the Elastic COBOL "Getting Started Guide"
-- where "ACCTUSER" is the database user (Oracle, Postgres, MySQL) or schema (DB2)
-- created to hold the "ACCTUSER"."ACCTFIL" table, a table representation of the original VSAM file
-- Login to your database as the "root" or "super" user and create a user or
-- schema named "ACCTUSER". 

-- Note:  Create the table under the same user id that you will specify in the ETP
-- deploy settings (e.g., ACCTUSER) .  Or, qualify the table name in this schema 
-- with that user or schema name (ACCTUSER).

-- Note:  Most databases consider names to be case-irrelevent when accessed without quotes.  
-- Your database may require upper-case only names in which
-- all the names below (e.g., ACCTFIL, LAST_NAME, etc.) should be quoted
-- (e.g., "ACCTUSER"."ACCTFIL", "LAST_NAME").

-- Click Run > Run. Click on View Results icon. Click View Detail.
-- Quoted SQL object names (e.g., Table and Column names) are case sensitive in both Oracle XE and cobol program. 
-- Unquoted SQL object names are assumed to be uppercase.

-- If rerunning this a second time, issue this to remove the table:
DROP TABLE ACCTFIL;

-- Create the table:
CREATE TABLE ACCTFIL ( -- table name is case sensitive on some DBMSs
ACCTNO        CHAR(5) NOT NULL,  -- account number
LAST_NAME     CHAR(18) NOT NULL, -- surname aka last name
FIRST_NAME    CHAR(12) NOT NULL, -- first name
MID_NAME      CHAR(1),           -- middle name 
TITL          CHAR(4),           -- title
PHONE_NO      CHAR(10),          -- telephone
ADDR1         CHAR(24) NOT NULL, -- address line 1 (street)
ADDR2         CHAR(24),          -- address line 2 (city)
ADDR3         CHAR(24),          -- address line 3 (state)
AUTH1         CHAR(32),          -- authorized code
AUTH2         CHAR(32),
AUTH3         CHAR(32),
AUTH4         CHAR(32),
CARD_COUNT    DECIMAL(1) NOT NULL, -- DECIMAL of cards issued 
ISSUEMO       CHAR(2) NOT NULL,  -- month issued (01 - 12)
ISSUEDAY      CHAR(2) NOT NULL,  -- date issued
ISSUEYR       CHAR(4) NOT NULL,  -- year issued 
RSN           CHAR(1),           -- reason code
CCODE         CHAR(1),           -- card code
APPR          CHAR(3),           -- approved by persons initials
SCODE1        CHAR(1),           -- special codes
SCODE2        CHAR(1),
SCODE3        CHAR(1),
STAT          CHAR(2) NOT NULL,  -- account status
CREDIT_LIMIT  DECIMAL(7,2) NOT NULL,   -- charge limit. PICTURE 9(5)V99. Example: 15000.00
PAYM1_DATE    DECIMAL(8),        -- YYYYMMDD
PAYM1_PAYMENT DECIMAL(6,2),      -- PICTURE 9(4)V99
PAYM1_BALANCE DECIMAL(7,2),      -- PICTURE 9(5)V99
PAYM2_DATE    DECIMAL(8),        -- YYYYMMDD
PAYM2_PAYMENT DECIMAL(6,2),      -- PICTURE 9(4)V99
PAYM2_BALANCE DECIMAL(7,2),      -- PICTURE 9(5)V99
PAYM3_DATE    DECIMAL(8),        -- YYYYMMDD
PAYM3_PAYMENT DECIMAL(6,2),      -- PICTURE 9(4)V99
PAYM3_BALANCE DECIMAL(7,2)       -- PICTURE 9(5)V99
);

-- Add the primary key
ALTER TABLE ACCTFIL
    ADD CONSTRAINT ACCTFIL_PK primary key (ACCTNO);

-- Add an alternate index:
CREATE INDEX ACCTFIL_AIX ON ACCTFIL (LAST_NAME, FIRST_NAME);

-- Commit those changes to the database:
COMMIT;

-- Insert data into the table:
INSERT INTO ACCTFIL VALUES ('10000', 'SMITH', 'JOHN', 'C', 'MR', '3131238877', '24 BATTLE CREEK RD', 'BATTLE CREEK', 'MI', 'AUTH1-10001', '', '', '', 2, '11', '30', '2014', 'R', 'C', 'APP', '1', '2', '3', 'ST', 15000.00, 20140114, 1234.56, 76543.21, 20140215, 2458.12, 66780.42, 20140116, 2345.67, 12241.46);
INSERT INTO ACCTFIL VALUES ('10001', 'SMITH', 'GINA', 'M', 'MS', '3134678785', '877 KALAMAZOO WAY', 'KALAMAZOO', 'MI', 'AUTH1-10001', '', '', '', 3, '01', '02', '2011', '', '', '', '', '', '', 'MA', 11000.00, 20140114, 1234.56, 76543.21, 20140215, 2458.12, 66780.42, 20140116, 2345.67, 12241.46);
INSERT INTO ACCTFIL VALUES ('10002', 'SMITH', 'JOHN', 'D', 'DR', '3137854342', '54 SUMMER WIND RD', 'KALAMAZOO', 'MI', 'AUTH1-10001', '', '', '', 1, '01', '02', '2011', '', '', '', '', '', '', 'MA', 12000.00, 20140114, 1234.56, 76543.21, 20140215, 2458.12, 66780.42, 20140116, 2345.67, 12241.46);
INSERT INTO ACCTFIL VALUES ('10003', 'SMITH', 'JOHN', 'R', 'MR', '3137787854', '54 SUMMER MOON RD', 'KALAMAZOO', 'MI', 'AUTH1-10001', '', '', '', 4, '01', '02', '2011', '', '', '', '', '', '', 'MA', 500.00, 20140114, 1234.56, 76543.21, 20140215, 2458.12, 66780.42, 20140116, 2345.67, 12241.46);
INSERT INTO ACCTFIL VALUES ('10004', 'GREENSTAN', 'TONI', 'M', 'MS', '7177854234', '34 BENTON AVE', 'SAN FRANCISCO', 'CA', 'AUTH1-20001', '', '', '', 2, '11', '15', '2010', 'N', 'A', 'RLL', '', '', '', 'N', 5000.00, 20140114, 1234.56, 76543.21, 20140215, 2458.12, 66780.42, 20140116, 2345.67, 12241.46);
INSERT INTO ACCTFIL VALUES ('10006', 'PEARLY', 'LARRY', '', '', '3131615279', '877 KALAMAZOO RD', 'KALAMAZOO', 'MI', 'AUTH1-4553', '', '', '', 2, '04', '04', '2011', 'N', 'A', 'LSP', '', '', '', 'N', 1000.00, 20140114, 1234.56, 76543.21, 20140215, 2458.12, 66780.42, 20140116, 2345.67, 12241.46);
INSERT INTO ACCTFIL VALUES ('10007', 'JONES', 'TOM', 'J', 'MR', '5136778534', '1010 COTTISFORD AVE', 'SAN JOSE', 'CA', 'AUTH1-47740', '', '', '', 2, '04', '04', '2011', 'N', 'A', 'LSP', '', '', '', 'N', 8000.50, 20140114, 1234.56, 76543.21, 20140215, 2458.12, 66780.42, 20140116, 2345.67, 12241.46);
INSERT INTO ACCTFIL VALUES ('10008', 'SHANNON', 'TERRY', 'S', 'MS', '2124905434', '1 BOSTON PLACE', 'MILLS', 'CA', 'NOBODY', 'AUTH1-4553', '', '', 1, '03', '03', '2011', 'N', 'A', 'LSP', '', '', '', 'N', 1000.62, 20140114, 1234.56, 76543.21, 20140215, 2458.12, 66780.42, 20140116, 2345.67, 12241.46);
INSERT INTO ACCTFIL VALUES ('10009', 'ROLAND', 'JOHN', 'M', 'MR', '3144223456', '45 BENTON STREET', 'CHICAGO', 'IL', 'AUTH1-4553', '', '', '', 1, '04', '06', '2011', 'N', 'A', 'LSP', '', '', '', 'N', 1000.00, 20140114, 1234.56, 76543.21, 20140215, 2458.12, 66780.42, 20140116, 2345.67, 12241.46);
INSERT INTO ACCTFIL VALUES ('10010', 'ROLAND', 'MYRON', 'A', 'MR', '2136778543', '384 17TH AVE', 'SAN FRANCISCO', 'CA', 'AUTH1-4553', '', '', '', 1, '04', '04', '2011', 'N', 'A', 'LSP', '', '', '', 'N', 1000.00, 20140114, 1234.56, 76543.21, 20140215, 2458.12, 66780.42, 20140116, 2345.67, 12241.46);
INSERT INTO ACCTFIL VALUES ('10011', 'SABRA', 'SAMRA', 'N', '', '4131349547', '877 KALAMAZOO RD', 'KALAMAZOO', 'MI', 'AUTH1-4553', '', '', '', 1, '01', '01', '2013', 'N', 'A', 'LSP', '', '', '', 'N', 1000.00, 20140114, 1234.56, 76543.21, 20140215, 2458.12, 66780.42, 20140116, 2345.67, 12241.46);
INSERT INTO ACCTFIL VALUES ('10012', 'SABRA', 'SYDNEY', 'G', '', '4131349547', '877 KALAMAZOO RD', 'KALAMAZOO', 'MI', 'AUTH1-4553', '', '', '', 1, '01', '02', '2011', 'N', 'A', 'LSP', '', '', '', 'N', 1000.00, 20140114, 1234.56, 76543.21, 20140215, 2458.12, 66780.42, 20140116, 2345.67, 12241.46);
INSERT INTO ACCTFIL VALUES ('10013', 'JONES', 'MIKE', 'S', '', '4131349547', '25 WAYLAND DR', 'DALLAS', 'TX', 'AUTH1-4553', '', '', '', 3, '04', '02', '2013', 'N', 'A', 'LSP', '', '', '', 'N', 1000.00, 20140114, 1234.56, 76543.21, 20140215, 2458.12, 66780.42, 20140116, 2345.67, 12241.46);
INSERT INTO ACCTFIL VALUES ('10014', 'STREET', 'JEFFREY', 'L', 'MR', '4131349547', '877 KALAMAZOO RD', 'KALAMAZOO', 'MI', 'AUTH1-4553', '', '', '', 1, '02', '04', '2011', 'N', 'A', 'LSP', '', '', '', 'N', 1000.00, 20140114, 1234.56, 76543.21, 20140215, 2458.12, 66780.42, 20140116, 2345.67, 12241.46);
INSERT INTO ACCTFIL VALUES ('10015', 'ROLAND', 'JOHN', 'S', 'MR', '2131288345', '45 BENTON STREET', 'AUBURN', 'AL', 'AUTH1-4553', '', '', '', 1, '02', '02', '2011', 'N', 'A', 'LSP', '', '', '', 'N', 1000.00, 20140114, 1234.56, 76543.21, 20140215, 2458.12, 66780.42, 20140116, 2345.67, 12241.46);
INSERT INTO ACCTFIL VALUES ('10016', 'GABBY', 'GREG', 'J', 'MR', '5154388434', '1010 COTTISFORD AVE', 'SAN JOSE', 'CA', 'AUTH1-4553', '', '', '', 2, '04', '04', '2011', 'N', 'A', 'LSP', '', '', '', 'N', 1000.00, 20140114, 1234.56, 76543.21, 20140215, 2458.12, 66780.42, 20140116, 2345.67, 12241.46);
INSERT INTO ACCTFIL VALUES ('10017', 'GABER', 'ALEX', 'K', 'MR', '2188823457', '1021 DOHERTY RIDGE ST', 'SAN JOSE', 'CA', 'AUTH1-3445', '', '', '', 2, '04', '04', '2011', 'N', 'A', 'LSP', '', '', '', 'N', 1000.00, 20140114, 1234.56, 76543.21, 20140215, 2458.12, 66780.42, 20140116, 2345.67, 12241.46);
INSERT INTO ACCTFIL VALUES ('10018', 'GABINO', 'MIKE', 'U', 'MR', '8155781234', '123 SUNNY BLVD', 'SAN JOSE', 'CA', 'AUTH1-9978', '', '', '', 2, '04', '04', '2011', 'N', 'A', 'LSP', '', '', '', 'N', 1000.00, 20140114, 1234.56, 76543.21, 20140215, 2458.12, 66780.42, 20140116, 2345.67, 12241.46);
INSERT INTO ACCTFIL VALUES ('10019', 'GREEN', 'STANLEY', 'B', 'MR', '8155981235', '534 STEVENS CREEK RD', 'SAN JOSE', 'CA', 'AUTH1-6778', '', '', '', 2, '04', '04', '2011', 'N', 'A', 'LSP', '', '', '', 'N', 1000.00, 20140114, 1234.56, 76543.21, 20140215, 2458.12, 66780.42, 20140116, 2345.67, 12241.46);
INSERT INTO ACCTFIL VALUES ('10020', 'GREEN', 'MIKE', 'Y', 'MR', '5156397368', '94 CIELO VISTA WY', 'SAN JOSE', 'CA', 'AUTH1-445', '', '', '', 2, '04', '04', '2011', 'N', 'A', 'LSP', '', '', '', 'N', 1000.00, 20140114, 1234.56, 76543.21, 20140215, 2458.12, 66780.42, 20140116, 2345.67, 12241.46);
INSERT INTO ACCTFIL VALUES ('10021', 'GREEN', 'JORGE', 'C', 'MR', '2156257388', '845 HOWARD COURT', 'SAN JOSE', 'CA', 'AUTH1-2234', '', '', '', 2, '04', '04', '2011', 'N', 'A', 'LSP', '', '', '', 'N', 1000.00, 20140114, 1234.56, 76543.21, 20140215, 2458.12, 66780.42, 20140116, 2345.67, 12241.46);
INSERT INTO ACCTFIL VALUES ('10022', 'GREENLAND', 'TOM', 'X', 'MR', '6198237126', '38 19TH AVE', 'SAN JOSE', 'CA', 'AUTH1-4556', '', '', '', 2, '04', '04', '2011', 'N', 'A', 'LSP', '', '', '', 'N', 1000.00, 20140114, 1234.56, 76543.21, 20140215, 2458.12, 66780.42, 20140116, 2345.67, 12241.46);
INSERT INTO ACCTFIL VALUES ('10023', 'GREENSIDE', 'PETE', 'H', 'MR', '2163566379', '485 13TH ST', 'SAN JOSE', 'CA', 'AUTH1-47740', '', '', '', 2, '04', '04', '2011', 'N', 'A', 'LSP', '', '', '', 'N', 1000.00, 20140114, 1234.56, 76543.21, 20140215, 2458.12, 66780.42, 20140116, 2345.67, 12241.46);
INSERT INTO ACCTFIL VALUES ('10024', 'GREENLY', 'ADAM', 'L', 'MR', '6122657256', '58 LONG RIDGE RD', 'SAN JOSE', 'CA', 'AUTH1-3223', '', '', '', 2, '04', '04', '2011', 'N', 'A', 'LSP', '', '', '', 'N', 1000.00, 20140114, 1234.56, 76543.21, 20140215, 2458.12, 66780.42, 20140116, 2345.67, 12241.46);
INSERT INTO ACCTFIL VALUES ('10025', 'GREENLY', 'ALAN', 'Z', 'MR', '6127683579', '563 SORICH AVE', 'SAN JOSE', 'CA', 'AUTH1-3442', '', '', '', 2, '04', '04', '2011', 'N', 'A', 'LSP', '', '', '', 'N', 1000.00, 20140114, 1234.56, 76543.21, 20140215, 2458.12, 66780.42, 20140116, 2345.67, 12241.46); 
INSERT INTO ACCTFIL VALUES ('10026', 'GREENSON', 'DUANE', 'R', 'MR', '3153658479', '64 PEARCE DR', 'SAN JOSE', 'CA', 'AUTH1-3322', '', '', '', 2, '04', '04', '2011', 'N', 'A', 'LSP', '', '', '', 'N', 1000.00, 20140114, 1234.56, 76543.21, 20140215, 2458.12, 66780.42, 20140116, 2345.67, 12241.46);
INSERT INTO ACCTFIL VALUES ('10027', 'REDLY', 'LISA', 'R', 'MR', '2125569479', '36 STEINER BLVD', 'SAN JOSE', 'CA', 'AUTH1-35675', '', '', '', 2, '04', '04', '2011', 'N', 'A', 'LSP', '', '', '', 'N', 1000.00, 20140114, 1234.56, 76543.21, 20140215, 2458.12, 66780.42, 20140116, 2345.67, 12241.46);
INSERT INTO ACCTFIL VALUES ('10028', 'REDD', 'PAT', 'Q', 'MS', '9107825546', '93 PORTOLA ST', 'SAN JOSE', 'CA', 'AUTH1-35567', '', '', '', 2, '04', '04', '2011', 'N', 'A', 'LSP', '', '', '', 'N', 14000.00, 20140114, 1234.56, 76543.21, 20140215, 2458.12, 66780.42, 20140116, 2345.67, 12241.46);
INSERT INTO ACCTFIL VALUES ('10029', 'REDSON', 'ANN', 'W', 'MS', '4146857898', '25 CLAY COURT', 'SAN JOSE', 'CA', 'AUTH1-47740', '', '', '', 2, '04', '04', '2011', 'N', 'A', 'LSP', '', '', '', 'N', 16000.00, 20140114, 1234.56, 76543.21, 20140215, 2458.12, 66780.42, 20140116, 2345.67, 12241.46);
INSERT INTO ACCTFIL VALUES ('10032', 'VAN AUSTIN', 'SAM', 'A', 'DR', '5127383568', '1024 WOODSIDE DR', 'CHEYENNE', 'WY', 'AUTH1-4223', '', '', '', 3, '01', '02', '2011', '', '', '', '', '', '', 'MA',500.00, 20140114, 1234.56, 76543.21, 20140215, 2458.12, 66780.42, 20140116, 2345.67, 12241.46);
INSERT INTO ACCTFIL VALUES ('10035', 'VAN AUSTIN', 'JOHN', 'B', 'DR', '2154625779', '421 WOODSIDE DR', 'DESMOINE', 'IA', 'AUTH1-47740', '', '', '', 4, '01', '02', '2011', '', '', '', '', '', '', 'MA', 500.00, 20140114, 1234.56, 76543.21, 20140215, 2458.12, 66780.42, 20140116, 2345.67, 12241.46);
INSERT INTO ACCTFIL VALUES ('10037', 'ZOOHEY', 'SAM', 'B', 'DR', '2151253579', '421 WOODSIDE DR', 'Iowa', '', 'Jared', 'AUTH1-2334', '', '', 5, '01', '02', '2011', '', '', '', '', '', '', 'MA', 500.00, 20140114, 1234.56, 76543.21, 20140215, 2458.12, 66780.42, 20140116, 2345.67, 12241.46);

-- Commit those changes to the database:
COMMIT;

