      *
      * BOOKGRID
      *
      * Copyright (C) 2010-2023 Heirloom Computing Inc.  All Rights Reserved.
      *
      * This file and associated files are copyrighted information
      * of Heirloom Computing.  Permission is granted for usage in 
      * conjunction with the Elastic COBOL product.
      *
      * User name is 'any'
      * Password is 'password'
      *
      * Enter revenue values into the grid at the appropriate months
      * for the appropriate authors.
      * 
      * After the values are entered, click the Calculate! button
      * to calculate the totals.  The values in the cells are
      * associated with currency values.
      *
       IDENTIFICATION DIVISION.
       PROGRAM-ID. BookGrid.

       ENVIRONMENT DIVISION.
       CONFIGURATION SECTION.
       INPUT-OUTPUT SECTION.
       FILE-CONTROL.
           select optional grid-file 
           assign to "grid.dat"
               file status is grid-status.
      
       DATA DIVISION.
       FILE SECTION.
       FD GRID-FILE.
       01 FILE-ITEM PIC $$$$,$$9.99.
          
       WORKING-STORAGE SECTION.
      * Temporary variables used in this sample.

       77 TOTAL PIC 99999999V99.
       77 TEMP  PIC 99999999V99.
       77 TEMPX PIC X(19).
       77 ROWNUM USAGE INDEX.
       77 COLNUM USAGE INDEX.
       
       01 GRID-TOTAL  PIC $$$$,$$9.99.
         
       77 GRID-STATUS PIC XX.
       
       77 ACCEPT-VALUE PIC 999 IS SPECIAL-NAMES CRT STATUS.
       
       78 SELECTED-PRINT VALUE 100.
       78 SELECTED-EXIT VALUE 101.
       78 SELECTED-ABOUT VALUE 102.
       78 SELECTED-CALCULATE VALUE 103.
       78 SELECTED-SAVE VALUE 104.
       78 SELECTED-RESTORE VALUE 105.
       
       01 LOGIN-INFO.
           05 LOGIN-USER PIC X(20) VALUE "any".
           05 LOGIN-PASSWORD PIC X(20) VALUE "password".
       
       SCREEN SECTION.
       01 LOGIN-SCREEN.
           05 LABEL "Enter 'any' and 'password' for access."
              LINE 1 COL 1
              .
           05 LABEL "User: " LINE 3 COL 1.
           05 LABEL "Password: " LINE 5 COL 1.
           05 ENTRY-FIELD USING LOGIN-USER
              LINE 3 COL 15.
           05 ENTRY_FIELD USING LOGIN-PASSWORD
              SECURE
              LINE 5 COL 15
              .
              
       01 MAIN-SCREEN.	      
           05 MENU
               BEGIN-MENU = "&File"
                   ITEM-TO-ADD = "&Print" 
        	   TERMINATION-VALUE=SELECTED-PRINT
        	   SEPARATOR
        	   ITEM-TO-ADD = "E&xit"
        	   TERMINATION-VALUE=SELECTED-EXIT
               END-MENU
               BEGIN-MENU = "&Help"
                   ITEM-TO-ADD = "&About"
        	   TERMINATION-VALUE=SELECTED-ABOUT
               END-MENU
               .
           05 LEFT-IMAGE BITMAP
              BITMAP-VALUE = "hci.png"
              LINE 1 COL 1
              SIZE 303 LINES 105
              .
           05 RIGHT-IMAGE LABEL
              COL PLUS 0
              LINE PLUS 0
              "Bookstore" FONT-NAME="Serif-64"
              .
           05 THE-GRID GRID
              LINE 10 COL 1
              LINES 11 SIZE 79
              COLUMN-HEADINGS ROW-HEADINGS CENTERED-HEADINGS
              DATA-SIZES = (12, 12, 12, 12, 12, 12, 12, 12, 12)
              DISPLAY-COLUMNS = (1, 13, 25, 37, 49, 61, 73, 84, 96)
              ALIGNMENT = ('R','R','R','R','R','R','R','R')
              NUM-ROWS = 8
              NUM-COLUMNS = 8
              HSCROLL
              VSCROLL
              ADJUSTABLE-COLUMNS
              TILED-HEADINGS
              .
           05 CALCULATE-IT PUSH-BUTTON "Calculate!"
              LINE 23 COL 30
              TERMINATION-VALUE = SELECTED-CALCULATE
              .
           05 SAVE-IT PUSH-BUTTON "Save"
              COL PLUS 2
              TERMINATION-VALUE = SELECTED-SAVE
              .
           05 RESTORE-IT PUSH-BUTTON "Restore"
              COL PLUS 2
              TERMINATION-VALUE = SELECTED-RESTORE
              .
      
       PROCEDURE DIVISION.
      *
      * Ask the user for a login name/password.
      * 
       LOGIN-SCREEN-PROMPT.
           DISPLAY INDEPENDENT GRAPHICAL WINDOW
               TITLE "Login"
               SIZE 40 LINES 8
               BACKGROUND-LOW
               INITIAL-COLORS
               MODELESS
               CENTERED
               
           DISPLAY LOGIN-SCREEN
           .
      
       LOGIN-LOOP.
           ACCEPT LOGIN-SCREEN
           IF LOGIN-USER NOT = "any" 
              OR LOGIN-PASSWORD NOT = "password" 
              THEN
                  DISPLAY MESSAGE BOX
                      "Enter 'any' and 'password'"
              GO TO LOGIN-LOOP
           END-IF
           
           CLOSE WINDOW
           .
      
      *
      * The program gets here only after a successful login.
      *	   
       MAIN-BOOKSTORE-PROGRAM.			      
       
           DISPLAY STANDARD GRAPHICAL WINDOW
              TITLE "Heirloom Bookstore"
              SIZE 82 LINES 25
              BACKGROUND-LOW
              CENTERED
           
           DISPLAY MAIN-SCREEN
           
           MODIFY THE-GRID
              X=2 Y=1 CELL-DATA = "King, Stephen"
              X=3 Y=1 CELL-DATA = "Jordan, Robert"
              X=4 Y=1 CELL-DATA = "Rice, Anne"
              X=5 Y=1 CELL-DATA = "Vinge, Vernor"
              X=6 Y=1 CELL-DATA = "Sullivan, Brian"
              X=7 Y=1 CELL-DATA = "Wolfe, Gene"
              X=8 Y=1 CELL-DATA = "Total"
              
              X=1 Y=2 CELL-DATA = "January"
              X=1 Y=3 CELL-DATA = "February"
              X=1 Y=4 CELL-DATA = "March"
              X=1 Y=5 CELL-DATA = "April"
              X=1 Y=6 CELL-DATA = "May"
              X=1 Y=7 CELL-DATA = "June"
              X=1 Y=8 CELL-DATA = "Total"
              
           DISPLAY THE-GRID
               
           PERFORM DO-RESTORE
           .
      
       MAIN-LOOP.	   
           ACCEPT MAIN-SCREEN
           
           EVALUATE ACCEPT-VALUE
               WHEN SELECTED-PRINT PERFORM DO-PRINT
               WHEN SELECTED-EXIT PERFORM DO-EXIT
               WHEN SELECTED-ABOUT PERFORM DO-ABOUT
               WHEN SELECTED-CALCULATE PERFORM DO-CALCULATE
               WHEN SELECTED-SAVE PERFORM DO-SAVE
               WHEN SELECTED-RESTORE PERFORM DO-RESTORE
           END-EVALUATE
           GO TO MAIN-LOOP
           .
       DO-PRINT.
           SHOW WINDOW UPON PRINTER
           .
           
       DO-EXIT.
           STOP ALL RUN
           .
           
       DO-CALCULATE.
       
           modify the-grid mass-update=true
           move 0 to total
           set rownum to 1
           set colnum to 1
           display "Summing columns..." upon sysout
           
           perform test after
               varying rownum from 2 by 1 until rownum=7
               move 0 to total

               perform test after
                   varying colnum from 2 by 1 until colnum=7
                   inquire the-grid (rownum, colnum) cell-data in tempx
                   move function numval (tempx) to temp
                   add temp to total
               end-perform

               move total to grid-total
               modify the-grid (rownum, 8) cell-data = grid-total
           end-perform
            
           move 0 to total
           set rownum to 1
           set colnum to 1
           display "Summing rows..." upon sysout
           
           perform test after
               varying colnum from 2 by 1 until colnum=7
               move 0 to total

               perform test after
                   varying rownum from 2 by 1 until rownum=7
                   inquire the-grid (rownum, colnum) cell-data in tempx
                   move function numval (tempx) to temp
                   add temp to total
               end-perform

               move total to grid-total
               modify the-grid (8, colnum) cell-data = grid-total
           end-perform
           
           move 0 to total
           set rownum to 1
           display "Summing total..." upon sysout
           
           perform test after
               varying rownum from 2 by 1 until rownum=7
               inquire the-grid (rownum, 8) cell-data in tempx
               move function numval (tempx) to temp
               add temp to total
           end-perform
           
           move total to grid-total
           modify the-grid (8, 8) cell-data = grid-total
           modify the-grid mass-update=false
           .
           
       DO-ABOUT.
           DISPLAY MESSAGE BOX
               TITLE = "About..."
               VALUE = "Heirloom Bookstore, " &
                       "(C) Heirloom Computing Inc."
           .		      
         
       DO-RESTORE SYNC FULL.
           display "Restoring..." UPON SYSOUT
           modify the-grid mass-update=true
           open input grid-file

           perform read-item
               varying rownum from 2 by 1 until rownum>8
               after   colnum from 2 by 1 until colnum>8

           modify the-grid mass-update=false
           display "GRID-FILE STATUS AFTER READ: " grid-status 
               upon sysout
           close grid-file
           display "GRID-FILE STATUS AFTER CLOSE: " grid-status 
               upon sysout
           .
           
       READ-ITEM.          
           read grid-file
           modify the-grid (rownum, colnum)
               cell-data = file-item
           .
           
       DO-SAVE SYNC FULL.
           display "Storing..." UPON SYSOUT
           
           open output GRID-FILE
           perform write-item
               varying rownum from 2 by 1 until rownum>8
               after   colnum from 2 by 1 until colnum>8
           display "GRID-FILE STATUS AFTER WRITE: " grid-status 
               upon sysout
           close grid-file
           display "GRID-FILE STATUS AFTER CLOSE: " grid-status 
               upon sysout
           .

       WRITE-ITEM.
           inquire the-grid (rownum, colnum)
               cell-data in file-item
           write file-item
           .
