      *
      * DDSCOBOL
      *
      * Copyright (C) 2010-2023 Heirloom Computing Inc.  All Rights Reserved.
      *
      * This file and associated files are copyrighted information
      * of Heirloom Computing.  Permission is granted for usage in 
      * conjunction with the Elastic COBOL product.
      *
      * DESCRIPTION:   TESTS PERCOBOL DDS SUPPORT
      *                THIS PROGRAM SHOULD RUN ON BOTH AS/400
      *                NATIVE COBOL AND PERCOBOL.
      *                RUN SIDE BY SIDE TO DO COMPARISON.
      *
      * INPUT FILES:   DDSFILE - DDS SOURCE CODE ON PERCOBOL
      *                          DDS BINARY CODE ON AS/400
      *
      * OUTPUT FILES:  NONE
      *
       IDENTIFICATION DIVISION.
       PROGRAM-ID.
           DDSCOBOL.

       ENVIRONMENT DIVISION.
       CONFIGURATION SECTION.
       INPUT-OUTPUT SECTION.
       FILE-CONTROL.
           SELECT TERMINAL-FILE
               ASSIGN TO WORKSTATION-DDSFILE
               ORGANIZATION IS TRANSACTION
               ACCESS IS DYNAMIC
               FILE STATUS IS F-STATUS
               RELATIVE KEY IS SUBFILE-RECORD-NUMBER.
       DATA DIVISION.
       FILE SECTION.
      *
       FD  TERMINAL-FILE
           LABEL RECORDS ARE OMITTED.
       01  TERMINAL-REC.
           COPY DDS-ALL-FORMATS OF DDSFILE.
      *
       WORKING-STORAGE SECTION.
       77  TRUE-VAL                      PIC 1 VALUE B"1".
       77  FALSE-VAL                     PIC 1 VALUE B"0".
       01  F-STATUS                      PIC 99 VALUE 0.
       01  LOOP-INDEX                    PIC 99 VALUE 0.
       01  DSPATRVAL                     PIC 99 BINARY.
       01  DSPATR-GROUP REDEFINES DSPATRVAL.
           05  FILLER                    PIC X.
           05  DSPATR                    PIC X.
       01  THE-TIME                      PIC 9(8).
       01  TIME-GROUP REDEFINES THE-TIME.
           05 HRS                        PIC 9(2).
           05 MINS                       PIC 9(2).
           05 SECS                       PIC 9(2).
           05 HSECS                      PIC 9(2).
       01  WAIT-TIME                     PIC 9(8).
       01  START-SECS                    PIC 9(8).
       01  CUR-SECS                      PIC 9(8).
       01  EXISTING-ORDER-DISPLAY-KEY.
           05  SUBFILE-RECORD-NUMBER     PIC 9(2) VALUE ZERO.
      *
       PROCEDURE DIVISION.
       MAIN-START.
           OPEN I-O TERMINAL-FILE
           IF F-STATUS NOT EQUAL 0 THEN GO TO ERROR-EXIT END-IF
           .
       MAIN-MENU-START.
           MOVE SPACES TO TERMINAL-REC
           WRITE TERMINAL-REC FORMAT "MAIN"
           IF F-STATUS NOT EQUAL 0 THEN GO TO ERROR-EXIT END-IF
           READ TERMINAL-FILE FORMAT "MAIN"
           IF F-STATUS NOT EQUAL 0 THEN GO TO ERROR-EXIT END-IF
           EVALUATE SELECTION OF MAIN-I
              WHEN "1"
                  GO TO RECORD-POS-TEST-START
              WHEN "2"
                  GO TO DSPATR-TEST-START
              WHEN "3"
                  GO TO OPIN-TEST-START
              WHEN "4"
                  GO TO MSG-TEST-START
              WHEN "5"
                  GO TO CURPOS-TEST-START
              WHEN "6"
                  GO TO KBDCTL-TEST-START
              WHEN "7"
                  GO TO DATAVAL-TEST-START
              WHEN "8"
                  GO TO EDIT-TEST-START
              WHEN "9"
                  GO TO REIN-TEST-START
              WHEN "A"
                  GO TO MISCOVR-TEST-START
              WHEN "B"
                  GO TO DATE-TEST-START
              WHEN "C"
                  GO TO ERRMSG-TEST-START
              WHEN "D"
                  GO TO HELPREC-TEST-START
              WHEN "E"
                  GO TO SFLREC-TEST-START
              WHEN "Q"
                  GO TO EXIT-START
           END-EVALUATE
           GO TO MAIN-MENU-START
           .
       RECORD-POS-TEST-START.
           WRITE TERMINAL-REC FORMAT "CLEARREC"
           WRITE TERMINAL-REC FORMAT "POSREC1" STARTING AT LINE 1
           WRITE TERMINAL-REC FORMAT "POSREC1" STARTING AT LINE 5
           WRITE TERMINAL-REC FORMAT "POSREC1" STARTING AT LINE 9
           WRITE TERMINAL-REC FORMAT "POSREC1" STARTING AT LINE 13
           WRITE TERMINAL-REC FORMAT "POSREC1" STARTING AT LINE 17
           WRITE TERMINAL-REC FORMAT "PAUSEREC" STARTING AT LINE 22
           READ TERMINAL-FILE FORMAT "PAUSEREC"
           WRITE TERMINAL-REC FORMAT "POSREC2"
           WRITE TERMINAL-REC FORMAT "PAUSEREC" STARTING AT LINE 22
           READ TERMINAL-FILE FORMAT "PAUSEREC"
           WRITE TERMINAL-REC FORMAT "POSREC3"
           WRITE TERMINAL-REC FORMAT "PAUSEREC" STARTING AT LINE 22
           READ TERMINAL-FILE FORMAT "PAUSEREC"
           WRITE TERMINAL-REC FORMAT "POSREC4" STARTING AT LINE 14
           WRITE TERMINAL-REC FORMAT "PAUSEREC" STARTING AT LINE 22
           READ TERMINAL-FILE FORMAT "PAUSEREC"
           WRITE TERMINAL-REC FORMAT "POSREC5" STARTING AT LINE 2
           WRITE TERMINAL-REC FORMAT "PAUSEREC" STARTING AT LINE 22
           READ TERMINAL-FILE FORMAT "PAUSEREC"
           WRITE TERMINAL-REC FORMAT "POSREC6" STARTING AT LINE 19
           WRITE TERMINAL-REC FORMAT "PAUSEREC" STARTING AT LINE 22
           READ TERMINAL-FILE FORMAT "PAUSEREC"
           WRITE TERMINAL-REC FORMAT "POSREC7" STARTING AT LINE 5
           WRITE TERMINAL-REC FORMAT "POSREC8" STARTING AT LINE 12
           WRITE TERMINAL-REC FORMAT "PAUSEREC" STARTING AT LINE 22
           READ TERMINAL-FILE FORMAT "PAUSEREC"
           WRITE TERMINAL-REC FORMAT "POSREC9" STARTING AT LINE 16
           WRITE TERMINAL-REC FORMAT "PAUSEREC" STARTING AT LINE 22
           READ TERMINAL-FILE FORMAT "PAUSEREC"
           GO TO MAIN-MENU-START
           .
       DSPATR-TEST-START.
           WRITE TERMINAL-REC FORMAT "DISPREC1"
           WRITE TERMINAL-REC FORMAT "PAUSEREC" STARTING AT LINE 22
           READ TERMINAL-FILE FORMAT "PAUSEREC"
           WRITE TERMINAL-REC FORMAT "DISPREC2"
           WRITE TERMINAL-REC FORMAT "PAUSEREC" STARTING AT LINE 22
           READ TERMINAL-FILE FORMAT "PAUSEREC"
           WRITE TERMINAL-REC FORMAT "CLEARREC"
           MOVE 32 TO DSPATRVAL
           PERFORM DSPATR-TEST-SUBROUTINE
           WRITE TERMINAL-REC FORMAT "PAUSEREC" STARTING AT LINE 22
           READ TERMINAL-FILE FORMAT "PAUSEREC"
           PERFORM DSPATR-TEST-SUBROUTINE
           WRITE TERMINAL-REC FORMAT "PAUSEREC" STARTING AT LINE 22
           READ TERMINAL-FILE FORMAT "PAUSEREC"
           GO TO MAIN-MENU-START
           .
       DSPATR-TEST-SUBROUTINE.
           MOVE DSPATR TO PFIELD1 OF DISPREC3-O
           MOVE 5 TO LOOP-INDEX
           PERFORM
             UNTIL LOOP-INDEX = 21
                WRITE TERMINAL-REC FORMAT "DISPREC3"
                   STARTING AT LINE LOOP-INDEX
                ADD 1 TO DSPATRVAL
                MOVE DSPATR TO PFIELD1 OF DISPREC3-O
                ADD 1 TO LOOP-INDEX
           END-PERFORM
           .
       OPIN-TEST-START.
           MOVE TRUE-VAL TO IN01 OF OPINREC1-O
           WRITE TERMINAL-REC FORMAT "OPINREC1"
           WRITE TERMINAL-REC FORMAT "PAUSEREC" STARTING AT LINE 22
           READ TERMINAL-FILE FORMAT "PAUSEREC"
           MOVE TRUE-VAL TO IN99 OF OPINREC1-O
           WRITE TERMINAL-REC FORMAT "OPINREC1"
           WRITE TERMINAL-REC FORMAT "PAUSEREC" STARTING AT LINE 22
           READ TERMINAL-FILE FORMAT "PAUSEREC"
           MOVE FALSE-VAL TO IN01 OF OPINREC1-O
           WRITE TERMINAL-REC FORMAT "OPINREC1"
           WRITE TERMINAL-REC FORMAT "PAUSEREC" STARTING AT LINE 22
           READ TERMINAL-FILE FORMAT "PAUSEREC"
           MOVE TRUE-VAL TO IN01 OF OPINREC1-O
           MOVE TRUE-VAL TO IN99 OF OPINREC1-O
           WRITE TERMINAL-REC FORMAT "OPINREC1"
           WRITE TERMINAL-REC FORMAT "PAUSEREC" STARTING AT LINE 22
           READ TERMINAL-FILE FORMAT "PAUSEREC"
           MOVE TRUE-VAL TO IN01 OF OPINREC2-O
           WRITE TERMINAL-REC FORMAT "OPINREC2"
           WRITE TERMINAL-REC FORMAT "PAUSEREC" STARTING AT LINE 22
           READ TERMINAL-FILE FORMAT "PAUSEREC"
           MOVE TRUE-VAL TO IN02 OF OPINREC2-O
           WRITE TERMINAL-REC FORMAT "OPINREC2"
           WRITE TERMINAL-REC FORMAT "PAUSEREC" STARTING AT LINE 22
           READ TERMINAL-FILE FORMAT "PAUSEREC"
           MOVE TRUE-VAL TO IN03 OF OPINREC2-O
           WRITE TERMINAL-REC FORMAT "OPINREC2"
           WRITE TERMINAL-REC FORMAT "PAUSEREC" STARTING AT LINE 22
           READ TERMINAL-FILE FORMAT "PAUSEREC"
           MOVE TRUE-VAL TO IN01 OF OPINREC2-O
           MOVE TRUE-VAL TO IN02 OF OPINREC2-O
           WRITE TERMINAL-REC FORMAT "OPINREC2"
           WRITE TERMINAL-REC FORMAT "PAUSEREC" STARTING AT LINE 22
           READ TERMINAL-FILE FORMAT "PAUSEREC"
           MOVE TRUE-VAL TO IN01 OF OPINREC2-O
           MOVE TRUE-VAL TO IN03 OF OPINREC2-O
           WRITE TERMINAL-REC FORMAT "OPINREC2"
           WRITE TERMINAL-REC FORMAT "PAUSEREC" STARTING AT LINE 22
           READ TERMINAL-FILE FORMAT "PAUSEREC"
           MOVE TRUE-VAL TO IN02 OF OPINREC2-O
           MOVE TRUE-VAL TO IN03 OF OPINREC2-O
           WRITE TERMINAL-REC FORMAT "OPINREC2"
           WRITE TERMINAL-REC FORMAT "PAUSEREC" STARTING AT LINE 22
           READ TERMINAL-FILE FORMAT "PAUSEREC"
           MOVE TRUE-VAL TO IN01 OF OPINREC2-O
           MOVE TRUE-VAL TO IN02 OF OPINREC2-O
           MOVE TRUE-VAL TO IN03 OF OPINREC2-O
           WRITE TERMINAL-REC FORMAT "OPINREC2"
           WRITE TERMINAL-REC FORMAT "PAUSEREC" STARTING AT LINE 22
           READ TERMINAL-FILE FORMAT "PAUSEREC"
           MOVE TRUE-VAL TO IN72 OF OPINREC2-O
           MOVE TRUE-VAL TO IN73 OF OPINREC2-O
           MOVE TRUE-VAL TO IN63 OF OPINREC2-O
           WRITE TERMINAL-REC FORMAT "OPINREC2"
           WRITE TERMINAL-REC FORMAT "PAUSEREC" STARTING AT LINE 22
           READ TERMINAL-FILE FORMAT "PAUSEREC"
           MOVE TRUE-VAL TO IN60 OF OPINREC2-O
           MOVE TRUE-VAL TO IN61 OF OPINREC2-O
           MOVE TRUE-VAL TO IN62 OF OPINREC2-O
           MOVE TRUE-VAL TO IN63 OF OPINREC2-O
           WRITE TERMINAL-REC FORMAT "OPINREC2"
           WRITE TERMINAL-REC FORMAT "PAUSEREC" STARTING AT LINE 22
           READ TERMINAL-FILE FORMAT "PAUSEREC"
           MOVE TRUE-VAL TO IN60 OF OPINREC2-O
           MOVE TRUE-VAL TO IN61 OF OPINREC2-O
           MOVE TRUE-VAL TO IN62 OF OPINREC2-O
           MOVE TRUE-VAL TO IN72 OF OPINREC2-O
           MOVE TRUE-VAL TO IN73 OF OPINREC2-O
           WRITE TERMINAL-REC FORMAT "OPINREC2"
           WRITE TERMINAL-REC FORMAT "PAUSEREC" STARTING AT LINE 22
           READ TERMINAL-FILE FORMAT "PAUSEREC"
           MOVE TRUE-VAL TO IN60 OF OPINREC2-O
           MOVE TRUE-VAL TO IN61 OF OPINREC2-O
           MOVE TRUE-VAL TO IN62 OF OPINREC2-O
           MOVE TRUE-VAL TO IN72 OF OPINREC2-O
           WRITE TERMINAL-REC FORMAT "OPINREC2"
           WRITE TERMINAL-REC FORMAT "PAUSEREC" STARTING AT LINE 22
           READ TERMINAL-FILE FORMAT "PAUSEREC"
           MOVE TRUE-VAL TO IN60 OF OPINREC2-O
           MOVE TRUE-VAL TO IN61 OF OPINREC2-O
           MOVE TRUE-VAL TO IN62 OF OPINREC2-O
           MOVE TRUE-VAL TO IN72 OF OPINREC2-O
           MOVE TRUE-VAL TO IN63 OF OPINREC2-O
           WRITE TERMINAL-REC FORMAT "OPINREC2"
           WRITE TERMINAL-REC FORMAT "PAUSEREC" STARTING AT LINE 22
           READ TERMINAL-FILE FORMAT "PAUSEREC"
           MOVE TRUE-VAL TO IN63 OF OPINREC2-O
           WRITE TERMINAL-REC FORMAT "OPINREC2"
           WRITE TERMINAL-REC FORMAT "PAUSEREC" STARTING AT LINE 22
           READ TERMINAL-FILE FORMAT "PAUSEREC"
           MOVE TRUE-VAL TO IN72 OF OPINREC2-O
           MOVE TRUE-VAL TO IN73 OF OPINREC2-O
           WRITE TERMINAL-REC FORMAT "OPINREC2"
           WRITE TERMINAL-REC FORMAT "PAUSEREC" STARTING AT LINE 22
           READ TERMINAL-FILE FORMAT "PAUSEREC"
           MOVE TRUE-VAL TO IN01 OF OPINREC3-O
           WRITE TERMINAL-REC FORMAT "OPINREC3"
           WRITE TERMINAL-REC FORMAT "PAUSEREC" STARTING AT LINE 22
           READ TERMINAL-FILE FORMAT "PAUSEREC"
           MOVE TRUE-VAL TO IN02 OF OPINREC3-O
           WRITE TERMINAL-REC FORMAT "OPINREC3"
           WRITE TERMINAL-REC FORMAT "PAUSEREC" STARTING AT LINE 22
           READ TERMINAL-FILE FORMAT "PAUSEREC"
           MOVE TRUE-VAL TO IN03 OF OPINREC3-O
           WRITE TERMINAL-REC FORMAT "OPINREC3"
           WRITE TERMINAL-REC FORMAT "PAUSEREC" STARTING AT LINE 22
           READ TERMINAL-FILE FORMAT "PAUSEREC"
           MOVE TRUE-VAL TO IN01 OF OPINREC3-O
           MOVE TRUE-VAL TO IN02 OF OPINREC3-O
           MOVE TRUE-VAL TO IN03 OF OPINREC3-O
           WRITE TERMINAL-REC FORMAT "OPINREC3"
           WRITE TERMINAL-REC FORMAT "PAUSEREC" STARTING AT LINE 22
           READ TERMINAL-FILE FORMAT "PAUSEREC"
           GO TO MAIN-MENU-START
           .
       MSG-TEST-START.
           WRITE TERMINAL-REC FORMAT "MSGREC1"
           WRITE TERMINAL-REC FORMAT "PAUSEREC" STARTING AT LINE 22
           READ TERMINAL-FILE FORMAT "PAUSEREC"
           MOVE "0021" TO MSGNBR OF MSGREC2-O
           MOVE "QCPFMSG" TO MSGFILENM OF MSGREC2-O
           WRITE TERMINAL-REC FORMAT "MSGREC2"
           WRITE TERMINAL-REC FORMAT "PAUSEREC" STARTING AT LINE 22
           READ TERMINAL-FILE FORMAT "PAUSEREC"
           MOVE TRUE-VAL TO IN01 OF MSGREC2-O
           MOVE "0021" TO MSGNBR OF MSGREC2-O
           MOVE "QCPFMSG" TO MSGFILENM OF MSGREC2-O
           WRITE TERMINAL-REC FORMAT "MSGREC2"
           WRITE TERMINAL-REC FORMAT "PAUSEREC" STARTING AT LINE 22
           READ TERMINAL-FILE FORMAT "PAUSEREC"
           MOVE TRUE-VAL TO IN01 OF MSGREC2-O
           MOVE TRUE-VAL TO IN25 OF MSGREC2-O
           MOVE "KBD0014" TO MSGIDNUM OF MSGREC2-O
           MOVE "0007" TO MSGNBR OF MSGREC2-O
           MOVE "QCPFMSG" TO MSGFILENM OF MSGREC2-O
           WRITE TERMINAL-REC FORMAT "MSGREC2"
           WRITE TERMINAL-REC FORMAT "PAUSEREC" STARTING AT LINE 22
           READ TERMINAL-FILE FORMAT "PAUSEREC"
           GO TO MAIN-MENU-START
           .
       CURPOS-TEST-START.
           MOVE 'CURSOR HERE, POS=2' TO FIELD1 OF CPREC1
           MOVE SPACES TO FIELD2 OF CPREC1
           MOVE SPACES TO FIELD3 OF CPREC1
           MOVE 08 TO LINNBR OF CPREC1
           MOVE 03 TO POSNBR OF CPREC1
           WRITE TERMINAL-REC FORMAT "CPREC1"
           WRITE TERMINAL-REC FORMAT "PAUSEREC" STARTING AT LINE 22
           READ TERMINAL-FILE FORMAT "PAUSEREC"
           MOVE "HERE" TO FIELD2 OF CPREC1
           MOVE SPACES TO FIELD1 OF CPREC1
           MOVE SPACES TO FIELD3 OF CPREC1
           MOVE 08 TO LINNBR OF CPREC1
           MOVE 60 TO POSNBR OF CPREC1
           WRITE TERMINAL-REC FORMAT "CPREC1"
           WRITE TERMINAL-REC FORMAT "PAUSEREC" STARTING AT LINE 22
           READ TERMINAL-FILE FORMAT "PAUSEREC"
           MOVE "CURSOR HERE, POS=4" TO FIELD3 OF CPREC1
           MOVE SPACES TO FIELD1 OF CPREC1
           MOVE SPACES TO FIELD2 OF CPREC1
           MOVE 10 TO LINNBR OF CPREC1
           MOVE 05 TO POSNBR OF CPREC1
           WRITE TERMINAL-REC FORMAT "CPREC1"
           WRITE TERMINAL-REC FORMAT "PAUSEREC" STARTING AT LINE 22
           READ TERMINAL-FILE FORMAT "PAUSEREC"
           MOVE "HERE" TO FIELD2 OF CPREC1
           MOVE SPACES TO FIELD1 OF CPREC1
           MOVE SPACES TO FIELD3 OF CPREC1
           MOVE 08 TO LINNBR OF CPREC1
           MOVE 60 TO POSNBR OF CPREC1
           WRITE TERMINAL-REC FORMAT "CPREC1"
           WRITE TERMINAL-REC FORMAT "PAUSEREC" STARTING AT LINE 22
           READ TERMINAL-FILE FORMAT "PAUSEREC"
           MOVE 'CURSOR HERE, POS=10' TO FIELD1 OF CPREC1
           MOVE SPACES TO FIELD2 OF CPREC1
           MOVE SPACES TO FIELD3 OF CPREC1
           MOVE 08 TO LINNBR OF CPREC1
           MOVE 11 TO POSNBR OF CPREC1
           WRITE TERMINAL-REC FORMAT "CPREC1"
           WRITE TERMINAL-REC FORMAT "PAUSEREC" STARTING AT LINE 22
           READ TERMINAL-FILE FORMAT "PAUSEREC"
           MOVE 'CURSOR HERE' TO FIELD1 OF CPREC2-O
           MOVE SPACES TO FIELD2 OF CPREC2-O
           MOVE SPACES TO FIELD3 OF CPREC2-O
           MOVE TRUE-VAL TO IN01 OF CPREC2-O
           WRITE TERMINAL-REC FORMAT "CPREC2"
           WRITE TERMINAL-REC FORMAT "PAUSEREC" STARTING AT LINE 22
           READ TERMINAL-FILE FORMAT "PAUSEREC"
           MOVE "HERE" TO FIELD2 OF CPREC2-O
           MOVE SPACES TO FIELD1 OF CPREC2-O
           MOVE SPACES TO FIELD3 OF CPREC2-O
           MOVE TRUE-VAL TO IN02 OF CPREC2-O
           WRITE TERMINAL-REC FORMAT "CPREC2"
           WRITE TERMINAL-REC FORMAT "PAUSEREC" STARTING AT LINE 22
           READ TERMINAL-FILE FORMAT "PAUSEREC"
           MOVE "CURSOR HERE" TO FIELD3 OF CPREC2-O
           MOVE SPACES TO FIELD1 OF CPREC2-O
           MOVE SPACES TO FIELD2 OF CPREC2-O
           MOVE TRUE-VAL TO IN03 OF CPREC2-O
           WRITE TERMINAL-REC FORMAT "CPREC2"
           WRITE TERMINAL-REC FORMAT "PAUSEREC" STARTING AT LINE 22
           READ TERMINAL-FILE FORMAT "PAUSEREC"
           MOVE "HERE" TO FIELD2 OF CPREC2-O
           MOVE SPACES TO FIELD1 OF CPREC2-O
           MOVE SPACES TO FIELD3 OF CPREC2-O
           MOVE TRUE-VAL TO IN02 OF CPREC2-O
           WRITE TERMINAL-REC FORMAT "CPREC2"
           WRITE TERMINAL-REC FORMAT "PAUSEREC" STARTING AT LINE 22
           READ TERMINAL-FILE FORMAT "PAUSEREC"
           MOVE 'CURSOR HERE' TO FIELD1 OF CPREC2-O
           MOVE SPACES TO FIELD2 OF CPREC2-O
           MOVE SPACES TO FIELD3 OF CPREC2-O
           WRITE TERMINAL-REC FORMAT "CPREC2"
           WRITE TERMINAL-REC FORMAT "PAUSEREC" STARTING AT LINE 22
           READ TERMINAL-FILE FORMAT "PAUSEREC"
           .
       CURPOS-TEST-2.
           MOVE SPACES TO TERMINAL-REC
           WRITE TERMINAL-REC FORMAT "CPREC3"
           READ TERMINAL-FILE FORMAT "CPREC3"
           .
      * FALL THROUGH TO ENTRY FIELD ATTRIBUTE TESTS
       ENTFLDATR-TEST-START.
           MOVE SPACES TO TERMINAL-REC
           WRITE TERMINAL-REC FORMAT "EFAREC1"
           READ TERMINAL-FILE FORMAT "EFAREC1"
           .
      * FALL THROUGH TO INPUT ATTRIBUTE TESTS
       INPATR-TEST-START.
           MOVE SPACES TO TERMINAL-REC
           WRITE TERMINAL-REC FORMAT "INPREC1"
           READ TERMINAL-FILE FORMAT "INPREC1"
           MOVE SPACES TO TERMINAL-REC
           MOVE 48 TO DSPATRVAL
           MOVE DSPATR TO PFIELD1 OF INPREC2-O
           WRITE TERMINAL-REC FORMAT "INPREC2"
           READ TERMINAL-FILE FORMAT "INPREC2"
           MOVE SPACES TO TERMINAL-REC
           MOVE 48 TO DSPATRVAL
           MOVE TRUE-VAL TO IN01 OF INPREC2-O
           MOVE DSPATR TO PFIELD1 OF INPREC2-O
           WRITE TERMINAL-REC FORMAT "INPREC2"
           READ TERMINAL-FILE FORMAT "INPREC2"
           MOVE SPACES TO TERMINAL-REC
           WRITE TERMINAL-REC FORMAT "INPREC3"
           READ TERMINAL-FILE FORMAT "INPREC3"
           MOVE SPACES TO TERMINAL-REC
           MOVE TRUE-VAL TO IN01 OF INPREC3-O
           WRITE TERMINAL-REC FORMAT "INPREC3"
           READ TERMINAL-FILE FORMAT "INPREC3"
           GO TO MAIN-MENU-START
           .
       KBDCTL-TEST-START.
           MOVE SPACES TO TERMINAL-REC
           MOVE -12.34 TO FIELD1 OF KBDCREC1
           MOVE -12.34 TO FIELD2 OF KBDCREC1
           MOVE -12.34 TO FIELD3 OF KBDCREC1
           MOVE -12.34 TO FIELD4 OF KBDCREC1
           MOVE "ABC" TO FIELD5 OF KBDCREC1
           MOVE "ABC" TO FIELD6 OF KBDCREC1
           .
       KBDC-LOOP1.
           MOVE SPACES TO RFIELD OF KBDCREC1
           WRITE TERMINAL-REC FORMAT "KBDCREC1"
           READ TERMINAL-FILE FORMAT "KBDCREC1"
           IF RFIELD OF KBDCREC1 NOT EQUAL 'Q'
              GO TO KBDC-LOOP1
           END-IF
           GO TO MAIN-MENU-START
           .
       DATAVAL-TEST-START.
       DVAL-LOOP1.
           MOVE SPACES TO TERMINAL-REC
           WRITE TERMINAL-REC FORMAT "DVALREC1"
           READ TERMINAL-FILE FORMAT "DVALREC1"
           IF RFIELD OF DVALREC1 NOT EQUAL 'Q'
              GO TO DVAL-LOOP1
           END-IF
           .
       DVAL-LOOP2.
           MOVE SPACES TO TERMINAL-REC
           WRITE TERMINAL-REC FORMAT "DVALREC2"
           READ TERMINAL-FILE FORMAT "DVALREC2"
           IF RFIELD OF DVALREC2 NOT EQUAL 'Q'
              GO TO DVAL-LOOP2
           END-IF
           .
       DVAL-LOOP3.
           MOVE SPACES TO TERMINAL-REC
           WRITE TERMINAL-REC FORMAT "DVALREC3"
           READ TERMINAL-FILE FORMAT "DVALREC3"
           IF RFIELD OF DVALREC3-I NOT EQUAL 'Q'
              GO TO DVAL-LOOP3
           END-IF
           .
       DVAL-LOOP4.
           MOVE SPACES TO TERMINAL-REC
           WRITE TERMINAL-REC FORMAT "DVALREC4"
           READ TERMINAL-FILE FORMAT "DVALREC4"
           IF RFIELD OF DVALREC4-I NOT EQUAL 'Q'
              GO TO DVAL-LOOP4
           END-IF
       DATAVAL-TEST-2.
           MOVE ZEROES TO TERMINAL-REC
           .
       DVAL-LOOP5.
           WRITE TERMINAL-REC FORMAT "DVALREC5"
           READ TERMINAL-FILE FORMAT "DVALREC5"
           IF RFIELD OF DVALREC5 NOT EQUAL 'Q'
              GO TO DVAL-LOOP5
           END-IF
           GO TO MAIN-MENU-START
           .
       EDIT-TEST-START.
       EDIT-TEST-1.
           MOVE ZEROES TO TERMINAL-REC
           .
       EDIT-LOOP1.
           MOVE SPACES TO RFIELD OF EDITREC1
           WRITE TERMINAL-REC FORMAT "EDITREC1"
           READ TERMINAL-FILE FORMAT "EDITREC1"
           IF RFIELD OF EDITREC1 NOT EQUAL 'Q'
              GO TO EDIT-LOOP1
           END-IF
           .
       EDIT-TEST-2.
           MOVE ZEROES TO TERMINAL-REC
           .
       EDIT-LOOP2.
           MOVE SPACES TO RFIELD OF EDITREC2
           WRITE TERMINAL-REC FORMAT "EDITREC2"
           READ TERMINAL-FILE FORMAT "EDITREC2"
           IF RFIELD OF EDITREC2 NOT EQUAL 'Q'
              GO TO EDIT-LOOP2
           END-IF
           .
       EDIT-TEST-3.
           MOVE ZEROES TO TERMINAL-REC
           .
       EDIT-LOOP3.
           MOVE SPACES TO RFIELD OF EDITREC3
           WRITE TERMINAL-REC FORMAT "EDITREC3"
           READ TERMINAL-FILE FORMAT "EDITREC3"
           IF RFIELD OF EDITREC3 NOT EQUAL 'Q'
              GO TO EDIT-LOOP3
           END-IF
           .
       EDIT-TEST-4.
           MOVE ZEROES TO TERMINAL-REC
           .
       EDIT-LOOP4.
           MOVE SPACES TO RFIELD OF EDITREC4
           WRITE TERMINAL-REC FORMAT "EDITREC4"
           READ TERMINAL-FILE FORMAT "EDITREC4"
           IF RFIELD OF EDITREC4 NOT EQUAL 'Q'
              GO TO EDIT-LOOP4
           END-IF
           .
       EDIT-TEST-5.
           MOVE ZEROES TO TERMINAL-REC
           .
       EDIT-LOOP5.
           MOVE SPACES TO RFIELD OF EDITREC5
           WRITE TERMINAL-REC FORMAT "EDITREC5"
           READ TERMINAL-FILE FORMAT "EDITREC5"
           IF RFIELD OF EDITREC5 NOT EQUAL 'Q'
              GO TO EDIT-LOOP5
           END-IF
           GO TO MAIN-MENU-START
           .
       REIN-TEST-START.
       REIN-TEST-1.
           MOVE SPACES TO TERMINAL-REC
           WRITE TERMINAL-REC FORMAT "REINREC1"
           READ TERMINAL-FILE FORMAT "REINREC1"
           IF IN04 OF REINREC1-I NOT EQUAL TRUE-VAL THEN
              GO TO REIN-TEST-1
           END-IF
           .
       REIN-TEST-2.
           MOVE SPACES TO TERMINAL-REC
           WRITE TERMINAL-REC FORMAT "REINREC2"
           MOVE "BYE" TO FIELD1 OF REINREC2-I
           MOVE "HELLO" TO FIELD2 OF REINREC2-I
           READ TERMINAL-FILE FORMAT "REINREC2"
           IF IN01 OF REINREC2-I EQUAL TO TRUE-VAL THEN
              MOVE FIELD1 OF REINREC2-I TO FIELD3 OF REINREC2-O
              MOVE FIELD2 OF REINREC2-I TO FIELD4 OF REINREC2-O
              MOVE TRUE-VAL TO IN01 OF REINREC2-O
              WRITE TERMINAL-REC FORMAT "REINREC2"
      * AT THIS READ, NO INPUT FIELDS EXIST - IT SHOULD
      * WAIT UNTIL ENTER IS PRESSED
              READ TERMINAL-FILE FORMAT "REINREC2"
              GO TO REIN-TEST-2
           END-IF
           .
       REIN-TEST-3.
           MOVE SPACES TO TERMINAL-REC
           WRITE TERMINAL-REC FORMAT "REINREC3"
           READ TERMINAL-FILE FORMAT "REINREC3"
           IF IN01 OF REINREC3-I NOT EQUAL TRUE-VAL THEN
              GO TO REIN-TEST-3
           END-IF
           .
       REIN-TEST-4.
           MOVE SPACES TO TERMINAL-REC.
           MOVE TRUE-VAL TO IN02 OF REINREC4-O
           .
       REIN-TEST-4-2.
           WRITE TERMINAL-REC FORMAT "REINREC4"
           READ TERMINAL-FILE FORMAT "REINREC4"
           IF IN01 OF REINREC4-I EQUAL TRUE-VAL OR
              IN02 OF REINREC4-I EQUAL TRUE-VAL OR
              IN03 OF REINREC4-I EQUAL TRUE-VAL OR
              IN04 OF REINREC4-I EQUAL TRUE-VAL OR
              IN05 OF REINREC4-I EQUAL TRUE-VAL
           THEN
              MOVE INFIELD OF REINREC4-I TO FIELD3 OF REINREC4-O
              MOVE REINREC4-I-INDIC TO FIELD1 OF REINREC4-O
              MOVE REINREC4-O-INDIC TO FIELD2 OF REINREC4-O
              GO TO REIN-TEST-4-2
           END-IF
           GO TO MAIN-MENU-START
           .
       MISCOVR-TEST-START.
           MOVE SPACES TO TERMINAL-REC
           WRITE TERMINAL-REC FORMAT "MSCOREC1"
           MOVE 4 TO WAIT-TIME
           PERFORM WAIT-N-SECONDS
           MOVE 123 TO FIELD1 OF MSCOREC2-O
           MOVE "FIELD 2" TO FIELD2 OF MSCOREC2-O
           WRITE TERMINAL-REC FORMAT "MSCOREC2"
           MOVE 4 TO WAIT-TIME
           PERFORM WAIT-N-SECONDS
           MOVE "FIELD 3" TO FIELD1 OF MSCOREC3-O
           MOVE "FIELD 4" TO FIELD2 OF MSCOREC3-O
           WRITE TERMINAL-REC FORMAT "MSCOREC3"
           PERFORM WAIT-N-SECONDS
           MOVE "FIELD 5" TO FIELD1 OF MSCOREC4
           MOVE "FIELD 6" TO FIELD2 OF MSCOREC4
           WRITE TERMINAL-REC FORMAT "MSCOREC4"
           MOVE 4 TO WAIT-TIME
           PERFORM WAIT-N-SECONDS
           READ TERMINAL-FILE FORMAT "MSCOREC4"
           MOVE SPACES TO TERMINAL-REC
           READ TERMINAL-FILE FORMAT "MSCOREC5"
           GO TO MAIN-MENU-START
           .
       DATE-TEST-START.
       DATE-TEST-1.
           MOVE SPACES TO TERMINAL-REC
           .
       DATE-LOOP1.
           MOVE SPACES TO RFIELD OF DATEREC1
           WRITE TERMINAL-REC FORMAT "DATEREC1"
           READ TERMINAL-FILE FORMAT "DATEREC1"
           IF RFIELD OF DATEREC1 NOT EQUAL 'Q'
              GO TO DATE-LOOP1
           END-IF
       DATE-TEST-2.
           MOVE SPACES TO TERMINAL-REC
           .
       DATE-LOOP2.
           MOVE SPACES TO RFIELD OF DATEREC2
           WRITE TERMINAL-REC FORMAT "DATEREC2"
           READ TERMINAL-FILE FORMAT "DATEREC2"
           IF RFIELD OF DATEREC2 NOT EQUAL 'Q'
              GO TO DATE-LOOP2
           END-IF
           .
       DATE-TEST-3.
           MOVE SPACES TO TERMINAL-REC
           .
       DATE-LOOP3.
           MOVE SPACES TO RFIELD OF DATEREC3
           WRITE TERMINAL-REC FORMAT "DATEREC3"
           READ TERMINAL-FILE FORMAT "DATEREC3"
           IF RFIELD OF DATEREC3 NOT EQUAL 'Q'
              GO TO DATE-LOOP3
           END-IF
           GO TO MAIN-MENU-START
           .
       ERRMSG-TEST-START.
           MOVE SPACES TO TERMINAL-REC
           WRITE TERMINAL-REC FORMAT "EMSGREC1"
           READ TERMINAL-FILE FORMAT "EMSGREC1"
           .
       ERRMSG-LOOP1.
           MOVE TRUE-VAL TO IN01 OF EMSGREC1-O
           WRITE TERMINAL-REC FORMAT "EMSGREC1"
           READ TERMINAL-FILE FORMAT "EMSGREC1"
           IF IN01 OF EMSGREC1-I IS EQUAL TO TRUE-VAL THEN
              GO TO ERRMSG-LOOP1
           END-IF
           .
       ERRMSG-LOOP2.
           MOVE TRUE-VAL TO IN02 OF EMSGREC1-O
           WRITE TERMINAL-REC FORMAT "EMSGREC1"
           READ TERMINAL-FILE FORMAT "EMSGREC1"
           IF IN02 OF EMSGREC1-I IS EQUAL TO TRUE-VAL THEN
              GO TO ERRMSG-LOOP2
           END-IF
           .
       ERRMSG-LOOP3.
           MOVE TRUE-VAL TO IN03 OF EMSGREC1-O
           MOVE "MY REPLACEMENT TEXT" TO RPLTXT OF EMSGREC1-O
           WRITE TERMINAL-REC FORMAT "EMSGREC1"
           READ TERMINAL-FILE FORMAT "EMSGREC1"
           IF IN03 OF EMSGREC1-I IS EQUAL TO TRUE-VAL THEN
              GO TO ERRMSG-LOOP3
           END-IF
           WRITE TERMINAL-REC FORMAT "EMSGREC1"
           READ TERMINAL-FILE FORMAT "EMSGREC1"
           GO TO MAIN-MENU-START
           .
       HELPREC-TEST-START.
           MOVE SPACES TO TERMINAL-REC
           WRITE TERMINAL-REC FORMAT "HELPREC1"
           WRITE TERMINAL-REC FORMAT "HELPREC2"
           WRITE TERMINAL-REC FORMAT "HELPREC3"
           READ TERMINAL-FILE FORMAT "HELPREC1"
           READ TERMINAL-FILE FORMAT "HELPREC2"
           READ TERMINAL-FILE FORMAT "HELPREC3"
           MOVE SPACES TO TERMINAL-REC
           MOVE TRUE-VAL TO IN01 OF HELPREC1-O
           WRITE TERMINAL-REC FORMAT "HELPREC1"
           WRITE TERMINAL-REC FORMAT "HELPREC2"
           WRITE TERMINAL-REC FORMAT "HELPREC3"
           READ TERMINAL-FILE FORMAT "HELPREC1"
           READ TERMINAL-FILE FORMAT "HELPREC2"
           READ TERMINAL-FILE FORMAT "HELPREC3"
           GO TO MAIN-MENU-START
           .
       SFLREC-TEST-START.
           MOVE SPACES TO TERMINAL-REC
           MOVE 1 TO SUBFILE-RECORD-NUMBER
           WRITE SUBFILE TERMINAL-REC FORMAT "SFLREC1"
           ADD 1 TO SUBFILE-RECORD-NUMBER
           WRITE SUBFILE TERMINAL-REC FORMAT "SFLREC1"
           ADD 1 TO SUBFILE-RECORD-NUMBER
           WRITE SUBFILE TERMINAL-REC FORMAT "SFLREC1"
           ADD 1 TO SUBFILE-RECORD-NUMBER
           WRITE SUBFILE TERMINAL-REC FORMAT "SFLREC1"
           WRITE TERMINAL-REC FORMAT "SFLCREC1"
           READ TERMINAL-FILE FORMAT "SFLCREC1"
           .
       SFLREC-TEST-2.
           MOVE SPACES TO TERMINAL-REC
           MOVE 1 TO SUBFILE-RECORD-NUMBER
           PERFORM UNTIL SUBFILE-RECORD-NUMBER IS EQUAL TO 16
              MOVE SUBFILE-RECORD-NUMBER TO
                  FIELD1 OF SFLREC2
              MOVE SUBFILE-RECORD-NUMBER TO
                  FIELD2 OF SFLREC2
              WRITE SUBFILE TERMINAL-REC FORMAT "SFLREC2"
              ADD 1 TO SUBFILE-RECORD-NUMBER
           END-PERFORM
           WRITE TERMINAL-REC FORMAT "SFLCREC2"
           READ TERMINAL-FILE FORMAT "SFLCREC2"
           .
       SFLREC-TEST-3.
           MOVE SPACES TO TERMINAL-REC
           MOVE 1 TO SUBFILE-RECORD-NUMBER
           PERFORM UNTIL SUBFILE-RECORD-NUMBER IS EQUAL TO 16
              MOVE SUBFILE-RECORD-NUMBER TO
                  FIELD1 OF SFLREC3
              MOVE SUBFILE-RECORD-NUMBER TO
                  FIELD2 OF SFLREC3
              WRITE SUBFILE TERMINAL-REC FORMAT "SFLREC3"
              ADD 1 TO SUBFILE-RECORD-NUMBER
           END-PERFORM
           WRITE TERMINAL-REC FORMAT "SFLCREC3"
           READ TERMINAL-FILE FORMAT "SFLCREC3"
      *
      ******************************************************
      * UNCOMMENT THE SECTION BELOW IF YOU WANT TO DISPLAY *
      * SUBFILE VALUES ON SYSOUT                           *
      ******************************************************
      *
      *    MOVE 0 TO F-STATUS
      *    PERFORM UNTIL F-STATUS NOT EQUAL TO 0
      *        READ SUBFILE TERMINAL-FILE NEXT MODIFIED RECORD
      *            FORMAT "SFLREC3"
      *        DISPLAY "RECORD " SUBFILE-RECORD-NUMBER ", "
      *        "FIELD1='" FIELD1 OF SFLREC3 "' "
      *        "FIELD2='" FIELD2 OF SFLREC3 "', FSTATUS="
      *        F-STATUS UPON SYSOUT
      *    END-PERFORM
      *
      *    MOVE 0 TO F-STATUS
      *    MOVE 1 TO SUBFILE-RECORD-NUMBER
      *    PERFORM UNTIL SUBFILE-RECORD-NUMBER IS EQUAL TO 17
      *       READ SUBFILE TERMINAL-FILE FORMAT "SFLREC3"
      *        DISPLAY "RECORD " SUBFILE-RECORD-NUMBER ", "
      *        "FIELD1='" FIELD1 OF SFLREC3 "' "
      *        "FIELD2='" FIELD2 OF SFLREC3 "', FSTATUS="
      *        F-STATUS UPON SYSOUT
      *        ADD 1 TO SUBFILE-RECORD-NUMBER
      *    END-PERFORM
           .
       SFLREC-TEST-4.
           MOVE SPACES TO TERMINAL-REC
           MOVE 1 TO SUBFILE-RECORD-NUMBER
           PERFORM UNTIL SUBFILE-RECORD-NUMBER IS EQUAL TO 16
              MOVE SUBFILE-RECORD-NUMBER TO
                  FIELD1 OF SFLREC4
              MOVE SUBFILE-RECORD-NUMBER TO
                  FIELD2 OF SFLREC4
              WRITE SUBFILE TERMINAL-REC FORMAT "SFLREC4"
              ADD 1 TO SUBFILE-RECORD-NUMBER
           END-PERFORM
           MOVE SPACES TO TERMINAL-REC
           MOVE 15 TO FIELD1 OF SFLCREC4-O
           WRITE TERMINAL-REC FORMAT "SFLCREC4"
           READ TERMINAL-FILE FORMAT "SFLCREC4"
           .
       SFLREC-TEST-5.
           MOVE SPACES TO TERMINAL-REC
           MOVE 1 TO SUBFILE-RECORD-NUMBER
           PERFORM UNTIL SUBFILE-RECORD-NUMBER IS EQUAL TO 16
              MOVE SUBFILE-RECORD-NUMBER TO
                  FIELD1 OF SFLREC5
              MOVE SUBFILE-RECORD-NUMBER TO
                  FIELD2 OF SFLREC5
              WRITE SUBFILE TERMINAL-REC FORMAT "SFLREC5"
              ADD 1 TO SUBFILE-RECORD-NUMBER
           END-PERFORM
           MOVE SPACES TO TERMINAL-REC
           MOVE 6 TO FIELD1 OF SFLCREC5-O
           WRITE TERMINAL-REC FORMAT "SFLCREC5"
           READ TERMINAL-FILE FORMAT "SFLCREC5"
           GO TO MAIN-MENU-START
           .
       WAIT-N-SECONDS.
           ACCEPT THE-TIME FROM TIME
           MOVE MINS OF TIME-GROUP TO START-SECS
           MULTIPLY 60 BY START-SECS
           ADD SECS OF TIME-GROUP TO START-SECS
           MOVE 0 TO CUR-SECS
           PERFORM UNTIL CUR-SECS GREATER THAN OR EQUAL WAIT-TIME
              ACCEPT THE-TIME FROM TIME
              MOVE MINS OF TIME-GROUP TO CUR-SECS
              MULTIPLY 60 BY CUR-SECS
              ADD SECS OF TIME-GROUP TO CUR-SECS
              SUBTRACT START-SECS FROM CUR-SECS GIVING CUR-SECS
           END-PERFORM
           .
       EXIT-START.
           CLOSE TERMINAL-FILE
           STOP RUN
           .
       ERROR-EXIT.
           DISPLAY "ABNORMAL EXIT, F-STATUS=" F-STATUS UPON SYSOUT
           IF F-STATUS = 10 THEN
               DISPLAY "Check that DDS Plug-in key is current"
                   UPON SYSOUT
           END-IF
           CLOSE TERMINAL-FILE
           STOP RUN
           .
