      *
      * DREAMHOME
      *
      * Copyright (C) 2010-2023 Heirloom Computing Inc.  All Rights Reserved.
      *
      * This file and associated files are copyrighted information
      * of Heirloom Computing.  Permission is granted for usage in 
      * conjunction with the Elastic COBOL product.
      *
      * This program display a Graphical User Interface using
      * Graphical Screen Section syntax from within either an 
      * application or an applet.  Make selections of the number 
      * of bedrooms, bathrooms, and price range to have the matching 
      * houses displayed.
      *
      * Select houses with one more bedroom than bathroom to see
      * actual houses.
      * 
       IDENTIFICATION DIVISION.
       PROGRAM-ID. DreamHome.
       ENVIRONMENT DIVISION.
       CONFIGURATION SECTION.
       SPECIAL-NAMES.
      *
      * RESOURCE specifies a resource name; this is a text file of
      * key=value lines, which may be localized to a particular
      * region, using resourcename[_language[_REGION]].properties, e.g.,
      * dreamhome_de.properties for German language in all regions.
      *
      * A resource is specified in the program source wherever
      * a display literal is used, such as in a DISPLAY statement
      * or in a graphical screen section property in the screen
      * section or in a MODIFY verb.  It may include the clause
      * WHEN OMITTED to specify text to use when there is no resource
      * file present.
      *
      * RESOURCE "resource-name" WHEN OMITTED "default-text"
      *
           RESOURCE IS "dreamhome"
           .
      
       DATA DIVISION.
       WORKING-STORAGE SECTION.
      
      * This receives the termination-value from the accept.
      
       77 ACCEPT-VALUE PIC 999 IS SPECIAL-NAMES CRT STATUS.
      
      * Assign constants so the 'function key' values implied
      * by the termination of a component will have a meaning
      * in the source code.
      
       78 SELECTED-PRINT VALUE 100.
       78 SELECTED-ABOUT VALUE 101.
       78 SELECTED-EXIT VALUE 102.
       78 SELECTED-SEARCH VALUE 103.
       78 SELECTED-VIEW VALUE 104.
      
      * Data input for screen section items
      
       77 MINPRICE-VALUE PIC $$,$$$,$$9 VALUE "$0".
       77 MAXPRICE-VALUE PIC $$,$$$,$$9 VALUE "$9,999,999".
       77 BED-CHOICE-VALUE PIC X(20).
       77 BATH-CHOICE-VALUE PIC X(20).
       77 SEARCHBOX-VALUE PIC X(70).
      
      * The APPLET-INIT sets IN-APPLET to true so we can tell
      * if we're running in an applet or not.  We default to
      * not being in an applet.
      
       01 APPLET-STATE PIC 9.
           88 IN-APPLET VALUE 1.
      
      * Housing information hardcoded into program to keep
      * demonstration simpler.
      
       77  SEARCH-FOUND                PIC 9(3) VALUE 0.
       77  SEARCH-INDEX                PIC 9(3) VALUE 0.
       77  SEARCH-MINPRICE             PIC 9(7).
       77  SEARCH-MAXPRICE             PIC 9(7).
      
       77  SEARCH-BED PIC 9.
       77  SEARCH-BATH PIC 9.
      
       77  VIEW-INDEX PIC 999.
      
       01  HOUSE-ARRAY                 OCCURS 15 TIMES.
           05  ADDRESS0                PIC X(70).
           05  BEDROOM                 PIC 9.
           05  BATHROOM                PIC 9.
           05  PRICE                   PIC 9(7).
           05  CITY                    PIC X.
           05  OUTSIDE                 PIC X(11).
           05  FLOORPLAN               PIC X(11).
      
       01  HOUSES-LIST                 REDEFINES HOUSE-ARRAY.
           05  HOUSE01.
               10  ADDRESS0             PIC X(70) VALUE  
                   "17 Camelot Dr. ($100,000)".
               10  BEDROOM             PIC 9 VALUE 2.
               10  BATHROOM            PIC 9 VALUE 1.
               10  PRICE               PIC 9(7) VALUE 100000.
               10  CITY                PIC X VALUE "C".
               10  OUTSIDE             PIC X(11) VALUE "house01.jpg".
               10  FLOORPLAN           PIC X(11) VALUE "floor01.jpg".
           05  HOUSE02.
               10  ADDRESS0             PIC X(70) VALUE 
                   "2805 E. Vancouver ($750,000)".
               10  BEDROOM             PIC 9 VALUE 4.
               10  BATHROOM            PIC 9 VALUE 3.
               10  PRICE               PIC 9(7) VALUE 750000.
               10  CITY                PIC X VALUE "S".
               10  OUTSIDE             PIC X(11) VALUE "house02.jpg".
               10  FLOORPLAN           PIC X(11) VALUE "floor02.jpg".
           05  HOUSE03.
               10  ADDRESS0             PIC X(70) VALUE 
                   "822 N. Lincoln ($500,000)".
               10  BEDROOM             PIC 9 VALUE 3.
               10  BATHROOM            PIC 9 VALUE 2.
               10  PRICE               PIC 9(7) VALUE 500000.
               10  CITY                PIC X VALUE "M".
               10  OUTSIDE             PIC X(11) VALUE "house03.jpg".
               10  FLOORPLAN           PIC X(11) VALUE "floor03.jpg".
           05  HOUSE04.
               10  ADDRESS0             PIC X(70) VALUE 
                   "824 N. Lincoln ($950,000)".
               10  BEDROOM             PIC 9 VALUE 5.
               10  BATHROOM            PIC 9 VALUE 4.
               10  PRICE               PIC 9(7) VALUE 950000.
               10  CITY                PIC X VALUE "P".
               10  OUTSIDE             PIC X(11) VALUE "house04.jpg".
               10  FLOORPLAN           PIC X(11) VALUE "floor04.jpg".
           05  HOUSE05.
               10  ADDRESS0             PIC X(70) VALUE 
                   "1523 Willham South ($625,000)".
               10  BEDROOM             PIC 9 VALUE 4.
               10  BATHROOM            PIC 9 VALUE 3.
               10  PRICE               PIC 9(7) VALUE 625000.
               10  CITY                PIC X VALUE "F".
               10  OUTSIDE             PIC X(11) VALUE "house05.jpg".
               10  FLOORPLAN           PIC X(11) VALUE "floor05.jpg".
           05  HOUSE06.
               10  ADDRESS0             PIC X(70) VALUE 
                   "12 Washington Court. ($425,000)".
               10  BEDROOM             PIC 9 VALUE 3.
               10  BATHROOM            PIC 9 VALUE 2.
               10  PRICE               PIC 9(7) VALUE 425000.
               10  CITY                PIC X VALUE "C".
               10  OUTSIDE             PIC X(11) VALUE "house06.jpg".
               10  FLOORPLAN           PIC X(11) VALUE "floor01.jpg".
           05  HOUSE07.
               10  ADDRESS0             PIC X(70) VALUE 
                   "14932 Jefferson Rd. ($675,000)".
               10  BEDROOM             PIC 9 VALUE 4.
               10  BATHROOM            PIC 9 VALUE 3.
               10  PRICE               PIC 9(7) VALUE 675000.
               10  CITY                PIC X VALUE "M".
               10  OUTSIDE             PIC X(11) VALUE "house07.jpg".
               10  FLOORPLAN           PIC X(11) VALUE "floor02.jpg".
           05  HOUSE08.
               10  ADDRESS0             PIC X(70) VALUE 
                   "21470 Browne Dr. ($575,000)".
               10  BEDROOM             PIC 9 VALUE 3.
               10  BATHROOM            PIC 9 VALUE 2.
               10  PRICE               PIC 9(7) VALUE 575000.
               10  CITY                PIC X VALUE "S".
               10  OUTSIDE             PIC X(11) VALUE "house08.jpg".
               10  FLOORPLAN           PIC X(11) VALUE "floor03.jpg".
           05  HOUSE09.
               10  ADDRESS0             PIC X(70) VALUE 
                   "21472 Happy Valley Dr. ($1,000,000)".
               10  BEDROOM             PIC 9 VALUE 5.
               10  BATHROOM            PIC 9 VALUE 4.
               10  PRICE               PIC 9(7) VALUE 1000000.
               10  CITY                PIC X VALUE "F".
               10  OUTSIDE             PIC X(11) VALUE "house09.jpg".
               10  FLOORPLAN           PIC X(11) VALUE "floor04.jpg".
           05  HOUSE10.
               10  ADDRESS0             PIC X(70) VALUE 
                   "4538 Vancouver Ct. ($275,000)".
               10  BEDROOM             PIC 9 VALUE 2.
               10  BATHROOM            PIC 9 VALUE 1.
               10  PRICE               PIC 9(7) VALUE 275000.
               10  CITY                PIC X VALUE "P".
               10  OUTSIDE             PIC X(11) VALUE "house10.jpg".
               10  FLOORPLAN           PIC X(11) VALUE "floor05.jpg".
           05  HOUSE11.
               10  ADDRESS0             PIC X(70) VALUE 
                   "527 Rio Sancho Blvd. ($790,000)".
               10  BEDROOM             PIC 9 VALUE 4.
               10  BATHROOM            PIC 9 VALUE 3.
               10  PRICE               PIC 9(7) VALUE 790000.
               10  CITY                PIC X VALUE "C".
               10  OUTSIDE             PIC X(11) VALUE "house11.jpg".
               10  FLOORPLAN           PIC X(11) VALUE "floor01.jpg".
           05  HOUSE12.
               10  ADDRESS0             PIC X(70) VALUE
                   "13419 Valley View Rd. ($355,000)".
               10  BEDROOM             PIC 9 VALUE 2.
               10  BATHROOM            PIC 9 VALUE 1.
               10  PRICE               PIC 9(7) VALUE 355000.
               10  CITY                PIC X VALUE "M".
               10  OUTSIDE             PIC X(11) VALUE "house12.jpg".
               10  FLOORPLAN           PIC X(11) VALUE "floor02.jpg".
           05  HOUSE13.
               10  ADDRESS0             PIC X(70) VALUE 
                   "144 Monterey Pkwy. ($590,000)".
               10  BEDROOM             PIC 9 VALUE 3.
               10  BATHROOM            PIC 9 VALUE 2.
               10  PRICE               PIC 9(7) VALUE 590000.
               10  CITY                PIC X VALUE "F".
               10  OUTSIDE             PIC X(11) VALUE "house13.jpg".
               10  FLOORPLAN           PIC X(11) VALUE "floor03.jpg".
           05  HOUSE14.
               10  ADDRESS0             PIC X(70) VALUE 
                   "121691 Ridge Rd. ($430,000)".
               10  BEDROOM             PIC 9 VALUE 2.
               10  BATHROOM            PIC 9 VALUE 1.
               10  PRICE               PIC 9(7) VALUE 430000.
               10  CITY                PIC X VALUE "S".
               10  OUTSIDE             PIC X(11) VALUE "house14.jpg".
               10  FLOORPLAN           PIC X(11) VALUE "floor04.jpg".
           05  HOUSE15.
               10  ADDRESS0             PIC X(70) VALUE
                   "26417 Constitution Ave. ($360,000)".
               10  BEDROOM             PIC 9 VALUE 3.
               10  BATHROOM            PIC 9 VALUE 2.
               10  PRICE               PIC 9(7) VALUE 360000.
               10  CITY                PIC X VALUE "P".
               10  OUTSIDE             PIC X(11) VALUE "house15.jpg".
               10  FLOORPLAN           PIC X(11) VALUE "floor05.jpg".
      
      *
      * SHARED-STORAGE is an extension of Elastic COBOL, used to allow
      * data to be shared between sessions.  In this program, when
      * run as an applet, the SHARED-STORAGE holds a counter
      * describing the number of times the page has been entered
      * during a single session.  The only way to initialize data
      * to an initial value is to use the VALUE clause; it will be
      * done only once.  After that, the storage remains.
      * 
       SHARED-STORAGE SECTION.
       77 MY-COUNTER PIC 9(9) VALUE 0.
      
      *
      * The SCREEN SECTION is an extension of the SCREEN SECTION
      * used in X/Open compliant Cobols, supporting not only the
      * text screen section, but also graphical screen section
      * elements.
      *
      * The graphical elements are placed on the screen using
      * text style co-ordinates.
      *
      
       SCREEN SECTION.
       01 MAIN-SCREEN.
           05 MAIN-MENU IS MENU
               BEGIN-MENU = 
                   RESOURCE "menu.file" WHEN OMITTED "&File"
                     ITEM-TO-ADD = 
                       RESOURCE "menu.print" WHEN OMITTED "&Print" 
                       TERMINATION-VALUE = SELECTED-PRINT
      
                     ITEM-TO-ADD = 
                       RESOURCE "menu.exit" WHEN OMITTED "E&xit"  
                       TERMINATION-VALUE = SELECTED-EXIT
               END-MENU
      
               BEGIN-MENU = 
                   RESOURCE "menu.help" WHEN OMITTED "&Help"
                     ITEM-TO-ADD = 
                       RESOURCE "menu.about" WHEN OMITTED "&About" 
                       TERMINATION-VALUE = SELECTED-ABOUT
               END-MENU
                     .
      
      
           05 HOUSE-IMAGE BITMAP SCALED | scaled fills entire area
               BITMAP-VALUE "house01.jpg"
               LINE 2 COLUMN 2
               SIZE 30 CELLS LINES 13 CELLS | bitmap size & lines normally in pixels
                    .
           05 FLOOR-IMAGE BITMAP SCALED
               BITMAP-VALUE "floor01.jpg"
               LINE 2 COLUMN 38
               SIZE 30 CELLS LINES 13 CELLS | bitmap size & lines normally in pixels
                    .
           05 BED-LABEL LABEL 
               RESOURCE "label.bed" WHEN OMITTED "Bedrooms"
               LINE 16 COLUMN 2 SIZE 15 CENTERED
               .
           05 BED-CHOICE COMBO-BOX UNSORTED DROP-LIST
               LINE 18 COLUMN 2 SIZE 15
               USING BED-CHOICE-VALUE
      
               ITEM-TO-ADD = 
                 RESOURCE "combo.bed1" WHEN OMITTED "One Bedroom"
      
               ITEM-TO-ADD = 
                 RESOURCE "combo.bed2" WHEN OMITTED "Two Bedroom" 
      
               ITEM-TO-ADD = 
                 RESOURCE "combo.bed3" WHEN OMITTED "Three Bedroom"
      
               ITEM-TO-ADD = 
                 RESOURCE "combo.bed4" WHEN OMITTED "Four Bedroom"
      
               ITEM-TO-ADD = 
                 RESOURCE "combo.bed5" WHEN OMITTED "Five Bedroom"
      
               SELECTION-INDEX = 1
               .
      
           05 BATH-LABEL LABEL 
               RESOURCE "label.bath" WHEN OMITTED "Bathrooms"
               LINE 16 COLUMN 25 SIZE 15 CENTERED
               .
           05 BATH-CHOICE COMBO-BOX UNSORTED DROP-LIST
               LINE 18 COLUMN 25 SIZE 15
               USING BATH-CHOICE-VALUE
      
               ITEM-TO-ADD = 
                 RESOURCE "combo.bath1" WHEN OMITTED "One Bathroom"
      
               ITEM-TO-ADD = 
                 RESOURCE "combo.bath2" WHEN OMITTED "Two Bathroom"
      
               ITEM-TO-ADD = 
                 RESOURCE "combo.bath3" WHEN OMITTED "Three Bathroom"
      
               ITEM-TO-ADD = 
                 RESOURCE "combo.bath4" WHEN OMITTED "Four Bathroom"
      
               SELECTION-INDEX = 1
               .
      
           05 PRICE-LABEL LABEL 
               RESOURCE "combo.price" WHEN OMITTED "Price Range"
               LINE 16 COLUMN 47 SIZE 20 CENTERED
                    .
           05 MIN-LABEL LABEL 
               RESOURCE "label.min" WHEN OMITTED "Min"
               LINE 18 COLUMN 47
               .
           05 MINPRICE ENTRY-FIELD RIGHT
               LINE 18 COLUMN 52 SIZE 15
               USING MINPRICE-VALUE
               .
           05 MAX-LABEL LABEL 
               RESOURCE "label.max" WHEN OMITTED "Max"
               LINE 20 COLUMN 47
                    .   
           05 MAXPRICE ENTRY-FIELD RIGHT
               LINE 20 COLUMN 52 SIZE 15
               USING MAXPRICE-VALUE
                    .      
           05 SEARCHBOX LIST-BOX UNSORTED
               USING SEARCHBOX-VALUE
               TERMINATION-VALUE = SELECTED-VIEW
               LINE 22 COLUMN 2
               LINES 5 COLUMNS 63
                    .
           05 SEARCH-BUTTON PUSH-BUTTON 
               RESOURCE "button.search" WHEN OMITTED "&Search"
               LINE 28 COLUMN 25
               TERMINATION-VALUE = SELECTED-SEARCH
               .
           05 VIEW-BUTTON PUSH-BUTTON 
               RESOURCE "button.view" WHEN OMITTED "&View"
               LINE 28 COLUMN 35
               TERMINATION-VALUE = SELECTED-VIEW
               .
                 05 COUNTER-LABEL LABEL LINE 28 COLUMN 58 SIZE 10.
      
       PROCEDURE DIVISION.
       MAIN-ENTRY.
           DISPLAY "PARAGRAPH MAIN-ENTRY" UPON SYSOUT
      
      * Create the main window, setting its attributes
      
           DISPLAY STANDARD GRAPHICAL WINDOW
              TITLE RESOURCE "window.title" WHEN OMITTED "Dream Home"
              SIZE 68 LINES 29
              BACKGROUND-LOW
      
      * Populate the main window with the screen data
      
           DISPLAY MAIN-SCREEN
      
      * Accept a screen, and act on the resulting value.
      
       MAIN-LOOP.
           DISPLAY "PARAGRAPH MAIN-LOOP" UPON SYSOUT
      
           ACCEPT MAIN-SCREEN
      
           EVALUATE ACCEPT-VALUE
               WHEN SELECTED-PRINT  PERFORM DO-PRINT
               WHEN SELECTED-ABOUT  PERFORM DO-ABOUT
               WHEN SELECTED-EXIT   PERFORM DO-EXIT
               WHEN SELECTED-SEARCH PERFORM DO-SEARCH
               WHEN SELECTED-VIEW   PERFORM DO-VIEW    
           END-EVALUATE
      
      * Update the price entry-fields so the dollar values
      * will be reflected in currency form.
      
           DISPLAY MINPRICE
           DISPLAY MAXPRICE
      
           GO TO MAIN-LOOP
           .
      
      * Search for the houses matching the given criteria,
      * filling in the searchbox with the results.
      
       DO-SEARCH.
           DISPLAY "PARAGRAPH DO-SEARCH" UPON SYSOUT
      
           INQUIRE BED-CHOICE SELECTION-INDEX IN SEARCH-BED
           INQUIRE BATH-CHOICE SELECTION-INDEX IN SEARCH-BATH
           MOVE MAXPRICE-VALUE TO SEARCH-MAXPRICE
           MOVE MINPRICE-VALUE TO SEARCH-MINPRICE
      
           MOVE 1 TO SEARCH-INDEX
           MOVE 0 TO SEARCH-FOUND
      
           MODIFY SEARCHBOX RESET-LIST = TRUE
      
           DISPLAY "---------------:" UPON SYSOUT
           DISPLAY "SEARCH-BED     : " SEARCH-BED UPON SYSOUT
           DISPLAY "SEARCH-BATH    : " SEARCH-BATH UPON SYSOUT
           DISPLAY "SEARCH-MAXPRICE: " SEARCH-MAXPRICE UPON SYSOUT
           DISPLAY "SEARCH-MINPRICE: " SEARCH-MINPRICE UPON SYSOUT
      
           PERFORM UNTIL SEARCH-INDEX > 15
               IF BEDROOM OF HOUSE-ARRAY (SEARCH-INDEX) = SEARCH-BED
                  AND BATHROOM OF HOUSE-ARRAY (SEARCH-INDEX) =
                      SEARCH-BATH 
                        AND PRICE OF HOUSE-ARRAY (SEARCH-INDEX) >= 
                            SEARCH-MINPRICE
                  AND PRICE OF HOUSE-ARRAY (SEARCH-INDEX) <= 
                            SEARCH-MAXPRICE
                  THEN
                      ADD 1 TO SEARCH-FOUND
                      MODIFY SEARCHBOX
                          ITEM-TO-ADD = 
                              ADDRESS0 OF HOUSE-ARRAY (SEARCH-INDEX)
               END-IF
               ADD 1 TO SEARCH-INDEX
           END-PERFORM
      
           DISPLAY "SEARCH-FOUND   : " SEARCH-FOUND UPON SYSOUT
      
           IF SEARCH-FOUND EQUAL TO ZERO THEN
               MODIFY SEARCHBOX ITEM-TO-ADD =
                "No matches found (use one more bedroom than bathroom)"
           END-IF
           .
      
      * Action for the View button, or double-clicking the searchbox
      
       DO-VIEW.
           DISPLAY "PARAGRAPH DO-VIEW" UPON SYSOUT
      
           IF SEARCH-FOUND > 0 THEN
               PERFORM VARYING SEARCH-INDEX FROM 1 BY 1
                   UNTIL SEARCH-INDEX > 15
                   IF ADDRESS0 OF HOUSE-ARRAY(SEARCH-INDEX) 
                            = SEARCHBOX-VALUE
                   THEN
                       PERFORM DO-VIEW-OF-SEARCH-INDEX
                       EXIT PERFORM
                   END-IF
               END-PERFORM
           END-IF
          .
      
      * View the house and floorplan of the house at search-index
      
       DO-VIEW-OF-SEARCH-INDEX.       
      
           DISPLAY "-------------" UPON SYSOUT
      
           DISPLAY "Viewing house " SEARCH-INDEX " '" 
                   OUTSIDE OF HOUSE-ARRAY(SEARCH-INDEX)
                   "' floorplan '"
                   FLOORPLAN OF HOUSE-ARRAY(SEARCH-INDEX)
                   "'" UPON SYSOUT
      
           MODIFY HOUSE-IMAGE 
              BITMAP-VALUE = OUTSIDE OF HOUSE-ARRAY(SEARCH-INDEX)
              SIZE 30 CELLS LINES 13 CELLS
      
           MODIFY FLOOR-IMAGE 
              BITMAP-VALUE = FLOORPLAN OF HOUSE-ARRAY(SEARCH-INDEX)
              SIZE 30 CELLS LINES 13 CELLS
          .           
      
      * Exit the program; stop all run stops all threads.
      
       DO-EXIT.
           IF IN-APPLET
      	       DISPLAY "PARAGRAPH DO-EXIT: N/A APPLET" UPON SYSOUT
           ELSE
              DISPLAY "PARAGRAPH DO-EXIT" UPON SYSOUT
              STOP ALL RUN
           END-IF
           .
      
      * Display an about message box.
      
       DO-ABOUT.
           DISPLAY "PARAGRAPH DO-ABOUT" UPON SYSOUT
      
           DISPLAY MESSAGE BOX 
               TITLE = "About..."
               VALUE = "Dream Home, " &
               "(C) Heirloom Computing Inc." 
           .
      
       DO-PRINT.             
           DISPLAY "PARAGRAPH DO-PRINT" UPON SYSOUT
           SHOW WINDOW UPON PRINTER
           .
      
      *
      * The APPLET-INIT, APPLET-START, APPLET-STOP, and APPLET-DESTROY
      * paragraphs are executed automatically by the system for applets.
      * These events are not typically used, but the APPLET-DESTROY
      * may be used to cleanup resources held (open files, for instance).
      *
      * The APPLICATION- paragraphs are equivalent for an application,
      * rather than applet, and are useful for testing applets as
      * applications.  They should generally not be used in typical
      * applications, but are presented here for completeness.  The
      * APPLICATION-STOP/DESTROY will only be executed under a GOBACK,
      * or fall out of program, not with a STOP RUN.
      *
      * These paragraphs, if used, must operate very quickly; they
      * should never be long-running activities.
      *
       APPLET-INIT.
          DISPLAY "PARAGRAPH APPLET-INIT" UPON SYSOUT
      	   SET IN-APPLET TO TRUE
      	   .
       APPLET-START.
          DISPLAY "PARAGRAPH APPLET-START" UPON SYSOUT
      	   ADD 1 TO MY-COUNTER
      	   MODIFY COUNTER-LABEL TITLE = MY-COUNTER
      	   DISPLAY "MY-COUNTER: " MY-COUNTER UPON SYSOUT
      	   .
       APPLET-STOP.
          DISPLAY "PARAGRAPH APPLET-STOP" UPON SYSOUT
          CLOSE WINDOW
      	   .
       APPLET-DESTROY.
          DISPLAY "PARAGRAPH APPLET-DESTROY" UPON SYSOUT
      	   .
      
      *APPLICATION-INIT.	   
      *    DISPLAY "APPLICATION-INIT" UPON SYSOUT
      *    .
      *APPLICATION-START.
      *    DISPLAY "APPLICATION-START" UPON SYSOUT
      *    .
      *APPLICATION-STOP.
      *    DISPLAY "APPLICATION-STOP" UPON SYSOUT
      *    .	    
      *APPLICATION-DESTROY.
      *    DISPLAY "APPLICATION-DESTROY" UPON SYSOUT
      *    .
