* GreeterServlet
*
* It obtains a reference to an EJB to obtain the time of day string and
* outputs a message to the HTML browser that invokes this program.
*
IDENTIFICATION DIVISION.
PROGRAM-ID. "samples.hellocobol.servlet.GreeterServlet" INHERITS OBJECT.

DATA DIVISION.
WORKING-STORAGE SECTION.

* Non-traditional Cobol variables for referencing possibly remote EJB functionality
77 myGreeterHome OBJECT REFERENCE "samples.hellocobol.ejb.GreeterHome".
77 myGreeterRemote OBJECT REFERENCE "samples.hellocobol.ejb.Greeter".

* Traditional Cobol variables
77 theMessage PIC X(80).
77 theName PIC X(80).
77 errorMessage PIC X(80).

PROCEDURE DIVISION.
MAIN-PARAGRAPH.

* Obtain the reference to the EJB object's home
    SET myGreeterHome TO INITIAL NARROW NAME "java:comp/env/ejb/greeter"
    IF myGreeterHome = NULL THEN
        MOVE "Could not obtain reference to ejb/greeter" TO errorMessage
        PERFORM ERROR-HANDLER
        GOBACK
    END-IF

* Create the bean itself    
    INVOKE myGreeterHome "create" GIVING myGreeterRemote
    ON EXCEPTION
        MOVE "Could not create the greeter bean" TO errorMessage
        PERFORM ERROR-HANDLER
        GOBACK
    END-INVOKE

* Invoke the bean's getGreeting method, giving a time of day message
    INVOKE myGreeterRemote "getGreeting" GIVING theMessage

* Set the variable theName to the HTML's parameter 'name'
    SET theName TO CONFIGURATION "SERVLET-PARAMETER-name"

* Output HTML to the user, embedding host variables as appropriate.
*
* HTML may be output using either EXEC HTML or by using DISPLAY statements.
    
    EXEC HTML.
    
    <HTML> 
    <HEAD><TITLE>Greeter</TITLE></HEAD> 
     <BODY BGCOLOR=#FFFFFF> 
      <H2>Hello World!</H2> 
      <p> 
       Good <hostvar name=theMessage></hostvar>, <hostvar name=theName></hostvar>.
       Enjoy your <hostvar name=theMessage></hostvar>.
      </p> 
     </BODY> 
    </HTML>
    
    END-EXEC
    
    GOBACK
    .

ERROR-HANDLER.

* Output error to logfile
    DISPLAY "Cobol Servlet Error: " errorMessage UPON SYSOUT

* Output error to user        
    DISPLAY "<HTML>"
    DISPLAY "<HEAD><TITLE>Error Processing Cobol Servlet</TITLE></HEAD>"
    DISPLAY " <BODY BGCOLOR=#FFFFFF>"
    DISPLAY "  <H2>Error Processing Cobol Servlet:</H2>"
    DISPLAY "  <p>" errorMessage "</p>"
    DISPLAY " </BODY>"
    DISPLAY "</HTML>"
    .
