       IDENTIFICATION DIVISION.
       PROGRAM-ID. ETPCallFromCOBOL.

      *
      * ETPCallFromCOBOL - a standard COBOL command-line app (i.e., non ETP
      * program) that invokes a transaction in an ETP region.  This
      * uses the ETP_LINK API part of the non-transactional ecobol.jar
      * runtime library to set up the EJB call library and invoke the
      * link dispatcher in the destination ETP region.
      *
      
       WORKING-STORAGE SECTION.
       10 COMMAREA PIC X(60).
       10 RETURNMESSAGE PIC X(10).
       10 JNDI1 PIC X(81) VALUE 'java.naming.factory.initial=org.apache.
      -           'openejb.client.RemoteInitialContextFactory'.
       10 JNDI2 PIC X(80) VALUE 
                  'java.naming.provider.url=ejbd://localhost:4201'.
       10 JNDI3 PIC X(80) VALUE 
                  'java.naming.security.principal=system'.
       10 JNDI4 PIC X(80) VALUE 
                  'java.naming.security.credentials=manager'.
       
       PROCEDURE DIVISION.
       MAIN.
           DISPLAY "ETPCallFromCOBOL STARTING" UPON SYSOUT.
           
      *    invoke the CICS transaction program ELINKTRN in sysid ETP1
      *    passing COMMAREA and two JNDI parameters.  if the JEE server
      *    is running under Java naming security then the user and
      *    password is required as well.
           MOVE 'HELLO FROM ETPCallFromCOBOL' TO COMMAREA.
           DISPLAY "Calling Program ID 'ETPETRN' in SYSID 'ETP2'"
               UPON SYSOUT.
           CALL 'ETP_LINK' USING 'ETPETRN', 'ETP2', COMMAREA, 
                JNDI1, JNDI2
      *       , JNDI3, JNDI4
                GIVING RETURNMESSAGE.
           DISPLAY "Giving " RETURNMESSAGE ", COMMAREA " COMMAREA
               UPON SYSOUT.
                
       END PROGRAM.
