*
* TESTMYCLASS-FROMCOBOL
*
* Copyright (C) 2010-2023 Heirloom Computing Inc.  All Rights Reserved.
*
* This file and associated files are copyrighted information
* of Heirloom Computing.  Permission is granted for usage in 
* conjunction with the Elastic COBOL product.
*
* This program invokes the my_class COBOL class in exactly
* the same manner as testmyclass_fromjava does, but coded
* in COBOL instead of Java.
*
id division.
program-id. testmyclass-fromcobol.

data division.
class-control.
   java-awt-color is class "java.awt.Color"
   .
   
working-storage section.

01 alpha object reference "my_class".
01 beta object reference "my_class".
01 v object reference "java.util.Vector".

01 color_red object reference java-awt-color.

01 short-1 pic xx comp-x.
01 short-2 pic xx comp-x.
01 result pic xx comp-x.

01 size-of-v pic 999.
01 i pic sx(4) comp-x.
01 element object reference.

procedure division.
main-paragraph.

    invoke alpha giving alpha
    invoke beta giving beta

    display "alpha:" upon sysout
    
    perform 10 times
        invoke alpha "one"
        invoke alpha "two"
        invoke alpha "three"
    end-perform
    
    display "beta:" upon sysout
    
    perform 10 times
        invoke beta "one"
	invoke beta "two"
	invoke beta "three"
    end-perform
    
    display "alpha:" upon sysout
    
    perform 10 times
        invoke alpha "one"
        invoke alpha "two"
        invoke alpha "three"
    end-perform
    
    display "beta:" upon sysout
    
    perform 10 times
        invoke beta "one"
	invoke beta "two"
	invoke beta "three"
    end-perform
    
    move 1 to short-1
    move 2 to short-2
    invoke alpha "shortadder" using by value short-1 short-2 giving result
    
    display "shortadder(1,2)=" result upon sysout
    
    move 100 to short-1
    move 200 to short-2
    invoke alpha "shortadder" using by value short-1 short-2 giving result
    display "shortadder(100,200)=" result upon sysout
    
    move 123 to short-1
    move 345 to short-2
    invoke alpha "shortadder" using by value short-1 short-2 giving result
    display "shortadder(123,345)=" result upon sysout
    
    | This is setting the object reference to an actual variable field
    | within the class java.awt.Color.  This field is a constant
    | representing the color red in Java.
        
    set color_red to "red" of java-awt-color
    
    invoke alpha "outputter" using by value "Hi there!", color_red giving v
    
    display "Return vector=" v upon sysout
    
    if v not = null then
    
        invoke v "size" giving size-of-v
	
	display "size=" size-of-v upon sysout
	
	perform varying i from 0 by 1 until i>= size-of-v
	    invoke v "elementAt" using by value i giving element
	    display i ":'" element "'" upon sysout
	end-perform
    
    end-if
    
    invoke alpha "myMixedCapsMethod" using by value "Mixed Caps test"
    .
    
