      *
      * PRINTERTEST
      *
      * Copyright (C) 2010-2023 Heirloom Computing Inc.  All Rights Reserved.
      *
      * This file and associated files are copyrighted information
      * of Heirloom Computing.  Permission is granted for usage in 
      * conjunction with the Elastic COBOL product.
      *
       identification division.
       program-id. printertest.
      
       environment division.
       input-output section.
       file-control.
      *    select print-file assign to printer "printer?"
           select print-file assign to "printer:"
           .
      
       data division.
       file section.
       fd print-file.
       01 print-rec pic x(80).
       01 print-group.
           05 print-text pic x(5).
           05 print-num pic 999.
           05 filler-1 pic x(36).
           05 filler-2 pic x(36).
      
       working-storage section.
       
       77 counter pic 999 value 0.
       77 size-x pic 999v99.
       77 size-y pic 999v99.      
       
       77 size-x-du pic 9(10).
       77 size-y-du pic 9(10).
       
       77 size-x-cu pic 9(3).
       77 size-y-cu pic 9(3).
      
       77 size-x-in pic 99v99.
       77 size-y-in pic 99v99.
      
       77 accept-dummy pic x.       
      
       77 horiz-inches pic 999v99.
       77 vert-inches pic 999v99.       
       
       procedure division.
       main-paragraph.
           open output print-file
           
           call "p$SetLeftMargin" using 1 "Inch"
           call "p$SetTopMargin" using 1 "Inch"
           
           move "Line " to print-text
           move 1 to print-num
           move "901234567890123456789012345678901234" to filler-1
           move "567890123456789012345678901234567890" to filler-2
           write print-group before advancing 1 line
      
           perform varying counter from 2 by 1 until counter > 132
               move "Line " to print-group
               move counter to print-num
               write print-group before advancing 1 line
           end-perform
           
      * Units can be 'Device Units', 'Inches', 'Metric' for cm, 'Characters'; default is Inches
      
           call "p$SetDefaultUnits" using "Device Units"
      
      * p$TextOut "text" x-position y-position ["Absolute/Relative" ["Units" ["Y/N"-box ["Y/N"-shade]]]]
      *
      * In all of these routines, it is 'x y' and 'width height'.
      *
      * In all of these routines, the first character is used for unit (I for Inch, etc.),
      * and mode (A for Absolute, etc.), and Y/N booleans (Y for Yes, N for No).
      
           call "p$TextOut" using "This is line one at (100,100)"
                100 100
           call "p$TextOut" using "This is line three at (300,300)"
                300 300
           call "p$TextOut" using "This is line two at (200,200)"
                200 200
           call "p$TextOut" using "This is line four at (200,400)"
                200 400 "Absolute" "Device Units" "Y"
           call "p$TextOut" using "This is line five at (100,500)"
                100 500 "Absolute" "Device Units" "Y" "Y"      
      
           call "p$TextOut" using "This is before" 
                 4 .5 "A" "I" "Y"
           
           call "p$TextOut" using "This is after" 
                 omitted omitted omitted omitted "Y"
      
           call "p$SetDefaultUnits" using "Inches"
      
      * Single quotes are used so inch markers (quote) may be included easily
      
           call "p$TextOut" using '(1",1")' 1 1
           call "p$TextOut" using '(2",1")' 2 1
           call "p$TextOut" using '(3",1")' 3 1
           call "p$TextOut" using '(4",1")' 4 1
           call "p$TextOut" using '(5",1")' 5 1
           call "p$TextOut" using '(6",1")' 6 1
           call "p$TextOut" using '(7",1")' 7 1
           call "p$TextOut" using '(8",1")' 8 1
      
      * Any built-in color name, or color from rgb.txt (Unix standard) file
      * may be used; rgb.txt must be in current directory or .jar if used.
      * The basic colors like red, green, blue, black are built-in.
      * SetTextColor r,g,b or #RRGGBB in hex, or color name
      
           call "p$SetTextColor" using "red"
      
           call "p$TextOut" using '(1",2")' 1 2
           call "p$TextOut" using '(1",3")' 1 3
      
           call "p$TextOut" using '(1",4")' 1 4
           call "p$TextOut" using '(1",5")' 1 5
      
           call "p$SetTextColor" using "blue"
      
           call "p$TextOut" using '(1",6")' 1 6
      
           call "p$SetTextColor" using "black"
           call "p$TextOut" using '(1",7")' 1 7
           call "p$TextOut" using "following 7"
           call "p$TextOut" using '(1",8")' 1 8
      
      * setFont properties are set name then value,
      * include "name" with value as name of font,
      * "height" with value as height of font,
      * "italic" is "Y" or "N"
      * "bold" is "Y" or "N"
      * "underline" is "Y" or "N"
      
      *    call "p$SetFont" using "name" "Serif" "height" "48"
           call "p$TextOut" using "Serif-48 text" 4 5
      
      * ClearFont returns to the default font    
           call "p$ClearFont"
      
           call "p$SetFont" using "underline" "Y"
           call "p$TextOut" using '(1",9")' 1 9
           call "p$SetFont" using "underline" "N"
      
           call "p$TextOut" using '(1",10")' 1 10
           call "p$TextOut" using '(1",11")' 1 11
      
      * DrawBox x-pos y-pos abs/rel units size-width size-height size-units [shade-y-n [raised-y-n OR [horiz-round vert-round]]]
      
           call "p$DrawBox" using 3 3 "Absolute" "Inches" 1 1
           call "p$DrawBox" using 3.1 3.1 "Absolute" "Inches" 
                 .8 .8 "Inches" "Y"
           call "p$DrawLine" using 3 3 "A" "I" 4 4 "A" "I"
      
      * r,g,b or #RRGGBB in hex, or color name
      
      *    call "p$SetBoxShade" using "200,200,200"
      
      * Draw a bitmap without scaling it
      *    call "p$SetPosition" using 3 7 "A" "I"
      *    call "p$DrawBitmap" using "Zapotec.bmp"
      
      * Draw a bitmap while scaling it; in this case, exactly 1 inch by 1 inch
           call "p$DrawBitmap" using "printergfx.jpg" 3 7 "A" "I" 
                 1 1 "I"
      
      * getTextExtent returns the rendered size of a piece of text,
      * it doesn't actually render it.
      
           call "p$GetTextExtent" using "Some Text"
                 size-x-du size-y-du "Device Unit"
      
           display "Device Unit: size-x=" size-x-du ", size-y=" 
                   size-y-du
                   upon sysout
           call "p$GetTextExtent" using "Some Text"
                size-x-cu size-y-cu "Characters"
      
           display "Chars: size-x=" size-x-cu ", size-y=" size-y-cu
                   upon sysout
           call "p$GetTextExtent" using "Some Text"
                size-x-in size-y-in "Metric"
      
           display "Metric: size-x=" size-x-in ", size-y=" size-y-in
                   upon sysout
           call "p$GetTextExtent" using "Some Text"
                 size-x-in size-y-in "Inches"
      
           display "Inches: size-x=" size-x-in ", size-y=" size-y-in
               upon sysout
      
           call "p$GetDeviceCapabilities" using
                "HORIZONTAL_INCHES" horiz-inches
                "VERTICAL_INCHES" vert-inches	   	       
      
           display "horiz inches: " horiz-inches upon sysout
           display "vert inches : " vert-inches upon sysout	       
      
           call "p$GetDeviceCapabilities" using
                "LOGICAL_PIXELS_X" horiz-inches
                "LOGICAL_PIXELS_Y" vert-inches	   	       
      
           display "log pixels x: " horiz-inches upon sysout
           display "log pixels y: " vert-inches upon sysout	       
      
           close print-file
      
      * The printer starts background threads, so an a stop run is necessary
           stop run
           .
