      *
      * COUNTER
      *
      * Copyright (C) 2010-2023 Heirloom Computing Inc.  All Rights Reserved.
      *
      * This file and associated files are copyrighted information
      * of Heirloom Computing.  Permission is granted for usage in
      * conjunction with the Elastic COBOL product.
      *
      * Counter displays how many times the servlet has been "hit"
      * since started, and how many times it has been "hit" by
      * the user in the user's current session.
      *
       IDENTIFICATION DIVISION.
       PROGRAM-ID. COUNTER.
       
       DATA DIVISION.
      
       SHARED-STORAGE SECTION.
       
      * Share this variable among all instances of this program,
      * for all sessions.
       01 TOTAL-COUNTER PIC 9999 VALUE 0.
       
       LOCAL-STORAGE SECTION.
      
      * This variable is used to read data from and write data to
      * the servlet session.
       01 SESSION-COUNTER PIC 9999 VALUE 0.
       
       PROCEDURE DIVISION.
       MAIN-PARAGRAPH.
      *
      * Display a greeting to anyone running this servlet as an
      * application.
      *
           DISPLAY "Elastic COBOL Counter Servlet" UPON SYSOUT
           DISPLAY "Copyright (C) Heirloom Computing Inc." UPON SYSOUT
           DISPLAY "All Rights Reserved." UPON SYSOUT
           DISPLAY "" UPON SYSOUT
           DISPLAY "This application executes as a servlet" UPON SYSOUT
           DISPLAY "that needs to be deployed to a web" UPON SYSOUT
           DISPLAY "application server." UPON SYSOUT
           STOP RUN
           .
       
      *
      * Servlet Code Begins Here
      *
       SERVLET.
      *
      * Track total usage information.
      * 
           ADD 1 TO TOTAL-COUNTER
           ACCEPT  SESSION-COUNTER FROM 
               CONFIGURATION "SERVLET-SESSION-PARAMETER-COUNTER"
               ON EXCEPTION
                   MOVE 0 TO SESSION-COUNTER
           END-ACCEPT
      
      *
      * Track information pertinent to this session in particular.
      *
           ADD 1 TO SESSION-COUNTER
           DISPLAY SESSION-COUNTER UPON
               CONFIGURATION "SERVLET-SESSION-PARAMETER-COUNTER"
      
      *
      * Display HTML to the browser with this information.
      *
       EXEC HTML.
       <HEAD>
       <TITLE>Elastic COBOL Counter Servlet</TITLE>
       </HEAD>
      
       <BODY>
       <H1>Welcome to the Elastic COBOL Counter Servlet!</H1>
       <P>
           This page has been accessed
           <hostvar name=total-counter </hostvar>
           times since the servlet was started.<br>
           This page has been accessed
           <hostvar name=session-counter> </hostvar>
           times since this session was started.
       <P>
           <a href="http://www.elasticcobol.com">Elastic COBOL</a>
       </BODY>
       END-EXEC.
       .
