      *
      * SNOOPER
      *
      * Copyright (C) 2010-2023 Heirloom Computing Inc.  All Rights Reserved.
      *
      * This file and associated files are copyrighted information
      * of Heirloom Computing.  Permission is granted for usage in
      * conjunction with the Elastic COBOL product.
      *
      * This example displays information pertaining to the access
      * used to show the page.
      *
      
       IDENTIFICATION DIVISION.
       PROGRAM-ID. SNOOPER.
       
       DATA DIVISION.
       LOCAL-STORAGE SECTION.
       
       77 MYDATA1 PIC X(80).
       77 MYDATA2 PIC X(80).
       77 MYDATA3 PIC X(80).
       77 MYDATA4 PIC X(80).
       77 MYDATA5 PIC X(80).
       77 MYDATA6 PIC X(80).
       77 MYDATA7 PIC X(80).
       77 MYDATA8 PIC X(80).
       77 MYDATA9 PIC X(80).
       77 MYDATA10 PIC X(80).
       77 MYDATA11 PIC X(80).
       77 MYDATA12 PIC X(80).
       77 MYDATA13 PIC X(80).
       77 MYDATA14 PIC X(80).
       77 MYDATA15 PIC X(80).
       
       PROCEDURE DIVISION.
       MAIN-PARAGRAPH.
           DISPLAY "Elastic COBOL Snooper Servlet" UPON SYSOUT.
           DISPLAY "Copyright (C) Heirloom Computing Inc." UPON SYSOUT
           DISPLAY "All Rights Reserved." UPON SYSOUT
           DISPLAY "" UPON SYSOUT
           DISPLAY "To execute, install via the web server admin"
                   " console and load via the servlet URL."
                   UPON SYSOUT
           STOP RUN
           .
       
       SERVLET.
           ACCEPT MYDATA1 FROM ENVIRONMENT "SERVLET-METHOD"
           ACCEPT MYDATA2 FROM ENVIRONMENT "SERVLET-REQUEST-URI"
           ACCEPT MYDATA3 FROM ENVIRONMENT "SERVLET-PROTOCOL"
           ACCEPT MYDATA4 FROM ENVIRONMENT "SERVLET-PATH"
           ACCEPT MYDATA5 FROM ENVIRONMENT "SERVLET-PATH-INFO"
           ACCEPT MYDATA6 FROM ENVIRONMENT "SERVLET-PATH-TRANSLATED"
           ACCEPT MYDATA7 FROM ENVIRONMENT "SERVLET-QUERY-STRING"
           ACCEPT MYDATA8 FROM ENVIRONMENT "SERVLET-CONTENT-LENGTH"
           ACCEPT MYDATA9 FROM ENVIRONMENT "SERVLET-CONTENT-TYPE"
           ACCEPT MYDATA10 FROM ENVIRONMENT "SERVLET-SERVER-NAME"
           ACCEPT MYDATA11 FROM ENVIRONMENT "SERVLET-SERVER-PORT"
           ACCEPT MYDATA12 FROM ENVIRONMENT "SERVLET-REMOTE-USER"
           ACCEPT MYDATA13 FROM ENVIRONMENT "SERVLET-REMOTE-ADDR"
           ACCEPT MYDATA14 FROM ENVIRONMENT "SERVLET-REMOTE-HOST"
           ACCEPT MYDATA15 FROM ENVIRONMENT "SERVLET-AUTH-TYPE"
        
           EXEC HTML.
           <HEAD>
           <TITLE>Elastic COBOL Servlet Snooper</TITLE>
           </HEAD>
      
           <BODY>
           <h1>Elastic COBOL Servlet Snooper</h1>
           <h2>Copyright (C) Heirloom Computing Inc</h2>
           <p>
           <h3>
           Query String is <hostvar name=MYDATA7></hostvar><br>
           </h3>
           <p>
           Method is <hostvar name=MYDATA1></hostvar><br>
           Request URI is <hostvar name=MYDATA2></hostvar><br>
           Protocol is <hostvar name=MYDATA3></hostvar><br>
           Path is <hostvar name=MYDATA4></hostvar><br>
           Path Info is <hostvar name=MYDATA5></hostvar><br>
           Path Translated is <hostvar name=MYDATA6></hostvar><br>
           Content Length is <hostvar name=MYDATA8></hostvar><br>
           Content Type is <hostvar name=MYDATA9></hostvar><br>
           Server Name is <hostvar name=MYDATA10></hostvar><br>
           Server Port is <hostvar name=MYDATA11></hostvar><br>
           Remote User is <hostvar name=MYDATA12></hostvar><br>
           Remote Address is <hostvar name=MYDATA13></hostvar><br>
           Remote Host is <hostvar name=MYDATA14></hostvar><br>
           Auth Type is <hostvar name=MYDATA15></hostvar><br>
           </BODY>
      
           END-EXEC.
           .
