      *
      * TCPIPCLIENT
      *
      * Copyright (C) 2010-2023 Heirloom Computing Inc.  All Rights Reserved.
      *
      * This file and associated files are copyrighted information
      * of Heirloom Computing.  Permission is granted for usage in 
      * conjunction with the Elastic COBOL product.
      *
      * This is an example program to display the time and date
      * by using the daytime service of a UN*X/MPE machine.
      *
      * Point the TCP-FILE assign to the socket of a machine
      * which has the daytime service.  The machine name
      * may either be an actual name or IP number.
      *
      * Keep the :13 for port 13 the same for daytime values.
      *
      * Change the :13 to other ports to examine what other
      * ports output.  Keep in mind that not all other
      * ports will disconnect after sending the output
      * (which corresponds to the AT END condition of the READ).
      *
      * Change the OPEN mode to I-O in order to write to
      * the box as well.
      *
      * Changing to LINE SEQUENTIAL may make sense for some
      * services.
      
       IDENTIFICATION DIVISION.
       PROGRAM-ID. TCPIPCLIENT.
      
       ENVIRONMENT DIVISION.
       CONFIGURATION SECTION.
       INPUT-OUTPUT SECTION.
       FILE-CONTROL.
      *
      * Can change the machine name below to a Unix TOD server visible from your
      * network running a standard TOD Server on port 13.
      *
       SELECT TCP-FILE ASSIGN TO
              "socket:127.0.0.1:3456".
      
       DATA DIVISION.
       FILE SECTION.
       FD TCP-FILE.
       01 PRINT-REC PICTURE X(1).
      
       PROCEDURE DIVISION.
       GREETING.
           DISPLAY "* Opening Connection..." upon sysout.
       OPEN-FILE.
           OPEN INPUT TCP-FILE.
       REPEAT-READ.
      *
      * Get a character from the port and display it.
      *
           READ TCP-FILE
      	    AT END
      	       GO TO DONE-READING
      	    END-READ
      	    DISPLAY PRINT-REC UPON SYSOUT WITH NO ADVANCING
      	    GO TO REPEAT-READ.
       DONE-READING.
           DISPLAY "" UPON SYSOUT
      	    DISPLAY "* Port Closed" UPON SYSOUT.
      *
      * Close port to end connection from this side.
      *
           CLOSE TCP-FILE. 
      
