      * 
      * SHOWTHREADS
      *
      * Copyright (C) 2010-2023 Heirloom Computing Inc.  All Rights Reserved.
      *
      * This file and associated files are copyrighted information
      * of Heirloom Computing.  Permission is granted for usage in 
      * conjunction with the Elastic COBOL product
      *
      * This program shows a call sequence in both unthreaded and
      * threaded form.  The threaded version is non-deterministic,
      * so it may or may not print in order depending upon the
      * the system's thread scheduling policies.
      *
       IDENTIFICATION DIVISION.
       PROGRAM-ID. showthreads.
      
       PROCEDURE DIVISION.
       WITHOUT-THREADS.
           DISPLAY "WITHOUT THREADS:" UPON SYSOUT
           
           DISPLAY "BEGIN" UPON SYSOUT
           PERFORM PARA-A
           PERFORM PARA-B
           PERFORM PARA-C
           CALL "SUBPROG"
           PERFORM PARA-C
           PERFORM PARA-B
           PERFORM PARA-A
           DISPLAY "END" UPON SYSOUT
           .
       WITH-THREADS.
           DISPLAY "WITH THREADS:" UPON SYSOUT
           
           DISPLAY "BEGIN" UPON SYSOUT
           PERFORM THREAD PARA-A
           PERFORM THREAD PARA-B
           PERFORM THREAD PARA-C
           CALL THREAD "SUBPROG"
           PERFORM THREAD PARA-C
           PERFORM THREAD PARA-B
           PERFORM THREAD PARA-A
           DISPLAY "END" UPON SYSOUT
           .
       PARA-A.
           DISPLAY "PARA-A" UPON SYSOUT
           .
       PARA-B.
           DISPLAY "PARA-B" UPON SYSOUT
           .
       PARA-C.
           DISPLAY "PARA-C" UPON SYSOUT
           .
