*
* XMLPARSE
*
* Copyright (C) 2010-2023 Heirloom Computing Inc.  All Rights Reserved.
*
* This file and associated files are copyrighted information
* of Heirloom Computing.  Permission is granted for usage in 
* conjunction with the Elastic COBOL product.
*
id division.
program-id. xmlparse.

procedure division.
main-paragraph.

        display "** begin parsing XML **" upon sysout

* XML PARSE is the COBOL verb for parsing data using a PROCESSING PROCEDURE.
* PARSE is a context-sensitive keyword, reserved only after the word XML.
* This example uses the data in the resource file xmldata.xml.

        xml parse resource "xmldata.xml" processing procedure is xml-handler
        on exception
                display "XML error: " XML-CODE upon sysout end-display
        not on exception
                display "XML document parsed successfully" upon sysout end-display
        end-xml
    
        display "** end parsing XML **" upon sysout
        
        goback
        .

xml-handler.
        if XML-CODE not = zeroes then
            display "XML-CODE : " XML-CODE upon sysout
        end-if
        display "XML-EVENT: '" XML-EVENT "'"upon sysout
        display "XML-TEXT : '" XML-TEXT "'" upon sysout
        display "---------" upon sysout
        .
        
