/*
 * Decompiled with CFR 0.152.
 */
package com.heirloomcomputing.ecs.exec;

import com.heirloomcomputing.ecs.exec.ACUFile;
import com.heirloomcomputing.ecs.exec.ACUFilePointer;
import com.heirloomcomputing.ecs.exec.Numeric;
import com.heirloomcomputing.ecs.exec.RuntimeEnvironment;
import com.heirloomcomputing.ecs.exec.Variable;
import com.heirloomcomputing.ecs.exec.VariableList;
import com.heirloomcomputing.ecs.exec.bTreeNode;
import com.heirloomcomputing.ecs.exec.comparableByteArray;

public class ACUBTreeNode
extends bTreeNode {
    public static final boolean debugMode = false;
    private ACUFile file = null;
    private ACUFilePointer currentLocation = null;
    private comparableByteArray keyTemplate = null;
    private int bTreeIndex = -1;
    private byte[] mainBuffer = null;
    private int numberOfKeys = 0;
    private int maxKeys;
    private int minKeys;
    private int keyLength;
    private int childLength;
    private long[] duplicateCount;
    private boolean allowsDuplicates = false;
    private boolean nodeIsDeleted = false;

    public static void debug(String text) {
        System.out.println("ACUBTreeNode: " + text);
    }

    public ACUBTreeNode(ACUFile file2, int order, comparableByteArray nodeKeyTemplate, int bTreeIndex, int keyTemplateLength) {
        this.maxKeys = order - 1;
        this.minKeys = this.maxKeys / 2;
        this.duplicateCount = new long[this.maxKeys];
        this.keyTemplate = nodeKeyTemplate;
        this.keyLength = nodeKeyTemplate.length();
        this.childLength = 4;
        this.bTreeIndex = bTreeIndex;
        this.file = file2;
        this.allowsDuplicates = file2.getDuplicatesAllowed(bTreeIndex);
        this.mainBuffer = new byte[file2.getIndexNodeRecordSize()];
        long currentRecordKey = file2.addKeyRecord(this.toByteArray());
        this.currentLocation = new ACUFilePointer(currentRecordKey);
    }

    public ACUBTreeNode(ACUFile file2, int order, long recordKey, comparableByteArray nodeKeyTemplate, int bTreeIndex, int keyTemplateLength) {
        this.maxKeys = order - 1;
        this.minKeys = this.maxKeys / 2;
        this.duplicateCount = new long[this.maxKeys];
        this.keyTemplate = nodeKeyTemplate;
        this.keyLength = nodeKeyTemplate.length();
        this.childLength = 4;
        this.bTreeIndex = bTreeIndex;
        this.file = file2;
        this.allowsDuplicates = file2.getDuplicatesAllowed(bTreeIndex);
        this.mainBuffer = new byte[file2.getIndexNodeRecordSize()];
        byte[] bytes = file2.getKeyRecord(recordKey);
        if (recordKey != 0L) {
            this.fromByteArray(bytes);
        }
        this.currentLocation = new ACUFilePointer(recordKey);
    }

    @Override
    public final Object getLocation() {
        return this.currentLocation;
    }

    @Override
    public final int getNumberOfKeys() {
        return this.numberOfKeys;
    }

    @Override
    public final int getMaxKeys() {
        return this.maxKeys;
    }

    @Override
    public final int getMinKeys() {
        return this.minKeys;
    }

    @Override
    public final long getDuplicateCount(int keyNumber) {
        if (keyNumber < 0 || keyNumber >= this.numberOfKeys) {
            return -1L;
        }
        return this.duplicateCount[keyNumber];
    }

    @Override
    public final void setDuplicateCount(int keyNumber, long count) {
        this.duplicateCount[keyNumber] = count;
    }

    @Override
    public final int getChildLength() {
        return this.childLength;
    }

    @Override
    public final int getKeyLength() {
        return this.keyLength;
    }

    private int getFullKey(byte[] buffer, byte[] lastKey, int index) {
        index += this.getChildLength() + 2;
        if (this.allowsDuplicates) {
            index += 4;
        }
        int offsetPastLastChar = index + (buffer[index] & 0xFF) + 1;
        int differCharPos = (buffer[index + 1] & 0xFF) - 1;
        if (differCharPos < 0) {
            return offsetPastLastChar;
        }
        index += 2;
        while (index < offsetPastLastChar) {
            lastKey[differCharPos++] = buffer[index++];
        }
        return offsetPastLastChar;
    }

    @Override
    public byte[] getFullKeyFromBytes(byte[] bytes, int offset) {
        int endKVB = ACUFile.getShortFromBytes(this.mainBuffer, 1) + 3;
        if (offset > endKVB) {
            return null;
        }
        int index = this.allowsDuplicates ? 16 : 12;
        byte[] fullKey = new byte[this.keyLength];
        System.arraycopy(bytes, index, fullKey, 0, this.keyLength);
        if ((index += this.keyLength) < offset && offset < bytes.length && bytes[offset] == 127 && bytes[offset - 1] == 0) {
            for (int i = 0; i < this.keyLength; ++i) {
                fullKey[i] = 127;
            }
            return fullKey;
        }
        boolean isFirstKey = true;
        while (index < offset) {
            index = this.getFullKey(this.mainBuffer, fullKey, index);
            isFirstKey = false;
        }
        if (!isFirstKey && fullKey[0] == 127) {
            for (int i = 0; i < this.keyLength; ++i) {
                fullKey[i] = 127;
            }
        }
        return fullKey;
    }

    private final int getOffsetForKeyInfo(int keyNumber) {
        int index = 3;
        int childLen = this.getChildLength();
        for (int i = 0; i < keyNumber; ++i) {
            index += childLen + 2;
            if (this.allowsDuplicates) {
                index += 4;
            }
            index += (this.mainBuffer[index] & 0xFF) + 1;
        }
        return index;
    }

    @Override
    public final int getKeyByteOffset(int keyNumber) {
        if (keyNumber == 0) {
            if (this.allowsDuplicates) {
                return 16;
            }
            return 12;
        }
        int index = this.getOffsetForKeyInfo(keyNumber);
        int childLen = this.getChildLength();
        index += childLen + 2;
        index = this.allowsDuplicates ? (index += 6) : (index += 2);
        return index;
    }

    @Override
    public final int getChildByteOffset(int childNumber) {
        if (childNumber == 0) {
            return 3;
        }
        int index = this.getOffsetForKeyInfo(childNumber);
        return index;
    }

    @Override
    public Object getChild(int childNumber) {
        if (childNumber >= this.getNumberOfKeys()) {
            return null;
        }
        return super.getChild(childNumber);
    }

    @Override
    public boolean getChild(int childNumber, byte[] bytes, int offset) {
        if (childNumber >= this.getNumberOfKeys()) {
            return false;
        }
        return super.getChild(childNumber, bytes, offset);
    }

    @Override
    public int findKeyWithChild(byte[] childBytes, int offset, int startIndex) {
        int count;
        byte[] buffer = this.getBuffer();
        int numKeys = this.getNumberOfKeys();
        int childLength = this.getChildLength();
        for (count = startIndex; count < numKeys && ACUBTreeNode.compareBytes(buffer, this.getChildByteOffset(count), childLength, childBytes, offset, childLength, false) != 0; ++count) {
        }
        if (count < numKeys) {
            return count;
        }
        return -1;
    }

    @Override
    public final bTreeNode getNode(Object myNodePointer, bTreeNode reuseNode) {
        if (myNodePointer == null) {
            return null;
        }
        ACUFilePointer nodePointer = (ACUFilePointer)myNodePointer;
        ACUBTreeNode node = (ACUBTreeNode)reuseNode;
        long recordKey = nodePointer.getRecordKey();
        node.fromByteArray(this.file.getKeyRecord(recordKey));
        node.currentLocation = new ACUFilePointer(recordKey);
        return node;
    }

    @Override
    public final bTreeNode getNode(Object myNodePointer) {
        if (myNodePointer == null) {
            return null;
        }
        return this.newInstance(((ACUFilePointer)myNodePointer).getRecordKey());
    }

    @Override
    public final void setNode() {
        if (this.currentLocation == null) {
            return;
        }
        if (this.numberOfKeys <= 0 && !this.isRoot()) {
            this.file.deleteKeyRecord(this.currentLocation.getRecordKey());
        } else {
            this.file.updateKeyRecord(this.currentLocation.getRecordKey(), this.toByteArray());
        }
    }

    @Override
    public final Object getData(Object myNodePointer) {
        if (myNodePointer == null) {
            return null;
        }
        long recKey = ((ACUFilePointer)myNodePointer).getRecordKey();
        if (recKey < 0L) {
            recKey = -recKey;
        }
        return this.file.getDataRecord(recKey);
    }

    @Override
    public final bTreeNode newInstance() {
        return new ACUBTreeNode(this.file, this.maxKeys + 1, this.keyTemplate, this.bTreeIndex, this.keyLength);
    }

    public final bTreeNode newInstance(long recordKey) {
        return new ACUBTreeNode(this.file, this.maxKeys + 1, recordKey, this.keyTemplate, this.bTreeIndex, this.keyLength);
    }

    private final boolean fromByteArray(byte[] tempBytes) {
        if (tempBytes == null) {
            return false;
        }
        this.nodeIsDeleted = (tempBytes[0] & 0xFF) == 3;
        int endKVB = ACUFile.getShortFromBytes(tempBytes, 1) + 3;
        int index = 3;
        int i = 0;
        while (index < endKVB) {
            index = this.fromKeyValueBlockBytes(i, index, tempBytes);
            ++i;
        }
        this.numberOfKeys = i;
        this.bTreeIndex = this.allowsDuplicates ? ACUFile.getShortFromBytes(tempBytes, 14) : ACUFile.getShortFromBytes(tempBytes, 10);
        System.arraycopy(tempBytes, 0, this.mainBuffer, 0, tempBytes.length);
        return true;
    }

    private int fromKeyValueBlockBytes(int i, int index, byte[] tempBytes) {
        if (i == 0) {
            long childPointer = ACUFile.getIntFromBytes(tempBytes, index);
            this.setLeaf(childPointer <= 0L);
            if (this.allowsDuplicates) {
                this.duplicateCount[i] = ACUFile.getIntFromBytes(tempBytes, index + 6);
                index += 13 + this.keyLength;
            } else {
                index += 9 + this.keyLength;
            }
            return index;
        }
        int childLen = this.getChildLength();
        index += childLen + 2;
        if (this.allowsDuplicates) {
            this.duplicateCount[i] = ACUFile.getIntFromBytes(tempBytes, index);
            index += 4;
        }
        index = (tempBytes[index] & 0xFF) + index + 1;
        return index;
    }

    private final byte[] toByteArray() {
        byte[] tempBytes = this.mainBuffer;
        int index = 3;
        for (int i = 0; i < this.numberOfKeys; ++i) {
            index = this.toKeyValueBlockBytes(i, index);
        }
        if (this.allowsDuplicates) {
            tempBytes[14] = (byte)(this.bTreeIndex >> 8 & 0xFF);
            tempBytes[15] = (byte)(this.bTreeIndex & 0xFF);
        } else {
            tempBytes[10] = (byte)(this.bTreeIndex >> 8 & 0xFF);
            tempBytes[11] = (byte)(this.bTreeIndex & 0xFF);
        }
        tempBytes[0] = this.nodeIsDeleted ? 3 : 1;
        return tempBytes;
    }

    private int toKeyValueBlockBytes(int i, int index) {
        if (i == 0) {
            index += 9 + this.keyLength;
            if (this.allowsDuplicates) {
                index += 4;
            }
            return index;
        }
        int childLen = this.getChildLength();
        index += childLen + 2;
        if (this.allowsDuplicates) {
            index += 4;
        }
        index = (this.mainBuffer[index] & 0xFF) + index + 1;
        return index;
    }

    @Override
    public void free() {
        super.free();
        this.numberOfKeys = 0;
        this.duplicateCount = new long[this.maxKeys];
    }

    @Override
    public final String toString() {
        String text = "";
        try {
            boolean showData = false;
            boolean showDuplicateCount = true;
            String lineSep = RuntimeEnvironment.getGlobalParameter("line.separator");
            int numKeys = this.getNumberOfKeys();
            Object l = this.getLocation();
            String loc = "";
            if (l != null) {
                loc = l.toString();
            }
            text = loc + " " + numKeys + ": ";
            text = this.isRoot() ? text + "(Root) " : text + "       ";
            if (this.isLeaf()) {
                text = text + "x ";
                for (int count = 0; count < numKeys; ++count) {
                    ACUFilePointer child = (ACUFilePointer)this.getChild(count);
                    text = text + child.toStringNegative();
                    if (showData) {
                        text = text + ":" + new String((byte[])this.getData(child));
                    }
                    text = showDuplicateCount ? text + "[" + this.getKey(count).toString() + ", " + this.duplicateCount[count] + "]" : text + "[" + this.getKey(count).toString() + "]";
                }
                text = text + lineSep;
            } else {
                text = text + "  ";
                for (int count = 0; count < numKeys; ++count) {
                    text = text + this.getChild(count);
                    text = text + "[" + this.getKey(count).toString() + "]";
                }
                text = text + lineSep;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return text;
    }

    @Override
    protected final byte[] getBuffer() {
        return this.mainBuffer;
    }

    @Override
    protected Object convertBytesToChildObject(int childNumber) {
        if (childNumber >= this.getNumberOfKeys()) {
            return null;
        }
        int offset = this.getChildByteOffset(childNumber);
        return new ACUFilePointer(this.mainBuffer, offset);
    }

    @Override
    protected boolean convertChildObjectToBytes(Object childObject, int childNumber) {
        if (childObject == null) {
            return false;
        }
        int offset = this.getChildByteOffset(childNumber);
        return this.convertChildObjectToBytes(childObject, this.mainBuffer, offset);
    }

    @Override
    protected boolean convertChildObjectToBytes(Object childObject, byte[] bytes, int offset) {
        if (childObject == null) {
            return false;
        }
        try {
            ((ACUFilePointer)childObject).writeBytes(bytes, offset);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    @Override
    protected comparableByteArray convertBytesToKeyObject(byte[] bytes, int offset, int len) {
        byte[] keyBytes;
        if (bytes == null) {
            return null;
        }
        comparableByteArray keyObject = this.keyTemplate.copy();
        if (bytes != this.mainBuffer) {
            keyBytes = new byte[len];
            System.arraycopy(bytes, offset, keyBytes, 0, len);
        } else {
            keyBytes = this.getFullKeyFromBytes(bytes, offset);
            if (keyBytes == null) {
                return null;
            }
        }
        keyObject.fromByteArray(keyBytes);
        return keyObject;
    }

    private int getDifferPoint(byte[] lastKey, int lastKeyOffset, byte[] curKey, int curKeyOffset) {
        if (curKey == null || lastKey == null) {
            return -1;
        }
        int min = this.keyLength;
        int curLen = curKey.length - curKeyOffset;
        int lastLen = lastKey.length - lastKeyOffset;
        if (curLen < min) {
            min = curLen;
        }
        if (lastLen < min) {
            min = lastLen;
        }
        for (int i = 0; i < min; ++i) {
            if (curKey[curKeyOffset++] == lastKey[lastKeyOffset++]) continue;
            return i + 1;
        }
        return 0;
    }

    private boolean convertKeyObjectToBytes(byte[] keyBytes, byte[] bytes, int offset) {
        return this.convertKeyObjectToBytes(keyBytes, 0, this.keyLength, bytes, offset);
    }

    @Override
    protected boolean convertKeyObjectToBytes(byte[] keyBytes, int keyBytesOffset, int keyLength, byte[] bytes, int offset) {
        boolean isMaxKey;
        int nextKeyOffset;
        if (keyBytes == this.mainBuffer) {
            keyBytes = this.getFullKeyFromBytes(keyBytes, keyBytesOffset);
            keyBytesOffset = 0;
        }
        if (this.allowsDuplicates && offset == 16 || !this.allowsDuplicates && offset == 12) {
            nextKeyOffset = (bytes[offset - 3] & 0xFF) + (offset - 3) + 1 + 8;
            if (this.allowsDuplicates) {
                nextKeyOffset += 4;
            }
        } else {
            nextKeyOffset = (bytes[offset - 2] & 0xFF) + (offset - 2) + 1 + 8;
            if (this.allowsDuplicates) {
                nextKeyOffset += 4;
            }
        }
        if (this.allowsDuplicates && offset == 16 || !this.allowsDuplicates && offset == 12) {
            byte[] nextBytes = this.getFullKeyFromBytes(bytes, nextKeyOffset);
            System.arraycopy(keyBytes, keyBytesOffset, bytes, offset, keyLength);
            if (nextBytes != null) {
                return this.convertKeyObjectToBytes(nextBytes, bytes, nextKeyOffset);
            }
            return true;
        }
        boolean bl = isMaxKey = keyBytes[keyBytesOffset] == 127;
        if (isMaxKey) {
            return true;
        }
        int lastKeyOffset = offset - 8;
        if (this.allowsDuplicates) {
            lastKeyOffset -= 4;
        }
        byte[] lastKeyBytes = this.getFullKeyFromBytes(bytes, lastKeyOffset -= 8);
        int differ = this.getDifferPoint(lastKeyBytes, 0, keyBytes, keyBytesOffset) - 1;
        int nextOffset = (bytes[offset - 2] & 0xFF) + (offset - 2) + 1;
        int curDiffer = (bytes[offset - 1] & 0xFF) - 1;
        if (differ == curDiffer) {
            if (differ < 0) {
                return true;
            }
            byte[] nextBytes = this.getFullKeyFromBytes(bytes, nextKeyOffset);
            System.arraycopy(keyBytes, differ + keyBytesOffset, bytes, offset, keyLength - differ);
            if (nextBytes != null) {
                return this.convertKeyObjectToBytes(nextBytes, bytes, nextKeyOffset);
            }
            return true;
        }
        int endKVB = ACUFile.getShortFromBytes(bytes, 1) + 3;
        int delta1 = differ;
        delta1 = delta1 < 0 ? 0 : keyLength - delta1;
        int delta2 = curDiffer;
        delta2 = delta2 < 0 ? 0 : keyLength - delta2;
        int delta = delta1 - delta2;
        if (bytes == null || delta + endKVB >= bytes.length) {
            return false;
        }
        System.arraycopy(bytes, nextOffset, bytes, nextOffset + delta, endKVB - nextOffset);
        if (differ >= 0) {
            System.arraycopy(keyBytes, keyBytesOffset + differ, bytes, offset, keyLength - differ);
        }
        bytes[offset - 2] = (byte)((bytes[offset - 2] & 0xFF) + delta);
        bytes[offset - 1] = (byte)(differ + 1);
        ACUFile.setBytesFromShort(bytes, 1, endKVB - 3 + delta);
        byte[] nextBytes = this.getFullKeyFromBytes(bytes, nextKeyOffset + delta);
        if (nextBytes != null) {
            return this.convertKeyObjectToBytes(nextBytes, bytes, nextKeyOffset + delta);
        }
        return true;
    }

    @Override
    protected boolean convertKeyObjectToBytes(comparableByteArray keyObject, byte[] bytes, int offset) {
        if (keyObject == null) {
            return false;
        }
        byte[] keyBytes = keyObject.toByteArray();
        return this.convertKeyObjectToBytes(keyBytes, bytes, offset);
    }

    @Override
    protected boolean insertKeyIntoBufferAndIncreaseNumberOfKeys(int keyNumberPosition, byte[] keyBytes, int keyOffset, int keyLen, byte[] childBytes, int childOffset, long duplicateCount) {
        boolean flag = this.inner_insertKeyIntoBufferAndIncreaseNumberOfKeys(keyNumberPosition, keyBytes, keyOffset, keyLen, childBytes, childOffset, duplicateCount);
        return flag;
    }

    private boolean inner_insertKeyIntoBufferAndIncreaseNumberOfKeys(int keyNumberPosition, byte[] keyBytes, int keyOffset, int keyLen, byte[] childBytes, int childOffset, long duplicateCount) {
        int deltaOffset;
        int delta;
        boolean isMaxKey;
        int nextKeyOffset;
        int sourceOffset;
        int endKVB = ACUFile.getShortFromBytes(this.mainBuffer, 1) + 3;
        if (keyNumberPosition == 0) {
            sourceOffset = 3;
            nextKeyOffset = sourceOffset + 9;
        } else {
            sourceOffset = this.getOffsetForKeyInfo(keyNumberPosition);
            nextKeyOffset = sourceOffset + 8;
        }
        if (this.allowsDuplicates) {
            nextKeyOffset += 4;
        }
        boolean bl = isMaxKey = keyBytes[keyOffset] == 127;
        if (isMaxKey && keyNumberPosition > 0) {
            this.mainBuffer[nextKeyOffset] = 127;
            this.mainBuffer[nextKeyOffset - 2] = 2;
            this.mainBuffer[nextKeyOffset - 1] = 0;
            int childLen = this.getChildLength();
            System.arraycopy(childBytes, childOffset, this.mainBuffer, sourceOffset, childLen);
            this.mainBuffer[sourceOffset + childLen] = 0;
            this.mainBuffer[sourceOffset + childLen + 1] = 0;
            this.duplicateCount[keyNumberPosition] = duplicateCount;
            int count = 8;
            if (this.allowsDuplicates) {
                count += 4;
                ACUFile.setBytesFromInt(this.mainBuffer, sourceOffset + 6, duplicateCount);
            }
            ACUFile.setBytesFromShort(this.mainBuffer, 1, endKVB - 3 + count + 1);
            ++this.numberOfKeys;
            return true;
        }
        byte[] nextKeyBytes = null;
        if (keyNumberPosition < this.numberOfKeys) {
            nextKeyBytes = this.getFullKeyFromBytes(this.mainBuffer, nextKeyOffset);
        }
        if (keyNumberPosition == 0) {
            if (nextKeyBytes != null) {
                if (endKVB + this.keyLength * 2 >= this.mainBuffer.length) {
                    return false;
                }
                byte[] savedBytes = new byte[endKVB];
                System.arraycopy(this.mainBuffer, 0, savedBytes, 0, endKVB);
                if (!this.insertKeyIntoBufferAndIncreaseNumberOfKeys(1, nextKeyBytes, 0, this.keyLength, this.mainBuffer, sourceOffset, this.duplicateCount[0])) {
                    return false;
                }
                System.arraycopy(keyBytes, keyOffset, this.mainBuffer, nextKeyOffset, keyLen);
                nextKeyOffset += this.keyLength + 8;
                if (this.allowsDuplicates) {
                    nextKeyOffset += 4;
                }
                if (!this.convertKeyObjectToBytes(nextKeyBytes, this.mainBuffer, nextKeyOffset)) {
                    System.arraycopy(savedBytes, 0, this.mainBuffer, 0, endKVB);
                    --this.numberOfKeys;
                    return false;
                }
            } else {
                System.arraycopy(keyBytes, keyOffset, this.mainBuffer, nextKeyOffset, keyLen);
                this.mainBuffer[nextKeyOffset - 3] = (byte)(this.keyLength + 2);
                ACUFile.setBytesFromShort(this.mainBuffer, 1, nextKeyOffset + this.keyLength - 3);
                ++this.numberOfKeys;
            }
            int childLen = this.getChildLength();
            System.arraycopy(childBytes, childOffset, this.mainBuffer, sourceOffset, childLen);
            this.mainBuffer[sourceOffset + childLen] = 0;
            this.mainBuffer[sourceOffset + childLen + 1] = 0;
            this.duplicateCount[keyNumberPosition] = duplicateCount;
            if (this.allowsDuplicates) {
                ACUFile.setBytesFromInt(this.mainBuffer, sourceOffset + 6, duplicateCount);
            }
            return true;
        }
        int lastKeyOffset = this.getKeyByteOffset(keyNumberPosition - 1);
        byte[] lastKeyBytes = this.getFullKeyFromBytes(this.mainBuffer, lastKeyOffset);
        int differ = this.getDifferPoint(lastKeyBytes, 0, keyBytes, keyOffset) - 1;
        int displacement = differ < 0 ? 8 : this.keyLength - differ + 8;
        if (this.allowsDuplicates) {
            displacement += 4;
        }
        int destOffset = sourceOffset + displacement;
        int totalBytesToMove = this.mainBuffer.length - sourceOffset - displacement;
        if (endKVB + displacement >= this.mainBuffer.length) {
            return false;
        }
        if (keyNumberPosition < this.numberOfKeys) {
            System.arraycopy(this.mainBuffer, sourceOffset, this.mainBuffer, destOffset, totalBytesToMove);
        }
        ++this.numberOfKeys;
        if (differ < 0) {
            delta = 0;
            deltaOffset = 0;
        } else {
            delta = this.keyLength - differ;
            deltaOffset = differ;
        }
        if (delta > 0) {
            System.arraycopy(keyBytes, deltaOffset, this.mainBuffer, nextKeyOffset, delta);
        }
        int childLen = this.getChildLength();
        System.arraycopy(childBytes, childOffset, this.mainBuffer, sourceOffset, childLen);
        this.mainBuffer[sourceOffset + childLen] = 0;
        this.mainBuffer[sourceOffset + childLen + 1] = 0;
        if (this.numberOfKeys < this.maxKeys) {
            System.arraycopy(this.duplicateCount, keyNumberPosition, this.duplicateCount, keyNumberPosition + 1, this.numberOfKeys - keyNumberPosition);
        }
        this.duplicateCount[keyNumberPosition] = duplicateCount;
        if (this.allowsDuplicates) {
            ACUFile.setBytesFromInt(this.mainBuffer, sourceOffset + 6, duplicateCount);
        }
        this.mainBuffer[nextKeyOffset - 2] = (byte)(delta + 1);
        this.mainBuffer[nextKeyOffset - 1] = (byte)(differ + 1);
        ACUFile.setBytesFromShort(this.mainBuffer, 1, endKVB - 3 + displacement);
        if (nextKeyBytes != null) {
            return this.convertKeyObjectToBytes(nextKeyBytes, this.mainBuffer, nextKeyOffset + displacement);
        }
        return true;
    }

    @Override
    protected boolean deleteKeyFromBufferAndDecreaseNumberOfKeys(int keyNumberPosition) {
        boolean flag = false;
        try {
            flag = this.inner_deleteKeyFromBufferAndDecreaseNumberOfKeys(keyNumberPosition);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return flag;
    }

    protected boolean inner_deleteKeyFromBufferAndDecreaseNumberOfKeys(int keyNumberPosition) {
        int sourceKeyOffset;
        int sourceOffset;
        int deletedKeyOffset;
        int destOffset;
        int numKeys = this.getNumberOfKeys();
        if (keyNumberPosition < 0 || keyNumberPosition >= numKeys) {
            return false;
        }
        if (keyNumberPosition == 0) {
            destOffset = 3;
            deletedKeyOffset = destOffset + 9;
            if (this.allowsDuplicates) {
                deletedKeyOffset += 4;
            }
            sourceOffset = (this.mainBuffer[deletedKeyOffset - 3] & 0xFF) + (deletedKeyOffset - 3) + 1;
            sourceKeyOffset = sourceOffset + 8;
            if (this.allowsDuplicates) {
                sourceKeyOffset += 4;
            }
        } else {
            destOffset = this.getOffsetForKeyInfo(keyNumberPosition);
            deletedKeyOffset = destOffset + 8;
            if (this.allowsDuplicates) {
                deletedKeyOffset += 4;
            }
            sourceOffset = (this.mainBuffer[deletedKeyOffset - 2] & 0xFF) + (deletedKeyOffset - 2) + 1;
            sourceKeyOffset = sourceOffset + 8;
            if (this.allowsDuplicates) {
                sourceKeyOffset += 4;
            }
        }
        int endKVB = ACUFile.getShortFromBytes(this.mainBuffer, 1) + 3;
        byte[] sourceKeyBytes = this.getFullKeyFromBytes(this.mainBuffer, sourceKeyOffset);
        if (sourceKeyBytes == null) {
            ACUFile.setBytesFromShort(this.mainBuffer, 1, endKVB - (sourceOffset - destOffset) - 3);
            --this.numberOfKeys;
            return true;
        }
        int lenToCopy = this.getChildLength() + 2;
        System.arraycopy(this.mainBuffer, sourceOffset, this.mainBuffer, destOffset, lenToCopy);
        if (this.allowsDuplicates) {
            System.arraycopy(this.mainBuffer, sourceOffset + lenToCopy, this.mainBuffer, destOffset + lenToCopy, 4);
        }
        if (sourceKeyBytes != null) {
            if (keyNumberPosition > 0 && sourceKeyBytes[0] == 127) {
                this.mainBuffer[deletedKeyOffset] = 127;
                this.mainBuffer[deletedKeyOffset - 1] = 0;
                this.mainBuffer[deletedKeyOffset - 2] = 2;
                if (keyNumberPosition + 1 < this.maxKeys) {
                    System.arraycopy(this.duplicateCount, keyNumberPosition + 1, this.duplicateCount, keyNumberPosition, this.numberOfKeys - keyNumberPosition - 1);
                }
                ACUFile.setBytesFromShort(this.mainBuffer, 1, deletedKeyOffset + 1 - 3);
                --this.numberOfKeys;
                return true;
            }
            if (!this.convertKeyObjectToBytes(sourceKeyBytes, this.mainBuffer, deletedKeyOffset)) {
                return false;
            }
        }
        endKVB = ACUFile.getShortFromBytes(this.mainBuffer, 1) + 3;
        destOffset = this.getOffsetForKeyInfo(keyNumberPosition + 1);
        deletedKeyOffset = destOffset + 8;
        if (this.allowsDuplicates) {
            deletedKeyOffset += 4;
        }
        sourceOffset = (this.mainBuffer[deletedKeyOffset - 2] & 0xFF) + (deletedKeyOffset - 2) + 1;
        try {
            int totalBytesToMove = this.mainBuffer.length - sourceOffset;
            System.arraycopy(this.mainBuffer, sourceOffset, this.mainBuffer, destOffset, totalBytesToMove);
            if (keyNumberPosition + 1 < this.maxKeys) {
                System.arraycopy(this.duplicateCount, keyNumberPosition + 1, this.duplicateCount, keyNumberPosition, this.numberOfKeys - keyNumberPosition - 1);
            }
            --this.numberOfKeys;
            ACUFile.setBytesFromShort(this.mainBuffer, 1, endKVB - (sourceOffset - destOffset) - 3);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    @Override
    protected boolean moveFromNode(bTreeNode sourceNode, int n) {
        try {
            boolean flag = this.inner_moveFromNode(sourceNode, n);
            return flag;
        }
        catch (Exception e) {
            return false;
        }
    }

    private boolean inner_moveFromNode(bTreeNode sourceNode, int n) {
        if (n == 0) {
            return true;
        }
        boolean returnValue = true;
        if (sourceNode.getNumberOfKeys() < n) {
            returnValue = false;
            n = sourceNode.getNumberOfKeys();
        }
        if (this.numberOfKeys + n > this.getMaxKeys()) {
            returnValue = false;
            n = this.getMaxKeys() - this.numberOfKeys;
        }
        try {
            int sourceOffset;
            int endKVB = ACUFile.getShortFromBytes(this.mainBuffer, 1) + 3;
            ACUBTreeNode source = (ACUBTreeNode)sourceNode;
            int keyNumberPosition = this.getNumberOfKeys();
            this.numberOfKeys += n;
            int ourOffset = this.getOffsetForKeyInfo(keyNumberPosition);
            byte[] sourceBuffer = source.getBuffer();
            int nextOffset = sourceOffset = source.getOffsetForKeyInfo(0);
            int delta = 6;
            if (this.allowsDuplicates) {
                delta += 4;
            }
            for (int i = 0; i < n; ++i) {
                nextOffset += delta;
                nextOffset += (sourceBuffer[nextOffset] & 0xFF) + 1;
            }
            int totalBytesToMove = nextOffset - sourceOffset;
            System.arraycopy(sourceBuffer, sourceOffset, this.mainBuffer, ourOffset, totalBytesToMove);
            System.arraycopy(source.duplicateCount, 0, this.duplicateCount, keyNumberPosition, n);
            ACUFile.setBytesFromShort(this.mainBuffer, 1, endKVB - 3 + totalBytesToMove);
            if (keyNumberPosition > 0) {
                byte[] keyBytes;
                int lastOffset = this.getOffsetForKeyInfo(keyNumberPosition - 1);
                int lastKeyOffset = lastOffset + 8;
                if (this.allowsDuplicates) {
                    lastKeyOffset += 4;
                }
                if ((keyBytes = this.getFullKeyFromBytes(this.mainBuffer, lastKeyOffset)) != null) {
                    return this.convertKeyObjectToBytes(keyBytes, this.mainBuffer, lastKeyOffset);
                }
            }
            endKVB = ACUFile.getShortFromBytes(sourceBuffer, 1) + 3;
            int destOffset = sourceOffset;
            sourceOffset = nextOffset;
            int sourceKeyOffset = sourceOffset + 8;
            if (this.allowsDuplicates) {
                sourceKeyOffset += 4;
            }
            byte[] sourceKeyBytes = null;
            if (source.getNumberOfKeys() > n) {
                sourceKeyBytes = source.getFullKeyFromBytes(sourceBuffer, sourceKeyOffset);
                if (sourceKeyBytes != null) {
                    // empty if block
                }
                System.arraycopy(sourceBuffer, sourceOffset, sourceBuffer, destOffset, 6);
                int nextSourceOffset = (sourceBuffer[sourceOffset + delta] & 0xFF) + (sourceOffset + delta) + 1;
                int nextDestOffset = (sourceBuffer[destOffset + delta] & 0xFF) + (destOffset + delta) + 1;
                int amount = sourceBuffer.length - nextSourceOffset;
                if (amount > 0) {
                    System.arraycopy(sourceBuffer, nextSourceOffset, sourceBuffer, nextDestOffset, amount);
                }
                int first = 12;
                if (this.allowsDuplicates) {
                    first = 16;
                }
                System.arraycopy(sourceKeyBytes, 0, sourceBuffer, first, this.keyLength);
                ACUFile.setBytesFromShort(sourceBuffer, 1, endKVB - nextSourceOffset + this.keyLength + first - 3);
            } else {
                ACUFile.setBytesFromShort(sourceBuffer, 1, endKVB - (sourceOffset - 3) - 3);
            }
            source.numberOfKeys -= n;
            if (source.numberOfKeys > 0) {
                System.arraycopy(source.duplicateCount, n, source.duplicateCount, 0, source.numberOfKeys);
            }
            return returnValue;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    @Override
    protected int compareKeyBytes(byte[] bytes, int offset, int len, byte[] fullKeyBytes, int fullKeyOffset, int fullKeyLength, boolean truncate) {
        if (bytes != this.mainBuffer) {
            return ACUBTreeNode.compareBytes(bytes, offset, len, fullKeyBytes, fullKeyOffset, fullKeyLength, truncate);
        }
        byte[] fullBytes = this.getFullKeyFromBytes(bytes, offset);
        int cresult = ACUBTreeNode.compareBytes(fullBytes, 0, this.keyLength, fullKeyBytes, fullKeyOffset, fullKeyLength, truncate);
        return cresult;
    }

    @Override
    protected boolean hasVariableKeyLengths() {
        return true;
    }

    @Override
    public boolean lastKeyIsMaxKey() {
        if (this.getNumberOfKeys() == 0) {
            return false;
        }
        this.getMaxKey();
        return this.compareKey(this.getNumberOfKeys() - 1, this.maxKeyBytes, 0, this.maxKeyLength, false) == 0;
    }

    @Override
    public comparableByteArray getMaxKey() {
        if (this.MAX_KEY != null) {
            return this.MAX_KEY;
        }
        this.MAX_KEY = this.keyTemplate.copy();
        if (this.MAX_KEY instanceof Numeric) {
            ((Variable)this.MAX_KEY).moveAll('\u007f');
            int len = this.MAX_KEY.toByteArray().length;
            this.MAX_KEY = Variable.newVariableOfSize(len);
            this.maxKeyBytes = new byte[len];
            for (int i = 0; i < len; ++i) {
                this.maxKeyBytes[i] = 127;
            }
            this.maxKeyLength = len;
            this.MAX_KEY.fromByteArray(this.maxKeyBytes);
        } else if (this.MAX_KEY instanceof VariableList) {
            int len = 0;
            for (Variable oneVar : ((VariableList)this.MAX_KEY).getList()) {
                oneVar.moveAll('\u007f');
                len += oneVar.toByteArray().length;
            }
            this.MAX_KEY = Variable.newVariableOfSize(len);
            this.maxKeyBytes = new byte[len];
            for (int i = 0; i < len; ++i) {
                this.maxKeyBytes[i] = 127;
            }
            this.maxKeyLength = len;
            this.MAX_KEY.fromByteArray(this.maxKeyBytes);
        } else if (this.MAX_KEY instanceof Variable) {
            ((Variable)this.MAX_KEY).moveAll('\u007f');
            int len = this.MAX_KEY.toByteArray().length;
            this.maxKeyBytes = new byte[len];
            for (int i = 0; i < len; ++i) {
                this.maxKeyBytes[i] = 127;
            }
            this.maxKeyLength = len;
        }
        return this.MAX_KEY;
    }

    @Override
    public boolean isBelowMinimum() {
        int numKeys = this.getNumberOfKeys();
        return this.getCanHoldKeys(numKeys + 1);
    }

    @Override
    public boolean isBelowOrAtMinimum() {
        int numKeys = this.getNumberOfKeys();
        return this.getCanHoldKeys(numKeys) || this.getCanHoldKeys(numKeys + 1);
    }

    @Override
    public boolean isAtMinimum() {
        int numKeys = this.getNumberOfKeys();
        return this.getCanHoldKeys(numKeys) && !this.getCanHoldKeys(numKeys + 1);
    }

    @Override
    public boolean getCanHoldKeys(int numKeys) {
        int nodeSize = this.file.getIndexNodeRecordSize();
        int spaceUsed = ACUFile.getShortFromBytes(this.mainBuffer, 1);
        int endKVB = spaceUsed + 3;
        int spaceLeft = nodeSize - endKVB;
        int curNumKeys = this.getNumberOfKeys();
        if (curNumKeys > 0) {
            int spacePerKey = spaceUsed / curNumKeys;
            return spacePerKey * numKeys < spaceLeft;
        }
        return numKeys <= this.getMaxNonCompressedKeys();
    }

    private int getMaxNonCompressedKeys() {
        int maxKeySize = this.keyLength;
        int nodeSize = this.file.getIndexNodeRecordSize();
        int keyOverhead = maxKeySize + 8;
        if (this.allowsDuplicates) {
            keyOverhead += 4;
        }
        int nodeOverhead = 9 + (3 + maxKeySize);
        if (this.allowsDuplicates) {
            nodeOverhead += 4;
        }
        return (nodeSize - nodeOverhead) / keyOverhead + 1;
    }

    @Override
    public void setTotalHeightOfTree(int h) {
        this.file.setHeightOfTree(this.bTreeIndex, h);
    }

    @Override
    public int getTotalHeightOfTree() {
        return (int)this.file.getHeightOfTree(this.bTreeIndex);
    }
}

